/**
 ******************************************************************************
 *
 * @file        MG32_SYS.h
 *
 * @brief       MG32 SYS Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_SYS_H
#define _MG32_SYS_H
#define _MG32_SYS_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_SYS_H_VER)
    #error "_MG32_SYS_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      SYS_Struct
 *              SYS  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x00]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] System interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  SYS interrupt enable register */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t MID           :32;    //[31..0] Chip manufacture identification code.
        }MBIT;
    }MID;                               /*!< MID        ~ Offset[0x0C]  SYS chip manufacture identification code */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :8;     //[7..0] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  GPR           :8;     //[23..16] General purpose data register bits.
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  SYS System control register 0 */

    __I uint32_t  RESERVED2[2];         /*!< RESERVED2  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RAM_SIZE      :2;     //[1..0] 
            __I  uint8_t                :2;     //[3..2] 
            __I  uint8_t  USBRAM_EN     :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t  DMARAM_EN     :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }MID2;                              /*!< MID2       ~ Offset[0x1C]  SYS chip manufacture identification code-2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t BKP0          :32;    //[31..0] This register is used for application firmware without any hardware control
        }MBIT;
    }BKP0;                              /*!< BKP0       ~ Offset[0x20]  SYS Backup register 0 */

    __I uint32_t  RESERVED3[2];         /*!< RESERVED3  ~ Offset[0x24]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t BKP3          :32;    //[31..0] 
        }MBIT;
    }BKP3;                              /*!< BKP3       ~ Offset[0x2C]  SYS backup register3 */

} SYS_Struct;

/**
 ******************************************************************************
 *
 * @name        SYS  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define SYS_Base                        ((uint32_t)0x4C030000)              /*!< System and Chip Control */
#define SYS                             ((SYS_Struct*) SYS_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        SYS  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        SYS_INT  [register's definitions]
 *              Offset[0x04]  SYS interrupt enable register (0x4C030004)
 ******************************************************************************
 */
///@{
#define SYS_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_INT */
#define SYS_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SYS_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SYS_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SYS_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SYS_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SYS_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SYS_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SYS_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SYS_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_MID  [register's definitions]
 *              Offset[0x0C]  SYS chip manufacture identification code (0x4C03000C)
 ******************************************************************************
 */
///@{
#define SYS_MID_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_MID */
#define SYS_MID_MID_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SYS_MID_MID_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define SYS_MID_MID_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define SYS_MID_MID_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_CR0  [register's definitions]
 *              Offset[0x10]  SYS System control register 0 (0x4C030010)
 ******************************************************************************
 */
///@{
#define SYS_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_CR0 */
#define SYS_CR0_GPR_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define SYS_CR0_GPR_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define SYS_CR0_GPR_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define SYS_CR0_GPR_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define SYS_CR0_GPR_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define SYS_CR0_GPR_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_MID2  [register's definitions]
 *              Offset[0x1C]  SYS chip manufacture identification code-2 (0x4C03001C)
 ******************************************************************************
 */
///@{
#define SYS_MID2_default                            ((uint32_t)0x00000053)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_MID2 */
#define SYS_MID2_DMARAM_EN_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define SYS_MID2_DMARAM_EN_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define SYS_MID2_DMARAM_EN_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SYS_MID2_DMARAM_EN_disable_w                ((uint32_t)0x00000000)
#define SYS_MID2_DMARAM_EN_disable_h0               ((uint16_t)0x0000)
#define SYS_MID2_DMARAM_EN_disable_b0               ((uint8_t )0x00)
#define SYS_MID2_DMARAM_EN_enable_w                 ((uint32_t)0x00000040)
#define SYS_MID2_DMARAM_EN_enable_h0                ((uint16_t)0x0040)
#define SYS_MID2_DMARAM_EN_enable_b0                ((uint8_t )0x40)

#define SYS_MID2_USBRAM_EN_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define SYS_MID2_USBRAM_EN_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define SYS_MID2_USBRAM_EN_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define SYS_MID2_USBRAM_EN_disable_w                ((uint32_t)0x00000000)
#define SYS_MID2_USBRAM_EN_disable_h0               ((uint16_t)0x0000)
#define SYS_MID2_USBRAM_EN_disable_b0               ((uint8_t )0x00)
#define SYS_MID2_USBRAM_EN_enable_w                 ((uint32_t)0x00000010)
#define SYS_MID2_USBRAM_EN_enable_h0                ((uint16_t)0x0010)
#define SYS_MID2_USBRAM_EN_enable_b0                ((uint8_t )0x10)

#define SYS_MID2_RAM_SIZE_mask_w                    ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define SYS_MID2_RAM_SIZE_mask_h0                   ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define SYS_MID2_RAM_SIZE_mask_b0                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define SYS_MID2_RAM_SIZE_4kb_w                     ((uint32_t)0x00000000)
#define SYS_MID2_RAM_SIZE_4kb_h0                    ((uint16_t)0x0000)
#define SYS_MID2_RAM_SIZE_4kb_b0                    ((uint8_t )0x00)
#define SYS_MID2_RAM_SIZE_8kb_w                     ((uint32_t)0x00000001)
#define SYS_MID2_RAM_SIZE_8kb_h0                    ((uint16_t)0x0001)
#define SYS_MID2_RAM_SIZE_8kb_b0                    ((uint8_t )0x01)
#define SYS_MID2_RAM_SIZE_12kb_w                    ((uint32_t)0x00000002)
#define SYS_MID2_RAM_SIZE_12kb_h0                   ((uint16_t)0x0002)
#define SYS_MID2_RAM_SIZE_12kb_b0                   ((uint8_t )0x02)
#define SYS_MID2_RAM_SIZE_14kb_w                    ((uint32_t)0x00000003)
#define SYS_MID2_RAM_SIZE_14kb_h0                   ((uint16_t)0x0003)
#define SYS_MID2_RAM_SIZE_14kb_b0                   ((uint8_t )0x03)

///@}
/**
 ******************************************************************************
 * @name        SYS_BKP0  [register's definitions]
 *              Offset[0x20]  SYS Backup register 0 (0x4C030020)
 ******************************************************************************
 */
///@{
#define SYS_BKP0_default                            ((uint32_t)0xFFFFFFFF)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_BKP0 */
#define SYS_BKP0_BKP0_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SYS_BKP0_BKP0_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define SYS_BKP0_BKP0_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define SYS_BKP0_BKP0_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_BKP3  [register's definitions]
 *              Offset[0x2C]  SYS backup register3 (0x4C03002C)
 ******************************************************************************
 */
///@{
#define SYS_BKP3_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_BKP3 */
#define SYS_BKP3_BKP3_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SYS_BKP3_BKP3_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define SYS_BKP3_BKP3_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define SYS_BKP3_BKP3_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_SYS_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_SYS.h                           */
/*----------------------------------------------------------------------------*/
