/**
 ******************************************************************************
 *
 * @file        MG32_RTC_Init.h
 *
 * @brief       This file is used to configure RTC setting.
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2023/05/10 09:09 (H File Generated Date)
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#include "MG32.h"
#include "MG32__Common_DRV.h"
#include "MG32_RTC.h"
#include "MG32_PW.h"
#include "MG32_CSC.h"
#include "MG32_SYS.h"


#if defined(IRQHandler_Middleware_Level_)
    #include "MG32_RTC_MID.h"
#endif

#ifndef _MG32_RTC_INIT_H
#define _MG32_RTC_INIT_H


#define MG32_Protect 0xA217
#define MG32_UnProtect 0x217A


//*** <<< Use Configuration Wizard in Context Menu >>> ***
//<e0.0> RTC Enable
//  <i> RTC module configure.(ENABLE/DISABLE)
#define CONF_RTC_EN    0x00000000

    //<o0> RTC_Count_Value 0~0xFFFFFFFE(0~4294967294) <0-0xFFFFFFFE>
    #define CONF_RTC_RLR    0x00000000

    //<h> RTC Input Clock Tree Configuration
        //<o0.2..3> RTC_CK_SEL <0=> CK_LS <1=> CK_UT <2=> CK_APB <3=> TM01_TRGO
        //  <i> RTC input clock CK_RTC source selects.
        #define CONF_RTC_CK_SEL    0x00000000
        //<o0.4..5> RTC_CK_DIV <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=> DIV8
        //  <i> RTC internal clock CK_RTC_INT input divider.
        #define CONF_RTC_CK_DIV    0x00000000
        //<o0.7> RTC_CK_PDIV <0=> DIV4096 <1=> DIV1
        //  <i> RTC internal clock CK_RTC_INT input pre-divider.
        #define CONF_RTC_CK_PDIV   0x00000000
    //</h>
    
    //<h> RTC Interrupt Configuration
        //  <i> Used with IRQ handler, or enable RTC NVIC by self.
        //<e0.0> RTC_IEA
        //  <i> RTC all interrupts enable.
        #define CONF_RTC_IEA       0x00000000
        //<q0.1> RTC_ALM_IE
        //  <i> RTC alarm matched interrupt enable.
        #define CONF_RTC_ALM_IE    0x00000000
        //<q0.2> RTC_PC_IE
        //  <i> RTC periodic interrupt enable.
        #define CONF_RTC_PC_IE     0x00000000
        //<q0.3> RTC_TS_IE
        //  <i> RTC time stamp interrupt enable.
        #define CONF_RTC_TS_IE     0x00000000
        //<q0.4> RTC_TIE
        //  <i> RTC time overflow/underflow interrupt enable.
        #define CONF_RTC_TIE       0x00000000
        //<q0.5> RTC_RCR_IE
        //  <i> RTC_RCR register reload, software capture or RTC_ALM register value update allowed interrupt enable.
        #define CONF_RTC_RCR_IE    0x00000000
        //</e>
    //</h>
    
    //<h> RTC Wake Up Configuration
        //<q0.16> RTC_ALM_WPEN
        //  <i> RTC detect RTC_ALMF flag wakeup from STOP mode enable bit.
        #define CONF_RTC_ALARM_WPEN    0x00000000
        //<q0.17> RTC_PC_WPEN
        //  <i> RTC detect RTC_PCF flag wakeup from STOP mode enable bit.
        #define CONF_RTC_PC_WPEN       0x00000000
        //<q0.19> RTC_TF_WPEN
        //  <i> RTC detect RTC_TOF flag wakeup from STOP mode enable bit.
        #define CONF_RTC_TF_WPEN       0x00000000
    //</h>
    
    //<h> RTC Output Configuration
        //<e0.15> RTC Output State Control
        //  <i> RTC_OUT output signal initial state control.
        //  <i> When locked, disables the register bit write access.
        //  <i> Hardware auto clear after register write access.
        #define CONF_RTC_OUT_LCK   0x00000000
            //<o0.14> RTC Output Initial State Select <0=> Level Low <1=> Level High
            #define CONF_RTC_OUT_STA   0x00000000
        //</e>

        //<o0.8..9> RTC_OUT_SEL <0=> ALM : Alarm compare output event <1=> PC : CK_RTC_INT periodic clock signal <2=> TS : Time stamp trigger event <3=> TO : Timer overflow signal toggle output
        //  <i> RTC output signal select. When selects 'PC', the RTC_CK_DIV and RTC_CK_PDIV cannot set both divided by 1.
        #define CONF_RTC_OUT_SEL 0x00000000
    //</h>

    //<o0.12..13> RTC Time Stamp Trigger Edge Select <0=> Disable <1=> Rising Edge <2=> Falling Edge <3=> Daul-Edge
    //  <i> RTC time stamp trigger edge select.
    #define CONF_RTC_TS_TRGS  0x00000000
    
    //<e0.1> RTC Alarm Enable
    #define CONF_RTC_ALM_EN 0x00000000
        //<o0> RTC alarm compared value. 0~0xFFFFFFFE(0~4294967294) <0-0xFFFFFFFE>
        #define CONF_RTC_ALM 0x00000000
    //</e>
//</e>
//*** <<< end of configuration section >>>    ***

/**
 * @name    RTC_Clock Selection_Definition
 *          RTC Clock Selection Definition
 */
///@{
#define CONF_RTC_CK_SEL_mask            0x0000000C
#define CONF_RTC_CK_SEL_ck_ls           0x00000000
#define CONF_RTC_CK_SEL_ck_ut           0x00000004
#define CONF_RTC_CK_SEL_ck_apb          0x00000008
#define CONF_RTC_CK_SEL_ck_tm01_trgo    0x0000000C
///@}

/**
 * @name    RTC_Divider_Configuration_Definition
 *          RTC Divider Configuration Definition
 */
///@{
#define CONF_RTC_CK_DIV_mask            0x00000003
#define CONF_RTC_CK_DIV_div1            0x00000000
#define CONF_RTC_CK_DIV_div2            0x00000010
#define CONF_RTC_CK_DIV_div4            0x00000020
#define CONF_RTC_CK_DIV_div8            0x00000030
///@}

/**
 * @name    RTC_Prescaler_Divider_Configuration_Definition
 *          RTC Prescaler Divider Configuration Definition
 */
///@{
#define CONF_RTC_CK_PDIV_mask           0x00000008
#define CONF_RTC_CK_PDIV_div4096        0x00000000
#define CONF_RTC_CK_PDIV_div1           0x00000008
///@}

/**
 * @name    RTC_Control_Register_Configuration_define.
 *          RTC Control Register Configuration define.
 */
///@{
#define CONF_RTC_CR0    (CONF_RTC_WPEN|     \
                        CONF_RTC_OUT|       \
                        CONF_RTC_TS_TRGS|   \
                        CONF_RTC_ALM_EN)
///@}

/**
 * @name    RTC_Control_Register_Configuration_define.
 *          RTC Control Register Configuration define.
 */
///@{
#define CONF_RTC_CLK    {CONF_RTC_CK_SEL|    \
                         CONF_RTC_CK_DIV|    \
                         CONF_RTC_CK_PDIV)

///@}

/**
 * @name    RTC_Interrupt_Configuration_Define
 *          RTC Interrupt Configuration Define
 */
///@{
#define CONF_RTC_INT    (CONF_RTC_IEA|      \
                         CONF_RTC_ALM_IE|   \
                         CONF_RTC_PC_IE|    \
                         CONF_RTC_TS_IE|    \
                         CONF_RTC_TIE|      \
                         CONF_RTC_RCR_IE)
///@}
    
/**
 * @name    RTC_Wake_Up_Even_Configuration_Define
 *          RTC Wake Up Even Configuration Define
 */
///@{
#define CONF_RTC_WPEN   (CONF_RTC_ALARM_WPEN|   \
                         CONF_RTC_PC_WPEN|      \
                         CONF_RTC_TF_WPEN)
///@}
    
/**
 * @name    RTC_Wake_Up_Even_Configuration_Define
 *          RTC Wake Up Even Configuration Define
 */
///@{
#define CONF_RTC_OUT    (CONF_RTC_OUT_LCK|  \
                         CONF_RTC_OUT_STA|  \
                         CONF_RTC_OUT_SEL)
    
///@}
    
/**
 * @name    Function announce
 *   
 */
///@{
void RTC_Init(void);
///@}

#endif      // _MG32_RTC_INIT_H

