

/**
 ******************************************************************************
 *
 * @file        BSP_Init.h
 * @brief       This is BSP initial H file.
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2021/05/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _BSP_INIT_H

#define _BSP_INIT_H


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_EXIC_DRV.h"
#include "__BSP_Wizard.h"

/* Wizard menu ---------------------------------------------------------------*/
/* define --------------------------------------------------------------------*/

//TH223x LED
#define TH223x_LED_ON            0            /*!< TH223x LED is low active.*/
#define TH223x_LED_OFF           1            
                                 
#define TH223x_LEDR_PIN          PE13
#define TH223x_LEDY_PIN          PE14
#define TH223x_LEDG_PIN          PE15
                                 
#define TH223x_LED_RED_OFF()     TH223x_LEDR_PIN = TH223x_LED_OFF
#define TH223x_LED_YELLOW_OFF()  TH223x_LEDY_PIN = TH223x_LED_OFF
#define TH223x_LED_GREEN_OFF()   TH223x_LEDG_PIN = TH223x_LED_OFF
                                 
#define TH223x_LED_RED_ON()      TH223x_LEDR_PIN = TH223x_LED_ON
#define TH223x_LED_YELLOW_ON()   TH223x_LEDY_PIN = TH223x_LED_ON
#define TH223x_LED_GREEN_ON()    TH223x_LEDG_PIN = TH223x_LED_ON
                                 
//TH222x Step Motor              
#define STEPMOTOR_STOP           0
#define STEPMOTOR_CLOCKWISE      1
#define STEPMOTOR_ANTICLOCKWISE  2
                                 
//TH222x Buzzer                  
#define BSP_BUZZER_TIME          50
                                 

/* typedef -----------------------------------------------------------*/

/*! @enum   BSP_StatusTypeDef
    @brief  
*/
typedef enum{
    TH222x_SUCCESS     = 0x00,    /*!< Success    */
    TH222x_FAILURE     = 0x01,    /*!< Failure    */
    TH222x_OK          = 0x00,    /*!< OK         */
    TH222x_ERROR       = 0x01,    /*!< Error      */
    TH222x_BUSY        = 0x02,    /*!< Busy       */
    TH222x_TIMEOUT     = 0x03,    /*!< Timout     */
    TH222x_IDLE        = 0x10,    /*!< Idle       */
    TH222x_READY       = 0xED,    /*!< Ready      */
}BSP_StatusTypeDef;


/*! @struct TH222xCTR_TypeDef
    @brief  
*/ 
typedef struct
{
    //=================================================
    //TH223A Button Control Relationship Parameter.
    uint32_t  __IO      SysTickCount;               // Increase SysTickCount in TH222x_main.c.
    
    uint8_t             UpdateFlag;
    uint8_t             DramaAct;                   // Drama Active No (Only accept range is 0~9):
                                                    // 0: RGB, ARGB, Step Motor.
                                                    // 2: Variable Resistor, Rotary encoder
                                                    // 4: RC servo motor
                                                    // 6: 4x4 Keyboard, 4x7-SEG display
                                                    // 9: BLE (No support)
    
    uint8_t             SW3_UpdateFlag;             // SysTick IRQ to config SW3_UpdateFlag to 1. 0: No update event.  1: Has update event.
    uint8_t             SW3_TRGlag;                 // The same as SW3_UpdateFlag.
    uint8_t             SW3_DramaTime;              // SW3_DramaTime accept rang is 0~7. (When 7 then clear SW3_UpdateFlag & SW3_TRGlag)
    
    uint8_t             SW4_UpdateFlag;             // SW4(PB11) 0: No update event.  1: Has update event.
    uint8_t             SW4_TRGlag;
    uint8_t             SW4_DramaTime;
    
    uint8_t             SW_DramaTimeMax;            // Default is 7.
    uint8_t             SW_DramaTimeDefault;        // Default is 4.    
    //=================================================
    //TH223A LED Control Relationship Parameter.
    uint8_t             GLED_Lock;
    uint8_t             YLED_Lock;
    uint8_t             RLED_Lock;
    
    uint8_t             GLED_Count;
    uint8_t             YLED_Count;
    uint8_t             RLED_Count;
    
    uint8_t             LED_CountMax;
    //=================================================
    //Power ON Test Item Result. 
    //    - Only test in power on reset.
    BSP_StatusTypeDef   TestFlashResult;
    BSP_StatusTypeDef   TestEEPROMResult;
    
    //=================================================
    //BLE Break Display Relationship Parameter.
    #if BSP_12_BLE == 1
        uint8_t           _PADDING[1];
        uint8_t             *ble_mac_addr;
    #else
        uint8_t           _PADDING[1];
    #endif

}TH222xCTR_TypeDef;


/* Macro -------------------------------------------------------------*/
/* Variables ---------------------------------------------------------*/ 
//TH222x
extern TH222xCTR_TypeDef  TH222x_CTR;
#if BSP_12_BLE == 1 && BSP_2_ARGB == 1
    extern uint8_t TH222x_BLE_ARGDelay;
#endif

//TH222x ARGB
extern uint8_t TH222x_ARGB_UpdateFlag;

//TH222x RGB
extern uint8_t TH222x_RGB_UpdateFlag;

//TH222x StepMotor
extern uint8_t TH222x_StepMotor_UpdateFlag;

//TH222x Variable Resistor
extern uint8_t TH222x_VR_UpdateFlag;

//TH222x Rotary Encoder
extern uint8_t TH222x_RotaryEncoder_UpdateFlag;

//TH222x Buzzer
extern uint8_t TH222x_Buzzer_UpdateFlag;
extern uint8_t TH222x_Buzzer_ONFlag;
extern uint8_t TH222x_Buzzer_ONCount;

//TH222x RC Sevo Motor
extern uint8_t TH222x_RCServoMotor_UpdateFlag;

//TH222x BLE
extern uint8_t TH222x_BLE_UpdateFlag;
extern uint8_t TH222x_BLE_ONFlag;

//TH222x 4x4 Keyboard
extern uint8_t TH222x_4x4Keyboard_UpdateFlag; 

//TH222x 2 color dot matrix LED
extern uint8_t TH222x_2ColorMatrixLED_UpdateFlag;

//TH222x 7-Segment
extern uint8_t TH222x_7Segment_UpdateFlag;

/* Function prototypes -----------------------------------------------*/
//TH222x 
void TH222x_Parameter_DeInit(void);
void TH222x_main(void);
void TH222x_Init(void);
void TH222x_DisplayTestResult(void);
void TH222x_Delay(__IO uint32_t Delay);

//TH223x DEBUG (URT)
void TH222x_DEBUGParameter_Init(void);
void TH222x_DEBUG_Init(void);


//TH222x ARGB
void TH222x_ARGBParameter_DeInit(void);
void TH222x_ARGB(void);

//TH222x RGB
void TH222x_RGBParameter_DeInit(void);
void TH222x_RGB(void);

//TH222x Step Motor
void TH222x_StepMotorParameter_DeInit(void);
void TH222x_StepMotor_SetStatus(uint8_t StepMotor_Status);
uint8_t TH222x_StepMotor_GetStatus(void);
void TH222x_StepMotor(void);

//TH222x Variable Resisotr
void TH222x_VariableResistorParameter_DeInit(void);
void TH222x_VariableResistor(void);

//TH222x Rotary Encoder
void TH222x_RotaryEncoderParameter_DeInit(void);
void TH222x_RotaryEncoder(void);

//TH222x Buzzer
void TH222x_BuzzerParameter_DeInit(void);
void TH222x_Buzzer(void);

//TH222x RC Servo Motor
void TH222x_RCServoMotorParameter_DeInit(void);
void TH222x_RCServoMotor(void);

//TH222x BLE
void TH222x_BLEParameter_DeInit(void);
void TH222x_BLE_Init(void);
void TH222x_BLE(void);
void TH222x_BLE_URTIRQHandler(void);
void TH222x_BLE_URTIT_Config(uint8_t BLE_URT_IT , FunctionalState BLE_URT_ITCmd);
uint8_t TH222x_BLE_WriteTxBuffer(uint8_t* TH222xBLE_TXBuf, uint8_t TH222xBLE_TXLen);

//TH222x SPI Flash
uint8_t TH222x_SPIFlash(void);

//TH222x EEPROM
uint8_t TH222x_EEPROM(void);

//TH222x 4x4 Keyboard
void TH222x_4x4KeyboardParameter_DeInit(void);
void TH222x_4x4Keyboard(void);

//TH222x 2 color dot matrix
void TH222x_2ColorDotMatrixParameter_DeInit(void);
void TH222x_2ColorDotMatrix(void);

//TH222x 7-Segment
void TH222x_7SegmentParameter_DeInit(void);
void TH222x_7Segment(void);
void TH222x_7Segment_ShowSignedValue(int16_t TH222x_SEG7_iValueX);
void TH222x_7Segment_ShowUnsignedValue(uint16_t TH222x_SEG7_iValueX);

//TH222x LCD 
void TH222x_LCDParameter_DeInit(void);


#endif





