/**
 ******************************************************************************
 *
 * @file        MG32_CAN_Init.H
 *
 * @brief       This file is to configure URT baudrate setting.
 *              Device : MG32F02N128
 * @par         Project
 *              MG32
 * @version     V1.00   
 * @date        2024/08/22
 * @author      MG32CoGen: 2.0.0.30 , 2025/3/26 上午 11:27 
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_CAN.h" 
#include "RTE_Components.h"
#if defined(IRQHandler_Middleware_Level_)
    #include "MG32_CAN_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>
//<e0> CAN0 Configure
    #define CONF_CAN0_INIT_EN               1
    //<h> Bit Timings Parameters
    //<i> TQ = freq(Clock source) / prescaler
    //<i> Bit time = TQ / ( 1 + (Prop_Seg + Phase_Seg1) + Phase_Seg2)
    #if 1
        //<o0> Clock source <0=> PROC <1=> NCO_P0 <2=> CK_LS
        #define CONF_CAN0_SEL                0
        //<o0> Prescaler ( for Time Quantum) (2~1024) (for Time Quantum) <2-1024>
        #define CONF_CAN0_BRP                16
        //<o0> Prop_Seg + Phase_Seg1 < 1=>  2 TQ < 2=>  3 TQ < 3=>  4 TQ < 4=>  5 TQ < 5=>  6TQ < 6=>  7 TQ < 7=>  8 TQ < 8=>  9 TQ 
        //                           < 9=> 10 TQ <10=> 11 TQ <11=> 12 TQ <12=> 13TQ <13=> 14 TQ <14=> 15 TQ <15=> 16 TQ
        //<i> Prop_Seg : Propagation segment
        //<i> Phase_Seg1 : Phase Buffer Segment 1        
        #define CONF_CAN0_TSEG1              2
        //<o0> Phase_Seg2 < 1=>  2 TQ < 2=>  3 TQ < 3=>  4 TQ < 4=>  5 TQ < 5=>  6TQ < 6=>  7 TQ < 7=>  8 TQ 
        //<i> Phase_Seg2 : Phase Buffer Segment 1 
        #define CONF_CAN0_TSEG2              2
        //<o0> ReSynchronization Jump Width (SJW) <0=> 1 TQ <1=> 2 TQ <2=> 3 TQ <3=> 4 TQ
        #define CONF_CAN0_SJW                0
    #endif
    //</h>
    //<h> Basic Parameters
    #if 1
        //<o0> Automatic Wake-Up Mode <0=> Disable <1=> Enable
        #define CONF_CAN0_WUP_MDS            0
        //<o0> Transmit Automatically Retransmit <1=> Disable <0=> Enable
        #define CONF_CAN0_TXE_MDS            0
        //<o0> Transmit Priority <0=> Message identifier <1=> Request sequence order
        #define CONF_CAN0_TX_PRI             0
        //<o0> Receive FIFO overrun mode <0=> Overwritten by new message <1=> Keep preserved old message
        #define CONF_CAN0_ROVR_MDS           0
        //<o0> Receive FIFO mode <0=> Two FIFO Structure <1=> One FIFO Structure
        #define CONF_CAN0_RBUF_SEL           0
        //<e0> CAN FD tolerant
        #define CONF_CAN0_FDT_MDS            0
            //<o0> CAN receive edge detect filter mode when detect FD frame <0=> Disable <1=> Enable
            #define CONF_CAN0_EDF_MDS        0            
        //</e>
    #endif
    //</h>
    //<h> Advanced Parameters
    #if 1
        //<o0> Operating Mode <0=> Normal mode <1=> Loop back mode <2=> Silent mode <3=> Loop back combined with silent mode.
        #define CONF_CAN0_TST_MDS            0 
        //<o0> CAN_RX / CAN_TX pin swap <0=> Disable <1=> Enable
        #define CONF_CAN0_IO_SWP             0 
        //<o0> Error Warning Limit (1-255) <1-255>
        #define CONF_CAN0_EW_LIM             96 
    #endif
    //</h>
    //<e0> Filter 0 Configure
    #define CONF_CAN0_AF0_EN                 0 
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF0_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF0_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_32MSKAF0_0   0x00000000
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF0_32MSKAF0_1   0x00000000
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32MSKAF0_2   0x00000000
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32MSKAF0_3   0x00000000
            #define CONF_CAN0_AF0_32MSKAF0     (CONF_CAN0_AF0_32MSKAF0_0|CONF_CAN0_AF0_32MSKAF0_1|CONF_CAN0_AF0_32MSKAF0_2|CONF_CAN0_AF0_32MSKAF0_3)
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF0_32MSKAF1     (CONF_CAN0_AF0_32MSKAF1_0|CONF_CAN0_AF0_32MSKAF1_1|CONF_CAN0_AF0_32MSKAF1_2|CONF_CAN0_AF0_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF0_16MSKAF00    (CONF_CAN0_AF0_16MSKAF00_0|CONF_CAN0_AF0_16MSKAF00_1|CONF_CAN0_AF0_16MSKAF00_2|CONF_CAN0_AF0_16MSKAF00_3)
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF0_16MSKAF01    (CONF_CAN0_AF0_16MSKAF01_0|CONF_CAN0_AF0_16MSKAF01_1|CONF_CAN0_AF0_16MSKAF01_2|CONF_CAN0_AF0_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16MSKAF10_0  0x00000000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF0_16MSKAF10    (CONF_CAN0_AF0_16MSKAF10_0|CONF_CAN0_AF0_16MSKAF10_1|CONF_CAN0_AF0_16MSKAF10_2|CONF_CAN0_AF0_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF0_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF0_16MSKAF11    (CONF_CAN0_AF0_16MSKAF11_0|CONF_CAN0_AF0_16MSKAF11_1|CONF_CAN0_AF0_16MSKAF11_2|CONF_CAN0_AF0_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF0_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF0_32LISTAF0    (CONF_CAN0_AF0_32LISTAF0_0|CONF_CAN0_AF0_32LISTAF0_1|CONF_CAN0_AF0_32LISTAF0_2|CONF_CAN0_AF0_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF0_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF0_32LISTAF1    (CONF_CAN0_AF0_32LISTAF1_0|CONF_CAN0_AF0_32LISTAF1_1|CONF_CAN0_AF0_32LISTAF1_2|CONF_CAN0_AF0_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF0_16LISTAF00   (CONF_CAN0_AF0_16LISTAF00_0|CONF_CAN0_AF0_16LISTAF00_1|CONF_CAN0_AF0_16LISTAF00_2|CONF_CAN0_AF0_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF0_16LISTAF01   (CONF_CAN0_AF0_16LISTAF01_0|CONF_CAN0_AF0_16LISTAF01_1|CONF_CAN0_AF0_16LISTAF01_2|CONF_CAN0_AF0_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16LISTAF10_0 0x00000000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF0_16LISTAF10   (CONF_CAN0_AF0_16LISTAF10_0|CONF_CAN0_AF0_16LISTAF10_1|CONF_CAN0_AF0_16LISTAF10_2|CONF_CAN0_AF0_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF0_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF0_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF0_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF0_16LISTAF11   (CONF_CAN0_AF0_16LISTAF11_0|CONF_CAN0_AF0_16LISTAF11_1|CONF_CAN0_AF0_16LISTAF11_2|CONF_CAN0_AF0_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Filter 1 Configure
    #define CONF_CAN0_AF1_EN                 0
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF1_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF1_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_32MSKAF0_0   0x00000000
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF1_32MSKAF0_1   0x00000000
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32MSKAF0_2   0x00000000
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32MSKAF0_3   0x00000000
            #define CONF_CAN0_AF1_32MSKAF0     (CONF_CAN0_AF1_32MSKAF0_0|CONF_CAN0_AF1_32MSKAF0_1|CONF_CAN0_AF1_32MSKAF0_2|CONF_CAN0_AF1_32MSKAF0_3)
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF1_32MSKAF1     (CONF_CAN0_AF1_32MSKAF1_0|CONF_CAN0_AF1_32MSKAF1_1|CONF_CAN0_AF1_32MSKAF1_2|CONF_CAN0_AF1_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF1_16MSKAF00    (CONF_CAN0_AF1_16MSKAF00_0|CONF_CAN0_AF1_16MSKAF00_1|CONF_CAN0_AF1_16MSKAF00_2|CONF_CAN0_AF1_16MSKAF00_3)
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF1_16MSKAF01    (CONF_CAN0_AF1_16MSKAF01_0|CONF_CAN0_AF1_16MSKAF01_1|CONF_CAN0_AF1_16MSKAF01_2|CONF_CAN0_AF1_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16MSKAF10_0  0x000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF1_16MSKAF10    (CONF_CAN0_AF1_16MSKAF10_0|CONF_CAN0_AF1_16MSKAF10_1|CONF_CAN0_AF1_16MSKAF10_2|CONF_CAN0_AF1_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF1_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF1_16MSKAF11    (CONF_CAN0_AF1_16MSKAF11_0|CONF_CAN0_AF1_16MSKAF11_1|CONF_CAN0_AF1_16MSKAF11_2|CONF_CAN0_AF1_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF1_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF1_32LISTAF0    (CONF_CAN0_AF1_32LISTAF0_0|CONF_CAN0_AF1_32LISTAF0_1|CONF_CAN0_AF1_32LISTAF0_2|CONF_CAN0_AF1_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF1_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF1_32LISTAF1    (CONF_CAN0_AF1_32LISTAF1_0|CONF_CAN0_AF1_32LISTAF1_1|CONF_CAN0_AF1_32LISTAF1_2|CONF_CAN0_AF1_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF1_16LISTAF00   (CONF_CAN0_AF1_16LISTAF00_0|CONF_CAN0_AF1_16LISTAF00_1|CONF_CAN0_AF1_16LISTAF00_2|CONF_CAN0_AF1_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF1_16LISTAF01   (CONF_CAN0_AF1_16LISTAF01_0|CONF_CAN0_AF1_16LISTAF01_1|CONF_CAN0_AF1_16LISTAF01_2|CONF_CAN0_AF1_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16LISTAF10_0 0x00000000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF1_16LISTAF10   (CONF_CAN0_AF1_16LISTAF10_0|CONF_CAN0_AF1_16LISTAF10_1|CONF_CAN0_AF1_16LISTAF10_2|CONF_CAN0_AF1_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF1_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF1_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF1_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF1_16LISTAF11   (CONF_CAN0_AF1_16LISTAF11_0|CONF_CAN0_AF1_16LISTAF11_1|CONF_CAN0_AF1_16LISTAF11_2|CONF_CAN0_AF1_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Filter 2 Configure
    #define CONF_CAN0_AF2_EN                 0
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF2_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF2_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_32MSKAF0_0   0x00000000 
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF2_32MSKAF0_1   0x00000000 
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32MSKAF0_2   0x00000000 
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32MSKAF0_3   0x00000000 
            #define CONF_CAN0_AF2_32MSKAF0     (CONF_CAN0_AF2_32MSKAF0_0|CONF_CAN0_AF2_32MSKAF0_1|CONF_CAN0_AF2_32MSKAF0_2|CONF_CAN0_AF2_32MSKAF0_3) 
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF2_32MSKAF1     (CONF_CAN0_AF2_32MSKAF1_0|CONF_CAN0_AF2_32MSKAF1_1|CONF_CAN0_AF2_32MSKAF1_2|CONF_CAN0_AF2_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF2_16MSKAF00    (CONF_CAN0_AF2_16MSKAF00_0|CONF_CAN0_AF2_16MSKAF00_1|CONF_CAN0_AF2_16MSKAF00_2|CONF_CAN0_AF2_16MSKAF00_3)
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF2_16MSKAF01    (CONF_CAN0_AF2_16MSKAF01_0|CONF_CAN0_AF2_16MSKAF01_1|CONF_CAN0_AF2_16MSKAF01_2|CONF_CAN0_AF2_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16MSKAF10_0  0x00000000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF2_16MSKAF10    (CONF_CAN0_AF2_16MSKAF10_0|CONF_CAN0_AF2_16MSKAF10_1|CONF_CAN0_AF2_16MSKAF10_2|CONF_CAN0_AF2_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF2_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF2_16MSKAF11    (CONF_CAN0_AF2_16MSKAF11_0|CONF_CAN0_AF2_16MSKAF11_1|CONF_CAN0_AF2_16MSKAF11_2|CONF_CAN0_AF2_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF2_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF2_32LISTAF0    (CONF_CAN0_AF2_32LISTAF0_0|CONF_CAN0_AF2_32LISTAF0_1|CONF_CAN0_AF2_32LISTAF0_2|CONF_CAN0_AF2_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF2_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF2_32LISTAF1    (CONF_CAN0_AF2_32LISTAF1_0CONF_CAN0_AF2_32LISTAF1_1|CONF_CAN0_AF2_32LISTAF1_2|CONF_CAN0_AF2_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF2_16LISTAF00   (CONF_CAN0_AF2_16LISTAF00_0|CONF_CAN0_AF2_16LISTAF00_1|CONF_CAN0_AF2_16LISTAF00_2|CONF_CAN0_AF2_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF2_16LISTAF01   (CONF_CAN0_AF2_16LISTAF01_0|CONF_CAN0_AF2_16LISTAF01_1|CONF_CAN0_AF2_16LISTAF01_2|CONF_CAN0_AF2_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16LISTAF10_0 0x00000000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF2_16LISTAF10   (CONF_CAN0_AF2_16LISTAF10_0|CONF_CAN0_AF2_16LISTAF10_1|CONF_CAN0_AF2_16LISTAF10_2|CONF_CAN0_AF2_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF2_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF2_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF2_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF2_16LISTAF11   (CONF_CAN0_AF2_16LISTAF11_0|CONF_CAN0_AF2_16LISTAF11_1|CONF_CAN0_AF2_16LISTAF11_2|CONF_CAN0_AF2_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Filter 3 Configure
    #define CONF_CAN0_AF3_EN                 0
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF3_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF3_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_32MSKAF0_0   0x00000000 
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF3_32MSKAF0_1   0x00000000 
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32MSKAF0_2   0x00000000 
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32MSKAF0_3   0x00000000 
            #define CONF_CAN0_AF3_32MSKAF0     (CONF_CAN0_AF3_32MSKAF0_0|CONF_CAN0_AF3_32MSKAF0_1|CONF_CAN0_AF3_32MSKAF0_2|CONF_CAN0_AF3_32MSKAF0_3)
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF3_32MSKAF1     (CONF_CAN0_AF3_32MSKAF1_0|CONF_CAN0_AF3_32MSKAF1_1|CONF_CAN0_AF3_32MSKAF1_2|CONF_CAN0_AF3_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF3_16MSKAF00    (CONF_CAN0_AF3_16MSKAF00_0|CONF_CAN0_AF3_16MSKAF00_1|CONF_CAN0_AF3_16MSKAF00_2|CONF_CAN0_AF3_16MSKAF00_3)
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF3_16MSKAF01    (CONF_CAN0_AF3_16MSKAF01_0|CONF_CAN0_AF3_16MSKAF01_1|CONF_CAN0_AF3_16MSKAF01_2|CONF_CAN0_AF3_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16MSKAF10_0  0x00000000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF3_16MSKAF10    (CONF_CAN0_AF3_16MSKAF10_0|CONF_CAN0_AF3_16MSKAF10_1|CONF_CAN0_AF3_16MSKAF10_2|CONF_CAN0_AF3_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF3_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF3_16MSKAF11    (CONF_CAN0_AF3_16MSKAF11_0|CONF_CAN0_AF3_16MSKAF11_1|CONF_CAN0_AF3_16MSKAF11_2|CONF_CAN0_AF3_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF3_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF3_32LISTAF0    (CONF_CAN0_AF3_32LISTAF0_0|CONF_CAN0_AF3_32LISTAF0_1|CONF_CAN0_AF3_32LISTAF0_2|CONF_CAN0_AF3_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF3_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF3_32LISTAF1    (CONF_CAN0_AF3_32LISTAF1_0|CONF_CAN0_AF3_32LISTAF1_1|CONF_CAN0_AF3_32LISTAF1_2|CONF_CAN0_AF3_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF3_16LISTAF00   (CONF_CAN0_AF3_16LISTAF00_0|CONF_CAN0_AF3_16LISTAF00_1|CONF_CAN0_AF3_16LISTAF00_2|CONF_CAN0_AF3_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF3_16LISTAF01   (CONF_CAN0_AF3_16LISTAF01_0|CONF_CAN0_AF3_16LISTAF01_1|CONF_CAN0_AF3_16LISTAF01_2|CONF_CAN0_AF3_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16LISTAF10_0 0x000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF3_16LISTAF10   (CONF_CAN0_AF3_16LISTAF10_0|CONF_CAN0_AF3_16LISTAF10_1|CONF_CAN0_AF3_16LISTAF10_2|CONF_CAN0_AF3_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF3_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF3_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF3_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF3_16LISTAF11   (CONF_CAN0_AF3_16LISTAF11_0|CONF_CAN0_AF3_16LISTAF11_1|CONF_CAN0_AF3_16LISTAF11_2|CONF_CAN0_AF3_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Filter 4 Configure
    #define CONF_CAN0_AF4_EN                 0
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF4_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF4_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_32MSKAF0_0   0x00000000
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF4_32MSKAF0_1   0x00000000
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32MSKAF0_2   0x00000000
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32MSKAF0_3   0x00000000
            #define CONF_CAN0_AF4_32MSKAF0     (CONF_CAN0_AF4_32MSKAF0_0|CONF_CAN0_AF4_32MSKAF0_1|CONF_CAN0_AF4_32MSKAF0_2|CONF_CAN0_AF4_32MSKAF0_3)
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF4_32MSKAF1     (CONF_CAN0_AF4_32MSKAF1_0|CONF_CAN0_AF4_32MSKAF1_1|CONF_CAN0_AF4_32MSKAF1_2|CONF_CAN0_AF4_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF4_16MSKAF00    (CONF_CAN0_AF4_16MSKAF00_0|CONF_CAN0_AF4_16MSKAF00_1|CONF_CAN0_AF4_16MSKAF00_2|CONF_CAN0_AF4_16MSKAF00_3)   
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF4_16MSKAF01    (CONF_CAN0_AF4_16MSKAF01_0|CONF_CAN0_AF4_16MSKAF01_1|CONF_CAN0_AF4_16MSKAF01_2|CONF_CAN0_AF4_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16MSKAF10_0  0x00000000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF4_16MSKAF10    (CONF_CAN0_AF4_16MSKAF10_0|CONF_CAN0_AF4_16MSKAF10_1|CONF_CAN0_AF4_16MSKAF10_2|CONF_CAN0_AF4_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF4_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF4_16MSKAF11    (CONF_CAN0_AF4_16MSKAF11_0|CONF_CAN0_AF4_16MSKAF11_1|CONF_CAN0_AF4_16MSKAF11_2|CONF_CAN0_AF4_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF4_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF4_32LISTAF0    (CONF_CAN0_AF4_32LISTAF0_0|CONF_CAN0_AF4_32LISTAF0_1|CONF_CAN0_AF4_32LISTAF0_2|CONF_CAN0_AF4_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF4_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF4_32LISTAF1    (CONF_CAN0_AF4_32LISTAF1_0|CONF_CAN0_AF4_32LISTAF1_1|CONF_CAN0_AF4_32LISTAF1_2|CONF_CAN0_AF4_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF4_16LISTAF00   (CONF_CAN0_AF4_16LISTAF00_0|CONF_CAN0_AF4_16LISTAF00_1|CONF_CAN0_AF4_16LISTAF00_2|CONF_CAN0_AF4_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF4_16LISTAF01   (CONF_CAN0_AF4_16LISTAF01_0|CONF_CAN0_AF4_16LISTAF01_1|CONF_CAN0_AF4_16LISTAF01_2|CONF_CAN0_AF4_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16LISTAF10_0 0x00000000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF4_16LISTAF10   (CONF_CAN0_AF4_16LISTAF10_0|CONF_CAN0_AF4_16LISTAF10_1|CONF_CAN0_AF4_16LISTAF10_2|CONF_CAN0_AF4_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF4_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF4_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF4_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF4_16LISTAF11   (CONF_CAN0_AF4_16LISTAF11_0|CONF_CAN0_AF4_16LISTAF11_1|CONF_CAN0_AF4_16LISTAF11_2|CONF_CAN0_AF4_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Filter 5 Configure
    #define CONF_CAN0_AF5_EN                 0
    #if 1    
        //<o0> Filter mode <0x00000000=> 32 bit mask mode
        //                 <0x00010000=> 16 bit mask mode
        //                 <0x00000001=> 32 bit list mode
        //                 <0x00010001=> 16 bit list mode
        //<i> If select "32 bit mask mode" to configure "32 bit mask mode configure"
        //<i> If select "16 bit mask mode" to configure "16 bit mask mode configure"
        //<i> If select "32 list mask mode" to configure "32 bit list mode configure"
        //<i> If select "16 list mask mode" to configure "16 bit list mode configure"
        #define CONF_CAN0_AF5_CFGMDS         0x00000000
        //<o0> FIFO Select <0=> FIFO 0 <1=> FIFO 1
        #define CONF_CAN0_AF5_FSEL           0
        //<h> 32 bit mask mode configure
        #if 1
            //<o0.21..31> [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_32MSKAF0_0   0x00000000 
            //<o0.3..20>  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF5_32MSKAF0_1   0x00000000 
            //<o0.2>      [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32MSKAF0_2   0x00000000 
            //<o0.1>      [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32MSKAF0_3   0x00000000 
            #define CONF_CAN0_AF5_32MSKAF0     (CONF_CAN0_AF5_32MSKAF0_0|CONF_CAN0_AF5_32MSKAF0_1|CONF_CAN0_AF5_32MSKAF0_2|CONF_CAN0_AF5_32MSKAF0_3) 
            //<o0.21..31> [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_32MSKAF1_0   0x00000000
            //<o0.3..20>  [Mask]       - Identifier extension (EID) <0x00000-0x3FFFF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_32MSKAF1_1   0x00000000
            //<o0.2>      [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_32MSKAF1_2   0x00000000
            //<o0.1>      [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_32MSKAF1_3   0x00000000
            #define CONF_CAN0_AF5_32MSKAF1     (CONF_CAN0_AF5_32MSKAF1_0|CONF_CAN0_AF5_32MSKAF1_1|CONF_CAN0_AF5_32MSKAF1_2|CONF_CAN0_AF5_32MSKAF1_3)
        #endif            
        //</h>            
        //<h> 16 bit mask mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16MSKAF00_0  0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16MSKAF00_1  0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16MSKAF00_2  0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16MSKAF00_3  0x00000000
            #define CONF_CAN0_AF5_16MSKAF00    (CONF_CAN0_AF5_16MSKAF00_0|CONF_CAN0_AF5_16MSKAF00_1|CONF_CAN0_AF5_16MSKAF00_2|CONF_CAN0_AF5_16MSKAF00_3)
            //<o0.21..31> 1st  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF01_0  0x00000000
            //<o0.16..18> 1st  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF01_1  0x00000000
            //<o0.20>     1st  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF01_2  0x00000000
            //<o0.19>     1st  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF01_3  0x00000000
            #define CONF_CAN0_AF5_16MSKAF01    (CONF_CAN0_AF5_16MSKAF01_0|CONF_CAN0_AF5_16MSKAF01_1|CONF_CAN0_AF5_16MSKAF01_2|CONF_CAN0_AF5_16MSKAF01_3)
            //<o0.5..15>  2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16MSKAF10_0  0x00000000
            //<o0.0..2>   2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16MSKAF10_1  0x00000000
            //<o0.4>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16MSKAF10_2  0x00000000
            //<o0.3>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16MSKAF10_3  0x00000000
            #define CONF_CAN0_AF5_16MSKAF10    (CONF_CAN0_AF5_16MSKAF10_0|CONF_CAN0_AF5_16MSKAF10_1|CONF_CAN0_AF5_16MSKAF10_2|CONF_CAN0_AF5_16MSKAF10_3)
            //<o0.21..31> 2nd  [Mask]       - Base identifier (SID) <0x000-0x7FF>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF11_0  0x00000000
            //<o0.16..18> 2nd  [Mask]       - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF11_1  0x00000000
            //<o0.20>     2nd  [Mask]       - IDE <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF11_2  0x00000000
            //<o0.19>     2nd  [Mask]       - RTR <0=> 0 <1=> 1
            //<i> 0 is mark individual bits as donot care.
            #define CONF_CAN0_AF5_16MSKAF11_3  0x00000000
            #define CONF_CAN0_AF5_16MSKAF11    (CONF_CAN0_AF5_16MSKAF11_0|CONF_CAN0_AF5_16MSKAF11_1|CONF_CAN0_AF5_16MSKAF11_2|CONF_CAN0_AF5_16MSKAF11_3)
        #endif            
        //</h>
        //<h> 32 bit list mode configure
        #if 1
            //<o0.21..31> 1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_32LISTAF0_0  0x00000000
            //<o0.3..20>  1st  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF5_32LISTAF0_1  0x00000000
            //<o0.2>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32LISTAF0_2  0x00000000
            //<o0.1>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32LISTAF0_3  0x00000000
            #define CONF_CAN0_AF5_32LISTAF0    (CONF_CAN0_AF5_32LISTAF0_0|CONF_CAN0_AF5_32LISTAF0_1|CONF_CAN0_AF5_32LISTAF0_2|CONF_CAN0_AF5_32LISTAF0_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_32LISTAF1_0  0x00000000
            //<o0.3..20>  2nd  [Identifier] - Identifier extension (EID) <0x00000-0x3FFFF>
            #define CONF_CAN0_AF5_32LISTAF1_1  0x00000000
            //<o0.2>      2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32LISTAF1_2  0x00000000
            //<o0.1>      2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_32LISTAF1_3  0x00000000
            #define CONF_CAN0_AF5_32LISTAF1    (CONF_CAN0_AF5_32LISTAF1_0|CONF_CAN0_AF5_32LISTAF1_1|CONF_CAN0_AF5_32LISTAF1_2|CONF_CAN0_AF5_32LISTAF1_3)
        #endif            
        //</h>
        //<h> 16 bit list mode configure
        #if 1
            //<o0.5..15>  1st  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16LISTAF00_0 0x00000000
            //<o0.0..2>   1st  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16LISTAF00_1 0x00000000
            //<o0.4>      1st  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF00_2 0x00000000
            //<o0.3>      1st  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF00_3 0x00000000
            #define CONF_CAN0_AF5_16LISTAF00   (CONF_CAN0_AF5_16LISTAF00_0|CONF_CAN0_AF5_16LISTAF00_1|CONF_CAN0_AF5_16LISTAF00_2|CONF_CAN0_AF5_16LISTAF00_3)
            //<o0.21..31> 2nd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16LISTAF01_0 0x00000000
            //<o0.16..18> 2nd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16LISTAF01_1 0x00000000
            //<o0.20>     2nd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF01_2 0x00000000
            //<o0.19>     2nd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF01_3 0x00000000
            #define CONF_CAN0_AF5_16LISTAF01   (CONF_CAN0_AF5_16LISTAF01_0|CONF_CAN0_AF5_16LISTAF01_1|CONF_CAN0_AF5_16LISTAF01_2|CONF_CAN0_AF5_16LISTAF01_3)
            //<o0.5..15>  3rd  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16LISTAF10_0 0x00000000
            //<o0.0..2>   3rd  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16LISTAF10_1 0x00000000
            //<o0.4>      3rd  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF10_2 0x00000000
            //<o0.3>      3rd  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF10_3 0x00000000
            #define CONF_CAN0_AF5_16LISTAF10   (CONF_CAN0_AF5_16LISTAF10_0|CONF_CAN0_AF5_16LISTAF10_1|CONF_CAN0_AF5_16LISTAF10_2|CONF_CAN0_AF5_16LISTAF10_3)
            //<o0.21..31> 4th  [Identifier] - Base identifier (SID) <0x000-0x7FF>
            #define CONF_CAN0_AF5_16LISTAF11_0 0x00000000
            //<o0.16..18> 4th  [Identifier] - Identifier extension (EID) ID17, ID16, ID15 <0x0-0x7>
            #define CONF_CAN0_AF5_16LISTAF11_1 0x00000000
            //<o0.20>     4th  [Identifier] - IDE <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF11_2 0x00000000
            //<o0.19>     4th  [Identifier] - RTR <0=> 0 <1=> 1
            #define CONF_CAN0_AF5_16LISTAF11_3 0x00000000
            #define CONF_CAN0_AF5_16LISTAF11   (CONF_CAN0_AF5_16LISTAF11_0|CONF_CAN0_AF5_16LISTAF11_1|CONF_CAN0_AF5_16LISTAF11_2|CONF_CAN0_AF5_16LISTAF11_3)
        #endif            
        //</h>
    #endif
    //</e>
    //<e0> Interrupt Enable (IEA)
    #define CONF_CAN0_IEA                    0
    #if 1
        //<q0> Bus-off Interrupt (BUS_IE)
        #define CONF_CAN0_BUS_IE             0
        //<q0> Error Warning Interrupt (EW_IE)
        #define CONF_CAN0_EW_IE              0
        //<q0> Wakeup From CAN Low Power Mode Interrupt (EW_IE)
        #define CONF_CAN0_WUP_IE             0
        //<q0> Error Passive Interrupt (EP_IE)
        #define CONF_CAN0_EP_IE              0
        //<q0> Arbitration Lost Interrupt (ALOS_IE)
        #define CONF_CAN0_ALOS_IE            0
        //<q0> Bus Error Interrupt (BERR_IE)
        #define CONF_CAN0_BERR_IE            0
        //<q0> RX FIFO0 Data Receive Interrupt (RX0_IE)
        #define CONF_CAN0_RX0_IE             0
        //<q0> RX FIFO0 Full Interrupt (RFUL0_IE)        
        #define CONF_CAN0_RFUL0_IE           0
        //<q0> RX FIFO0 Overrun Interrupt (ROVR0_IE)
        #define CONF_CAN0_ROVR0_IE           0
        //<q0> RX FIFO0 Remained Pending Interrupt (RPEND0_IE)
        #define CONF_CAN0_RPEND0_IE          0
        //<q0> RX FIFO1 Data Receive Interrupt (RX1_IE)
        #define CONF_CAN0_RX1_IE             0
        //<q0> RX FIFO1 Full Interrupt (RFUL1_IE)        
        #define CONF_CAN0_RFUL1_IE           0
        //<q0> RX FIFO1 Overrun Interrupt (ROVR1_IE)
        #define CONF_CAN0_ROVR1_IE           0
        //<q0> RX FIFO1 Remained Pending Interrupt (RPEND1_IE)
        #define CONF_CAN0_RPEND1_IE          0    
        //<q0> TX Message Buffer0 Request Completed Interrupt (TX0_IE)
        #define CONF_CAN0_TX0_IE             0
        //<q0> TX Message Buffer1 Request Completed Interrupt (TX1_IE)
        #define CONF_CAN0_TX1_IE             0
        //<q0> TX Message Buffer2 Request Completed Interrupt (TX2_IE)
        #define CONF_CAN0_TX2_IE             0        
    #endif
    //</e>
//</e>
// <<< end of Configuration section >>>
    
/* Define ---------------------------------------------------------------------*/
#define CAN_FILTER_MODE_32BIT_MASK    0x00000000
#define CAN_FILTER_MODE_16BIT_MASK    0x00010000
#define CAN_FILTER_MODE_32BIT_LIST    0x00000001
#define CAN_FILTER_MODE_16BIT_LIST    0x00010001

/* Exported variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)
    extern CAN_HandleTypeDef  mCAN0;
#endif

 
/* Exported functions ---------------------------------------------------------*/ 
void CAN_Init(void);

void CAN0_Init_CpltCallback(void);

