
/**
 ******************************************************************************
 *
 * @file        MG32_OPA_Init.h
 *
 * @brief       The OPA initial code h file
 *              
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2025/04/09/10:00
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 ******************************************************************************
 */
#ifndef _MG32_OPA_INIT_H
/*!< _MG32_OPA_INIT_H */ 
#define _MG32_OPA_INIT_H

#include "MG32_OPA_DRV.h"

// <<< Use Configuration Wizard in Context Menu >>>

//<e0.0> Module - Mode Active
    #define CONF_OPA_MODE                      0x00000000
//  <h> OPA0 Config
//      <o0.8..9> OPA positive channel selection <0=> VBUF <1=> OPA_I0 (PA4) <2=> PGA_P0
        #define CONF_OPA_OPAPMUX               0x00000000
//      <o0.12..13> OPA negative channel selection <0=> VBUF <1=> OPA_I1 (PA5) <2=> OPA_P0 (PA0)
        #define CONF_OPA_OPANMUX               0x00000000
//      <q0.2> OPA low power mode
        #define CONF_OPA_OPALPEN               0x00000000
//  </h>
//</e>
// <<< end of Configuration section >>>

// Combined with OPA_CR0 register bit function
#define CONF_OPA_CR0    (CONF_OPA_OPAPMUX       |\
                         CONF_OPA_OPANMUX       |\
                         CONF_OPA_OPALPEN       |\
                         OPA_CR0_OP0_EN_enable_w) 

    
/**
 * @name  Function announce
 *      
 */
///@{ 
void OPA_Init(void);

///@}
#endif  // _MG32_OPA_INIT_H
