/**
 ******************************************************************************
 *
 * @file        MG32_OPA_DRV.h
 *
 * @brief       This file contains all the functions prototypes for the OPA 
 *              firmware library.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2024/09/12
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 


#include "MG32.h"

#if defined(ModuleExist_OPA)

#ifndef _MG32_OPA_DRV_H

/*!< _MG32_OPA_DRV_H */ 
#define _MG32_OPA_DRV_H


#include "MG32__Common_DRV.h"
#include "MG32_OPA.h"
#include "MG32_PW_DRV.h"
#include "MG32_ADC_DRV.h"
#include "MG32__ExtraStruct.h"





/** 
 * @enum		OPA_PowerLevelSel
 * @brief		declare OPA power level select
 */        
typedef enum 
{ 
    OPA_NormalPower = OPA_CR0_OP0_LPEN_disable_w,   /*!< Normal power mode */
    OPA_LowPower    = OPA_CR0_OP0_LPEN_enable_w     /*!< Low power mode */
} OPA_PowerLevelSel;



/** 
 * @enum		OPA_ACPinInputDef
 * @brief		declare ACz postive input property 
 */        
typedef enum 
{ 
    OPA_P_VBUF      = OPA_CR0_OP0_PMUX_vbuf_w,      /*!< select internal reference be input */
    OPA_P_OP0_I0    = OPA_CR0_OP0_PMUX_op0_i0_w,    /*!< select PA4 pin be input */
    OPA_P_PGA       = OPA_CR0_OP0_PMUX_pga_p0_w,    /*!< select PGA output be input */
} OPA_ACPinInputDef;

/** 
 * @enum		OPA_ACNPinInputDef
 * @brief		declare ACz negative input property 
 */        
typedef enum 
{ 
    OPA_N_VBUF      = OPA_CR0_OP0_NMUX_vbuf_w,      /*!< select internal reference be input */
    OPA_N_OP0_I1    = OPA_CR0_OP0_NMUX_op0_i1_w,    /*!< select PA5 pin be input */
    OPA_N_OPA_P0    = OPA_CR0_OP0_NMUX_op0_p0_w,    /*!< select OPA output be input */
} OPA_ACNPinInputDef;


/**
 * @name	Function announce
 *   		
 */ 
///@{  
void OPA_DeInit(void);
///@}

///@{  
void OPA_Cmd(OPA_OP_Struct* OPAx, FunctionalState NewState);
void OPA_Power_Select(OPA_OP_Struct* OPAx, OPA_PowerLevelSel PowerLevelSel);
///@}


///@{  
void OPA_PositivePin_Select(OPA_OP_Struct* OPAx, OPA_ACPinInputDef OP0PPin);
void OPA_NegativePin_Select(OPA_OP_Struct* OPAx, OPA_ACNPinInputDef OP0NPin);
void OPA_SetOffset(OPA_OP_Struct* OPAx, int8_t Val);
///@}


///@{  
void OPA_OffsetCalibration_Cmd (OPA_OP_Struct* OPAx, FunctionalState NewState);
///@}


#endif
#endif
