/**
 ******************************************************************************
 *
 * @file        MG32_IEC60730_GPIO.h
 *
 * @brief       This is the C code format driver head file.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2021/09/15
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 

#ifndef _MG32_IEC60730_GPIO_Test_H
#define _MG32_IEC60730_GPIO_Test_H

#include "MG32_GPIO.h"

// <<< Use Configuration Wizard in Context Menu >>>
//<h> GPIO Output test
    //<e0> Test PortA 
        //<e1.0> Test PA0
            //<o2.0> Test level <0=> L <1=> H
        //</e>
        //<e1.1> Test PA1
            //<o2.1> Test level <0=> L <1=> H
        //</e>    
        //<e1.2> Test PA2
            //<o2.2> Test level <0=> L <1=> H
        //</e>
        //<e1.3> Test PA3
            //<o2.3> Test level <0=> L <1=> H
        //</e>
        //<e1.4> Test PA4
            //<o2.4> Test level <0=> L <1=> H
        //</e>
        //<e1.5> Test PA5
            //<o2.5> Test level <0=> L <1=> H
        //</e>
        //<e1.6> Test PA6
            //<o2.6> Test level <0=> L <1=> H
        //</e>
        //<e1.7> Test PA7
            //<o2.7> Test level <0=> L <1=> H
        //</e>
        //<e1.8> Test PA8
            //<o2.8> Test level <0=> L <1=> H
        //</e>
        //<e1.9> Test PA9
            //<o2.9> Test level <0=> L <1=> H
        //</e>
        //<e1.10>Test PA10
            //<o2.10> Test level <0=> L <1=> H
        //</e>
        //<e1.11>Test PA11
            //<o2.11> Test level <0=> L <1=> H
        //</e>
        //<e1.12>Test PA12
            //<o2.12> Test level <0=> L <1=> H
        //</e>
        //<e1.13>Test PA13
            //<o2.13> Test level <0=> L <1=> H
        //</e>
        //<e1.14>Test PA14
            //<o2.14> Test level <0=> L <1=> H
        //</e>
        //<e1.15>Test PA15
            //<o2.15> Test level <0=> L <1=> H
        //</e>    
    //</e>
    #define TST_PAO_MSK    1
    #define TST_PAOX_MSK   0x0001
    #define TST_PAO_LVL    0x0000
    //<e0> Test PortB
        //<e1.0> Test PB0
            //<o2.0> Test level <0=> L <1=> H
        //</e>
        //<e1.1> Test PB1
            //<o2.1> Test level <0=> L <1=> H
        //</e>
        //<e1.2> Test PB2
            //<o2.2> Test level <0=> L <1=> H
        //</e>
        //<e1.3> Test PB3
            //<o2.3> Test level <0=> L <1=> H
        //</e>
        //<e1.4> Test PB4
            //<o2.4> Test level <0=> L <1=> H
        //</e>
        //<e1.5> Test PB5
            //<o2.5> Test level <0=> L <1=> H
        //</e>
        //<e1.6> Test PB6
            //<o2.6> Test level <0=> L <1=> H
        //</e>
        //<e1.7> Test PB7
            //<o2.7> Test level <0=> L <1=> H
        //</e>
        //<e1.8> Test PB8
            //<o2.8> Test level <0=> L <1=> H
        //</e>
        //<e1.9> Test PB9
            //<o2.9> Test level <0=> L <1=> H
        //</e>
        //<e1.10>Test PB10
            //<o2.10> Test level <0=> L <1=> H
        //</e>
        //<e1.11>Test PB11
            //<o2.11> Test level <0=> L <1=> H
        //</e>
        //<e1.12>Test PB12
            //<o2.12> Test level <0=> L <1=> H
        //</e>
        //<e1.13>Test PB13
            //<o2.13> Test level <0=> L <1=> H
        //</e>
        //<e1.14>Test PB14
            //<o2.14> Test level <0=> L <1=> H
        //</e>
        //<e1.15>Test PB15 
            //<o2.15> Test level <0=> L <1=> H
        //</e>        
    //</e>
    #define TST_PBO_MSK    1
    #define TST_PBOX_MSK   0x0001
    #define TST_PBO_LVL    0x0003
    //<e0> Test PortC
        //<e1.0> Test PC0
            //<o2.0> Test level <0=> L <1=> H
        //</e>
        //<e1.1> Test PC1
            //<o2.1> Test level <0=> L <1=> H
        //</e>
        //<e1.2> Test PC2
            //<o2.2> Test level <0=> L <1=> H
        //</e>
        //<e1.3> Test PC3
            //<o2.3> Test level <0=> L <1=> H
        //</e>
        //<e1.4> Test PC4
            //<o2.4> Test level <0=> L <1=> H
        //</e>
        //<e1.5> Test PC5
            //<o2.5> Test level <0=> L <1=> H
        //</e>
        //<e1.6> Test PC6
            //<o2.6> Test level <0=> L <1=> H
        //</e>
        //<e1.7> Test PC7
            //<o2.7> Test level <0=> L <1=> H
        //</e>
        //<e1.8> Test PC8
            //<o2.8> Test level <0=> L <1=> H
        //</e>
        //<e1.9> Test PC9
            //<o2.9> Test level <0=> L <1=> H
        //</e>
        //<e1.10>Test PC10
            //<o2.10> Test level <0=> L <1=> H
        //</e>
        //<e1.11>Test PC11
            //<o2.11> Test level <0=> L <1=> H
        //</e>
        //<e1.12>Test PC12
            //<o2.12> Test level <0=> L <1=> H
        //</e>
        //<e1.13>Test PC13
            //<o2.13> Test level <0=> L <1=> H
        //</e>
        //<e1.14>Test PC14
            //<o2.14> Test level <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PCO_MSK    0
    #define TST_PCOX_MSK   0x0000
    #define TST_PCO_LVL    0x0000
    //<e0> Test PortD
        //<e1.0> Test PD0
            //<o2.0> Test level <0=> L <1=> H
        //</e>
        //<e1.1> Test PD1
            //<o2.1> Test level <0=> L <1=> H
        //</e>
        //<e1.2> Test PD2
            //<o2.2> Test level <0=> L <1=> H
        //</e>
        //<e1.3> Test PD3
            //<o2.3> Test level <0=> L <1=> H
        //</e>
        //<e1.4> Test PD4
            //<o2.4> Test level <0=> L <1=> H
        //</e>
        //<e1.5> Test PD5
            //<o2.5> Test level <0=> L <1=> H
        //</e>
        //<e1.6> Test PD6
            //<o2.6> Test level <0=> L <1=> H
        //</e>
        //<e1.7> Test PD7
            //<o2.7> Test level <0=> L <1=> H
        //</e>
        //<e1.8> Test PD8
            //<o2.8> Test level <0=> L <1=> H
        //</e>
        //<e1.9> Test PD9
            //<o2.9> Test level <0=> L <1=> H
        //</e>
        //<e1.10>Test PD10
            //<o2.10> Test level <0=> L <1=> H
        //</e>
        //<e1.11>Test PD11
            //<o2.11> Test level <0=> L <1=> H
        //</e>
        //<e1.12>Test PD12
            //<o2.12> Test level <0=> L <1=> H
        //</e>
        //<e1.13>Test PD13
            //<o2.13> Test level <0=> L <1=> H
        //</e>
        //<e1.14>Test PD14
            //<o2.14> Test level <0=> L <1=> H
        //</e>
        //<e1.15>Test PD15
            //<o2.15> Test level <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PDO_MSK    0
    #define TST_PDOX_MSK   0x0000
    #define TST_PDO_LVL    0x0000
    //<e0> Test PortE
        //<e1.0> Test PE0
            //<o2.0> Test level <0=> L <1=> H
        //</e>
        //<e1.1> Test PE1
            //<o2.1> Test level <0=> L <1=> H
        //</e>
        //<e1.2> Test PE2
            //<o2.2> Test level <0=> L <1=> H
        //</e>
        //<e1.3> Test PE3
            //<o2.3> Test level <0=> L <1=> H
        //</e>
        //<e1.8> Test PE8
            //<o2.8> Test level <0=> L <1=> H
        //</e>
        //<e1.9> Test PE9
            //<o2.9> Test level <0=> L <1=> H
        //</e>
        //<e1.12>Test PE12
            //<o2.12> Test level <0=> L <1=> H
        //</e>
        //<e1.13>Test PE13
            //<o2.13> Test level <0=> L <1=> H
        //</e>
        //<e1.14>Test PE14
            //<o2.14> Test level <0=> L <1=> H
        //</e>
        //<e1.15>Test PE15
            //<o2.15> Test level <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PEO_MSK    0
    #define TST_PEOX_MSK   0x2000
    #define TST_PEO_LVL    0x0000
//</h>


//<h> GPIO Input test
    //<e0> Test PortA 
        //<e1.0> Test PA0
            //<o2.0> expect status <0=> L <1=> H
        //</e>
        //<e1.1> Test PA1
            //<o2.1> expect status <0=> L <1=> H
        //</e>
        //<e1.2> Test PA2
            //<o2.2> expect status <0=> L <1=> H
        //</e>
        //<e1.3> Test PA3
            //<o2.3> expect status <0=> L <1=> H
        //</e>
        //<e1.4> Test PA4
            //<o2.4> expect status <0=> L <1=> H
        //</e>
        //<e1.5> Test PA5
            //<o2.5> expect status <0=> L <1=> H
        //</e>
        //<e1.6> Test PA6
            //<o2.6> expect status <0=> L <1=> H
        //</e>
        //<e1.7> Test PA7
            //<o2.7> expect status <0=> L <1=> H
        //</e>
        //<e1.8> Test PA8
            //<o2.8> expect status <0=> L <1=> H
        //</e>
        //<e1.9> Test PA9
            //<o2.9> expect status <0=> L <1=> H
        //</e>
        //<e1.10> Test PA10
            //<o2.10> expect status <0=> L <1=> H
        //</e>
        //<e1.11> Test PA11
            //<o2.11> expect status <0=> L <1=> H
        //</e>
        //<e1.12> Test PA12
            //<o2.12> expect status <0=> L <1=> H
        //</e>
        //<e1.13> Test PA13
            //<o2.13> expect status <0=> L <1=> H
        //</e>
        //<e1.14> Test PA14
            //<o2.14> expect status <0=> L <1=> H
        //</e>
        //<e1.15> Test PA15
            //<o2.15> expect status <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PAI_MSK    0
    #define TST_PAIX_MSK   0x0002
    #define TST_PAI_EXPECT 0x0000

    //<e0> Test PortB 
        //<e1.0> Test PB0
            //<o2.0> expect status <0=> L <1=> H
        //</e>
        //<e1.1> Test PB1
            //<o2.1> expect status <0=> L <1=> H
        //</e>
        //<e1.2> Test PB2
            //<o2.2> expect status <0=> L <1=> H
        //</e>
        //<e1.3> Test PB3
            //<o2.3> expect status <0=> L <1=> H
        //</e>
        //<e1.4> Test PB4
            //<o2.4> expect status <0=> L <1=> H
        //</e>
        //<e1.5> Test PB5
            //<o2.5> expect status <0=> L <1=> H
        //</e>
        //<e1.6> Test PB6
            //<o2.6> expect status <0=> L <1=> H
        //</e>
        //<e1.7> Test PB7
            //<o2.7> expect status <0=> L <1=> H
        //</e>
        //<e1.8> Test PB8
            //<o2.8> expect status <0=> L <1=> H
        //</e>
        //<e1.9> Test PB9
            //<o2.9> expect status <0=> L <1=> H
        //</e>
        //<e1.10> Test PB10
            //<o2.10> expect status <0=> L <1=> H
        //</e>
        //<e1.11> Test PB11
            //<o2.11> expect status <0=> L <1=> H
        //</e>
        //<e1.12> Test PB12
            //<o2.12> expect status <0=> L <1=> H
        //</e>
        //<e1.13> Test PB13
            //<o2.13> expect status <0=> L <1=> H
        //</e>
        //<e1.14> Test PB14
            //<o2.14> expect status <0=> L <1=> H
        //</e>
        //<e1.15> Test PB15
            //<o2.15> expect status <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PBI_MSK    0
    #define TST_PBIX_MSK   0x0000
    #define TST_PBI_EXPECT 0x0000
    
    //<e0> Test PortC 
        //<e1.0> Test PC0
            //<o2.0> expect status <0=> L <1=> H
        //</e>
        //<e1.1> Test PC1
            //<o2.1> expect status <0=> L <1=> H
        //</e>
        //<e1.2> Test PC2
            //<o2.2> expect status <0=> L <1=> H
        //</e>
        //<e1.3> Test PC3
            //<o2.3> expect status <0=> L <1=> H
        //</e>
        //<e1.4> Test PC4
            //<o2.4> expect status <0=> L <1=> H
        //</e>
        //<e1.5> Test PC5
            //<o2.5> expect status <0=> L <1=> H
        //</e>
        //<e1.6> Test PC6
            //<o2.6> expect status <0=> L <1=> H
        //</e>
        //<e1.7> Test PC7
            //<o2.7> expect status <0=> L <1=> H
        //</e>
        //<e1.8> Test PC8
            //<o2.8> expect status <0=> L <1=> H
        //</e>
        //<e1.9> Test PC9
            //<o2.9> expect status <0=> L <1=> H
        //</e>
        //<e1.10> Test PC10
            //<o2.10> expect status <0=> L <1=> H
        //</e>
        //<e1.11> Test PC11
            //<o2.11> expect status <0=> L <1=> H
        //</e>
        //<e1.12> Test PC12
            //<o2.12> expect status <0=> L <1=> H
        //</e>
        //<e1.13> Test PC13
            //<o2.13> expect status <0=> L <1=> H
        //</e>
        //<e1.14> Test PC14
            //<o2.14> expect status <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PCI_MSK    1
    #define TST_PCIX_MSK   0x0001
    #define TST_PCI_EXPECT 0x0001

    //<e0> Test PortD 
        //<e1.0> Test PD0
            //<o2.0> expect status <0=> L <1=> H
        //</e>
        //<e1.1> Test PD1
            //<o2.1> expect status <0=> L <1=> H
        //</e>
        //<e1.2> Test PD2
            //<o2.2> expect status <0=> L <1=> H
        //</e>
        //<e1.3> Test PD3
            //<o2.3> expect status <0=> L <1=> H
        //</e>
        //<e1.4> Test PD4
            //<o2.4> expect status <0=> L <1=> H
        //</e>
        //<e1.5> Test PD5
            //<o2.5> expect status <0=> L <1=> H
        //</e>
        //<e1.6> Test PD6
            //<o2.6> expect status <0=> L <1=> H
        //</e>
        //<e1.7> Test PD7
            //<o2.7> expect status <0=> L <1=> H
        //</e>
        //<e1.8> Test PD8
            //<o2.8> expect status <0=> L <1=> H
        //</e>
        //<e1.9> Test PD9
            //<o2.9> expect status <0=> L <1=> H
        //</e>
        //<e1.10> Test PD10
            //<o2.10> expect status <0=> L <1=> H
        //</e>
        //<e1.11> Test PD11
            //<o2.11> expect status <0=> L <1=> H
        //</e>
        //<e1.12> Test PD12
            //<o2.12> expect status <0=> L <1=> H
        //</e>
        //<e1.13> Test PD13
            //<o2.13> expect status <0=> L <1=> H
        //</e>
        //<e1.14> Test PD14
            //<o2.14> expect status <0=> L <1=> H
        //</e>
        //<e1.15> Test PD15
            //<o2.15> expect status <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PDI_MSK    0
    #define TST_PDIX_MSK   0x0001
    #define TST_PDI_EXPECT 0x0001
    
    //<e0> Test PortE 
        //<e1.0> Test PE0
            //<o2.0> expect status <0=> L <1=> H
        //</e>
        //<e1.1> Test PE1
            //<o2.1> expect status <0=> L <1=> H
        //</e>
        //<e1.2> Test PE2
            //<o2.2> expect status <0=> L <1=> H
        //</e>
        //<e1.3> Test PE3
            //<o2.3> expect status <0=> L <1=> H
        //</e>
        //<e1.8> Test PE8
            //<o2.8> expect status <0=> L <1=> H
        //</e>
        //<e1.9> Test PE9
            //<o2.9> expect status <0=> L <1=> H
        //</e>
        //<e1.12> Test PE12
            //<o2.12> expect status <0=> L <1=> H
        //</e>
        //<e1.13> Test PE13
            //<o2.13> expect status <0=> L <1=> H
        //</e>
        //<e1.14> Test PE14
            //<o2.14> expect status <0=> L <1=> H
        //</e>
        //<e1.15> Test PE15
            //<o2.15> expect status <0=> L <1=> H
        //</e>
    //</e>
    #define TST_PEI_MSK    0
    #define TST_PEIX_MSK   0x8000
    #define TST_PEI_EXPECT 0x0000
//</h>    

// <<< end of configuration section >>>  

#define TST_PORT_MSK      0x44070000
#define TST_PIN_MSK       0x000000FF

#define TST_PA_MSK        TST_PAI_MSK | TST_PAO_MSK
#define TST_PB_MSK        TST_PBI_MSK | TST_PBO_MSK
#define TST_PC_MSK        TST_PCI_MSK | TST_PCO_MSK
#define TST_PD_MSK        TST_PDI_MSK | TST_PDO_MSK
#define TST_PE_MSK        TST_PEI_MSK | TST_PEO_MSK

#define TST_PINA_MSK      TST_PAIX_MSK | TST_PAOX_MSK    
#define TST_PINB_MSK      TST_PBIX_MSK | TST_PBOX_MSK
#define TST_PINC_MSK      TST_PCIX_MSK | TST_PCOX_MSK
#define TST_PIND_MSK      TST_PDIX_MSK | TST_PDOX_MSK
#define TST_PINE_MSK      TST_PEIX_MSK | TST_PEOX_MSK


#define TST_TOTAL_PORT    5
#define TST_TOTAL_PIN     16

#define IEC60730_PORTA    0
#define IEC60730_PORTB    1
#define IEC60730_PORTC    2
#define IEC60730_PORTD    3
#define IEC60730_PORTE    4

    
#if defined(GPIOE_Base)
    #define MG32_GPIOAInit_ENMask      CONF_GPIOAInit_EN * CONF_GPIOAInit_Mask
    #define MG32_GPIOBInit_ENMask      CONF_GPIOBInit_EN * CONF_GPIOBInit_Mask
    #define MG32_GPIOCInit_ENMask      CONF_GPIOCInit_EN * CONF_GPIOCInit_Mask
    #define MG32_GPIODInit_ENMask      CONF_GPIODInit_EN * CONF_GPIODInit_Mask
    #define MG32_GPIOEInit_ENMask      CONF_GPIOEInit_EN * CONF_GPIOEInit_Mask
    #define MG32_GPIOInit_ENMask       MG32_GPIOAInit_ENMask ==0 && MG32_GPIOBInit_ENMask == 0 && MG32_GPIOCInit_ENMask == 0 &&  MG32_GPIODInit_ENMask == 0 && MG32_GPIOEInit_ENMask == 0
#else
    #define MG32_GPIOAInit_ENMask      CONF_GPIOAInit_EN * CONF_GPIOAInit_Mask
    #define MG32_GPIOBInit_ENMask      CONF_GPIOBInit_EN * CONF_GPIOBInit_Mask
    #define MG32_GPIOCInit_ENMask      CONF_GPIOCInit_EN * CONF_GPIOCInit_Mask
    #define MG32_GPIODInit_ENMask      CONF_GPIODInit_EN * CONF_GPIODInit_Mask
    #define MG32_GPIOInit_ENMask       MG32_GPIOAInit_ENMask ==0 && MG32_GPIOBInit_ENMask == 0 && MG32_GPIOCInit_ENMask == 0 &&  MG32_GPIODInit_ENMask == 0
#endif

#endif

