;******************************************************************************
;*                                                                            *
;* @file        startup_MG32.s                                            *
;*                                                                            *
;* @brief       MG32 Device vector table for MDK-ARM                      *
;*                                                                            *
;* @par         Project                                                       *
;*              MG32                                                      *
;* @version     V6.0 (Interrupt Table Date : 2023_0914)                       *
;* @date        2023/09/14 17:03 (Startup File Generated Date)                *
;* @author      StartupGen V0.21                                               *
;* @note        Copyright (c) 2023 MegaWin Technology Co., Ltd.               *
;*              All rights reserved.                                          *
;*              This module performs:                                         *
;*                  - Set the initial SP                                      *
;*                  - Set the initial PC == Reset_Handler                     *
;*                  - Set the vector table entries with ISR address           *
;*                  - Branches to __main in the C library                     *
;*                                                                            *
;* Important!   This file is generated by code generator. Do not edit!        *
;*                                                                            *
;* <<< Use Configuration Wizard in Context Menu >>>                           *
;******************************************************************************
;  @attention
; 
;  The vector table area is dummy and will update by StartupGen
;   program to generate a project startup .s file
; 
;*******************************************************************************
;
; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs
; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000200

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp                    ; Top of Stack
                DCD     MG32_IEC60730_MANAGER       ; IEC60730 MANAGER
                DCD     NMI_Handler                     ; NMI Handler
                DCD     HardFault_Handler               ; Hard Fault Handler
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     SVC_Handler                     ; SVCall Handler
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     0xFFFFFFFF                      ; Reserved
                DCD     PendSV_Handler                  ; PendSV Handler
                DCD     SysTick_Handler                 ; SysTick Handler

                ; External Interrupts
                DCD     WWDT_IRQHandler                 ;Window Watchdog interrupt
                DCD     SYS_IRQHandler                  ;System global interrupt
                DCD     0xFFFFFFFF                      ;Reserved
                DCD     EXINT0_IRQHandler               ;EXIC EXINT0 (PA) interrupt
                DCD     EXINT1_IRQHandler               ;EXIC EXINT1 (PB) interrupt
                DCD     EXINT2_IRQHandler               ;EXIC EXINT2 (PC) interrupt
                DCD     EXINT3_IRQHandler               ;EXIC EXINT3/4 (PD/PE) interrupt
                DCD     COMP_IRQHandler                 ;Analog Comparators global interrupt
                DCD     DMA_IRQHandler                  ;DMA all channel global interrupt
                DCD     OPA_IRQHandler                  ;OPA interrupt
                DCD     ADC_IRQHandler                  ;ADC interrupt
                DCD     DAC_IRQHandler                  ;DAC interrupt
                DCD     TM0x_IRQHandler                 ;Timer TM0x global interrupt
                DCD     TM10_IRQHandler                 ;Timer TM10 interrupt
                DCD     TM1x_IRQHandler                 ;Timer TM16 TM1x global interrupt
                DCD     TM20_IRQHandler                 ;Timer TM20 interrupt
                DCD     TM2x_IRQHandler                 ;Timer TM26 TM2x global interrupt
                DCD     TM3x_IRQHandler                 ;Timer TM3x global interrupt
                DCD     0xFFFFFFFF                      ;Reserved
                DCD     LCD_IRQHandler                  ;LCD interrupt
                DCD     URT0_IRQHandler                 ;UART URT0 interrupt
                DCD     URT123_IRQHandler               ;UART URT1/2/3 global interrupt
                DCD     URT4x_IRQHandler                ;UART URT4/5/6/7 global interrupt
                DCD     0xFFFFFFFF                      ;Reserved
                DCD     SPI0_IRQHandler                 ;SPI0 interrupt
                DCD     0xFFFFFFFF                      ;Reserved
                DCD     0xFFFFFFFF                      ;Reserved
                DCD     CAN0_IRQHandler                 ;CAN0 interrupt
                DCD     I2C0_IRQHandler                 ;I2C0 interrupt
                DCD     I2Cx_IRQHandler                 ;I2C1 I2Cx global interrupt
                DCD     USB_IRQHandler                  ;USB interrupt
                DCD     APX_IRQHandler                  ;APX interrupt

__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY

; IEC60730 handler routine
MG32_IEC60730_MANAGER     PROC
                EXPORT  MG32_IEC60730_MANAGER       [WEAK]
                ENDP
ReInitial_Stack PROC
                EXPORT  ReInitial_Stack                 [WEAK]
                ; reload SP pointer 
                MOVS    R0, #0x00
                LDR     R1, [R0]
                MOV     R13, R1
                ENDP

; Reset handler routine
Reset_Handler    PROC
                 EXPORT  Reset_Handler                  [WEAK]
        IMPORT  __main
        IMPORT  SystemInit
                 LDR     R0, =SystemInit
                 BLX     R0
                 LDR     R0, =__main
                 BX      R0
                 ENDP

; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler                     [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler               [WEAK]
                IMPORT  HardFault_Handler_C
                MOVS    r0, #4
                MOV     r1, LR
                TST     r0, r1
                BEQ     stacking_used_MSP
                MRS     R0, PSP                         ; first parameter - stacking was using PSP
                B       get_LR_and_branch
stacking_used_MSP
                MRS     R0, MSP                         ; first parameter - stacking was using MSP
get_LR_and_branch
                MOV     R1, LR                          ; second parameter is LR current value
                LDR     R2,=HardFault_Handler_C
                BX      R2
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler                     [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler                  [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler                 [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  WWDT_IRQHandler                 [WEAK]
                EXPORT  SYS_IRQHandler                  [WEAK]
                EXPORT  EXINT0_IRQHandler               [WEAK]
                EXPORT  EXINT1_IRQHandler               [WEAK]
                EXPORT  EXINT2_IRQHandler               [WEAK]
                EXPORT  EXINT3_IRQHandler               [WEAK]
                EXPORT  COMP_IRQHandler                 [WEAK]
                EXPORT  DMA_IRQHandler                  [WEAK]
                EXPORT  OPA_IRQHandler                  [WEAK]
                EXPORT  ADC_IRQHandler                  [WEAK]
                EXPORT  DAC_IRQHandler                  [WEAK]
                EXPORT  TM0x_IRQHandler                 [WEAK]
                EXPORT  TM10_IRQHandler                 [WEAK]
                EXPORT  TM1x_IRQHandler                 [WEAK]
                EXPORT  TM20_IRQHandler                 [WEAK]
                EXPORT  TM2x_IRQHandler                 [WEAK]
                EXPORT  TM3x_IRQHandler                 [WEAK]
                EXPORT  LCD_IRQHandler                  [WEAK]
                EXPORT  URT0_IRQHandler                 [WEAK]
                EXPORT  URT123_IRQHandler               [WEAK]
                EXPORT  URT4x_IRQHandler                [WEAK]
                EXPORT  SPI0_IRQHandler                 [WEAK]
                EXPORT  CAN0_IRQHandler                 [WEAK]
                EXPORT  I2C0_IRQHandler                 [WEAK]
                EXPORT  I2Cx_IRQHandler                 [WEAK]
                EXPORT  USB_IRQHandler                  [WEAK]
                EXPORT  APX_IRQHandler                  [WEAK]


WWDT_IRQHandler
SYS_IRQHandler
EXINT0_IRQHandler
EXINT1_IRQHandler
EXINT2_IRQHandler
EXINT3_IRQHandler
COMP_IRQHandler
DMA_IRQHandler
OPA_IRQHandler
ADC_IRQHandler
DAC_IRQHandler
TM0x_IRQHandler
TM10_IRQHandler
TM1x_IRQHandler
TM20_IRQHandler
TM2x_IRQHandler
TM3x_IRQHandler
LCD_IRQHandler
URT0_IRQHandler
URT123_IRQHandler
URT4x_IRQHandler
SPI0_IRQHandler
CAN0_IRQHandler
I2C0_IRQHandler
I2Cx_IRQHandler
USB_IRQHandler
APX_IRQHandler

                B       .

                ENDP

                ALIGN

;*******************************************************************************
; User Stack and Heap initialization
;*******************************************************************************
                 IF      :DEF:__MICROLIB

                 EXPORT  __initial_sp
                 EXPORT  __heap_base
                 EXPORT  __heap_limit

                 ELSE

                 IMPORT  __use_two_region_memory
                 EXPORT  __user_initial_stackheap

__user_initial_stackheap

                 LDR     R0, =  Heap_Mem
                 LDR     R1, =(Stack_Mem + Stack_Size)
                 LDR     R2, = (Heap_Mem +  Heap_Size)
                 LDR     R3, = Stack_Mem
                 BX      LR

                 ALIGN

                 ENDIF

                 END

;************************ End of file ************************

