/**
 ******************************************************************************
 *
 * @file        MG32_APB.h
 *
 * @brief       MG32 APB Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.04 (Register File Date : 2025_1014)
 * @date        2026/01/05 10:06 (H File Generated Date)
 * @author      HeadCodeGen V1.61
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_APB_H
#define _MG32_APB_H
#define _MG32_APB_H_VER                             104     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_APB_H_VER)
    #error "_MG32_APB_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      APB_Struct
 *              APB  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :8;     //[7..0] 
            __IO uint8_t  OBM0F         :1;     //[8] OBM-0 break trigger event detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  OBM1F         :1;     //[9] OBM-1 break trigger event detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  NCO0F         :1;     //[12] NCO-0 adder overflow event detect interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :3;     //[15..13] 
            __I  uint8_t  OBM0_OUT      :1;     //[16] OBM-0 output signal status.
            __I  uint8_t  OBM1_OUT      :1;     //[17] OBM-1 output signal status.
            __I  uint8_t                :2;     //[19..18] 
            __I  uint8_t  NCO0_OUT      :1;     //[20] NCO-0 output status bit.
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t  OBM0_SW       :1;     //[24] OBM-0 break switching signal status.
            __I  uint8_t  OBM1_SW       :1;     //[25] OBM-1 break switching signal status.
            __I  uint8_t                :2;     //[27..26] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  APB status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] APB interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  OBM0_IE       :1;     //[8] OBM-0 break trigger event detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OBM1_IE       :1;     //[9] OBM-1 break trigger event detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  NCO0_IE       :1;     //[12] NCO-0 adder overflow event detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[15..13] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  APB interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :3;     //[2..0] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  IRCLK_INV     :1;     //[4] IR clock signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  IRDAT_INV     :1;     //[5] IR data envelope signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  IRCLK_MUX     :4;     //[11..8] IR carrier clock source select.
                                        //0x0 = CLK0 : Output 0
                                        //0x1 = CLK1
                                        //0x2 = CLK2
                                        //0x3 = CLK3
                                        //0x4 = CLK4
                                        //0x5 = CLK5
                                        //0x6 = CLK6
                                        //0x7 = CLK7
                                        //0x8 = CLK8
                                        //0x9 = CLK9
                                        //0xA = CLK10
                                        //0xB = CLK11
                                        //0xC = CLK12
                                        //0xD = CLK13
                                        //0xE = CLK14
                                        //0xF = CLK15
            __IO uint8_t  IRDAT_MUX     :4;     //[15..12] IR data envelope signal source select.
                                        //0x0 = DAT0 : Output 0
                                        //0x1 = DAT1
                                        //0x2 = DAT2
                                        //0x3 = DAT3
                                        //0x4 = DAT4
                                        //0x5 = DAT5
                                        //0x6 = DAT6
                                        //0x7 = DAT7
                                        //0x8 = DAT8
                                        //0x9 = DAT9
                                        //0xA = DAT10
                                        //0xB = DAT11
                                        //0xC = DAT12
                                        //0xD = DAT13
                                        //0xE = DAT14
                                        //0xF = DAT15
            __IO uint8_t  GPR           :8;     //[23..16] General purpose data register bits.
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  APB global control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __O  uint8_t  TM00_EN       :1;     //[0] TM00 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __O  uint8_t  TM01_EN       :1;     //[1] TM01 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __O  uint8_t  TM10_EN       :1;     //[4] TM10 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :2;     //[6..5] 
            __O  uint8_t  TM16_EN       :1;     //[7] TM16 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __O  uint8_t  TM20_EN       :1;     //[8] TM20 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __O  uint8_t  TM26_EN       :1;     //[11] TM26 main Timer/Counter enable bit.
                                        //0 =No : No effect
                                        //1 = Enable
            __I  uint8_t                :3;     //[14..12] 
            __O  uint8_t  TM36_EN       :1;     //[15] TM36 main Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __O  uint8_t  TM00_EN2      :1;     //[16] TM00 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __O  uint8_t  TM01_EN2      :1;     //[17] TM01 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :2;     //[19..18] 
            __O  uint8_t  TM10_EN2      :1;     //[20] TM10 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :2;     //[22..21] 
            __O  uint8_t  TM16_EN2      :1;     //[23] TM16 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __O  uint8_t  TM20_EN2      :1;     //[24] TM20 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[25] 
            __I  uint8_t                :1;     //[26] 
            __O  uint8_t  TM26_EN2      :1;     //[27] TM26 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
            __I  uint8_t                :3;     //[30..28] 
            __O  uint8_t  TM36_EN2      :1;     //[31] TM36 2nd Timer/Counter enable bit.
                                        //0 = No : No effect
                                        //1 = Enable
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  APB global control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ITR6_MUX      :3;     //[2..0] Timer internal common trigger source ITR6 source select
                                        //0x0 = TRG0
                                        //0x1 = TRG1
                                        //0x2 = TRG2
                                        //0x3 = TRG3
                                        //0x4 = TRG4
                                        //0x5 = TRG5
                                        //0x6 = TRG6
                                        //0x7 = TRG7
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  ITR7_MUX      :4;     //[7..4] Timer internal common trigger source ITR7 source select
                                        //0x0 = TRG0
                                        //0x1 = TRG1
                                        //0x2 = TRG2
                                        //0x3 = TRG3
                                        //0x4 = TRG4
                                        //0x5 = TRG5
                                        //0x6 = TRG6
                                        //0x7 = TRG7
                                        //0x8 = TRG8
                                        //0x9 = TRG9
                                        //0xA = TRG10
                                        //0xB = TRG11
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  MF0_INV       :1;     //[16] MF_S0 output signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MF1_INV       :1;     //[17] MF_S1 output signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[23..18] 
            __IO uint8_t  MF0_MUX       :3;     //[26..24] MF_S0 signal source select.
                                        //0x0 = SIG0 : URT0_NSS (master SPI NSS output)
                                        //0x1 = SIG1 : URT0_BRO
                                        //0x2 = SIG2 : URT0_DE
                                        //0x3 = SIG3 : URT0_RTS
                                        //0x4 = SIG4 : Reserved (USB_S0)
                                        //0x5 = SIG5 : CAN0_S0
                                        //0x6 = SIG6 : LCD_S0
                                        //0x7 = SIG7 : Reserved
            __I  uint8_t                :1;     //[27] 
            __IO uint8_t  MF1_MUX       :3;     //[30..28] MF_S1 signal source select.
                                        //0x0 = SIG0 : URT1_NSS (master SPI NSS output)
                                        //0x1 = SIG1 : URT1_BRO
                                        //0x2 = SIG2 : URT1_DE
                                        //0x3 = SIG3 : URT1_RTS
                                        //0x4 = SIG4 : Reserved (USB_S1)
                                        //0x5 = SIG5 : CAN0_S1
                                        //0x6 = SIG6 : LCD_S1
                                        //0x7 = SIG7 : Reserved
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  APB global control register 2 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x1C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OBM0_MDS      :2;     //[1..0] OBM0 break operation mode select
                                        //0x0 = AND : AND signal of all break channels' output
                                        //0x1 = CLR : STA bit is cleared by falling edge of OR signal
                                        //0x2 = SET : STA bit is set by falling edge of OR signal
                                        //0x3 = TOGGLE : STA bit is toggle by falling edge of OR signal
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  OBM0_STA      :1;     //[4] OBM0 break switching signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OBM0_LCK      :1;     //[5] OBM0 break switching signal initial state write control
                                        //0 = Locked
                                        //1 = Un-Locked
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  OBM0_BKN0     :1;     //[8] OBM0 break source-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM0_BKN1     :1;     //[9] OBM0 break source-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM0_BKN2     :1;     //[10] OBM0 break source-2 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  OBM0_BKS0     :4;     //[19..16] OBM0 break signal source channel-0 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  OBM0_BKS1     :4;     //[23..20] OBM0 break signal source channel-1 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  OBM0_BKS2     :4;     //[27..24] OBM0 break signal source channel-2 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }OBM00;                             /*!< OBM00      ~ Offset[0x20]  APB OBM0 control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OBM0_INV0     :1;     //[0] OBM0 source channel-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM0_INV1     :1;     //[1] OBM0 source channel-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM0_POL      :1;     //[2] OBM0 output signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  OBM0_FCKS     :2;     //[5..4] OBM0 output deglitch filter clock source select
                                        //0x0 = Disable
                                        //0x1 = APB : CLK_APB
                                        //0x2 = APB_DIV8 : CLK_APB divide by 8
                                        //0x3 = TM00_TRGO
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  OBM0_MUX0     :4;     //[19..16] OBM0 output source channel-0 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __IO uint8_t  OBM0_MUX1     :4;     //[23..20] OBM0 output source channel-1 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OBM01;                             /*!< OBM01      ~ Offset[0x24]  APB OBM0 control register-1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OBM1_MDS      :2;     //[1..0] OBM1 break operation mode select
                                        //0x0 = AND : AND signal of all break channels' output
                                        //0x1 = CLR : STA bit is cleared by falling edge of OR signal
                                        //0x2 = SET : STA bit is set by falling edge of OR signal
                                        //0x3 = TOGGLE : STA bit is toggle by falling edge of OR signal
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  OBM1_STA      :1;     //[4] OBM1 break switching signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OBM1_LCK      :1;     //[5] OBM1 break switching signal initial state write control
                                        //0 = Locked
                                        //1 = Un-Locked
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  OBM1_BKN0     :1;     //[8] OBM1 break source-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM1_BKN1     :1;     //[9] OBM1 break source-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM1_BKN2     :1;     //[10] OBM1 break source-2 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  OBM1_BKS0     :4;     //[19..16] OBM1 break signal source channel-0 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  OBM1_BKS1     :4;     //[23..20] OBM1 break signal source channel-1 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __IO uint8_t  OBM1_BKS2     :4;     //[27..24] OBM1 break signal source channel-2 select.
                                        //0x0 = BK0 : Output 1
                                        //0x1 = BK1
                                        //0x2 = BK2
                                        //0x3 = BK3
                                        //0x4 = BK4
                                        //0x5 = BK5
                                        //0x6 = BK6
                                        //0x7 = BK7
                                        //0x8 = BK8
                                        //0x9 = BK9
                                        //0xA = BK10
                                        //0xB = BK11
                                        //0xC = BK12
                                        //0xD = BK13
                                        //0xE = BK14
                                        //0xF = BK15
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }OBM10;                             /*!< OBM10      ~ Offset[0x28]  APB OBM1 control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OBM1_INV0     :1;     //[0] OBM1 source channel-0 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM1_INV1     :1;     //[1] OBM1 source channel-1 signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  OBM1_POL      :1;     //[2] OBM1 output signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  OBM1_FCKS     :2;     //[5..4] OBM1 output deglitch filter clock source select
                                        //0x0 = Disable
                                        //0x1 = APB : CLK_APB
                                        //0x2 = APB_DIV8 : CLK_APB divide by 8
                                        //0x3 = TM00_TRGO
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  OBM1_MUX0     :4;     //[19..16] OBM1 output source channel-0 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __IO uint8_t  OBM1_MUX1     :4;     //[23..20] OBM1 output source channel-1 signal select.
                                        //0x0 = SR0 : Output 0
                                        //0x1 = SR1
                                        //0x2 = SR2
                                        //0x3 = SR3
                                        //0x4 = SR4
                                        //0x5 = SR5
                                        //0x6 = SR6
                                        //0x7 = SR7
                                        //0x8 = SR8
                                        //0x9 = SR9
                                        //0xA = SR10
                                        //0xB = SR11
                                        //0xC = SR12
                                        //0xD = SR13
                                        //0xE = SR14
                                        //0xF = SR15
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OBM11;                             /*!< OBM11      ~ Offset[0x2C]  APB OBM1 control register-1 */

    __I uint32_t  RESERVED2[4];         /*!< RESERVED2  ~ Offset[0x30]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t NCO0_INC      :20;    //[19..0] NCO adder increment value. The register value needs to be equal or smaller than 2^19.
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  NCO0_EN       :1;     //[24] NCO enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  NCO0_INV      :1;     //[25] NCO output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NCO0_MDS      :1;     //[26] NCO output mode select
                                        //0 = FDC : fixed duty cycle mode
                                        //1 = PFM : pulse frequency mode
            __I  uint8_t                :1;     //[27] 
            __IO uint8_t  NCO0_CKS      :3;     //[30..28] NCO input clock source select.
                                        //0x0 = CK_IHRCO
                                        //0x1 = CK_PLL
                                        //0x2 = CK_APB
                                        //0x3 = CK_LS
                                        //0x4 = TM00_TRGO
                                        //0x5 = NCO_CK0
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }NCO00;                             /*!< NCO00      ~ Offset[0x40]  APB NCO0 increment register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t NCO0_ACC      :20;    //[19..0] NCO adder accumulator store data
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  NCO0_PWS      :3;     //[26..24] NCO PFM mode output pulse width select.
                                        //0x0 = CK1 : 1 CK_NCOn clock period
                                        //0x1 = CK2 : 2 CK_NCOn clock period
                                        //0x2 = CK4 : 4 CK_NCOn clock period
                                        //0x3 = CK8 : 8 CK_NCOn clock period
                                        //0x4 = CK16 : 16 CK_NCOn clock period
                                        //0x5 = CK32 : 32 CK_NCOn clock period
                                        //0x6 = CK64 : 64 CK_NCOn clock period
                                        //0x7 = CK128 : 128 CK_NCOn clock period
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }NCO01;                             /*!< NCO01      ~ Offset[0x44]  APB NCO0 accumulator register */

} APB_Struct;

/**
 ******************************************************************************
 *
 * @name        APB  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define APB_Base                        ((uint32_t)0x5F000000)              /*!< APB Module Global Control */
#define APB                             ((APB_Struct*) APB_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        APB  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        APB_STA  [register's definitions]
 *              Offset[0x00]  APB status register (0x5F000000)
 ******************************************************************************
 */
///@{
#define APB_STA_default                             ((uint32_t)0x03000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_STA */
#define APB_STA_OBM1_SW_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM1_SW_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM1_SW_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM1_SW_shift_w                     (25)                    /*!< Bit Shift of 32bit */
#define APB_STA_OBM1_SW_shift_h1                    (9)                     /*!< Bit Shift of 16bit */
#define APB_STA_OBM1_SW_shift_b3                    (1)                     /*!< Bit Shift of 8bit */

#define APB_STA_OBM0_SW_mask_w                      ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM0_SW_mask_h1                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM0_SW_mask_b3                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM0_SW_shift_w                     (24)                    /*!< Bit Shift of 32bit */
#define APB_STA_OBM0_SW_shift_h1                    (8)                     /*!< Bit Shift of 16bit */
#define APB_STA_OBM0_SW_shift_b3                    (0)                     /*!< Bit Shift of 8bit */

#define APB_STA_NCO0_OUT_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define APB_STA_NCO0_OUT_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_STA_NCO0_OUT_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_STA_NCO0_OUT_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define APB_STA_NCO0_OUT_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define APB_STA_NCO0_OUT_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define APB_STA_OBM1_OUT_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM1_OUT_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM1_OUT_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM1_OUT_shift_w                    (17)                    /*!< Bit Shift of 32bit */
#define APB_STA_OBM1_OUT_shift_h1                   (1)                     /*!< Bit Shift of 16bit */
#define APB_STA_OBM1_OUT_shift_b2                   (1)                     /*!< Bit Shift of 8bit */

#define APB_STA_OBM0_OUT_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM0_OUT_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM0_OUT_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM0_OUT_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define APB_STA_OBM0_OUT_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define APB_STA_OBM0_OUT_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define APB_STA_NCO0F_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define APB_STA_NCO0F_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define APB_STA_NCO0F_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_STA_NCO0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APB_STA_NCO0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APB_STA_NCO0F_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APB_STA_NCO0F_happened_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define APB_STA_NCO0F_happened_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define APB_STA_NCO0F_happened_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define APB_STA_OBM1F_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM1F_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM1F_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM1F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APB_STA_OBM1F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APB_STA_OBM1F_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APB_STA_OBM1F_happened_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define APB_STA_OBM1F_happened_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define APB_STA_OBM1F_happened_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define APB_STA_OBM0F_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define APB_STA_OBM0F_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_STA_OBM0F_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_STA_OBM0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APB_STA_OBM0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APB_STA_OBM0F_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APB_STA_OBM0F_happened_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define APB_STA_OBM0F_happened_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define APB_STA_OBM0F_happened_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_INT  [register's definitions]
 *              Offset[0x04]  APB interrupt enable register (0x5F000004)
 ******************************************************************************
 */
///@{
#define APB_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_INT */
#define APB_INT_NCO0_IE_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define APB_INT_NCO0_IE_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define APB_INT_NCO0_IE_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_INT_NCO0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_INT_NCO0_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_INT_NCO0_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_INT_NCO0_IE_enable_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_INT_NCO0_IE_enable_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_INT_NCO0_IE_enable_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_INT_OBM1_IE_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define APB_INT_OBM1_IE_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_INT_OBM1_IE_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_INT_OBM1_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_INT_OBM1_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_INT_OBM1_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_INT_OBM1_IE_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_INT_OBM1_IE_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_INT_OBM1_IE_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_INT_OBM0_IE_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define APB_INT_OBM0_IE_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_INT_OBM0_IE_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_INT_OBM0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_INT_OBM0_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_INT_OBM0_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_INT_OBM0_IE_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_INT_OBM0_IE_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_INT_OBM0_IE_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APB_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_CR0  [register's definitions]
 *              Offset[0x10]  APB global control register 0 (0x5F000010)
 ******************************************************************************
 */
///@{
#define APB_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_CR0 */
#define APB_CR0_GPR_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define APB_CR0_GPR_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define APB_CR0_GPR_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define APB_CR0_GPR_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define APB_CR0_GPR_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define APB_CR0_GPR_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define APB_CR0_IRDAT_MUX_mask_w                    ((uint32_t)0x0000F000)  /*!< Bit Mask of 32bit */
#define APB_CR0_IRDAT_MUX_mask_h0                   ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define APB_CR0_IRDAT_MUX_mask_b1                   ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_CR0_IRDAT_MUX_dat0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DAT0 of 32bit */
#define APB_CR0_IRDAT_MUX_dat0_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DAT0 of 16bit */
#define APB_CR0_IRDAT_MUX_dat0_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):DAT0 of 8bit */
#define APB_CR0_IRDAT_MUX_dat1_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DAT1 of 32bit */
#define APB_CR0_IRDAT_MUX_dat1_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DAT1 of 16bit */
#define APB_CR0_IRDAT_MUX_dat1_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):DAT1 of 8bit */
#define APB_CR0_IRDAT_MUX_dat2_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DAT2 of 32bit */
#define APB_CR0_IRDAT_MUX_dat2_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DAT2 of 16bit */
#define APB_CR0_IRDAT_MUX_dat2_b1                   ((uint8_t )0x20)        /*!< Bit Value =(0x2):DAT2 of 8bit */
#define APB_CR0_IRDAT_MUX_dat3_w                    ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DAT3 of 32bit */
#define APB_CR0_IRDAT_MUX_dat3_h0                   ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DAT3 of 16bit */
#define APB_CR0_IRDAT_MUX_dat3_b1                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):DAT3 of 8bit */
#define APB_CR0_IRDAT_MUX_dat4_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):DAT4 of 32bit */
#define APB_CR0_IRDAT_MUX_dat4_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(0x4):DAT4 of 16bit */
#define APB_CR0_IRDAT_MUX_dat4_b1                   ((uint8_t )0x40)        /*!< Bit Value =(0x4):DAT4 of 8bit */
#define APB_CR0_IRDAT_MUX_dat5_w                    ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):DAT5 of 32bit */
#define APB_CR0_IRDAT_MUX_dat5_h0                   ((uint16_t)0x5000)      /*!< Bit Value =(0x5):DAT5 of 16bit */
#define APB_CR0_IRDAT_MUX_dat5_b1                   ((uint8_t )0x50)        /*!< Bit Value =(0x5):DAT5 of 8bit */
#define APB_CR0_IRDAT_MUX_dat6_w                    ((uint32_t)0x00006000)  /*!< Bit Value =(0x6):DAT6 of 32bit */
#define APB_CR0_IRDAT_MUX_dat6_h0                   ((uint16_t)0x6000)      /*!< Bit Value =(0x6):DAT6 of 16bit */
#define APB_CR0_IRDAT_MUX_dat6_b1                   ((uint8_t )0x60)        /*!< Bit Value =(0x6):DAT6 of 8bit */
#define APB_CR0_IRDAT_MUX_dat7_w                    ((uint32_t)0x00007000)  /*!< Bit Value =(0x7):DAT7 of 32bit */
#define APB_CR0_IRDAT_MUX_dat7_h0                   ((uint16_t)0x7000)      /*!< Bit Value =(0x7):DAT7 of 16bit */
#define APB_CR0_IRDAT_MUX_dat7_b1                   ((uint8_t )0x70)        /*!< Bit Value =(0x7):DAT7 of 8bit */
#define APB_CR0_IRDAT_MUX_dat8_w                    ((uint32_t)0x00008000)  /*!< Bit Value =(0x8):DAT8 of 32bit */
#define APB_CR0_IRDAT_MUX_dat8_h0                   ((uint16_t)0x8000)      /*!< Bit Value =(0x8):DAT8 of 16bit */
#define APB_CR0_IRDAT_MUX_dat8_b1                   ((uint8_t )0x80)        /*!< Bit Value =(0x8):DAT8 of 8bit */
#define APB_CR0_IRDAT_MUX_dat9_w                    ((uint32_t)0x00009000)  /*!< Bit Value =(0x9):DAT9 of 32bit */
#define APB_CR0_IRDAT_MUX_dat9_h0                   ((uint16_t)0x9000)      /*!< Bit Value =(0x9):DAT9 of 16bit */
#define APB_CR0_IRDAT_MUX_dat9_b1                   ((uint8_t )0x90)        /*!< Bit Value =(0x9):DAT9 of 8bit */
#define APB_CR0_IRDAT_MUX_dat10_w                   ((uint32_t)0x0000A000)  /*!< Bit Value =(0xA):DAT10 of 32bit */
#define APB_CR0_IRDAT_MUX_dat10_h0                  ((uint16_t)0xA000)      /*!< Bit Value =(0xA):DAT10 of 16bit */
#define APB_CR0_IRDAT_MUX_dat10_b1                  ((uint8_t )0xA0)        /*!< Bit Value =(0xA):DAT10 of 8bit */
#define APB_CR0_IRDAT_MUX_dat11_w                   ((uint32_t)0x0000B000)  /*!< Bit Value =(0xB):DAT11 of 32bit */
#define APB_CR0_IRDAT_MUX_dat11_h0                  ((uint16_t)0xB000)      /*!< Bit Value =(0xB):DAT11 of 16bit */
#define APB_CR0_IRDAT_MUX_dat11_b1                  ((uint8_t )0xB0)        /*!< Bit Value =(0xB):DAT11 of 8bit */
#define APB_CR0_IRDAT_MUX_dat12_w                   ((uint32_t)0x0000C000)  /*!< Bit Value =(0xC):DAT12 of 32bit */
#define APB_CR0_IRDAT_MUX_dat12_h0                  ((uint16_t)0xC000)      /*!< Bit Value =(0xC):DAT12 of 16bit */
#define APB_CR0_IRDAT_MUX_dat12_b1                  ((uint8_t )0xC0)        /*!< Bit Value =(0xC):DAT12 of 8bit */
#define APB_CR0_IRDAT_MUX_dat13_w                   ((uint32_t)0x0000D000)  /*!< Bit Value =(0xD):DAT13 of 32bit */
#define APB_CR0_IRDAT_MUX_dat13_h0                  ((uint16_t)0xD000)      /*!< Bit Value =(0xD):DAT13 of 16bit */
#define APB_CR0_IRDAT_MUX_dat13_b1                  ((uint8_t )0xD0)        /*!< Bit Value =(0xD):DAT13 of 8bit */
#define APB_CR0_IRDAT_MUX_dat14_w                   ((uint32_t)0x0000E000)  /*!< Bit Value =(0xE):DAT14 of 32bit */
#define APB_CR0_IRDAT_MUX_dat14_h0                  ((uint16_t)0xE000)      /*!< Bit Value =(0xE):DAT14 of 16bit */
#define APB_CR0_IRDAT_MUX_dat14_b1                  ((uint8_t )0xE0)        /*!< Bit Value =(0xE):DAT14 of 8bit */
#define APB_CR0_IRDAT_MUX_dat15_w                   ((uint32_t)0x0000F000)  /*!< Bit Value =(0xF):DAT15 of 32bit */
#define APB_CR0_IRDAT_MUX_dat15_h0                  ((uint16_t)0xF000)      /*!< Bit Value =(0xF):DAT15 of 16bit */
#define APB_CR0_IRDAT_MUX_dat15_b1                  ((uint8_t )0xF0)        /*!< Bit Value =(0xF):DAT15 of 8bit */

#define APB_CR0_IRCLK_MUX_mask_w                    ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define APB_CR0_IRCLK_MUX_mask_h0                   ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APB_CR0_IRCLK_MUX_mask_b1                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_CR0_IRCLK_MUX_clk0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CLK0 of 32bit */
#define APB_CR0_IRCLK_MUX_clk0_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CLK0 of 16bit */
#define APB_CR0_IRCLK_MUX_clk0_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):CLK0 of 8bit */
#define APB_CR0_IRCLK_MUX_clk1_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CLK1 of 32bit */
#define APB_CR0_IRCLK_MUX_clk1_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CLK1 of 16bit */
#define APB_CR0_IRCLK_MUX_clk1_b1                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CLK1 of 8bit */
#define APB_CR0_IRCLK_MUX_clk2_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):CLK2 of 32bit */
#define APB_CR0_IRCLK_MUX_clk2_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CLK2 of 16bit */
#define APB_CR0_IRCLK_MUX_clk2_b1                   ((uint8_t )0x02)        /*!< Bit Value =(0x2):CLK2 of 8bit */
#define APB_CR0_IRCLK_MUX_clk3_w                    ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):CLK3 of 32bit */
#define APB_CR0_IRCLK_MUX_clk3_h0                   ((uint16_t)0x0300)      /*!< Bit Value =(0x3):CLK3 of 16bit */
#define APB_CR0_IRCLK_MUX_clk3_b1                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):CLK3 of 8bit */
#define APB_CR0_IRCLK_MUX_clk4_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):CLK4 of 32bit */
#define APB_CR0_IRCLK_MUX_clk4_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CLK4 of 16bit */
#define APB_CR0_IRCLK_MUX_clk4_b1                   ((uint8_t )0x04)        /*!< Bit Value =(0x4):CLK4 of 8bit */
#define APB_CR0_IRCLK_MUX_clk5_w                    ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):CLK5 of 32bit */
#define APB_CR0_IRCLK_MUX_clk5_h0                   ((uint16_t)0x0500)      /*!< Bit Value =(0x5):CLK5 of 16bit */
#define APB_CR0_IRCLK_MUX_clk5_b1                   ((uint8_t )0x05)        /*!< Bit Value =(0x5):CLK5 of 8bit */
#define APB_CR0_IRCLK_MUX_clk6_w                    ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):CLK6 of 32bit */
#define APB_CR0_IRCLK_MUX_clk6_h0                   ((uint16_t)0x0600)      /*!< Bit Value =(0x6):CLK6 of 16bit */
#define APB_CR0_IRCLK_MUX_clk6_b1                   ((uint8_t )0x06)        /*!< Bit Value =(0x6):CLK6 of 8bit */
#define APB_CR0_IRCLK_MUX_clk7_w                    ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):CLK7 of 32bit */
#define APB_CR0_IRCLK_MUX_clk7_h0                   ((uint16_t)0x0700)      /*!< Bit Value =(0x7):CLK7 of 16bit */
#define APB_CR0_IRCLK_MUX_clk7_b1                   ((uint8_t )0x07)        /*!< Bit Value =(0x7):CLK7 of 8bit */
#define APB_CR0_IRCLK_MUX_clk8_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):CLK8 of 32bit */
#define APB_CR0_IRCLK_MUX_clk8_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(0x8):CLK8 of 16bit */
#define APB_CR0_IRCLK_MUX_clk8_b1                   ((uint8_t )0x08)        /*!< Bit Value =(0x8):CLK8 of 8bit */
#define APB_CR0_IRCLK_MUX_clk9_w                    ((uint32_t)0x00000900)  /*!< Bit Value =(0x9):CLK9 of 32bit */
#define APB_CR0_IRCLK_MUX_clk9_h0                   ((uint16_t)0x0900)      /*!< Bit Value =(0x9):CLK9 of 16bit */
#define APB_CR0_IRCLK_MUX_clk9_b1                   ((uint8_t )0x09)        /*!< Bit Value =(0x9):CLK9 of 8bit */
#define APB_CR0_IRCLK_MUX_clk10_w                   ((uint32_t)0x00000A00)  /*!< Bit Value =(0xA):CLK10 of 32bit */
#define APB_CR0_IRCLK_MUX_clk10_h0                  ((uint16_t)0x0A00)      /*!< Bit Value =(0xA):CLK10 of 16bit */
#define APB_CR0_IRCLK_MUX_clk10_b1                  ((uint8_t )0x0A)        /*!< Bit Value =(0xA):CLK10 of 8bit */
#define APB_CR0_IRCLK_MUX_clk11_w                   ((uint32_t)0x00000B00)  /*!< Bit Value =(0xB):CLK11 of 32bit */
#define APB_CR0_IRCLK_MUX_clk11_h0                  ((uint16_t)0x0B00)      /*!< Bit Value =(0xB):CLK11 of 16bit */
#define APB_CR0_IRCLK_MUX_clk11_b1                  ((uint8_t )0x0B)        /*!< Bit Value =(0xB):CLK11 of 8bit */
#define APB_CR0_IRCLK_MUX_clk12_w                   ((uint32_t)0x00000C00)  /*!< Bit Value =(0xC):CLK12 of 32bit */
#define APB_CR0_IRCLK_MUX_clk12_h0                  ((uint16_t)0x0C00)      /*!< Bit Value =(0xC):CLK12 of 16bit */
#define APB_CR0_IRCLK_MUX_clk12_b1                  ((uint8_t )0x0C)        /*!< Bit Value =(0xC):CLK12 of 8bit */
#define APB_CR0_IRCLK_MUX_clk13_w                   ((uint32_t)0x00000D00)  /*!< Bit Value =(0xD):CLK13 of 32bit */
#define APB_CR0_IRCLK_MUX_clk13_h0                  ((uint16_t)0x0D00)      /*!< Bit Value =(0xD):CLK13 of 16bit */
#define APB_CR0_IRCLK_MUX_clk13_b1                  ((uint8_t )0x0D)        /*!< Bit Value =(0xD):CLK13 of 8bit */
#define APB_CR0_IRCLK_MUX_clk14_w                   ((uint32_t)0x00000E00)  /*!< Bit Value =(0xE):CLK14 of 32bit */
#define APB_CR0_IRCLK_MUX_clk14_h0                  ((uint16_t)0x0E00)      /*!< Bit Value =(0xE):CLK14 of 16bit */
#define APB_CR0_IRCLK_MUX_clk14_b1                  ((uint8_t )0x0E)        /*!< Bit Value =(0xE):CLK14 of 8bit */
#define APB_CR0_IRCLK_MUX_clk15_w                   ((uint32_t)0x00000F00)  /*!< Bit Value =(0xF):CLK15 of 32bit */
#define APB_CR0_IRCLK_MUX_clk15_h0                  ((uint16_t)0x0F00)      /*!< Bit Value =(0xF):CLK15 of 16bit */
#define APB_CR0_IRCLK_MUX_clk15_b1                  ((uint8_t )0x0F)        /*!< Bit Value =(0xF):CLK15 of 8bit */

#define APB_CR0_IRDAT_INV_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define APB_CR0_IRDAT_INV_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define APB_CR0_IRDAT_INV_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define APB_CR0_IRDAT_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_CR0_IRDAT_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_CR0_IRDAT_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_CR0_IRDAT_INV_enable_w                  ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR0_IRDAT_INV_enable_h0                 ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR0_IRDAT_INV_enable_b0                 ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR0_IRCLK_INV_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define APB_CR0_IRCLK_INV_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_CR0_IRCLK_INV_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_CR0_IRCLK_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_CR0_IRCLK_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_CR0_IRCLK_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_CR0_IRCLK_INV_enable_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR0_IRCLK_INV_enable_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR0_IRCLK_INV_enable_b0                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_CR1  [register's definitions]
 *              Offset[0x14]  APB global control register 1 (0x5F000014)
 ******************************************************************************
 */
///@{
#define APB_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_CR1 */
#define APB_CR1_TM36_EN2_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM36_EN2_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM36_EN2_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM36_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM36_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM36_EN2_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM36_EN2_enable_w                   ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM36_EN2_enable_h1                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM36_EN2_enable_b3                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM26_EN2_mask_w                     ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM26_EN2_mask_h1                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM26_EN2_mask_b3                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM26_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM26_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM26_EN2_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM26_EN2_enable_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM26_EN2_enable_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM26_EN2_enable_b3                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM20_EN2_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM20_EN2_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM20_EN2_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM20_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM20_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM20_EN2_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM20_EN2_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM20_EN2_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM20_EN2_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM16_EN2_mask_w                     ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM16_EN2_mask_h1                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM16_EN2_mask_b2                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM16_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM16_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM16_EN2_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM16_EN2_enable_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM16_EN2_enable_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM16_EN2_enable_b2                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM10_EN2_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM10_EN2_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM10_EN2_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM10_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM10_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM10_EN2_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM10_EN2_enable_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM10_EN2_enable_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM10_EN2_enable_b2                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM01_EN2_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM01_EN2_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM01_EN2_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM01_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM01_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM01_EN2_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM01_EN2_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM01_EN2_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM01_EN2_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM00_EN2_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM00_EN2_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM00_EN2_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM00_EN2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM00_EN2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM00_EN2_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM00_EN2_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM00_EN2_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM00_EN2_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM36_EN_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM36_EN_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM36_EN_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM36_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM36_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM36_EN_no_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM36_EN_enable_w                    ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM36_EN_enable_h0                   ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM36_EN_enable_b1                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM26_EN_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM26_EN_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM26_EN_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM26_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM26_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM26_EN_no_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM26_EN_enable_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM26_EN_enable_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM26_EN_enable_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM20_EN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM20_EN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM20_EN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM20_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM20_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM20_EN_no_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM20_EN_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM20_EN_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM20_EN_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM16_EN_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM16_EN_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM16_EN_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM16_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM16_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM16_EN_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM16_EN_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM16_EN_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM16_EN_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM10_EN_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM10_EN_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM10_EN_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM10_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM10_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM10_EN_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM10_EN_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM10_EN_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM10_EN_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM01_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM01_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM01_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM01_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM01_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM01_EN_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM01_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM01_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM01_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR1_TM00_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APB_CR1_TM00_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_CR1_TM00_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_CR1_TM00_EN_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define APB_CR1_TM00_EN_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define APB_CR1_TM00_EN_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define APB_CR1_TM00_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR1_TM00_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR1_TM00_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_CR2  [register's definitions]
 *              Offset[0x18]  APB global control register 2 (0x5F000018)
 ******************************************************************************
 */
///@{
#define APB_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_CR2 */
#define APB_CR2_MF1_MUX_mask_w                      ((uint32_t)0x70000000)  /*!< Bit Mask of 32bit */
#define APB_CR2_MF1_MUX_mask_h1                     ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define APB_CR2_MF1_MUX_mask_b3                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define APB_CR2_MF1_MUX_sig0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SIG0 of 32bit */
#define APB_CR2_MF1_MUX_sig0_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SIG0 of 16bit */
#define APB_CR2_MF1_MUX_sig0_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):SIG0 of 8bit */
#define APB_CR2_MF1_MUX_sig1_w                      ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):SIG1 of 32bit */
#define APB_CR2_MF1_MUX_sig1_h1                     ((uint16_t)0x1000)      /*!< Bit Value =(0x1):SIG1 of 16bit */
#define APB_CR2_MF1_MUX_sig1_b3                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):SIG1 of 8bit */
#define APB_CR2_MF1_MUX_sig2_w                      ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):SIG2 of 32bit */
#define APB_CR2_MF1_MUX_sig2_h1                     ((uint16_t)0x2000)      /*!< Bit Value =(0x2):SIG2 of 16bit */
#define APB_CR2_MF1_MUX_sig2_b3                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):SIG2 of 8bit */
#define APB_CR2_MF1_MUX_sig3_w                      ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):SIG3 of 32bit */
#define APB_CR2_MF1_MUX_sig3_h1                     ((uint16_t)0x3000)      /*!< Bit Value =(0x3):SIG3 of 16bit */
#define APB_CR2_MF1_MUX_sig3_b3                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):SIG3 of 8bit */
#define APB_CR2_MF1_MUX_sig4_w                      ((uint32_t)0x40000000)  /*!< Bit Value =(0x4):SIG4 of 32bit */
#define APB_CR2_MF1_MUX_sig4_h1                     ((uint16_t)0x4000)      /*!< Bit Value =(0x4):SIG4 of 16bit */
#define APB_CR2_MF1_MUX_sig4_b3                     ((uint8_t )0x40)        /*!< Bit Value =(0x4):SIG4 of 8bit */
#define APB_CR2_MF1_MUX_sig5_w                      ((uint32_t)0x50000000)  /*!< Bit Value =(0x5):SIG5 of 32bit */
#define APB_CR2_MF1_MUX_sig5_h1                     ((uint16_t)0x5000)      /*!< Bit Value =(0x5):SIG5 of 16bit */
#define APB_CR2_MF1_MUX_sig5_b3                     ((uint8_t )0x50)        /*!< Bit Value =(0x5):SIG5 of 8bit */
#define APB_CR2_MF1_MUX_sig6_w                      ((uint32_t)0x60000000)  /*!< Bit Value =(0x6):SIG6 of 32bit */
#define APB_CR2_MF1_MUX_sig6_h1                     ((uint16_t)0x6000)      /*!< Bit Value =(0x6):SIG6 of 16bit */
#define APB_CR2_MF1_MUX_sig6_b3                     ((uint8_t )0x60)        /*!< Bit Value =(0x6):SIG6 of 8bit */
#define APB_CR2_MF1_MUX_sig7_w                      ((uint32_t)0x70000000)  /*!< Bit Value =(0x7):SIG7 of 32bit */
#define APB_CR2_MF1_MUX_sig7_h1                     ((uint16_t)0x7000)      /*!< Bit Value =(0x7):SIG7 of 16bit */
#define APB_CR2_MF1_MUX_sig7_b3                     ((uint8_t )0x70)        /*!< Bit Value =(0x7):SIG7 of 8bit */

#define APB_CR2_MF0_MUX_mask_w                      ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define APB_CR2_MF0_MUX_mask_h1                     ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define APB_CR2_MF0_MUX_mask_b3                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define APB_CR2_MF0_MUX_sig0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SIG0 of 32bit */
#define APB_CR2_MF0_MUX_sig0_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SIG0 of 16bit */
#define APB_CR2_MF0_MUX_sig0_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):SIG0 of 8bit */
#define APB_CR2_MF0_MUX_sig1_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):SIG1 of 32bit */
#define APB_CR2_MF0_MUX_sig1_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):SIG1 of 16bit */
#define APB_CR2_MF0_MUX_sig1_b3                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):SIG1 of 8bit */
#define APB_CR2_MF0_MUX_sig2_w                      ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):SIG2 of 32bit */
#define APB_CR2_MF0_MUX_sig2_h1                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):SIG2 of 16bit */
#define APB_CR2_MF0_MUX_sig2_b3                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):SIG2 of 8bit */
#define APB_CR2_MF0_MUX_sig3_w                      ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):SIG3 of 32bit */
#define APB_CR2_MF0_MUX_sig3_h1                     ((uint16_t)0x0300)      /*!< Bit Value =(0x3):SIG3 of 16bit */
#define APB_CR2_MF0_MUX_sig3_b3                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):SIG3 of 8bit */
#define APB_CR2_MF0_MUX_sig4_w                      ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):SIG4 of 32bit */
#define APB_CR2_MF0_MUX_sig4_h1                     ((uint16_t)0x0400)      /*!< Bit Value =(0x4):SIG4 of 16bit */
#define APB_CR2_MF0_MUX_sig4_b3                     ((uint8_t )0x04)        /*!< Bit Value =(0x4):SIG4 of 8bit */
#define APB_CR2_MF0_MUX_sig5_w                      ((uint32_t)0x05000000)  /*!< Bit Value =(0x5):SIG5 of 32bit */
#define APB_CR2_MF0_MUX_sig5_h1                     ((uint16_t)0x0500)      /*!< Bit Value =(0x5):SIG5 of 16bit */
#define APB_CR2_MF0_MUX_sig5_b3                     ((uint8_t )0x05)        /*!< Bit Value =(0x5):SIG5 of 8bit */
#define APB_CR2_MF0_MUX_sig6_w                      ((uint32_t)0x06000000)  /*!< Bit Value =(0x6):SIG6 of 32bit */
#define APB_CR2_MF0_MUX_sig6_h1                     ((uint16_t)0x0600)      /*!< Bit Value =(0x6):SIG6 of 16bit */
#define APB_CR2_MF0_MUX_sig6_b3                     ((uint8_t )0x06)        /*!< Bit Value =(0x6):SIG6 of 8bit */
#define APB_CR2_MF0_MUX_sig7_w                      ((uint32_t)0x07000000)  /*!< Bit Value =(0x7):SIG7 of 32bit */
#define APB_CR2_MF0_MUX_sig7_h1                     ((uint16_t)0x0700)      /*!< Bit Value =(0x7):SIG7 of 16bit */
#define APB_CR2_MF0_MUX_sig7_b3                     ((uint8_t )0x07)        /*!< Bit Value =(0x7):SIG7 of 8bit */

#define APB_CR2_MF1_INV_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define APB_CR2_MF1_INV_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_CR2_MF1_INV_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_CR2_MF1_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_CR2_MF1_INV_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_CR2_MF1_INV_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_CR2_MF1_INV_enable_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR2_MF1_INV_enable_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR2_MF1_INV_enable_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR2_MF0_INV_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define APB_CR2_MF0_INV_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_CR2_MF0_INV_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_CR2_MF0_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_CR2_MF0_INV_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_CR2_MF0_INV_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_CR2_MF0_INV_enable_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_CR2_MF0_INV_enable_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_CR2_MF0_INV_enable_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_CR2_ITR7_MUX_mask_w                     ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define APB_CR2_ITR7_MUX_mask_h0                    ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APB_CR2_ITR7_MUX_mask_b0                    ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_CR2_ITR7_MUX_trg0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define APB_CR2_ITR7_MUX_trg0_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define APB_CR2_ITR7_MUX_trg0_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define APB_CR2_ITR7_MUX_trg1_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define APB_CR2_ITR7_MUX_trg1_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define APB_CR2_ITR7_MUX_trg1_b0                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):TRG1 of 8bit */
#define APB_CR2_ITR7_MUX_trg2_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):TRG2 of 32bit */
#define APB_CR2_ITR7_MUX_trg2_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):TRG2 of 16bit */
#define APB_CR2_ITR7_MUX_trg2_b0                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):TRG2 of 8bit */
#define APB_CR2_ITR7_MUX_trg3_w                     ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):TRG3 of 32bit */
#define APB_CR2_ITR7_MUX_trg3_h0                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):TRG3 of 16bit */
#define APB_CR2_ITR7_MUX_trg3_b0                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):TRG3 of 8bit */
#define APB_CR2_ITR7_MUX_trg4_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):TRG4 of 32bit */
#define APB_CR2_ITR7_MUX_trg4_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(0x4):TRG4 of 16bit */
#define APB_CR2_ITR7_MUX_trg4_b0                    ((uint8_t )0x40)        /*!< Bit Value =(0x4):TRG4 of 8bit */
#define APB_CR2_ITR7_MUX_trg5_w                     ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):TRG5 of 32bit */
#define APB_CR2_ITR7_MUX_trg5_h0                    ((uint16_t)0x0050)      /*!< Bit Value =(0x5):TRG5 of 16bit */
#define APB_CR2_ITR7_MUX_trg5_b0                    ((uint8_t )0x50)        /*!< Bit Value =(0x5):TRG5 of 8bit */
#define APB_CR2_ITR7_MUX_trg6_w                     ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):TRG6 of 32bit */
#define APB_CR2_ITR7_MUX_trg6_h0                    ((uint16_t)0x0060)      /*!< Bit Value =(0x6):TRG6 of 16bit */
#define APB_CR2_ITR7_MUX_trg6_b0                    ((uint8_t )0x60)        /*!< Bit Value =(0x6):TRG6 of 8bit */
#define APB_CR2_ITR7_MUX_trg7_w                     ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):TRG7 of 32bit */
#define APB_CR2_ITR7_MUX_trg7_h0                    ((uint16_t)0x0070)      /*!< Bit Value =(0x7):TRG7 of 16bit */
#define APB_CR2_ITR7_MUX_trg7_b0                    ((uint8_t )0x70)        /*!< Bit Value =(0x7):TRG7 of 8bit */
#define APB_CR2_ITR7_MUX_trg8_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(0x8):TRG8 of 32bit */
#define APB_CR2_ITR7_MUX_trg8_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(0x8):TRG8 of 16bit */
#define APB_CR2_ITR7_MUX_trg8_b0                    ((uint8_t )0x80)        /*!< Bit Value =(0x8):TRG8 of 8bit */
#define APB_CR2_ITR7_MUX_trg9_w                     ((uint32_t)0x00000090)  /*!< Bit Value =(0x9):TRG9 of 32bit */
#define APB_CR2_ITR7_MUX_trg9_h0                    ((uint16_t)0x0090)      /*!< Bit Value =(0x9):TRG9 of 16bit */
#define APB_CR2_ITR7_MUX_trg9_b0                    ((uint8_t )0x90)        /*!< Bit Value =(0x9):TRG9 of 8bit */
#define APB_CR2_ITR7_MUX_trg10_w                    ((uint32_t)0x000000A0)  /*!< Bit Value =(0xA):TRG10 of 32bit */
#define APB_CR2_ITR7_MUX_trg10_h0                   ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):TRG10 of 16bit */
#define APB_CR2_ITR7_MUX_trg10_b0                   ((uint8_t )0xA0)        /*!< Bit Value =(0xA):TRG10 of 8bit */
#define APB_CR2_ITR7_MUX_trg11_w                    ((uint32_t)0x000000B0)  /*!< Bit Value =(0xB):TRG11 of 32bit */
#define APB_CR2_ITR7_MUX_trg11_h0                   ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):TRG11 of 16bit */
#define APB_CR2_ITR7_MUX_trg11_b0                   ((uint8_t )0xB0)        /*!< Bit Value =(0xB):TRG11 of 8bit */

#define APB_CR2_ITR6_MUX_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define APB_CR2_ITR6_MUX_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define APB_CR2_ITR6_MUX_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define APB_CR2_ITR6_MUX_trg0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define APB_CR2_ITR6_MUX_trg0_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define APB_CR2_ITR6_MUX_trg0_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define APB_CR2_ITR6_MUX_trg1_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define APB_CR2_ITR6_MUX_trg1_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define APB_CR2_ITR6_MUX_trg1_b0                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):TRG1 of 8bit */
#define APB_CR2_ITR6_MUX_trg2_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):TRG2 of 32bit */
#define APB_CR2_ITR6_MUX_trg2_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(0x2):TRG2 of 16bit */
#define APB_CR2_ITR6_MUX_trg2_b0                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):TRG2 of 8bit */
#define APB_CR2_ITR6_MUX_trg3_w                     ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):TRG3 of 32bit */
#define APB_CR2_ITR6_MUX_trg3_h0                    ((uint16_t)0x0003)      /*!< Bit Value =(0x3):TRG3 of 16bit */
#define APB_CR2_ITR6_MUX_trg3_b0                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):TRG3 of 8bit */
#define APB_CR2_ITR6_MUX_trg4_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):TRG4 of 32bit */
#define APB_CR2_ITR6_MUX_trg4_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(0x4):TRG4 of 16bit */
#define APB_CR2_ITR6_MUX_trg4_b0                    ((uint8_t )0x04)        /*!< Bit Value =(0x4):TRG4 of 8bit */
#define APB_CR2_ITR6_MUX_trg5_w                     ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):TRG5 of 32bit */
#define APB_CR2_ITR6_MUX_trg5_h0                    ((uint16_t)0x0005)      /*!< Bit Value =(0x5):TRG5 of 16bit */
#define APB_CR2_ITR6_MUX_trg5_b0                    ((uint8_t )0x05)        /*!< Bit Value =(0x5):TRG5 of 8bit */
#define APB_CR2_ITR6_MUX_trg6_w                     ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):TRG6 of 32bit */
#define APB_CR2_ITR6_MUX_trg6_h0                    ((uint16_t)0x0006)      /*!< Bit Value =(0x6):TRG6 of 16bit */
#define APB_CR2_ITR6_MUX_trg6_b0                    ((uint8_t )0x06)        /*!< Bit Value =(0x6):TRG6 of 8bit */
#define APB_CR2_ITR6_MUX_trg7_w                     ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):TRG7 of 32bit */
#define APB_CR2_ITR6_MUX_trg7_h0                    ((uint16_t)0x0007)      /*!< Bit Value =(0x7):TRG7 of 16bit */
#define APB_CR2_ITR6_MUX_trg7_b0                    ((uint8_t )0x07)        /*!< Bit Value =(0x7):TRG7 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_OBM00  [register's definitions]
 *              Offset[0x20]  APB OBM0 control register-0 (0x5F000020)
 ******************************************************************************
 */
///@{
#define APB_OBM00_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_OBM00 */
#define APB_OBM00_OBM0_BKS2_mask_w                  ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKS2_mask_h1                 ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKS2_mask_b3                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKS2_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk0_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk1_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk1_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk1_b3                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk2_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk2_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk2_b3                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk3_w                   ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk3_h1                  ((uint16_t)0x0300)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk3_b3                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk4_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk4_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk4_b3                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk5_w                   ((uint32_t)0x05000000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk5_h1                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk5_b3                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk6_w                   ((uint32_t)0x06000000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk6_h1                  ((uint16_t)0x0600)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk6_b3                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk7_w                   ((uint32_t)0x07000000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk7_h1                  ((uint16_t)0x0700)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk7_b3                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk8_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk8_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk8_b3                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk9_w                   ((uint32_t)0x09000000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk9_h1                  ((uint16_t)0x0900)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk9_b3                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk10_w                  ((uint32_t)0x0A000000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk10_h1                 ((uint16_t)0x0A00)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk10_b3                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk11_w                  ((uint32_t)0x0B000000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk11_h1                 ((uint16_t)0x0B00)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk11_b3                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk12_w                  ((uint32_t)0x0C000000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk12_h1                 ((uint16_t)0x0C00)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk12_b3                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk13_w                  ((uint32_t)0x0D000000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk13_h1                 ((uint16_t)0x0D00)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk13_b3                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk14_w                  ((uint32_t)0x0E000000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk14_h1                 ((uint16_t)0x0E00)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk14_b3                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM00_OBM0_BKS2_bk15_w                  ((uint32_t)0x0F000000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM00_OBM0_BKS2_bk15_h1                 ((uint16_t)0x0F00)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM00_OBM0_BKS2_bk15_b3                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM00_OBM0_BKS1_mask_w                  ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKS1_mask_h1                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKS1_mask_b2                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKS1_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk1_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk1_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk1_b2                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk2_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk2_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk2_b2                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk3_w                   ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk3_h1                  ((uint16_t)0x0030)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk3_b2                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk4_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk4_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk4_b2                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk5_w                   ((uint32_t)0x00500000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk5_h1                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk5_b2                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk6_w                   ((uint32_t)0x00600000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk6_h1                  ((uint16_t)0x0060)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk6_b2                  ((uint8_t )0x60)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk7_w                   ((uint32_t)0x00700000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk7_h1                  ((uint16_t)0x0070)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk7_b2                  ((uint8_t )0x70)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk8_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk8_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk8_b2                  ((uint8_t )0x80)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk9_w                   ((uint32_t)0x00900000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk9_h1                  ((uint16_t)0x0090)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk9_b2                  ((uint8_t )0x90)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk10_w                  ((uint32_t)0x00A00000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk10_h1                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk10_b2                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk11_w                  ((uint32_t)0x00B00000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk11_h1                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk11_b2                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk12_w                  ((uint32_t)0x00C00000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk12_h1                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk12_b2                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk13_w                  ((uint32_t)0x00D00000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk13_h1                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk13_b2                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk14_w                  ((uint32_t)0x00E00000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk14_h1                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk14_b2                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM00_OBM0_BKS1_bk15_w                  ((uint32_t)0x00F00000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM00_OBM0_BKS1_bk15_h1                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM00_OBM0_BKS1_bk15_b2                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM00_OBM0_BKS0_mask_w                  ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKS0_mask_h1                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKS0_mask_b2                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKS0_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk1_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk1_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk1_b2                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk2_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk2_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk2_b2                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk3_w                   ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk3_h1                  ((uint16_t)0x0003)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk3_b2                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk4_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk4_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk4_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk5_w                   ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk5_h1                  ((uint16_t)0x0005)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk5_b2                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk6_w                   ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk6_h1                  ((uint16_t)0x0006)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk6_b2                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk7_w                   ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk7_h1                  ((uint16_t)0x0007)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk7_b2                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk8_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk8_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk8_b2                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk9_w                   ((uint32_t)0x00090000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk9_h1                  ((uint16_t)0x0009)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk9_b2                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk10_w                  ((uint32_t)0x000A0000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk10_h1                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk10_b2                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk11_w                  ((uint32_t)0x000B0000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk11_h1                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk11_b2                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk12_w                  ((uint32_t)0x000C0000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk12_h1                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk12_b2                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk13_w                  ((uint32_t)0x000D0000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk13_h1                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk13_b2                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk14_w                  ((uint32_t)0x000E0000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk14_h1                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk14_b2                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM00_OBM0_BKS0_bk15_w                  ((uint32_t)0x000F0000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM00_OBM0_BKS0_bk15_h1                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM00_OBM0_BKS0_bk15_b2                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM00_OBM0_BKN2_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKN2_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKN2_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKN2_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM00_OBM0_BKN2_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM00_OBM0_BKN2_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM00_OBM0_BKN2_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM00_OBM0_BKN2_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM00_OBM0_BKN2_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM00_OBM0_BKN1_mask_w                  ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKN1_mask_h0                 ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKN1_mask_b1                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKN1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM00_OBM0_BKN1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM00_OBM0_BKN1_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM00_OBM0_BKN1_enable_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM00_OBM0_BKN1_enable_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM00_OBM0_BKN1_enable_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM00_OBM0_BKN0_mask_w                  ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_BKN0_mask_h0                 ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_BKN0_mask_b1                 ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_BKN0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM00_OBM0_BKN0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM00_OBM0_BKN0_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM00_OBM0_BKN0_enable_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM00_OBM0_BKN0_enable_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM00_OBM0_BKN0_enable_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM00_OBM0_LCK_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_LCK_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_LCK_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_LCK_locked_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define APB_OBM00_OBM0_LCK_locked_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define APB_OBM00_OBM0_LCK_locked_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define APB_OBM00_OBM0_LCK_un_locked_w              ((uint32_t)0x00000020)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define APB_OBM00_OBM0_LCK_un_locked_h0             ((uint16_t)0x0020)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define APB_OBM00_OBM0_LCK_un_locked_b0             ((uint8_t )0x20)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define APB_OBM00_OBM0_STA_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_STA_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_STA_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_STA_0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define APB_OBM00_OBM0_STA_0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define APB_OBM00_OBM0_STA_0_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define APB_OBM00_OBM0_STA_1_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):1 of 32bit */
#define APB_OBM00_OBM0_STA_1_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):1 of 16bit */
#define APB_OBM00_OBM0_STA_1_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):1 of 8bit */

#define APB_OBM00_OBM0_MDS_mask_w                   ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define APB_OBM00_OBM0_MDS_mask_h0                  ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define APB_OBM00_OBM0_MDS_mask_b0                  ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define APB_OBM00_OBM0_MDS_and_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):AND of 32bit */
#define APB_OBM00_OBM0_MDS_and_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):AND of 16bit */
#define APB_OBM00_OBM0_MDS_and_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):AND of 8bit */
#define APB_OBM00_OBM0_MDS_clr_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):CLR of 32bit */
#define APB_OBM00_OBM0_MDS_clr_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CLR of 16bit */
#define APB_OBM00_OBM0_MDS_clr_b0                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CLR of 8bit */
#define APB_OBM00_OBM0_MDS_set_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):SET of 32bit */
#define APB_OBM00_OBM0_MDS_set_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(0x2):SET of 16bit */
#define APB_OBM00_OBM0_MDS_set_b0                   ((uint8_t )0x02)        /*!< Bit Value =(0x2):SET of 8bit */
#define APB_OBM00_OBM0_MDS_toggle_w                 ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):TOGGLE of 32bit */
#define APB_OBM00_OBM0_MDS_toggle_h0                ((uint16_t)0x0003)      /*!< Bit Value =(0x3):TOGGLE of 16bit */
#define APB_OBM00_OBM0_MDS_toggle_b0                ((uint8_t )0x03)        /*!< Bit Value =(0x3):TOGGLE of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_OBM01  [register's definitions]
 *              Offset[0x24]  APB OBM0 control register-1 (0x5F000024)
 ******************************************************************************
 */
///@{
#define APB_OBM01_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_OBM01 */
#define APB_OBM01_OBM0_MUX1_mask_w                  ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_MUX1_mask_h1                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_MUX1_mask_b2                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_MUX1_sr0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SR0 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SR0 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):SR0 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr1_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):SR1 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr1_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SR1 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr1_b2                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):SR1 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr2_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):SR2 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr2_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(0x2):SR2 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr2_b2                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):SR2 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr3_w                   ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):SR3 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr3_h1                  ((uint16_t)0x0030)      /*!< Bit Value =(0x3):SR3 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr3_b2                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):SR3 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr4_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):SR4 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr4_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(0x4):SR4 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr4_b2                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):SR4 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr5_w                   ((uint32_t)0x00500000)  /*!< Bit Value =(0x5):SR5 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr5_h1                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):SR5 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr5_b2                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):SR5 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr6_w                   ((uint32_t)0x00600000)  /*!< Bit Value =(0x6):SR6 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr6_h1                  ((uint16_t)0x0060)      /*!< Bit Value =(0x6):SR6 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr6_b2                  ((uint8_t )0x60)        /*!< Bit Value =(0x6):SR6 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr7_w                   ((uint32_t)0x00700000)  /*!< Bit Value =(0x7):SR7 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr7_h1                  ((uint16_t)0x0070)      /*!< Bit Value =(0x7):SR7 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr7_b2                  ((uint8_t )0x70)        /*!< Bit Value =(0x7):SR7 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr8_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(0x8):SR8 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr8_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(0x8):SR8 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr8_b2                  ((uint8_t )0x80)        /*!< Bit Value =(0x8):SR8 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr9_w                   ((uint32_t)0x00900000)  /*!< Bit Value =(0x9):SR9 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr9_h1                  ((uint16_t)0x0090)      /*!< Bit Value =(0x9):SR9 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr9_b2                  ((uint8_t )0x90)        /*!< Bit Value =(0x9):SR9 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr10_w                  ((uint32_t)0x00A00000)  /*!< Bit Value =(0xA):SR10 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr10_h1                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):SR10 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr10_b2                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):SR10 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr11_w                  ((uint32_t)0x00B00000)  /*!< Bit Value =(0xB):SR11 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr11_h1                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):SR11 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr11_b2                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):SR11 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr12_w                  ((uint32_t)0x00C00000)  /*!< Bit Value =(0xC):SR12 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr12_h1                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):SR12 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr12_b2                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):SR12 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr13_w                  ((uint32_t)0x00D00000)  /*!< Bit Value =(0xD):SR13 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr13_h1                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):SR13 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr13_b2                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):SR13 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr14_w                  ((uint32_t)0x00E00000)  /*!< Bit Value =(0xE):SR14 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr14_h1                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):SR14 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr14_b2                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):SR14 of 8bit */
#define APB_OBM01_OBM0_MUX1_sr15_w                  ((uint32_t)0x00F00000)  /*!< Bit Value =(0xF):SR15 of 32bit */
#define APB_OBM01_OBM0_MUX1_sr15_h1                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):SR15 of 16bit */
#define APB_OBM01_OBM0_MUX1_sr15_b2                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):SR15 of 8bit */

#define APB_OBM01_OBM0_MUX0_mask_w                  ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_MUX0_mask_h1                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_MUX0_mask_b2                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_MUX0_sr0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SR0 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SR0 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):SR0 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr1_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):SR1 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr1_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(0x1):SR1 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr1_b2                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):SR1 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr2_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):SR2 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr2_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):SR2 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr2_b2                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):SR2 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr3_w                   ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):SR3 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr3_h1                  ((uint16_t)0x0003)      /*!< Bit Value =(0x3):SR3 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr3_b2                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):SR3 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr4_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):SR4 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr4_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x4):SR4 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr4_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):SR4 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr5_w                   ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):SR5 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr5_h1                  ((uint16_t)0x0005)      /*!< Bit Value =(0x5):SR5 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr5_b2                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):SR5 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr6_w                   ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):SR6 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr6_h1                  ((uint16_t)0x0006)      /*!< Bit Value =(0x6):SR6 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr6_b2                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):SR6 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr7_w                   ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):SR7 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr7_h1                  ((uint16_t)0x0007)      /*!< Bit Value =(0x7):SR7 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr7_b2                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):SR7 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr8_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):SR8 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr8_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(0x8):SR8 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr8_b2                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):SR8 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr9_w                   ((uint32_t)0x00090000)  /*!< Bit Value =(0x9):SR9 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr9_h1                  ((uint16_t)0x0009)      /*!< Bit Value =(0x9):SR9 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr9_b2                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):SR9 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr10_w                  ((uint32_t)0x000A0000)  /*!< Bit Value =(0xA):SR10 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr10_h1                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):SR10 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr10_b2                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):SR10 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr11_w                  ((uint32_t)0x000B0000)  /*!< Bit Value =(0xB):SR11 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr11_h1                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):SR11 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr11_b2                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):SR11 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr12_w                  ((uint32_t)0x000C0000)  /*!< Bit Value =(0xC):SR12 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr12_h1                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):SR12 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr12_b2                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):SR12 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr13_w                  ((uint32_t)0x000D0000)  /*!< Bit Value =(0xD):SR13 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr13_h1                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):SR13 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr13_b2                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):SR13 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr14_w                  ((uint32_t)0x000E0000)  /*!< Bit Value =(0xE):SR14 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr14_h1                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):SR14 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr14_b2                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):SR14 of 8bit */
#define APB_OBM01_OBM0_MUX0_sr15_w                  ((uint32_t)0x000F0000)  /*!< Bit Value =(0xF):SR15 of 32bit */
#define APB_OBM01_OBM0_MUX0_sr15_h1                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):SR15 of 16bit */
#define APB_OBM01_OBM0_MUX0_sr15_b2                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):SR15 of 8bit */

#define APB_OBM01_OBM0_FCKS_mask_w                  ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_FCKS_mask_h0                 ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_FCKS_mask_b0                 ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_FCKS_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APB_OBM01_OBM0_FCKS_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APB_OBM01_OBM0_FCKS_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APB_OBM01_OBM0_FCKS_apb_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):APB of 32bit */
#define APB_OBM01_OBM0_FCKS_apb_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):APB of 16bit */
#define APB_OBM01_OBM0_FCKS_apb_b0                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):APB of 8bit */
#define APB_OBM01_OBM0_FCKS_apb_div8_w              ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):APB_DIV8 of 32bit */
#define APB_OBM01_OBM0_FCKS_apb_div8_h0             ((uint16_t)0x0020)      /*!< Bit Value =(0x2):APB_DIV8 of 16bit */
#define APB_OBM01_OBM0_FCKS_apb_div8_b0             ((uint8_t )0x20)        /*!< Bit Value =(0x2):APB_DIV8 of 8bit */
#define APB_OBM01_OBM0_FCKS_tm00_trgo_w             ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):TM00_TRGO of 32bit */
#define APB_OBM01_OBM0_FCKS_tm00_trgo_h0            ((uint16_t)0x0030)      /*!< Bit Value =(0x3):TM00_TRGO of 16bit */
#define APB_OBM01_OBM0_FCKS_tm00_trgo_b0            ((uint8_t )0x30)        /*!< Bit Value =(0x3):TM00_TRGO of 8bit */

#define APB_OBM01_OBM0_POL_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_POL_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_POL_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_POL_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM01_OBM0_POL_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM01_OBM0_POL_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM01_OBM0_POL_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM01_OBM0_POL_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM01_OBM0_POL_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM01_OBM0_INV1_mask_w                  ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_INV1_mask_h0                 ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_INV1_mask_b0                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_INV1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM01_OBM0_INV1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM01_OBM0_INV1_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM01_OBM0_INV1_enable_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM01_OBM0_INV1_enable_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM01_OBM0_INV1_enable_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM01_OBM0_INV0_mask_w                  ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APB_OBM01_OBM0_INV0_mask_h0                 ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_OBM01_OBM0_INV0_mask_b0                 ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_OBM01_OBM0_INV0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM01_OBM0_INV0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM01_OBM0_INV0_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM01_OBM0_INV0_enable_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM01_OBM0_INV0_enable_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM01_OBM0_INV0_enable_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_OBM10  [register's definitions]
 *              Offset[0x28]  APB OBM1 control register-0 (0x5F000028)
 ******************************************************************************
 */
///@{
#define APB_OBM10_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_OBM10 */
#define APB_OBM10_OBM1_BKS2_mask_w                  ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKS2_mask_h1                 ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKS2_mask_b3                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKS2_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk0_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk1_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk1_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk1_b3                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk2_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk2_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk2_b3                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk3_w                   ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk3_h1                  ((uint16_t)0x0300)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk3_b3                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk4_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk4_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk4_b3                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk5_w                   ((uint32_t)0x05000000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk5_h1                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk5_b3                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk6_w                   ((uint32_t)0x06000000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk6_h1                  ((uint16_t)0x0600)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk6_b3                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk7_w                   ((uint32_t)0x07000000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk7_h1                  ((uint16_t)0x0700)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk7_b3                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk8_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk8_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk8_b3                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk9_w                   ((uint32_t)0x09000000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk9_h1                  ((uint16_t)0x0900)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk9_b3                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk10_w                  ((uint32_t)0x0A000000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk10_h1                 ((uint16_t)0x0A00)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk10_b3                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk11_w                  ((uint32_t)0x0B000000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk11_h1                 ((uint16_t)0x0B00)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk11_b3                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk12_w                  ((uint32_t)0x0C000000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk12_h1                 ((uint16_t)0x0C00)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk12_b3                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk13_w                  ((uint32_t)0x0D000000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk13_h1                 ((uint16_t)0x0D00)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk13_b3                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk14_w                  ((uint32_t)0x0E000000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk14_h1                 ((uint16_t)0x0E00)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk14_b3                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM10_OBM1_BKS2_bk15_w                  ((uint32_t)0x0F000000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM10_OBM1_BKS2_bk15_h1                 ((uint16_t)0x0F00)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM10_OBM1_BKS2_bk15_b3                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM10_OBM1_BKS1_mask_w                  ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKS1_mask_h1                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKS1_mask_b2                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKS1_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk1_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk1_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk1_b2                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk2_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk2_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk2_b2                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk3_w                   ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk3_h1                  ((uint16_t)0x0030)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk3_b2                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk4_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk4_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk4_b2                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk5_w                   ((uint32_t)0x00500000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk5_h1                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk5_b2                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk6_w                   ((uint32_t)0x00600000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk6_h1                  ((uint16_t)0x0060)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk6_b2                  ((uint8_t )0x60)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk7_w                   ((uint32_t)0x00700000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk7_h1                  ((uint16_t)0x0070)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk7_b2                  ((uint8_t )0x70)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk8_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk8_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk8_b2                  ((uint8_t )0x80)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk9_w                   ((uint32_t)0x00900000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk9_h1                  ((uint16_t)0x0090)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk9_b2                  ((uint8_t )0x90)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk10_w                  ((uint32_t)0x00A00000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk10_h1                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk10_b2                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk11_w                  ((uint32_t)0x00B00000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk11_h1                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk11_b2                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk12_w                  ((uint32_t)0x00C00000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk12_h1                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk12_b2                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk13_w                  ((uint32_t)0x00D00000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk13_h1                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk13_b2                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk14_w                  ((uint32_t)0x00E00000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk14_h1                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk14_b2                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM10_OBM1_BKS1_bk15_w                  ((uint32_t)0x00F00000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM10_OBM1_BKS1_bk15_h1                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM10_OBM1_BKS1_bk15_b2                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM10_OBM1_BKS0_mask_w                  ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKS0_mask_h1                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKS0_mask_b2                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKS0_bk0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):BK0 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):BK0 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):BK0 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk1_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):BK1 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk1_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(0x1):BK1 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk1_b2                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):BK1 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk2_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):BK2 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk2_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):BK2 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk2_b2                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):BK2 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk3_w                   ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):BK3 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk3_h1                  ((uint16_t)0x0003)      /*!< Bit Value =(0x3):BK3 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk3_b2                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):BK3 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk4_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):BK4 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk4_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x4):BK4 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk4_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):BK4 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk5_w                   ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):BK5 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk5_h1                  ((uint16_t)0x0005)      /*!< Bit Value =(0x5):BK5 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk5_b2                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):BK5 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk6_w                   ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):BK6 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk6_h1                  ((uint16_t)0x0006)      /*!< Bit Value =(0x6):BK6 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk6_b2                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):BK6 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk7_w                   ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):BK7 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk7_h1                  ((uint16_t)0x0007)      /*!< Bit Value =(0x7):BK7 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk7_b2                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):BK7 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk8_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):BK8 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk8_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(0x8):BK8 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk8_b2                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):BK8 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk9_w                   ((uint32_t)0x00090000)  /*!< Bit Value =(0x9):BK9 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk9_h1                  ((uint16_t)0x0009)      /*!< Bit Value =(0x9):BK9 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk9_b2                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):BK9 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk10_w                  ((uint32_t)0x000A0000)  /*!< Bit Value =(0xA):BK10 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk10_h1                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):BK10 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk10_b2                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):BK10 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk11_w                  ((uint32_t)0x000B0000)  /*!< Bit Value =(0xB):BK11 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk11_h1                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):BK11 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk11_b2                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):BK11 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk12_w                  ((uint32_t)0x000C0000)  /*!< Bit Value =(0xC):BK12 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk12_h1                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):BK12 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk12_b2                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):BK12 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk13_w                  ((uint32_t)0x000D0000)  /*!< Bit Value =(0xD):BK13 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk13_h1                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):BK13 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk13_b2                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):BK13 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk14_w                  ((uint32_t)0x000E0000)  /*!< Bit Value =(0xE):BK14 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk14_h1                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):BK14 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk14_b2                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):BK14 of 8bit */
#define APB_OBM10_OBM1_BKS0_bk15_w                  ((uint32_t)0x000F0000)  /*!< Bit Value =(0xF):BK15 of 32bit */
#define APB_OBM10_OBM1_BKS0_bk15_h1                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):BK15 of 16bit */
#define APB_OBM10_OBM1_BKS0_bk15_b2                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):BK15 of 8bit */

#define APB_OBM10_OBM1_BKN2_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKN2_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKN2_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKN2_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM10_OBM1_BKN2_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM10_OBM1_BKN2_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM10_OBM1_BKN2_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM10_OBM1_BKN2_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM10_OBM1_BKN2_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM10_OBM1_BKN1_mask_w                  ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKN1_mask_h0                 ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKN1_mask_b1                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKN1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM10_OBM1_BKN1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM10_OBM1_BKN1_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM10_OBM1_BKN1_enable_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM10_OBM1_BKN1_enable_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM10_OBM1_BKN1_enable_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM10_OBM1_BKN0_mask_w                  ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_BKN0_mask_h0                 ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_BKN0_mask_b1                 ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_BKN0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM10_OBM1_BKN0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM10_OBM1_BKN0_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM10_OBM1_BKN0_enable_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM10_OBM1_BKN0_enable_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM10_OBM1_BKN0_enable_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM10_OBM1_LCK_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_LCK_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_LCK_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_LCK_locked_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define APB_OBM10_OBM1_LCK_locked_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define APB_OBM10_OBM1_LCK_locked_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define APB_OBM10_OBM1_LCK_un_locked_w              ((uint32_t)0x00000020)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define APB_OBM10_OBM1_LCK_un_locked_h0             ((uint16_t)0x0020)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define APB_OBM10_OBM1_LCK_un_locked_b0             ((uint8_t )0x20)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define APB_OBM10_OBM1_STA_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_STA_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_STA_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_STA_0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define APB_OBM10_OBM1_STA_0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define APB_OBM10_OBM1_STA_0_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define APB_OBM10_OBM1_STA_1_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):1 of 32bit */
#define APB_OBM10_OBM1_STA_1_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):1 of 16bit */
#define APB_OBM10_OBM1_STA_1_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):1 of 8bit */

#define APB_OBM10_OBM1_MDS_mask_w                   ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define APB_OBM10_OBM1_MDS_mask_h0                  ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define APB_OBM10_OBM1_MDS_mask_b0                  ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define APB_OBM10_OBM1_MDS_and_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):AND of 32bit */
#define APB_OBM10_OBM1_MDS_and_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):AND of 16bit */
#define APB_OBM10_OBM1_MDS_and_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):AND of 8bit */
#define APB_OBM10_OBM1_MDS_clr_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):CLR of 32bit */
#define APB_OBM10_OBM1_MDS_clr_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CLR of 16bit */
#define APB_OBM10_OBM1_MDS_clr_b0                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CLR of 8bit */
#define APB_OBM10_OBM1_MDS_set_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):SET of 32bit */
#define APB_OBM10_OBM1_MDS_set_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(0x2):SET of 16bit */
#define APB_OBM10_OBM1_MDS_set_b0                   ((uint8_t )0x02)        /*!< Bit Value =(0x2):SET of 8bit */
#define APB_OBM10_OBM1_MDS_toggle_w                 ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):TOGGLE of 32bit */
#define APB_OBM10_OBM1_MDS_toggle_h0                ((uint16_t)0x0003)      /*!< Bit Value =(0x3):TOGGLE of 16bit */
#define APB_OBM10_OBM1_MDS_toggle_b0                ((uint8_t )0x03)        /*!< Bit Value =(0x3):TOGGLE of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_OBM11  [register's definitions]
 *              Offset[0x2C]  APB OBM1 control register-1 (0x5F00002C)
 ******************************************************************************
 */
///@{
#define APB_OBM11_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_OBM11 */
#define APB_OBM11_OBM1_MUX1_mask_w                  ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_MUX1_mask_h1                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_MUX1_mask_b2                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_MUX1_sr0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SR0 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SR0 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):SR0 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr1_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):SR1 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr1_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SR1 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr1_b2                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):SR1 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr2_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):SR2 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr2_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(0x2):SR2 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr2_b2                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):SR2 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr3_w                   ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):SR3 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr3_h1                  ((uint16_t)0x0030)      /*!< Bit Value =(0x3):SR3 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr3_b2                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):SR3 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr4_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):SR4 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr4_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(0x4):SR4 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr4_b2                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):SR4 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr5_w                   ((uint32_t)0x00500000)  /*!< Bit Value =(0x5):SR5 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr5_h1                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):SR5 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr5_b2                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):SR5 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr6_w                   ((uint32_t)0x00600000)  /*!< Bit Value =(0x6):SR6 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr6_h1                  ((uint16_t)0x0060)      /*!< Bit Value =(0x6):SR6 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr6_b2                  ((uint8_t )0x60)        /*!< Bit Value =(0x6):SR6 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr7_w                   ((uint32_t)0x00700000)  /*!< Bit Value =(0x7):SR7 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr7_h1                  ((uint16_t)0x0070)      /*!< Bit Value =(0x7):SR7 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr7_b2                  ((uint8_t )0x70)        /*!< Bit Value =(0x7):SR7 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr8_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(0x8):SR8 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr8_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(0x8):SR8 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr8_b2                  ((uint8_t )0x80)        /*!< Bit Value =(0x8):SR8 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr9_w                   ((uint32_t)0x00900000)  /*!< Bit Value =(0x9):SR9 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr9_h1                  ((uint16_t)0x0090)      /*!< Bit Value =(0x9):SR9 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr9_b2                  ((uint8_t )0x90)        /*!< Bit Value =(0x9):SR9 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr10_w                  ((uint32_t)0x00A00000)  /*!< Bit Value =(0xA):SR10 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr10_h1                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):SR10 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr10_b2                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):SR10 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr11_w                  ((uint32_t)0x00B00000)  /*!< Bit Value =(0xB):SR11 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr11_h1                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):SR11 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr11_b2                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):SR11 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr12_w                  ((uint32_t)0x00C00000)  /*!< Bit Value =(0xC):SR12 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr12_h1                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):SR12 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr12_b2                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):SR12 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr13_w                  ((uint32_t)0x00D00000)  /*!< Bit Value =(0xD):SR13 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr13_h1                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):SR13 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr13_b2                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):SR13 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr14_w                  ((uint32_t)0x00E00000)  /*!< Bit Value =(0xE):SR14 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr14_h1                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):SR14 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr14_b2                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):SR14 of 8bit */
#define APB_OBM11_OBM1_MUX1_sr15_w                  ((uint32_t)0x00F00000)  /*!< Bit Value =(0xF):SR15 of 32bit */
#define APB_OBM11_OBM1_MUX1_sr15_h1                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):SR15 of 16bit */
#define APB_OBM11_OBM1_MUX1_sr15_b2                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):SR15 of 8bit */

#define APB_OBM11_OBM1_MUX0_mask_w                  ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_MUX0_mask_h1                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_MUX0_mask_b2                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_MUX0_sr0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SR0 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SR0 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):SR0 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr1_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):SR1 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr1_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(0x1):SR1 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr1_b2                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):SR1 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr2_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):SR2 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr2_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):SR2 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr2_b2                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):SR2 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr3_w                   ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):SR3 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr3_h1                  ((uint16_t)0x0003)      /*!< Bit Value =(0x3):SR3 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr3_b2                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):SR3 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr4_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):SR4 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr4_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x4):SR4 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr4_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):SR4 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr5_w                   ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):SR5 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr5_h1                  ((uint16_t)0x0005)      /*!< Bit Value =(0x5):SR5 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr5_b2                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):SR5 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr6_w                   ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):SR6 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr6_h1                  ((uint16_t)0x0006)      /*!< Bit Value =(0x6):SR6 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr6_b2                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):SR6 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr7_w                   ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):SR7 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr7_h1                  ((uint16_t)0x0007)      /*!< Bit Value =(0x7):SR7 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr7_b2                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):SR7 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr8_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):SR8 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr8_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(0x8):SR8 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr8_b2                  ((uint8_t )0x08)        /*!< Bit Value =(0x8):SR8 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr9_w                   ((uint32_t)0x00090000)  /*!< Bit Value =(0x9):SR9 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr9_h1                  ((uint16_t)0x0009)      /*!< Bit Value =(0x9):SR9 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr9_b2                  ((uint8_t )0x09)        /*!< Bit Value =(0x9):SR9 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr10_w                  ((uint32_t)0x000A0000)  /*!< Bit Value =(0xA):SR10 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr10_h1                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):SR10 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr10_b2                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):SR10 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr11_w                  ((uint32_t)0x000B0000)  /*!< Bit Value =(0xB):SR11 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr11_h1                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):SR11 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr11_b2                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):SR11 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr12_w                  ((uint32_t)0x000C0000)  /*!< Bit Value =(0xC):SR12 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr12_h1                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):SR12 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr12_b2                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):SR12 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr13_w                  ((uint32_t)0x000D0000)  /*!< Bit Value =(0xD):SR13 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr13_h1                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):SR13 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr13_b2                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):SR13 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr14_w                  ((uint32_t)0x000E0000)  /*!< Bit Value =(0xE):SR14 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr14_h1                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):SR14 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr14_b2                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):SR14 of 8bit */
#define APB_OBM11_OBM1_MUX0_sr15_w                  ((uint32_t)0x000F0000)  /*!< Bit Value =(0xF):SR15 of 32bit */
#define APB_OBM11_OBM1_MUX0_sr15_h1                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):SR15 of 16bit */
#define APB_OBM11_OBM1_MUX0_sr15_b2                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):SR15 of 8bit */

#define APB_OBM11_OBM1_FCKS_mask_w                  ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_FCKS_mask_h0                 ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_FCKS_mask_b0                 ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_FCKS_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APB_OBM11_OBM1_FCKS_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APB_OBM11_OBM1_FCKS_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APB_OBM11_OBM1_FCKS_apb_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):APB of 32bit */
#define APB_OBM11_OBM1_FCKS_apb_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):APB of 16bit */
#define APB_OBM11_OBM1_FCKS_apb_b0                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):APB of 8bit */
#define APB_OBM11_OBM1_FCKS_apb_div8_w              ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):APB_DIV8 of 32bit */
#define APB_OBM11_OBM1_FCKS_apb_div8_h0             ((uint16_t)0x0020)      /*!< Bit Value =(0x2):APB_DIV8 of 16bit */
#define APB_OBM11_OBM1_FCKS_apb_div8_b0             ((uint8_t )0x20)        /*!< Bit Value =(0x2):APB_DIV8 of 8bit */
#define APB_OBM11_OBM1_FCKS_tm00_trgo_w             ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):TM00_TRGO of 32bit */
#define APB_OBM11_OBM1_FCKS_tm00_trgo_h0            ((uint16_t)0x0030)      /*!< Bit Value =(0x3):TM00_TRGO of 16bit */
#define APB_OBM11_OBM1_FCKS_tm00_trgo_b0            ((uint8_t )0x30)        /*!< Bit Value =(0x3):TM00_TRGO of 8bit */

#define APB_OBM11_OBM1_POL_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_POL_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_POL_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_POL_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM11_OBM1_POL_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM11_OBM1_POL_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM11_OBM1_POL_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM11_OBM1_POL_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM11_OBM1_POL_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM11_OBM1_INV1_mask_w                  ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_INV1_mask_h0                 ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_INV1_mask_b0                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_INV1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM11_OBM1_INV1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM11_OBM1_INV1_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM11_OBM1_INV1_enable_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM11_OBM1_INV1_enable_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM11_OBM1_INV1_enable_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_OBM11_OBM1_INV0_mask_w                  ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APB_OBM11_OBM1_INV0_mask_h0                 ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APB_OBM11_OBM1_INV0_mask_b0                 ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_OBM11_OBM1_INV0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_OBM11_OBM1_INV0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_OBM11_OBM1_INV0_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_OBM11_OBM1_INV0_enable_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_OBM11_OBM1_INV0_enable_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_OBM11_OBM1_INV0_enable_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_NCO00  [register's definitions]
 *              Offset[0x40]  APB NCO0 increment register (0x5F000040)
 ******************************************************************************
 */
///@{
#define APB_NCO00_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_NCO00 */
#define APB_NCO00_NCO0_CKS_mask_w                   ((uint32_t)0x70000000)  /*!< Bit Mask of 32bit */
#define APB_NCO00_NCO0_CKS_mask_h1                  ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define APB_NCO00_NCO0_CKS_mask_b3                  ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define APB_NCO00_NCO0_CKS_ck_ihrco_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_IHRCO of 32bit */
#define APB_NCO00_NCO0_CKS_ck_ihrco_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_IHRCO of 16bit */
#define APB_NCO00_NCO0_CKS_ck_ihrco_b3              ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_IHRCO of 8bit */
#define APB_NCO00_NCO0_CKS_ck_pll_w                 ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):CK_PLL of 32bit */
#define APB_NCO00_NCO0_CKS_ck_pll_h1                ((uint16_t)0x1000)      /*!< Bit Value =(0x1):CK_PLL of 16bit */
#define APB_NCO00_NCO0_CKS_ck_pll_b3                ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_PLL of 8bit */
#define APB_NCO00_NCO0_CKS_ck_apb_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):CK_APB of 32bit */
#define APB_NCO00_NCO0_CKS_ck_apb_h1                ((uint16_t)0x2000)      /*!< Bit Value =(0x2):CK_APB of 16bit */
#define APB_NCO00_NCO0_CKS_ck_apb_b3                ((uint8_t )0x20)        /*!< Bit Value =(0x2):CK_APB of 8bit */
#define APB_NCO00_NCO0_CKS_ck_ls_w                  ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):CK_LS of 32bit */
#define APB_NCO00_NCO0_CKS_ck_ls_h1                 ((uint16_t)0x3000)      /*!< Bit Value =(0x3):CK_LS of 16bit */
#define APB_NCO00_NCO0_CKS_ck_ls_b3                 ((uint8_t )0x30)        /*!< Bit Value =(0x3):CK_LS of 8bit */
#define APB_NCO00_NCO0_CKS_tm00_trgo_w              ((uint32_t)0x40000000)  /*!< Bit Value =(0x4):TM00_TRGO of 32bit */
#define APB_NCO00_NCO0_CKS_tm00_trgo_h1             ((uint16_t)0x4000)      /*!< Bit Value =(0x4):TM00_TRGO of 16bit */
#define APB_NCO00_NCO0_CKS_tm00_trgo_b3             ((uint8_t )0x40)        /*!< Bit Value =(0x4):TM00_TRGO of 8bit */
#define APB_NCO00_NCO0_CKS_nco_ck0_w                ((uint32_t)0x50000000)  /*!< Bit Value =(0x5):NCO_CK0 of 32bit */
#define APB_NCO00_NCO0_CKS_nco_ck0_h1               ((uint16_t)0x5000)      /*!< Bit Value =(0x5):NCO_CK0 of 16bit */
#define APB_NCO00_NCO0_CKS_nco_ck0_b3               ((uint8_t )0x50)        /*!< Bit Value =(0x5):NCO_CK0 of 8bit */

#define APB_NCO00_NCO0_MDS_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define APB_NCO00_NCO0_MDS_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define APB_NCO00_NCO0_MDS_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define APB_NCO00_NCO0_MDS_fdc_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):FDC of 32bit */
#define APB_NCO00_NCO0_MDS_fdc_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):FDC of 16bit */
#define APB_NCO00_NCO0_MDS_fdc_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):FDC of 8bit */
#define APB_NCO00_NCO0_MDS_pfm_w                    ((uint32_t)0x04000000)  /*!< Bit Value =(1):PFM of 32bit */
#define APB_NCO00_NCO0_MDS_pfm_h1                   ((uint16_t)0x0400)      /*!< Bit Value =(1):PFM of 16bit */
#define APB_NCO00_NCO0_MDS_pfm_b3                   ((uint8_t )0x04)        /*!< Bit Value =(1):PFM of 8bit */

#define APB_NCO00_NCO0_INV_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define APB_NCO00_NCO0_INV_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APB_NCO00_NCO0_INV_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APB_NCO00_NCO0_INV_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_NCO00_NCO0_INV_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_NCO00_NCO0_INV_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_NCO00_NCO0_INV_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_NCO00_NCO0_INV_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_NCO00_NCO0_INV_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_NCO00_NCO0_EN_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define APB_NCO00_NCO0_EN_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APB_NCO00_NCO0_EN_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APB_NCO00_NCO0_EN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APB_NCO00_NCO0_EN_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APB_NCO00_NCO0_EN_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APB_NCO00_NCO0_EN_enable_w                  ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define APB_NCO00_NCO0_EN_enable_h1                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define APB_NCO00_NCO0_EN_enable_b3                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APB_NCO00_NCO0_INC_mask_w                   ((uint32_t)0x000FFFFF)  /*!< Bit Mask of 32bit */
#define APB_NCO00_NCO0_INC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define APB_NCO00_NCO0_INC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define APB_NCO00_NCO0_INC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APB_NCO01  [register's definitions]
 *              Offset[0x44]  APB NCO0 accumulator register (0x5F000044)
 ******************************************************************************
 */
///@{
#define APB_NCO01_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APB_NCO01 */
#define APB_NCO01_NCO0_PWS_mask_w                   ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define APB_NCO01_NCO0_PWS_mask_h1                  ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define APB_NCO01_NCO0_PWS_mask_b3                  ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define APB_NCO01_NCO0_PWS_ck1_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK1 of 32bit */
#define APB_NCO01_NCO0_PWS_ck1_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK1 of 16bit */
#define APB_NCO01_NCO0_PWS_ck1_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK1 of 8bit */
#define APB_NCO01_NCO0_PWS_ck2_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):CK2 of 32bit */
#define APB_NCO01_NCO0_PWS_ck2_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK2 of 16bit */
#define APB_NCO01_NCO0_PWS_ck2_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK2 of 8bit */
#define APB_NCO01_NCO0_PWS_ck4_w                    ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):CK4 of 32bit */
#define APB_NCO01_NCO0_PWS_ck4_h1                   ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CK4 of 16bit */
#define APB_NCO01_NCO0_PWS_ck4_b3                   ((uint8_t )0x02)        /*!< Bit Value =(0x2):CK4 of 8bit */
#define APB_NCO01_NCO0_PWS_ck8_w                    ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):CK8 of 32bit */
#define APB_NCO01_NCO0_PWS_ck8_h1                   ((uint16_t)0x0300)      /*!< Bit Value =(0x3):CK8 of 16bit */
#define APB_NCO01_NCO0_PWS_ck8_b3                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):CK8 of 8bit */
#define APB_NCO01_NCO0_PWS_ck16_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):CK16 of 32bit */
#define APB_NCO01_NCO0_PWS_ck16_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CK16 of 16bit */
#define APB_NCO01_NCO0_PWS_ck16_b3                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):CK16 of 8bit */
#define APB_NCO01_NCO0_PWS_ck32_w                   ((uint32_t)0x05000000)  /*!< Bit Value =(0x5):CK32 of 32bit */
#define APB_NCO01_NCO0_PWS_ck32_h1                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):CK32 of 16bit */
#define APB_NCO01_NCO0_PWS_ck32_b3                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):CK32 of 8bit */
#define APB_NCO01_NCO0_PWS_ck64_w                   ((uint32_t)0x06000000)  /*!< Bit Value =(0x6):CK64 of 32bit */
#define APB_NCO01_NCO0_PWS_ck64_h1                  ((uint16_t)0x0600)      /*!< Bit Value =(0x6):CK64 of 16bit */
#define APB_NCO01_NCO0_PWS_ck64_b3                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):CK64 of 8bit */
#define APB_NCO01_NCO0_PWS_ck128_w                  ((uint32_t)0x07000000)  /*!< Bit Value =(0x7):CK128 of 32bit */
#define APB_NCO01_NCO0_PWS_ck128_h1                 ((uint16_t)0x0700)      /*!< Bit Value =(0x7):CK128 of 16bit */
#define APB_NCO01_NCO0_PWS_ck128_b3                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):CK128 of 8bit */

#define APB_NCO01_NCO0_ACC_mask_w                   ((uint32_t)0x000FFFFF)  /*!< Bit Mask of 32bit */
#define APB_NCO01_NCO0_ACC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define APB_NCO01_NCO0_ACC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define APB_NCO01_NCO0_ACC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_APB_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_APB.h                           */
/*----------------------------------------------------------------------------*/
