/**
  ******************************************************************************
 *
 * @file        Sample_MID_TM26_QEI.c
 *
 * @brief       TM26 QEI setup.
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_MID.h"
#include "RTE_Components.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static TM_HandleTypeDef    mTM26;

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_TM26_QEI(void);
void TM2x_IRQHandler(void);
void MID_TM_QEI_INDEXCallback(TM_HandleTypeDef* mTM);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    TM26 QEI setup.
 * @details     1.TM26 Setup parameters.
 *    \n        2.TM26 clock initial.
 *    \n        3.QEI configuration.
 *    \n        4.Start QEI with interrupt service.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_TM26_QEI(void)
{      
    TM_Encoder_InitTypeDef TM26Encoder;
    TM_ClockConfigTypeDef CKConfig;

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->TM26 = Enable
    //Configure Peripheral On Mode Clock->TM26 = Enable
	
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOB->PB4,PB5,PB6
    //GPIO port initial is 0xFFFF
    //PB4,PB5 mode is PPO
    //PB4,PB5 function TM20_IC0,TM20_IC1
    
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOB->PB6
    //PB6 mode is PPO
    //PB6 function TM20_ETR
        
    // ------------------------------------------------------------------------
    // 1.TM26 Setup parameters.
    // ------------------------------------------------------------------------
    mTM26.Instance                  = TM26;
    mTM26.Init.TM_CounterMode       = TM_CASCADE_UP;
    mTM26.Init.TM_Period            = 20;
    mTM26.Init.TM_Prescaler         = 3;
    MID_TM_Encoder_Init(&mTM26);
    
    // ------------------------------------------------------------------------
    // 2.TM26 clock initial.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = TM_EXTERNAL_ETR;              
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    MID_TM_ConfigClockSource(&mTM26, &CKConfig);  
    
    // ------------------------------------------------------------------------
    // 3.QEI configuration.
    // ------------------------------------------------------------------------
    TM26Encoder.EncoderMode         = TM_ENCODERMODE_BOTHEDGE;
    TM26Encoder.EncoderDirection    = TM_ENCODER_DIRECTION_NORMAL;
    TM26Encoder.EncoderReset        = TM_ENCODER_RESET_DISABLE;
    TM26Encoder.IC0Selection        = MID_TM_INPUTMUX_PIN;
    TM26Encoder.IC1Selection        = MID_TM_INPUTMUX_PIN;
//    MID_TM_Encoder_Start(&mTM26, &TM26Encoder); 
    
    // ------------------------------------------------------------------------
    // 4.Start QEI with interrupt service.
    // ------------------------------------------------------------------------
    #ifndef MG32_TM26_IRQ_
        NVIC_EnableIRQ(TM2x_IRQn);
    #endif
    MID_TM_Encoder_Start_IT(&mTM26, &TM26Encoder, TM_IT_QEI_DIRCHANGE); 
    
}

/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
#ifndef MG32_TM26_IRQ_
void TM2x_IRQHandler(void)
{
    MID_TM_IRQHandler(&mTM26);
}
#endif

/**
 *******************************************************************************
 * @brief       QEI index callback in non blocking mode.
 * @param[in]   mTM : pointer to a TM_HandleTypeDef
 * @return      None
 *******************************************************************************
 */
void MID_TM_QEI_INDEXCallback(TM_HandleTypeDef* mTM)
{
	// to do ...
    UNUSED(mTM);
}


