/**
  ******************************************************************************
 *
 * @file        Sample_MID_PW.c
 *
 * @brief       PW use interrupt sample code
 *
 * @par         Project
 *              MG32
 * @version     V2.43
 * @date        2021/09/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_MID.h"
#include "MG32_PW_MID.h"
#include "MG32_SYS_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_PW (void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       PW BODx use interrupt.
 * @details     1.DeInitial and Configure 
 *    \n        2.Entry STOP mode
 * @return      None
 *******************************************************************************
 */
void Sample_MID_PW (void)
{
    PW_BODxTypeDef BOD1_CFG;


    // make sure :
    //Keil toolbar "Manage Run-Time Environment" clik.
    //"IRQ handler" must be ticked in "MG32_ChipInit_Wizard"
    //When use PW, "Enable PW NVIC" of "MG32_IRQ_Handler" must be ticked in "MG32_ChipInit_Wizard"
    //
    // ------------------------------------------------------------------------
    // 1.DeInitial and Configure 
    // ------------------------------------------------------------------------
    
    MID_PW_DeInit();
    MID_UnProtectModuleReg(PWmodule);                   // Unprotect PW moduel
    BOD1_CFG.BODx_THRESHOLD = PW_BOD1_TH_2V4;           // Set BOD1 detect 2.4V
    BOD1_CFG.BODx_TRIGGER = PW_BODx_TRG_FALLING;        // BOD1 falling edge trigger
    MID_PW_ConfigBOD1 (&BOD1_CFG);                      // Init BOD1
    __DRV_PW_BOD1_STOP_MODE_POWER_ON_ENABLE();          // Turn on BOD1 power in STOP mode
    
    __DRV_PW_ENABLE_IT(PW_IT_BOD1 | PW_IT_IEA);         // Enable BOD1 interrput
    __DRV_SYS_ENABLE_IT(SYS_IT_IEA);                    // System interrupt all enable (include EMB/MEM/APB/CSC/RTC/PW/IWDT) 
    __DRV_BOD1_STOP_MODE_WAKRUP_DISABLE();              // Enable BOD1 stop mode power on
    __DRV_PW_ENABLE_BOD1();                             // Eenble BOD1
    
    __DRV_PW_WAKEUP_DELAY_SELECT(PW_WAKEUP_DLEAY_DT0);  // Setting STOP mode wakeup delay time 
    
    // Protect PW module register write
    MID_ProtectModuleReg(PWmodule);
    
    // ------------------------------------------------------------------------
    // 2.Entry STOP mode 
    // ------------------------------------------------------------------------
    MID_PW_EnterSTOPMode(PW_STOPENTRY_WFI);
    
}


/**
 *******************************************************************************
 * @brief       Middle power BOD0 call back
 * @details  
 * @return      None
 * @note
 * @par         Example
 * @code
    MID_PW_BOD0Callback();
 * @endcode
 *******************************************************************************
 */
void MID_PW_BOD0Callback (void)
{
    // To do ...
}


/**
 *******************************************************************************
 * @brief       Middle power BOD1 call back
 * @details  
 * @return      None
 * @note
 * @par         Example
 * @code
    MID_PW_BOD1Callback();
 * @endcode
 *******************************************************************************
 */
void MID_PW_BOD1Callback (void)
{
    // To do ...
}


#if defined(MG32_3RD)
/**
 *******************************************************************************
 * @brief       Middle power BOD2 call back
 * @details  
 * @return      None
 * @note
 * @par         Example
 * @code
    MID_PW_BOD2Callback();
 * @endcode
 *******************************************************************************
 */
void MID_PW_BOD2Callback (void)
{
    // To do ...
}
#endif
   

/**
 *******************************************************************************
 * @brief       Middle power wakeup call back
 * @details  
 * @return      None
 * @note
 * @par         Example
 * @code
    MID_PW_WKCallback();
 * @endcode
 *******************************************************************************
 */
void MID_PW_WKCallback (void)
{
    // To do ...
}






