/**
  ******************************************************************************
 *
 * @file        Sample_MID_GPL_HDIV.c
 *
 * @brief       GPL Hardware Divider sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */

/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "MG32_MID.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"

/* External vairables --------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Sample_MID_GPL_HDIV(void);
/* Exported constants --------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/ 
/* Exported macros -----------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_GPL_HDIV_Unsigned(void);
void Sample_MID_GPL_HDIV_Signed(void);

/**
 ******************************************************************************
 * Sample MID GPL HDIV Unsigned Calcuation
 ******************************************************************************
 */
void Sample_MID_GPL_HDIV_Unsigned(void)
{
    uint32_t lCount;
    uint32_t lDividend, lDivisor;
    uint32_t lQUITIENT, lREMAINDER;

    printf("+---------------------------------------------------------------------------------+\n\r");
    printf("| GPL HDIV(Hardware Divider) Unsigned Calcuation Sample Code                      |\n\r");
    printf("+---------------------------------------------------------------------------------+\n\r");

    lDividend = 1234567;
    lDivisor = 28;

    for(lCount = 0; lCount < 5; lCount ++)
    {
        lQUITIENT = MID_GPL_HDIV_UDIV(lDividend, lDivisor);
        lREMAINDER = __DRV_GPL_HDIV_GET_REMAINDER();
        //lREMAINDER = MID_GPL_HDIV_UMOD(lDividend, lDivisor);
        if(__MID_GPL_HDIV_IS_DIVBYZERO() == 0)
        {
            printf("    HDIV Calcuation %d / %d  = %d mod %d Divide by 0 flag %d\n\r", lDividend, lDivisor, lQUITIENT, lREMAINDER, __MID_GPL_HDIV_IS_DIVBYZERO());
            printf("    HDIV Calcuation %d / %d  = %d mod %d\n\r", lDividend, lDivisor, lDividend/lDivisor, lDividend%lDivisor);
            if((lQUITIENT == (lDividend / lDivisor)) && (lREMAINDER == (lDividend % lDivisor)))
                printf("    Division PASS\n\r");
            else
                printf("!!! Division FAIL\n\r");
        }
        else
        {
            printf("    HDIV calculation : %d / %d, divide by 0 !!!\n\r", lDividend, lDivisor);
            printf("    Divide by zero checking PASS !!!\n\r");
        }
        lDivisor -= 7;
        printf("\n\r");
    }

    printf("===== THE END =====================================================================\n\r\n\r");
}

/**
 ******************************************************************************
 * Sample MID GPL HDIV Signed Calcuation
 ******************************************************************************
 */
void Sample_MID_GPL_HDIV_Signed(void)
{
    uint32_t lCount;
    int32_t lDividend, lDivisor;
    int32_t lQUITIENT, lREMAINDER;

    printf("+---------------------------------------------------------------------------------+\n\r");
    printf("| GPL HDIV(Hardware Divider) Signed Calcuation Sample Code                        |\n\r");
    printf("+---------------------------------------------------------------------------------+\n\r");

    lDividend = 1234567;
    lDivisor = 21;

    for(lCount = 0; lCount < 7; lCount ++)
    {
        lQUITIENT = MID_GPL_HDIV_DIV(lDividend, lDivisor);
        lREMAINDER = (int32_t)__DRV_GPL_HDIV_GET_REMAINDER();
        //lREMAINDER = MID_GPL_HDIV_MOD(lDividend, lDivisor);
        if(__MID_GPL_HDIV_IS_DIVBYZERO() == 0)
        {
            printf("    HDIV Calcuation %d / %d  = %d mod %d Divide by 0 flag %d\n\r", lDividend, lDivisor, lQUITIENT, lREMAINDER, __MID_GPL_HDIV_IS_DIVBYZERO());
            printf("    HDIV Calcuation %d / %d  = %d mod %d\n\r", lDividend, lDivisor, lDividend/lDivisor, lDividend%lDivisor);
            if((lQUITIENT == (lDividend / lDivisor)) && (lREMAINDER == (lDividend % lDivisor)))
                printf("    Division PASS\n\r");
            else
                printf("!!! Division FAIL\n\r");
        }
        else
        {
            printf("    HDIV calculation : %d / %d, divide by 0 !!!\n\r", lDividend, lDivisor);
            printf("    Divide by zero checking PASS !!!\n\r");
        }

        lDivisor -= 7;
        printf("\n\r");
    }

    lDividend = -1234567;
    lDivisor = 21;

    for(lCount = 0; lCount < 7; lCount ++)
    {
        lQUITIENT = MID_GPL_HDIV_DIV(lDividend, lDivisor);
        lREMAINDER = (int32_t)__DRV_GPL_HDIV_GET_REMAINDER();
        //lREMAINDER = MID_GPL_HDIV_MOD(lDividend, lDivisor);
        if(__MID_GPL_HDIV_IS_DIVBYZERO() == 0)
        {
            printf("    HDIV Calcuation %d / %d  = %d mod %d Divide by 0 flag %d\n\r", lDividend, lDivisor, lQUITIENT, lREMAINDER, __MID_GPL_HDIV_IS_DIVBYZERO());
            printf("    HDIV Calcuation %d / %d  = %d mod %d\n\r", lDividend, lDivisor, lDividend/lDivisor, lDividend%lDivisor);
            if((lQUITIENT == (lDividend / lDivisor)) && (lREMAINDER == (lDividend % lDivisor)))
                printf("    Division PASS\n\r");
            else
                printf("!!! Division FAIL\n\r");
        }
        else
        {
            printf("    HDIV calculation : %d / %d, divide by 0 !!!\n\r", lDividend, lDivisor);
            printf("    Divide by zero checking PASS !!!\n\r");
        }

        lDivisor -= 7;
        printf("\n\r");
    }

    printf("===== THE END =====================================================================\n\r\n\r");
}

/**
 ******************************************************************************
 * Sample MID GPL HDIV Calcuation
 ******************************************************************************
 */
void Sample_MID_GPL_HDIV(void)
{
    Sample_MID_GPL_HDIV_Signed();

    Sample_MID_GPL_HDIV_Unsigned();
}


