/**
  ******************************************************************************
 *
 * @file        Sample_WWDT_Init.c
 *
 * @brief       WWDT sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.20
 * @date        2022/02/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_WWDT_Init (void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief  	    Sample IWDT init
 * @details     1. Enable CSC to WWDT clock
 *      \n      2. Configure WWDT clock
 *      \n      3. Setup threshold and reload value
 *      \n      4. Enable WWDT module
 *      \n      5. Check flag action
 *      \n      6. Disable WWDT module
 * @return	    None		
 * @note        
 * @par         Example
 * @code
    Sample_WWDT_Init();
 * @endcode
 *******************************************************************************
 */
void Sample_WWDT_Init (void)
{

    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12Mz
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Select CK_UT Divider = ILRCO/32
    //Configure Peripheral On Mode Clock->WWDT = Enable

//    /*=== 1. Enable CSC to WWDT clock ===*/
//    UnProtectModuleReg(CSCprotect);                                 // Unprotect CSC module
//    CSC_PeriphOnModeClock_Config(CSC_ON_WWDT, ENABLE);              // Enable WWDT module clock
//    ProtectModuleReg(CSCprotect);                                   // protect CSC module
    
    UnProtectModuleReg(WWDTprotect);                                // Unprotect WWDT module
    /*=== 2. Configure WWDT clock ===*/
    WWDT_DIV_Select(WWDT_DIV_1);                                    // DIV/1
    WWDT_PDIV_Select(WWDT_PDIV_1);                                  // PDIV/1
    WWDT_CLK_Select(WWDT_CK_UT);                                    // WWDT = CK_UT
    
    /*=== 3. Setup threshold and reload value ===*/
    WWDT_SetReloadReg(0x3FF);                                       // Reload register = 0x3FF
    WWDT_SetWindowThreshold(0x1FF);                                 // Window threshold = 0x1FF
    WWDT_SetWarningThreshold(0x0FF);                                // Waring threshold = 0x0FF

    /*=== 4. Enable WWDT module ===*/
    WWDT_Cmd(ENABLE);                                               // Enable WWDT module
    ProtectModuleReg(WWDTprotect);                                  // Protect WWDT module
    
    /*=== 5. Check flag action ===*/
    WWDT_RefreshCounter();                                          // Trigger WINF happened
    while(WWDT_GetSingleFlagStatus(WWDT_WINF) == DRV_UnHappened);   // Wait WINF happened
    WWDT_ClearFlag(WWDT_WINF);                                      // Clear WINF flag
    
    while(WWDT_GetSingleFlagStatus(WWDT_WRNF) == DRV_UnHappened);   // Wait WRNF happened
    WWDT_ClearFlag(WWDT_WRNF);                                      // Clear WRNF flag
    
    while(WWDT_GetSingleFlagStatus(WWDT_TF) == DRV_UnHappened);     // Wait TF happened
    WWDT_ClearFlag(WWDT_TF);                                        // Clear WRNF flag

    /*=== 6. Disable WWDT module ===*/
    UnProtectModuleReg(WWDTprotect);                                // Unprotect WWDT module
    WWDT_Cmd(DISABLE);                                              // Disable WWDT module
    ProtectModuleReg(WWDTprotect);                                  // Unprotect WWDT module

}



