

/**
 ******************************************************************************
 *
 * @file        Sample_URT4_UART_Init.c
 * @brief       The demo URT4'S initial sample C file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2025/08/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *  
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_URT_DRV.h"
#include "MG32_EXIC_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define URTX    URT4

#define EXIC_URT4567_ID 22
#define EXIC_URT4       0x01
#define EXIC_URT5       0x02
#define EXIC_URT6       0x04
#define EXIC_URT7       0x08

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_URT4_Init(void);
void URT4x_IRQHandler(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

 /**
 *******************************************************************************
 * @brief       Sample URT3 initial
 * @details     1. Set CSC initial.
 *     \n       2. Set GPIO initial.
 *     \n       3. Set RX/TX Baudrate.
 *     \n       4. Set data character.
 *     \n       8. Enable URT4 interrupt.
 *     \n       9. Enable URT4 
 *     \n      10. Receive data into interrupt function.
 *     \n      11. Send data of receive.
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void Sample_URT4_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    
    //==Set CSC init
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 11.0592M
    //Select CK_MAIN Source = CK_HS
    //Configure Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->Port A/URT4 = Enable
    //Configure Peripheral On Mode Clock->URT3->Select URT3_PR Source = CK_APB(12)
    
    //==Set GPIO init
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->Pin0/1
    //GPIO port initial is 0xFFFF
    //PA0 mode is PPO/PA1 mode is DIN
    //PA0 pull-up resister Enable
    //PA0/PA1 function URT4_TX/RX
    //(URT4 TX/RX pin refer to related data.)  
    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource    = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode           = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;                    //Set PSR
    URT_BRG.URT_BaudRateCounterReload  = 11;                   //Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);              //BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1) in URT Clock Source is 12MHz
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);                   //Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXOverSamplingSampleNumber_Select(URTX, 7);            //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 7);            //Set RX OS_NUM
    URT_TX_Cmd(URTX, ENABLE);                                  //Enable TX
    URT_RX_Cmd(URTX, ENABLE);                                  //Enable RX
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    URT_DataCharacter_Config(URTX, &DataDef);
    

    //=====Enable URT Interrupt=====//
    URT_IT_Config(URTX, URT_IT_RX, ENABLE);
    URT_ITEA_Cmd(URTX, ENABLE);
    NVIC_EnableIRQ(URT4x_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URTX, ENABLE);

}

/**
 *******************************************************************************
 * @brief	    URT4x IRQHandler 
 * @details     
 * @return      
 * @exception   No
 * @note 
 *******************************************************************************
 */
//void URT4x_IRQHandler(void)
//{
//    uint32_t URT123_IRQHandler_ITFlag;
//    uint32_t URT123_IRQHandler_Tmp;
//    uint8_t  URT123_IRQHandler_IDTmp;
//    
//    URT123_IRQHandler_IDTmp = EXIC_GetITSourceID(EXIC_URT4567_ID);
//    
//    if( URT123_IRQHandler_IDTmp & EXIC_URT4)
//    {
//        URT123_IRQHandler_ITFlag = URT_GetITAllFlagStatus(URTX) & URT_GetITStatus(URTX);
//        
//        if( URT123_IRQHandler_ITFlag & URT_IT_RX)
//        {
//            URT123_IRQHandler_Tmp  = URT_GetRXData(URTX);
//        
//            URT_SetTXData(URTX,1,URT123_IRQHandler_Tmp);
//        }
//    }
//}
