
/**
  ******************************************************************************
 *
 * @file        Sample_Enter_STOP_SLEEP_Mode.c
 *
 * @brief       Chip into STOP or SLEEP mode sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/02/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_EnterSLEEP_STOP (void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
*******************************************************************************
* @brief  	    Sample RTC init
* @details     1. Into SLEEP mode by __WFE();
*      \n      2. Into STOP mode by __WFE();
*      \n      3. Into SLEEP mode by __WFI();
*      \n      4. Into STOP mode by __WFI();
* @return	    None	
* @note        
               Please check private define, will define how to into SLEEP mode or STOP mode.
* @par         Example
* @code
   Sample_IntoSLEEPorSTOP();
* @endcode
*******************************************************************************
*/
void Sample_EnterSLEEP_STOP (void)
{
    /*=== 1. Chip work into SLEEP mode wake up only by interrupt ===*/
//    SLEEP_WFI();
    /*=== 2. Chip work into STOP mode wake up only by interrupt ===*/
    STOP_WFI();
    
/*
    // When event register is not 0, "WFE" will clear event register and not go to STOP/SLEEP Mode.
    // When event register is 0, "WFE" will go to STOP/SLEEP Mode.
    //=== 3. Chip work into SLEEP mode wake up by event or interrupt ===//
    SLEEP_WFE();
    //=== 4. Chip work into STOP mode wake up by event or interrupt ===//
    STOP_WFE();
*/

}


