
/**
 ******************************************************************************
 *
 * @file        TH222x_18_7Segment.c
 * @brief       This is to test TH222x 7Segment C file.
                
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_18_7Segment.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TH222x_7SEG_DISABLE     0
#define TH222x_7SEG_USER        1
#define TH222x_7SEG_SIGNED      2
#define TH222x_7SEG_UNSIGNED    3

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_7Segment_UpdateFlag;

static uint8_t  TH222x_7Segment_Status;
static uint8_t  TH222x_7Segment_DramaTime;
static uint8_t  TH222x_7Segment_DramaTimeMax;
static uint32_t TH222x_7Segment_BreakTime;
static uint32_t TH222x_7Segment_BreakTimeMax;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	 TH222x 7Segment parameter default initial.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_7SegmentParameter_DeInit(void)
{
    TH222x_7Segment_UpdateFlag   = 0;
    TH222x_7Segment_DramaTime    = 0;
    TH222x_7Segment_DramaTimeMax = 40;
    TH222x_7Segment_BreakTime    = 0;
    TH222x_7Segment_BreakTimeMax = 400;
    
    /*Set 7 Segment default mode*/
    TH222x_7Segment_Status = TH222x_7SEG_USER;
    BSP_7Segment_TriggerUserDefineDisplay();
    
}
/**
 *******************************************************************************
 * @brief	 TH222x 7Segment show signed value.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_7Segment_ShowSignedValue( int16_t TH222x_SEG7_iValueX)
{
    if(BSP_7Segment_ShowSignedValue(TH222x_SEG7_iValueX,0x0000)==SEG7_DISPLAY_SUCCESS)
    {
        TH222x_7Segment_Status    = TH222x_7SEG_SIGNED;
        TH222x_7Segment_BreakTime = 0;
    }
}
/**
 *******************************************************************************
 * @brief	 TH222x 7Segment show signed value.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_7Segment_ShowUnsignedValue( uint16_t TH222x_SEG7_iValueX)
{
    if(BSP_7Segment_ShowUnsignedValue(TH222x_SEG7_iValueX,0x0000)==SEG7_DISPLAY_SUCCESS)
    {
        TH222x_7Segment_Status    = TH222x_7SEG_UNSIGNED;
        TH222x_7Segment_BreakTime = 0;
    }
}
/**
 *******************************************************************************
 * @brief	 TH222x 7Segment parameter default initial.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_7Segment(void)
{
    if(TH222x_7Segment_UpdateFlag==0)
    {
        return;
    }        
    
    TH222x_7Segment_UpdateFlag = 0;

    if( TH222x_7Segment_Status == TH222x_7SEG_USER)
    {
        if( TH222x_7Segment_DramaTime < TH222x_7Segment_DramaTimeMax)
        {
            TH222x_7Segment_DramaTime = TH222x_7Segment_DramaTime + 1;
            return;
        }
        
        TH222x_7Segment_DramaTime = 0;
    }
    else if( TH222x_7Segment_BreakTime > TH222x_7Segment_BreakTimeMax)
    {
        TH222x_7Segment_Status    = TH222x_7SEG_USER;
        TH222x_7Segment_DramaTime = 0;
        BSP_7Segment_TriggerUserDefineDisplay();
    }
    else
    {
        TH222x_7Segment_BreakTime = TH222x_7Segment_BreakTime + 1;
    }
    BSP_7Segment_main();
}





