


/**
 ******************************************************************************
 *
 * @file        TH222x_13_SPIFlash.c
 * @brief       This is to test TH222x SPI Flash C file.
                
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/29
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_IWDT_DRV.h"
#include "TH222x_Global.h"
#include "BSP_13_SPIFlash.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static FlashCTR_TypeDef TH222x_Flash;

static uint8_t TH222x_SPI_ProgramFlashBuffer[10] = {0x05, 0x30, 0x06, 0x15, 0x5A, 0xA5, 0x11, 0x20, 0x09 , 0x12};
static uint8_t TH222x_SPI_ReadFlashBuffer[10];


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	 TH222x SPI Flash main function. 
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
uint8_t TH222x_SPIFlash(void)
{
    uint32_t TH222x_SPIFlashTmp;
    
    
    /*Disable IWDT*/
    UnProtectModuleReg(IWDTprotect);
    IWDT_Cmd(DISABLE);
    ProtectModuleReg(IWDTprotect);
    
    /*Initial SPI*/
    BSP_SPIFlash_Init();
    
    /*Check Flash ID*/
    if(BSP_SPIFlash_ReadFlashRDID()!= BSP_13_SPIFLASH_RDID)
    {
        return(TH222x_FAILURE);
    }
    
    /*Test Erase Flash*/
    BSP_SPIFlash_Erase(Flash_Erase_Sector,1);                        // Erase sector 1 ( Address = 0x1000 ~ 0x1FFF)
        
    TH222x_Flash.Address      = 0x1040;                              // Define address of flash program. 
    TH222x_Flash.Buffer       = &TH222x_SPI_ReadFlashBuffer[0];      // Define storage address of receive data from flash.
    TH222x_Flash.Total_Length = 10;                                  // Define size of read data from flash.
    BSP_SPIFlash_Read(TH222x_Flash,Flash_Read);                      // SPI read flash      
    
    for(TH222x_SPIFlashTmp=0;TH222x_SPIFlashTmp<10;TH222x_SPIFlashTmp++)
    {
        if( TH222x_SPI_ReadFlashBuffer[TH222x_SPIFlashTmp]!=0xFF)
        {
            return(TH222x_FAILURE);
        }
    }
    
    /*Test Program Flash */
    TH222x_Flash.Address      = 0x1040;                              // Define address of flash program. 
    TH222x_Flash.Buffer       = &TH222x_SPI_ProgramFlashBuffer[0];   // Define datas of flash program.
    TH222x_Flash.Total_Length = 10;                                  // Define size of flash program.
    BPS_SPIFlash_Program(TH222x_Flash,Flash_PageProgram);            // SPI program

    TH222x_Flash.Address      = 0x1040;                              // Define address of flash program. 
    TH222x_Flash.Buffer       = &TH222x_SPI_ReadFlashBuffer[0];      // Define storage address of receive data from flash.
    TH222x_Flash.Total_Length = 10;                                  // Define size of read data from flash.
    BSP_SPIFlash_Read(TH222x_Flash,Flash_Read);                      // SPI read flash 
    
    for(TH222x_SPIFlashTmp=0;TH222x_SPIFlashTmp<10;TH222x_SPIFlashTmp++)
    {
        if( TH222x_SPI_ReadFlashBuffer[TH222x_SPIFlashTmp]!=TH222x_SPI_ProgramFlashBuffer[TH222x_SPIFlashTmp])
        {
            return(TH222x_FAILURE);
        }
    }
    
    
    
    return(TH222x_SUCCESS);
}











