

/**
 ******************************************************************************
 *
 * @file        LCD_MG04_06.h
 * @brief       The code is Using SPI of MG32 to control ILI9341 
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#ifndef __MG32_SPILCD_H

#define __MG32_SPILCD_H

#include "MG32_GPIO_DRV.h"
#include "MG32_SPI_DRV.h"
#include "MG32_URT_DRV.h"



/** 
 * @name  define
 */
///@{
                                                   
/* GPIO */
#define LCD_RSTN_IOM         PINB(4)
#define LCD_RSTN_AFS         0


#define LCD_RS_IOM           PINC(7)
#define LCD_RS_AFS           0

#define LCD_SDI_IOM          PINA(4)      // Use URT0_TX
#define LCD_SDI_AFS          11

#define LCD_SDO_IOM          PINA(5)      // Use URT0_RX
#define LCD_SDO_AFS          11

#define LCD_SCK_IOM          PINA(6)      // Use URT0_CLK
#define LCD_SCK_AFS          11

#define LCD_CS_IOM           PINB(7)      
#define LCD_CS_AFS           0

#define LCD_BL_IOM           PINE(9)        
#define LCD_BL_AFS           0


#define LCD_RSTN             PB4
#define LCD_RS               PC7
#define LCD_CS               PB7
#define LCD_BL               PE9

 
/* LCD Hardware Control */
#define  LCD_SPI                    URT0
#define  LCD_SPI_TXF                URT_STA_TXF_mask_w
#define  LCD_SPI_TCF                URT_STA_TCF_mask_w


#define __SPI_LCD_RESET_ENABLE()    LCD_RSTN = CLR
#define __SPI_LCD_RESET_DISABLE()   LCD_RSTN = SET

#define __SPI_LCD_BACKLIGHT_ON()    LCD_BL = SET
#define __SPI_LCD_BACKLIGHT_OFF()   LCD_BL = CLR


#define __LCD_CS_CLR()              LCD_CS = CLR
#define __LCD_CS_SET()              LCD_CS = SET

#define __LCD_RS_CLR()              LCD_RS = CLR
#define __LCD_RS_SET()              LCD_RS = SET

 
/* LCD */ 
 
/* LCD String Size */
//#define LCD_Pixel_320        320
//#define LCD_Pixel_240        240
#define LCD_STRING_SIZE      16
                             
    
/* LCD Color */    
#define WHITE                0xFFFF
#define LIGHTGREY            0xC618
#define DARKGREY             0x7BEF
#define BLACK                0x0000
#define BLUE                 0x001F 
#define NAVY_BLUE            0x000F
#define DARKCYAN             0x03EF
#define CYAN                 0x07FF
#define GREEN                0x07E0
#define DARK_GREEN           0x03E0
#define OLIVE                0x7BE0
#define GREEN_YELLOW         0xAFE5
#define YELLOW               0xFFE0
#define ORANGE               0xFD20      
#define MAROON               0x7800
#define RED                  0xF800
#define MAGENTA              0xF81F
#define PURPLE               0x780F



/**/
#define L2R_U2D        0 
#define L2R_D2U        1 
#define R2L_U2D        2 
#define R2L_D2U        3 
                       
#define U2D_L2R        4 
#define U2D_R2L        5 
#define D2U_L2R        6 
#define D2U_R2L        7 

#define DFT_SCAN_DIR   L2R_U2D 


/**/
#define R0             0x00
#define R1             0x01
#define R2             0x02
#define R3             0x03
#define R4             0x04
#define R5             0x05
#define R6             0x06
#define R7             0x07
#define R8             0x08
#define R9             0x09
#define R10            0x0A
#define R12            0x0C
#define R13            0x0D
#define R14            0x0E
#define R15            0x0F
#define R16            0x10
#define R17            0x11
#define R18            0x12
#define R19            0x13
#define R20            0x14
#define R21            0x15
#define R22            0x16
#define R23            0x17
#define R24            0x18
#define R25            0x19
#define R26            0x1A
#define R27            0x1B
#define R28            0x1C
#define R29            0x1D
#define R30            0x1E
#define R31            0x1F
#define R32            0x20
#define R33            0x21
#define R34            0x22
#define R36            0x24
#define R37            0x25
#define R40            0x28
#define R41            0x29
#define R43            0x2B
#define R45            0x2D
#define R48            0x30
#define R49            0x31
#define R50            0x32
#define R51            0x33
#define R52            0x34
#define R53            0x35
#define R54            0x36
#define R55            0x37
#define R56            0x38
#define R57            0x39
#define R59            0x3B
#define R60            0x3C
#define R61            0x3D
#define R62            0x3E
#define R63            0x3F
#define R64            0x40
#define R65            0x41
#define R66            0x42
#define R67            0x43
#define R68            0x44
#define R69            0x45
#define R70            0x46
#define R71            0x47
#define R72            0x48
#define R73            0x49
#define R74            0x4A
#define R75            0x4B
#define R76            0x4C
#define R77            0x4D
#define R78            0x4E
#define R79            0x4F
#define R80            0x50
#define R81            0x51
#define R82            0x52
#define R83            0x53
#define R96            0x60
#define R97            0x61
#define R106           0x6A
#define R118           0x76
#define R128           0x80
#define R129           0x81
#define R130           0x82
#define R131           0x83
#define R132           0x84
#define R133           0x85
#define R134           0x86
#define R135           0x87
#define R136           0x88
#define R137           0x89
#define R139           0x8B
#define R140           0x8C
#define R141           0x8D
#define R143           0x8F
#define R144           0x90
#define R145           0x91
#define R146           0x92
#define R147           0x93
#define R148           0x94
#define R149           0x95
#define R150           0x96
#define R151           0x97
#define R152           0x98
#define R153           0x99
#define R154           0x9A
#define R157           0x9D
#define R192           0xC0
#define R193           0xC1
#define R229           0xE5


/* LCD use IRQHandler*/
#define BSP_LCD_IRQHandler  URT0_IRQHandler          /*!< LCD use UART0 module SPI mode so LCD IRQHandler is URT0_IRQHandler*/


//
#define BSP_LCDFormatSize 4 


///@}


/** 
 * @name  typedef
 */                                                      
///@{ 


/*! @enum   LCD_Status_TypeDef
    @brief  LCD status type
*/
typedef enum
{
    LCD_Idle,
    LCD_Busy,
}LCD_Status_TypeDef;           


/*! @struct Display_HandleTypeDef
    @brief  LCD control struct
*/
typedef struct __Display_HandleTypeDef{
    
    void(* Reset)(uint32_t Times);
    void(* BackLight)(uint16_t Duty);       

    void(* SelectReg)(uint16_t Register);
    void(* WriteData)(uint16_t Value);
    void(* WriteData8)(uint8_t Value);

    uint16_t(* ReadData)(void);

    void(* WriteRegister)(uint16_t Register, uint16_t Value); 

    __IO uint32_t            Direct;     
    
    
    __IO uint16_t            ID;            
    __IO uint16_t            Width;         
    __IO uint16_t            Height;        
    __IO uint16_t            SetXcmd;       
    __IO uint16_t            SetYcmd;        
    __IO uint16_t            GRAMcmd;        
    __IO uint16_t            PointColor;
    __IO uint16_t            BackColor;
    
    __IO uint32_t            FlashAddress;
    
    __IO LCD_Status_TypeDef  State;  
         uint8_t             __padding[3];
}Display_HandleTypeDef;


///@} 

  
/** 
 * @name  Parameter
 */                                                      
///@{
 
extern Display_HandleTypeDef LCD_CTR;


///@}


/** 
 * @name  Function
 */                                                      
///@{

void API_LCD_Init(void);




void BSP_LCD_FillMonochrome(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t color);
void BSP_LCD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint16_t Color);
void BSP_LCD_ShowString(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, char *p);
void BSP_LCD_Clear(uint16_t color);


void BSP_LCD_InitCallback(void);


///@}

#endif
