/**
 ******************************************************************************
 *
 * @file        MG32_IWDT.h
 *
 * @brief       MG32 IWDT Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.11 (Register File Date : 2025_0704)
 * @date        2025/07/04 11:56 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_IWDT_H
#define _MG32_IWDT_H
#define _MG32_IWDT_H_VER                            111     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_IWDT_H_VER)
    #error "_MG32_IWDT_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      IWDT_Struct
 *              IWDT  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  TF            :1;     //[1] IWDT timer timeout interrupt flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EW0F          :1;     //[2] IWDT early wakeup-0 flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EW1F          :1;     //[3] IWDT early wakeup-1 flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  IWDT status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  TIE           :1;     //[1] IWDT timer timeout interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EW0_IE        :1;     //[2] IWDT early wakeup-0 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EW1_IE        :1;     //[3] IWDT early wakeup-1 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  IWDT interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  CK_DIV        :4;     //[7..4] IWDT internal clock CK_IWDT_INT input divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
                                        //0x5 = DIV32 : divided by 32
                                        //0x6 = DIV64 : divided by 64
                                        //0x7 = DIV128 : divided by 128
                                        //0x8 = DIV256 : divided by 256 
                                        //0x9 = DIV512 : divided by 512
                                        //0xA = DIV1024 : divided by 1024
                                        //0xB = DIV2048 : divided by 2048
                                        //0xC = DIV4096 : divided by 4096
                                        //0xD = Reserved
                                        //0xE = Reserved
                                        //0xF = Reserved
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  IWDT clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] IWDT key register and counter reload enable control
                                        //0 = Unprotected
                                        //1 = Protected
            __IO uint16_t LOCK          :16;    //[31..16] IWDT lock register
                                        //0 = Unlocked
                                        //1 = Locked
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  IWDT write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] IWDT function enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :6;     //[7..2] 
            __IO uint8_t  TF_WPEN       :1;     //[8] IWDT detect IWDT_TF flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  EW0_WPEN      :1;     //[10] IWDT detect IWDT_EW0F flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EW1_WPEN      :1;     //[11] IWDT detect IWDT_EW1F flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  IWDT control register 0 */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  CNT           :8;     //[7..0] IWDT counter value register.
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CNT;                               /*!< CNT        ~ Offset[0x18]  IWDT counter register */

} IWDT_Struct;

/**
 ******************************************************************************
 *
 * @name        IWDT  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define IWDT_Base                       ((uint32_t)0x5D000000)              /*!< Independent Watch Dog Timer Control */
#define IWDT                            ((IWDT_Struct*) IWDT_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        IWDT  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        IWDT_STA  [register's definitions]
 *              Offset[0x00]  IWDT status register (0x5D000000)
 ******************************************************************************
 */
///@{
#define IWDT_STA_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_STA */
#define IWDT_STA_EW1F_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define IWDT_STA_EW1F_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define IWDT_STA_EW1F_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define IWDT_STA_EW1F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define IWDT_STA_EW1F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define IWDT_STA_EW1F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define IWDT_STA_EW1F_happened_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define IWDT_STA_EW1F_happened_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define IWDT_STA_EW1F_happened_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define IWDT_STA_EW0F_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define IWDT_STA_EW0F_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define IWDT_STA_EW0F_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define IWDT_STA_EW0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define IWDT_STA_EW0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define IWDT_STA_EW0F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define IWDT_STA_EW0F_happened_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define IWDT_STA_EW0F_happened_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define IWDT_STA_EW0F_happened_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define IWDT_STA_TF_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define IWDT_STA_TF_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define IWDT_STA_TF_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define IWDT_STA_TF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define IWDT_STA_TF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define IWDT_STA_TF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define IWDT_STA_TF_happened_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define IWDT_STA_TF_happened_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define IWDT_STA_TF_happened_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        IWDT_INT  [register's definitions]
 *              Offset[0x04]  IWDT interrupt enable register (0x5D000004)
 ******************************************************************************
 */
///@{
#define IWDT_INT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_INT */
#define IWDT_INT_EW1_IE_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define IWDT_INT_EW1_IE_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define IWDT_INT_EW1_IE_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define IWDT_INT_EW1_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_INT_EW1_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_INT_EW1_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_INT_EW1_IE_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_INT_EW1_IE_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_INT_EW1_IE_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define IWDT_INT_EW0_IE_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define IWDT_INT_EW0_IE_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define IWDT_INT_EW0_IE_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define IWDT_INT_EW0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_INT_EW0_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_INT_EW0_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_INT_EW0_IE_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_INT_EW0_IE_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_INT_EW0_IE_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define IWDT_INT_TIE_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define IWDT_INT_TIE_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define IWDT_INT_TIE_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define IWDT_INT_TIE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_INT_TIE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_INT_TIE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_INT_TIE_enable_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_INT_TIE_enable_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_INT_TIE_enable_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        IWDT_CLK  [register's definitions]
 *              Offset[0x08]  IWDT clock source register (0x5D000008)
 ******************************************************************************
 */
///@{
#define IWDT_CLK_default                            ((uint32_t)0x000000C0)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_CLK */
#define IWDT_CLK_CK_DIV_mask_w                      ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define IWDT_CLK_CK_DIV_mask_h0                     ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define IWDT_CLK_CK_DIV_mask_b0                     ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define IWDT_CLK_CK_DIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define IWDT_CLK_CK_DIV_div1_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define IWDT_CLK_CK_DIV_div1_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define IWDT_CLK_CK_DIV_div2_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define IWDT_CLK_CK_DIV_div2_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define IWDT_CLK_CK_DIV_div2_b0                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define IWDT_CLK_CK_DIV_div4_w                      ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define IWDT_CLK_CK_DIV_div4_h0                     ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define IWDT_CLK_CK_DIV_div4_b0                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define IWDT_CLK_CK_DIV_div8_w                      ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define IWDT_CLK_CK_DIV_div8_h0                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define IWDT_CLK_CK_DIV_div8_b0                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define IWDT_CLK_CK_DIV_div16_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define IWDT_CLK_CK_DIV_div16_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define IWDT_CLK_CK_DIV_div16_b0                    ((uint8_t )0x40)        /*!< Bit Value =(0x4):DIV16 of 8bit */
#define IWDT_CLK_CK_DIV_div32_w                     ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):DIV32 of 32bit */
#define IWDT_CLK_CK_DIV_div32_h0                    ((uint16_t)0x0050)      /*!< Bit Value =(0x5):DIV32 of 16bit */
#define IWDT_CLK_CK_DIV_div32_b0                    ((uint8_t )0x50)        /*!< Bit Value =(0x5):DIV32 of 8bit */
#define IWDT_CLK_CK_DIV_div64_w                     ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):DIV64 of 32bit */
#define IWDT_CLK_CK_DIV_div64_h0                    ((uint16_t)0x0060)      /*!< Bit Value =(0x6):DIV64 of 16bit */
#define IWDT_CLK_CK_DIV_div64_b0                    ((uint8_t )0x60)        /*!< Bit Value =(0x6):DIV64 of 8bit */
#define IWDT_CLK_CK_DIV_div128_w                    ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):DIV128 of 32bit */
#define IWDT_CLK_CK_DIV_div128_h0                   ((uint16_t)0x0070)      /*!< Bit Value =(0x7):DIV128 of 16bit */
#define IWDT_CLK_CK_DIV_div128_b0                   ((uint8_t )0x70)        /*!< Bit Value =(0x7):DIV128 of 8bit */
#define IWDT_CLK_CK_DIV_div256_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(0x8):DIV256 of 32bit */
#define IWDT_CLK_CK_DIV_div256_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(0x8):DIV256 of 16bit */
#define IWDT_CLK_CK_DIV_div256_b0                   ((uint8_t )0x80)        /*!< Bit Value =(0x8):DIV256 of 8bit */
#define IWDT_CLK_CK_DIV_div512_w                    ((uint32_t)0x00000090)  /*!< Bit Value =(0x9):DIV512 of 32bit */
#define IWDT_CLK_CK_DIV_div512_h0                   ((uint16_t)0x0090)      /*!< Bit Value =(0x9):DIV512 of 16bit */
#define IWDT_CLK_CK_DIV_div512_b0                   ((uint8_t )0x90)        /*!< Bit Value =(0x9):DIV512 of 8bit */
#define IWDT_CLK_CK_DIV_div1024_w                   ((uint32_t)0x000000A0)  /*!< Bit Value =(0xA):DIV1024 of 32bit */
#define IWDT_CLK_CK_DIV_div1024_h0                  ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):DIV1024 of 16bit */
#define IWDT_CLK_CK_DIV_div1024_b0                  ((uint8_t )0xA0)        /*!< Bit Value =(0xA):DIV1024 of 8bit */
#define IWDT_CLK_CK_DIV_div2048_w                   ((uint32_t)0x000000B0)  /*!< Bit Value =(0xB):DIV2048 of 32bit */
#define IWDT_CLK_CK_DIV_div2048_h0                  ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):DIV2048 of 16bit */
#define IWDT_CLK_CK_DIV_div2048_b0                  ((uint8_t )0xB0)        /*!< Bit Value =(0xB):DIV2048 of 8bit */
#define IWDT_CLK_CK_DIV_div4096_w                   ((uint32_t)0x000000C0)  /*!< Bit Value =(0xC):DIV4096 of 32bit */
#define IWDT_CLK_CK_DIV_div4096_h0                  ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):DIV4096 of 16bit */
#define IWDT_CLK_CK_DIV_div4096_b0                  ((uint8_t )0xC0)        /*!< Bit Value =(0xC):DIV4096 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        IWDT_KEY  [register's definitions]
 *              Offset[0x0C]  IWDT write protected Key register (0x5D00000C)
 ******************************************************************************
 */
///@{
#define IWDT_KEY_default                            ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_KEY */
#define IWDT_KEY_LOCK_mask_w                        ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define IWDT_KEY_LOCK_mask_h1                       ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define IWDT_KEY_LOCK_unlocked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unlocked of 32bit */
#define IWDT_KEY_LOCK_unlocked_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Unlocked of 16bit */
#define IWDT_KEY_LOCK_unlocked_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Unlocked of 8bit */
#define IWDT_KEY_LOCK_locked_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(1):Locked of 32bit */
#define IWDT_KEY_LOCK_locked_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Locked of 16bit */
#define IWDT_KEY_LOCK_locked_b2                     ((uint8_t )0x01)        /*!< Bit Value =(1):Locked of 8bit */

#define IWDT_KEY_KEY_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define IWDT_KEY_KEY_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define IWDT_KEY_KEY_unprotected_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define IWDT_KEY_KEY_unprotected_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define IWDT_KEY_KEY_unprotected_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define IWDT_KEY_KEY_protected_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define IWDT_KEY_KEY_protected_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define IWDT_KEY_KEY_protected_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        IWDT_CR0  [register's definitions]
 *              Offset[0x10]  IWDT control register 0 (0x5D000010)
 ******************************************************************************
 */
///@{
#define IWDT_CR0_default                            ((uint32_t)0x00000003)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_CR0 */
#define IWDT_CR0_EW1_WPEN_mask_w                    ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define IWDT_CR0_EW1_WPEN_mask_h0                   ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define IWDT_CR0_EW1_WPEN_mask_b1                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define IWDT_CR0_EW1_WPEN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_CR0_EW1_WPEN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_CR0_EW1_WPEN_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_CR0_EW1_WPEN_enable_w                  ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_CR0_EW1_WPEN_enable_h0                 ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_CR0_EW1_WPEN_enable_b1                 ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define IWDT_CR0_EW0_WPEN_mask_w                    ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define IWDT_CR0_EW0_WPEN_mask_h0                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define IWDT_CR0_EW0_WPEN_mask_b1                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define IWDT_CR0_EW0_WPEN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_CR0_EW0_WPEN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_CR0_EW0_WPEN_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_CR0_EW0_WPEN_enable_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_CR0_EW0_WPEN_enable_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_CR0_EW0_WPEN_enable_b1                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define IWDT_CR0_TF_WPEN_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define IWDT_CR0_TF_WPEN_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define IWDT_CR0_TF_WPEN_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define IWDT_CR0_TF_WPEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_CR0_TF_WPEN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_CR0_TF_WPEN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_CR0_TF_WPEN_enable_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_CR0_TF_WPEN_enable_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_CR0_TF_WPEN_enable_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define IWDT_CR0_EN_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define IWDT_CR0_EN_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define IWDT_CR0_EN_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define IWDT_CR0_EN_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define IWDT_CR0_EN_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define IWDT_CR0_EN_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define IWDT_CR0_EN_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define IWDT_CR0_EN_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define IWDT_CR0_EN_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        IWDT_CNT  [register's definitions]
 *              Offset[0x18]  IWDT counter register (0x5D000018)
 ******************************************************************************
 */
///@{
#define IWDT_CNT_default                            ((uint32_t)0x000000FF)  /*!< Reg Reset Default Value */

/* Bit fields of IWDT_CNT */
#define IWDT_CNT_CNT_mask_w                         ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define IWDT_CNT_CNT_mask_h0                        ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define IWDT_CNT_CNT_mask_b0                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define IWDT_CNT_CNT_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define IWDT_CNT_CNT_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define IWDT_CNT_CNT_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_IWDT_H

/*----------------------------------------------------------------------------*/
/*                          End of file MG32_IWDT.h                           */
/*----------------------------------------------------------------------------*/
