
/**
 ******************************************************************************
 *
 * @file        MG32_ChipInit.H
 *
 * @brief       By the file select you want to function initial.
 * @par         Project
 *              MG32F02K128
 * @version     V1.00
 * @date        2024/10/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par     Disclaimer 
 *    The Demo software is provided "AS IS"  without any warranty, either 
 *    expressed or implied, including, but not limited to, the implied warranties 
 *    of merchantability and fitness for a particular purpose.  The author will 
 *    not be liable for any special, incidental, consequential or indirect 
 *    damages due to loss of data or any other reason. 
 *    These statements agree with the world wide and local dictated laws about 
 *    authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 How to use the file :
 1. Right click "MG32_ChipInit.h" in Project Explorer window.
 2. Left click "CMSIS Configuration Wizard" in "Open With".
 ******************************************************************************
 */

#ifndef _MG32_ChipInit_H
 
#define _MG32_ChipInit_H

/* Wizard menu ---------------------------------------------------------------*/
// <<< Use Configuration Wizard in Context Menu >>>
//  <h> ChipInit_Wizard
//    <q0> ADC 
//      <i> ADC Initial wizard for Megawin MG32 Series.
#define Initial_ADC_Module          0       // 0 = Disable, 1 = Enable

//    <q0> APB 
//      <i> APB Initial wizard for Megawin MG32 Series.
#define Initial_APB_Module          0       // 0 = Disable, 1 = Enable

//    <q0> APX_CCL
//      <i> APX_CCL Initial wizard for Megawin MG32 Series.
#define Initial_APX_CCL_Module      0       // 0 = Disable, 1 = Enable

//    <q0> CMP 
//      <i> CMP Initial wizard for Megawin MG32 Series.
#define Initial_CMP_Module          0       // 0 = Disable, 1 = Enable

//    <q0> CSC 
//      <i> Clock Source Control for Megawin MG32 Series.
#define Initial_CSC_Module          1       // 0 = Disable, 1 = Enable

//    <e0> EXIC 
//      <i> EXIC Initial wizard for Megawin MG32 Series.
#define Initial_EXIC_Module         0       // 0 = Disable, 1 = Enable
//      <o0> The IC package selection for GPIO <0=> LQFP80 <1=> LQFP64
#define EXIC_PackageOption          0
//    </e>

//    <e0> GPIO 
//      <i> GPIO Initial wizard for Megawin MG32 Series.
#define Initial_GPIO_Module         0       // 0 = Disable, 1 = Enable
//      <o0> The IC package selection for GPIO <0=> LQFP80 <1=> LQFP64
#define GPIO_PackageOption          0
//    </e>

//    <q0> GPL 
//      <i> GPL Initial wizard for Megawin MG32 Series.
#define Initial_GPL_Module          0       // 0 = Disable, 1 = Enable

//    <q0> I2C
//      <i> I2C Initial wizard for Megawin MG32 Series.
#define Initial_I2C_Module          0       // 0 = Disable, 1 = Enable

//    <q0> IWDT
//      <i> IWDT Initial wizard for Megawin MG32 Series.
#define Initial_IWDT_Module         0       // 0 = Disable, 1 = Enable

//    <q0> LCD
//      <i> LCD Initial wizard for Megawin MG32 Series.
#define Initial_LCD_Module          0       // 0 = Disable, 1 = Enable

//    <q0> MEM 
//      <i> MEM Initial wizard for Megawin MG32 Series.
#define Initial_MEM_Module          0       // 0 = Disable, 1 = Enable

//    <q0> OPA
//      <i> OPA Initial wizard for Megawin MG32 Series.
#define Initial_OPA_Module          0       // 0 = Disable, 1 = Enable

//    <q0> PW 
//      <i> Power Initial wizard for Megawin MG32 Series.
#define Initial_PW_Module           0       // 0 = Disable, 1 = Enable

//    <q0> RST 
//      <i> Reset Initial wizard for Megawin MG32 Series.
#define Initial_RST_Module          0       // 0 = Disable, 1 = Enable

//    <q0> RTC 
//      <i> RTC Initial wizard for Megawin MG32 Series.
#define Initial_RTC_Module          0       // 0 = Disable, 1 = Enable

//    <q0> SPI 
//      <i> SPI Initial wizard for Megawin MG32 Series.
#define Initial_SPI_Module          0       // 0 = Disable, 1 = Enable

//    <q0> Timer 
//      <i> TM Initial wizard for Megawin MG32 Series.
#define Initial_TM_Module           0       // 0 = Disable, 1 = Enable

//    <q0> URT 
//      <i> URTx Initial wizard for Megawin MG32 Series.
#define Initial_URT_Module          0       // 0 = Disable, 1 = Enable

//    <q0> WWDT
//      <i> WWDT Initial wizard for Megawin MG32 Series.
#define Initial_WWDT_Module         0       // 0 = Disable, 1 = Enable

// </h>

/*
 ******************************************************************************
 * MG32_IRQHandler routine:
 *   Megawin uses two definitions to control IRQ handler. 'Use_Driver_Code' or 
 *   'Use_Middleware_Code' options. But 'Use_Middleware_Code' priority is more 
 *   than 'Use_Driver_Code'.
 *
 *   'Use_Driver_Code'     : Use the 'Module_IRQ()' routine to simplify the
 *                           'Module_IRQHandler' routine. e.g. ADC_IRQ(); 
 *   'Use_Middleware_Code' : Refer 'MID_Module_IRQHandler' in MG32_Module_MID.c 
 *                           file. e.g. MID_ADC_IRQHandler(); 
 ******************************************************************************
 */
 
//  <h> IRQ_Handler routine support
//  ---------------------------------------------------------------------------
//    <q0> Enable 'Driver-level' support IRQ_Handler.c
//      <i> But 'Middleware_Code' priority is more than 'Driver_Code'.
//  ---------------------------------------------------------------------------
#define Use_Driver_Code             1       // 0 = Disable, 1 = Enable

//  ---------------------------------------------------------------------------
//    <q0> Enable 'Middleware-level' support IRQ_Handler.c
//      <i> But 'Middleware_Code' priority is more than 'Driver_Code'.
//  ---------------------------------------------------------------------------
#define Use_Middleware_Code         0       // 0 = Disable, 1 = Enable
//  </h>    
/*
 ******************************************************************************
 * Module IRQ handler control:
 *   User can define MG32 module IRQ handler function.      
 *   Description:
 *     1. User can input '0~4' for every module IRQ handler.
 *        0 = Disable this IRQ handler.
 *        1 = Enable IRQ handler and config priority to 'Level-0 (High)'
 *        2 = Enable IRQ handler and config priority to 'Level-1'
 *        3 = Enable IRQ handler and config priority to 'Level-2'
 *        4 = Enable IRQ handler and config priority to 'Level-3 (Low)'
 *     2. If user defined 'Initial_WWDT_IRQ' as '0'. That means disabling the 
 *        WWDT IRQ handler. 
 *     3. Or user define 'Initial_WWDT_IRQ' as '1'. That means enabling WWDT  
 *        IRQ handler and this priority is 0 'Level-0 (High)'. 
 *     4. The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 
 *        'Level-3 (Low)'.
 ******************************************************************************
 */
 
//  <h> IRQ_Handler
//  ---------------------------------------------------------------------------
//    <o0> 11.SVC priority <0=> Cortex-M0 default state <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_SVC_IRQ             0       // 0 = Disable this IRQ handler.
                                            // 1 = Enable IRQ handler and config priority to 'Level-0 (High)'
                                            // 2 = Enable IRQ handler and config priority to 'Level-1'
                                            // 3 = Enable IRQ handler and config priority to 'Level-2'
                                            // 4 = Enable IRQ handler and config priority to 'Level-3 (Low)'
                                            
//  ---------------------------------------------------------------------------
//    <o0> 14.PendSV NVIC priority <0=> Cortex-M0 default state <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_PendSV_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 15.SysTick NVIC priority <0=> Cortex-M0 default state <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_SysTick_IRQ         0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 16.Enable WWDT NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_WWDT_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 17.Enable SYS NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_SYS_IRQ             0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 19.Enable EXINT0 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_EXINT0_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 20.Enable EXINT1 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_EXINT1_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 21.Enable EXINT2 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_EXINT2_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 22.Enable EXINT3 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_EXINT3_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 23.Enable COMP NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_COMP_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 24.Enable DMA NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_DMA_IRQ             0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 26.Enable ADC NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_ADC_IRQ             0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 28.Enable TM0x NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM0x_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 29.Enable TM10 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM10_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 30.Enable TM1x NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM1x_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 31.Enable TM20 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM20_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 32.Enable TM2x NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM2x_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 33.Enable TM3x NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_TM3x_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 33.Enable LCD NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_LCD_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 36.Enable URT0 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_URT0_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 37.Enable URT123 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_URT123_IRQ          0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 38.Enable URT4x NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_URT4x_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 40.Enable SPI0 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_SPI0_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 44.Enable I2C0 NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_I2C0_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 45.Enable I2Cx NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_I2Cx_IRQ            0       // 0 = Disable, >1 = Enable & Set priority

//  ---------------------------------------------------------------------------
//    <o0> 47.Enable APX NVIC + priority <0=> Disable <1=> Level-0 (High) <2=> Level-1 <3=> Level-2 <4=> Level-3 (Low)
//      <i> The priority is 'Level-0 (High)' >  'Level-1' > 'Level-2' > 'Level-3 (Low)'.
//  ---------------------------------------------------------------------------
#define Initial_APX_IRQ              0       // 0 = Disable, >1 = Enable & Set priority

//   </h>
// <<< end of Configuration section >>>    

/* Private define ------------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/
// ----------------------------------------------------------------------------
/* Package : The IC package selection for GPIO & EXIC. */
// ----------------------------------------------------------------------------
#define PackageLQFP80     0
#define PackageLQFP64     1
#define PackageLQFP48     2
#define PackageQFN32      3
#define PackageTSSOP20    4
#define PackageLQFP32     5
#define PackageLQFP80U    6
#define PackageLQFP64U    7
#define PackageLQFP48U    8

/* Includes ------------------------------------------------------------------*/
#include "RTE_Components.h"         // From Keil "Manage Run-Time Enviroment' setting
//
#ifdef MG32_ConfigerWizard_PW   // "Manage Run-Time Enviroment" enable PW wizard
    #include "MG32_PW_Init.h"   // include "MG32_PW_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_RST  // "Manage Run-Time Enviroment" enable RST wizard
    #include "MG32_RST_Init.h"  // include "MG32_RST_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_GPIO // "Manage Run-Time Enviroment" enable GPIO wizard
    #include MG32_GPIO_FILENAME // include "MG32_GPIO_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CSC  // "Manage Run-Time Enviroment" enable CSC wizard
    #include "MG32_CSC_Init.h"  // include "MG32_CSC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_EXIC // "Manage Run-Time Enviroment" enable EXIC wizard
    #include MG32_EXIC_FILENAME // include "MG32_EXIC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_GPL  // "Manage Run-Time Enviroment" enable GPL wizard
    #include "MG32_GPL_Init.h"  // include "MG32_GPL_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_MEM  // "Manage Run-Time Enviroment" enable MEM wizard
    #include "MG32_MEM_Init.h"  // include "MG32_MEM_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_I2C  // "Manage Run-Time Enviroment" enable I2C wizard
    #include "MG32_I2C_Init.h"  // include "MG32_I2C_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_URT  // "Manage Run-Time Enviroment" enable URT wizard
    #include "MG32_URT_Init.h"  // include "MG32_URT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_SPI  // "Manage Run-Time Enviroment" enable SPI wizard
    #include "MG32_SPI_Init.h"  // include "MG32_SPI_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CAN0 // "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_CAN_Init.h" // include "MG32_CAN_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_TM   // "Manage Run-Time Enviroment" enable TM wizard
    #include "MG32_TM_Init.h"   // include "MG32_TM_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_LCD // "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_LCD_Init.h" // include "MG32_LCD_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_OPA // "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_OPA_Init.h" // include "MG32_OPA_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_ADC  // "Manage Run-Time Enviroment" enable ADC wizard
    #include "MG32_ADC_Init.h"  // include "MG32_ADC_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_CMP  // "Manage Run-Time Enviroment" enable CMP wizard
    #include "MG32_CMP_Init.h"  // include "MG32_CMP_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_IWDT // "Manage Run-Time Enviroment" enable IWDT wizard
    #include "MG32_IWDT_Init.h"  // include "MG32_IWDT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_WWDT // "Manage Run-Time Enviroment" enable WWDT wizard
    #include "MG32_WWDT_Init.h" // include "MG32_WWDT_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_RTC  // "Manage Run-Time Enviroment" enable RTC wizard
    #include "MG32_RTC_Init.h"  // include "MG32_CCL_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_APB  // "Manage Run-Time Enviroment" enable APB wizard
    #include "MG32_APB_Init.h"  // include "MG32_APB_Init.h" file
#endif

#ifdef MG32_ConfigerWizard_APX_CCL    // "Manage Run-Time Enviroment" enable APX CCL wizard
    #include "MG32_CCL_Init.h"  // include "MG32_CCL_Init.h" file
#endif


#include "MG32_SYS.h"

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/**
 * @name    Function announce
 * @brief   Chip Initial routine  
 */ 
///@{
void ChipInit(void);
///@}

/* External vairables --------------------------------------------------------*/


#endif
