
/**
 ******************************************************************************
 *
 * @file        TH222x_8_VariableResistor.c
 * @brief       This is to test TH222x Variable Resistor C file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/08
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_8_VariableResistor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_VR_UpdateFlag;                               // UpdateFlag=0 (Nothing)    
                                                            // UpdateFlag=1 (Needs to do ...)
                                                            
static uint8_t TH222x_VAR_Status[2];

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    TH222x variable resistor parameter default initial.
 * @details     Clear update event and get percentage.
 * @return      None
 * @note        No
 *******************************************************************************
 */
void TH222x_VariableResistorParameter_DeInit(void)
{
    // ------------------------------------------------------------------------
    TH222x_VR_UpdateFlag         = 0;                       // No update event
    
    // ------------------------------------------------------------------------
    // Get VR1 & VR2 default status. (The value is percentage.)
    TH222x_VAR_Status[VR1_DATA]  = BSP_VR_GETPERCENTAGE(VR1_DATA);
    TH222x_VAR_Status[VR2_DATA]  = BSP_VR_GETPERCENTAGE(VR2_DATA);    
}
/**
 *******************************************************************************
 * @brief	 	TH222x variable resistor main function.
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_VariableResistor(void)
{
    uint8_t TH222x_VRTmp;
    
    // ------------------------------------------------------------------------
    // Condition is TH222x_VR_UpdateFlag=1.
    // ------------------------------------------------------------------------
    if(TH222x_VR_UpdateFlag==0)
    {
        return;
    }
    
    // ------------------------------------------------------------------------
    TH222x_VR_UpdateFlag = 0;
 
    // ------------------------------------------------------------------------
    // Get VAR status
    // ------------------------------------------------------------------------
    BSP_VR_main();
    
    // ------------------------------------------------------------------------
    // To check VAR status whether change or not.
    // ------------------------------------------------------------------------
    if(VR_CTR.ChangeFlag == 0)
    {
        return;
    }

    // ------------------------------------------------------------------------
    // VR1 status (ADC data) chagne
    // ------------------------------------------------------------------------
    if(VR_CTR.ChangeFlag & VR_CHANGEFLAG_VR1)
    {
        // --------------------------------------------------------------------
        // Get percentage value.
        TH222x_VRTmp = BSP_VR_GETPERCENTAGE(VR1_DATA);
        
        // --------------------------------------------------------------------
        // Clockwise turns R-LED (More than previous VR1)
        // --------------------------------------------------------------------
        if(TH222x_VRTmp > TH222x_VAR_Status[VR1_DATA])
        {
            // Light up R LED of TH223x and light off G LED of TH223x.
            TH222x_CTR.GLED_Count = TH222x_CTR.LED_CountMax;// G-LED turn-off

            TH222x_CTR.RLED_Lock  = 1;
            TH222x_CTR.RLED_Count = 0;    
        }
        // --------------------------------------------------------------------
        // Anticlockwise turns on G-LED (Smaller than previous VR1)
        // --------------------------------------------------------------------
        else
        {
            // Light up G LED of TH223x and light off R LED of TH223x.
            TH222x_CTR.RLED_Count = TH222x_CTR.LED_CountMax;// R-LED turn-off

            TH222x_CTR.GLED_Lock  = 1;
            TH222x_CTR.GLED_Count = 0;               
        }
        
        // --------------------------------------------------------------------
        TH222x_VAR_Status[VR1_DATA]  = TH222x_VRTmp;
        
        // --------------------------------------------------------------------
        // Show result to 7-Segment if 7-Segment code be activated.
        // --------------------------------------------------------------------
        #if BSP_18_7SEGMENT_DISPLAY == 1
            TH222x_7Segment_ShowUnsignedValue(TH222x_VRTmp);
        #endif
    }

    // ------------------------------------------------------------------------
    // VR2 status (ADC data)chagne
    // ------------------------------------------------------------------------
    if(VR_CTR.ChangeFlag & VR_CHANGEFLAG_VR2)
    {
        // --------------------------------------------------------------------
        TH222x_VRTmp = BSP_VR_GETPERCENTAGE(VR2_DATA);
        
        // --------------------------------------------------------------------
        // Clockwise turns R-LED (More than previous VR2)
        // --------------------------------------------------------------------
        if(TH222x_VRTmp > TH222x_VAR_Status[VR2_DATA])
        {
            //Light up R LED of TH223x and light off G LED of TH223x.
            TH222x_CTR.GLED_Count = TH222x_CTR.LED_CountMax;// G-LED turn-off

            TH222x_CTR.RLED_Lock  = 1;
            TH222x_CTR.RLED_Count = 0;  
        }
        // --------------------------------------------------------------------
        // Anticlockwise turns on G-LED (Smaller than previous VR2)
        // --------------------------------------------------------------------
        else
        { 
            //Light up G LED of TH223x and light off R LED of TH223x.
            TH222x_CTR.RLED_Count = TH222x_CTR.LED_CountMax;// R-LED turn-off

            TH222x_CTR.GLED_Lock  = 1;
            TH222x_CTR.GLED_Count = 0;
        }
        
        // --------------------------------------------------------------------
        TH222x_VAR_Status[VR2_DATA]  = TH222x_VRTmp; 
        
        // --------------------------------------------------------------------
        // Show result to 7-Segment if 7-Segment code be activated.
        // --------------------------------------------------------------------
        #if BSP_18_7SEGMENT_DISPLAY == 1
            TH222x_7Segment_ShowUnsignedValue(TH222x_VRTmp);
        #endif
    }
    
    VR_CTR.ChangeFlag = 0;
    
}

