
/**
 ******************************************************************************
 *
 * @file        TH222x_7_StepMotor.c
 * @brief       This is to test TH222x StepMotor C file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/08
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_7_StepMotor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_StepMotor_UpdateFlag;                        // UpdateFlag=0 (Nothing)    
                                                            // UpdateFlag=1 (Needs to do ...)
                                                            
static uint8_t TH222x_StepMotor_Status;                     // There are 3 status for TH222x_StepMotor_Status.
                                                            //      1. STEPMOTOR_STOP             
                                                            //      2. STEPMOTOR_CLOCKWISE        
                                                            //      3. STEPMOTOR_ANTICLOCKWISE
                                                            
/* Private function prototypes -----------------------------------------------*/                                                                   
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       TH222x step motor parameter default initial.  
 * @details     Deinitial ARGB's parameters.
 * @return      None
 * @note        No
 *******************************************************************************
 */
void TH222x_StepMotorParameter_DeInit(void)
{
    // ------------------------------------------------------------------------
    TH222x_StepMotor_UpdateFlag = 0;                        // No update event
    
    TH222x_StepMotor_Status =  STEPMOTOR_STOP;              // Default state
    
    // ------------------------------------------------------------------------
    // control step motor rotating speed
    BSP_StepMotor_SetSpeed(1);
}   

/**
 *******************************************************************************
 * @brief	    Set Step Motor Status
 * @param[in]   StepMotor_Status:
 *  @arg\b      STEPMOTOR_STOP          : Step Motor stop.
 *  @arg\b      STEPMOTOR_CLOCKWISE     : Step Motor clockwise rotate.
 *  @arg\b      STEPMOTOR_ANTICLOCKWISE : Step Motor anticlockwise rotate.
 * @return      None
 * @note        No
 *******************************************************************************
 */
void TH222x_StepMotor_SetStatus(uint8_t StepMotor_Status)
{
    TH222x_StepMotor_Status = StepMotor_Status;
}

/**
 *******************************************************************************
 * @brief	  	Get Step Motor Status
 * @return    	Step motor rotate status.
 * @note      	No
 *******************************************************************************
 */
uint8_t TH222x_StepMotor_GetStatus(void)
{
    return(TH222x_StepMotor_Status);
}

/**
 *******************************************************************************
 * @brief	    TH222x step motor main function.  
 * @details     TH223x's SW3 control Step Motor. (Default is 'STOP' state)
 * 				1. First press : The step motor rotates clockwise.
 * 				2. Second press : The step motor rotates anticlockwise.
 * 				3. Third press : The step motor stops turning.
 * @return      None          
 * @note      	Step Motor working voltage is 5V.
 *  *******************************************************************************
 */ 
void TH222x_StepMotor(void)
{
    // ------------------------------------------------------------------------
    // Condition is TH222x_StepMotor_UpdateFlag=1.
    // ------------------------------------------------------------------------
    if(TH222x_StepMotor_UpdateFlag==0)
    {
        return;
    }
    
    // ------------------------------------------------------------------------
    TH222x_StepMotor_UpdateFlag = 0;
    
    // ------------------------------------------------------------------------
    // STEPMOTOR_STOP
    // ------------------------------------------------------------------------
    if(TH222x_StepMotor_Status == STEPMOTOR_STOP)
    {
        return;
    }
    
    // ------------------------------------------------------------------------
    // get previous rotate whether complete or not?
    // ------------------------------------------------------------------------
    if(BSP_StepMotor_GetStatus() == BSP_STEPMOTOR_BUSY)
    {
        return;
    }
    
    // ------------------------------------------------------------------------
    // STEPMOTOR_CLOCKWISE
    // ------------------------------------------------------------------------
    if(TH222x_StepMotor_Status == STEPMOTOR_CLOCKWISE)
    {
        // Control step motor clockwise rotate 
        BSP_StepMotor_ClockwiseRotate(1);
    }
    // ------------------------------------------------------------------------
    // STEPMOTOR_ANTICLOCKWISE
    // ------------------------------------------------------------------------
    else if(TH222x_StepMotor_Status == STEPMOTOR_ANTICLOCKWISE)
    {
        // Control step motor anticlockwise rotate 
        BSP_StepMotor_AnticlockwiseRotate(1);
    }
    
}
