

/**
 ******************************************************************************
 *
 * @file        TH222x_17_2ColorDotMatrixLED.c
 * @brief       This is to test TH222x 2 color dot matrix LED C file.
                
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_17_2ColorDotMatrixLED.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_2ColorMatrixLED_UpdateFlag;                  // UpdateFlag=0 (Nothing)
                                                            // UpdateFlag=1 (Needs to do ...)
                                                            
static uint8_t  TH222x_2ColorMatrixLED_Table[8][8];         // This is a 8x8 LED arrays.

static uint8_t  TH222x_DotMatrixLED_DramaAct;               // Drama counter : (0~TH222x_DotMatrixLED_DramaActMax)
static uint8_t  TH222x_DotMatrixLED_DramaActMax;            // The maximum of TH222x_DotMatrixLED_DramaAct.

static uint16_t TH222x_DotMatrixLED_DramaTime;              // Drama Time counter : (0~TH222x_DotMatrixLED_DramaTimeMax)
static uint16_t TH222x_DotMatrixLED_DramaTimeMax;           // The maximum of TH222x_DotMatrixLED_DramaTime.

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    TH222x 2 color dot matrix LED parameter default initial. 
 * @details     Deinit routine.
 * @return      None    
 * @note        No
 *******************************************************************************
 */
void TH222x_2ColorDotMatrixParameter_DeInit(void)
{
    uint8_t *TH222x_2ColorDotMatrix_clrBuf;
    uint8_t TH222x_2ColorDotMatrix_clrTmp;
    
    // ------------------------------------------------------------------------
    TH222x_2ColorMatrixLED_UpdateFlag = 0;                  // No update event
    
    TH222x_DotMatrixLED_DramaAct      = 0;                  // Drama counter
    TH222x_DotMatrixLED_DramaActMax   = 16;
    
    TH222x_DotMatrixLED_DramaTime     = 0;                  // Drama Time counter
    TH222x_DotMatrixLED_DramaTimeMax  = 500;
    
    // ------------------------------------------------------------------------
    // clear TH222x_2ColorMatrixLED_Table array
    TH222x_2ColorDotMatrix_clrBuf = &TH222x_2ColorMatrixLED_Table[0][0];
    
    for(TH222x_2ColorDotMatrix_clrTmp=0; TH222x_2ColorDotMatrix_clrTmp<64; TH222x_2ColorDotMatrix_clrTmp++)
    {
        TH222x_2ColorDotMatrix_clrBuf[TH222x_2ColorDotMatrix_clrTmp] = 0;
    }
}
/**
 *******************************************************************************
 * @brief	 TH222x 2 color dot matrix LED main function.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_2ColorDotMatrix(void)
{
    
    // ------------------------------------------------------------------------
    // Condition is TH222x_2ColorMatrixLED_UpdateFlag=1.
    // ------------------------------------------------------------------------
    if(TH222x_2ColorMatrixLED_UpdateFlag == 0)
    {
        return;
    }
    
    // ------------------------------------------------------------------------
    TH222x_2ColorMatrixLED_UpdateFlag = 0;
    
    // ------------------------------------------------------------------------
    // According visiting function frequency and RefreshFlag parameter 
    // to control 2 color dot matrix refresh frequency.
    // ------------------------------------------------------------------------
    BSP_2ColorDotMatrixLED_main();

    // ------------------------------------------------------------------------    
    // Refresh Frame (Time counter : TH222x_DotMatrixLED_DramaTime)
    // ------------------------------------------------------------------------
    if(TH222x_DotMatrixLED_DramaTime < TH222x_DotMatrixLED_DramaTimeMax)
    {
        TH222x_DotMatrixLED_DramaTime = TH222x_DotMatrixLED_DramaTime + 1;
        return;
    }
    
    TH222x_DotMatrixLED_DramaTime = 0;
    
    // ------------------------------------------------------------------------
    // Drama Index : TH222x_DotMatrixLED_DramaAct
    // ------------------------------------------------------------------------
    switch(TH222x_DotMatrixLED_DramaAct)
    {
    // ------------------------------------------------------------------------
    // 0
    case 0:
        TH222x_2ColorMatrixLED_Table[0][0] = 1;
        TH222x_2ColorMatrixLED_Table[7][0] = 1;
        TH222x_2ColorMatrixLED_Table[0][7] = 2;
        TH222x_2ColorMatrixLED_Table[7][7] = 2;
        break;
    
    // ------------------------------------------------------------------------
    // 1~7
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:     
        TH222x_2ColorMatrixLED_Table[0][TH222x_DotMatrixLED_DramaAct] = 1;
        TH222x_2ColorMatrixLED_Table[7][TH222x_DotMatrixLED_DramaAct] = 1;            
        TH222x_2ColorMatrixLED_Table[0][(TH222x_DotMatrixLED_DramaAct-1)] = 0;
        TH222x_2ColorMatrixLED_Table[7][(TH222x_DotMatrixLED_DramaAct-1)] = 0;

        TH222x_2ColorMatrixLED_Table[0][(7-TH222x_DotMatrixLED_DramaAct)] = 2;
        TH222x_2ColorMatrixLED_Table[7][(7-TH222x_DotMatrixLED_DramaAct)] = 2;
        TH222x_2ColorMatrixLED_Table[0][(8-TH222x_DotMatrixLED_DramaAct)] = 0;
        TH222x_2ColorMatrixLED_Table[7][(8-TH222x_DotMatrixLED_DramaAct)] = 0;
        break;
    
    // ------------------------------------------------------------------------
    // 8
    case 8:
        TH222x_2ColorMatrixLED_Table[7][0] = 0;        
        TH222x_2ColorMatrixLED_Table[7][7] = 0;
        TH222x_2ColorMatrixLED_Table[0][0] = 1;
        TH222x_2ColorMatrixLED_Table[0][7] = 2;
        break;
    
    // ------------------------------------------------------------------------
    // 9~10
    case 9:
    case 10:
    case 11:
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][0] = 0;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][7] = 0;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][0] = 1;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][7] = 2;
        break;
    
    // ------------------------------------------------------------------------
    // 12~14
    case 12:
    case 13:
    case 14:
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][0] = 0;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][7] = 0;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][0] = 2;
        TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][7] = 1;
        break;
    
    // ------------------------------------------------------------------------
    // 15 or the others
    case 15:
    default:  
        TH222x_2ColorMatrixLED_Table[6][0] = 0;
        TH222x_2ColorMatrixLED_Table[6][7] = 0;            
        TH222x_2ColorMatrixLED_Table[7][0] = 2;
        TH222x_2ColorMatrixLED_Table[7][7] = 1;
        TH222x_DotMatrixLED_DramaAct = 0;
        break;
 
    }
    
    // ------------------------------------------------------------------------
    // Update 2 color dot matrix LED show.
    // ------------------------------------------------------------------------
    BSP_2ColorDotMatrixLED_RefreshFrame(&TH222x_2ColorMatrixLED_Table[0][0]);
    
    // ------------------------------------------------------------------------
    // Drama index (0~TH222x_DotMatrixLED_DramaActMax)
    // ------------------------------------------------------------------------
    TH222x_DotMatrixLED_DramaAct = TH222x_DotMatrixLED_DramaAct + 1;
    
    if(TH222x_DotMatrixLED_DramaAct < TH222x_DotMatrixLED_DramaActMax)
    {
        return;
    }
    
    TH222x_DotMatrixLED_DramaAct = 0;
    
}

