

/**
 ******************************************************************************
 *
 * @file        Sample_main_wizard.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/24
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"
#include "MG32_ChipInit.h"
#include "LCD.h"

/* External vairables --------------------------------------------------------*/
extern unsigned char gImage_LogoX[36008];
extern unsigned char gImage_LogoXc[69768];

/* Wizard menu ---------------------------------------------------------------*/


/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Debug_Initial(void);

int main(void)
{
    uint32_t pColorAddr;
    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();

    SysTick_Config(CONF_CK_AHB_FREQ / 1000);

    Debug_Initial();

    LCD_Interface_Init();

    while(1)
    {
        LCD_Clear(&LCD1st, BLACK);
       // LCD_Color_Fill(&LCD1st, 0, 123, 240, 75, (uint16_t *)&gImage_LogoX[8]);
        LCD_Color_Fill(&LCD1st, 65, 0, 109, 320, (uint16_t *)&gImage_LogoXc[8]);
        Delay(3000);

        LCD_ColorBar_1(&LCD1st);
        Delay(3000);

        LCD_ColorBar_2(&LCD1st);
        Delay(3000);
//=============================================================================

        LCD_Clear(&LCD1st, BLACK);
        LCD_DrawLine(&LCD1st, 04, 46, 234, 276, 0x07FF);
        LCD_DrawLine(&LCD1st, 05, 45, 235, 275, 0x07FF);
        LCD_DrawLine(&LCD1st, 06, 44, 236, 274, 0x07FF);

        LCD_DrawLine(&LCD1st, 04, 274, 234, 44, 0xF81F);
        LCD_DrawLine(&LCD1st, 05, 275, 235, 45, 0xF81F);
        LCD_DrawLine(&LCD1st, 06, 276, 236, 46, 0xF81F);

        LCD_DrawLine(&LCD1st, 119, 44, 119, 276, 0xFFC0);
        LCD_DrawLine(&LCD1st, 120, 44, 120, 276, 0xFFC0);
        LCD_DrawLine(&LCD1st, 121, 44, 121, 276, 0xFFC0);

        LCD_DrawLine(&LCD1st, 04, 159, 236, 159, 0xFFC0);
        LCD_DrawLine(&LCD1st, 04, 160, 236, 160, 0xFFC0);
        LCD_DrawLine(&LCD1st, 04, 161, 236, 161, 0xFFC0);

        LCD_DrawRectangle(&LCD1st, 14, 54, 224, 264, 0x001F);
        LCD_DrawRectangle(&LCD1st, 15, 55, 225, 265, 0x001F);
        LCD_DrawRectangle(&LCD1st, 16, 56, 226, 266, 0x001F);

        LCD_DrawRectangle(&LCD1st,  9, 49, 229, 269, 0x07C0);
        LCD_DrawRectangle(&LCD1st, 10, 50, 230, 270, 0x07C0);
        LCD_DrawRectangle(&LCD1st, 11, 51, 231, 271, 0x07C0);

        LCD_DrawRectangle(&LCD1st, 04, 44, 234, 274, 0xF800);
        LCD_DrawRectangle(&LCD1st, 05, 45, 235, 275, 0xF800);
        LCD_DrawRectangle(&LCD1st, 06, 46, 236, 276, 0xF800);

        LCD_Draw_Circle(&LCD1st, 120, 160, 89, 0x001F);
        LCD_Draw_Circle(&LCD1st, 120, 160, 90, 0x001F);
        LCD_Draw_Circle(&LCD1st, 120, 160, 91, 0x001F);

        LCD_Draw_Circle(&LCD1st, 120, 160, 94, 0x07C0);
        LCD_Draw_Circle(&LCD1st, 120, 160, 95, 0x07C0);
        LCD_Draw_Circle(&LCD1st, 120, 160, 96, 0x07C0);

        LCD_Draw_Circle(&LCD1st, 120, 160,  99, 0xF800);
        LCD_Draw_Circle(&LCD1st, 120, 160, 100, 0xF800);
        LCD_Draw_Circle(&LCD1st, 120, 160, 101, 0xF800);
        Delay(3000);
//=============================================================================

        LCD_Clear(&LCD1st, BLACK);
        printf("01 Test Count  0");
        printf("02 Test Count  1\n");
        printf("03 Test Count  2");
        printf("04 Test Count  3\n\r");
        printf("05 Test Count  0123456789\n\r");
        printf("06 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz\n\r");
        printf("07 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
        printf("08 Test Count  ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
        printf("09 Test Count  abcdefghijklmnopqrstuvwxyz\n\r");
        printf("10 Test Count  0123456789\n\r");
        printf("11 Test Count  abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
        printf("12 Test Count  ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
        printf("13 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("14 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("15 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("16 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("17 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("18 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("19 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
//        printf("20 Test Count  0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\r");
        //Delay(3000);

        //To do......
    }
}

void Debug_Initial(void)
{
    // GPIO IO Config
    PINE(0)->CR.W  = PX_CR_IOM_ppo_w | PX_CR_HS_enable_w | PX_CR_PU_disable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af11_w;
    PINE(1)->CR.W  = PX_CR_IOM_din_w | PX_CR_HS_disable_w | PX_CR_PU_enable_w | PX_CR_INV_disable_w | PX_CR_ODC_level0_w | PX_CR_FDIV_bypass_w | PX_CR_AFS_af11_w;

    //URT4 Initial CK_HS = 12MHz, URT0 Baudrate 230400
    //URT4 Initial CK_HS = 25MHz, URT0 Baudrate 480000
    //URT_Init(URT0);     // for Debug Information
    URT4->CR0.W = 0;
    URT4->CLK.W = URT_CLK_BR_EN_mask_w;
    URT4->CR1.W = 0x0C400C40;
    URT4->CR2.W = 0x0000000C;
    URT4->CR3.W = 0x00000A00;
    URT4->RLR.W = 0x00000101;
    URT4->CNT.W = 0x00000101;
    URT4->IRDA.W = 0x00000300;
    URT4->MUTE.W = 0x00010100;
    URT4->CR0.W = URT_CR0_EN_mask_w;
}

