/**
 *******************************************************************************
 *
 * @file        MG32_CCL_Init.c
 *
 * @brief       The APX CCL initial code C file 
 *              Apply device : MG32F02A128/U128/A064/U064
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/04/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_CCL_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            CCL_HandleTypeDef       mCCL;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        CCL_HandleTypeDef       mCCL;
    #endif
    // ------------------------------------------------------------------------
#endif
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief  	    Initialized APX CCL module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void APX_CCL_Init(void)
{

    /* CCL0 initial wizard */
    #if ((CONF_APX_CCL00 & 0x00000001) != 0)
        APX->CCL01.W = CONF_APX_CCL01;          
        APX->CCL00.W = CONF_APX_CCL00 & (~APX_CCL00_CCL0_EN_enable_w);          
        APX->CCL00.W |= (APX_CCL00_CCL0_EN_enable_w);          
    #endif
    
    /* CCL1 initial wizard */
    #if ((CONF_APX_CCL10 & 0x00000001) != 0)
        APX->CCL11.W = CONF_APX_CCL11;          
        APX->CCL10.W = CONF_APX_CCL00 & (~APX_CCL00_CCL0_EN_enable_w);     
        APX->CCL10.W |= (APX_CCL00_CCL0_EN_enable_w);     
    #endif   

    /* CCLx interrupt initial wizard */
    #if (CONF_APX_INT_CCLx != 0)
        APX->INT.W = CONF_APX_INT_CCLx;
    #endif


    // ------------------------------------------------------------------------
    // Config mCCL structure within Middleware level
    // ------------------------------------------------------------------------
    #if defined(IRQHandler_Middleware_Level_)       
        // (for CCL0)----------------------------------------------------------
        #if CONF_APX_CCL00 != 0
            mCCL.Instance                   = CCL0;
            mCCL.TruthTable                 = mCCL0_TruthTable_Select;     
            mCCL.CCL_INTClockDivision       = mCCL0_CCL_INTClockDivision_Select;      
            mCCL.MUX0Input                  = mCCL0_MUX0Input_Select;               
            mCCL.MUX1Input                  = mCCL0_MUX1Input_Select;               
            mCCL.MUX2Input                  = mCCL0_MUX2Input_Select;               
            mCCL.CCL_SQIN                   = mCCL0_CCL_SQIN_Select;                  
            mCCL.SEQMode                    = mCCL0_SEQMode_Select;           
            mCCL.EdgeDetectMode             = mCCL0_EdgeDetectMode_Select;        
            mCCL.OutputSync                 = mCCL0_OutputSync_Select;     
            mCCL.OutputPol                  = mCCL0_OutputPol_Select;   
            
        #endif
        // MID_APX_CCL_Init(&mCCL);
        
        // (for CCL1)----------------------------------------------------------
        #if CONF_APX_CCL10 != 0
            mCCL.Instance                   = CCL1;
            mCCL.TruthTable                 = mCCL1_TruthTable_Select;     
            mCCL.CCL_INTClockDivision       = mCCL1_CCL_INTClockDivision_Select;      
            mCCL.MUX0Input                  = mCCL1_MUX0Input_Select;               
            mCCL.MUX1Input                  = mCCL1_MUX1Input_Select;               
            mCCL.MUX2Input                  = mCCL1_MUX2Input_Select;               
            mCCL.CCL_SQIN                   = mCCL1_CCL_SQIN_Select;                  
            mCCL.SEQMode                    = mCCL1_SEQMode_Select;           
            mCCL.EdgeDetectMode             = mCCL1_EdgeDetectMode_Select;        
            mCCL.OutputSync                 = mCCL1_OutputSync_Select;     
            mCCL.OutputPol                  = mCCL1_OutputPol_Select;   
            
        #endif
        // MID_APX_CCL_Init(&mCCL);
    #endif

}




