/**
 ******************************************************************************
 *
 * @file        MG32_IEC60730_CPU_PC.c
 *
 * @brief       This file provides firmware functions to manage the following 
 *              functionalities of the ADC peripheral:
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2018/12/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 



/* Includes -----------------------------------------------------------------*/
#include "MG32_IEC60730_Common.h"

/* Private typedef ----------------------------------------------------------*/

/* Private define -----------------------------------------------------------*/

/* Private macro ------------------------------------------------------------*/

/* Private variables --------------------------------------------------------*/

/* Private function prototypes ----------------------------------------------*/
void* STL_PC_TEST_pcTestFunction1(void) __attribute__((section("pc_test_section_1"), ));
void* STL_PC_TEST_pcTestFunction2(void) __attribute__((section("pc_test_section_2"), ));
void* STL_PC_TEST_pcTestFunction3(void) __attribute__((section("pc_test_section_3"), ));
void* STL_PC_TEST_pcTestFunction4(void) __attribute__((section("pc_test_section_4"), ));
void* STL_PC_TEST_pcTestFunction5(void) __attribute__((section("pc_test_section_5"), ));
void* STL_PC_TEST_pcTestFunction6(void) __attribute__((section("pc_test_section_6"), ));
void* STL_PC_TEST_pcTestFunction7(void) __attribute__((section("pc_test_section_7"), ));
void* STL_PC_TEST_pcTestFunction8(void) __attribute__((section("pc_test_section_8"), ));

/* Private functions --------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief       
 * @details  
 * @param[in]    
 * @return      
 * @exception      
 * @note        
 *******************************************************************************
 */
IEC60730_Ret IEC60730_CPU_PC(void)
{
    uint16_t countPcTest;
    void* pReturnFunctionAddress;

    // Store function addresses in an array
    void* (*pPcTestFunctions[8])(void) =
    {
        &STL_PC_TEST_pcTestFunction1,
        &STL_PC_TEST_pcTestFunction2,
        &STL_PC_TEST_pcTestFunction3,
        &STL_PC_TEST_pcTestFunction4,
        &STL_PC_TEST_pcTestFunction5,
        &STL_PC_TEST_pcTestFunction6,
        &STL_PC_TEST_pcTestFunction7,
        &STL_PC_TEST_pcTestFunction8,
    };
 
    for(countPcTest = 0U; countPcTest < 8U; countPcTest++)
    {
        pReturnFunctionAddress = (*pPcTestFunctions[countPcTest])();
        // if the address returned doesn't match the address of
        // the function return an error
        #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
            #pragma clang diagnostic push
            #pragma clang diagnostic ignored "-Wpedantic"
                if(pPcTestFunctions[countPcTest] != pReturnFunctionAddress)
                    return(IEC60730_TEST_FAILURE);
            #pragma clang diagnostic pop
        #else
            if(pPcTestFunctions[countPcTest] != pReturnFunctionAddress)
                return(IEC60730_TEST_FAILURE);
        #endif
    }
    // Return success if all the functions return their own 
    // address
    return(IEC60730_TEST_SUCCESS);

}// end of STL_PC_TEST_testPcRegister function

//! 
//! the PC test functions return their own address
//!
void* STL_PC_TEST_pcTestFunction1(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction1;
}

void* STL_PC_TEST_pcTestFunction2(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction2;
}

void* STL_PC_TEST_pcTestFunction3(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction3;
}

void* STL_PC_TEST_pcTestFunction4(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction4;
}

void* STL_PC_TEST_pcTestFunction5(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction5;
}

void* STL_PC_TEST_pcTestFunction6(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction6;
}

void* STL_PC_TEST_pcTestFunction7(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction7;
}

void* STL_PC_TEST_pcTestFunction8(void)
{
    return(void *)&STL_PC_TEST_pcTestFunction8;
}






















/******************* (C) COPYRIGHT 2018 Megawin ************ END OF FILE *****/


