


/**
 ******************************************************************************
 *
 * @file        Sample_MID_GPIO_Init.c
 * @brief       The sample code is that use middleware to receive and transmit data
 *     \n       (The middleware is use polling flag).
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2025/09/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_MID.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_GPIO_Init(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    GPIO Init sample code.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void Sample_MID_GPIO_Init(void)
{
    GPIO_InitTypeDef    GPIOX;
    uint32_t            SMP_GPIO_Delay;
    uint32_t            GPIO_Status;
    uint8_t             PIN_Status;
    
    //==============================================================================
    //CSC Inital 
    //You can:
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //    2. In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    
    //==============================================================
    //Use port inital.
    GPIOX.Pin           = ( GPIO_Pin_9 | GPIO_Pin_10);           // Inital pin9 & pin10 of the port.
    GPIOX.Mode          = GPIO_MODE_PUSHPULL_O;                  // Pin mode is push pull output mode.
    GPIOX.Pull          = GPIO_NOPULLUP;                         // Disable pull-up resistance.
    GPIOX.Speed         = GPIO_SPEED_LOW;                        // Output speed no high speed mode.
    GPIOX.Inverse       = GPIO_INVERSE_DISABLE;                  // Disable input inverse.
    GPIOX.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;                  // Output drive strength is level0
    GPIOX.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;             // Disable input filter.
    GPIOX.Alternate     = 0;                                     // The pins alternate function is GPIO
    
    MID_GPIO_Init( IOMB ,&GPIOX); 

    //===============================================================
    //Use pin inital
    MID_GPIO_Pin_Init( PINB(8) , &GPIOX);                        // Inital PB8 and the pin seting is same the above setting except for Pin parameter.

    
    
    GPIO_Status = __DRV_GPIO_READ( GPIOB);                                         //Read GPIOB port status. 
    GPIO_Status &= (uint32_t)( ~(GPIO_Pin_8 | GPIO_Pin_9 | GPIO_Pin_10));                    
    __DRV_GPIO_WRITE( GPIOB, GPIO_Status);                                         //Write GPIO port status.
    
    
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_SET_BIT( GPIOB , GPIO_Pin_10);                                      //Set PB10   
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}         
    __DRV_GPIO_SET_BIT( GPIOB , GPIO_Pin_9);                                       //Set PB9 
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_SET_BIT( GPIOB , GPIO_Pin_8);                                       //Set PB8         
        
    
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_CLEAR_BIT( GPIOB , GPIO_Pin_10);                                    //Clear PB10   
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_CLEAR_BIT( GPIOB , GPIO_Pin_9);                                     //Clear PB9 
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_CLEAR_BIT( GPIOB , GPIO_Pin_8);                                     //Clear PB8      
        
        
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_SET_BIT( GPIOB , (GPIO_Pin_10 | GPIO_Pin_8));                       //Set PB10 & PB8
 
    
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_SETCLEAR_BIT( GPIOB , GPIO_Pin_9, (GPIO_Pin_10 | GPIO_Pin_8));      //Set PB9 , Clear PB10 & PB8
        
       
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    __DRV_GPIO_SETCLEAR_BIT( GPIOB ,(GPIO_Pin_10 | GPIO_Pin_8) , GPIO_Pin_9);      //Set PB10 & PB8 , Clear PB9 
        
    
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}           
    PIN_Status = PB8;                                                              //Read PIN status
        
    PB8 = ~PIN_Status;                                                             //Write PIN status    
        
    for(SMP_GPIO_Delay = 0; SMP_GPIO_Delay < 1480000; SMP_GPIO_Delay++){}
    
    
}

















