
/**
 ******************************************************************************
 *
 * @file        Sample_MID_EXIC_Init.c
 * @brief       The sample code is that use middleware to receive and transmit data
 *     \n       (The middleware is use polling flag).
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2025/09/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_CSC_Init.h"
#include "MG32_GPIO_MID.h"
#include "MG32_EXIC_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static EXIC_HandleTypeDef  mEXIC_PA;

/* Private function prototypes -----------------------------------------------*/
void EXINT0_IRQHandler(void);
void Sample_MID_EXIC_Init(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    External interrupt AND path happen callback.
 * @details     
 * @param[in]   MEXIC_PX   : EXIC_PORT handle.
 * @return      No.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void MID_EXIC_AFCallback( EXIC_HandleTypeDef* MEXIC_PX)
{
    //==============================================================================
    //Into the AFCallback from EXIC_PA input interrupt.
    if( MEXIC_PX->EXIC_Port == EXIC_PORTA)
    {
        // To do....
         __DRV_EXIC_CLEAR_PINTRIGGER_EVENTFLAG( MEXIC_PX, (EXIC_PX_PIN1 | EXIC_PX_PIN0));
         
         MID_EXIC_ClearITFlag(MEXIC_PX , EXIC_PX_AF);
    }
}
/**
 *******************************************************************************
 * @brief	    External interrupt OR path happen callback.
 * @details     
 * @param[in]   MEXIC_PX   : EXIC_PORT handle. 
 * @return      No.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void MID_EXIC_OFCallback( EXIC_HandleTypeDef* MEXIC_PX )
{
    uint16_t EXIC_PX_PF;
    
    //==============================================================================
    //Into the OFCallback from EXIC_PA input interrupt.
    if( MEXIC_PX->EXIC_Port == EXIC_PORTA)
    {
        EXIC_PX_PF = (uint16_t)__DRV_EXIC_GET_PINTRIGGER_EVENTFLAG( MEXIC_PX);
        
        //------------------------------------------------------------------------
        // PA2 event trigger happen.
        if( EXIC_PX_PF & EXIC_PX_PIN2)
        {
            //To do...
            __DRV_EXIC_CLEAR_PINTRIGGER_EVENTFLAG( MEXIC_PX , EXIC_PX_PIN2);
        }
        //------------------------------------------------------------------------
        // PA3 event trigger happen.
        if( EXIC_PX_PF & EXIC_PX_PIN3)
        {
            //To do...
            __DRV_EXIC_CLEAR_PINTRIGGER_EVENTFLAG( MEXIC_PX , EXIC_PX_PIN3);
        }
    }
}
/**
 *******************************************************************************
 * @brief     EXINT0 IRQ Handle
 * @details   Call the MID_EXIC_IRQHandler() function into EXINT0_IRQHandler() if 
 *            the EXINT0_IRQHandler() already  exists, or uncommenting 
 *            the EXINT0_IRQHandler() function in the sample code.
 * @return      
 * @exception No
 * @note      No
 *******************************************************************************
 */
//void EXINT0_IRQHandler(void)
//{
//    MID_EXIC_IRQHandler(&mEXIC_PA);
//}


/**
 *******************************************************************************
 * @brief	    Initalize the EXIC MSP.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void MID_EXIC_MspInit( EXIC_HandleTypeDef* MEXIC_PX)
{
    GPIO_InitTypeDef PINX_InitStruct;
    
    //==============================================================================
    //CSC Inital 
    //You can:
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //    2. In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    //==============================================================================
    //GPIO Inital : 
    //You can :
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //       In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    //    or
    //    2. Use MID_GPIO_Pin_Init() or MID_GPIO_Init()
    //       the following sample code is MID_GPIO_Pin_Init().
    PINX_InitStruct.Pin            = ( GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3);
    PINX_InitStruct.Mode		   = GPIO_MODE_OPENDRAIN_O;
    PINX_InitStruct.Pull           = GPIO_PULLUP;
    PINX_InitStruct.Speed          = GPIO_SPEED_LOW;
    PINX_InitStruct.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
    PINX_InitStruct.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
    PINX_InitStruct.Inverse        = GPIO_INVERSE_DISABLE;
    PINX_InitStruct.Alternate      = 0;
    MID_GPIO_Init(IOMA , &PINX_InitStruct);
    //==============================================================================
    //GPIO Trigger event Inital :
    
    MID_EXIC_PxTriggerMode_Config(MEXIC_PX, (EXIC_TRGS_PIN0 | EXIC_TRGS_PIN1 ), EXIC_TRIGGER_LEVEL);  // PA0 , PA1 trigger event = low level.
    MID_EXIC_PxTriggerMode_Config(MEXIC_PX, (EXIC_TRGS_PIN2 | EXIC_TRGS_PIN3 ), EXIC_TRIGGER_EDGE);   // PA2 , PA3 trigger event = falling edge.
    
}
/**
 *******************************************************************************
 * @brief	    EXIC Init sample code.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void Sample_MID_EXIC_Init(void)
{
    //==============================================================================
    //Enable NVIC IRQ :
    //You can :
    //    1. Tick IRQ handler checkbox of MG32_ChipInit_Wizard and Tick Enable EXINT0 NVIC of
    //       MG32_IRQ_Handler in Run-Time Environment.
    //    or    
    //    2. Use NVIC_EnableIRQ() to enable.
    NVIC_EnableIRQ( EXINT0_IRQn);
    
    //==============================================================================
    //EXIC Inital
    mEXIC_PA.Instance    = EXIC_PA;               // Set mEXIC_PA to control external PortA input interrupt.
    mEXIC_PA.AND_Mask    = 0x03;                  // Set AND mask = 0x03 ( If PA0 & PA1 trigger event happen at the same time , into interrupt. 
    mEXIC_PA.OR_Mask     = 0x0C;                  // Set OR mask = 0x0C (If PA0 or PA1 trigger event happen , into interrupt.
    mEXIC_PA.AND_UnMatch = DISABLE;               // Disable AND flag status inverse. 
    mEXIC_PA.Interrupt   = EXIC_INTERRUPT_ENABLE; // Enable Interrupt.
    
    
    MID_EXIC_PxTrigger_Init(&mEXIC_PA);
    
}

















