/**
  ******************************************************************************
 *
 * @file        Sample_MID_APB_NCO.c
 *
 * @brief       Control NCO peripheral output.
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_APB_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***

// ----------------------------------------------------------------------------
//  <o0> NCO input clock source select. 
//      <0x00000000=> CK_IHRCO 
//      <0x10000000=> CL_PLL 
//      <0x20000000=> CK_APB
//      <0x30000000=> CK_LS
//      <0x40000000=> TM00_TRGO
//      <0x50000000=> NCO_CK0 (input pin)
#define NCOClock        0

// ----------------------------------------------------------------------------
//  <o0> NCO output mode <0=>FDC mode <0x04000000=>PFM mode  
#define NCOOutputMode   0  

// ----------------------------------------------------------------------------
//  <o0> Inverse NCO output <0x02000000=>ENABLE <0=>DISABLE
#define InverseNCO      0    

// ----------------------------------------------------------------------------
//  <o0> input range from 0 to 1048575 (2^20 - 1)
#define NCOINCVal       1000

// ----------------------------------------------------------------------------
//  <o0> APB NCO PFM width select (only support PFM mode)
//      <0x00000000=> 1 CK_NCOn clock period 
//      <0x01000000=> 2 CK_NCOn clock period 
//      <0x02000000=> 4 CK_NCOn clock period 
//      <0x03000000=> 8 CK_NCOn clock period 
//      <0x04000000=> 16 CK_NCOn clock period 
//      <0x05000000=> 32 CK_NCOn clock period 
//      <0x06000000=> 64 CK_NCOn clock period 
//      <0x07000000=> 128 CK_NCOn clock period
#define NCO_PFMWidth    0

//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_APB_NCO(void);
void MID_APB_NCOTriggerCallback(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    Output 2-channels PWM of TM20 when TRGI(ETR) event happened.
 *              Then it will to stop PWM pulse when output N times.
 * @details     Initial NCO with start it.
 * @return      None
 * @note        It will always output PWM cycle when TRGI happen.
 *******************************************************************************
 */
void Sample_MID_APB_NCO(void)
{  
    
    // make sure :
	
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->APB = Enable
	
    //==Set GPIO init 
    //NCO_P0 pin config:
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOB->PB3
    //GPIO port initial is 0xFFFF
    //PB3 mode is PPO
    //PB3 function NCO_P0


    // ------------------------------------------------------------------------
    // initial NCO
    __DRV_NCO_CLOCK(NCOClock);
    __DRV_NCO_FUNCTION_MODE(NCOOutputMode);
    __DRV_NCO_INVERT_OUTPUT(InverseNCO);
    
    __DRV_NCO_PFM_WIDTH(NCO_PFMWidth);
    
    __DRV_NCO_INC(NCOINCVal);
    __DRV_NCO_ADDER_INIT(999);
    
    __DRV_NCO_ENABLE();
    
    // Enable NCO interrupt (if user want to use it. Please uncomment it)
    {
//    __DRV_APB_ENABLE_IT(APB_IT_NCO);
//    __DRV_APB_ENABLE_ITEA();
//    __DRV_SYS_ENABLE_IT(SYS_IT_IEA);
    }
        
    return;
}

/**
 *******************************************************************************
 * @brief       Handles NCO interrupt request.  
 * @return		None
 *******************************************************************************
 */
void MID_APB_NCOTriggerCallback(void)
{
    // to do ...
    
}


