
/**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       main C file.
 
 * @par         Project
 *              Mouse
 * @version     V1.01
 * @date        2022/06/21
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_ChipInit.h"
#include "MG32_Wheel_API.h"
#include "MG32_Mouse_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void SysTick_Handler(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	  Sytstick ( Time base 250us)   
 * @details     
 * @return      
 * @exception   
 * @note
 *******************************************************************************
 */
void SysTick_Handler(void)
{
    /*Detect wheel status*/
    API_Wheel_DetectStatus();
    
    Mouse_CTR.BaseCount++;
    
    /*1 ms time base*/
    switch(Mouse_CTR.BaseCount)
    {
        case 1:
                /*Button handler*/
                API_Mouse_ButtonHandler();
                break;
        case 2:
                /*Sensor data handler*/
                API_Mouse_SensorHandler();
                break;
        case 3:
                break;
        case 4:
        default:
                /*Wheel handler*/
                API_Mouse_WheelHandler();
                /*Send Mouse report*/
                API_Mouse_ReportHandler();
                Mouse_CTR.BaseCount = 0; 
                break;
        
    }
}    
/**
 *******************************************************************************
 * @brief	   main function  
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */
int main(void)
{

    /*IC hardware initial (ChipInit_Wizard)*/
    UnProtectModuleReg(MEMprotect);
    MEM->CR0.MBIT.FWAIT  = 1;
    MEM->CR0.MBIT.HSP_EN = 1;
    ProtectModuleReg(MEMprotect);
    
    ChipInit();
    
    /*Mouse initial*/
    API_Mouse_Init();
    
    
    while(1)
    {
        API_Mouse_Handler();

    }

}





