

/**
 ******************************************************************************
 *
 * @file        TH222x_7_StepMotor.c
 * @brief       This is to test TH222x StepMotor C file.
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_7_StepMotor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_StepMotor_UpdateFlag;

static uint8_t TH222x_StepMotor_Status;

/* Private function prototypes -----------------------------------------------*/                                                                   
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	 TH222x step motor parameter default initial.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_StepMotorParameter_DeInit(void)
{
    TH222x_StepMotor_UpdateFlag = 0;
    
    TH222x_StepMotor_Status =  STEPMOTOR_STOP;
    
    BSP_StepMotor_SetSpeed(1);
}   
/**
 *******************************************************************************
 * @brief	  Set Step Motor Status
 * @param[in] StepMotor_Status:
 *  @arg\b    STEPMOTOR_STOP          : Step Motor stop.
 *  @arg\b    STEPMOTOR_CLOCKWISE     : Step Motor clockwise rotate.
 *  @arg\b    STEPMOTOR_ANTICLOCKWISE : Step Motor anticlockwise rotate.
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_StepMotor_SetStatus(uint8_t StepMotor_Status)
{
    TH222x_StepMotor_Status = StepMotor_Status;
}
/**
 *******************************************************************************
 * @brief	  Get Step Motor Status
 * @details     
 * @return    Step motor rotate status.
 * @note       
 *******************************************************************************
 */
uint8_t TH222x_StepMotor_GetStatus(void)
{
    return(TH222x_StepMotor_Status);
}
/**
 *******************************************************************************
 * @brief	 TH222x step motor main function.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */ 
void TH222x_StepMotor(void)
{
    if(TH222x_StepMotor_UpdateFlag==0)
    {
        return;
    }
    
    TH222x_StepMotor_UpdateFlag = 0;
    
    
    if( TH222x_StepMotor_Status == STEPMOTOR_STOP)
    {
        return;
    }
    
    if( BSP_StepMotor_GetStatus() == BSP_STEPMOTOR_BUSY)
    {
        return;
    }
    
    if( TH222x_StepMotor_Status == STEPMOTOR_CLOCKWISE)
    {
        BSP_StepMotor_ClockwiseRotate(1);
    }
    else if(TH222x_StepMotor_Status == STEPMOTOR_ANTICLOCKWISE)
    {
        BSP_StepMotor_AnticlockwiseRotate(1);
    }
    
}





