/**
 ******************************************************************************
 *
 * @file        BSP_12_BLE_app.c
 * @brief       BLE_MG126 app c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include <string.h>
#include <stdint.h>
#include "__BSP_Wizard.h"
#if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_MG126
#include "BSP_12_BLE_MG126_app.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/*******************************************************************************
                 *****DataBase****

01 - 06  GAP (Primary service) 0x1800
  03:04  name
07 - 0f  Device Info (Primary service) 0x180a
  0a:0b  firmware version
  0e:0f  software version
10 - 19  LED service (Primary service) 6E400001-B5A3-F393-E0A9-E50E24DCCA9E
  11:12  6E400003-B5A3-F393-E0A9-E50E24DCCA9E(0x04)  RxNotify
  13     cfg
  14:15  6E400002-B5A3-F393-E0A9-E50E24DCCA9E(0x0C)  Tx
  16     cfg
  17:18  6E400004-B5A3-F393-E0A9-E50E24DCCA9E(0x0A)  BaudRate
  19     0x2901  info
*******************************************************************************/


/* Private define ------------------------------------------------------------*/
/// Characteristic Properties Bit
#define ATT_CHAR_PROP_RD            0x02
#define ATT_CHAR_PROP_W_NORSP       0x04
#define ATT_CHAR_PROP_W             0x08
#define ATT_CHAR_PROP_NTF           0x10
#define ATT_CHAR_PROP_IND           0x20 
#define GATT_PRIMARY_SERVICE_UUID   0x2800

#define TYPE_CHAR                   0x2803
#define TYPE_CFG                    0x2902
#define TYPE_INFO                   0x2901
#define TYPE_xRpRef                 0x2907
#define TYPE_RpRef                  0x2908
#define TYPE_INC                    0x2802
#define UUID16_FORMAT               0xff

#define SOFTWARE_INFO               "SV3.3.3"
#define MANU_INFO                   "megawin"
static char DeviceInfo[] =          "MG-UART-HH";  /*max len is 24 bytes*/

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
volatile u16 cur_notifyhandle = 0x12;  /* volatile *///Note: make sure each notify handle by invoking function: set_notifyhandle(hd);
unsigned char gConnectedFlag = 0;

/* Private function prototypes -----------------------------------------------*/
u8 GetCharListDim(void);
void gatt_user_send_notify_data_callback(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
//extern void BSP_BLE_WriteRxBuffer (u8* DestIndex, u8 len);


u8* getDeviceInfoData(u8* len)
{    
    *len = sizeof(DeviceInfo);
    return (u8*)DeviceInfo;
}


void updateDeviceInfoData(u8* name, u8 len)
{
    memcpy(DeviceInfo,name, len);
    
    ble_set_name(name,len);
}


//
///STEP0:Character declare
//
volatile BLE_CHAR AttCharList[] = {
// ======  gatt =====  Do NOT Change!!
    {GATT_PRIMARY_SERVICE_UUID, 0x0001, {0x00,                                  0x00, 0x00, 0x00, 0x00}, 0x00},
    {TYPE_CHAR,                 0x0003, {ATT_CHAR_PROP_RD,                      0x04, 0x00, 0x00, 0x2a}, UUID16_FORMAT},//name
    //05-06 reserved
// ======  device info =====    Do NOT Change if using the default!!!
    {GATT_PRIMARY_SERVICE_UUID, 0x0007, {0x00,                                  0x00, 0x00, 0x00, 0x00}, 0x00},
    {TYPE_CHAR,                 0x0008, {ATT_CHAR_PROP_RD,                      0x09, 0x00, 0x29, 0x2a}, UUID16_FORMAT},//manufacture
    {TYPE_CHAR,                 0x000a, {ATT_CHAR_PROP_RD,                      0x0b, 0x00, 0x26, 0x2a}, UUID16_FORMAT},//firmware version
    {TYPE_CHAR,                 0x000e, {ATT_CHAR_PROP_RD,                      0x0f, 0x00, 0x28, 0x2a}, UUID16_FORMAT},//sw version
    
// ======  User service or other services added here =====  User defined
    {GATT_PRIMARY_SERVICE_UUID, 0x0010, {0x00,                                  0x00, 0x00, 0x00, 0x00}, 0x00},
    {TYPE_CHAR,                 0x0011, {ATT_CHAR_PROP_NTF,                     0x12, 0x00, 0x00, 0x00}, 0x01/*uuid128-idx1*/ },//RxNotify
    {TYPE_CFG,                  0x0013, {ATT_CHAR_PROP_RD|ATT_CHAR_PROP_W,      0x00, 0x00, 0x00, 0x00}, 0x00},//cfg
    {TYPE_CHAR,                 0x0014, {ATT_CHAR_PROP_W|ATT_CHAR_PROP_W_NORSP, 0x15, 0x00, 0x00, 0x00}, 0x02/*uuid128-idx2*/ },//Tx    
};

BLE_UUID128 AttUuid128List[] = {
/*for supporting the android app [nRF UART V2.0], one SHOULD using the 0x9e,0xca,0xdc.... uuid128*/
    {0x9e,0xca,0xdc,0x24,0x0e,0xe5,0xa9,0xe0,0x93,0xf3,0xa3,0xb5,1,0,0x40,0x6e}, //idx0,little endian, service uuid
    {0x9e,0xca,0xdc,0x24,0x0e,0xe5,0xa9,0xe0,0x93,0xf3,0xa3,0xb5,3,0,0x40,0x6e}, //idx1,little endian, RxNotify
    {0x9e,0xca,0xdc,0x24,0x0e,0xe5,0xa9,0xe0,0x93,0xf3,0xa3,0xb5,2,0,0x40,0x6e}, //idx2,little endian, Tx
};


u8 GetCharListDim(void)
{
    return sizeof(AttCharList)/sizeof(AttCharList[0]);
}


//////////////////////////////////////////////////////////////////////////
///STEP1:Service declare
// read by type request handle, primary service declare implementation
void att_server_rdByGrType( u8 pdu_type, u8 attOpcode, u16 st_hd, u16 end_hd, u16 att_type )
{
    (void) end_hd;
 //!!!!!!!!  hard code for gap and gatt, make sure here is 100% matched with database:[AttCharList] !!!!!!!!!
                     
    if((att_type == GATT_PRIMARY_SERVICE_UUID) && (st_hd == 0x0001))//hard code for device info service
    {
        u8 t[] = {0x00,0x18};
        att_server_rdByGrTypeRspPrimaryService(pdu_type,0x1,0x6,(u8*)(t),2);
        return;
    }
    else if((att_type == GATT_PRIMARY_SERVICE_UUID) && (st_hd <= 0x0007))//hard code for device info service
    {
        u8 t[] = {0x0a,0x18};
        att_server_rdByGrTypeRspPrimaryService(pdu_type,0x7,0x0f,(u8*)(t),2);
        return;
    }
    
    else if((att_type == GATT_PRIMARY_SERVICE_UUID) && (st_hd <= 0x0010)) //usr's service
    {
        att_server_rdByGrTypeRspPrimaryService(pdu_type, 0x10, 0x15, (u8*)(AttUuid128List[0].uuid128), 16);
        return;
    }
    //other service added here if any
    //to do....

    ///error handle
    att_notFd( pdu_type, attOpcode, st_hd );
}


///STEP2:data coming
///write response, data coming....
void ser_write_rsp(u8 pdu_type/*reserved*/, u8 attOpcode/*reserved*/, 
                   u16 att_hd, u8* attValue/*app data pointer*/, u8 valueLen_w/*app data size*/)
{
    switch(att_hd)
    {
        case 0x15://Tx
#ifdef LOOPBACK //ble directly send back the data to central/phone
            sconn_notifydata(attValue,valueLen_w);
#else
            BSP_BLE_WriteRxBuffer(attValue,valueLen_w);     // Update BLE receive data to txbuf
#endif
            ser_write_rsp_pkt(pdu_type);                        //if the related character has the property of ATT_CHAR_PROP_W
            break;
        
        case 0x12://cmd
        case 0x13://cfg  
            ser_write_rsp_pkt(pdu_type);  /*if the related character has the property of WRITE(with response) or TYPE_CFG, one MUST invoke this func*/      
            break;
        
        default:
            att_notFd( pdu_type, attOpcode, att_hd );	/*the default response, also for the purpose of error robust */
            break;
    }
 }

 
///STEP2.1:Queued Writes data if any
void ser_prepare_write(u16 handle, u8* attValue, u16 attValueLen, u16 att_offset)//user's call back api 
{
    ((void)(att_offset));
    
    //queued data:offset + data(size)
    //when ser_execute_write() is invoked, means end of queue write.
    
    //to do    
    if (0x0015 == handle)
    {
#ifdef LOOPBACK //ble directly send back the data to central/phone
        sconn_notifydata(attValue,attValueLen);
#else
        BSP_BLE_WriteRxBuffer(attValue, (u8) attValueLen);  // Update BLE receive data to txbuf
#endif
    }
}


void ser_execute_write(void)//user's call back api 
{
    //end of queued writes  
    
    //to do...    
}


///STEP3:Read data
//// read response
void server_rd_rsp(u8 attOpcode, u16 attHandle, u8 pdu_type)
{
    u8  d_len;
    u8* ble_name = getDeviceInfoData(&d_len);
    
    switch(attHandle) //hard code
    {
        case 0x04: //GAP name
            att_server_rd( pdu_type, attOpcode, attHandle, ble_name, d_len);
            break;
                
        case 0x09: //MANU_INFO
            //att_server_rd( pdu_type, attOpcode, attHandle, (u8*)(MANU_INFO), sizeof(MANU_INFO)-1);
            att_server_rd( pdu_type, attOpcode, attHandle, get_ble_version(), (unsigned char) strlen((const char*)get_ble_version())); //ble lib build version
            break;
        
        case 0x0b: //FIRMWARE_INFO
        {
            //do NOT modify this code!!!
            att_server_rd( pdu_type, attOpcode, attHandle, GetFirmwareInfo(), (unsigned char) strlen((const char*)GetFirmwareInfo()));
            break;
        }
        
        case 0x0f://SOFTWARE_INFO
            att_server_rd( pdu_type, attOpcode, attHandle, (u8*)(SOFTWARE_INFO), sizeof(SOFTWARE_INFO)-1);
            break;
        
        case 0x13://cfg
            {
                u8 t[2] = {0,0};
                att_server_rd( pdu_type, attOpcode, attHandle, t, 2);
            }
            break;
        default:
            att_notFd( pdu_type, attOpcode, attHandle );/*the default response, also for the purpose of error robust */
            break;
    }
}


void server_blob_rd_rsp(u8 attOpcode, u16 attHandle, u8 dataHdrP,u16 offset)
{
    (void)attOpcode;
    (void)attHandle;
    (void)dataHdrP;
    (void)offset;
}


//return 1 means found
int GetPrimaryServiceHandle(unsigned short hd_start, unsigned short hd_end,
                            unsigned short uuid16,
                            unsigned short* hd_start_r,unsigned short* hd_end_r)
{
// example  
    (void) hd_end;    
    if((uuid16 == 0xca9e) && (hd_start <= 0x10))// MUST keep match with the information save in function  att_server_rdByGrType(...)
    {
        *hd_start_r = 0x10;
        *hd_end_r = 0x15;
        return 1;
    }
    
    return 0;
}


//add user sending data notify operation ....
void gatt_user_send_notify_data_callback(void)
{
    //to do if any ...
    //add user sending data notify operation ....
}

char GetConnectedStatus(void)
{
    return gConnectedFlag;
}


void ConnectStausUpdate(unsigned char IsConnectedFlag) //porting api
{
    //[IsConnectedFlag] indicates the connection status

    if (IsConnectedFlag != gConnectedFlag)
    {
        gConnectedFlag = IsConnectedFlag;
    }
}


void UsrProcCallback_Central(u8 fin, u8* dat_rcv, u8 dat_len)
{
    (void)fin;
    (void)dat_rcv;
    (void)dat_len;    
}


void att_cli_receive_callback(u16 att_hd, u8* attValue/*app data pointer*/, u8 valueLen_w/*app data size*/)
{
    (void)att_hd;
    (void)attValue;
    (void)valueLen_w;
}


void gatt_client_send_callback(void)
{
}
#endif


