
/**
 ******************************************************************************
 *
 * @file        
 * @brief        
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _BSP_LCD_H
#define _BSP_LCD_H

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_LCD_DRV.h"

/* Menu ----------------------------------------------------------------------*/


/* Typedef -------------------------------------------------------------------*/
typedef union
{
    uint8_t B;
    struct
    {
        __IO  uint8_t COM0  : 1;
        __IO  uint8_t COM1  : 1;
        __IO  uint8_t COM2  : 1;
        __IO  uint8_t COM3  : 1;
        __IO  uint8_t COM4  : 1;
        __IO  uint8_t COM5  : 1;
        __IO  uint8_t COM6  : 1;
        __IO  uint8_t COM7  : 1;
    }MBIT;
}COM_TypeDef;

typedef struct
{
    uint16_t   Year;
    uint16_t   mSecond;
    uint8_t    Month;
    uint8_t    Day;
    uint8_t    Hour;
    uint8_t    Minute;
    uint8_t    Second;
    uint8_t    pSecond;
    uint8_t    __padding[2]; 
}LCD_ClockTypeDef;


/* Define --------------------------------------------------------------------*/
#define LCD_MD_Base   0x5A000030

#define LCD_P0        ((COM_TypeDef*)(LCD_MD_Base + 0))
#define LCD_P1        ((COM_TypeDef*)(LCD_MD_Base + 1))
#define LCD_P2        ((COM_TypeDef*)(LCD_MD_Base + 2))
#define LCD_P3        ((COM_TypeDef*)(LCD_MD_Base + 3))
#define LCD_P4        ((COM_TypeDef*)(LCD_MD_Base + 4))
#define LCD_P5        ((COM_TypeDef*)(LCD_MD_Base + 5))
#define LCD_P6        ((COM_TypeDef*)(LCD_MD_Base + 6))
#define LCD_P7        ((COM_TypeDef*)(LCD_MD_Base + 7))
#define LCD_P8        ((COM_TypeDef*)(LCD_MD_Base + 8))
#define LCD_P9        ((COM_TypeDef*)(LCD_MD_Base + 9))
#define LCD_P10       ((COM_TypeDef*)(LCD_MD_Base + 10))
#define LCD_P11       ((COM_TypeDef*)(LCD_MD_Base + 11))
#define LCD_P12       ((COM_TypeDef*)(LCD_MD_Base + 12))
#define LCD_P13       ((COM_TypeDef*)(LCD_MD_Base + 13))
#define LCD_P14       ((COM_TypeDef*)(LCD_MD_Base + 14))
#define LCD_P15       ((COM_TypeDef*)(LCD_MD_Base + 15))
#define LCD_P16       ((COM_TypeDef*)(LCD_MD_Base + 16))
#define LCD_P17       ((COM_TypeDef*)(LCD_MD_Base + 17))
#define LCD_P18       ((COM_TypeDef*)(LCD_MD_Base + 18))
#define LCD_P19       ((COM_TypeDef*)(LCD_MD_Base + 19))
#define LCD_P20       ((COM_TypeDef*)(LCD_MD_Base + 20))
#define LCD_P21       ((COM_TypeDef*)(LCD_MD_Base + 21))
#define LCD_P22       ((COM_TypeDef*)(LCD_MD_Base + 22))
#define LCD_P23       ((COM_TypeDef*)(LCD_MD_Base + 23))
#define LCD_P24       ((COM_TypeDef*)(LCD_MD_Base + 24))
#define LCD_P25       ((COM_TypeDef*)(LCD_MD_Base + 25))
#define LCD_P26       ((COM_TypeDef*)(LCD_MD_Base + 26))
#define LCD_P27       ((COM_TypeDef*)(LCD_MD_Base + 27))
#define LCD_P28       ((COM_TypeDef*)(LCD_MD_Base + 28))
#define LCD_P29       ((COM_TypeDef*)(LCD_MD_Base + 29))
#define LCD_P30       ((COM_TypeDef*)(LCD_MD_Base + 30))
#define LCD_P31       ((COM_TypeDef*)(LCD_MD_Base + 31))
#define LCD_P32       ((COM_TypeDef*)(LCD_MD_Base + 32))
#define LCD_P33       ((COM_TypeDef*)(LCD_MD_Base + 33))
#define LCD_P34       ((COM_TypeDef*)(LCD_MD_Base + 34))
#define LCD_P35       ((COM_TypeDef*)(LCD_MD_Base + 35))
#define LCD_P36       ((COM_TypeDef*)(LCD_MD_Base + 36))
#define LCD_P37       ((COM_TypeDef*)(LCD_MD_Base + 37))
#define LCD_P38       ((COM_TypeDef*)(LCD_MD_Base + 38))
#define LCD_P39       ((COM_TypeDef*)(LCD_MD_Base + 39))
#define LCD_P40       ((COM_TypeDef*)(LCD_MD_Base + 40))
#define LCD_P41       ((COM_TypeDef*)(LCD_MD_Base + 41))
#define LCD_P42       ((COM_TypeDef*)(LCD_MD_Base + 42))
#define LCD_P43       ((COM_TypeDef*)(LCD_MD_Base + 43))


#define BSP_LCD_SEG7_1   0
#define BSP_LCD_SEG7_2   1
#define BSP_LCD_SEG7_3   2
#define BSP_LCD_SEG7_4   3
#define BSP_LCD_SEG7_5   4
#define BSP_LCD_SEG7_6   5
#define BSP_LCD_SEG7_7   6
#define BSP_LCD_SEG7_8   7
#define BSP_LCD_SEG7_9   8
#define BSP_LCD_SEG7_10  9

#define BSP_LCD_SEG7_6to10_S14     0
#define BSP_LCD_SEG7_6to10_S15     1
#define BSP_LCD_SEG7_6to10_S16     2
#define BSP_LCD_SEG7_6to10_S17     3
                                   
#define BSP_LCD_SEG16_11           0
#define BSP_LCD_SEG16_12           1
#define BSP_LCD_SEG16_13           2
#define BSP_LCD_SEG16_14           3
#define BSP_LCD_SEG16_15           4

#define BSP_LCD_TEMPERTURE_MODE    0
#define BSP_LCD_HUMIDITY_MODE      1
#define BSP_LCD_VOLTAGE_V_MODE     2
#define BSP_LCD_VOLTAGE_mV_MODE    3                              
#define BSP_LCD_CURRENT_A_MODE     4
#define BSP_LCD_CURRENT_mA_MODE    5
#define BSP_LCD_PRESSURE_KPA_MODE  6
#define BSP_LCD_PRESSURE_MPA_MODE  7


#define BSP_LCD_BATTERY_LEVEL0     0
#define BSP_LCD_BATTERY_LEVEL1     1
#define BSP_LCD_BATTERY_LEVEL2     2
#define BSP_LCD_BATTERY_LEVEL3     3

#define BSP_LCD_SINGSTRENGTH_LEVLE0  0
#define BSP_LCD_SINGSTRENGTH_LEVLE1  1
#define BSP_LCD_SINGSTRENGTH_LEVLE2  2


#define BSP_LCD_SUCCESS    0
#define BSP_LCD_FAILURE    1


/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
extern COM_TypeDef LCD_PIN1_Tmp;
extern COM_TypeDef LCD_PIN2_Tmp;
extern COM_TypeDef LCD_PIN3_Tmp;
extern COM_TypeDef LCD_PIN4_Tmp;
extern COM_TypeDef LCD_PIN5_Tmp;
extern COM_TypeDef LCD_PIN6_Tmp;
extern COM_TypeDef LCD_PIN7_Tmp;
extern COM_TypeDef LCD_PIN8_Tmp;
extern COM_TypeDef LCD_PIN9_Tmp;
extern COM_TypeDef LCD_PIN10_Tmp;
extern COM_TypeDef LCD_PIN11_Tmp;
extern COM_TypeDef LCD_PIN12_Tmp;
extern COM_TypeDef LCD_PIN13_Tmp;
extern COM_TypeDef LCD_PIN14_Tmp;
extern COM_TypeDef LCD_PIN15_Tmp;
extern COM_TypeDef LCD_PIN16_Tmp;
extern COM_TypeDef LCD_PIN17_Tmp;
extern COM_TypeDef LCD_PIN18_Tmp;
extern COM_TypeDef LCD_PIN19_Tmp;
extern COM_TypeDef LCD_PIN20_Tmp;
extern COM_TypeDef LCD_PIN21_Tmp;
extern COM_TypeDef LCD_PIN22_Tmp;
extern COM_TypeDef LCD_PIN23_Tmp;
extern COM_TypeDef LCD_PIN24_Tmp;

/* Functions -----------------------------------------------------------------*/
void BSP_LCD_Init(void);
void BSP_LCD_ClearDataBuffer(void);
uint8_t BSP_LCD_TriggerUpdate(void);


void BSP_LCD_SignalStrength(uint8_t SignalStrength_Level);
void BSP_LCD_Battery(uint8_t BatterLevel);
void BSP_LCD_Percentage(uint8_t Percentage_number);

void BSP_LCD_7Segment(uint8_t SEG7_Number, uint8_t diplay_number);
void BSP_LCD_7Segment_6_10_Point(uint8_t SEG7_6to10_point);
void BSP_LCD_7Segment_6_10_NegativeSymbol(uint8_t SEG7_6to10_SigFigs);

void BSP_LCD_16SegmentChar( uint8_t SEG16_Number, uint8_t SEG16_display);
void BSP_LCD_16Segment0to9( uint8_t SEG16_Number, uint8_t SEG16_display);

void BSP_LCD_Symbol_T(void);
void BSP_LCD_Symbol_P(void);
void BSP_LCD_Symbol_Degree(void);
void BSP_LCD_Symbol_Percentage(void);
void BSP_LCD_Symbol_V(void);
void BSP_LCD_Symbol_A(void);
void BSP_LCD_Symbol_m(void);
void BSP_LCD_Symbol_KPa(void);
void BSP_LCD_Symbol_MPa(void);

void BSP_LCD_OFF_Cmd( FunctionalState LCD_OFF_Cmd);

#endif



