

/**
 ******************************************************************************
 *
 * @file        MG32_ARGB_Drama.h
 * @brief       
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/01/13
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef __MG32_ARGB_DRAMA_H
#define __MG32_ARGB_DRAMA_H


/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_ARGB.h"
#include "MG32_ARGB_Drama.h"


/* Wizard menu ---------------------------------------------------------------*/
/* typedef -------------------------------------------------------------------*/

/*! @struct ARGBDramaCTR_TypeDef
    @brief  
*/ 

typedef struct __attribute__((packed))
{                                                            
    //=======================================================================
    // ARGB mode Drama Control Relationship.
    
         uint8_t             DramaMode;            /*!< ARGB Display mode control.
                                                        This parameter can be a value of reference to SMP_ARGB_DramaModeTypeDef.*/
         uint8_t             UpdateTRG;            /*!< ARGB control relationship trigger parameter.
                                                        This parameter can be any value of SMP_ARGB_TRGTypeDef.*/
                                                     
         uint8_t             DramaTmp[3];          /*!< Calculate Temporary buffer.*/
                                                   
         uint8_t             *DramaBuf;            /*!< Pointer to data buffer for calculation.*/
                                                   
         uint8_t             DramaAct;             /*!< Control the ARGB drama current main step*/
                                                   
         uint8_t             DramaActMax;          /*!< Control the ARGB drama max main step.*/
                                                   
         uint32_t            DramaScene;           /*!< Control the ARGB drama current substep*/
                                                   
         uint32_t            DramaSceneMax;        /*!< Control the ARGB drama max substep.*/
                                                   
         uint8_t             DramaTime;            /*!< Control the ARGB drama current time .*/
                                                   
         uint8_t             DramaTimeMax;         /*!< Control the ARGB drama max time .*/
                                 
}ARGBDramaCTR_TypeDef;

/* define --------------------------------------------------------------------*/
/**
 * @name	ARGBDramaCTR_TypeDef : ARGB Display mode.
 *   		
 */ 
///@{
#define ARGB_DRAMA_DISABLE        0                 /*!<ARGB mode = ARGB disable mode.*/
#define ARGB_DRAMA_STATIC         1                 /*!<ARGB mode = ARGB Static color mode.*/
#define ARGB_DRAMA_BREATH         2                 /*!<ARGB mode = ARGB breath mode.*/
#define ARGB_DRAMA_RAINBOW        3                 /*!<ARGB mode = ARGB rainbow mode.*/
#define ARGB_DRAMA_MORPHING       4                 /*!<ARGB mode = ARGB morphing color mode.*/
#define ARGB_DRAMA_WDROP          5                 /*!<ARGB mode = ARGB water drop mode.*/
#define ARGB_DRAMA_MOVING         6                 /*!<ARGB mode = ARGB signal direct move mode.*/
#define ARGB_DRAMA_2MOVING        7                 /*!<ARGB mode = ARGB two direct move mode.*/
///@}
/**
 * @name	ARGBDramaCTR_TypeDef : ARGB relationship trigger status.
 *   		
 */ 
///@{
#define ARGB_UPDATE_DATA          0x01                 /*!< ARGB data update.*/
#define ARGB_UPDATE_MODE          0x02                 /*!< ARGB mode update.*/
///@}

/* macro ---------------------------------------------------------------------*/                                                      
/* Exported variables --------------------------------------------------------*/
extern ARGBDramaCTR_TypeDef  ARGB_Drama;
extern uint8_t               ARGB_DramaBuf[SMP_ARGB_PIECE][SMP_ARGB_DATASIZE];   /*!<.The buffer is use for ARGB calculate.*/

/* Exported functions --------------------------------------------------------*/
void MG32_ARGBDrama_Init(void);
void MG32_ARGBDrama_ClearBuf( ARGBDramaCTR_TypeDef* sARGB );
void MG32_ARGBDrama_UpdateData( ARGBDramaCTR_TypeDef* sARGB );
void MG32_ARGBDrama_UpdateMode( ARGBDramaCTR_TypeDef* sARGB );
void MG32_ARGBDrama_ChangeMode( uint8_t  ARGB_Mode);


void MG32_ARGBDrama_UpdateModeCallback(void);

/* External variables --------------------------------------------------------*/
/* External function----------------------------------------------------------*/






#endif


