


 /**
 ******************************************************************************
 *
 * @file        USBD_DSC.h
 * @brief       The USBD Descriptor's h file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2020/09/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _USB_DSC_H
#define _USB_DSC_H

#include "MG32.h"
#include "MG32_USB_Init.h"

#define FKB_TOTALFUNCTION    0x14


#define    HID_REPORT_LENGTH sizeof(HID_REPORT)



#define    EP0_PACKET_SIZE       64                                       /*!< Maximum packet size for EP0.*/
#define    EP1_PACKET_SIZE        8                                       /*!< Maximum packet size for EP1.*/






#define USB_CONFIGURATION_DESC_SIZE        9          /*!< USB Configuration descriptor data size. */
#define USB_INTERFACE_DESC_SIZE            9          /*!< USB Interface descriptor data size. */
#define USB_HID_DESC_SIZE                  9          /*!< USB HID descriptor data size. */
#define USB_ENDPOINT_DESC_SIZE             7          /*!< USB Endpoint descriptor data size. */


#define USB_CONFIGURATION_TOTAOL_INTERFACE  1                                                                                    /*!< Total interface in the configuration.*/

#define USB_CONFIGURATION_DESC_TOTAOSIZE   ((USB_CONFIGURATION_DESC_SIZE * 1) +  \
                                            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE + USB_ENDPOINT_DESC_SIZE * 1))          /*!< The configuration descriptor total size.*/
                                      


       
extern const uint16_t HID0_ReportLength;                    /*!< HID0 report size */


extern const uint8_t USB_INTERFACE0_HID_REPORT[];           /*!< HID report of interface0.*/
extern const uint8_t USB_DEVICE_DESCRIPTOR[];               /*!< Device Descriptor.*/
extern const uint8_t USB_CONFIGURATION_DESCRIPTOR[];        /*!< Configuration Descriptor.*/
extern const uint8_t USB_STRING_DESCRIPTOR[];               /*!< String descriptor.*/
                                                            
#if MF_STRING == 1                                          
#define MFS_LEN (sizeof(MANUFACTURER_DESCRIPTOR)*2)         /*!< Manufacture descriptor size.*/
extern  const uint8_t Manufacturer_Descriptor[];            /*!< Manufacture string descriptor.*/
#endif                                                      
                                                            
#if PD_STRING == 1                                          
#define PDS_LEN (sizeof(PRODUCT_DESCRIPTOR)*2)              /*!< Product descriptor size.*/
extern const uint8_t Product_Descriptor[];                  /*!< Product string descriptor.*/
#endif                                                      
                                                            
#if SN_STRING == 1                                          
#define SNS_LEN (sizeof(SERIALNUMBER_DESCRIPTOR)*2)         /*!< Serial number descriptor size.*/
extern const uint8_t SerialNumber_Descriptor[];             /*!< Serial number string descriptor.*/
#endif                                                      
                                                            
#if MG_USB_LPM_EN == 1                                      
extern const uint8_t USB_BOS_DESCRIPTOR[];                  /*!< BOS descriptor.*/
extern const uint8_t USB_EXT_DESCRIPTOR[];                  /*!< Device capability descriptor.*/
#endif

#endif
















