

/**
 ******************************************************************************
 *
 * @file        Audio1.c
 * @brief       This is a 8K, mono with 8bit Audio raw data. 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2025/07/14
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/*
    Audio raw data :
        1. 8K Hz sample rate.
        2. mono channel.
        3. 8bit data.
        4. Total 2400 bytes ~ 3 second.
        
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define rawData_Size    24000 

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        __ALIGNED(4) const uint8_t rawData[rawData_Size] = {
    #pragma clang diagnostic pop
#else
    __ALIGNED(4) const uint8_t rawData[rawData_Size] = {
#endif

	0x80, 0x7B, 0x7D, 0x7E, 0x7B, 0x7E, 0x7D, 0x7F, 0x7F, 0x7F, 0x82, 0x7D,
	0x83, 0x7F, 0x80, 0x82, 0x7F, 0x82, 0x7F, 0x83, 0x7F, 0x82, 0x81, 0x81,
	0x83, 0x82, 0x85, 0x83, 0x85, 0x85, 0x85, 0x86, 0x84, 0x86, 0x84, 0x83,
	0x85, 0x82, 0x84, 0x84, 0x84, 0x85, 0x81, 0x87, 0x7F, 0x85, 0x83, 0x82,
	0x85, 0x81, 0x84, 0x84, 0x82, 0x84, 0x83, 0x81, 0x83, 0x81, 0x82, 0x82,
	0x83, 0x82, 0x81, 0x82, 0x80, 0x83, 0x82, 0x84, 0x81, 0x84, 0x83, 0x81,
	0x83, 0x82, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x7F, 0x80, 0x81, 0x7D, 0x7F,
	0x7E, 0x7C, 0x80, 0x7C, 0x7E, 0x7F, 0x7D, 0x80, 0x7D, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7B, 0x7C, 0x7C, 0x7C, 0x7D, 0x7C, 0x7C, 0x7A, 0x7C, 0x7C, 0x7B,
	0x7E, 0x7B, 0x7F, 0x7E, 0x7C, 0x80, 0x7C, 0x7D, 0x7C, 0x7D, 0x7C, 0x7D,
	0x7D, 0x80, 0x7E, 0x7D, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x7D, 0x82, 0x80,
	0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x82, 0x80, 0x81, 0x84, 0x81, 0x82,
	0x82, 0x83, 0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x85, 0x84, 0x85, 0x83,
	0x83, 0x84, 0x82, 0x84, 0x82, 0x85, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x81, 0x82, 0x82, 0x84, 0x84, 0x83, 0x84, 0x82, 0x82, 0x81, 0x82, 0x80,
	0x80, 0x82, 0x7F, 0x82, 0x80, 0x7F, 0x82, 0x7F, 0x82, 0x81, 0x82, 0x83,
	0x82, 0x83, 0x80, 0x82, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x81,
	0x7D, 0x80, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x82, 0x84, 0x84,
	0x80, 0x81, 0x83, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7A, 0x79, 0x79,
	0x79, 0x7C, 0x7A, 0x7A, 0x7C, 0x79, 0x79, 0x78, 0x7A, 0x7C, 0x7F, 0x84,
	0x84, 0x86, 0x87, 0x87, 0x88, 0x88, 0x8B, 0x89, 0x8A, 0x8C, 0x8B, 0x8B,
	0x8A, 0x8A, 0x88, 0x87, 0x88, 0x87, 0x86, 0x86, 0x85, 0x85, 0x82, 0x84,
	0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x7D, 0x7E, 0x7D, 0x7D, 0x7C, 0x7A, 0x79,
	0x79, 0x78, 0x79, 0x7A, 0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7B, 0x7A, 0x7C,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7B, 0x7C, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x83, 0x83,
	0x84, 0x83, 0x82, 0x81, 0x82, 0x81, 0x83, 0x84, 0x85, 0x86, 0x85, 0x86,
	0x87, 0x88, 0x88, 0x89, 0x8A, 0x8A, 0x8A, 0x89, 0x89, 0x89, 0x89, 0x88,
	0x87, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x78, 0x77, 0x73, 0x72,
	0x73, 0x73, 0x74, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x76, 0x77, 0x7A,
	0x7D, 0x7F, 0x82, 0x84, 0x86, 0x88, 0x88, 0x8A, 0x8B, 0x8B, 0x8C, 0x8C,
	0x8B, 0x8C, 0x8B, 0x8A, 0x89, 0x88, 0x87, 0x86, 0x88, 0x87, 0x87, 0x87,
	0x87, 0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80,
	0x7E, 0x7C, 0x7A, 0x79, 0x78, 0x7A, 0x77, 0x74, 0x74, 0x75, 0x76, 0x76,
	0x78, 0x77, 0x77, 0x77, 0x74, 0x72, 0x71, 0x72, 0x74, 0x78, 0x79, 0x7A,
	0x7E, 0x7C, 0x7E, 0x7D, 0x79, 0x77, 0x77, 0x78, 0x78, 0x7A, 0x7B, 0x79,
	0x7E, 0x7A, 0x75, 0x77, 0x76, 0x78, 0x7B, 0x7F, 0x81, 0x8A, 0x92, 0x95,
	0x9B, 0xA1, 0xA0, 0x9F, 0x9F, 0x9A, 0x96, 0x94, 0x8D, 0x89, 0x89, 0x87,
	0x86, 0x7D, 0x84, 0x81, 0x7D, 0x82, 0x82, 0x81, 0x82, 0x8A, 0x87, 0x8C,
	0x95, 0x93, 0x98, 0x9B, 0x96, 0x94, 0x92, 0x8D, 0x85, 0x83, 0x7F, 0x7A,
	0x77, 0x77, 0x76, 0x76, 0x6C, 0x74, 0x73, 0x6B, 0x72, 0x6E, 0x6F, 0x6C,
	0x6E, 0x72, 0x6F, 0x7A, 0x7A, 0x7B, 0x83, 0x81, 0x82, 0x7F, 0x83, 0x79,
	0x74, 0x79, 0x74, 0x78, 0x78, 0x7A, 0x7F, 0x78, 0x79, 0x83, 0x7B, 0x79,
	0x7A, 0x7B, 0x78, 0x7A, 0x83, 0x7E, 0x87, 0x90, 0x90, 0x8F, 0x95, 0x95,
	0x8D, 0x8F, 0x86, 0x81, 0x7C, 0x7C, 0x78, 0x76, 0x75, 0x74, 0x79, 0x71,
	0x6E, 0x7D, 0x70, 0x73, 0x75, 0x72, 0x76, 0x76, 0x7E, 0x7E, 0x8A, 0x93,
	0x95, 0x9C, 0x9D, 0x9B, 0x98, 0x95, 0x91, 0x8C, 0x8D, 0x87, 0x83, 0x85,
	0x80, 0x7F, 0x83, 0x7B, 0x75, 0x82, 0x7A, 0x77, 0x7D, 0x7A, 0x79, 0x78,
	0x7B, 0x7C, 0x7D, 0x86, 0x86, 0x88, 0x8D, 0x88, 0x83, 0x82, 0x7D, 0x76,
	0x6F, 0x6E, 0x6C, 0x6B, 0x6C, 0x6D, 0x6C, 0x6E, 0x65, 0x6D, 0x69, 0x63,
	0x6B, 0x6C, 0x6F, 0x73, 0x79, 0x80, 0x88, 0x97, 0x9C, 0xA1, 0xA2, 0x9F,
	0x9D, 0x96, 0x92, 0x8E, 0x89, 0x87, 0x87, 0x84, 0x82, 0x82, 0x81, 0x7F,
	0x74, 0x78, 0x78, 0x71, 0x75, 0x73, 0x75, 0x73, 0x79, 0x7D, 0x82, 0x89,
	0x92, 0x96, 0x97, 0x98, 0x98, 0x90, 0x8B, 0x84, 0x7B, 0x79, 0x79, 0x7B,
	0x7B, 0x7C, 0x7E, 0x81, 0x78, 0x78, 0x82, 0x75, 0x74, 0x75, 0x72, 0x70,
	0x74, 0x7A, 0x7D, 0x89, 0x8F, 0x8F, 0x93, 0x94, 0x93, 0x91, 0x8E, 0x88,
	0x82, 0x82, 0x7E, 0x7D, 0x81, 0x80, 0x81, 0x84, 0x7E, 0x73, 0x83, 0x7A,
	0x77, 0x7D, 0x78, 0x7A, 0x7D, 0x7F, 0x84, 0x89, 0x98, 0x97, 0x9A, 0x9F,
	0x9A, 0x98, 0x93, 0x8F, 0x88, 0x86, 0x81, 0x7D, 0x7B, 0x77, 0x77, 0x73,
	0x70, 0x65, 0x6F, 0x6A, 0x62, 0x6A, 0x69, 0x6B, 0x6D, 0x73, 0x70, 0x76,
	0x84, 0x80, 0x89, 0x8D, 0x88, 0x88, 0x84, 0x82, 0x7B, 0x7F, 0x84, 0x80,
	0x89, 0x87, 0x86, 0x8B, 0x8D, 0x7D, 0x87, 0x89, 0x79, 0x7E, 0x82, 0x81,
	0x81, 0x88, 0x86, 0x87, 0x92, 0x8D, 0x8F, 0x93, 0x8F, 0x8A, 0x86, 0x85,
	0x7C, 0x7A, 0x78, 0x74, 0x7B, 0x78, 0x7A, 0x7A, 0x7C, 0x6E, 0x67, 0x76,
	0x63, 0x66, 0x6A, 0x67, 0x67, 0x6C, 0x77, 0x72, 0x82, 0x8F, 0x86, 0x8C,
	0x8B, 0x87, 0x7D, 0x7E, 0x7C, 0x71, 0x74, 0x74, 0x76, 0x7A, 0x7E, 0x83,
	0x84, 0x7F, 0x72, 0x7F, 0x72, 0x6C, 0x74, 0x70, 0x73, 0x77, 0x81, 0x7D,
	0x82, 0x97, 0x8E, 0x94, 0x99, 0x8F, 0x8E, 0x8B, 0x8A, 0x80, 0x86, 0x8A,
	0x88, 0x92, 0x8E, 0x93, 0x94, 0x96, 0x84, 0x87, 0x8A, 0x73, 0x78, 0x77,
	0x73, 0x76, 0x78, 0x7A, 0x82, 0x8E, 0x8C, 0x88, 0x8D, 0x90, 0x89, 0x86,
	0x7C, 0x66, 0x6C, 0x71, 0x78, 0x87, 0x77, 0x74, 0x79, 0x89, 0x85, 0x86,
	0x8D, 0x67, 0x6F, 0x81, 0x87, 0x90, 0x8E, 0x85, 0x7D, 0x9D, 0xAF, 0xA9,
	0xA8, 0x95, 0x87, 0x86, 0x93, 0x90, 0x81, 0x7A, 0x6C, 0x79, 0x87, 0x92,
	0x94, 0x87, 0x6E, 0x67, 0x80, 0x72, 0x74, 0x6F, 0x62, 0x64, 0x71, 0x84,
	0x7E, 0x88, 0x8D, 0x7E, 0x8B, 0x8F, 0x8A, 0x81, 0x78, 0x71, 0x6B, 0x75,
	0x7C, 0x7C, 0x7E, 0x7B, 0x7F, 0x84, 0x7B, 0x6F, 0x7B, 0x64, 0x5D, 0x68,
	0x6C, 0x71, 0x7A, 0x83, 0x7C, 0x89, 0x9C, 0x8E, 0x94, 0x92, 0x84, 0x7A,
	0x77, 0x75, 0x6E, 0x72, 0x76, 0x7A, 0x84, 0x88, 0x8D, 0x92, 0x83, 0x73,
	0x86, 0x73, 0x6C, 0x79, 0x79, 0x7B, 0x85, 0x94, 0x91, 0x99, 0xAA, 0x9D,
	0x99, 0x95, 0x88, 0x7D, 0x79, 0x77, 0x70, 0x72, 0x78, 0x7D, 0x89, 0x8D,
	0x8C, 0x8F, 0x7C, 0x64, 0x7C, 0x65, 0x5B, 0x6A, 0x6A, 0x6F, 0x7B, 0x90,
	0x90, 0x98, 0xA6, 0xA0, 0x9E, 0x9D, 0x92, 0x87, 0x84, 0x85, 0x81, 0x85,
	0x8D, 0x92, 0x98, 0x9A, 0x96, 0x98, 0x83, 0x6A, 0x7A, 0x66, 0x5C, 0x6A,
	0x6E, 0x73, 0x80, 0x8F, 0x89, 0x8E, 0x98, 0x8C, 0x88, 0x84, 0x7B, 0x70,
	0x6D, 0x6F, 0x6F, 0x74, 0x7C, 0x84, 0x88, 0x85, 0x83, 0x85, 0x6D, 0x58,
	0x6C, 0x5C, 0x58, 0x68, 0x74, 0x78, 0x84, 0x93, 0x89, 0x89, 0x92, 0x85,
	0x7D, 0x7B, 0x78, 0x73, 0x78, 0x7E, 0x80, 0x83, 0x8A, 0x90, 0x8F, 0x8E,
	0x86, 0x82, 0x63, 0x50, 0x6B, 0x56, 0x60, 0x72, 0x7D, 0x87, 0x92, 0x9E,
	0x93, 0x8D, 0x9A, 0x8A, 0x80, 0x85, 0x83, 0x81, 0x88, 0x91, 0x93, 0x95,
	0x9D, 0x9E, 0x98, 0x90, 0x84, 0x7B, 0x57, 0x57, 0x68, 0x58, 0x65, 0x7A,
	0x87, 0x8B, 0x96, 0x97, 0x81, 0x83, 0x82, 0x73, 0x74, 0x75, 0x7A, 0x7C,
	0x84, 0x8D, 0x92, 0x9A, 0x9C, 0x9E, 0x95, 0x92, 0x8B, 0x84, 0x68, 0x67,
	0x80, 0x70, 0x7F, 0x93, 0x97, 0x9A, 0x9A, 0x97, 0x8D, 0x86, 0x87, 0x7E,
	0x7A, 0x7A, 0x81, 0x83, 0x85, 0x8A, 0x8C, 0x88, 0x89, 0x8B, 0x86, 0x7D,
	0x76, 0x6F, 0x4D, 0x5E, 0x69, 0x5F, 0x6D, 0x77, 0x7F, 0x80, 0x7F, 0x7D,
	0x76, 0x74, 0x75, 0x75, 0x79, 0x7B, 0x84, 0x85, 0x81, 0x86, 0x8B, 0x89,
	0x86, 0x87, 0x7F, 0x79, 0x78, 0x72, 0x58, 0x6E, 0x75, 0x6A, 0x7A, 0x89,
	0x8B, 0x8A, 0x84, 0x7D, 0x77, 0x73, 0x76, 0x7A, 0x7D, 0x82, 0x8A, 0x8B,
	0x8B, 0x8E, 0x90, 0x8C, 0x8B, 0x8C, 0x87, 0x83, 0x85, 0x76, 0x62, 0x7F,
	0x7C, 0x7F, 0x8C, 0x94, 0x96, 0x8B, 0x84, 0x7D, 0x7A, 0x7C, 0x79, 0x7D,
	0x7F, 0x85, 0x8F, 0x90, 0x8D, 0x8C, 0x8B, 0x84, 0x82, 0x83, 0x7D, 0x75,
	0x74, 0x69, 0x5A, 0x79, 0x79, 0x7A, 0x88, 0x95, 0x99, 0x95, 0x8D, 0x8A,
	0x84, 0x85, 0x8A, 0x91, 0x97, 0x97, 0x99, 0x9A, 0x95, 0x94, 0x95, 0x8D,
	0x89, 0x86, 0x7F, 0x77, 0x79, 0x62, 0x5E, 0x78, 0x6F, 0x77, 0x7F, 0x89,
	0x8A, 0x7D, 0x78, 0x77, 0x71, 0x71, 0x74, 0x7A, 0x7D, 0x81, 0x84, 0x82,
	0x7E, 0x7F, 0x7E, 0x7C, 0x7C, 0x7F, 0x7A, 0x75, 0x73, 0x57, 0x63, 0x71,
	0x6E, 0x75, 0x7D, 0x89, 0x84, 0x7A, 0x75, 0x76, 0x7A, 0x78, 0x82, 0x8B,
	0x8A, 0x8C, 0x8B, 0x8B, 0x83, 0x80, 0x7E, 0x79, 0x7D, 0x7C, 0x7C, 0x78,
	0x75, 0x5D, 0x6F, 0x7C, 0x79, 0x7E, 0x87, 0x92, 0x8D, 0x83, 0x81, 0x85,
	0x85, 0x88, 0x95, 0x9C, 0x9C, 0x99, 0x93, 0x8C, 0x85, 0x82, 0x7E, 0x7D,
	0x7F, 0x7D, 0x77, 0x7D, 0x6D, 0x5C, 0x76, 0x75, 0x77, 0x78, 0x81, 0x86,
	0x7B, 0x71, 0x77, 0x7E, 0x81, 0x85, 0x93, 0x9B, 0x99, 0x98, 0x97, 0x95,
	0x8F, 0x8D, 0x8E, 0x93, 0x92, 0x8E, 0x8A, 0x8D, 0x6D, 0x6F, 0x86, 0x84,
	0x89, 0x83, 0x90, 0x90, 0x7E, 0x75, 0x76, 0x7B, 0x7E, 0x83, 0x8F, 0x90,
	0x8C, 0x85, 0x82, 0x81, 0x7E, 0x7B, 0x7E, 0x82, 0x78, 0x71, 0x73, 0x71,
	0x55, 0x5C, 0x6E, 0x71, 0x76, 0x7A, 0x89, 0x88, 0x74, 0x70, 0x78, 0x7A,
	0x81, 0x87, 0x90, 0x8F, 0x8A, 0x87, 0x84, 0x85, 0x81, 0x7D, 0x85, 0x84,
	0x7E, 0x77, 0x7C, 0x69, 0x51, 0x69, 0x6F, 0x77, 0x74, 0x79, 0x87, 0x7C,
	0x6E, 0x71, 0x7B, 0x81, 0x86, 0x8F, 0x92, 0x92, 0x8D, 0x8B, 0x8E, 0x8D,
	0x8A, 0x8A, 0x94, 0x92, 0x8A, 0x83, 0x86, 0x67, 0x5E, 0x77, 0x7A, 0x81,
	0x7B, 0x86, 0x89, 0x77, 0x6D, 0x71, 0x7D, 0x86, 0x86, 0x8F, 0x8E, 0x89,
	0x7E, 0x7B, 0x80, 0x7F, 0x7F, 0x83, 0x8D, 0x8A, 0x7C, 0x83, 0x83, 0x62,
	0x71, 0x86, 0x92, 0x92, 0x8E, 0x9C, 0x99, 0x86, 0x7C, 0x85, 0x92, 0x97,
	0x9B, 0x9F, 0x9E, 0x97, 0x8A, 0x89, 0x8C, 0x86, 0x81, 0x85, 0x8B, 0x84,
	0x75, 0x76, 0x6A, 0x52, 0x68, 0x74, 0x83, 0x7C, 0x79, 0x83, 0x77, 0x67,
	0x61, 0x6E, 0x7A, 0x7F, 0x84, 0x88, 0x88, 0x81, 0x79, 0x7E, 0x82, 0x82,
	0x81, 0x86, 0x85, 0x7E, 0x74, 0x7B, 0x6A, 0x5B, 0x71, 0x7A, 0x88, 0x7D,
	0x81, 0x89, 0x7D, 0x6B, 0x69, 0x79, 0x86, 0x88, 0x8A, 0x88, 0x83, 0x7A,
	0x76, 0x7E, 0x86, 0x85, 0x84, 0x89, 0x89, 0x7F, 0x75, 0x7A, 0x60, 0x63,
	0x76, 0x83, 0x8E, 0x83, 0x8B, 0x8F, 0x88, 0x77, 0x7B, 0x8C, 0x93, 0x96,
	0x94, 0x8F, 0x8A, 0x81, 0x7D, 0x82, 0x89, 0x88, 0x89, 0x8D, 0x88, 0x7E,
	0x77, 0x73, 0x59, 0x61, 0x72, 0x7F, 0x85, 0x7C, 0x83, 0x87, 0x7E, 0x74,
	0x7E, 0x93, 0x9B, 0x9C, 0x9C, 0x98, 0x92, 0x8A, 0x88, 0x8F, 0x94, 0x93,
	0x91, 0x93, 0x8E, 0x85, 0x84, 0x7D, 0x62, 0x6E, 0x79, 0x85, 0x86, 0x7C,
	0x85, 0x86, 0x7A, 0x6B, 0x74, 0x89, 0x8F, 0x8F, 0x8C, 0x84, 0x7D, 0x76,
	0x76, 0x7E, 0x83, 0x81, 0x7E, 0x7E, 0x7E, 0x74, 0x75, 0x66, 0x55, 0x6D,
	0x75, 0x86, 0x7B, 0x7A, 0x7C, 0x78, 0x6F, 0x69, 0x7E, 0x88, 0x89, 0x87,
	0x84, 0x83, 0x7B, 0x7B, 0x7D, 0x87, 0x8A, 0x85, 0x85, 0x81, 0x7D, 0x73,
	0x72, 0x64, 0x58, 0x6F, 0x7A, 0x86, 0x7B, 0x7D, 0x84, 0x80, 0x76, 0x71,
	0x86, 0x93, 0x95, 0x90, 0x8A, 0x8A, 0x84, 0x84, 0x89, 0x96, 0x98, 0x8E,
	0x8A, 0x88, 0x81, 0x79, 0x79, 0x5F, 0x5D, 0x6E, 0x7D, 0x85, 0x7A, 0x82,
	0x83, 0x81, 0x72, 0x72, 0x83, 0x90, 0x91, 0x88, 0x86, 0x85, 0x82, 0x83,
	0x88, 0x96, 0x99, 0x92, 0x90, 0x91, 0x8F, 0x89, 0x87, 0x6B, 0x71, 0x7F,
	0x8C, 0x90, 0x85, 0x8C, 0x8A, 0x8A, 0x7D, 0x7F, 0x8F, 0x96, 0x94, 0x88,
	0x89, 0x86, 0x83, 0x82, 0x84, 0x8D, 0x8B, 0x82, 0x7F, 0x7E, 0x7A, 0x77,
	0x71, 0x5A, 0x63, 0x6D, 0x7B, 0x79, 0x73, 0x77, 0x77, 0x74, 0x69, 0x70,
	0x7F, 0x8A, 0x8C, 0x82, 0x7F, 0x7B, 0x7C, 0x7D, 0x82, 0x8C, 0x88, 0x7F,
	0x7A, 0x78, 0x7A, 0x7B, 0x76, 0x5B, 0x6B, 0x75, 0x86, 0x7F, 0x75, 0x7A,
	0x78, 0x75, 0x69, 0x74, 0x83, 0x8D, 0x8C, 0x83, 0x86, 0x85, 0x84, 0x83,
	0x87, 0x8F, 0x8C, 0x86, 0x83, 0x84, 0x83, 0x87, 0x7C, 0x68, 0x73, 0x7B,
	0x90, 0x87, 0x81, 0x82, 0x84, 0x7C, 0x71, 0x7D, 0x88, 0x93, 0x90, 0x85,
	0x87, 0x87, 0x87, 0x84, 0x8A, 0x8E, 0x88, 0x81, 0x7C, 0x7F, 0x7F, 0x84,
	0x74, 0x62, 0x72, 0x77, 0x8F, 0x86, 0x86, 0x8A, 0x8E, 0x87, 0x7C, 0x8E,
	0x95, 0x9E, 0x98, 0x8B, 0x8D, 0x8B, 0x8D, 0x88, 0x90, 0x93, 0x8C, 0x86,
	0x85, 0x89, 0x87, 0x86, 0x71, 0x63, 0x6F, 0x7A, 0x86, 0x7A, 0x77, 0x7A,
	0x7E, 0x76, 0x70, 0x7C, 0x85, 0x8C, 0x84, 0x7A, 0x7B, 0x79, 0x79, 0x75,
	0x7D, 0x84, 0x80, 0x7D, 0x7E, 0x80, 0x7F, 0x7F, 0x68, 0x61, 0x6B, 0x7A,
	0x80, 0x76, 0x73, 0x78, 0x80, 0x77, 0x75, 0x7F, 0x8B, 0x8F, 0x88, 0x82,
	0x7F, 0x7A, 0x78, 0x77, 0x80, 0x87, 0x83, 0x7C, 0x7D, 0x85, 0x86, 0x86,
	0x72, 0x64, 0x6C, 0x77, 0x83, 0x7A, 0x7C, 0x7F, 0x82, 0x7A, 0x78, 0x85,
	0x93, 0x98, 0x8E, 0x88, 0x86, 0x84, 0x86, 0x83, 0x87, 0x8B, 0x8A, 0x86,
	0x87, 0x8A, 0x89, 0x88, 0x74, 0x64, 0x6B, 0x79, 0x84, 0x79, 0x77, 0x7B,
	0x83, 0x7D, 0x7A, 0x83, 0x90, 0x96, 0x8F, 0x8C, 0x8B, 0x8B, 0x8B, 0x8A,
	0x90, 0x95, 0x95, 0x8F, 0x90, 0x92, 0x90, 0x90, 0x7B, 0x6F, 0x72, 0x7F,
	0x8A, 0x7E, 0x7E, 0x7F, 0x85, 0x7F, 0x7C, 0x84, 0x8D, 0x92, 0x87, 0x7F,
	0x79, 0x7A, 0x7A, 0x7A, 0x7F, 0x84, 0x85, 0x80, 0x80, 0x7F, 0x7F, 0x7C,
	0x64, 0x56, 0x5A, 0x6C, 0x7A, 0x71, 0x73, 0x79, 0x81, 0x7A, 0x76, 0x7D,
	0x8C, 0x8F, 0x83, 0x79, 0x73, 0x79, 0x7B, 0x7D, 0x85, 0x8C, 0x8E, 0x89,
	0x87, 0x87, 0x85, 0x7F, 0x63, 0x59, 0x60, 0x73, 0x7D, 0x72, 0x78, 0x7E,
	0x8A, 0x7F, 0x7A, 0x81, 0x8A, 0x8C, 0x81, 0x7B, 0x7A, 0x81, 0x83, 0x84,
	0x8F, 0x94, 0x93, 0x91, 0x90, 0x91, 0x8F, 0x87, 0x6A, 0x60, 0x67, 0x78,
	0x81, 0x79, 0x7C, 0x83, 0x8D, 0x86, 0x80, 0x84, 0x8D, 0x8B, 0x82, 0x7A,
	0x79, 0x7F, 0x81, 0x85, 0x8C, 0x92, 0x92, 0x90, 0x90, 0x90, 0x90, 0x8C,
	0x71, 0x65, 0x6C, 0x7F, 0x8B, 0x85, 0x89, 0x8D, 0x95, 0x8A, 0x80, 0x84,
	0x8F, 0x90, 0x8A, 0x7F, 0x7B, 0x84, 0x88, 0x8B, 0x8F, 0x92, 0x8F, 0x8A,
	0x88, 0x85, 0x85, 0x7C, 0x61, 0x55, 0x5D, 0x72, 0x7C, 0x77, 0x76, 0x7A,
	0x84, 0x78, 0x6F, 0x70, 0x7A, 0x81, 0x80, 0x77, 0x76, 0x7E, 0x84, 0x8A,
	0x8B, 0x8E, 0x8A, 0x87, 0x87, 0x83, 0x84, 0x7B, 0x62, 0x57, 0x5F, 0x78,
	0x84, 0x84, 0x7D, 0x80, 0x83, 0x7A, 0x75, 0x77, 0x7E, 0x7D, 0x7D, 0x75,
	0x78, 0x83, 0x88, 0x8A, 0x88, 0x8B, 0x8A, 0x88, 0x88, 0x85, 0x82, 0x7C,
	0x66, 0x5C, 0x66, 0x7D, 0x8B, 0x88, 0x88, 0x8D, 0x91, 0x86, 0x7C, 0x7B,
	0x83, 0x88, 0x89, 0x7F, 0x7D, 0x85, 0x8B, 0x90, 0x90, 0x91, 0x8D, 0x8A,
	0x8A, 0x83, 0x83, 0x7C, 0x64, 0x58, 0x5F, 0x79, 0x8B, 0x8D, 0x85, 0x8A,
	0x8F, 0x8C, 0x85, 0x85, 0x89, 0x8C, 0x8E, 0x8A, 0x8B, 0x8F, 0x93, 0x94,
	0x92, 0x95, 0x97, 0x96, 0x92, 0x88, 0x84, 0x81, 0x6A, 0x61, 0x63, 0x79,
	0x8A, 0x8B, 0x84, 0x84, 0x84, 0x7B, 0x71, 0x71, 0x76, 0x7E, 0x81, 0x7A,
	0x75, 0x79, 0x81, 0x86, 0x82, 0x7F, 0x7F, 0x82, 0x85, 0x81, 0x7E, 0x77,
	0x62, 0x58, 0x60, 0x76, 0x89, 0x87, 0x80, 0x82, 0x82, 0x7A, 0x71, 0x76,
	0x7D, 0x84, 0x88, 0x83, 0x7E, 0x82, 0x84, 0x86, 0x85, 0x85, 0x84, 0x84,
	0x82, 0x7D, 0x7B, 0x77, 0x62, 0x5C, 0x63, 0x78, 0x8B, 0x88, 0x81, 0x7F,
	0x84, 0x7C, 0x73, 0x76, 0x7C, 0x86, 0x8E, 0x8C, 0x87, 0x8B, 0x90, 0x90,
	0x8E, 0x8F, 0x8F, 0x8E, 0x89, 0x81, 0x7D, 0x7C, 0x6B, 0x61, 0x67, 0x7A,
	0x8F, 0x8F, 0x89, 0x83, 0x82, 0x76, 0x71, 0x76, 0x7E, 0x88, 0x8E, 0x8C,
	0x87, 0x8B, 0x91, 0x94, 0x92, 0x92, 0x90, 0x92, 0x90, 0x8B, 0x88, 0x85,
	0x73, 0x65, 0x6D, 0x82, 0x9B, 0x98, 0x8E, 0x84, 0x84, 0x7F, 0x79, 0x7B,
	0x7C, 0x86, 0x8E, 0x8C, 0x85, 0x82, 0x82, 0x83, 0x84, 0x86, 0x89, 0x89,
	0x83, 0x7B, 0x77, 0x72, 0x66, 0x58, 0x5F, 0x6D, 0x82, 0x85, 0x84, 0x7C,
	0x7A, 0x74, 0x73, 0x78, 0x7C, 0x85, 0x8A, 0x88, 0x83, 0x7E, 0x80, 0x83,
	0x85, 0x87, 0x8B, 0x8C, 0x87, 0x81, 0x7B, 0x74, 0x67, 0x5C, 0x60, 0x6F,
	0x84, 0x86, 0x7F, 0x79, 0x75, 0x72, 0x76, 0x7C, 0x80, 0x85, 0x89, 0x86,
	0x83, 0x7F, 0x7F, 0x83, 0x87, 0x8B, 0x8E, 0x8F, 0x8C, 0x88, 0x83, 0x7D,
	0x72, 0x68, 0x6C, 0x75, 0x89, 0x8C, 0x89, 0x81, 0x7A, 0x73, 0x76, 0x7D,
	0x82, 0x8A, 0x8D, 0x8A, 0x83, 0x7E, 0x7E, 0x82, 0x87, 0x8D, 0x92, 0x91,
	0x8D, 0x88, 0x84, 0x81, 0x76, 0x6C, 0x72, 0x7D, 0x93, 0x95, 0x92, 0x88,
	0x83, 0x7F, 0x82, 0x89, 0x8B, 0x92, 0x96, 0x95, 0x8E, 0x87, 0x85, 0x8A,
	0x8D, 0x90, 0x93, 0x91, 0x8A, 0x83, 0x7A, 0x71, 0x67, 0x5E, 0x66, 0x71,
	0x84, 0x86, 0x81, 0x78, 0x6F, 0x6E, 0x70, 0x77, 0x78, 0x7E, 0x81, 0x81,
	0x7D, 0x7C, 0x7C, 0x82, 0x88, 0x8F, 0x93, 0x8D, 0x84, 0x7C, 0x77, 0x75,
	0x6B, 0x62, 0x66, 0x72, 0x86, 0x88, 0x87, 0x79, 0x70, 0x6F, 0x73, 0x79,
	0x7C, 0x84, 0x86, 0x81, 0x7B, 0x79, 0x7D, 0x87, 0x8B, 0x8F, 0x90, 0x8C,
	0x84, 0x7D, 0x76, 0x71, 0x6B, 0x65, 0x6D, 0x77, 0x87, 0x8A, 0x89, 0x7F,
	0x78, 0x7C, 0x81, 0x88, 0x89, 0x8F, 0x8D, 0x8B, 0x88, 0x83, 0x81, 0x85,
	0x8B, 0x92, 0x94, 0x8E, 0x86, 0x80, 0x78, 0x75, 0x6E, 0x66, 0x6D, 0x77,
	0x89, 0x8D, 0x8C, 0x7E, 0x7A, 0x7C, 0x82, 0x89, 0x8C, 0x93, 0x92, 0x91,
	0x8D, 0x89, 0x89, 0x8E, 0x93, 0x99, 0x98, 0x93, 0x8C, 0x87, 0x82, 0x7D,
	0x76, 0x6C, 0x73, 0x7B, 0x8B, 0x8C, 0x88, 0x7A, 0x72, 0x71, 0x77, 0x7E,
	0x83, 0x89, 0x85, 0x83, 0x7E, 0x7C, 0x7D, 0x81, 0x87, 0x89, 0x87, 0x7F,
	0x7A, 0x77, 0x72, 0x72, 0x6A, 0x67, 0x70, 0x79, 0x85, 0x84, 0x81, 0x74,
	0x74, 0x72, 0x79, 0x7B, 0x82, 0x88, 0x86, 0x83, 0x7D, 0x7F, 0x82, 0x85,
	0x8A, 0x8B, 0x87, 0x7F, 0x7B, 0x76, 0x72, 0x74, 0x67, 0x64, 0x6C, 0x7B,
	0x87, 0x87, 0x7F, 0x70, 0x73, 0x72, 0x7E, 0x82, 0x86, 0x89, 0x87, 0x88,
	0x84, 0x87, 0x8A, 0x8F, 0x94, 0x94, 0x90, 0x89, 0x85, 0x7E, 0x79, 0x79,
	0x6E, 0x6D, 0x70, 0x7D, 0x87, 0x89, 0x83, 0x77, 0x75, 0x75, 0x80, 0x83,
	0x88, 0x8C, 0x8A, 0x8A, 0x87, 0x88, 0x8B, 0x8F, 0x95, 0x95, 0x91, 0x8A,
	0x88, 0x85, 0x81, 0x7E, 0x74, 0x74, 0x7A, 0x86, 0x8C, 0x8D, 0x87, 0x7E,
	0x7D, 0x7E, 0x88, 0x8B, 0x8F, 0x8F, 0x8B, 0x88, 0x86, 0x8A, 0x89, 0x89,
	0x88, 0x87, 0x84, 0x7D, 0x7C, 0x78, 0x75, 0x73, 0x66, 0x67, 0x6D, 0x7A,
	0x7B, 0x79, 0x6F, 0x6B, 0x6D, 0x75, 0x80, 0x83, 0x88, 0x87, 0x85, 0x82,
	0x82, 0x85, 0x88, 0x8A, 0x88, 0x86, 0x81, 0x7D, 0x7C, 0x79, 0x78, 0x72,
	0x6E, 0x6D, 0x72, 0x79, 0x7C, 0x7C, 0x74, 0x70, 0x6B, 0x74, 0x7E, 0x85,
	0x88, 0x86, 0x86, 0x83, 0x84, 0x86, 0x86, 0x88, 0x87, 0x87, 0x82, 0x7D,
	0x7E, 0x7C, 0x7C, 0x73, 0x71, 0x74, 0x7D, 0x86, 0x87, 0x84, 0x7B, 0x78,
	0x74, 0x7C, 0x85, 0x8C, 0x8F, 0x89, 0x86, 0x85, 0x8D, 0x92, 0x91, 0x8E,
	0x87, 0x86, 0x84, 0x84, 0x84, 0x7F, 0x7D, 0x71, 0x74, 0x75, 0x7F, 0x84,
	0x86, 0x84, 0x7C, 0x7E, 0x7B, 0x85, 0x8A, 0x91, 0x93, 0x90, 0x8D, 0x89,
	0x8E, 0x95, 0x97, 0x98, 0x90, 0x8C, 0x87, 0x86, 0x88, 0x83, 0x7D, 0x6F,
	0x6D, 0x70, 0x7A, 0x7D, 0x81, 0x79, 0x73, 0x71, 0x73, 0x7E, 0x84, 0x86,
	0x83, 0x7D, 0x79, 0x7A, 0x81, 0x86, 0x85, 0x87, 0x84, 0x84, 0x82, 0x83,
	0x7F, 0x78, 0x6F, 0x69, 0x6D, 0x72, 0x79, 0x76, 0x79, 0x75, 0x74, 0x71,
	0x76, 0x7E, 0x85, 0x88, 0x86, 0x81, 0x7C, 0x7D, 0x84, 0x89, 0x86, 0x86,
	0x7F, 0x7F, 0x7F, 0x83, 0x84, 0x7D, 0x6F, 0x67, 0x6A, 0x75, 0x7A, 0x7C,
	0x7B, 0x76, 0x74, 0x74, 0x7B, 0x84, 0x8D, 0x8F, 0x8D, 0x88, 0x87, 0x89,
	0x90, 0x91, 0x8C, 0x89, 0x85, 0x84, 0x84, 0x85, 0x85, 0x7D, 0x71, 0x71,
	0x75, 0x81, 0x7E, 0x80, 0x7D, 0x7D, 0x7B, 0x7B, 0x80, 0x85, 0x8D, 0x90,
	0x8E, 0x88, 0x86, 0x8C, 0x97, 0x97, 0x91, 0x8C, 0x89, 0x89, 0x8B, 0x8C,
	0x89, 0x7A, 0x73, 0x75, 0x81, 0x8A, 0x89, 0x85, 0x81, 0x7E, 0x7B, 0x7C,
	0x81, 0x86, 0x89, 0x88, 0x84, 0x81, 0x80, 0x86, 0x8D, 0x8A, 0x84, 0x81,
	0x7D, 0x7B, 0x7B, 0x7B, 0x77, 0x69, 0x65, 0x67, 0x77, 0x7D, 0x7D, 0x7B,
	0x7A, 0x7A, 0x77, 0x79, 0x7B, 0x83, 0x87, 0x88, 0x83, 0x7E, 0x7F, 0x86,
	0x8F, 0x8A, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x81, 0x75, 0x69, 0x64, 0x6D,
	0x78, 0x79, 0x77, 0x75, 0x78, 0x79, 0x7A, 0x79, 0x7D, 0x82, 0x83, 0x83,
	0x81, 0x7F, 0x82, 0x89, 0x8E, 0x89, 0x83, 0x83, 0x83, 0x84, 0x86, 0x85,
	0x79, 0x71, 0x70, 0x7B, 0x82, 0x84, 0x7E, 0x7B, 0x7C, 0x7D, 0x81, 0x83,
	0x8B, 0x8D, 0x8B, 0x87, 0x83, 0x84, 0x8A, 0x90, 0x91, 0x89, 0x83, 0x85,
	0x86, 0x86, 0x86, 0x7F, 0x78, 0x73, 0x78, 0x84, 0x87, 0x83, 0x7E, 0x80,
	0x83, 0x86, 0x85, 0x88, 0x8C, 0x8F, 0x8F, 0x8E, 0x8C, 0x8D, 0x90, 0x93,
	0x90, 0x88, 0x84, 0x84, 0x83, 0x81, 0x7A, 0x73, 0x70, 0x6D, 0x74, 0x7C,
	0x7F, 0x79, 0x74, 0x74, 0x76, 0x79, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x82,
	0x85, 0x8A, 0x8C, 0x8C, 0x88, 0x81, 0x80, 0x82, 0x80, 0x7C, 0x73, 0x70,
	0x6F, 0x72, 0x7A, 0x7F, 0x7F, 0x79, 0x78, 0x77, 0x7C, 0x7D, 0x7E, 0x7C,
	0x7C, 0x79, 0x7B, 0x7F, 0x84, 0x88, 0x89, 0x89, 0x85, 0x7E, 0x7D, 0x7C,
	0x7A, 0x73, 0x6B, 0x6F, 0x74, 0x7A, 0x7C, 0x81, 0x7D, 0x7B, 0x7C, 0x81,
	0x85, 0x86, 0x87, 0x86, 0x84, 0x7F, 0x83, 0x89, 0x8E, 0x91, 0x8E, 0x8A,
	0x88, 0x87, 0x87, 0x85, 0x7D, 0x73, 0x72, 0x78, 0x81, 0x82, 0x83, 0x82,
	0x80, 0x7B, 0x7D, 0x83, 0x87, 0x88, 0x88, 0x86, 0x82, 0x82, 0x87, 0x8E,
	0x94, 0x93, 0x90, 0x8B, 0x8A, 0x88, 0x89, 0x87, 0x7D, 0x7A, 0x7F, 0x89,
	0x8A, 0x86, 0x82, 0x81, 0x81, 0x7D, 0x7D, 0x81, 0x84, 0x83, 0x81, 0x79,
	0x76, 0x78, 0x82, 0x8C, 0x8D, 0x85, 0x7E, 0x7B, 0x7B, 0x78, 0x78, 0x6F,
	0x6B, 0x6D, 0x79, 0x85, 0x85, 0x81, 0x78, 0x78, 0x78, 0x7B, 0x7F, 0x85,
	0x85, 0x82, 0x7D, 0x78, 0x78, 0x7D, 0x89, 0x90, 0x8D, 0x87, 0x82, 0x7F,
	0x7B, 0x78, 0x72, 0x6C, 0x6D, 0x73, 0x7D, 0x80, 0x81, 0x7A, 0x78, 0x76,
	0x77, 0x77, 0x7B, 0x82, 0x82, 0x7F, 0x7A, 0x75, 0x75, 0x7F, 0x8A, 0x90,
	0x8C, 0x86, 0x84, 0x83, 0x81, 0x7A, 0x73, 0x72, 0x76, 0x83, 0x8A, 0x89,
	0x83, 0x7E, 0x7B, 0x7F, 0x86, 0x87, 0x8B, 0x8E, 0x8A, 0x84, 0x7E, 0x7D,
	0x82, 0x8A, 0x91, 0x90, 0x8B, 0x86, 0x84, 0x82, 0x7B, 0x74, 0x74, 0x7A,
	0x83, 0x8C, 0x8F, 0x8B, 0x87, 0x82, 0x81, 0x85, 0x8B, 0x90, 0x93, 0x94,
	0x8D, 0x86, 0x83, 0x83, 0x85, 0x89, 0x8E, 0x8D, 0x8A, 0x82, 0x7B, 0x74,
	0x6C, 0x6D, 0x73, 0x7E, 0x84, 0x87, 0x84, 0x80, 0x79, 0x76, 0x74, 0x76,
	0x7B, 0x81, 0x87, 0x87, 0x80, 0x7B, 0x7B, 0x7F, 0x82, 0x84, 0x86, 0x86,
	0x83, 0x7D, 0x73, 0x6C, 0x6B, 0x6F, 0x7A, 0x82, 0x87, 0x86, 0x85, 0x7F,
	0x79, 0x76, 0x75, 0x7B, 0x80, 0x85, 0x84, 0x7F, 0x7A, 0x7A, 0x7E, 0x7E,
	0x7D, 0x7C, 0x7E, 0x7F, 0x7D, 0x72, 0x68, 0x68, 0x6D, 0x78, 0x82, 0x84,
	0x84, 0x86, 0x89, 0x86, 0x7F, 0x7A, 0x7D, 0x85, 0x89, 0x89, 0x87, 0x85,
	0x85, 0x84, 0x81, 0x7F, 0x81, 0x85, 0x87, 0x87, 0x7F, 0x75, 0x71, 0x75,
	0x7D, 0x84, 0x8A, 0x8C, 0x8B, 0x8A, 0x89, 0x84, 0x7F, 0x7F, 0x85, 0x8B,
	0x8C, 0x8C, 0x8B, 0x8C, 0x8C, 0x8A, 0x86, 0x84, 0x84, 0x84, 0x86, 0x82,
	0x7E, 0x79, 0x7C, 0x83, 0x87, 0x8B, 0x8A, 0x8B, 0x8B, 0x8B, 0x89, 0x83,
	0x7D, 0x7B, 0x7E, 0x7F, 0x82, 0x85, 0x89, 0x87, 0x83, 0x7C, 0x76, 0x73,
	0x72, 0x70, 0x6E, 0x6E, 0x70, 0x73, 0x7B, 0x7E, 0x81, 0x83, 0x83, 0x87,
	0x87, 0x89, 0x88, 0x84, 0x7F, 0x7B, 0x7E, 0x7E, 0x82, 0x86, 0x88, 0x85,
	0x81, 0x7C, 0x74, 0x71, 0x6D, 0x6A, 0x6C, 0x71, 0x78, 0x7A, 0x7C, 0x7A,
	0x7B, 0x80, 0x82, 0x84, 0x84, 0x88, 0x87, 0x82, 0x7A, 0x76, 0x7B, 0x81,
	0x84, 0x85, 0x85, 0x85, 0x83, 0x7D, 0x74, 0x6F, 0x6D, 0x70, 0x78, 0x81,
	0x86, 0x84, 0x81, 0x7B, 0x7D, 0x86, 0x8B, 0x91, 0x92, 0x95, 0x91, 0x88,
	0x81, 0x7D, 0x85, 0x8A, 0x8D, 0x8D, 0x8A, 0x84, 0x7D, 0x74, 0x6C, 0x6A,
	0x6F, 0x79, 0x85, 0x8A, 0x8A, 0x85, 0x82, 0x81, 0x86, 0x8E, 0x94, 0x98,
	0x98, 0x97, 0x92, 0x8C, 0x88, 0x87, 0x8C, 0x8E, 0x8F, 0x8C, 0x87, 0x81,
	0x76, 0x6A, 0x63, 0x66, 0x72, 0x7F, 0x87, 0x84, 0x7E, 0x7B, 0x79, 0x79,
	0x7F, 0x86, 0x89, 0x8A, 0x87, 0x87, 0x84, 0x7F, 0x7C, 0x7B, 0x81, 0x85,
	0x85, 0x81, 0x76, 0x6B, 0x67, 0x68, 0x70, 0x75, 0x7A, 0x7B, 0x7C, 0x7E,
	0x7C, 0x7E, 0x7C, 0x7F, 0x85, 0x8A, 0x8D, 0x8B, 0x8A, 0x88, 0x84, 0x7E,
	0x79, 0x78, 0x79, 0x7A, 0x79, 0x75, 0x6F, 0x6A, 0x6B, 0x6E, 0x73, 0x74,
	0x76, 0x79, 0x7C, 0x7E, 0x7E, 0x84, 0x84, 0x86, 0x8A, 0x8E, 0x92, 0x92,
	0x91, 0x90, 0x8A, 0x81, 0x77, 0x74, 0x78, 0x7E, 0x7E, 0x7C, 0x7B, 0x7D,
	0x7F, 0x7E, 0x79, 0x77, 0x7B, 0x85, 0x8B, 0x8D, 0x8A, 0x89, 0x85, 0x85,
	0x8A, 0x91, 0x97, 0x96, 0x93, 0x8D, 0x85, 0x7D, 0x77, 0x74, 0x78, 0x7E,
	0x86, 0x8C, 0x8A, 0x84, 0x7E, 0x7C, 0x7C, 0x7F, 0x88, 0x8E, 0x90, 0x8D,
	0x88, 0x87, 0x83, 0x85, 0x89, 0x8F, 0x93, 0x8F, 0x87, 0x7F, 0x76, 0x6A,
	0x67, 0x6A, 0x77, 0x83, 0x87, 0x7F, 0x73, 0x6A, 0x6B, 0x71, 0x76, 0x7D,
	0x84, 0x88, 0x88, 0x84, 0x81, 0x84, 0x85, 0x8A, 0x8F, 0x92, 0x8F, 0x85,
	0x7A, 0x72, 0x6E, 0x6D, 0x76, 0x7F, 0x85, 0x82, 0x7C, 0x73, 0x6E, 0x6F,
	0x73, 0x74, 0x76, 0x78, 0x7E, 0x83, 0x84, 0x82, 0x82, 0x83, 0x7E, 0x7D,
	0x81, 0x83, 0x7F, 0x77, 0x73, 0x77, 0x7C, 0x7E, 0x7C, 0x7A, 0x7D, 0x81,
	0x84, 0x81, 0x7C, 0x79, 0x7A, 0x7C, 0x7E, 0x83, 0x8B, 0x8E, 0x8D, 0x88,
	0x86, 0x86, 0x84, 0x7E, 0x7E, 0x84, 0x8D, 0x8F, 0x8E, 0x86, 0x7B, 0x75,
	0x75, 0x7B, 0x82, 0x87, 0x84, 0x80, 0x7B, 0x7C, 0x80, 0x84, 0x86, 0x8A,
	0x90, 0x8F, 0x89, 0x82, 0x7D, 0x80, 0x84, 0x8E, 0x99, 0xA1, 0x9C, 0x8D,
	0x80, 0x7A, 0x7E, 0x7F, 0x82, 0x7F, 0x81, 0x82, 0x84, 0x81, 0x7B, 0x7B,
	0x7D, 0x81, 0x7C, 0x7A, 0x79, 0x75, 0x6F, 0x6E, 0x76, 0x80, 0x87, 0x88,
	0x87, 0x87, 0x86, 0x82, 0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x84, 0x88, 0x8A,
	0x89, 0x84, 0x7B, 0x73, 0x72, 0x72, 0x71, 0x73, 0x78, 0x7C, 0x7E, 0x80,
	0x7D, 0x7C, 0x79, 0x7F, 0x84, 0x89, 0x86, 0x7C, 0x76, 0x77, 0x7A, 0x7B,
	0x7E, 0x81, 0x83, 0x80, 0x79, 0x6E, 0x64, 0x63, 0x6B, 0x76, 0x7F, 0x88,
	0x8A, 0x85, 0x7E, 0x7C, 0x81, 0x87, 0x8C, 0x8D, 0x8C, 0x8B, 0x88, 0x82,
	0x81, 0x87, 0x8C, 0x8D, 0x88, 0x83, 0x7D, 0x79, 0x77, 0x74, 0x78, 0x7E,
	0x86, 0x84, 0x7E, 0x7B, 0x80, 0x83, 0x84, 0x85, 0x86, 0x88, 0x8A, 0x8D,
	0x8F, 0x93, 0x93, 0x8F, 0x89, 0x83, 0x81, 0x7E, 0x82, 0x85, 0x8C, 0x90,
	0x8D, 0x82, 0x77, 0x73, 0x79, 0x83, 0x87, 0x89, 0x88, 0x83, 0x7D, 0x7B,
	0x7F, 0x86, 0x8C, 0x8F, 0x8B, 0x82, 0x79, 0x6F, 0x6D, 0x6E, 0x76, 0x7F,
	0x87, 0x86, 0x7D, 0x75, 0x70, 0x73, 0x78, 0x81, 0x87, 0x88, 0x84, 0x84,
	0x84, 0x84, 0x85, 0x86, 0x85, 0x82, 0x7F, 0x7B, 0x7B, 0x7B, 0x7D, 0x7F,
	0x81, 0x7E, 0x79, 0x74, 0x70, 0x71, 0x75, 0x77, 0x78, 0x76, 0x75, 0x78,
	0x7C, 0x7F, 0x7F, 0x81, 0x7F, 0x79, 0x71, 0x6D, 0x6F, 0x77, 0x82, 0x8E,
	0x94, 0x92, 0x87, 0x7C, 0x75, 0x77, 0x7F, 0x85, 0x87, 0x85, 0x82, 0x7E,
	0x7C, 0x7D, 0x81, 0x88, 0x8B, 0x86, 0x7D, 0x76, 0x76, 0x78, 0x7E, 0x87,
	0x90, 0x95, 0x91, 0x8A, 0x82, 0x7F, 0x7C, 0x7E, 0x7E, 0x7F, 0x82, 0x85,
	0x86, 0x87, 0x89, 0x89, 0x89, 0x82, 0x79, 0x73, 0x78, 0x80, 0x8A, 0x94,
	0x98, 0x95, 0x8D, 0x86, 0x84, 0x89, 0x8E, 0x91, 0x8C, 0x85, 0x7B, 0x79,
	0x7A, 0x80, 0x87, 0x8B, 0x88, 0x7E, 0x74, 0x69, 0x68, 0x6A, 0x73, 0x7D,
	0x87, 0x87, 0x80, 0x7A, 0x79, 0x7D, 0x83, 0x87, 0x87, 0x89, 0x88, 0x87,
	0x86, 0x84, 0x82, 0x83, 0x81, 0x7F, 0x77, 0x71, 0x6F, 0x71, 0x7B, 0x82,
	0x85, 0x7E, 0x75, 0x70, 0x74, 0x7A, 0x7D, 0x80, 0x7D, 0x79, 0x78, 0x79,
	0x7F, 0x88, 0x8B, 0x88, 0x80, 0x76, 0x6C, 0x68, 0x6A, 0x74, 0x81, 0x8B,
	0x8B, 0x81, 0x7B, 0x77, 0x79, 0x7B, 0x7F, 0x83, 0x87, 0x86, 0x82, 0x82,
	0x84, 0x85, 0x85, 0x84, 0x84, 0x87, 0x81, 0x7B, 0x78, 0x7A, 0x83, 0x8B,
	0x8E, 0x8A, 0x85, 0x80, 0x7F, 0x7E, 0x82, 0x85, 0x83, 0x7C, 0x79, 0x7E,
	0x8A, 0x92, 0x8F, 0x89, 0x81, 0x7E, 0x79, 0x79, 0x7D, 0x8B, 0x95, 0x99,
	0x96, 0x8D, 0x88, 0x85, 0x85, 0x88, 0x8B, 0x8C, 0x8A, 0x82, 0x7D, 0x7C,
	0x7F, 0x7F, 0x81, 0x82, 0x83, 0x7C, 0x70, 0x6B, 0x6C, 0x78, 0x82, 0x88,
	0x88, 0x86, 0x7F, 0x7B, 0x78, 0x79, 0x81, 0x85, 0x86, 0x84, 0x83, 0x85,
	0x87, 0x87, 0x85, 0x7F, 0x7C, 0x75, 0x72, 0x72, 0x77, 0x7D, 0x81, 0x85,
	0x83, 0x7E, 0x78, 0x77, 0x7A, 0x81, 0x83, 0x82, 0x7B, 0x78, 0x77, 0x7A,
	0x7F, 0x84, 0x86, 0x82, 0x7B, 0x6F, 0x68, 0x65, 0x68, 0x70, 0x7C, 0x88,
	0x88, 0x7F, 0x74, 0x72, 0x76, 0x7C, 0x83, 0x87, 0x89, 0x8A, 0x87, 0x85,
	0x84, 0x88, 0x8C, 0x88, 0x81, 0x7A, 0x79, 0x78, 0x79, 0x7B, 0x80, 0x88,
	0x89, 0x84, 0x7F, 0x81, 0x83, 0x83, 0x81, 0x82, 0x83, 0x83, 0x83, 0x84,
	0x8A, 0x90, 0x93, 0x8D, 0x84, 0x7E, 0x7B, 0x7A, 0x7A, 0x80, 0x8B, 0x92,
	0x90, 0x87, 0x81, 0x82, 0x86, 0x88, 0x8B, 0x8C, 0x8B, 0x86, 0x7F, 0x7C,
	0x82, 0x89, 0x90, 0x8F, 0x88, 0x83, 0x7C, 0x79, 0x74, 0x76, 0x7F, 0x87,
	0x89, 0x85, 0x7F, 0x79, 0x75, 0x72, 0x73, 0x7A, 0x81, 0x81, 0x81, 0x7E,
	0x7E, 0x7F, 0x85, 0x89, 0x88, 0x85, 0x80, 0x7C, 0x76, 0x77, 0x7D, 0x85,
	0x88, 0x86, 0x83, 0x7D, 0x7A, 0x7B, 0x7D, 0x7C, 0x7A, 0x77, 0x76, 0x75,
	0x74, 0x75, 0x7B, 0x85, 0x86, 0x80, 0x77, 0x70, 0x6C, 0x6E, 0x72, 0x7A,
	0x80, 0x85, 0x84, 0x7E, 0x79, 0x7A, 0x7F, 0x82, 0x83, 0x82, 0x83, 0x7E,
	0x7A, 0x77, 0x7B, 0x83, 0x88, 0x86, 0x81, 0x7D, 0x79, 0x75, 0x75, 0x7A,
	0x83, 0x8B, 0x8D, 0x89, 0x84, 0x86, 0x88, 0x8C, 0x8A, 0x88, 0x88, 0x84,
	0x80, 0x7F, 0x83, 0x87, 0x86, 0x84, 0x7F, 0x7D, 0x7F, 0x7D, 0x7A, 0x7B,
	0x7D, 0x83, 0x86, 0x88, 0x89, 0x8B, 0x8D, 0x8E, 0x8F, 0x90, 0x8E, 0x8A,
	0x85, 0x86, 0x8A, 0x8C, 0x89, 0x87, 0x85, 0x80, 0x7B, 0x78, 0x75, 0x74,
	0x76, 0x77, 0x7A, 0x7C, 0x7B, 0x78, 0x76, 0x77, 0x7B, 0x80, 0x83, 0x83,
	0x83, 0x87, 0x8B, 0x8E, 0x8B, 0x88, 0x88, 0x88, 0x86, 0x83, 0x7E, 0x79,
	0x75, 0x73, 0x72, 0x75, 0x7B, 0x7E, 0x7E, 0x7A, 0x76, 0x75, 0x77, 0x79,
	0x79, 0x7B, 0x82, 0x85, 0x8A, 0x87, 0x83, 0x7F, 0x7F, 0x81, 0x7E, 0x78,
	0x73, 0x73, 0x72, 0x6F, 0x6D, 0x70, 0x75, 0x7A, 0x7B, 0x79, 0x78, 0x79,
	0x79, 0x7B, 0x7F, 0x85, 0x8C, 0x8E, 0x8D, 0x88, 0x88, 0x8A, 0x8A, 0x88,
	0x85, 0x86, 0x88, 0x85, 0x7F, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7C, 0x7B, 0x7C, 0x7F, 0x83, 0x87, 0x86, 0x88, 0x89, 0x8C, 0x8E, 0x8C,
	0x8A, 0x89, 0x88, 0x87, 0x87, 0x88, 0x89, 0x86, 0x82, 0x80, 0x81, 0x82,
	0x82, 0x7D, 0x7E, 0x81, 0x85, 0x86, 0x83, 0x81, 0x82, 0x87, 0x89, 0x87,
	0x85, 0x87, 0x8A, 0x89, 0x86, 0x81, 0x7F, 0x7D, 0x7A, 0x74, 0x70, 0x6F,
	0x74, 0x79, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x82, 0x85, 0x85,
	0x84, 0x82, 0x82, 0x83, 0x88, 0x8C, 0x8D, 0x8A, 0x83, 0x7D, 0x78, 0x75,
	0x74, 0x74, 0x75, 0x77, 0x79, 0x7B, 0x77, 0x75, 0x75, 0x78, 0x7D, 0x7D,
	0x7A, 0x78, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x82, 0x84, 0x83, 0x7F, 0x7C,
	0x7B, 0x7C, 0x79, 0x78, 0x79, 0x7E, 0x81, 0x7E, 0x7B, 0x79, 0x78, 0x7A,
	0x7C, 0x7E, 0x83, 0x86, 0x8A, 0x8C, 0x8C, 0x8A, 0x88, 0x87, 0x87, 0x8A,
	0x8C, 0x8C, 0x87, 0x83, 0x80, 0x7E, 0x7C, 0x7B, 0x7C, 0x80, 0x81, 0x7D,
	0x7A, 0x79, 0x7B, 0x82, 0x85, 0x87, 0x89, 0x8B, 0x8D, 0x8C, 0x8B, 0x8A,
	0x8A, 0x8D, 0x8D, 0x8C, 0x8C, 0x8C, 0x8C, 0x86, 0x7E, 0x79, 0x7A, 0x7C,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7B,
	0x7D, 0x7E, 0x7E, 0x7E, 0x82, 0x88, 0x8D, 0x8B, 0x85, 0x82, 0x7F, 0x7C,
	0x77, 0x75, 0x77, 0x7C, 0x80, 0x81, 0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x7F, 0x7D, 0x7C, 0x7D, 0x7F, 0x81, 0x7F, 0x7D, 0x7F, 0x81, 0x7F,
	0x7B, 0x77, 0x73, 0x71, 0x70, 0x72, 0x76, 0x79, 0x79, 0x78, 0x76, 0x75,
	0x78, 0x7B, 0x7E, 0x7F, 0x82, 0x84, 0x87, 0x86, 0x83, 0x80, 0x7F, 0x80,
	0x7F, 0x82, 0x82, 0x82, 0x81, 0x82, 0x82, 0x80, 0x80, 0x81, 0x82, 0x84,
	0x85, 0x86, 0x83, 0x81, 0x81, 0x84, 0x89, 0x89, 0x88, 0x84, 0x82, 0x82,
	0x83, 0x83, 0x83, 0x83, 0x84, 0x86, 0x86, 0x83, 0x81, 0x7F, 0x7F, 0x81,
	0x85, 0x89, 0x8B, 0x8A, 0x87, 0x87, 0x89, 0x8C, 0x8A, 0x88, 0x84, 0x82,
	0x83, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84, 0x83, 0x81, 0x7E, 0x78, 0x72,
	0x71, 0x74, 0x77, 0x77, 0x79, 0x7E, 0x86, 0x8B, 0x86, 0x83, 0x81, 0x82,
	0x80, 0x7F, 0x7F, 0x82, 0x88, 0x88, 0x86, 0x84, 0x85, 0x82, 0x7C, 0x78,
	0x78, 0x78, 0x76, 0x73, 0x75, 0x7A, 0x81, 0x82, 0x7F, 0x7C, 0x7D, 0x7E,
	0x7D, 0x7A, 0x7B, 0x7B, 0x7A, 0x7A, 0x79, 0x7D, 0x83, 0x83, 0x7C, 0x77,
	0x75, 0x73, 0x70, 0x6F, 0x72, 0x77, 0x7D, 0x7F, 0x81, 0x83, 0x83, 0x82,
	0x7E, 0x7C, 0x7E, 0x81, 0x83, 0x84, 0x86, 0x88, 0x8A, 0x8A, 0x88, 0x89,
	0x8B, 0x8A, 0x84, 0x7E, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7F, 0x81, 0x84,
	0x86, 0x85, 0x82, 0x7F, 0x7F, 0x83, 0x88, 0x8B, 0x8A, 0x87, 0x86, 0x85,
	0x85, 0x87, 0x8A, 0x8D, 0x8F, 0x8C, 0x86, 0x80, 0x7C, 0x7A, 0x7A, 0x7F,
	0x84, 0x87, 0x86, 0x86, 0x85, 0x85, 0x84, 0x85, 0x86, 0x89, 0x86, 0x83,
	0x7D, 0x7B, 0x7C, 0x7C, 0x7E, 0x7F, 0x84, 0x84, 0x82, 0x7C, 0x76, 0x74,
	0x75, 0x77, 0x7B, 0x81, 0x87, 0x88, 0x86, 0x85, 0x84, 0x83, 0x81, 0x7E,
	0x7D, 0x80, 0x81, 0x82, 0x81, 0x82, 0x84, 0x83, 0x7E, 0x78, 0x76, 0x75,
	0x73, 0x70, 0x70, 0x73, 0x78, 0x7B, 0x7B, 0x7C, 0x7F, 0x7C, 0x79, 0x77,
	0x78, 0x79, 0x78, 0x78, 0x7B, 0x83, 0x87, 0x87, 0x83, 0x81, 0x7F, 0x7C,
	0x76, 0x72, 0x74, 0x7A, 0x7D, 0x7E, 0x7F, 0x83, 0x86, 0x86, 0x83, 0x81,
	0x83, 0x85, 0x85, 0x86, 0x88, 0x8B, 0x8D, 0x8B, 0x89, 0x8A, 0x8A, 0x85,
	0x7D, 0x76, 0x76, 0x78, 0x7B, 0x7C, 0x81, 0x87, 0x8B, 0x87, 0x81, 0x7C,
	0x7B, 0x7D, 0x7E, 0x85, 0x8D, 0x94, 0x93, 0x8F, 0x8C, 0x8C, 0x8D, 0x8B,
	0x87, 0x85, 0x83, 0x7E, 0x7A, 0x7A, 0x80, 0x87, 0x8A, 0x86, 0x82, 0x82,
	0x80, 0x7A, 0x74, 0x74, 0x78, 0x7E, 0x81, 0x80, 0x81, 0x84, 0x86, 0x84,
	0x82, 0x7F, 0x7E, 0x7C, 0x7B, 0x7D, 0x83, 0x86, 0x86, 0x84, 0x83, 0x82,
	0x80, 0x79, 0x77, 0x7C, 0x84, 0x85, 0x7F, 0x7B, 0x7B, 0x7F, 0x82, 0x7F,
	0x7C, 0x7C, 0x7A, 0x77, 0x75, 0x77, 0x7D, 0x81, 0x81, 0x7E, 0x7C, 0x7A,
	0x76, 0x71, 0x70, 0x75, 0x7D, 0x7F, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7A,
	0x7B, 0x7C, 0x7C, 0x78, 0x75, 0x78, 0x7B, 0x7F, 0x82, 0x86, 0x89, 0x8B,
	0x88, 0x83, 0x81, 0x83, 0x88, 0x8C, 0x8C, 0x8B, 0x88, 0x86, 0x84, 0x84,
	0x84, 0x80, 0x7B, 0x76, 0x75, 0x79, 0x7F, 0x83, 0x83, 0x85, 0x86, 0x87,
	0x84, 0x81, 0x80, 0x83, 0x8A, 0x8E, 0x8F, 0x8E, 0x8A, 0x89, 0x87, 0x88,
	0x89, 0x88, 0x83, 0x7D, 0x79, 0x78, 0x7C, 0x80, 0x84, 0x87, 0x89, 0x88,
	0x84, 0x80, 0x7E, 0x81, 0x85, 0x87, 0x87, 0x83, 0x7F, 0x7D, 0x7D, 0x7F,
	0x82, 0x83, 0x7E, 0x78, 0x75, 0x77, 0x7D, 0x82, 0x83, 0x81, 0x81, 0x82,
	0x7E, 0x7B, 0x79, 0x7C, 0x83, 0x86, 0x86, 0x84, 0x80, 0x7F, 0x80, 0x82,
	0x84, 0x82, 0x78, 0x6F, 0x6C, 0x72, 0x7B, 0x81, 0x83, 0x81, 0x81, 0x7E,
	0x76, 0x6E, 0x6D, 0x73, 0x7A, 0x7D, 0x7C, 0x79, 0x78, 0x79, 0x7C, 0x82,
	0x85, 0x83, 0x7A, 0x72, 0x71, 0x78, 0x7F, 0x82, 0x83, 0x84, 0x88, 0x87,
	0x83, 0x7F, 0x80, 0x84, 0x86, 0x84, 0x81, 0x80, 0x82, 0x84, 0x87, 0x8C,
	0x8C, 0x85, 0x7B, 0x74, 0x76, 0x7F, 0x87, 0x8A, 0x8B, 0x8D, 0x8C, 0x87,
	0x81, 0x7E, 0x83, 0x89, 0x87, 0x83, 0x7D, 0x7C, 0x7C, 0x7F, 0x85, 0x8A,
	0x8A, 0x85, 0x7C, 0x79, 0x7D, 0x85, 0x89, 0x8B, 0x8E, 0x91, 0x91, 0x8B,
	0x86, 0x85, 0x89, 0x8A, 0x87, 0x82, 0x7D, 0x7A, 0x77, 0x76, 0x77, 0x78,
	0x76, 0x72, 0x70, 0x75, 0x7F, 0x85, 0x86, 0x87, 0x88, 0x8B, 0x89, 0x85,
	0x83, 0x87, 0x8C, 0x8B, 0x87, 0x81, 0x7D, 0x7A, 0x7A, 0x7A, 0x7C, 0x7A,
	0x74, 0x6D, 0x6C, 0x72, 0x7A, 0x7E, 0x7F, 0x81, 0x86, 0x89, 0x85, 0x7F,
	0x7B, 0x7F, 0x82, 0x81, 0x7E, 0x7E, 0x7E, 0x7D, 0x79, 0x76, 0x73, 0x6F,
	0x6C, 0x6C, 0x71, 0x7A, 0x81, 0x80, 0x7E, 0x7C, 0x7E, 0x7E, 0x7D, 0x7B,
	0x80, 0x86, 0x89, 0x86, 0x84, 0x85, 0x87, 0x8A, 0x8A, 0x89, 0x85, 0x7E,
	0x78, 0x76, 0x7B, 0x83, 0x87, 0x88, 0x87, 0x88, 0x88, 0x84, 0x7D, 0x7B,
	0x7D, 0x84, 0x86, 0x83, 0x84, 0x84, 0x87, 0x84, 0x81, 0x7F, 0x7F, 0x7F,
	0x81, 0x84, 0x89, 0x8D, 0x8C, 0x89, 0x88, 0x8A, 0x8B, 0x89, 0x83, 0x82,
	0x82, 0x86, 0x82, 0x7E, 0x7D, 0x82, 0x86, 0x87, 0x82, 0x7B, 0x76, 0x70,
	0x71, 0x77, 0x82, 0x8A, 0x8E, 0x8C, 0x8B, 0x8B, 0x89, 0x82, 0x7D, 0x7D,
	0x81, 0x85, 0x82, 0x7E, 0x7B, 0x7B, 0x7B, 0x79, 0x75, 0x73, 0x74, 0x76,
	0x78, 0x7C, 0x83, 0x84, 0x85, 0x84, 0x85, 0x86, 0x87, 0x83, 0x81, 0x7F,
	0x7F, 0x7E, 0x7B, 0x79, 0x77, 0x79, 0x79, 0x75, 0x6E, 0x6A, 0x68, 0x69,
	0x6E, 0x76, 0x80, 0x88, 0x88, 0x87, 0x85, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x84, 0x85, 0x83, 0x82, 0x80, 0x81, 0x82, 0x7D, 0x77, 0x74, 0x76, 0x7B,
	0x81, 0x86, 0x88, 0x8A, 0x8B, 0x8B, 0x8B, 0x8A, 0x88, 0x84, 0x82, 0x81,
	0x83, 0x86, 0x86, 0x86, 0x88, 0x8A, 0x89, 0x7F, 0x73, 0x6D, 0x6F, 0x75,
	0x7F, 0x87, 0x8E, 0x91, 0x8F, 0x8A, 0x86, 0x84, 0x85, 0x85, 0x85, 0x85,
	0x86, 0x87, 0x85, 0x83, 0x85, 0x89, 0x8A, 0x84, 0x7C, 0x78, 0x76, 0x76,
	0x78, 0x7C, 0x7F, 0x83, 0x85, 0x85, 0x85, 0x86, 0x85, 0x81, 0x7C, 0x7B,
	0x7E, 0x83, 0x84, 0x84, 0x85, 0x86, 0x84, 0x7B, 0x74, 0x72, 0x75, 0x7A,
	0x7F, 0x85, 0x88, 0x88, 0x84, 0x81, 0x7F, 0x7F, 0x82, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7A, 0x7A, 0x7C, 0x7F, 0x7E, 0x78, 0x72, 0x6E, 0x6E, 0x6D,
	0x72, 0x78, 0x80, 0x83, 0x84, 0x83, 0x82, 0x7E, 0x7D, 0x7B, 0x78, 0x79,
	0x7E, 0x81, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7A, 0x7B, 0x7C, 0x7D, 0x7D,
	0x7F, 0x84, 0x88, 0x8A, 0x8B, 0x8D, 0x8D, 0x8C, 0x8B, 0x88, 0x84, 0x82,
	0x82, 0x84, 0x82, 0x82, 0x84, 0x84, 0x84, 0x81, 0x7D, 0x78, 0x75, 0x74,
	0x77, 0x7E, 0x84, 0x8A, 0x8B, 0x8A, 0x88, 0x87, 0x88, 0x89, 0x89, 0x8A,
	0x8B, 0x8D, 0x8A, 0x85, 0x83, 0x83, 0x84, 0x86, 0x87, 0x85, 0x84, 0x7F,
	0x7B, 0x78, 0x77, 0x7A, 0x7E, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x85, 0x89, 0x8A, 0x88, 0x85, 0x83, 0x81, 0x7E, 0x7D, 0x7C, 0x7B, 0x7D,
	0x7E, 0x7C, 0x7A, 0x79, 0x78, 0x77, 0x78, 0x79, 0x7D, 0x80, 0x7F, 0x7F,
	0x7F, 0x82, 0x85, 0x84, 0x83, 0x81, 0x81, 0x7F, 0x7C, 0x78, 0x76, 0x78,
	0x7B, 0x7A, 0x76, 0x75, 0x74, 0x73, 0x73, 0x74, 0x76, 0x78, 0x79, 0x7A,
	0x7D, 0x82, 0x84, 0x83, 0x7F, 0x7D, 0x7E, 0x7F, 0x7F, 0x7D, 0x7F, 0x85,
	0x8A, 0x8D, 0x8A, 0x87, 0x84, 0x7F, 0x7C, 0x7B, 0x7D, 0x7F, 0x81, 0x82,
	0x82, 0x84, 0x86, 0x85, 0x85, 0x85, 0x86, 0x86, 0x83, 0x7F, 0x7D, 0x7E,
	0x82, 0x86, 0x89, 0x8C, 0x8D, 0x89, 0x82, 0x7C, 0x79, 0x78, 0x7A, 0x7D,
	0x82, 0x88, 0x8C, 0x8C, 0x88, 0x84, 0x83, 0x84, 0x86, 0x86, 0x85, 0x86,
	0x85, 0x85, 0x85, 0x86, 0x89, 0x89, 0x86, 0x81, 0x7C, 0x78, 0x76, 0x76,
	0x78, 0x7C, 0x82, 0x86, 0x88, 0x88, 0x86, 0x83, 0x7F, 0x7B, 0x7A, 0x7C,
	0x81, 0x85, 0x85, 0x83, 0x81, 0x81, 0x83, 0x83, 0x82, 0x80, 0x7E, 0x7B,
	0x78, 0x74, 0x74, 0x77, 0x7B, 0x7E, 0x82, 0x84, 0x83, 0x7E, 0x77, 0x74,
	0x76, 0x7A, 0x7C, 0x7D, 0x7D, 0x7C, 0x7A, 0x78, 0x78, 0x7B, 0x7F, 0x81,
	0x7D, 0x79, 0x76, 0x77, 0x76, 0x74, 0x73, 0x77, 0x7B, 0x7E, 0x7F, 0x80,
	0x84, 0x87, 0x88, 0x87, 0x86, 0x86, 0x86, 0x85, 0x85, 0x86, 0x89, 0x89,
	0x88, 0x86, 0x85, 0x85, 0x84, 0x7F, 0x7B, 0x7B, 0x7C, 0x7A, 0x79, 0x7B,
	0x83, 0x89, 0x8A, 0x88, 0x85, 0x85, 0x86, 0x85, 0x85, 0x85, 0x86, 0x86,
	0x85, 0x85, 0x88, 0x8B, 0x8C, 0x88, 0x82, 0x7E, 0x7E, 0x7C, 0x79, 0x7A,
	0x7E, 0x84, 0x88, 0x89, 0x88, 0x88, 0x85, 0x83, 0x81, 0x81, 0x81, 0x81,
	0x7F, 0x7F, 0x82, 0x86, 0x8B, 0x8B, 0x87, 0x82, 0x7E, 0x7B, 0x77, 0x74,
	0x76, 0x79, 0x7B, 0x7D, 0x7E, 0x7E, 0x81, 0x83, 0x85, 0x85, 0x83, 0x81,
	0x7E, 0x7C, 0x7B, 0x7D, 0x83, 0x86, 0x85, 0x82, 0x80, 0x7F, 0x7C, 0x77,
	0x73, 0x72, 0x72, 0x74, 0x75, 0x75, 0x76, 0x7B, 0x7C, 0x7C, 0x7D, 0x7F,
	0x7F, 0x7B, 0x78, 0x7A, 0x81, 0x85, 0x83, 0x7E, 0x7B, 0x7B, 0x7A, 0x79,
	0x7A, 0x7E, 0x82, 0x81, 0x7D, 0x7A, 0x7C, 0x82, 0x85, 0x85, 0x85, 0x87,
	0x88, 0x84, 0x81, 0x83, 0x89, 0x8D, 0x8A, 0x86, 0x84, 0x83, 0x81, 0x7D,
	0x7C, 0x7E, 0x83, 0x84, 0x82, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x81,
	0x82, 0x80, 0x7E, 0x84, 0x8A, 0x8E, 0x8E, 0x8A, 0x87, 0x85, 0x83, 0x81,
	0x82, 0x84, 0x86, 0x86, 0x85, 0x84, 0x87, 0x89, 0x88, 0x83, 0x7C, 0x78,
	0x76, 0x74, 0x77, 0x7E, 0x86, 0x8B, 0x8D, 0x8C, 0x88, 0x83, 0x80, 0x7E,
	0x7E, 0x7F, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x83, 0x86, 0x87, 0x86, 0x81,
	0x7C, 0x77, 0x73, 0x74, 0x76, 0x7C, 0x82, 0x84, 0x84, 0x82, 0x82, 0x82,
	0x7E, 0x7A, 0x77, 0x79, 0x7B, 0x7B, 0x7B, 0x7D, 0x7F, 0x7E, 0x7C, 0x7A,
	0x7B, 0x7B, 0x79, 0x76, 0x74, 0x75, 0x77, 0x77, 0x76, 0x76, 0x79, 0x7E,
	0x7E, 0x7D, 0x7E, 0x81, 0x81, 0x7F, 0x80, 0x85, 0x8C, 0x8D, 0x8A, 0x86,
	0x85, 0x86, 0x86, 0x86, 0x85, 0x86, 0x85, 0x7F, 0x79, 0x76, 0x78, 0x7B,
	0x7B, 0x7B, 0x7F, 0x87, 0x8A, 0x87, 0x84, 0x83, 0x83, 0x83, 0x83, 0x86,
	0x88, 0x89, 0x84, 0x81, 0x82, 0x86, 0x8A, 0x88, 0x83, 0x7E, 0x7C, 0x7A,
	0x76, 0x75, 0x7A, 0x83, 0x89, 0x8B, 0x8D, 0x90, 0x90, 0x8A, 0x83, 0x7E,
	0x7E, 0x81, 0x83, 0x83, 0x85, 0x87, 0x89, 0x87, 0x85, 0x83, 0x83, 0x80,
	0x78, 0x71, 0x70, 0x73, 0x77, 0x7B, 0x7F, 0x85, 0x88, 0x87, 0x86, 0x85,
	0x84, 0x81, 0x7E, 0x7C, 0x7E, 0x83, 0x87, 0x86, 0x82, 0x7E, 0x7F, 0x81,
	0x7F, 0x7A, 0x76, 0x73, 0x71, 0x71, 0x73, 0x77, 0x7B, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7F, 0x7E, 0x7C, 0x7C, 0x7F, 0x80, 0x7F, 0x7D, 0x7D, 0x7D,
	0x7B, 0x78, 0x77, 0x78, 0x78, 0x78, 0x78, 0x7A, 0x7D, 0x7F, 0x80, 0x81,
	0x81, 0x83, 0x86, 0x88, 0x89, 0x8A, 0x8C, 0x8C, 0x87, 0x84, 0x84, 0x85,
	0x85, 0x82, 0x80, 0x82, 0x84, 0x84, 0x81, 0x7E, 0x7B, 0x7A, 0x79, 0x78,
	0x78, 0x7D, 0x81, 0x7F, 0x7D, 0x7E, 0x85, 0x8B, 0x8C, 0x8B, 0x8D, 0x90,
	0x8F, 0x8A, 0x87, 0x87, 0x8C, 0x90, 0x8C, 0x8B, 0x8F, 0x8B, 0x7C, 0x74,
	0x79, 0x80, 0x78, 0x6E, 0x77, 0x84, 0x82, 0x79, 0x7F, 0x8A, 0x86, 0x7B,
	0x7C, 0x83, 0x7F, 0x73, 0x75, 0x84, 0x87, 0x7D, 0x7C, 0x87, 0x89, 0x7B,
	0x72, 0x7C, 0x85, 0x7F, 0x79, 0x82, 0x90, 0x8C, 0x82, 0x83, 0x8C, 0x8F,
	0x8A, 0x86, 0x8C, 0x90, 0x89, 0x82, 0x84, 0x84, 0x7E, 0x78, 0x76, 0x74,
	0x6D, 0x66, 0x64, 0x67, 0x65, 0x69, 0x6F, 0x72, 0x6F, 0x6C, 0x71, 0x74,
	0x70, 0x6C, 0x70, 0x78, 0x7D, 0x7F, 0x84, 0x8D, 0x90, 0x8D, 0x88, 0x8A,
	0x89, 0x83, 0x7E, 0x80, 0x88, 0x8E, 0x91, 0x92, 0x90, 0x8C, 0x87, 0x85,
	0x87, 0x83, 0x81, 0x82, 0x80, 0x81, 0x82, 0x84, 0x86, 0x82, 0x84, 0x81,
	0x7C, 0x79, 0x73, 0x70, 0x72, 0x78, 0x7C, 0x7D, 0x81, 0x84, 0x84, 0x84,
	0x81, 0x83, 0x86, 0x86, 0x87, 0x88, 0x8B, 0x8F, 0x93, 0x95, 0x95, 0x94,
	0x91, 0x8D, 0x86, 0x82, 0x7E, 0x81, 0x85, 0x86, 0x89, 0x8B, 0x89, 0x85,
	0x82, 0x7F, 0x7B, 0x79, 0x77, 0x75, 0x75, 0x77, 0x7A, 0x79, 0x79, 0x79,
	0x78, 0x78, 0x71, 0x71, 0x77, 0x7C, 0x81, 0x83, 0x83, 0x86, 0x87, 0x82,
	0x81, 0x83, 0x83, 0x86, 0x86, 0x86, 0x84, 0x81, 0x81, 0x81, 0x82, 0x83,
	0x7F, 0x7C, 0x78, 0x73, 0x70, 0x77, 0x7A, 0x7D, 0x7F, 0x83, 0x85, 0x7F,
	0x79, 0x77, 0x78, 0x78, 0x78, 0x79, 0x7B, 0x7A, 0x79, 0x7A, 0x79, 0x7C,
	0x81, 0x7F, 0x7E, 0x7B, 0x7D, 0x82, 0x82, 0x84, 0x87, 0x87, 0x89, 0x86,
	0x85, 0x86, 0x8A, 0x8B, 0x87, 0x86, 0x86, 0x83, 0x82, 0x7D, 0x7C, 0x7F,
	0x7E, 0x79, 0x75, 0x72, 0x75, 0x78, 0x7A, 0x7D, 0x81, 0x85, 0x81, 0x7B,
	0x77, 0x7C, 0x85, 0x87, 0x87, 0x88, 0x8C, 0x8A, 0x85, 0x82, 0x86, 0x8A,
	0x8C, 0x87, 0x86, 0x88, 0x8A, 0x87, 0x84, 0x85, 0x89, 0x8B, 0x89, 0x86,
	0x87, 0x8A, 0x8C, 0x8A, 0x88, 0x87, 0x86, 0x83, 0x7F, 0x7D, 0x7F, 0x83,
	0x7C, 0x77, 0x78, 0x7B, 0x7C, 0x7B, 0x7C, 0x80, 0x84, 0x82, 0x7A, 0x77,
	0x78, 0x7B, 0x7B, 0x7A, 0x7C, 0x7F, 0x7E, 0x7A, 0x75, 0x74, 0x78, 0x78,
	0x77, 0x76, 0x78, 0x7B, 0x77, 0x72, 0x74, 0x7D, 0x85, 0x82, 0x7D, 0x82,
	0x85, 0x82, 0x80, 0x7F, 0x81, 0x81, 0x7D, 0x7A, 0x7A, 0x7E, 0x7F, 0x7E,
	0x7D, 0x7F, 0x82, 0x80, 0x7D, 0x7E, 0x83, 0x85, 0x86, 0x86, 0x84, 0x88,
	0x87, 0x86, 0x83, 0x80, 0x82, 0x82, 0x7C, 0x78, 0x7B, 0x80, 0x81, 0x81,
	0x82, 0x83, 0x7E, 0x7A, 0x79, 0x7D, 0x84, 0x87, 0x85, 0x85, 0x89, 0x8C,
	0x8B, 0x89, 0x87, 0x87, 0x87, 0x83, 0x7F, 0x7A, 0x7A, 0x7C, 0x7A, 0x79,
	0x7C, 0x81, 0x7F, 0x7D, 0x7E, 0x81, 0x81, 0x7D, 0x7B, 0x81, 0x86, 0x88,
	0x8B, 0x8F, 0x91, 0x90, 0x8D, 0x86, 0x83, 0x84, 0x86, 0x86, 0x84, 0x85,
	0x87, 0x83, 0x7D, 0x7D, 0x81, 0x86, 0x88, 0x87, 0x86, 0x86, 0x84, 0x7F,
	0x7E, 0x81, 0x82, 0x7F, 0x7B, 0x79, 0x78, 0x78, 0x76, 0x73, 0x73, 0x74,
	0x74, 0x73, 0x72, 0x74, 0x7A, 0x7C, 0x79, 0x77, 0x7E, 0x84, 0x86, 0x85,
	0x84, 0x85, 0x80, 0x7C, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7B, 0x77, 0x77, 0x7B, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x7F, 0x7E,
	0x82, 0x84, 0x84, 0x81, 0x7B, 0x79, 0x78, 0x79, 0x7A, 0x7F, 0x85, 0x87,
	0x86, 0x84, 0x84, 0x85, 0x83, 0x81, 0x81, 0x86, 0x8E, 0x8E, 0x8A, 0x89,
	0x89, 0x86, 0x83, 0x83, 0x84, 0x85, 0x85, 0x82, 0x7E, 0x7C, 0x7C, 0x7D,
	0x7F, 0x84, 0x87, 0x89, 0x88, 0x84, 0x84, 0x86, 0x85, 0x82, 0x7F, 0x82,
	0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x7E, 0x7E, 0x7E, 0x82, 0x84, 0x81,
	0x81, 0x82, 0x81, 0x81, 0x84, 0x87, 0x8B, 0x90, 0x92, 0x8D, 0x86, 0x80,
	0x7C, 0x76, 0x74, 0x76, 0x7B, 0x7A, 0x73, 0x6F, 0x71, 0x74, 0x74, 0x76,
	0x78, 0x7A, 0x7B, 0x78, 0x76, 0x79, 0x7E, 0x84, 0x87, 0x89, 0x89, 0x86,
	0x80, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B, 0x7A, 0x79, 0x7D, 0x80, 0x7E, 0x7D,
	0x80, 0x82, 0x81, 0x7C, 0x7D, 0x83, 0x87, 0x88, 0x84, 0x81, 0x7F, 0x7D,
	0x7F, 0x7F, 0x7F, 0x81, 0x7E, 0x79, 0x75, 0x75, 0x77, 0x78, 0x7A, 0x7F,
	0x87, 0x88, 0x85, 0x81, 0x81, 0x83, 0x86, 0x87, 0x86, 0x88, 0x88, 0x84,
	0x80, 0x80, 0x82, 0x85, 0x87, 0x84, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x7E,
	0x7F, 0x81, 0x82, 0x84, 0x89, 0x8C, 0x8B, 0x87, 0x83, 0x81, 0x7F, 0x7F,
	0x7F, 0x82, 0x85, 0x87, 0x84, 0x81, 0x7D, 0x80, 0x85, 0x87, 0x89, 0x88,
	0x86, 0x87, 0x85, 0x84, 0x85, 0x8A, 0x8D, 0x8C, 0x8A, 0x88, 0x86, 0x81,
	0x7B, 0x79, 0x7B, 0x7D, 0x7B, 0x78, 0x75, 0x74, 0x70, 0x6E, 0x70, 0x76,
	0x7B, 0x7C, 0x7A, 0x79, 0x7B, 0x7B, 0x7A, 0x79, 0x79, 0x79, 0x7B, 0x7D,
	0x7F, 0x7D, 0x7E, 0x7E, 0x7B, 0x77, 0x78, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7E, 0x7D, 0x7C, 0x81, 0x88, 0x8C, 0x8C, 0x88, 0x84, 0x81, 0x7F, 0x7C,
	0x7A, 0x7D, 0x83, 0x85, 0x84, 0x81, 0x7D, 0x78, 0x74, 0x74, 0x79, 0x7F,
	0x82, 0x82, 0x7E, 0x7F, 0x82, 0x85, 0x87, 0x89, 0x89, 0x87, 0x85, 0x83,
	0x80, 0x81, 0x83, 0x83, 0x82, 0x81, 0x85, 0x88, 0x86, 0x82, 0x80, 0x80,
	0x81, 0x7D, 0x7D, 0x80, 0x85, 0x88, 0x88, 0x87, 0x85, 0x82, 0x7F, 0x7F,
	0x81, 0x84, 0x85, 0x81, 0x7D, 0x7C, 0x7E, 0x7F, 0x81, 0x83, 0x88, 0x8D,
	0x8D, 0x86, 0x7F, 0x80, 0x85, 0x89, 0x8B, 0x8C, 0x8D, 0x8C, 0x86, 0x81,
	0x7F, 0x83, 0x86, 0x86, 0x85, 0x84, 0x82, 0x7A, 0x73, 0x72, 0x74, 0x78,
	0x77, 0x78, 0x7C, 0x7F, 0x80, 0x7D, 0x79, 0x77, 0x7A, 0x7B, 0x7C, 0x7A,
	0x7B, 0x7D, 0x7D, 0x7B, 0x7A, 0x7D, 0x81, 0x7F, 0x7C, 0x7B, 0x7C, 0x7C,
	0x7A, 0x77, 0x79, 0x7F, 0x82, 0x84, 0x84, 0x87, 0x89, 0x85, 0x7D, 0x7A,
	0x7C, 0x7E, 0x7E, 0x7D, 0x7F, 0x83, 0x83, 0x7D, 0x77, 0x75, 0x78, 0x7B,
	0x7A, 0x7A, 0x7C, 0x81, 0x83, 0x84, 0x86, 0x89, 0x8C, 0x8D, 0x89, 0x85,
	0x82, 0x81, 0x7D, 0x7B, 0x80, 0x88, 0x8C, 0x87, 0x82, 0x7E, 0x7C, 0x79,
	0x78, 0x78, 0x7D, 0x83, 0x86, 0x85, 0x86, 0x88, 0x8B, 0x89, 0x88, 0x87,
	0x86, 0x86, 0x84, 0x82, 0x7F, 0x81, 0x83, 0x82, 0x81, 0x82, 0x84, 0x81,
	0x7C, 0x7C, 0x7D, 0x7F, 0x81, 0x83, 0x87, 0x8B, 0x8E, 0x8E, 0x8D, 0x8B,
	0x88, 0x85, 0x85, 0x84, 0x84, 0x85, 0x87, 0x85, 0x81, 0x7B, 0x75, 0x73,
	0x71, 0x6F, 0x6F, 0x73, 0x78, 0x79, 0x79, 0x79, 0x7B, 0x7C, 0x7D, 0x7E,
	0x80, 0x82, 0x82, 0x7F, 0x7C, 0x7E, 0x83, 0x84, 0x82, 0x81, 0x81, 0x7F,
	0x7A, 0x75, 0x72, 0x75, 0x7A, 0x7F, 0x81, 0x80, 0x82, 0x83, 0x81, 0x80,
	0x7F, 0x82, 0x81, 0x7E, 0x7F, 0x82, 0x86, 0x86, 0x82, 0x7E, 0x7D, 0x7C,
	0x7C, 0x79, 0x77, 0x77, 0x78, 0x79, 0x79, 0x7D, 0x84, 0x88, 0x88, 0x85,
	0x84, 0x84, 0x83, 0x81, 0x7F, 0x83, 0x88, 0x8B, 0x8A, 0x86, 0x83, 0x82,
	0x7F, 0x7D, 0x7D, 0x7F, 0x81, 0x81, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x80,
	0x83, 0x86, 0x87, 0x83, 0x81, 0x82, 0x86, 0x88, 0x87, 0x87, 0x87, 0x89,
	0x89, 0x88, 0x85, 0x83, 0x81, 0x7F, 0x7F, 0x81, 0x83, 0x85, 0x84, 0x82,
	0x80, 0x7F, 0x7F, 0x80, 0x83, 0x85, 0x88, 0x89, 0x86, 0x81, 0x7E, 0x7D,
	0x7E, 0x7F, 0x7D, 0x7C, 0x7D, 0x7C, 0x79, 0x75, 0x75, 0x78, 0x7A, 0x7A,
	0x7B, 0x7C, 0x7B, 0x79, 0x79, 0x7B, 0x7E, 0x82, 0x83, 0x82, 0x7D, 0x7A,
	0x79, 0x7A, 0x7A, 0x7B, 0x7E, 0x81, 0x82, 0x81, 0x7E, 0x7D, 0x7C, 0x79,
	0x78, 0x79, 0x7D, 0x7E, 0x7D, 0x7D, 0x80, 0x84, 0x84, 0x82, 0x7F, 0x80,
	0x81, 0x81, 0x7D, 0x7A, 0x7B, 0x7E, 0x83, 0x83, 0x82, 0x84, 0x86, 0x85,
	0x83, 0x7F, 0x7D, 0x7D, 0x7D, 0x80, 0x85, 0x8A, 0x8C, 0x89, 0x85, 0x83,
	0x84, 0x83, 0x80, 0x7F, 0x83, 0x87, 0x88, 0x84, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x81, 0x83, 0x82, 0x81, 0x81, 0x85, 0x88, 0x88, 0x87, 0x85,
	0x85, 0x84, 0x81, 0x7F, 0x81, 0x85, 0x88, 0x89, 0x88, 0x86, 0x83, 0x7E,
	0x7B, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x84, 0x89, 0x89, 0x87, 0x83,
	0x83, 0x84, 0x82, 0x7E, 0x7D, 0x7F, 0x84, 0x85, 0x84, 0x82, 0x7F, 0x7C,
	0x79, 0x76, 0x76, 0x77, 0x78, 0x78, 0x7A, 0x7E, 0x84, 0x85, 0x84, 0x81,
	0x7F, 0x7E, 0x7A, 0x77, 0x77, 0x7B, 0x7F, 0x82, 0x81, 0x7E, 0x7C, 0x79,
	0x76, 0x73, 0x72, 0x74, 0x78, 0x7A, 0x79, 0x79, 0x7E, 0x82, 0x82, 0x83,
	0x85, 0x87, 0x84, 0x7F, 0x7D, 0x7E, 0x81, 0x82, 0x84, 0x87, 0x88, 0x86,
	0x82, 0x7D, 0x79, 0x7A, 0x7C, 0x7B, 0x7B, 0x7C, 0x82, 0x87, 0x86, 0x82,
	0x81, 0x83, 0x84, 0x84, 0x83, 0x85, 0x88, 0x89, 0x88, 0x87, 0x86, 0x85,
	0x82, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x85, 0x87, 0x88, 0x86,
	0x86, 0x88, 0x87, 0x84, 0x81, 0x83, 0x88, 0x8A, 0x89, 0x87, 0x86, 0x84,
	0x7D, 0x78, 0x76, 0x77, 0x7B, 0x7D, 0x7F, 0x7F, 0x81, 0x83, 0x82, 0x80,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x82, 0x83, 0x84, 0x86, 0x87, 0x86,
	0x80, 0x79, 0x75, 0x76, 0x78, 0x79, 0x7B, 0x7E, 0x84, 0x8A, 0x89, 0x85,
	0x7F, 0x7B, 0x78, 0x77, 0x77, 0x77, 0x7A, 0x7D, 0x80, 0x82, 0x81, 0x7D,
	0x7A, 0x76, 0x73, 0x72, 0x75, 0x79, 0x7A, 0x7B, 0x7E, 0x85, 0x87, 0x87,
	0x85, 0x86, 0x85, 0x80, 0x7B, 0x7A, 0x7C, 0x7F, 0x83, 0x84, 0x85, 0x84,
	0x81, 0x7C, 0x77, 0x75, 0x77, 0x7A, 0x7C, 0x7E, 0x83, 0x8A, 0x8C, 0x8A,
	0x85, 0x84, 0x84, 0x82, 0x7D, 0x7D, 0x81, 0x83, 0x83, 0x82, 0x84, 0x86,
	0x83, 0x7E, 0x7B, 0x7A, 0x7D, 0x7E, 0x7F, 0x82, 0x87, 0x8F, 0x91, 0x91,
	0x8F, 0x8E, 0x8D, 0x89, 0x84, 0x81, 0x83, 0x87, 0x89, 0x87, 0x84, 0x81,
	0x7D, 0x78, 0x76, 0x77, 0x7B, 0x7B, 0x79, 0x7B, 0x83, 0x8B, 0x8B, 0x88,
	0x86, 0x87, 0x88, 0x85, 0x81, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7E, 0x7A, 0x78, 0x76, 0x76, 0x74, 0x75, 0x79, 0x81, 0x88, 0x88, 0x87,
	0x87, 0x88, 0x86, 0x7F, 0x78, 0x76, 0x7A, 0x7D, 0x7D, 0x7B, 0x78, 0x77,
	0x76, 0x75, 0x76, 0x78, 0x7A, 0x79, 0x77, 0x79, 0x7E, 0x84, 0x84, 0x84,
	0x85, 0x87, 0x86, 0x82, 0x80, 0x80, 0x82, 0x80, 0x7E, 0x7D, 0x7E, 0x7E,
	0x7A, 0x78, 0x77, 0x79, 0x7B, 0x7C, 0x7E, 0x82, 0x87, 0x8B, 0x89, 0x87,
	0x85, 0x85, 0x85, 0x82, 0x7E, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x7F, 0x7E,
	0x7B, 0x7B, 0x7C, 0x7E, 0x7F, 0x81, 0x83, 0x87, 0x8C, 0x91, 0x91, 0x91,
	0x91, 0x8F, 0x8B, 0x85, 0x81, 0x81, 0x83, 0x84, 0x82, 0x80, 0x7F, 0x7E,
	0x7C, 0x7B, 0x78, 0x78, 0x7A, 0x7D, 0x81, 0x85, 0x8B, 0x8D, 0x8B, 0x88,
	0x87, 0x87, 0x85, 0x81, 0x7D, 0x7D, 0x7D, 0x7D, 0x7B, 0x7C, 0x7D, 0x7C,
	0x7A, 0x79, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x81, 0x88, 0x8D, 0x8D, 0x8A,
	0x87, 0x85, 0x81, 0x7C, 0x79, 0x79, 0x7B, 0x7A, 0x77, 0x76, 0x76, 0x77,
	0x75, 0x74, 0x76, 0x79, 0x7A, 0x7A, 0x7C, 0x83, 0x88, 0x88, 0x86, 0x84,
	0x84, 0x83, 0x80, 0x7D, 0x7B, 0x7D, 0x7C, 0x7A, 0x7B, 0x7C, 0x7E, 0x7E,
	0x7A, 0x77, 0x77, 0x7A, 0x7A, 0x7B, 0x81, 0x8A, 0x8F, 0x8D, 0x89, 0x88,
	0x88, 0x85, 0x7E, 0x7B, 0x7C, 0x7E, 0x7C, 0x7A, 0x7C, 0x7D, 0x7F, 0x7E,
	0x7E, 0x7E, 0x81, 0x80, 0x7D, 0x7E, 0x84, 0x8C, 0x8F, 0x8D, 0x8D, 0x8E,
	0x8E, 0x89, 0x83, 0x82, 0x84, 0x85, 0x81, 0x7F, 0x84, 0x87, 0x87, 0x83,
	0x81, 0x81, 0x80, 0x7E, 0x7C, 0x7F, 0x85, 0x8A, 0x87, 0x85, 0x85, 0x85,
	0x84, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x81, 0x83, 0x83, 0x80,
	0x7E, 0x7D, 0x7C, 0x79, 0x76, 0x78, 0x7E, 0x84, 0x83, 0x81, 0x81, 0x81,
	0x81, 0x7E, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7C,
	0x79, 0x79, 0x79, 0x77, 0x76, 0x78, 0x7C, 0x7D, 0x7B, 0x79, 0x7A, 0x7C,
	0x7D, 0x7B, 0x7B, 0x7E, 0x82, 0x82, 0x81, 0x80, 0x83, 0x85, 0x84, 0x81,
	0x7E, 0x7C, 0x7A, 0x77, 0x76, 0x7A, 0x7F, 0x81, 0x7F, 0x80, 0x81, 0x81,
	0x7D, 0x7C, 0x7D, 0x82, 0x85, 0x84, 0x84, 0x85, 0x87, 0x88, 0x86, 0x84,
	0x83, 0x83, 0x82, 0x7F, 0x7E, 0x81, 0x82, 0x81, 0x7E, 0x7F, 0x82, 0x83,
	0x82, 0x82, 0x84, 0x87, 0x88, 0x86, 0x86, 0x89, 0x8B, 0x8A, 0x87, 0x86,
	0x86, 0x86, 0x84, 0x82, 0x83, 0x87, 0x86, 0x83, 0x80, 0x7F, 0x7F, 0x7C,
	0x7A, 0x7C, 0x80, 0x83, 0x82, 0x81, 0x81, 0x82, 0x83, 0x82, 0x82, 0x83,
	0x84, 0x83, 0x82, 0x81, 0x82, 0x83, 0x7F, 0x7C, 0x7C, 0x7D, 0x7D, 0x7B,
	0x79, 0x7A, 0x7D, 0x7E, 0x7D, 0x7D, 0x80, 0x83, 0x82, 0x7E, 0x7B, 0x7C,
	0x7D, 0x7C, 0x7D, 0x80, 0x84, 0x83, 0x7E, 0x7A, 0x7A, 0x7A, 0x77, 0x74,
	0x75, 0x7A, 0x7E, 0x7F, 0x7C, 0x7B, 0x7D, 0x7E, 0x7D, 0x7D, 0x7E, 0x81,
	0x7F, 0x7D, 0x7D, 0x82, 0x85, 0x83, 0x80, 0x7F, 0x81, 0x82, 0x7F, 0x7D,
	0x7E, 0x81, 0x82, 0x81, 0x81, 0x82, 0x85, 0x83, 0x81, 0x7D, 0x7C, 0x7D,
	0x7E, 0x7F, 0x82, 0x87, 0x87, 0x84, 0x7F, 0x7E, 0x81, 0x81, 0x7F, 0x7F,
	0x82, 0x86, 0x86, 0x85, 0x84, 0x86, 0x89, 0x89, 0x86, 0x85, 0x86, 0x85,
	0x82, 0x80, 0x83, 0x89, 0x89, 0x85, 0x83, 0x83, 0x83, 0x7F, 0x7D, 0x80,
	0x84, 0x86, 0x87, 0x86, 0x86, 0x86, 0x85, 0x83, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7E, 0x7F, 0x83, 0x84, 0x80, 0x7A, 0x78, 0x7A, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7F, 0x81, 0x82, 0x82, 0x83, 0x85, 0x85, 0x82, 0x80, 0x7F, 0x7F, 0x7C,
	0x7B, 0x7D, 0x82, 0x82, 0x7D, 0x79, 0x79, 0x79, 0x77, 0x75, 0x75, 0x7A,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7E, 0x82, 0x84, 0x81, 0x7D, 0x7A, 0x7A, 0x7A, 0x78, 0x77, 0x7A, 0x7F,
	0x82, 0x81, 0x82, 0x85, 0x87, 0x87, 0x83, 0x7F, 0x7F, 0x7F, 0x7F, 0x81,
	0x83, 0x88, 0x88, 0x85, 0x81, 0x7E, 0x7E, 0x7D, 0x7A, 0x7A, 0x7D, 0x81,
	0x82, 0x82, 0x84, 0x87, 0x88, 0x85, 0x83, 0x83, 0x85, 0x84, 0x82, 0x84,
	0x88, 0x8C, 0x8B, 0x88, 0x86, 0x87, 0x87, 0x84, 0x81, 0x80, 0x82, 0x83,
	0x84, 0x83, 0x85, 0x87, 0x87, 0x84, 0x81, 0x7F, 0x7E, 0x7B, 0x79, 0x7B,
	0x82, 0x86, 0x83, 0x7F, 0x7D, 0x7E, 0x7E, 0x7C, 0x7A, 0x7D, 0x82, 0x82,
	0x81, 0x81, 0x83, 0x84, 0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7D, 0x7C, 0x7E,
	0x83, 0x82, 0x7E, 0x7C, 0x7D, 0x7E, 0x7B, 0x78, 0x78, 0x7B, 0x7F, 0x80,
	0x7F, 0x80, 0x83, 0x82, 0x7E, 0x7A, 0x79, 0x79, 0x78, 0x76, 0x76, 0x7B,
	0x81, 0x80, 0x7D, 0x7C, 0x7D, 0x7C, 0x79, 0x76, 0x79, 0x7F, 0x82, 0x80,
	0x7F, 0x83, 0x87, 0x88, 0x86, 0x83, 0x83, 0x83, 0x7F, 0x7D, 0x7D, 0x82,
	0x85, 0x84, 0x82, 0x81, 0x82, 0x7F, 0x7B, 0x77, 0x77, 0x80, 0x83, 0x83,
	0x82, 0x87, 0x88, 0x85, 0x82, 0x82, 0x84, 0x85, 0x83, 0x82, 0x83, 0x88,
	0x8A, 0x86, 0x84, 0x86, 0x87, 0x84, 0x82, 0x82, 0x82, 0x85, 0x87, 0x85,
	0x85, 0x86, 0x88, 0x87, 0x85, 0x85, 0x85, 0x84, 0x80, 0x81, 0x81, 0x87,
	0x85, 0x82, 0x7E, 0x81, 0x81, 0x7C, 0x79, 0x79, 0x7B, 0x82, 0x80, 0x81,
	0x7F, 0x82, 0x83, 0x7F, 0x7D, 0x7C, 0x7F, 0x80, 0x7E, 0x7D, 0x82, 0x83,
	0x87, 0x80, 0x83, 0x80, 0x84, 0x79, 0x78, 0x77, 0x7E, 0x7B, 0x7D, 0x7B,
	0x7E, 0x82, 0x7D, 0x7B, 0x77, 0x78, 0x79, 0x78, 0x77, 0x77, 0x7D, 0x81,
	0x80, 0x7D, 0x7A, 0x7E, 0x7F, 0x7C, 0x77, 0x7E, 0x7E, 0x81, 0x7E, 0x80,
	0x7F, 0x86, 0x80, 0x81, 0x7D, 0x82, 0x81, 0x7D, 0x79, 0x7C, 0x82, 0x85,
	0x82, 0x82, 0x7F, 0x83, 0x82, 0x7C, 0x7B, 0x7D, 0x83, 0x81, 0x86, 0x84,
	0x85, 0x86, 0x83, 0x81, 0x7F, 0x82, 0x81, 0x7F, 0x7D, 0x7E, 0x86, 0x87,
	0x84, 0x83, 0x85, 0x86, 0x87, 0x82, 0x7F, 0x86, 0x88, 0x89, 0x89, 0x8B,
	0x8A, 0x8E, 0x87, 0x84, 0x82, 0x87, 0x82, 0x81, 0x7D, 0x82, 0x84, 0x86,
	0x82, 0x82, 0x7E, 0x83, 0x7D, 0x78, 0x7A, 0x7F, 0x7D, 0x84, 0x7F, 0x81,
	0x86, 0x82, 0x82, 0x7D, 0x82, 0x84, 0x7E, 0x7D, 0x80, 0x7C, 0x84, 0x85,
	0x83, 0x7E, 0x81, 0x82, 0x7E, 0x78, 0x79, 0x7A, 0x7F, 0x7E, 0x7F, 0x81,
	0x84, 0x7F, 0x7A, 0x7C, 0x7D, 0x7A, 0x7D, 0x79, 0x79, 0x7A, 0x84, 0x81,
	0x7B, 0x7D, 0x7E, 0x78, 0x7D, 0x73, 0x7A, 0x79, 0x7F, 0x7E, 0x81, 0x7E,
	0x7F, 0x7F, 0x7B, 0x77, 0x81, 0x7D, 0x7E, 0x7F, 0x7E, 0x80, 0x88, 0x86,
	0x82, 0x84, 0x85, 0x82, 0x7C, 0x82, 0x76, 0x7F, 0x82, 0x83, 0x80, 0x7F,
	0x8D, 0x7E, 0x77, 0x84, 0x7B, 0x7C, 0x7E, 0x82, 0x7B, 0x7E, 0x8F, 0x84,
	0x84, 0x89, 0x88, 0x84, 0x85, 0x81, 0x82, 0x82, 0x8B, 0x88, 0x82, 0x8A,
	0x8D, 0x81, 0x83, 0x85, 0x81, 0x7D, 0x87, 0x7F, 0x76, 0x87, 0x8E, 0x84,
	0x84, 0x8B, 0x83, 0x7D, 0x87, 0x7F, 0x73, 0x83, 0x88, 0x84, 0x7B, 0x8C,
	0x86, 0x77, 0x80, 0x81, 0x78, 0x78, 0x83, 0x7F, 0x72, 0x82, 0x8C, 0x7A,
	0x7D, 0x8A, 0x7F, 0x79, 0x84, 0x81, 0x71, 0x80, 0x8B, 0x7A, 0x7C, 0x84,
	0x86, 0x78, 0x7A, 0x84, 0x74, 0x74, 0x82, 0x75, 0x73, 0x7C, 0x86, 0x81,
	0x79, 0x80, 0x82, 0x76, 0x77, 0x7B, 0x79, 0x79, 0x82, 0x82, 0x7C, 0x81,
	0x82, 0x7F, 0x78, 0x79, 0x81, 0x7B, 0x7A, 0x7C, 0x7A, 0x80, 0x86, 0x87,
	0x85, 0x80, 0x85, 0x83, 0x7B, 0x79, 0x7D, 0x81, 0x82, 0x81, 0x84, 0x86,
	0x82, 0x7F, 0x81, 0x7F, 0x7D, 0x7F, 0x81, 0x7D, 0x7E, 0x89, 0x87, 0x88,
	0x85, 0x83, 0x88, 0x84, 0x7E, 0x81, 0x82, 0x84, 0x86, 0x84, 0x86, 0x86,
	0x89, 0x85, 0x85, 0x82, 0x84, 0x88, 0x7D, 0x7C, 0x85, 0x87, 0x8C, 0x8A,
	0x8A, 0x85, 0x87, 0x84, 0x7A, 0x7F, 0x7F, 0x7D, 0x84, 0x83, 0x83, 0x80,
	0x82, 0x7F, 0x7B, 0x7B, 0x7F, 0x81, 0x7A, 0x7D, 0x82, 0x82, 0x88, 0x85,
	0x81, 0x84, 0x84, 0x81, 0x7D, 0x80, 0x7C, 0x7F, 0x82, 0x7E, 0x7F, 0x80,
	0x82, 0x7E, 0x7A, 0x7C, 0x7A, 0x7A, 0x78, 0x79, 0x7F, 0x81, 0x85, 0x82,
	0x7D, 0x7D, 0x7D, 0x7A, 0x78, 0x78, 0x79, 0x7D, 0x7D, 0x7B, 0x7E, 0x7D,
	0x7E, 0x7C, 0x7A, 0x7C, 0x7C, 0x7A, 0x7A, 0x7A, 0x7C, 0x82, 0x85, 0x84,
	0x82, 0x84, 0x82, 0x7E, 0x7D, 0x7B, 0x7B, 0x7F, 0x80, 0x81, 0x85, 0x84,
	0x84, 0x82, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7F, 0x83, 0x89, 0x87, 0x84,
	0x85, 0x82, 0x81, 0x81, 0x7F, 0x7B, 0x7E, 0x82, 0x83, 0x84, 0x85, 0x87,
	0x88, 0x87, 0x86, 0x84, 0x85, 0x86, 0x83, 0x82, 0x85, 0x88, 0x8A, 0x8A,
	0x88, 0x88, 0x87, 0x82, 0x7D, 0x7C, 0x7D, 0x7F, 0x81, 0x82, 0x83, 0x84,
	0x84, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7D, 0x7E, 0x82, 0x86, 0x86, 0x83,
	0x7E, 0x81, 0x83, 0x7F, 0x7B, 0x7C, 0x7D, 0x7D, 0x80, 0x80, 0x80, 0x84,
	0x83, 0x7F, 0x7C, 0x7C, 0x7D, 0x79, 0x7A, 0x7D, 0x7F, 0x84, 0x85, 0x82,
	0x7E, 0x81, 0x7E, 0x77, 0x76, 0x78, 0x7A, 0x7C, 0x7E, 0x7C, 0x7C, 0x7F,
	0x7D, 0x79, 0x79, 0x7B, 0x7A, 0x7A, 0x7A, 0x79, 0x7E, 0x83, 0x82, 0x7F,
	0x80, 0x83, 0x83, 0x7E, 0x7B, 0x7C, 0x7B, 0x7E, 0x82, 0x81, 0x85, 0x89,
	0x85, 0x81, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x85, 0x88, 0x86, 0x81,
	0x7F, 0x82, 0x7F, 0x7A, 0x79, 0x7D, 0x7F, 0x82, 0x85, 0x85, 0x86, 0x88,
	0x87, 0x84, 0x83, 0x86, 0x85, 0x83, 0x83, 0x87, 0x8B, 0x8A, 0x88, 0x85,
	0x84, 0x86, 0x82, 0x7E, 0x7C, 0x7D, 0x82, 0x84, 0x85, 0x88, 0x8B, 0x8A,
	0x87, 0x82, 0x7F, 0x7F, 0x7F, 0x7C, 0x7C, 0x80, 0x85, 0x84, 0x7F, 0x7D,
	0x7F, 0x82, 0x7D, 0x79, 0x79, 0x79, 0x7C, 0x7F, 0x7E, 0x82, 0x86, 0x87,
	0x84, 0x82, 0x80, 0x81, 0x7E, 0x7B, 0x79, 0x7C, 0x84, 0x83, 0x7F, 0x7F,
	0x7F, 0x7D, 0x7A, 0x76, 0x75, 0x7A, 0x7E, 0x7F, 0x7E, 0x7F, 0x84, 0x7F,
	0x79, 0x78, 0x77, 0x78, 0x79, 0x7A, 0x7A, 0x7D, 0x84, 0x82, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7B, 0x78, 0x78, 0x79, 0x7E, 0x81, 0x7F, 0x82, 0x87, 0x86,
	0x83, 0x7F, 0x81, 0x81, 0x7C, 0x7C, 0x7B, 0x82, 0x89, 0x87, 0x84, 0x84,
	0x84, 0x82, 0x7E, 0x7C, 0x7D, 0x83, 0x85, 0x85, 0x83, 0x84, 0x88, 0x85,
	0x81, 0x80, 0x81, 0x82, 0x80, 0x7F, 0x81, 0x89, 0x8E, 0x8A, 0x87, 0x87,
	0x88, 0x85, 0x81, 0x7D, 0x7F, 0x83, 0x87, 0x85, 0x86, 0x8A, 0x8E, 0x8A,
	0x83, 0x81, 0x7F, 0x7F, 0x7B, 0x7A, 0x7B, 0x82, 0x86, 0x85, 0x83, 0x7F,
	0x80, 0x7F, 0x7D, 0x7B, 0x7E, 0x82, 0x83, 0x82, 0x82, 0x84, 0x83, 0x83,
	0x82, 0x7F, 0x7E, 0x7E, 0x7A, 0x77, 0x79, 0x7E, 0x82, 0x82, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7C, 0x78, 0x79, 0x7B, 0x7C, 0x80, 0x81, 0x84, 0x82, 0x7E,
	0x7A, 0x78, 0x77, 0x76, 0x75, 0x77, 0x79, 0x7C, 0x80, 0x81, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7D, 0x7C, 0x7A, 0x7B, 0x7C, 0x7E, 0x7D, 0x7F, 0x82, 0x83,
	0x83, 0x83, 0x86, 0x83, 0x81, 0x82, 0x83, 0x81, 0x82, 0x85, 0x81, 0x7E,
	0x7E, 0x7E, 0x7C, 0x7C, 0x7B, 0x7B, 0x80, 0x84, 0x86, 0x85, 0x88, 0x8A,
	0x87, 0x85, 0x86, 0x85, 0x82, 0x82, 0x82, 0x7E, 0x7E, 0x80, 0x80, 0x7B,
	0x7B, 0x85, 0x89, 0x8C, 0x8D, 0x8E, 0x8F, 0x8B, 0x87, 0x85, 0x86, 0x86,
	0x83, 0x83, 0x80, 0x7C, 0x7B, 0x73, 0x78, 0x7C, 0x7B, 0x81, 0x88, 0x8A,
	0x88, 0x87, 0x89, 0x85, 0x7F, 0x81, 0x83, 0x85, 0x83, 0x81, 0x7B, 0x78,
	0x67, 0x6A, 0x77, 0x78, 0x81, 0x85, 0x97, 0x9D, 0x93, 0x90, 0x88, 0x83,
	0x7A, 0x78, 0x82, 0x82, 0x80, 0x79, 0x7C, 0x74, 0x5C, 0x6F, 0x6B, 0x6D,
	0x70, 0x74, 0x81, 0x77, 0x76, 0x72, 0x72, 0x75, 0x6F, 0x72, 0x73, 0x76,
	0x7E, 0x7D, 0x87, 0x86, 0x6D, 0x7F, 0x7A, 0x7A, 0x8A, 0x8F, 0x98, 0x94,
	0xA4, 0x9B, 0x88, 0x8D, 0x96, 0xA0, 0x8A, 0x88, 0xA4, 0xA5, 0x93, 0x81,
	0x6E, 0x8A, 0x77, 0x67, 0x79, 0x8D, 0x9B, 0x7A, 0x85, 0x8D, 0x82, 0x70,
	0x68, 0x84, 0x7B, 0x6B, 0x6E, 0x81, 0x87, 0x77, 0x53, 0x5E, 0x76, 0x66,
	0x69, 0x73, 0x9C, 0x92, 0x83, 0x86, 0x87, 0x8B, 0x77, 0x84, 0x8B, 0x8D,
	0x88, 0x87, 0x94, 0x91, 0x78, 0x58, 0x76, 0x6F, 0x6C, 0x67, 0x7D, 0x8E,
	0x79, 0x7C, 0x76, 0x7E, 0x77, 0x76, 0x81, 0x7F, 0x84, 0x7E, 0x88, 0x8B,
	0x86, 0x5B, 0x66, 0x76, 0x76, 0x77, 0x79, 0xA2, 0x9A, 0x99, 0x8F, 0x92,
	0x98, 0x8E, 0x9A, 0x94, 0x98, 0x93, 0x9B, 0x9F, 0x9E, 0x84, 0x65, 0x87,
	0x7B, 0x82, 0x78, 0x94, 0x9D, 0x8C, 0x8B, 0x80, 0x8D, 0x7C, 0x7E, 0x82,
	0x7F, 0x81, 0x7E, 0x8E, 0x8B, 0x82, 0x51, 0x67, 0x6B, 0x68, 0x64, 0x6D,
	0x96, 0x84, 0x83, 0x73, 0x80, 0x7E, 0x72, 0x82, 0x7F, 0x88, 0x7E, 0x8C,
	0x8D, 0x8C, 0x66, 0x58, 0x77, 0x6F, 0x76, 0x69, 0x91, 0x93, 0x85, 0x7E,
	0x72, 0x84, 0x72, 0x7B, 0x7A, 0x79, 0x73, 0x72, 0x81, 0x80, 0x72, 0x46,
	0x6A, 0x70, 0x70, 0x6B, 0x73, 0x99, 0x87, 0x8A, 0x79, 0x88, 0x88, 0x7D,
	0x8A, 0x87, 0x8E, 0x86, 0x96, 0x9D, 0x9B, 0x6D, 0x66, 0x86, 0x7F, 0x7D,
	0x6F, 0x98, 0x9F, 0x98, 0x8B, 0x85, 0x94, 0x81, 0x87, 0x82, 0x88, 0x84,
	0x84, 0x92, 0x91, 0x86, 0x50, 0x6B, 0x72, 0x74, 0x6C, 0x74, 0xA1, 0x93,
	0x91, 0x7E, 0x8B, 0x8C, 0x80, 0x8B, 0x84, 0x8F, 0x8A, 0x97, 0x9A, 0x99,
	0x6E, 0x5D, 0x7C, 0x7B, 0x83, 0x72, 0x94, 0x9C, 0x95, 0x89, 0x7D, 0x8E,
	0x7F, 0x86, 0x84, 0x88, 0x87, 0x8A, 0x96, 0x90, 0x7C, 0x48, 0x67, 0x6B,
	0x71, 0x65, 0x6E, 0x96, 0x89, 0x88, 0x6E, 0x80, 0x7F, 0x7D, 0x85, 0x7F,
	0x8C, 0x83, 0x92, 0x8F, 0x93, 0x62, 0x52, 0x75, 0x74, 0x7B, 0x63, 0x8F,
	0x95, 0x94, 0x83, 0x77, 0x8D, 0x7D, 0x87, 0x7A, 0x82, 0x7E, 0x84, 0x8D,
	0x8E, 0x7A, 0x47, 0x68, 0x6C, 0x7A, 0x65, 0x73, 0x8E, 0x86, 0x89, 0x6C,
	0x85, 0x82, 0x88, 0x85, 0x84, 0x90, 0x8E, 0x9D, 0x96, 0x9C, 0x60, 0x60,
	0x79, 0x7E, 0x82, 0x6E, 0x9A, 0x95, 0x9A, 0x7F, 0x7B, 0x86, 0x7C, 0x8A,
	0x7B, 0x85, 0x80, 0x8A, 0x8E, 0x92, 0x77, 0x46, 0x67, 0x6C, 0x7C, 0x67,
	0x7A, 0x93, 0x91, 0x8A, 0x6E, 0x81, 0x7C, 0x82, 0x7B, 0x7A, 0x85, 0x84,
	0x8E, 0x8D, 0x8F, 0x59, 0x5E, 0x77, 0x82, 0x7F, 0x72, 0x92, 0x92, 0x99,
	0x7C, 0x7F, 0x88, 0x89, 0x8E, 0x82, 0x8A, 0x84, 0x8C, 0x8A, 0x91, 0x72,
	0x4A, 0x67, 0x6D, 0x7E, 0x66, 0x79, 0x8B, 0x8C, 0x86, 0x6D, 0x82, 0x81,
	0x8C, 0x83, 0x84, 0x88, 0x8B, 0x95, 0x94, 0x91, 0x58, 0x67, 0x77, 0x87,
	0x7D, 0x75, 0x97, 0x9A, 0xA2, 0x7B, 0x82, 0x86, 0x8D, 0x89, 0x7C, 0x87,
	0x82, 0x92, 0x8B, 0x93, 0x6B, 0x50, 0x68, 0x6F, 0x81, 0x64, 0x80, 0x8B,
	0x9C, 0x85, 0x71, 0x82, 0x84, 0x92, 0x82, 0x8D, 0x8A, 0x97, 0x9B, 0x99,
	0x93, 0x5D, 0x6B, 0x74, 0x8A, 0x7C, 0x78, 0x90, 0x93, 0x9A, 0x74, 0x7D,
	0x7E, 0x8F, 0x8B, 0x83, 0x86, 0x81, 0x90, 0x87, 0x90, 0x64, 0x4F, 0x69,
	0x75, 0x82, 0x63, 0x7E, 0x86, 0x94, 0x7B, 0x6C, 0x79, 0x7D, 0x8D, 0x7C,
	0x83, 0x7E, 0x8E, 0x92, 0x93, 0x87, 0x57, 0x6E, 0x77, 0x8E, 0x71, 0x77,
	0x8D, 0x94, 0x93, 0x6E, 0x7F, 0x7C, 0x90, 0x82, 0x7F, 0x81, 0x87, 0x95,
	0x8A, 0x95, 0x62, 0x5C, 0x6A, 0x77, 0x7A, 0x60, 0x7F, 0x81, 0x96, 0x73,
	0x74, 0x78, 0x84, 0x8D, 0x7E, 0x87, 0x7E, 0x96, 0x90, 0x99, 0x7B, 0x5A,
	0x72, 0x7B, 0x92, 0x70, 0x86, 0x91, 0xA0, 0x92, 0x75, 0x80, 0x7D, 0x91,
	0x81, 0x85, 0x7C, 0x87, 0x8D, 0x90, 0x88, 0x53, 0x64, 0x6F, 0x89, 0x70,
	0x6D, 0x86, 0x92, 0x99, 0x73, 0x7D, 0x7C, 0x94, 0x8A, 0x84, 0x84, 0x8B,
	0x9C, 0x91, 0x99, 0x6B, 0x65, 0x74, 0x83, 0x84, 0x6A, 0x89, 0x8A, 0x9F,
	0x80, 0x7C, 0x7F, 0x8A, 0x92, 0x80, 0x85, 0x78, 0x8D, 0x85, 0x93, 0x73,
	0x51, 0x63, 0x70, 0x87, 0x62, 0x72, 0x7C, 0x97, 0x89, 0x6F, 0x74, 0x78,
	0x91, 0x7E, 0x84, 0x7A, 0x92, 0x92, 0x97, 0x8D, 0x5F, 0x6D, 0x72, 0x8D,
	0x73, 0x70, 0x81, 0x91, 0x98, 0x75, 0x77, 0x75, 0x91, 0x86, 0x83, 0x7D,
	0x8A, 0x99, 0x92, 0x98, 0x66, 0x60, 0x68, 0x7F, 0x7A, 0x63, 0x75, 0x7E,
	0x96, 0x79, 0x72, 0x6F, 0x87, 0x8C, 0x81, 0x7D, 0x7E, 0x99, 0x90, 0x9A,
	0x78, 0x63, 0x70, 0x7D, 0x8D, 0x6F, 0x7F, 0x85, 0x9E, 0x91, 0x7C, 0x76,
	0x7F, 0x92, 0x85, 0x87, 0x7B, 0x90, 0x8F, 0x96, 0x84, 0x5B, 0x6D, 0x76,
	0x8F, 0x72, 0x71, 0x7B, 0x90, 0x94, 0x79, 0x78, 0x7A, 0x96, 0x8A, 0x8B,
	0x82, 0x92, 0x9E, 0x9E, 0x9A, 0x6B, 0x68, 0x70, 0x8A, 0x7D, 0x6B, 0x79,
	0x8C, 0x9F, 0x84, 0x77, 0x73, 0x8D, 0x8C, 0x83, 0x7A, 0x7F, 0x91, 0x8E,
	0x94, 0x6E, 0x60, 0x69, 0x7D, 0x82, 0x69, 0x6F, 0x79, 0x98, 0x89, 0x7A,
	0x6B, 0x7E, 0x8D, 0x84, 0x7A, 0x74, 0x8D, 0x92, 0x99, 0x7A, 0x5F, 0x67,
	0x78, 0x89, 0x6F, 0x6F, 0x77, 0x94, 0x90, 0x7E, 0x6E, 0x76, 0x91, 0x8D,
	0x8A, 0x7A, 0x8C, 0x94, 0x9D, 0x8B, 0x61, 0x5B, 0x6A, 0x83, 0x73, 0x66,
	0x68, 0x80, 0x90, 0x80, 0x70, 0x69, 0x87, 0x8D, 0x8B, 0x7C, 0x82, 0x92,
	0x9E, 0x9C, 0x77, 0x61, 0x6D, 0x85, 0x87, 0x72, 0x70, 0x7D, 0x9A, 0x93,
	0x84, 0x6F, 0x7E, 0x90, 0x91, 0x84, 0x78, 0x85, 0x95, 0xA2, 0x88, 0x67,
	0x65, 0x7D, 0x8D, 0x7B, 0x6E, 0x6E, 0x8A, 0x93, 0x8B, 0x73, 0x70, 0x87,
	0x95, 0x95, 0x85, 0x8A, 0x96, 0xA9, 0xA3, 0x7B, 0x62, 0x6C, 0x8A, 0x8B,
	0x78, 0x6E, 0x80, 0x98, 0x96, 0x82, 0x6B, 0x79, 0x8C, 0x95, 0x87, 0x7F,
	0x82, 0x93, 0x9E, 0x85, 0x63, 0x5B, 0x71, 0x83, 0x7F, 0x6F, 0x69, 0x80,
	0x8C, 0x88, 0x69, 0x64, 0x76, 0x8B, 0x8A, 0x82, 0x7F, 0x88, 0x98, 0x96,
	0x77, 0x61, 0x67, 0x7F, 0x89, 0x82, 0x71, 0x77, 0x86, 0x91, 0x84, 0x71,
	0x71, 0x83, 0x92, 0x91, 0x8A, 0x84, 0x8E, 0x96, 0x86, 0x69, 0x5F, 0x6A,
	0x79, 0x7C, 0x75, 0x6C, 0x73, 0x7C, 0x81, 0x76, 0x70, 0x76, 0x83, 0x8D,
	0x91, 0x8E, 0x8A, 0x8E, 0x8D, 0x7A, 0x6F, 0x6C, 0x73, 0x7A, 0x85, 0x82,
	0x82, 0x81, 0x85, 0x84, 0x7F, 0x7D, 0x81, 0x88, 0x90, 0x94, 0x92, 0x90,
	0x90, 0x81, 0x75, 0x6F, 0x72, 0x76, 0x7C, 0x7D, 0x7A, 0x7C, 0x7B, 0x7E,
	0x7B, 0x7E, 0x81, 0x87, 0x91, 0x98, 0x9C, 0x98, 0x97, 0x8C, 0x7C, 0x78,
	0x78, 0x7D, 0x7F, 0x86, 0x84, 0x88, 0x82, 0x7F, 0x7E, 0x7E, 0x83, 0x83,
	0x8C, 0x90, 0x95, 0x91, 0x8C, 0x8B, 0x79, 0x73, 0x6D, 0x72, 0x72, 0x7D,
	0x7C, 0x7C, 0x79, 0x72, 0x75, 0x72, 0x78, 0x76, 0x7D, 0x87, 0x8F, 0x92,
	0x8B, 0x8E, 0x84, 0x7C, 0x77, 0x77, 0x79, 0x79, 0x7F, 0x7C, 0x80, 0x78,
	0x79, 0x79, 0x7B, 0x7E, 0x7F, 0x88, 0x8D, 0x95, 0x91, 0x8E, 0x89, 0x7D,
	0x78, 0x70, 0x72, 0x70, 0x78, 0x75, 0x73, 0x6D, 0x68, 0x6D, 0x6E, 0x73,
	0x72, 0x7E, 0x86, 0x8F, 0x92, 0x90, 0x93, 0x89, 0x81, 0x7A, 0x7B, 0x7B,
	0x82, 0x85, 0x83, 0x84, 0x77, 0x75, 0x73, 0x7A, 0x7B, 0x7E, 0x88, 0x90,
	0x99, 0x94, 0x92, 0x8C, 0x85, 0x7D, 0x76, 0x76, 0x7A, 0x82, 0x7B, 0x7C,
	0x75, 0x72, 0x72, 0x75, 0x7D, 0x7F, 0x8A, 0x8F, 0x99, 0x9A, 0x97, 0x96,
	0x90, 0x8A, 0x83, 0x7C, 0x7C, 0x84, 0x86, 0x82, 0x7A, 0x74, 0x74, 0x72,
	0x7B, 0x7E, 0x87, 0x8C, 0x94, 0x98, 0x93, 0x92, 0x8D, 0x86, 0x7E, 0x78,
	0x77, 0x79, 0x7F, 0x7A, 0x74, 0x6B, 0x69, 0x6A, 0x6C, 0x72, 0x79, 0x83,
	0x88, 0x8F, 0x8C, 0x8D, 0x90, 0x8A, 0x82, 0x7B, 0x75, 0x77, 0x80, 0x84,
	0x81, 0x7B, 0x73, 0x72, 0x70, 0x79, 0x7B, 0x83, 0x89, 0x91, 0x90, 0x88,
	0x8B, 0x8E, 0x87, 0x7D, 0x77, 0x76, 0x77, 0x7C, 0x78, 0x72, 0x68, 0x67,
	0x67, 0x6A, 0x70, 0x79, 0x85, 0x8E, 0x93, 0x8D, 0x8D, 0x90, 0x8E, 0x86,
	0x81, 0x7C, 0x7C, 0x81, 0x84, 0x7F, 0x77, 0x6D, 0x6E, 0x71, 0x78, 0x7A,
	0x82, 0x8E, 0x96, 0x92, 0x8B, 0x8F, 0x93, 0x8C, 0x86, 0x7E, 0x7C, 0x7D,
	0x83, 0x7E, 0x79, 0x6F, 0x6F, 0x72, 0x77, 0x79, 0x7D, 0x8A, 0x95, 0x97,
	0x92, 0x93, 0x99, 0x97, 0x92, 0x8B, 0x83, 0x84, 0x88, 0x84, 0x7F, 0x75,
	0x72, 0x73, 0x75, 0x7A, 0x7A, 0x83, 0x8C, 0x92, 0x8E, 0x8A, 0x8F, 0x8D,
	0x87, 0x83, 0x7A, 0x77, 0x7A, 0x7F, 0x7A, 0x73, 0x6A, 0x6C, 0x6E, 0x74,
	0x76, 0x7B, 0x86, 0x8F, 0x8F, 0x88, 0x8A, 0x8F, 0x89, 0x86, 0x7D, 0x79,
	0x79, 0x7F, 0x81, 0x7B, 0x70, 0x6C, 0x6F, 0x75, 0x75, 0x76, 0x81, 0x8E,
	0x92, 0x8C, 0x89, 0x8F, 0x8B, 0x86, 0x82, 0x79, 0x74, 0x76, 0x79, 0x75,
	0x6C, 0x63, 0x68, 0x6E, 0x73, 0x74, 0x7B, 0x86, 0x8D, 0x8D, 0x89, 0x8E,
	0x91, 0x8B, 0x8B, 0x85, 0x7E, 0x79, 0x7E, 0x80, 0x7B, 0x70, 0x6E, 0x73,
	0x79, 0x7A, 0x7B, 0x86, 0x8F, 0x94, 0x90, 0x8E, 0x94, 0x8D, 0x8B, 0x88,
	0x81, 0x78, 0x78, 0x7F, 0x7D, 0x74, 0x6B, 0x72, 0x76, 0x7A, 0x7C, 0x87,
	0x91, 0x97, 0x97, 0x91, 0x98, 0x97, 0x8D, 0x8B, 0x86, 0x81, 0x7A, 0x7F,
	0x83, 0x7F, 0x71, 0x71, 0x75, 0x7A, 0x7B, 0x7D, 0x87, 0x8F, 0x95, 0x8D,
	0x90, 0x95, 0x8C, 0x88, 0x84, 0x82, 0x79, 0x77, 0x79, 0x78, 0x6E, 0x65,
	0x6C, 0x70, 0x76, 0x75, 0x81, 0x8A, 0x90, 0x8A, 0x86, 0x90, 0x8C, 0x87,
	0x82, 0x82, 0x7C, 0x75, 0x78, 0x79, 0x76, 0x69, 0x6C, 0x70, 0x77, 0x77,
	0x7B, 0x87, 0x8C, 0x90, 0x88, 0x8E, 0x90, 0x8A, 0x86, 0x81, 0x7E, 0x76,
	0x78, 0x77, 0x74, 0x6A, 0x69, 0x6F, 0x71, 0x76, 0x75, 0x81, 0x87, 0x8E,
	0x89, 0x89, 0x90, 0x8C, 0x8C, 0x86, 0x82, 0x78, 0x7A, 0x7F, 0x7B, 0x72,
	0x6B, 0x73, 0x74, 0x77, 0x76, 0x83, 0x8D, 0x92, 0x93, 0x8E, 0x95, 0x90,
	0x8E, 0x89, 0x84, 0x7E, 0x7A, 0x7F, 0x7E, 0x78, 0x6B, 0x6F, 0x76, 0x7E,
	0x7D, 0x80, 0x8D, 0x94, 0x97, 0x90, 0x92, 0x91, 0x8E, 0x8E, 0x87, 0x83,
	0x79, 0x7C, 0x7D, 0x7B, 0x72, 0x6D, 0x73, 0x7A, 0x7F, 0x7C, 0x84, 0x8E,
	0x96, 0x93, 0x8F, 0x90, 0x8D, 0x91, 0x8B, 0x83, 0x78, 0x78, 0x7B, 0x78,
	0x6D, 0x67, 0x6C, 0x75, 0x7B, 0x79, 0x7E, 0x88, 0x90, 0x90, 0x8C, 0x8C,
	0x87, 0x8C, 0x89, 0x81, 0x75, 0x72, 0x78, 0x79, 0x71, 0x67, 0x69, 0x70,
	0x78, 0x76, 0x79, 0x83, 0x8E, 0x90, 0x8E, 0x8E, 0x86, 0x8A, 0x89, 0x82,
	0x78, 0x71, 0x76, 0x78, 0x75, 0x6B, 0x6A, 0x6E, 0x78, 0x7A, 0x78, 0x7F,
	0x8C, 0x94, 0x92, 0x8F, 0x88, 0x8C, 0x8D, 0x83, 0x7B, 0x74, 0x78, 0x7A,
	0x7A, 0x70, 0x6B, 0x6D, 0x78, 0x7F, 0x7C, 0x81, 0x8C, 0x98, 0x9A, 0x97,
	0x8A, 0x89, 0x92, 0x89, 0x81, 0x77, 0x7A, 0x7F, 0x7F, 0x75, 0x6C, 0x6E,
	0x78, 0x83, 0x81, 0x82, 0x8B, 0x9A, 0x9E, 0x97, 0x88, 0x84, 0x91, 0x8D,
	0x82, 0x76, 0x7A, 0x80, 0x7F, 0x78, 0x6F, 0x70, 0x7A, 0x81, 0x82, 0x80,
	0x86, 0x92, 0x98, 0x98, 0x88, 0x82, 0x8C, 0x8B, 0x81, 0x71, 0x70, 0x78,
	0x7D, 0x76, 0x6F, 0x6E, 0x79, 0x82, 0x84, 0x82, 0x87, 0x92, 0x96, 0x99,
	0x89, 0x81, 0x85, 0x86, 0x7F, 0x6E, 0x6D, 0x73, 0x7B, 0x74, 0x70, 0x6C,
	0x72, 0x79, 0x7C, 0x7E, 0x7F, 0x8C, 0x93, 0x9B, 0x8C, 0x83, 0x84, 0x81,
	0x81, 0x71, 0x6E, 0x70, 0x79, 0x75, 0x6F, 0x6D, 0x6F, 0x79, 0x7B, 0x7F,
	0x7E, 0x8A, 0x95, 0x9A, 0x8B, 0x84, 0x88, 0x83, 0x81, 0x74, 0x72, 0x74,
	0x79, 0x79, 0x72, 0x74, 0x75, 0x7C, 0x7E, 0x82, 0x86, 0x8E, 0x98, 0x96,
	0x8C, 0x89, 0x89, 0x85, 0x7F, 0x77, 0x74, 0x79, 0x7A, 0x7B, 0x77, 0x7A,
	0x7E, 0x7E, 0x82, 0x83, 0x8C, 0x90, 0x99, 0x96, 0x8C, 0x8E, 0x8A, 0x89,
	0x7E, 0x77, 0x74, 0x78, 0x79, 0x77, 0x78, 0x78, 0x82, 0x7E, 0x82, 0x81,
	0x8C, 0x91, 0x96, 0x93, 0x8B, 0x91, 0x89, 0x89, 0x7C, 0x74, 0x72, 0x72,
	0x73, 0x70, 0x77, 0x77, 0x84, 0x81, 0x82, 0x82, 0x89, 0x94, 0x94, 0x8D,
	0x86, 0x8D, 0x88, 0x82, 0x75, 0x6C, 0x6F, 0x71, 0x72, 0x6F, 0x77, 0x7D,
	0x84, 0x82, 0x7D, 0x7F, 0x85, 0x90, 0x8E, 0x86, 0x85, 0x89, 0x88, 0x7F,
	0x76, 0x6C, 0x6D, 0x70, 0x6F, 0x6C, 0x6E, 0x7B, 0x82, 0x85, 0x7C, 0x7E,
	0x85, 0x91, 0x91, 0x85, 0x89, 0x88, 0x8B, 0x7F, 0x74, 0x6D, 0x6C, 0x6F,
	0x6E, 0x72, 0x73, 0x80, 0x85, 0x89, 0x85, 0x81, 0x89, 0x92, 0x95, 0x88,
	0x86, 0x86, 0x8A, 0x84, 0x77, 0x73, 0x72, 0x75, 0x70, 0x74, 0x78, 0x82,
	0x89, 0x8C, 0x8D, 0x88, 0x8D, 0x91, 0x92, 0x8D, 0x89, 0x89, 0x8B, 0x88,
	0x7D, 0x76, 0x75, 0x75, 0x73, 0x74, 0x7A, 0x80, 0x8A, 0x8D, 0x8D, 0x87,
	0x8A, 0x8F, 0x8E, 0x8D, 0x88, 0x89, 0x8A, 0x87, 0x7F, 0x77, 0x75, 0x70,
	0x6D, 0x6E, 0x77, 0x7D, 0x84, 0x88, 0x89, 0x88, 0x84, 0x88, 0x87, 0x8D,
	0x8B, 0x89, 0x89, 0x86, 0x82, 0x77, 0x74, 0x70, 0x6E, 0x6D, 0x74, 0x7C,
	0x7F, 0x83, 0x82, 0x84, 0x80, 0x81, 0x82, 0x87, 0x8B, 0x88, 0x87, 0x83,
	0x81, 0x7A, 0x76, 0x72, 0x6D, 0x6D, 0x71, 0x78, 0x77, 0x79, 0x7D, 0x82,
	0x80, 0x7F, 0x83, 0x87, 0x8C, 0x89, 0x87, 0x85, 0x83, 0x7E, 0x77, 0x74,
	0x6F, 0x6E, 0x6F, 0x77, 0x79, 0x7B, 0x80, 0x85, 0x88, 0x85, 0x87, 0x8A,
	0x8F, 0x8F, 0x8C, 0x89, 0x88, 0x85, 0x7E, 0x7B, 0x77, 0x74, 0x71, 0x75,
	0x7B, 0x7D, 0x81, 0x85, 0x8B, 0x8A, 0x88, 0x88, 0x8D, 0x90, 0x8E, 0x8B,
	0x8B, 0x8D, 0x86, 0x7E, 0x7A, 0x79, 0x77, 0x77, 0x7C, 0x7E, 0x81, 0x84,
	0x87, 0x87, 0x86, 0x86, 0x8A, 0x8C, 0x8C, 0x89, 0x88, 0x89, 0x85, 0x7F,
	0x7C, 0x7A, 0x77, 0x75, 0x78, 0x7A, 0x7C, 0x80, 0x84, 0x83, 0x83, 0x82,
	0x87, 0x89, 0x88, 0x87, 0x86, 0x88, 0x83, 0x7E, 0x7B, 0x7C, 0x7A, 0x76,
	0x78, 0x7A, 0x7B, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x81, 0x83, 0x82, 0x82,
	0x80, 0x83, 0x81, 0x7C, 0x78, 0x79, 0x79, 0x76, 0x74, 0x74, 0x79, 0x7B,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x81, 0x82, 0x82, 0x81, 0x83, 0x84, 0x81,
	0x7C, 0x7B, 0x7B, 0x79, 0x79, 0x76, 0x7A, 0x7F, 0x84, 0x84, 0x81, 0x81,
	0x7F, 0x86, 0x84, 0x81, 0x80, 0x85, 0x88, 0x82, 0x7B, 0x7A, 0x7D, 0x7D,
	0x7C, 0x7A, 0x7D, 0x83, 0x87, 0x88, 0x84, 0x85, 0x84, 0x8A, 0x8D, 0x88,
	0x86, 0x87, 0x8C, 0x88, 0x81, 0x7C, 0x7F, 0x81, 0x7E, 0x7C, 0x7C, 0x84,
	0x85, 0x8A, 0x88, 0x86, 0x85, 0x85, 0x8B, 0x88, 0x86, 0x84, 0x88, 0x86,
	0x81, 0x7B, 0x79, 0x7B, 0x79, 0x7B, 0x79, 0x7C, 0x7E, 0x82, 0x85, 0x81,
	0x83, 0x82, 0x89, 0x88, 0x86, 0x83, 0x84, 0x86, 0x83, 0x7F, 0x79, 0x79,
	0x77, 0x79, 0x78, 0x78, 0x7D, 0x81, 0x86, 0x82, 0x83, 0x7F, 0x81, 0x82,
	0x80, 0x81, 0x7E, 0x81, 0x7D, 0x7B, 0x76, 0x75, 0x74, 0x73, 0x76, 0x75,
	0x7B, 0x7B, 0x82, 0x84, 0x82, 0x82, 0x80, 0x84, 0x7F, 0x83, 0x7F, 0x83,
	0x81, 0x7F, 0x7B, 0x77, 0x76, 0x72, 0x77, 0x79, 0x7F, 0x81, 0x82, 0x87,
	0x84, 0x83, 0x7F, 0x86, 0x85, 0x88, 0x85, 0x85, 0x84, 0x7E, 0x7D, 0x78,
	0x7A, 0x78, 0x7A, 0x7B, 0x7D, 0x83, 0x82, 0x87, 0x86, 0x88, 0x85, 0x89,
	0x89, 0x89, 0x89, 0x87, 0x89, 0x85, 0x84, 0x7F, 0x81, 0x7E, 0x7F, 0x81,
	0x81, 0x88, 0x85, 0x88, 0x88, 0x87, 0x85, 0x86, 0x88, 0x85, 0x85, 0x80,
	0x83, 0x80, 0x80, 0x7D, 0x7C, 0x7D, 0x7B, 0x7B, 0x7A, 0x7F, 0x82, 0x86,
	0x89, 0x86, 0x84, 0x84, 0x88, 0x85, 0x83, 0x7F, 0x83, 0x84, 0x80, 0x7B,
	0x76, 0x7B, 0x7B, 0x7B, 0x78, 0x7C, 0x82, 0x85, 0x89, 0x84, 0x81, 0x7E,
	0x83, 0x83, 0x7F, 0x7C, 0x7B, 0x81, 0x7F, 0x7C, 0x74, 0x77, 0x77, 0x76,
	0x72, 0x74, 0x7C, 0x7E, 0x83, 0x81, 0x7F, 0x7D, 0x81, 0x84, 0x82, 0x81,
	0x7D, 0x81, 0x7F, 0x7D, 0x77, 0x77, 0x7A, 0x7B, 0x7A, 0x79, 0x7E, 0x81,
	0x86, 0x86, 0x83, 0x81, 0x80, 0x85, 0x85, 0x84, 0x7F, 0x82, 0x83, 0x83,
	0x7E, 0x79, 0x7C, 0x7D, 0x7E, 0x7B, 0x7E, 0x82, 0x87, 0x8A, 0x87, 0x84,
	0x82, 0x86, 0x88, 0x87, 0x84, 0x83, 0x84, 0x86, 0x84, 0x80, 0x81, 0x83,
	0x84, 0x80, 0x80, 0x83, 0x88, 0x8C, 0x89, 0x85, 0x84, 0x82, 0x82, 0x83,
	0x82, 0x82, 0x81, 0x82, 0x83, 0x7F, 0x7D, 0x7D, 0x7E, 0x7D, 0x7C, 0x7F,
	0x84, 0x88, 0x88, 0x84, 0x84, 0x82, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7C, 0x7D, 0x80, 0x81, 0x84, 0x86, 0x83,
	0x7F, 0x7C, 0x7B, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x7A, 0x77, 0x77,
	0x79, 0x79, 0x78, 0x7B, 0x7E, 0x83, 0x85, 0x84, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7B, 0x7D, 0x81, 0x84, 0x80, 0x79, 0x79, 0x78, 0x7A, 0x76, 0x78,
	0x7D, 0x86, 0x8D, 0x8C, 0x86, 0x7E, 0x7B, 0x7A, 0x7F, 0x82, 0x82, 0x84,
	0x84, 0x81, 0x79, 0x75, 0x77, 0x7F, 0x82, 0x82, 0x84, 0x86, 0x87, 0x85,
	0x83, 0x81, 0x85, 0x88, 0x8C, 0x8B, 0x86, 0x83, 0x80, 0x80, 0x7D, 0x7D,
	0x7E, 0x82, 0x83, 0x7F, 0x81, 0x85, 0x8C, 0x8D, 0x8B, 0x85, 0x83, 0x81,
	0x7E, 0x7F, 0x7F, 0x83, 0x85, 0x87, 0x86, 0x83, 0x80, 0x7F, 0x7F, 0x7A,
	0x7A, 0x7C, 0x83, 0x88, 0x88, 0x85, 0x81, 0x81, 0x7F, 0x82, 0x83, 0x85,
	0x86, 0x85, 0x84, 0x7D, 0x7C, 0x7C, 0x81, 0x7E, 0x7B, 0x7D, 0x82, 0x86,
	0x83, 0x7F, 0x79, 0x7A, 0x7B, 0x7B, 0x7E, 0x7D, 0x81, 0x81, 0x81, 0x7A,
	0x78, 0x77, 0x7C, 0x7C, 0x77, 0x79, 0x7C, 0x84, 0x81, 0x7F, 0x7B, 0x7B,
	0x7E, 0x7B, 0x7C, 0x7C, 0x7F, 0x80, 0x82, 0x7F, 0x7A, 0x7A, 0x7A, 0x7F,
	0x7A, 0x7A, 0x7C, 0x85, 0x8A, 0x88, 0x83, 0x7D, 0x7F, 0x7D, 0x7E, 0x7E,
	0x81, 0x82, 0x82, 0x81, 0x7C, 0x7C, 0x7C, 0x80, 0x7D, 0x7C, 0x7D, 0x82,
	0x8A, 0x8A, 0x87, 0x81, 0x81, 0x82, 0x84, 0x86, 0x86, 0x86, 0x84, 0x86,
	0x83, 0x7F, 0x7C, 0x7E, 0x84, 0x85, 0x87, 0x87, 0x8F, 0x91, 0x8E, 0x86,
	0x7F, 0x80, 0x80, 0x83, 0x83, 0x81, 0x7E, 0x81, 0x81, 0x7E, 0x7A, 0x78,
	0x81, 0x82, 0x83, 0x81, 0x87, 0x90, 0x8E, 0x87, 0x7C, 0x7B, 0x7C, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x82, 0x7F, 0x7F, 0x7D, 0x81, 0x84, 0x85, 0x82,
	0x81, 0x87, 0x88, 0x84, 0x79, 0x74, 0x76, 0x79, 0x7B, 0x7B, 0x7D, 0x7D,
	0x81, 0x81, 0x7E, 0x7C, 0x7C, 0x81, 0x83, 0x81, 0x7B, 0x7C, 0x7F, 0x7F,
	0x78, 0x70, 0x70, 0x76, 0x7C, 0x80, 0x81, 0x80, 0x84, 0x86, 0x85, 0x81,
	0x7D, 0x7F, 0x7F, 0x7F, 0x7C, 0x7E, 0x81, 0x81, 0x7D, 0x77, 0x76, 0x78,
	0x7B, 0x82, 0x86, 0x87, 0x88, 0x89, 0x89, 0x84, 0x7C, 0x78, 0x7A, 0x7A,
	0x78, 0x78, 0x7B, 0x7F, 0x81, 0x80, 0x80, 0x83, 0x89, 0x91, 0x92, 0x8E,
	0x88, 0x84, 0x83, 0x80, 0x79, 0x73, 0x73, 0x76, 0x78, 0x7C, 0x85, 0x92,
	0x9A, 0x9A, 0x93, 0x8C, 0x8C, 0x8F, 0x92, 0x8E, 0x84, 0x76, 0x6B, 0x64,
	0x61, 0x61, 0x6A, 0x7B, 0x8B, 0x93, 0x96, 0x99, 0x99, 0x9A, 0x97, 0x91,
	0x8B, 0x84, 0x7A, 0x6E, 0x61, 0x59, 0x5C, 0x68, 0x72, 0x77, 0x7E, 0x8A,
	0x95, 0x9D, 0xA1, 0xA5, 0xA7, 0xA0, 0x95, 0x7F, 0x6B, 0x5F, 0x59, 0x5B,
	0x5F, 0x62, 0x67, 0x72, 0x81, 0x8A, 0x8F, 0x96, 0xA0, 0xA4, 0xA2, 0x9A,
	0x90, 0x84, 0x75, 0x62, 0x4F, 0x4A, 0x51, 0x5D, 0x67, 0x72, 0x7B, 0x88,
	0x94, 0x9C, 0x9D, 0x9B, 0x9E, 0xA0, 0x9B, 0x8D, 0x79, 0x68, 0x5C, 0x56,
	0x52, 0x55, 0x62, 0x76, 0x84, 0x8F, 0x95, 0x9B, 0x9E, 0x9C, 0x9A, 0x96,
	0x94, 0x8E, 0x82, 0x70, 0x63, 0x5C, 0x5C, 0x66, 0x6B, 0x70, 0x79, 0x88,
	0x95, 0x9B, 0x9D, 0x99, 0x9A, 0x99, 0x99, 0x90, 0x83, 0x78, 0x6C, 0x67,
	0x66, 0x70, 0x74, 0x7A, 0x7F, 0x84, 0x8D, 0x92, 0x9B, 0x9B, 0x9B, 0x96,
	0x94, 0x8F, 0x84, 0x7A, 0x6A, 0x66, 0x63, 0x69, 0x71, 0x79, 0x82, 0x83,
	0x8C, 0x8E, 0x93, 0x93, 0x94, 0x96, 0x95, 0x94, 0x86, 0x79, 0x6A, 0x61,
	0x5D, 0x61, 0x6D, 0x76, 0x81, 0x88, 0x90, 0x91, 0x92, 0x94, 0x93, 0x92,
	0x8C, 0x8B, 0x85, 0x7A, 0x6D, 0x5D, 0x57, 0x59, 0x67, 0x73, 0x7C, 0x86,
	0x8C, 0x91, 0x96, 0x96, 0x92, 0x8B, 0x82, 0x7F, 0x80, 0x76, 0x6C, 0x60,
	0x5A, 0x59, 0x5E, 0x6A, 0x78, 0x87, 0x8B, 0x92, 0x98, 0x98, 0x9B, 0x95,
	0x90, 0x8B, 0x8B, 0x83, 0x76, 0x6A, 0x61, 0x63, 0x67, 0x74, 0x7B, 0x81,
	0x8A, 0x91, 0x97, 0x97, 0x9B, 0x9A, 0x9A, 0x96, 0x90, 0x88, 0x76, 0x69,
	0x5C, 0x5D, 0x61, 0x6D, 0x74, 0x7B, 0x85, 0x85, 0x8C, 0x8F, 0x94, 0x98,
	0x9B, 0x9A, 0x98, 0x98, 0x86, 0x76, 0x64, 0x5D, 0x5E, 0x69, 0x79, 0x82,
	0x8D, 0x8E, 0x92, 0x90, 0x94, 0x98, 0x97, 0x98, 0x92, 0x92, 0x83, 0x76,
	0x63, 0x5C, 0x60, 0x66, 0x75, 0x7C, 0x8B, 0x8E, 0x93, 0x94, 0x95, 0x96,
	0x92, 0x93, 0x8E, 0x8F, 0x83, 0x75, 0x6A, 0x63, 0x63, 0x67, 0x77, 0x7D,
	0x85, 0x87, 0x8F, 0x93, 0x92, 0x92, 0x8D, 0x8E, 0x86, 0x83, 0x7B, 0x6C,
	0x5B, 0x57, 0x5E, 0x64, 0x75, 0x74, 0x81, 0x86, 0x86, 0x8B, 0x7F, 0x87,
	0x8B, 0x8F, 0x8F, 0x85, 0x75, 0x66, 0x5E, 0x5E, 0x65, 0x66, 0x73, 0x77,
	0x85, 0x93, 0x96, 0x97, 0x88, 0x88, 0x8B, 0x98, 0xA0, 0x96, 0x86, 0x72,
	0x67, 0x60, 0x6B, 0x6F, 0x75, 0x79, 0x81, 0x91, 0x99, 0x9F, 0x94, 0x8E,
	0x8A, 0x8F, 0x93, 0x90, 0x8A, 0x71, 0x63, 0x55, 0x58, 0x63, 0x71, 0x7A,
	0x7F, 0x8C, 0x91, 0x9F, 0xA0, 0xA0, 0x9B, 0x9B, 0x9A, 0x94, 0x8D, 0x7B,
	0x6F, 0x61, 0x5D, 0x63, 0x75, 0x7D, 0x7F, 0x86, 0x84, 0x8B, 0x8B, 0x92,
	0x99, 0x99, 0x9C, 0x99, 0x95, 0x82, 0x70, 0x5C, 0x59, 0x61, 0x6E, 0x7F,
	0x81, 0x88, 0x86, 0x87, 0x86, 0x87, 0x8C, 0x8A, 0x93, 0x93, 0x8D, 0x7D,
	0x6E, 0x60, 0x59, 0x5A, 0x65, 0x76, 0x7F, 0x8C, 0x8D, 0x8C, 0x88, 0x87,
	0x8C, 0x91, 0x97, 0x92, 0x91, 0x88, 0x79, 0x6A, 0x63, 0x66, 0x6B, 0x75,
	0x78, 0x86, 0x8E, 0x94, 0x93, 0x90, 0x90, 0x8F, 0x96, 0x8D, 0x85, 0x76,
	0x65, 0x5C, 0x58, 0x5A, 0x5C, 0x65, 0x6A, 0x6F, 0x71, 0x76, 0x74, 0x79,
	0x7E, 0x83, 0x89, 0x86, 0x87, 0x7F, 0x72, 0x63, 0x5C, 0x63, 0x6E, 0x81,
	0x8B, 0x99, 0x98, 0x9B, 0x9B, 0x98, 0xA0, 0xA5, 0xAA, 0xA9, 0xA7, 0x9D,
	0x8D, 0x7F, 0x75, 0x71, 0x73, 0x86, 0x95, 0xA2, 0x9E, 0x98, 0x93, 0x8F,
	0x90, 0x91, 0x97, 0x98, 0x98, 0x8D, 0x7B, 0x69, 0x5B, 0x5A, 0x61, 0x70,
	0x79, 0x83, 0x85, 0x89, 0x89, 0x87, 0x88, 0x86, 0x84, 0x81, 0x81, 0x7E,
	0x72, 0x61, 0x57, 0x5A, 0x5C, 0x67, 0x73, 0x7D, 0x82, 0x81, 0x7C, 0x82,
	0x84, 0x89, 0x8A, 0x83, 0x7E, 0x78, 0x6C, 0x59, 0x50, 0x53, 0x5B, 0x6C,
	0x76, 0x7F, 0x83, 0x82, 0x7E, 0x7F, 0x81, 0x8B, 0x91, 0x91, 0x8E, 0x88,
	0x77, 0x66, 0x5D, 0x5D, 0x6D, 0x7F, 0x8B, 0x99, 0xA1, 0xA3, 0x9F, 0x9B,
	0x9E, 0xA3, 0xA9, 0xA4, 0xA3, 0xA0, 0x93, 0x7B, 0x6A, 0x67, 0x70, 0x82,
	0x8C, 0x9D, 0xA3, 0xA2, 0x9D, 0x96, 0x91, 0x92, 0x91, 0x8D, 0x89, 0x82,
	0x7C, 0x6A, 0x60, 0x5B, 0x5D, 0x69, 0x76, 0x84, 0x8B, 0x91, 0x8B, 0x86,
	0x84, 0x85, 0x89, 0x8A, 0x86, 0x7D, 0x77, 0x68, 0x62, 0x63, 0x69, 0x76,
	0x7F, 0x84, 0x87, 0x8A, 0x81, 0x7B, 0x7D, 0x85, 0x8C, 0x8A, 0x87, 0x83,
	0x7A, 0x65, 0x59, 0x54, 0x59, 0x64, 0x70, 0x7A, 0x7E, 0x7D, 0x79, 0x75,
	0x71, 0x77, 0x82, 0x87, 0x8B, 0x88, 0x82, 0x74, 0x68, 0x66, 0x65, 0x71,
	0x80, 0x8E, 0x97, 0x99, 0x93, 0x8C, 0x89, 0x8B, 0x92, 0x93, 0x95, 0x93,
	0x8F, 0x81, 0x72, 0x67, 0x67, 0x74, 0x7E, 0x84, 0x87, 0x89, 0x88, 0x85,
	0x7F, 0x7C, 0x7F, 0x82, 0x83, 0x84, 0x84, 0x79, 0x71, 0x6C, 0x70, 0x78,
	0x82, 0x8F, 0x93, 0x93, 0x8D, 0x88, 0x86, 0x8B, 0x91, 0x8E, 0x8E, 0x90,
	0x91, 0x89, 0x7F, 0x7C, 0x80, 0x8B, 0x95, 0x9C, 0x9C, 0x9A, 0x92, 0x87,
	0x7E, 0x7C, 0x82, 0x8B, 0x90, 0x8C, 0x85, 0x7A, 0x6F, 0x6D, 0x6C, 0x6D,
	0x78, 0x85, 0x8D, 0x8B, 0x84, 0x7B, 0x77, 0x75, 0x7A, 0x84, 0x8A, 0x8D,
	0x90, 0x88, 0x75, 0x69, 0x67, 0x6F, 0x7C, 0x86, 0x8D, 0x91, 0x93, 0x8E,
	0x84, 0x7B, 0x7F, 0x84, 0x86, 0x82, 0x7D, 0x77, 0x6E, 0x65, 0x5D, 0x5F,
	0x68, 0x73, 0x7D, 0x82, 0x82, 0x80, 0x7F, 0x7A, 0x7C, 0x7E, 0x85, 0x86,
	0x86, 0x81, 0x76, 0x71, 0x70, 0x76, 0x7D, 0x86, 0x8C, 0x94, 0x97, 0x94,
	0x8D, 0x87, 0x8A, 0x90, 0x93, 0x90, 0x8B, 0x84, 0x78, 0x69, 0x5F, 0x5F,
	0x69, 0x75, 0x7D, 0x7F, 0x7A, 0x75, 0x71, 0x6F, 0x72, 0x78, 0x83, 0x8B,
	0x8D, 0x86, 0x77, 0x6B, 0x64, 0x64, 0x6A, 0x74, 0x81, 0x8C, 0x8E, 0x8B,
	0x83, 0x7E, 0x81, 0x89, 0x95, 0x9A, 0x9B, 0x9B, 0x96, 0x8B, 0x79, 0x6F,
	0x71, 0x7B, 0x82, 0x87, 0x8B, 0x8B, 0x86, 0x7F, 0x7B, 0x7D, 0x85, 0x8B,
	0x8D, 0x8B, 0x83, 0x78, 0x6C, 0x67, 0x68, 0x71, 0x7A, 0x86, 0x8F, 0x8E,
	0x89, 0x84, 0x85, 0x89, 0x8E, 0x91, 0x92, 0x92, 0x8E, 0x86, 0x79, 0x73,
	0x75, 0x7C, 0x85, 0x8B, 0x8D, 0x8E, 0x8B, 0x7E, 0x79, 0x78, 0x82, 0x89,
	0x8B, 0x86, 0x7E, 0x74, 0x6B, 0x65, 0x63, 0x69, 0x75, 0x83, 0x89, 0x8A,
	0x86, 0x7D, 0x7B, 0x7B, 0x83, 0x8E, 0x96, 0x9A, 0x93, 0x87, 0x7B, 0x72,
	0x6E, 0x73, 0x7F, 0x8B, 0x93, 0x98, 0x98, 0x8F, 0x83, 0x7C, 0x81, 0x87,
	0x88, 0x89, 0x86, 0x7C, 0x6F, 0x61, 0x59, 0x59, 0x63, 0x72, 0x81, 0x89,
	0x8B, 0x88, 0x81, 0x7E, 0x7E, 0x84, 0x8A, 0x8D, 0x88, 0x7F, 0x73, 0x6A,
	0x64, 0x62, 0x68, 0x76, 0x85, 0x8C, 0x92, 0x93, 0x90, 0x8E, 0x90, 0x97,
	0x9A, 0x97, 0x91, 0x88, 0x78, 0x6B, 0x61, 0x60, 0x67, 0x75, 0x7F, 0x87,
	0x8B, 0x89, 0x84, 0x82, 0x84, 0x86, 0x89, 0x8E, 0x91, 0x89, 0x79, 0x6D,
	0x64, 0x62, 0x65, 0x74, 0x87, 0x92, 0x96, 0x94, 0x91, 0x8A, 0x87, 0x8B,
	0x95, 0x9B, 0x9B, 0x97, 0x8D, 0x7E, 0x6D, 0x64, 0x65, 0x70, 0x7E, 0x88,
	0x8D, 0x8C, 0x88, 0x7E, 0x7C, 0x7D, 0x82, 0x87, 0x89, 0x89, 0x80, 0x75,
	0x6C, 0x65, 0x63, 0x69, 0x78, 0x86, 0x8E, 0x90, 0x94, 0x91, 0x8C, 0x89,
	0x8C, 0x91, 0x90, 0x8C, 0x85, 0x81, 0x77, 0x6F, 0x6C, 0x6D, 0x75, 0x7E,
	0x87, 0x89, 0x86, 0x82, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x7A, 0x71,
	0x66, 0x63, 0x63, 0x62, 0x6A, 0x79, 0x86, 0x8C, 0x8C, 0x89, 0x84, 0x7C,
	0x7D, 0x84, 0x89, 0x89, 0x84, 0x7F, 0x79, 0x6F, 0x6A, 0x6E, 0x7A, 0x86,
	0x94, 0x9A, 0x9C, 0x98, 0x91, 0x8A, 0x85, 0x83, 0x83, 0x88, 0x8A, 0x84,
	0x78, 0x6F, 0x6C, 0x69, 0x6A, 0x73, 0x85, 0x8C, 0x8F, 0x90, 0x8E, 0x88,
	0x80, 0x7E, 0x7E, 0x82, 0x84, 0x85, 0x84, 0x7D, 0x73, 0x6E, 0x72, 0x7A,
	0x82, 0x8A, 0x93, 0x98, 0x98, 0x97, 0x92, 0x8F, 0x8C, 0x8B, 0x8A, 0x87,
	0x7F, 0x77, 0x71, 0x6E, 0x6C, 0x6F, 0x78, 0x83, 0x86, 0x85, 0x89, 0x8A,
	0x86, 0x82, 0x82, 0x83, 0x82, 0x7E, 0x78, 0x75, 0x72, 0x6E, 0x6E, 0x73,
	0x7E, 0x8A, 0x92, 0x96, 0x95, 0x93, 0x91, 0x8D, 0x8A, 0x88, 0x89, 0x86,
	0x7E, 0x75, 0x6C, 0x67, 0x67, 0x68, 0x71, 0x7F, 0x8B, 0x8E, 0x8B, 0x88,
	0x82, 0x7A, 0x77, 0x79, 0x7A, 0x78, 0x74, 0x71, 0x6E, 0x69, 0x65, 0x64,
	0x6E, 0x7A, 0x85, 0x8D, 0x92, 0x92, 0x8D, 0x89, 0x84, 0x82, 0x81, 0x81,
	0x83, 0x7F, 0x7D, 0x79, 0x79, 0x76, 0x77, 0x7D, 0x87, 0x90, 0x92, 0x94,
	0x92, 0x8F, 0x88, 0x86, 0x84, 0x80, 0x7B, 0x77, 0x76, 0x72, 0x6E, 0x6C,
	0x70, 0x78, 0x7F, 0x86, 0x89, 0x8F, 0x90, 0x8F, 0x8D, 0x8C, 0x8C, 0x8B,
	0x89, 0x82, 0x7B, 0x74, 0x75, 0x78, 0x7B, 0x82, 0x8C, 0x96, 0x96, 0x95,
	0x91, 0x8C, 0x87, 0x82, 0x84, 0x87, 0x85, 0x7E, 0x78, 0x70, 0x68, 0x64,
	0x69, 0x73, 0x7D, 0x87, 0x8D, 0x91, 0x8F, 0x89, 0x81, 0x7E, 0x83, 0x85,
	0x86, 0x87, 0x86, 0x81, 0x7B, 0x75, 0x77, 0x7C, 0x83, 0x8D, 0x92, 0x94,
	0x8E, 0x8B, 0x84, 0x7C, 0x77, 0x77, 0x7C, 0x7C, 0x79, 0x74, 0x72, 0x6E,
	0x6D, 0x6F, 0x75, 0x7D, 0x82, 0x85, 0x7F, 0x7C, 0x78, 0x76, 0x77, 0x78,
	0x78, 0x74, 0x73, 0x71, 0x6F, 0x6C, 0x6E, 0x79, 0x85, 0x8E, 0x8F, 0x8E,
	0x8B, 0x88, 0x84, 0x84, 0x8A, 0x8E, 0x91, 0x8A, 0x80, 0x79, 0x74, 0x75,
	0x76, 0x7B, 0x85, 0x91, 0x98, 0x95, 0x8B, 0x82, 0x7D, 0x7B, 0x7C, 0x7E,
	0x7E, 0x7C, 0x75, 0x6E, 0x67, 0x66, 0x6C, 0x79, 0x8A, 0x95, 0x99, 0x99,
	0x97, 0x91, 0x89, 0x82, 0x83, 0x88, 0x89, 0x85, 0x7D, 0x78, 0x76, 0x77,
	0x79, 0x81, 0x8D, 0x96, 0x97, 0x92, 0x8C, 0x88, 0x88, 0x8A, 0x87, 0x7F,
	0x78, 0x72, 0x6B, 0x64, 0x64, 0x6B, 0x75, 0x7F, 0x89, 0x8C, 0x8A, 0x87,
	0x84, 0x88, 0x8C, 0x8F, 0x91, 0x91, 0x8A, 0x7E, 0x73, 0x6F, 0x74, 0x7B,
	0x83, 0x89, 0x8E, 0x90, 0x8B, 0x83, 0x7D, 0x7E, 0x82, 0x86, 0x87, 0x84,
	0x7B, 0x75, 0x70, 0x6B, 0x6C, 0x72, 0x7B, 0x7E, 0x7E, 0x7D, 0x7E, 0x7C,
	0x7B, 0x7C, 0x79, 0x7A, 0x78, 0x77, 0x75, 0x73, 0x72, 0x77, 0x81, 0x88,
	0x89, 0x84, 0x81, 0x81, 0x86, 0x88, 0x8B, 0x90, 0x8F, 0x8A, 0x7E, 0x77,
	0x76, 0x78, 0x7E, 0x84, 0x8A, 0x8D, 0x8D, 0x88, 0x80, 0x7A, 0x79, 0x7D,
	0x7E, 0x7E, 0x77, 0x73, 0x70, 0x71, 0x74, 0x76, 0x7D, 0x85, 0x8C, 0x8D,
	0x8A, 0x84, 0x83, 0x86, 0x87, 0x85, 0x7E, 0x7A, 0x77, 0x78, 0x7A, 0x81,
	0x8C, 0x95, 0x99, 0x95, 0x91, 0x8D, 0x8A, 0x87, 0x87, 0x86, 0x86, 0x86,
	0x7B, 0x6F, 0x67, 0x69, 0x71, 0x7B, 0x87, 0x8C, 0x8F, 0x8A, 0x82, 0x7B,
	0x7A, 0x7E, 0x83, 0x84, 0x83, 0x7F, 0x78, 0x77, 0x7A, 0x81, 0x86, 0x8A,
	0x90, 0x92, 0x8F, 0x87, 0x81, 0x81, 0x82, 0x81, 0x7D, 0x77, 0x72, 0x71,
	0x74, 0x7A, 0x81, 0x88, 0x90, 0x90, 0x8B, 0x84, 0x7E, 0x79, 0x78, 0x77,
	0x77, 0x74, 0x6D, 0x67, 0x65, 0x69, 0x73, 0x7E, 0x85, 0x89, 0x8B, 0x8A,
	0x89, 0x85, 0x80, 0x7C, 0x7C, 0x79, 0x74, 0x70, 0x6F, 0x74, 0x7B, 0x83,
	0x8A, 0x91, 0x93, 0x92, 0x90, 0x8E, 0x8D, 0x8E, 0x8F, 0x8B, 0x7F, 0x71,
	0x6A, 0x69, 0x6D, 0x74, 0x7D, 0x89, 0x90, 0x90, 0x8A, 0x82, 0x80, 0x83,
	0x88, 0x88, 0x85, 0x7D, 0x73, 0x6B, 0x68, 0x6D, 0x76, 0x82, 0x8D, 0x94,
	0x95, 0x93, 0x92, 0x90, 0x8D, 0x8A, 0x87, 0x83, 0x7B, 0x72, 0x6A, 0x6B,
	0x73, 0x7F, 0x89, 0x8D, 0x8F, 0x8F, 0x8F, 0x8C, 0x89, 0x89, 0x8A, 0x87,
	0x7B, 0x6D, 0x65, 0x66, 0x6E, 0x79, 0x83, 0x8D, 0x93, 0x97, 0x97, 0x93,
	0x8F, 0x8F, 0x8F, 0x89, 0x7D, 0x70, 0x67, 0x64, 0x65, 0x6A, 0x72, 0x7C,
	0x87, 0x8F, 0x8F, 0x8E, 0x8F, 0x95, 0x9A, 0x98, 0x8D, 0x7A, 0x6A, 0x60,
	0x5D, 0x5E, 0x67, 0x73, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x88, 0x8C, 0x90,
	0x91, 0x8D, 0x81, 0x71, 0x64, 0x5E, 0x62, 0x6C, 0x77, 0x80, 0x86, 0x88,
	0x87, 0x87, 0x89, 0x8D, 0x91, 0x94, 0x90, 0x86, 0x7A, 0x73, 0x74, 0x77,
	0x7C, 0x80, 0x83, 0x83, 0x81, 0x7E, 0x7C, 0x84, 0x8A, 0x8B, 0x83, 0x78,
	0x74, 0x74, 0x76, 0x78, 0x7B, 0x81, 0x87, 0x87, 0x86, 0x81, 0x7D, 0x7F,
	0x85, 0x8B, 0x8C, 0x89, 0x7F, 0x79, 0x78, 0x7B, 0x82, 0x89, 0x8F, 0x8F,
	0x8B, 0x84, 0x84, 0x86, 0x88, 0x8A, 0x88, 0x84, 0x7C, 0x76, 0x70, 0x70,
	0x76, 0x82, 0x8D, 0x8E, 0x8C, 0x87, 0x83, 0x7F, 0x7E, 0x81, 0x89, 0x8E,
	0x88, 0x7D, 0x74, 0x70, 0x70, 0x75, 0x7E, 0x88, 0x91, 0x92, 0x8E, 0x84,
	0x7C, 0x79, 0x7B, 0x82, 0x85, 0x83, 0x7C, 0x77, 0x73, 0x75, 0x7A, 0x7E,
	0x86, 0x8C, 0x90, 0x8B, 0x82, 0x7B, 0x7A, 0x79, 0x74, 0x70, 0x6E, 0x6D,
	0x6C, 0x6B, 0x6D, 0x76, 0x81, 0x89, 0x90, 0x91, 0x8D, 0x86, 0x82, 0x83,
	0x83, 0x81, 0x7B, 0x76, 0x6F, 0x6A, 0x6C, 0x75, 0x82, 0x8D, 0x93, 0x98,
	0x9B, 0x9A, 0x98, 0x93, 0x8C, 0x86, 0x81, 0x7A, 0x70, 0x63, 0x5D, 0x60,
	0x68, 0x71, 0x7B, 0x89, 0x93, 0x98, 0x95, 0x90, 0x90, 0x90, 0x8D, 0x86,
	0x7B, 0x6E, 0x63, 0x5E, 0x61, 0x69, 0x74, 0x82, 0x8E, 0x98, 0x9C, 0x9C,
	0x9A, 0x98, 0x98, 0x96, 0x91, 0x88, 0x7B, 0x6E, 0x63, 0x5B, 0x5E, 0x6B,
	0x7B, 0x88, 0x8E, 0x96, 0x9A, 0x98, 0x91, 0x8C, 0x8F, 0x91, 0x8D, 0x82,
	0x74, 0x69, 0x64, 0x62, 0x68, 0x73, 0x7E, 0x88, 0x8D, 0x93, 0x94, 0x92,
	0x8F, 0x8C, 0x89, 0x85, 0x82, 0x7A, 0x72, 0x6A, 0x68, 0x69, 0x71, 0x7D,
	0x87, 0x8F, 0x8F, 0x8F, 0x8F, 0x8E, 0x8C, 0x87, 0x83, 0x7C, 0x75, 0x6B,
	0x66, 0x64, 0x64, 0x67, 0x6E, 0x79, 0x83, 0x8B, 0x8B, 0x8B, 0x8A, 0x8A,
	0x8A, 0x8A, 0x89, 0x83, 0x7D, 0x75, 0x70, 0x6D, 0x71, 0x79, 0x82, 0x8B,
	0x90, 0x94, 0x92, 0x92, 0x90, 0x90, 0x8F, 0x88, 0x82, 0x79, 0x73, 0x6B,
	0x68, 0x6A, 0x6E, 0x74, 0x78, 0x80, 0x86, 0x8A, 0x89, 0x88, 0x8A, 0x8D,
	0x8D, 0x86, 0x80, 0x77, 0x70, 0x6B, 0x6D, 0x73, 0x79, 0x83, 0x88, 0x8D,
	0x8D, 0x8D, 0x8D, 0x8E, 0x90, 0x91, 0x90, 0x89, 0x82, 0x78, 0x73, 0x6E,
	0x6D, 0x73, 0x7C, 0x86, 0x89, 0x89, 0x86, 0x83, 0x82, 0x83, 0x8A, 0x92,
	0x95, 0x8D, 0x81, 0x76, 0x72, 0x70, 0x72, 0x78, 0x7D, 0x83, 0x84, 0x85,
	0x7F, 0x7D, 0x7E, 0x81, 0x87, 0x8C, 0x91, 0x8D, 0x84, 0x7A, 0x77, 0x77,
	0x7B, 0x81, 0x84, 0x86, 0x82, 0x7E, 0x7A, 0x78, 0x7A, 0x7D, 0x81, 0x85,
	0x87, 0x82, 0x7A, 0x74, 0x74, 0x76, 0x77, 0x79, 0x7A, 0x7D, 0x7B, 0x78,
	0x75, 0x77, 0x7C, 0x83, 0x88, 0x8D, 0x91, 0x8F, 0x8A, 0x83, 0x82, 0x82,
	0x82, 0x84, 0x85, 0x86, 0x82, 0x7F, 0x7E, 0x7F, 0x81, 0x83, 0x87, 0x89,
	0x8C, 0x8B, 0x87, 0x81, 0x7C, 0x78, 0x75, 0x73, 0x75, 0x7A, 0x79, 0x77,
	0x74, 0x76, 0x7A, 0x7B, 0x7E, 0x82, 0x89, 0x8E, 0x8E, 0x89, 0x85, 0x82,
	0x7C, 0x7A, 0x7B, 0x7E, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E, 0x81, 0x86,
	0x8C, 0x8E, 0x8E, 0x8A, 0x84, 0x7D, 0x78, 0x77, 0x78, 0x78, 0x7B, 0x7B,
	0x7A, 0x7C, 0x7F, 0x82, 0x83, 0x85, 0x8C, 0x91, 0x93, 0x8D, 0x83, 0x7B,
	0x76, 0x72, 0x70, 0x73, 0x77, 0x79, 0x7A, 0x7D, 0x7F, 0x83, 0x87, 0x8B,
	0x92, 0x97, 0x98, 0x91, 0x88, 0x7F, 0x79, 0x72, 0x6D, 0x6D, 0x71, 0x76,
	0x77, 0x79, 0x7C, 0x7F, 0x80, 0x84, 0x8C, 0x91, 0x93, 0x8E, 0x86, 0x7B,
	0x75, 0x6D, 0x68, 0x69, 0x6D, 0x73, 0x7A, 0x83, 0x89, 0x8A, 0x88, 0x8A,
	0x91, 0x97, 0x9B, 0x99, 0x93, 0x8A, 0x81, 0x77, 0x70, 0x70, 0x73, 0x79,
	0x7C, 0x81, 0x84, 0x85, 0x84, 0x82, 0x83, 0x88, 0x8E, 0x8D, 0x88, 0x7E,
	0x76, 0x70, 0x6C, 0x6A, 0x6B, 0x71, 0x77, 0x7D, 0x83, 0x86, 0x85, 0x83,
	0x86, 0x8D, 0x92, 0x91, 0x8D, 0x87, 0x7F, 0x78, 0x71, 0x6F, 0x6F, 0x72,
	0x76, 0x7C, 0x83, 0x87, 0x87, 0x85, 0x85, 0x87, 0x8E, 0x92, 0x90, 0x8B,
	0x83, 0x7B, 0x74, 0x71, 0x71, 0x74, 0x79, 0x7D, 0x82, 0x86, 0x86, 0x82,
	0x82, 0x85, 0x8A, 0x8B, 0x8A, 0x88, 0x85, 0x7E, 0x75, 0x71, 0x70, 0x73,
	0x78, 0x7E, 0x86, 0x89, 0x89, 0x87, 0x87, 0x88, 0x8A, 0x8D, 0x8D, 0x8A,
	0x85, 0x7F, 0x76, 0x71, 0x6E, 0x6E, 0x72, 0x76, 0x7D, 0x83, 0x84, 0x82,
	0x7F, 0x81, 0x86, 0x88, 0x88, 0x87, 0x86, 0x85, 0x7E, 0x78, 0x74, 0x74,
	0x75, 0x79, 0x7E, 0x85, 0x8A, 0x8C, 0x8D, 0x8E, 0x90, 0x90, 0x90, 0x90,
	0x8D, 0x8A, 0x83, 0x7A, 0x72, 0x6D, 0x6C, 0x6C, 0x72, 0x79, 0x80, 0x84,
	0x86, 0x88, 0x8B, 0x8E, 0x8C, 0x87, 0x86, 0x86, 0x7E, 0x75, 0x6D, 0x69,
	0x69, 0x6A, 0x70, 0x79, 0x83, 0x8A, 0x8D, 0x8F, 0x90, 0x90, 0x8F, 0x8C,
	0x88, 0x83, 0x7B, 0x75, 0x6E, 0x6A, 0x69, 0x69, 0x70, 0x7B, 0x87, 0x8C,
	0x8E, 0x8F, 0x92, 0x94, 0x93, 0x8D, 0x88, 0x87, 0x82, 0x79, 0x6F, 0x6B,
	0x6C, 0x6E, 0x70, 0x78, 0x83, 0x8A, 0x8E, 0x8F, 0x90, 0x90, 0x8E, 0x8B,
	0x86, 0x80, 0x7A, 0x77, 0x76, 0x73, 0x70, 0x6E, 0x71, 0x7A, 0x85, 0x8C,
	0x8F, 0x90, 0x91, 0x90, 0x8D, 0x86, 0x81, 0x7D, 0x7C, 0x77, 0x73, 0x70,
	0x6F, 0x6E, 0x6D, 0x74, 0x80, 0x8A, 0x8E, 0x8D, 0x8D, 0x8F, 0x8D, 0x88,
	0x82, 0x7E, 0x7D, 0x7A, 0x77, 0x76, 0x76, 0x76, 0x78, 0x80, 0x8A, 0x91,
	0x92, 0x91, 0x92, 0x92, 0x8F, 0x86, 0x7E, 0x78, 0x76, 0x73, 0x71, 0x70,
	0x72, 0x73, 0x74, 0x7A, 0x83, 0x8C, 0x8D, 0x8B, 0x8A, 0x8A, 0x87, 0x80,
	0x78, 0x75, 0x75, 0x73, 0x74, 0x76, 0x79, 0x7A, 0x7A, 0x7E, 0x86, 0x8C,
	0x8E, 0x8C, 0x8A, 0x89, 0x86, 0x81, 0x7A, 0x76, 0x76, 0x78, 0x7A, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7D, 0x83, 0x89, 0x8E, 0x8F, 0x8E, 0x8E, 0x8B, 0x85,
	0x7F, 0x7B, 0x7A, 0x7C, 0x7C, 0x7C, 0x7B, 0x79, 0x74, 0x73, 0x79, 0x80,
	0x86, 0x86, 0x88, 0x8A, 0x8B, 0x86, 0x82, 0x82, 0x84, 0x85, 0x82, 0x80,
	0x7D, 0x7A, 0x76, 0x74, 0x76, 0x7C, 0x83, 0x84, 0x85, 0x87, 0x89, 0x89,
	0x85, 0x81, 0x7E, 0x7E, 0x7C, 0x7B, 0x78, 0x74, 0x6F, 0x6D, 0x70, 0x77,
	0x7F, 0x84, 0x89, 0x8D, 0x8F, 0x8D, 0x89, 0x86, 0x85, 0x87, 0x85, 0x85,
	0x83, 0x7F, 0x79, 0x73, 0x74, 0x7A, 0x84, 0x89, 0x8D, 0x8F, 0x90, 0x8C,
	0x83, 0x7C, 0x79, 0x7B, 0x7B, 0x7E, 0x7D, 0x7A, 0x74, 0x6F, 0x70, 0x74,
	0x7D, 0x84, 0x8B, 0x8F, 0x90, 0x8C, 0x83, 0x7D, 0x7A, 0x7C, 0x7D, 0x7F,
	0x7E, 0x7B, 0x75, 0x6F, 0x6F, 0x76, 0x81, 0x89, 0x8F, 0x92, 0x90, 0x8D,
	0x86, 0x81, 0x7E, 0x81, 0x81, 0x82, 0x81, 0x7E, 0x78, 0x75, 0x78, 0x7F,
	0x8A, 0x8F, 0x92, 0x92, 0x8F, 0x8A, 0x7E, 0x78, 0x76, 0x7A, 0x7A, 0x79,
	0x78, 0x77, 0x76, 0x72, 0x73, 0x7A, 0x87, 0x8F, 0x93, 0x94, 0x91, 0x8C,
	0x83, 0x7C, 0x77, 0x78, 0x7A, 0x7E, 0x81, 0x7E, 0x79, 0x73, 0x74, 0x79,
	0x82, 0x88, 0x8C, 0x90, 0x8E, 0x88, 0x7D, 0x75, 0x73, 0x76, 0x78, 0x79,
	0x7E, 0x80, 0x7F, 0x79, 0x74, 0x76, 0x80, 0x8A, 0x8F, 0x90, 0x8E, 0x8D,
	0x86, 0x7F, 0x7B, 0x7D, 0x81, 0x86, 0x8A, 0x87, 0x80, 0x77, 0x74, 0x76,
	0x7B, 0x82, 0x86, 0x8A, 0x88, 0x82, 0x79, 0x76, 0x78, 0x7E, 0x84, 0x86,
	0x87, 0x85, 0x7D, 0x72, 0x6B, 0x6F, 0x7B, 0x88, 0x8B, 0x89, 0x85, 0x84,
	0x80, 0x7C, 0x7A, 0x7F, 0x87, 0x8A, 0x88, 0x81, 0x7A, 0x72, 0x6F, 0x71,
	0x79, 0x84, 0x8C, 0x8F, 0x8E, 0x8A, 0x83, 0x81, 0x83, 0x86, 0x88, 0x88,
	0x88, 0x84, 0x7E, 0x74, 0x6D, 0x6F, 0x79, 0x83, 0x87, 0x87, 0x88, 0x89,
	0x86, 0x82, 0x7E, 0x81, 0x86, 0x86, 0x83, 0x7C, 0x77, 0x73, 0x72, 0x74,
	0x7B, 0x84, 0x8B, 0x8E, 0x8C, 0x8A, 0x87, 0x84, 0x84, 0x85, 0x84, 0x81,
	0x7E, 0x7A, 0x74, 0x6D, 0x6B, 0x6F, 0x79, 0x82, 0x87, 0x89, 0x8A, 0x89,
	0x86, 0x7F, 0x7B, 0x7D, 0x82, 0x84, 0x80, 0x78, 0x72, 0x70, 0x70, 0x75,
	0x7D, 0x88, 0x91, 0x96, 0x96, 0x93, 0x8E, 0x89, 0x86, 0x85, 0x86, 0x85,
	0x81, 0x7A, 0x72, 0x6B, 0x67, 0x6D, 0x78, 0x82, 0x88, 0x8B, 0x8D, 0x8D,
	0x8B, 0x87, 0x83, 0x81, 0x82, 0x7F, 0x7B, 0x76, 0x71, 0x6E, 0x6E, 0x71,
	0x78, 0x83, 0x8B, 0x8E, 0x8D, 0x8A, 0x88, 0x85, 0x82, 0x81, 0x81, 0x7E,
	0x7D, 0x7B, 0x78, 0x75, 0x73, 0x76, 0x81, 0x8A, 0x8F, 0x8F, 0x8F, 0x8D,
	0x89, 0x84, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x7C, 0x79, 0x76, 0x73, 0x73,
	0x79, 0x82, 0x8A, 0x8C, 0x8B, 0x87, 0x83, 0x7E, 0x7A, 0x79, 0x79, 0x7E,
	0x82, 0x83, 0x80, 0x7C, 0x79, 0x78, 0x7C, 0x83, 0x8A, 0x8D, 0x8D, 0x8B,
	0x86, 0x7F, 0x79, 0x79, 0x7B, 0x7E, 0x7E, 0x7E, 0x7E, 0x7B, 0x76, 0x73,
	0x76, 0x7D, 0x84, 0x87, 0x87, 0x86, 0x86, 0x83, 0x7D, 0x7B, 0x7D, 0x83,
	0x85, 0x86, 0x84, 0x81, 0x7F, 0x7D, 0x7C, 0x7D, 0x84, 0x8B, 0x8F, 0x8E,
	0x8A, 0x85, 0x82, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7B, 0x77, 0x74,
	0x75, 0x79, 0x80, 0x86, 0x89, 0x8A, 0x88, 0x84, 0x7D, 0x7A, 0x7D, 0x84,
	0x86, 0x83, 0x81, 0x7E, 0x7B, 0x76, 0x71, 0x71, 0x78, 0x82, 0x88, 0x87,
	0x87, 0x86, 0x84, 0x81, 0x7E, 0x81, 0x86, 0x8B, 0x8B, 0x87, 0x82, 0x7C,
	0x76, 0x73, 0x75, 0x7C, 0x85, 0x8B, 0x8B, 0x88, 0x84, 0x82, 0x80, 0x81,
	0x83, 0x86, 0x89, 0x87, 0x83, 0x7A, 0x73, 0x6E, 0x6E, 0x73, 0x7A, 0x82,
	0x85, 0x87, 0x87, 0x84, 0x82, 0x83, 0x87, 0x8B, 0x8C, 0x88, 0x84, 0x7E,
	0x78, 0x72, 0x70, 0x74, 0x79, 0x7E, 0x81, 0x82, 0x82, 0x7F, 0x7D, 0x7F,
	0x82, 0x86, 0x89, 0x88, 0x85, 0x81, 0x79, 0x73, 0x73, 0x77, 0x7C, 0x81,
	0x85, 0x85, 0x83, 0x83, 0x81, 0x81, 0x83, 0x88, 0x8B, 0x8D, 0x8C, 0x8B,
	0x89, 0x85, 0x7F, 0x7B, 0x7B, 0x7D, 0x7E, 0x7D, 0x7D, 0x7C, 0x79, 0x76,
	0x76, 0x7A, 0x7F, 0x86, 0x8A, 0x8C, 0x8C, 0x8B, 0x86, 0x7E, 0x79, 0x77,
	0x79, 0x7C, 0x7D, 0x7C, 0x79, 0x78, 0x74, 0x74, 0x78, 0x7F, 0x87, 0x8C,
	0x8F, 0x8E, 0x8C, 0x86, 0x80, 0x7D, 0x7A, 0x78, 0x79, 0x7C, 0x7D, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7D, 0x83, 0x89, 0x8F, 0x91, 0x90, 0x8D, 0x8B, 0x86,
	0x7F, 0x7B, 0x77, 0x76, 0x75, 0x77, 0x78, 0x78, 0x78, 0x79, 0x7B, 0x7E,
	0x84, 0x88, 0x8C, 0x8E, 0x8D, 0x8D, 0x8A, 0x83, 0x7A, 0x74, 0x73, 0x74,
	0x76, 0x79, 0x7B, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x85, 0x8A, 0x8C, 0x8C,
	0x8C, 0x88, 0x7F, 0x77, 0x72, 0x70, 0x72, 0x74, 0x77, 0x7B, 0x7F, 0x83,
	0x85, 0x85, 0x85, 0x85, 0x88, 0x8B, 0x8E, 0x8F, 0x8C, 0x86, 0x7F, 0x7C,
	0x79, 0x79, 0x7D, 0x81, 0x84, 0x83, 0x83, 0x81, 0x7E, 0x7C, 0x7A, 0x7C,
	0x7F, 0x84, 0x85, 0x85, 0x83, 0x80, 0x7D, 0x7D, 0x7D, 0x7F, 0x80, 0x81,
	0x81, 0x7E, 0x7C, 0x79, 0x78, 0x78, 0x7A, 0x7D, 0x80, 0x83, 0x84, 0x86,
	0x86, 0x82, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7C, 0x7A,
	0x7A, 0x7E, 0x84, 0x88, 0x88, 0x88, 0x8A, 0x8B, 0x8B, 0x86, 0x81, 0x80,
	0x81, 0x80, 0x7F, 0x7D, 0x7C, 0x7A, 0x78, 0x77, 0x78, 0x7C, 0x81, 0x84,
	0x87, 0x86, 0x87, 0x87, 0x88, 0x85, 0x81, 0x7F, 0x81, 0x81, 0x7E, 0x7B,
	0x7A, 0x79, 0x7A, 0x7A, 0x7A, 0x7E, 0x84, 0x87, 0x87, 0x85, 0x86, 0x88,
	0x8A, 0x87, 0x81, 0x7D, 0x7C, 0x7B, 0x79, 0x76, 0x74, 0x74, 0x76, 0x78,
	0x7A, 0x7D, 0x82, 0x85, 0x88, 0x8A, 0x8B, 0x8D, 0x90, 0x8F, 0x88, 0x83,
	0x7F, 0x7D, 0x7B, 0x79, 0x78, 0x7A, 0x7D, 0x7F, 0x7C, 0x79, 0x7A, 0x80,
	0x85, 0x88, 0x88, 0x8A, 0x8C, 0x8C, 0x85, 0x7D, 0x7B, 0x7B, 0x7C, 0x7B,
	0x79, 0x79, 0x79, 0x79, 0x76, 0x77, 0x7B, 0x81, 0x85, 0x89, 0x89, 0x88,
	0x88, 0x88, 0x84, 0x7C, 0x78, 0x78, 0x7A, 0x7A, 0x78, 0x77, 0x78, 0x7C,
	0x7E, 0x7E, 0x81, 0x87, 0x8D, 0x8E, 0x8D, 0x88, 0x88, 0x8A, 0x89, 0x83,
	0x7D, 0x7C, 0x7E, 0x7E, 0x7C, 0x7A, 0x7B, 0x7F, 0x81, 0x7F, 0x7E, 0x7E,
	0x81, 0x83, 0x84, 0x82, 0x82, 0x84, 0x87, 0x85, 0x7F, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7B, 0x7B, 0x7D, 0x81, 0x7F, 0x7C, 0x7B, 0x7E, 0x82, 0x83, 0x83,
	0x85, 0x8A, 0x8E, 0x8C, 0x84, 0x7D, 0x7A, 0x79, 0x79, 0x78, 0x77, 0x78,
	0x7A, 0x7A, 0x77, 0x77, 0x7B, 0x83, 0x89, 0x8D, 0x8F, 0x91, 0x92, 0x90,
	0x87, 0x7F, 0x7D, 0x7B, 0x7B, 0x7A, 0x79, 0x79, 0x7A, 0x7C, 0x7A, 0x79,
	0x7B, 0x83, 0x89, 0x8C, 0x8B, 0x8B, 0x8C, 0x8A, 0x83, 0x7A, 0x79, 0x79,
	0x7A, 0x78, 0x77, 0x77, 0x79, 0x7A, 0x79, 0x7B, 0x7F, 0x84, 0x89, 0x8A,
	0x89, 0x87, 0x86, 0x86, 0x81, 0x7A, 0x77, 0x77, 0x77, 0x77, 0x75, 0x76,
	0x79, 0x7D, 0x81, 0x82, 0x84, 0x88, 0x8C, 0x8C, 0x89, 0x88, 0x8A, 0x8D,
	0x8A, 0x82, 0x7C, 0x7B, 0x7B, 0x7A, 0x79, 0x7A, 0x7E, 0x82, 0x82, 0x80,
	0x7F, 0x7F, 0x82, 0x84, 0x85, 0x85, 0x87, 0x88, 0x85, 0x7E, 0x78, 0x78,
	0x7A, 0x7C, 0x7B, 0x7A, 0x7A, 0x7D, 0x80, 0x80, 0x7E, 0x7E, 0x82, 0x86,
	0x87, 0x87, 0x85, 0x88, 0x88, 0x83, 0x7C, 0x78, 0x78, 0x78, 0x76, 0x75,
	0x76, 0x7B, 0x7D, 0x7C, 0x7B, 0x7C, 0x81, 0x87, 0x8B, 0x8C, 0x8C, 0x8E,
	0x8D, 0x87, 0x80, 0x7C, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7D,
	0x7B, 0x7B, 0x7E, 0x84, 0x88, 0x89, 0x88, 0x88, 0x89, 0x86, 0x80, 0x7C,
	0x7C, 0x7E, 0x7F, 0x7D, 0x79, 0x78, 0x79, 0x78, 0x79, 0x7C, 0x7F, 0x84,
	0x86, 0x88, 0x87, 0x8A, 0x8C, 0x88, 0x83, 0x7E, 0x7A, 0x78, 0x76, 0x74,
	0x73, 0x73, 0x78, 0x7C, 0x7E, 0x81, 0x84, 0x89, 0x8E, 0x91, 0x91, 0x91,
	0x93, 0x8F, 0x87, 0x7F, 0x77, 0x74, 0x73, 0x74, 0x74, 0x77, 0x7C, 0x7F,
	0x7F, 0x7F, 0x81, 0x85, 0x89, 0x8C, 0x8C, 0x8C, 0x8D, 0x88, 0x7E, 0x76,
	0x70, 0x71, 0x74, 0x78, 0x7A, 0x7A, 0x7D, 0x80, 0x80, 0x81, 0x82, 0x86,
	0x8A, 0x8C, 0x8B, 0x88, 0x88, 0x85, 0x7F, 0x7A, 0x74, 0x73, 0x75, 0x79,
	0x7A, 0x76, 0x78, 0x7B, 0x7C, 0x7D, 0x7F, 0x85, 0x8A, 0x8D, 0x8C, 0x8B,
	0x8C, 0x8B, 0x85, 0x7F, 0x7B, 0x79, 0x7C, 0x7D, 0x7E, 0x7A, 0x7A, 0x7D,
	0x7E, 0x7F, 0x7F, 0x82, 0x86, 0x89, 0x89, 0x89, 0x8A, 0x8A, 0x85, 0x7F,
	0x79, 0x75, 0x78, 0x7A, 0x7D, 0x7B, 0x7A, 0x7C, 0x7C, 0x7E, 0x7E, 0x81,
	0x84, 0x89, 0x8B, 0x8B, 0x8C, 0x8A, 0x84, 0x7D, 0x78, 0x73, 0x74, 0x76,
	0x78, 0x78, 0x76, 0x78, 0x7A, 0x7E, 0x80, 0x85, 0x8A, 0x90, 0x93, 0x91,
	0x90, 0x8C, 0x86, 0x7F, 0x7B, 0x76, 0x75, 0x77, 0x7A, 0x7B, 0x7A, 0x7B,
	0x7D, 0x83, 0x86, 0x88, 0x8B, 0x8E, 0x8F, 0x8C, 0x8A, 0x87, 0x82, 0x7A,
	0x75, 0x70, 0x70, 0x74, 0x77, 0x7A, 0x7A, 0x7C, 0x7E, 0x81, 0x84, 0x88,
	0x8B, 0x8C, 0x8C, 0x89, 0x89, 0x86, 0x7F, 0x79, 0x76, 0x73, 0x71, 0x72,
	0x73, 0x77, 0x78, 0x7A, 0x7C, 0x7F, 0x83, 0x86, 0x89, 0x8B, 0x8D, 0x8D,
	0x8F, 0x8D, 0x88, 0x81, 0x7B, 0x77, 0x75, 0x77, 0x7A, 0x7E, 0x80, 0x81,
	0x81, 0x81, 0x83, 0x85, 0x88, 0x8A, 0x8C, 0x8C, 0x8D, 0x89, 0x7F, 0x77,
	0x73, 0x72, 0x72, 0x74, 0x77, 0x7B, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x86,
	0x8B, 0x8D, 0x8C, 0x89, 0x88, 0x85, 0x7D, 0x79, 0x77, 0x75, 0x75, 0x74,
	0x75, 0x76, 0x7A, 0x7C, 0x7B, 0x7F, 0x83, 0x89, 0x8D, 0x8E, 0x8C, 0x8B,
	0x8B, 0x8B, 0x85, 0x7E, 0x79, 0x76, 0x76, 0x75, 0x76, 0x77, 0x7B, 0x7E,
	0x7F, 0x83, 0x86, 0x8B, 0x8D, 0x8C, 0x89, 0x87, 0x88, 0x88, 0x82, 0x7B,
	0x76, 0x73, 0x71, 0x70, 0x71, 0x74, 0x7B, 0x82, 0x83, 0x85, 0x85, 0x88,
	0x8A, 0x8B, 0x8B, 0x8B, 0x8D, 0x8C, 0x84, 0x7A, 0x75, 0x71, 0x72, 0x71,
	0x72, 0x75, 0x78, 0x7B, 0x7B, 0x7D, 0x80, 0x86, 0x8B, 0x8E, 0x8F, 0x8E,
	0x8F, 0x8C, 0x86, 0x7F, 0x7B, 0x78, 0x78, 0x77, 0x77, 0x77, 0x78, 0x7D,
	0x7F, 0x82, 0x87, 0x8C, 0x91, 0x91, 0x8F, 0x8B, 0x8B, 0x88, 0x82, 0x7A,
	0x76, 0x72, 0x72, 0x71, 0x70, 0x74, 0x79, 0x80, 0x83, 0x87, 0x8A, 0x8D,
	0x8F, 0x8E, 0x8B, 0x87, 0x88, 0x85, 0x7E, 0x77, 0x72, 0x70, 0x71, 0x71,
	0x71, 0x75, 0x79, 0x7D, 0x81, 0x84, 0x87, 0x8C, 0x8E, 0x8C, 0x88, 0x86,
	0x88, 0x88, 0x83, 0x7E, 0x79, 0x75, 0x76, 0x77, 0x78, 0x7A, 0x7D, 0x81,
	0x83, 0x85, 0x88, 0x8B, 0x8C, 0x8B, 0x89, 0x89, 0x8B, 0x8A, 0x83, 0x7A,
	0x76, 0x74, 0x75, 0x75, 0x74, 0x75, 0x78, 0x7C, 0x7E, 0x81, 0x83, 0x88,
	0x8C, 0x8D, 0x8D, 0x8C, 0x8E, 0x8C, 0x85, 0x7D, 0x77, 0x73, 0x73, 0x73,
	0x72, 0x71, 0x73, 0x77, 0x78, 0x7A, 0x7E, 0x87, 0x8E, 0x91, 0x90, 0x8E,
	0x8F, 0x8E, 0x87, 0x7F, 0x79, 0x75, 0x75, 0x76, 0x74, 0x73, 0x75, 0x79,
	0x7C, 0x80, 0x85, 0x8F, 0x96, 0x97, 0x94, 0x90, 0x8E, 0x8B, 0x83, 0x7A,
	0x74, 0x70, 0x70, 0x70, 0x70, 0x70, 0x72, 0x7A, 0x7F, 0x86, 0x8A, 0x91,
	0x96, 0x94, 0x8F, 0x8A, 0x88, 0x86, 0x81, 0x79, 0x73, 0x6E, 0x6E, 0x6F,
	0x70, 0x72, 0x75, 0x7B, 0x81, 0x84, 0x84, 0x88, 0x8D, 0x8D, 0x8B, 0x86,
	0x86, 0x87, 0x85, 0x7E, 0x7B, 0x77, 0x76, 0x76, 0x77, 0x7A, 0x7C, 0x80,
	0x82, 0x84, 0x85, 0x88, 0x8E, 0x8F, 0x8E, 0x8A, 0x8A, 0x8C, 0x8A, 0x82,
	0x79, 0x74, 0x71, 0x71, 0x71, 0x72, 0x73, 0x76, 0x7A, 0x7C, 0x80, 0x84,
	0x8C, 0x90, 0x91, 0x8E, 0x8D, 0x8F, 0x8D, 0x84, 0x7A, 0x74, 0x70, 0x70,
	0x70, 0x70, 0x72, 0x76, 0x7A, 0x7A, 0x7D, 0x81, 0x8B, 0x91, 0x93, 0x8F,
	0x8B, 0x8C, 0x8C, 0x86, 0x7D, 0x78, 0x75, 0x75, 0x75, 0x74, 0x75, 0x77,
	0x7C, 0x7F, 0x82, 0x85, 0x8D, 0x93, 0x92, 0x8D, 0x86, 0x88, 0x8C, 0x89,
	0x7F, 0x77, 0x73, 0x71, 0x73, 0x72, 0x72, 0x75, 0x7A, 0x7E, 0x7F, 0x82,
	0x87, 0x8F, 0x90, 0x8E, 0x87, 0x87, 0x8D, 0x8D, 0x85, 0x79, 0x73, 0x70,
	0x71, 0x71, 0x70, 0x73, 0x77, 0x7A, 0x7A, 0x7B, 0x7E, 0x88, 0x8D, 0x8E,
	0x8A, 0x8A, 0x91, 0x93, 0x8C, 0x80, 0x77, 0x74, 0x74, 0x76, 0x73, 0x74,
	0x76, 0x7B, 0x7D, 0x80, 0x85, 0x8F, 0x96, 0x95, 0x92, 0x8D, 0x91, 0x95,
	0x8F, 0x81, 0x72, 0x6E, 0x6C, 0x6E, 0x6C, 0x6B, 0x6F, 0x74, 0x7C, 0x80,
	0x86, 0x8E, 0x97, 0x97, 0x93, 0x8D, 0x8D, 0x92, 0x8E, 0x83, 0x73, 0x6C,
	0x6A, 0x6B, 0x6D, 0x6C, 0x72, 0x77, 0x7F, 0x80, 0x82, 0x88, 0x8F, 0x91,
	0x8C, 0x88, 0x87, 0x8F, 0x91, 0x87, 0x79, 0x6D, 0x6F, 0x70, 0x78, 0x75,
	0x77, 0x79, 0x7E, 0x83, 0x83, 0x89, 0x8C, 0x90, 0x8B, 0x89, 0x8A, 0x91,
	0x96, 0x8A, 0x7C, 0x6E, 0x6F, 0x71, 0x75, 0x74, 0x6E, 0x72, 0x75, 0x7F,
	0x81, 0x87, 0x8C, 0x8F, 0x91, 0x8C, 0x8E, 0x8F, 0x95, 0x8D, 0x7C, 0x71,
	0x6B, 0x71, 0x6E, 0x70, 0x68, 0x6C, 0x75, 0x7E, 0x86, 0x83, 0x89, 0x89,
	0x8F, 0x90, 0x90, 0x92, 0x8F, 0x8E, 0x7D, 0x75, 0x6F, 0x73, 0x76, 0x72,
	0x71, 0x6F, 0x7C, 0x83, 0x8A, 0x89, 0x89, 0x8F, 0x90, 0x95, 0x8F, 0x8D,
	0x8C, 0x8C, 0x85, 0x78, 0x72, 0x6E, 0x72, 0x6E, 0x6E, 0x6E, 0x76, 0x81,
	0x85, 0x85, 0x85, 0x89, 0x8E, 0x8F, 0x8F, 0x8A, 0x8D, 0x8E, 0x8B, 0x7F,
	0x77, 0x72, 0x76, 0x74, 0x71, 0x70, 0x72, 0x7A, 0x7C, 0x7E, 0x7B, 0x7F,
	0x86, 0x8A, 0x8E, 0x8C, 0x8E, 0x91, 0x8F, 0x85, 0x7C, 0x77, 0x77, 0x77,
	0x73, 0x72, 0x71, 0x79, 0x7C, 0x7F, 0x7E, 0x82, 0x89, 0x8F, 0x93, 0x94,
	0x93, 0x95, 0x93, 0x88, 0x7B, 0x74, 0x71, 0x72, 0x6C, 0x6B, 0x6B, 0x71,
	0x79, 0x7B, 0x80, 0x85, 0x8F, 0x97, 0x99, 0x98, 0x93, 0x8F, 0x8E, 0x84,
	0x78, 0x71, 0x6B, 0x6D, 0x67, 0x66, 0x69, 0x6F, 0x7D, 0x80, 0x86, 0x8B,
	0x8F, 0x97, 0x96, 0x94, 0x90, 0x8A, 0x8B, 0x81, 0x76, 0x71, 0x6B, 0x70,
	0x6D, 0x6D, 0x72, 0x78, 0x85, 0x89, 0x8A, 0x8E, 0x92, 0x98, 0x96, 0x8F,
	0x8C, 0x8A, 0x8C, 0x84, 0x74, 0x70, 0x6B, 0x70, 0x6F, 0x6A, 0x70, 0x77,
	0x83, 0x86, 0x84, 0x88, 0x8E, 0x92, 0x93, 0x8B, 0x8B, 0x8E, 0x8E, 0x85,
	0x72, 0x70, 0x70, 0x75, 0x73, 0x6B, 0x6F, 0x77, 0x82, 0x80, 0x79, 0x7A,
	0x86, 0x8E, 0x8F, 0x8A, 0x8B, 0x90, 0x8D, 0x7F, 0x70, 0x73, 0x78, 0x7C,
	0x78, 0x71, 0x75, 0x7D, 0x81, 0x7D, 0x7A, 0x82, 0x93, 0x98, 0x95, 0x8D,
	0x8C, 0x8E, 0x8C, 0x7E, 0x75, 0x7A, 0x7D, 0x7C, 0x72, 0x6B, 0x70, 0x7A,
	0x7B, 0x79, 0x7B, 0x86, 0x94, 0x94, 0x90, 0x8B, 0x8E, 0x8F, 0x8A, 0x7B,
	0x74, 0x7A, 0x79, 0x77, 0x6E, 0x6B, 0x73, 0x78, 0x78, 0x78, 0x80, 0x8B,
	0x92, 0x91, 0x8C, 0x89, 0x8B, 0x88, 0x83, 0x7A, 0x79, 0x7D, 0x79, 0x76,
	0x70, 0x73, 0x78, 0x7C, 0x7F, 0x83, 0x8A, 0x8E, 0x8F, 0x8D, 0x8B, 0x8B,
	0x8D, 0x89, 0x83, 0x7D, 0x7C, 0x7B, 0x73, 0x70, 0x72, 0x75, 0x74, 0x77,
	0x7D, 0x81, 0x82, 0x84, 0x89, 0x8F, 0x90, 0x8B, 0x8A, 0x89, 0x86, 0x7E,
	0x78, 0x77, 0x78, 0x7A, 0x78, 0x77, 0x76, 0x77, 0x7B, 0x7E, 0x81, 0x84,
	0x8A, 0x8C, 0x8A, 0x86, 0x83, 0x81, 0x7D, 0x7B, 0x78, 0x78, 0x7A, 0x7B,
	0x7B, 0x7A, 0x77, 0x7A, 0x83, 0x88, 0x88, 0x87, 0x8B, 0x8F, 0x8C, 0x86,
	0x85, 0x86, 0x82, 0x7D, 0x7D, 0x7F, 0x7E, 0x7C, 0x7A, 0x79, 0x78, 0x7A,
	0x7F, 0x83, 0x85, 0x84, 0x87, 0x8A, 0x88, 0x86, 0x82, 0x81, 0x82, 0x81,
	0x7F, 0x7C, 0x79, 0x7C, 0x7D, 0x79, 0x75, 0x79, 0x81, 0x81, 0x81, 0x83,
	0x82, 0x84, 0x82, 0x82, 0x81, 0x7D, 0x7F, 0x80, 0x7E, 0x7E, 0x7E, 0x80,
	0x7F, 0x7E, 0x7E, 0x7F, 0x83, 0x86, 0x86, 0x83, 0x81, 0x87, 0x88, 0x84,
	0x81, 0x84, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x7E, 0x7B, 0x7A, 0x77,
	0x79, 0x7D, 0x7E, 0x78, 0x7B, 0x85, 0x7E, 0x83, 0x89, 0x84, 0x8B, 0x8E,
	0x86, 0x81, 0x7B, 0x80, 0x81, 0x74, 0x74, 0x7B, 0x7D, 0x73, 0x78, 0x81,
	0x7B, 0x83, 0x82, 0x90, 0x8B, 0x7F, 0x86, 0x88, 0x88, 0x74, 0x79, 0x7E,
	0x80, 0x7D, 0x6E, 0x79, 0x7F, 0x7F, 0x80, 0x83, 0x8A, 0x82, 0x90, 0x8D,
	0x89, 0x89, 0x7F, 0x89, 0x88, 0x78, 0x7D, 0x7A, 0x8A, 0x77, 0x75, 0x7C,
	0x7E, 0x84, 0x74, 0x84, 0x89, 0x7E, 0x84, 0x85, 0x8A, 0x7C, 0x82, 0x7D,
	0x87, 0x81, 0x74, 0x7F, 0x81, 0x7B, 0x7A, 0x7B, 0x7F, 0x78, 0x85, 0x7B,
	0x82, 0x85, 0x7A, 0x8F, 0x82, 0x7E, 0x7B, 0x87, 0x88, 0x79, 0x7E, 0x70,
	0x87, 0x7C, 0x72, 0x7B, 0x7A, 0x7D, 0x82, 0x7F, 0x84, 0x87, 0x81, 0x88,
	0x93, 0x81, 0x81, 0x96, 0x7B, 0x88, 0x81, 0x73, 0x89, 0x7E, 0x78, 0x7C,
	0x77, 0x7D, 0x79, 0x83, 0x7E, 0x7F, 0x86, 0x83, 0x8F, 0x7D, 0x7D, 0x89,
	0x84, 0x7F, 0x7A, 0x7F, 0x7F, 0x7A, 0x81, 0x78, 0x7E, 0x7A, 0x82, 0x86,
	0x7D, 0x80, 0x8B, 0x82, 0x85, 0x82, 0x81, 0x7D, 0x85, 0x7C, 0x7A, 0x77,
	0x7A, 0x81, 0x7A, 0x79, 0x7C, 0x80, 0x81, 0x83, 0x88, 0x85, 0x7D, 0x8C,
	0x84, 0x85, 0x7E, 0x84, 0x88, 0x80, 0x80, 0x7C, 0x84, 0x82, 0x82, 0x81,
	0x7B, 0x7D, 0x81, 0x83, 0x7D, 0x7D, 0x7E, 0x83, 0x84, 0x82, 0x7A, 0x87,
	0x86, 0x86, 0x7E, 0x7C, 0x85, 0x7B, 0x83, 0x7A, 0x7D, 0x78, 0x78, 0x87,
	0x7B, 0x80, 0x7B, 0x88, 0x88, 0x82, 0x88, 0x80, 0x89, 0x82, 0x7D, 0x79,
	0x77, 0x78, 0x81, 0x70, 0x77, 0x78, 0x7B, 0x83, 0x86, 0x85, 0x81, 0x89,
	0x8F, 0x87, 0x8B, 0x81, 0x8E, 0x82, 0x7D, 0x7E, 0x75, 0x7E, 0x75, 0x87,
	0x76, 0x79, 0x7F, 0x87, 0x83, 0x7E, 0x85, 0x83, 0x8E, 0x87, 0x7D, 0x88,
	0x81, 0x7F, 0x86, 0x78, 0x79, 0x78, 0x82, 0x7B, 0x79, 0x7F, 0x77, 0x8C,
	0x7B, 0x81, 0x84, 0x7B, 0x8C, 0x83, 0x83, 0x81, 0x88, 0x85, 0x7E, 0x7D,
	0x74, 0x7B, 0x7E, 0x7E, 0x7D, 0x7D, 0x7B, 0x86, 0x7D, 0x7F, 0x7C, 0x84,
	0x81, 0x8A, 0x85, 0x7C, 0x89, 0x82, 0x82, 0x7F, 0x77, 0x7F, 0x86, 0x86,
	0x7B, 0x7E, 0x83, 0x79, 0x86, 0x7C, 0x80, 0x84, 0x88, 0x87, 0x82, 0x85,
	0x82, 0x82, 0x85, 0x79, 0x84, 0x74, 0x82, 0x81, 0x77, 0x7B, 0x78, 0x7F,
	0x82, 0x7D, 0x81, 0x89, 0x84, 0x8B, 0x89, 0x85, 0x87, 0x85, 0x85, 0x7A,
	0x7C, 0x79, 0x74, 0x7C, 0x7C, 0x6F, 0x78, 0x7F, 0x7E, 0x83, 0x81, 0x8B,
	0x87, 0x88, 0x87, 0x8C, 0x80, 0x83, 0x88, 0x81, 0x75, 0x77, 0x81, 0x79,
	0x7C, 0x77, 0x7D, 0x80, 0x81, 0x7F, 0x88, 0x7E, 0x81, 0x8F, 0x85, 0x83,
	0x82, 0x85, 0x85, 0x7F, 0x7B, 0x7D, 0x7A, 0x7E, 0x7F, 0x75, 0x7E, 0x7C,
	0x82, 0x82, 0x83, 0x7E, 0x86, 0x85, 0x89, 0x88, 0x85, 0x87, 0x82, 0x83,
	0x7B, 0x76, 0x76, 0x83, 0x73, 0x81, 0x72, 0x7B, 0x86, 0x77, 0x87, 0x83,
	0x87, 0x86, 0x8F, 0x84, 0x85, 0x7B, 0x86, 0x7E, 0x75, 0x7C, 0x78, 0x7A,
	0x81, 0x75, 0x7E, 0x7C, 0x7E, 0x8E, 0x7E, 0x8D, 0x86, 0x87, 0x88, 0x88,
	0x7B, 0x7C, 0x85, 0x79, 0x7D, 0x7A, 0x75, 0x7E, 0x79, 0x7D, 0x7B, 0x7E,
	0x82, 0x8D, 0x81, 0x8A, 0x80, 0x84, 0x86, 0x82, 0x81, 0x7F, 0x80, 0x83,
	0x7E, 0x75, 0x75, 0x82, 0x7E, 0x7F, 0x82, 0x83, 0x7E, 0x87, 0x86, 0x85,
	0x82, 0x84, 0x85, 0x86, 0x7D, 0x7E, 0x84, 0x7F, 0x7B, 0x7E, 0x78, 0x81,
	0x83, 0x81, 0x7B, 0x81, 0x7C, 0x80, 0x84, 0x7C, 0x7D, 0x81, 0x81, 0x86,
	0x80, 0x7E, 0x82, 0x85, 0x7B, 0x7C, 0x82, 0x7E, 0x87, 0x83, 0x7B, 0x7C,
	0x7B, 0x78, 0x80, 0x82, 0x7D, 0x7F, 0x8A, 0x8A, 0x83, 0x81, 0x83, 0x84,
	0x87, 0x7D, 0x86, 0x7F, 0x7F, 0x84, 0x7A, 0x72, 0x7A, 0x7A, 0x81, 0x84,
	0x7F, 0x89, 0x87, 0x86, 0x83, 0x7D, 0x82, 0x83, 0x85, 0x80, 0x77, 0x80,
	0x7C, 0x78, 0x7F, 0x75, 0x77, 0x85, 0x7F, 0x88, 0x8B, 0x7D, 0x87, 0x8C,
	0x7D, 0x83, 0x7F, 0x80, 0x85, 0x78, 0x7C, 0x7C, 0x77, 0x81, 0x7D, 0x77,
	0x7B, 0x7F, 0x85, 0x8A, 0x81, 0x84, 0x82, 0x82, 0x88, 0x7F, 0x7E, 0x88,
	0x81, 0x81, 0x79, 0x75, 0x82, 0x7F, 0x78, 0x85, 0x7C, 0x7E, 0x89, 0x84,
	0x85, 0x7F, 0x88, 0x84, 0x8B, 0x84, 0x7D, 0x87, 0x7D, 0x7A, 0x7E, 0x7A,
	0x7A, 0x8B, 0x7B, 0x7B, 0x83, 0x79, 0x84, 0x87, 0x7E, 0x86, 0x83, 0x84,
	0x85, 0x83, 0x79, 0x7F, 0x7F, 0x79, 0x7C, 0x7B, 0x81, 0x85, 0x7C, 0x7E,
	0x81, 0x7A, 0x7E, 0x8A, 0x82, 0x7E, 0x85, 0x86, 0x81, 0x7E, 0x7D, 0x7E,
	0x83, 0x80, 0x82, 0x7C, 0x7F, 0x87, 0x7C, 0x85, 0x76, 0x82, 0x86, 0x7F,
	0x83, 0x86, 0x7A, 0x88, 0x7D, 0x82, 0x81, 0x7C, 0x83, 0x81, 0x7C, 0x80,
	0x7B, 0x81, 0x84, 0x7D, 0x82, 0x7C, 0x85, 0x84, 0x7B, 0x84, 0x7A, 0x85,
	0x83, 0x80, 0x82, 0x83, 0x7B, 0x87, 0x79, 0x81, 0x7A, 0x88, 0x84, 0x7F,
	0x7F, 0x7D, 0x7C, 0x7B, 0x7D, 0x7F, 0x7C, 0x89, 0x83, 0x88, 0x82, 0x7D,
	0x89, 0x81, 0x83, 0x81, 0x7F, 0x86, 0x7E, 0x7C, 0x76, 0x76, 0x77, 0x7E,
	0x7E, 0x85, 0x82, 0x89, 0x8D, 0x89, 0x83, 0x86, 0x86, 0x85, 0x81, 0x7C,
	0x7C, 0x81, 0x74, 0x7F, 0x79, 0x70, 0x7C, 0x85, 0x7F, 0x86, 0x85, 0x8A,
	0x8C, 0x87, 0x84, 0x84, 0x81, 0x7E, 0x7C, 0x7B, 0x73, 0x7F, 0x7A, 0x7F,
	0x76, 0x74, 0x7F, 0x82, 0x82, 0x86, 0x83, 0x8B, 0x8C, 0x83, 0x80, 0x81,
	0x79, 0x84, 0x7B, 0x7B, 0x7C, 0x7A, 0x83, 0x7D, 0x77, 0x7C, 0x7F, 0x85,
	0x85, 0x86, 0x87, 0x85, 0x8C, 0x85, 0x7C, 0x84, 0x7C, 0x7B, 0x80, 0x79,
	0x75, 0x81, 0x82, 0x79, 0x81, 0x79, 0x7A, 0x8C, 0x85, 0x88, 0x88, 0x88,
	0x87, 0x88, 0x83, 0x72, 0x86, 0x7B, 0x75, 0x82, 0x71, 0x7E, 0x85, 0x7F,
	0x79, 0x7E, 0x7C, 0x86, 0x88, 0x84, 0x88, 0x86, 0x83, 0x88, 0x81, 0x7B,
	0x7B, 0x82, 0x79, 0x7E, 0x7C, 0x7C, 0x89, 0x7D, 0x78, 0x7E, 0x75, 0x87,
	0x89, 0x7F, 0x87, 0x86, 0x86, 0x85, 0x88, 0x7A, 0x7D, 0x86, 0x7D, 0x7A,
	0x7F, 0x7C, 0x7D, 0x85, 0x77, 0x77, 0x7B, 0x81, 0x85, 0x87, 0x7C, 0x88,
	0x85, 0x84, 0x88, 0x7A, 0x7F, 0x7F, 0x7F, 0x7B, 0x77, 0x7D, 0x82, 0x85,
	0x77, 0x7E, 0x7B, 0x7A, 0x8D, 0x7F, 0x7D, 0x87, 0x87, 0x85, 0x8D, 0x77,
	0x82, 0x7D, 0x82, 0x7D, 0x7B, 0x81, 0x85, 0x82, 0x83, 0x71, 0x76, 0x7E,
	0x82, 0x81, 0x87, 0x7B, 0x8A, 0x8E, 0x7D, 0x88, 0x7B, 0x7B, 0x8B, 0x75,
	0x7A, 0x85, 0x78, 0x8A, 0x78, 0x6F, 0x7F, 0x72, 0x8B, 0x87, 0x82, 0x88,
	0x8A, 0x91, 0x83, 0x7F, 0x88, 0x79, 0x85, 0x7A, 0x75, 0x7E, 0x7D, 0x7D,
	0x7C, 0x75, 0x76, 0x81, 0x8A, 0x85, 0x89, 0x85, 0x87, 0x8F, 0x86, 0x82,
	0x7F, 0x7F, 0x7D, 0x79, 0x76, 0x75, 0x7F, 0x82, 0x7A, 0x79, 0x76, 0x81,
	0x82, 0x88, 0x88, 0x83, 0x88, 0x8E, 0x8D, 0x81, 0x83, 0x83, 0x79, 0x81,
	0x76, 0x77, 0x83, 0x7D, 0x83, 0x7D, 0x6E, 0x81, 0x89, 0x81, 0x84, 0x8A,
	0x87, 0x8C, 0x91, 0x7D, 0x82, 0x7E, 0x78, 0x82, 0x70, 0x77, 0x7E, 0x83,
	0x7F, 0x77, 0x78, 0x7B, 0x81, 0x89, 0x83, 0x84, 0x8A, 0x8E, 0x88, 0x83,
	0x81, 0x78, 0x7E, 0x7C, 0x77, 0x7C, 0x7C, 0x87, 0x86, 0x74, 0x78, 0x7A,
	0x82, 0x8A, 0x85, 0x8A, 0x87, 0x8A, 0x8C, 0x83, 0x77, 0x82, 0x81, 0x77,
	0x81, 0x74, 0x7C, 0x88, 0x7B, 0x7D, 0x78, 0x79, 0x86, 0x87, 0x83, 0x8B,
	0x87, 0x89, 0x8C, 0x81, 0x83, 0x7A, 0x79, 0x84, 0x72, 0x76, 0x81, 0x7C,
	0x83, 0x7E, 0x70, 0x84, 0x7C, 0x87, 0x8C, 0x83, 0x87, 0x8C, 0x85, 0x88,
	0x7E, 0x7A, 0x7E, 0x80, 0x74, 0x79, 0x7C, 0x7C, 0x8A, 0x7A, 0x74, 0x7C,
	0x7C, 0x85, 0x87, 0x7E, 0x8A, 0x86, 0x8A, 0x88, 0x7B, 0x7E, 0x83, 0x7D,
	0x7C, 0x7E, 0x7E, 0x81, 0x81, 0x7B, 0x7A, 0x72, 0x79, 0x8B, 0x7F, 0x85,
	0x86, 0x87, 0x8D, 0x81, 0x85, 0x7E, 0x81, 0x7C, 0x83, 0x7A, 0x75, 0x86,
	0x78, 0x7C, 0x78, 0x70, 0x8B, 0x7B, 0x8B, 0x8A, 0x7F, 0x8A, 0x85, 0x86,
	0x82, 0x7E, 0x81, 0x81, 0x7C, 0x7B, 0x7C, 0x7B, 0x7F, 0x7D, 0x7E, 0x7A,
	0x7F, 0x86, 0x85, 0x84, 0x8A, 0x7D, 0x88, 0x85, 0x7E, 0x81, 0x7A, 0x7C,
	0x81, 0x7A, 0x79, 0x7F, 0x7B, 0x7C, 0x80, 0x7D, 0x82, 0x86, 0x85, 0x87,
	0x85, 0x7D, 0x86, 0x85, 0x7D, 0x86, 0x78, 0x7D, 0x81, 0x72, 0x7D, 0x7B,
	0x7C, 0x7E, 0x81, 0x7E, 0x81, 0x80, 0x82, 0x88, 0x81, 0x88, 0x85, 0x86,
	0x88, 0x82, 0x80, 0x80, 0x78, 0x81, 0x84, 0x7B, 0x88, 0x82, 0x81, 0x86,
	0x78, 0x7D, 0x7D, 0x7B, 0x82, 0x7C, 0x7E, 0x81, 0x7E, 0x7D, 0x79, 0x7B,
	0x7B, 0x7F, 0x83, 0x7F, 0x82, 0x81, 0x81, 0x82, 0x7B, 0x7F, 0x80, 0x80,
	0x82, 0x81, 0x82, 0x86, 0x88, 0x84, 0x81, 0x7E, 0x83, 0x84, 0x7F, 0x7E,
	0x7F, 0x7D, 0x7B, 0x7B, 0x7A, 0x7C, 0x7E, 0x81, 0x82, 0x84, 0x7F, 0x87,
	0x89, 0x83, 0x85, 0x82, 0x84, 0x81, 0x84, 0x85, 0x80, 0x88, 0x83, 0x85,
	0x84, 0x7D, 0x81, 0x82, 0x7C, 0x7F, 0x81, 0x81, 0x88, 0x86, 0x82, 0x7E,
	0x7B, 0x7C, 0x79, 0x7D, 0x79, 0x7A, 0x80, 0x7A, 0x76, 0x7C, 0x77, 0x7C,
	0x7E, 0x7D, 0x81, 0x82, 0x88, 0x84, 0x81, 0x80, 0x7E, 0x80, 0x7D, 0x7A,
	0x7F, 0x7F, 0x7B, 0x7A, 0x79, 0x7C, 0x81, 0x84, 0x88, 0x88, 0x8A, 0x90,
	0x90, 0x8B, 0x8A, 0x8A, 0x84, 0x80, 0x81, 0x82, 0x7E, 0x7F, 0x82, 0x7E,
	0x7C, 0x7D, 0x7B, 0x7D, 0x81, 0x7E, 0x82, 0x83, 0x80, 0x7F, 0x7D, 0x79,
	0x7B, 0x79, 0x7A, 0x7C, 0x7D, 0x82, 0x84, 0x83, 0x81, 0x82, 0x83, 0x86,
	0x88, 0x87, 0x87, 0x83, 0x87, 0x88, 0x7F, 0x80, 0x81, 0x7D, 0x7E, 0x7A,
	0x7D, 0x7C, 0x78, 0x7B, 0x77, 0x75, 0x79, 0x7E, 0x79, 0x7A, 0x7B, 0x7B,
	0x7F, 0x7E, 0x7F, 0x82, 0x83, 0x85, 0x87, 0x87, 0x84, 0x85, 0x87, 0x87,
	0x87, 0x87, 0x89, 0x88, 0x8A, 0x87, 0x86, 0x85, 0x89, 0x89, 0x86, 0x81,
	0x81, 0x7B, 0x77, 0x77, 0x78, 0x77, 0x7E, 0x83, 0x7F, 0x81, 0x83, 0x82,
	0x81, 0x7C, 0x7F, 0x7B, 0x7A, 0x78, 0x71, 0x6C, 0x72, 0x76, 0x72, 0x7D,
	0x84, 0x82, 0x8B, 0x93, 0x8B, 0x8C, 0x8C, 0x7F, 0x80, 0x81, 0x76, 0x75,
	0x79, 0x76, 0x7C, 0x85, 0x83, 0x8C, 0x95, 0x97, 0x9A, 0x9B, 0x94, 0x95,
	0x88, 0x74, 0x76, 0x6A, 0x66, 0x65, 0x5C, 0x63, 0x7A, 0x81, 0x71, 0x7F,
	0x96, 0x91, 0x84, 0x94, 0xA0, 0x94, 0x77, 0x77, 0x85, 0x68, 0x60, 0x64,
	0x6E, 0x75, 0x84, 0x86, 0x8A, 0xA2, 0xA4, 0x98, 0x97, 0xA7, 0xA4, 0x8C,
	0x72, 0x7D, 0x7B, 0x4F, 0x59, 0x61, 0x57, 0x5E, 0x73, 0x7A, 0x7F, 0x8B,
	0x92, 0x93, 0x93, 0x97, 0x90, 0x8C, 0x7A, 0x74, 0x7E, 0x60, 0x6A, 0x79,
	0x6A, 0x6E, 0x8A, 0x90, 0x8A, 0x9A, 0xA3, 0xA2, 0x9C, 0x9E, 0xA0, 0x97,
	0x7F, 0x6D, 0x7C, 0x68, 0x5F, 0x71, 0x67, 0x68, 0x7D, 0x7D, 0x78, 0x88,
	0x91, 0x8D, 0x8B, 0x92, 0x90, 0x8A, 0x7F, 0x66, 0x74, 0x6A, 0x55, 0x6F,
	0x6D, 0x62, 0x75, 0x87, 0x7B, 0x84, 0x90, 0x90, 0x91, 0x95, 0x99, 0x98,
	0x96, 0x7A, 0x83, 0x8A, 0x6A, 0x7A, 0x7E, 0x70, 0x7E, 0x93, 0x89, 0x8A,
	0x92, 0x87, 0x89, 0x90, 0x91, 0x91, 0x86, 0x71, 0x68, 0x72, 0x62, 0x64,
	0x61, 0x48, 0x50, 0x66, 0x6A, 0x72, 0x8B, 0x93, 0x98, 0x9B, 0x9A, 0xA3,
	0xA8, 0x97, 0x8F, 0xA6, 0x90, 0x82, 0x94, 0x92, 0x87, 0x96, 0x95, 0x88,
	0x8D, 0x8B, 0x8E, 0x90, 0x8D, 0x8E, 0x80, 0x76, 0x5E, 0x6A, 0x65, 0x46,
	0x5D, 0x5B, 0x52, 0x63, 0x75, 0x72, 0x76, 0x7B, 0x7E, 0x83, 0x85, 0x86,
	0x80, 0x7F, 0x6C, 0x6F, 0x7B, 0x64, 0x75, 0x86, 0x7A, 0x84, 0x98, 0x8B,
	0x8B, 0x96, 0x98, 0x98, 0x95, 0x9C, 0x9D, 0x9D, 0x89, 0x7B, 0x8D, 0x72,
	0x77, 0x8C, 0x7E, 0x7F, 0x92, 0x90, 0x8C, 0x98, 0x97, 0x93, 0x94, 0x95,
	0x92, 0x8E, 0x79, 0x5F, 0x6E, 0x5B, 0x4E, 0x61, 0x59, 0x59, 0x74, 0x7F,
	0x78, 0x87, 0x8D, 0x88, 0x90, 0x91, 0x91, 0x8D, 0x85, 0x6E, 0x79, 0x78,
	0x64, 0x74, 0x6B, 0x5E, 0x73, 0x87, 0x84, 0x83, 0x8A, 0x89, 0x8A, 0x8A,
	0x85, 0x7B, 0x78, 0x60, 0x61, 0x6C, 0x4D, 0x58, 0x64, 0x59, 0x69, 0x81,
	0x7A, 0x83, 0x97, 0x9B, 0x9D, 0x9F, 0xA6, 0xA0, 0x9D, 0x89, 0x81, 0x93,
	0x76, 0x7C, 0x8D, 0x81, 0x89, 0x9F, 0x99, 0x91, 0xA1, 0xA7, 0xA9, 0xA8,
	0xAA, 0xA8, 0xA5, 0x97, 0x7B, 0x86, 0x6B, 0x5D, 0x70, 0x5E, 0x5E, 0x75,
	0x76, 0x6F, 0x81, 0x85, 0x84, 0x8B, 0x92, 0x99, 0x96, 0x8F, 0x74, 0x81,
	0x72, 0x56, 0x6E, 0x6F, 0x67, 0x7B, 0x84, 0x7F, 0x89, 0x91, 0x89, 0x8C,
	0x8C, 0x8D, 0x89, 0x84, 0x66, 0x65, 0x6A, 0x4D, 0x60, 0x5E, 0x4D, 0x5E,
	0x70, 0x68, 0x6C, 0x7D, 0x7E, 0x85, 0x87, 0x86, 0x7F, 0x83, 0x6F, 0x64,
	0x78, 0x5C, 0x64, 0x7A, 0x6B, 0x74, 0x8B, 0x84, 0x8A, 0x9B, 0x9F, 0xA7,
	0xAF, 0xB9, 0xB2, 0xAB, 0x9D, 0x84, 0x97, 0x87, 0x7B, 0x94, 0x85, 0x82,
	0x9A, 0x97, 0x88, 0x97, 0x96, 0x96, 0x9B, 0x9C, 0x9F, 0x99, 0x90, 0x71,
	0x7B, 0x77, 0x5F, 0x7A, 0x71, 0x6A, 0x80, 0x87, 0x80, 0x85, 0x8A, 0x89,
	0x8E, 0x8F, 0x8A, 0x83, 0x7E, 0x64, 0x68, 0x72, 0x50, 0x63, 0x6D, 0x5D,
	0x71, 0x81, 0x70, 0x72, 0x7D, 0x7B, 0x7D, 0x76, 0x7A, 0x77, 0x71, 0x5E,
	0x58, 0x6C, 0x4B, 0x51, 0x5D, 0x51, 0x5D, 0x75, 0x74, 0x70, 0x7D, 0x80,
	0x88, 0x8C, 0x8B, 0x87, 0x88, 0x7B, 0x6B, 0x86, 0x6E, 0x70, 0x8B, 0x7A,
	0x79, 0x93, 0x95, 0x8F, 0xA0, 0xA5, 0xA6, 0xA8, 0xAC, 0xAE, 0xA8, 0x99,
	0x7E, 0x90, 0x84, 0x71, 0x8E, 0x88, 0x7F, 0x96, 0x96, 0x86, 0x8F, 0x98,
	0x9C, 0x9E, 0xA0, 0xA2, 0x9B, 0x90, 0x71, 0x7C, 0x77, 0x5D, 0x77, 0x73,
	0x67, 0x83, 0x93, 0x86, 0x8D, 0x93, 0x90, 0x96, 0x97, 0x98, 0x91, 0x87,
	0x6A, 0x6B, 0x6D, 0x4B, 0x5F, 0x64, 0x56, 0x65, 0x71, 0x68, 0x66, 0x70,
	0x6F, 0x73, 0x74, 0x7B, 0x79, 0x73, 0x5E, 0x5C, 0x71, 0x53, 0x62, 0x70,
	0x60, 0x6D, 0x84, 0x82, 0x86, 0x97, 0x99, 0x9F, 0x9E, 0x9B, 0x96, 0x93,
	0x7E, 0x70, 0x87, 0x70, 0x76, 0x8E, 0x7B, 0x83, 0x9B, 0x98, 0x93, 0x9C,
	0x9F, 0xA4, 0xA6, 0xAA, 0xA4, 0x9E, 0x89, 0x71, 0x8A, 0x75, 0x71, 0x8D,
	0x7D, 0x83, 0x96, 0x92, 0x8B, 0x96, 0x95, 0x95, 0x98, 0x9B, 0x97, 0x90,
	0x81, 0x62, 0x75, 0x64, 0x55, 0x72, 0x68, 0x68, 0x7F, 0x83, 0x77, 0x7B,
	0x79, 0x7C, 0x79, 0x79, 0x78, 0x71, 0x67, 0x4E, 0x60, 0x57, 0x43, 0x63,
	0x62, 0x62, 0x78, 0x82, 0x7A, 0x7F, 0x84, 0x83, 0x89, 0x8C, 0x90, 0x8B,
	0x82, 0x70, 0x7D, 0x7E, 0x6D, 0x86, 0x83, 0x7C, 0x92, 0x9B, 0x93, 0x97,
	0x99, 0x9D, 0x9E, 0x98, 0x9E, 0x94, 0x8A, 0x6F, 0x76, 0x7C, 0x62, 0x7F,
	0x82, 0x77, 0x87, 0x91, 0x8D, 0x90, 0x92, 0x8E, 0x95, 0x92, 0x9A, 0x93,
	0x88, 0x6F, 0x6F, 0x7A, 0x5A, 0x73, 0x7C, 0x6F, 0x83, 0x8B, 0x85, 0x87,
	0x8B, 0x8B, 0x8E, 0x88, 0x90, 0x8C, 0x84, 0x6B, 0x67, 0x75, 0x56, 0x6B,
	0x76, 0x67, 0x79, 0x8A, 0x81, 0x7E, 0x83, 0x7E, 0x88, 0x83, 0x8B, 0x91,
	0x8A, 0x72, 0x70, 0x84, 0x5B, 0x68, 0x78, 0x63, 0x77, 0x8A, 0x82, 0x83,
	0x8A, 0x87, 0x8F, 0x8D, 0x98, 0xA0, 0x97, 0x85, 0x7D, 0x91, 0x6C, 0x73,
	0x88, 0x6C, 0x79, 0x8B, 0x84, 0x83, 0x8B, 0x84, 0x88, 0x87, 0x89, 0x91,
	0x88, 0x78, 0x6B, 0x7E, 0x5F, 0x5C, 0x7B, 0x64, 0x6B, 0x7F, 0x7C, 0x7E,
	0x8B, 0x8A, 0x90, 0x92, 0x92, 0x9A, 0x96, 0x84, 0x72, 0x8F, 0x73, 0x69,
	0x8B, 0x73, 0x78, 0x8D, 0x85, 0x7C, 0x82, 0x7D, 0x81, 0x82, 0x81, 0x8E,
	0x8A, 0x7A, 0x62, 0x7E, 0x6D, 0x5A, 0x86, 0x75, 0x72, 0x8C, 0x8C, 0x83,
	0x8B, 0x88, 0x83, 0x86, 0x88, 0x94, 0x93, 0x88, 0x70, 0x8A, 0x7A, 0x5F,
	0x89, 0x79, 0x71, 0x8D, 0x8F, 0x82, 0x8F, 0x8E, 0x8A, 0x91, 0x8E, 0x95,
	0x98, 0x8C, 0x6D, 0x81, 0x79, 0x5A, 0x7F, 0x79, 0x69, 0x85, 0x8A, 0x7E,
	0x87, 0x8B, 0x85, 0x87, 0x89, 0x8C, 0x8C, 0x84, 0x62, 0x72, 0x76, 0x4F,
	0x73, 0x75, 0x65, 0x82, 0x8E, 0x81, 0x8B, 0x93, 0x8D, 0x90, 0x8D, 0x95,
	0x92, 0x86, 0x61, 0x6C, 0x74, 0x4C, 0x67, 0x70, 0x5F, 0x73, 0x87, 0x79,
	0x7D, 0x86, 0x7D, 0x7C, 0x7D, 0x86, 0x86, 0x84, 0x67, 0x6B, 0x7D, 0x56,
	0x6E, 0x7E, 0x6C, 0x85, 0x9B, 0x93, 0x97, 0xA2, 0xA0, 0xA2, 0xA0, 0xAA,
	0xAC, 0xAB, 0x92, 0x86, 0x9E, 0x71, 0x78, 0x8C, 0x71, 0x7C, 0x91, 0x89,
	0x84, 0x8F, 0x8D, 0x8F, 0x8E, 0x97, 0x98, 0x94, 0x7F, 0x6D, 0x83, 0x5E,
	0x5D, 0x78, 0x65, 0x6A, 0x7F, 0x7A, 0x73, 0x81, 0x81, 0x7F, 0x7E, 0x89,
	0x8C, 0x8B, 0x7D, 0x63, 0x7D, 0x5D, 0x52, 0x76, 0x63, 0x65, 0x7E, 0x7C,
	0x73, 0x81, 0x86, 0x86, 0x85, 0x8A, 0x8D, 0x8A, 0x7C, 0x5F, 0x77, 0x65,
	0x53, 0x76, 0x6A, 0x64, 0x7E, 0x82, 0x76, 0x83, 0x86, 0x87, 0x88, 0x8A,
	0x96, 0x95, 0x8E, 0x6F, 0x83, 0x7E, 0x67, 0x90, 0x8B, 0x84, 0x9D, 0xA4,
	0x9B, 0xA0, 0xA3, 0xA5, 0x9F, 0x9F, 0xAA, 0xA2, 0x9C, 0x79, 0x88, 0x83,
	0x62, 0x84, 0x7F, 0x77, 0x8B, 0x94, 0x86, 0x8A, 0x8E, 0x8A, 0x87, 0x82,
	0x8D, 0x88, 0x82, 0x60, 0x69, 0x74, 0x4F, 0x6D, 0x75, 0x69, 0x86, 0x92,
	0x89, 0x8A, 0x90, 0x8F, 0x8D, 0x81, 0x88, 0x86, 0x7C, 0x5F, 0x5B, 0x6B,
	0x45, 0x5A, 0x69, 0x56, 0x6A, 0x7D, 0x75, 0x76, 0x84, 0x81, 0x86, 0x7B,
	0x83, 0x88, 0x7E, 0x64, 0x5E, 0x73, 0x50, 0x61, 0x76, 0x68, 0x7C, 0x91,
	0x8D, 0x90, 0x9C, 0x9B, 0x9F, 0x92, 0x95, 0x9A, 0x95, 0x7C, 0x6D, 0x88,
	0x69, 0x73, 0x8A, 0x7B, 0x8D, 0xA3, 0x9E, 0x98, 0xA2, 0x9E, 0xA2, 0x9B,
	0x9C, 0xA1, 0x9C, 0x89, 0x72, 0x8A, 0x6C, 0x65, 0x85, 0x76, 0x7D, 0x94,
	0x91, 0x8A, 0x94, 0x92, 0x92, 0x8C, 0x8E, 0x92, 0x90, 0x85, 0x62, 0x77,
	0x65, 0x56, 0x77, 0x6A, 0x6F, 0x89, 0x88, 0x7E, 0x85, 0x87, 0x89, 0x7D,
	0x77, 0x81, 0x7B, 0x73, 0x53, 0x63, 0x5A, 0x40, 0x61, 0x58, 0x54, 0x6D,
	0x75, 0x6B, 0x76, 0x7E, 0x7D, 0x7D, 0x7A, 0x86, 0x81, 0x7B, 0x62, 0x73,
	0x79, 0x60, 0x82, 0x81, 0x7A, 0x99, 0xA4, 0x98, 0xA2, 0xAD, 0xAB, 0xAC,
	0xA3, 0xA4, 0xA1, 0x9A, 0x74, 0x74, 0x82, 0x60, 0x7B, 0x7F, 0x72, 0x8A,
	0x98, 0x91, 0x94, 0x9D, 0x97, 0x9A, 0x92, 0x92, 0x90, 0x89, 0x69, 0x62,
	0x73, 0x49, 0x63, 0x75, 0x6B, 0x86, 0x99, 0x8D, 0x8F, 0x9D, 0x97, 0x95,
	0x8C, 0x8F, 0x90, 0x8C, 0x70, 0x5D, 0x76, 0x54, 0x5C, 0x71, 0x62, 0x7A,
	0x90, 0x88, 0x86, 0x92, 0x90, 0x8D, 0x84, 0x7F, 0x7F, 0x7C, 0x6B, 0x52,
	0x6A, 0x52, 0x4D, 0x70, 0x64, 0x6B, 0x89, 0x8A, 0x87, 0x98, 0x95, 0x98,
	0x93, 0x8C, 0x8D, 0x88, 0x7B, 0x5B, 0x74, 0x6A, 0x5A, 0x7B, 0x77, 0x7E,
	0x9A, 0x9C, 0x91, 0x9E, 0xA5, 0xA1, 0x9E, 0x95, 0x97, 0x92, 0x89, 0x66,
	0x6F, 0x75, 0x57, 0x76, 0x78, 0x71, 0x8C, 0x93, 0x88, 0x8D, 0x94, 0x91,
	0x96, 0x8F, 0x94, 0x94, 0x90, 0x72, 0x6B, 0x7A, 0x57, 0x6C, 0x7B, 0x6F,
	0x82, 0x92, 0x83, 0x83, 0x8C, 0x84, 0x82, 0x78, 0x7B, 0x7F, 0x7E, 0x66,
	0x59, 0x72, 0x5A, 0x62, 0x79, 0x6D, 0x7D, 0x93, 0x89, 0x84, 0x91, 0x8C,
	0x8B, 0x83, 0x80, 0x82, 0x80, 0x74, 0x62, 0x7D, 0x6F, 0x68, 0x8C, 0x7F,
	0x86, 0x9E, 0x99, 0x91, 0x9D, 0x9C, 0x99, 0x95, 0x8F, 0x97, 0x92, 0x86,
	0x69, 0x7D, 0x79, 0x66, 0x85, 0x80, 0x7D, 0x94, 0x91, 0x82, 0x8D, 0x91,
	0x89, 0x88, 0x7D, 0x83, 0x81, 0x78, 0x5E, 0x62, 0x70, 0x59, 0x74, 0x7B,
	0x75, 0x8D, 0x95, 0x8A, 0x8E, 0x96, 0x8F, 0x91, 0x89, 0x90, 0x8F, 0x87,
	0x6D, 0x63, 0x77, 0x53, 0x64, 0x7A, 0x6B, 0x7A, 0x87, 0x77, 0x77, 0x84,
	0x79, 0x7B, 0x73, 0x76, 0x7C, 0x77, 0x67, 0x53, 0x6B, 0x58, 0x5A, 0x76,
	0x6F, 0x7F, 0x9A, 0x91, 0x8D, 0xA3, 0xA1, 0xA4, 0x9F, 0x9A, 0xA1, 0x98,
	0x8A, 0x6F, 0x8B, 0x78, 0x6D, 0x8F, 0x7F, 0x87, 0xA0, 0x99, 0x91, 0xA4,
	0xA0, 0x9B, 0x9A, 0x94, 0x9C, 0x90, 0x88, 0x6B, 0x77, 0x74, 0x5D, 0x7C,
	0x78, 0x71, 0x87, 0x89, 0x7B, 0x8B, 0x8F, 0x88, 0x8B, 0x85, 0x8A, 0x86,
	0x7D, 0x5F, 0x60, 0x67, 0x4C, 0x69, 0x70, 0x68, 0x7D, 0x86, 0x77, 0x82,
	0x8C, 0x84, 0x87, 0x81, 0x87, 0x85, 0x7F, 0x66, 0x5E, 0x72, 0x4F, 0x62,
	0x74, 0x66, 0x79, 0x89, 0x78, 0x79, 0x8B, 0x84, 0x89, 0x82, 0x8A, 0x8F,
	0x87, 0x74, 0x65, 0x83, 0x62, 0x6D, 0x87, 0x79, 0x8C, 0x9E, 0x91, 0x8F,
	0xA0, 0x99, 0x9B, 0x98, 0x9A, 0xA0, 0x98, 0x85, 0x6D, 0x8A, 0x6E, 0x6D,
	0x8C, 0x79, 0x82, 0x97, 0x8B, 0x84, 0x95, 0x8E, 0x8F, 0x8C, 0x8A, 0x92,
	0x8D, 0x83, 0x65, 0x7E, 0x6F, 0x5F, 0x88, 0x7E, 0x82, 0x99, 0x94, 0x85,
	0x94, 0x95, 0x94, 0x93, 0x8D, 0x94, 0x8A, 0x7F, 0x5D, 0x71, 0x67, 0x4E,
	0x75, 0x6D, 0x65, 0x7E, 0x7C, 0x68, 0x78, 0x7B, 0x75, 0x79, 0x73, 0x7B,
	0x76, 0x74, 0x52, 0x5F, 0x68, 0x46, 0x6E, 0x75, 0x6D, 0x86, 0x8E, 0x7B,
	0x88, 0x92, 0x8A, 0x8F, 0x8C, 0x96, 0x93, 0x8E, 0x72, 0x79, 0x88, 0x63,
	0x86, 0x93, 0x84, 0x99, 0xA5, 0x94, 0x96, 0x9F, 0x97, 0x9A, 0x92, 0x96,
	0x94, 0x90, 0x73, 0x6B, 0x83, 0x5D, 0x72, 0x85, 0x70, 0x85, 0x96, 0x82,
	0x85, 0x93, 0x8B, 0x8F, 0x8A, 0x90, 0x93, 0x8E, 0x73, 0x68, 0x84, 0x60,
	0x6C, 0x86, 0x74, 0x81, 0x93, 0x84, 0x7E, 0x8D, 0x88, 0x89, 0x85, 0x88,
	0x87, 0x80, 0x65, 0x51, 0x6D, 0x4C, 0x53, 0x74, 0x65, 0x72, 0x8A, 0x7C,
	0x76, 0x88, 0x81, 0x84, 0x85, 0x88, 0x8A, 0x88, 0x78, 0x64, 0x87, 0x67,
	0x65, 0x8B, 0x7B, 0x85, 0xA1, 0x95, 0x8A, 0x9C, 0x98, 0x95, 0x95, 0x92,
	0x93, 0x8E, 0x79, 0x5E, 0x83, 0x67, 0x61, 0x89, 0x7B, 0x81, 0xA0, 0x97,
	0x88, 0x99, 0x95, 0x91, 0x90, 0x8D, 0x8E, 0x88, 0x78, 0x59, 0x7B, 0x63,
	0x57, 0x81, 0x75, 0x77, 0x93, 0x8C, 0x79, 0x8C, 0x8A, 0x88, 0x89, 0x87,
	0x8E, 0x88, 0x7E, 0x5C, 0x7A, 0x6B, 0x56, 0x81, 0x79, 0x78, 0x91, 0x90,
	0x79, 0x86, 0x88, 0x80, 0x83, 0x7D, 0x83, 0x7F, 0x77, 0x53, 0x6F, 0x66,
	0x4E, 0x7A, 0x79, 0x74, 0x92, 0x97, 0x82, 0x92, 0x94, 0x8B, 0x8F, 0x8D,
	0x93, 0x92, 0x8A, 0x63, 0x82, 0x7E, 0x61, 0x91, 0x8E, 0x87, 0xA0, 0xA5,
	0x8C, 0x98, 0x9B, 0x8C, 0x8E, 0x89, 0x8A, 0x87, 0x7F, 0x59, 0x70, 0x70,
	0x4F, 0x7A, 0x7E, 0x74, 0x90, 0x9D, 0x84, 0x8C, 0x90, 0x83, 0x8A, 0x86,
	0x8A, 0x89, 0x86, 0x5E, 0x71, 0x7B, 0x54, 0x7A, 0x84, 0x78, 0x92, 0x9E,
	0x85, 0x84, 0x8B, 0x7C, 0x7F, 0x7C, 0x7C, 0x7A, 0x7B, 0x55, 0x61, 0x72,
	0x4B, 0x6D, 0x78, 0x6E, 0x85, 0x94, 0x7C, 0x79, 0x85, 0x78, 0x79, 0x7A,
	0x7F, 0x7F, 0x83, 0x61, 0x6C, 0x81, 0x5B, 0x7A, 0x89, 0x7E, 0x97, 0xAA,
	0x95, 0x90, 0x9C, 0x94, 0x90, 0x95, 0x97, 0x90, 0x95, 0x70, 0x76, 0x8D,
	0x64, 0x82, 0x93, 0x84, 0x97, 0xA6, 0x94, 0x91, 0x9A, 0x90, 0x8A, 0x8C,
	0x8E, 0x89, 0x8C, 0x69, 0x65, 0x82, 0x58, 0x6E, 0x87, 0x78, 0x89, 0x9E,
	0x8E, 0x84, 0x8D, 0x86, 0x7F, 0x7F, 0x83, 0x7F, 0x87, 0x65, 0x60, 0x7C,
	0x51, 0x63, 0x7F, 0x70, 0x7B, 0x93, 0x84, 0x78, 0x82, 0x7A, 0x6E, 0x70,
	0x77, 0x6E, 0x74, 0x5A, 0x53, 0x77, 0x4D, 0x5C, 0x7F, 0x70, 0x80, 0x9F,
	0x96, 0x8C, 0x98, 0x95, 0x8B, 0x87, 0x8E, 0x86, 0x8F, 0x72, 0x68, 0x8E,
	0x64, 0x78, 0x99, 0x84, 0x90, 0xAD, 0xA1, 0x96, 0x9D, 0x9A, 0x92, 0x8B,
	0x95, 0x89, 0x8C, 0x75, 0x64, 0x8D, 0x62, 0x6C, 0x92, 0x7F, 0x86, 0xA3,
	0x97, 0x88, 0x90, 0x8B, 0x84, 0x7B, 0x85, 0x7D, 0x81, 0x65, 0x52, 0x7F,
	0x58, 0x60, 0x87, 0x78, 0x80, 0x9F, 0x98, 0x88, 0x90, 0x8D, 0x86, 0x7A,
	0x86, 0x7D, 0x7C, 0x68, 0x53, 0x7E, 0x56, 0x56, 0x82, 0x74, 0x75, 0x97,
	0x92, 0x85, 0x8B, 0x86, 0x80, 0x76, 0x83, 0x7C, 0x7A, 0x6A, 0x53, 0x81,
	0x61, 0x5F, 0x8D, 0x81, 0x82, 0xA1, 0x9D, 0x8F, 0x99, 0x96, 0x94, 0x8C,
	0x92, 0x8D, 0x8A, 0x77, 0x5F, 0x8C, 0x68, 0x65, 0x92, 0x83, 0x81, 0x9D,
	0x97, 0x8B, 0x91, 0x8E, 0x8C, 0x7F, 0x88, 0x87, 0x7F, 0x6D, 0x5A, 0x86,
	0x66, 0x62, 0x8F, 0x85, 0x85, 0xA0, 0x9B, 0x8E, 0x93, 0x92, 0x8E, 0x83,
	0x89, 0x8A, 0x82, 0x6E, 0x5D, 0x7D, 0x62, 0x5E, 0x85, 0x7B, 0x77, 0x93,
	0x8B, 0x80, 0x83, 0x81, 0x7F, 0x75, 0x7B, 0x7F, 0x77, 0x62, 0x55, 0x75,
	0x5B, 0x58, 0x7A, 0x79, 0x78, 0x91, 0x90, 0x89, 0x8B, 0x8D, 0x8A, 0x7E,
	0x85, 0x8D, 0x87, 0x6F, 0x67, 0x88, 0x70, 0x6F, 0x91, 0x93, 0x90, 0xA6,
	0xA4, 0x9B, 0x9B, 0x9D, 0x99, 0x8C, 0x90, 0x92, 0x88, 0x6A, 0x68, 0x82,
	0x67, 0x6D, 0x89, 0x88, 0x87, 0x96, 0x90, 0x8A, 0x89, 0x8A, 0x85, 0x7D,
	0x82, 0x85, 0x82, 0x5E, 0x5E, 0x77, 0x5B, 0x66, 0x7F, 0x82, 0x84, 0x95,
	0x90, 0x8C, 0x8A, 0x8A, 0x87, 0x7C, 0x7D, 0x80, 0x7C, 0x57, 0x5C, 0x71,
	0x4E, 0x60, 0x72, 0x75, 0x7C, 0x8C, 0x86, 0x85, 0x85, 0x84, 0x81, 0x76,
	0x7B, 0x7F, 0x7F, 0x5C, 0x66, 0x82, 0x5D, 0x72, 0x85, 0x85, 0x8C, 0x9C,
	0x98, 0x9A, 0x99, 0x99, 0x99, 0x8F, 0x93, 0x93, 0x95, 0x6D, 0x75, 0x8D,
	0x66, 0x7D, 0x8D, 0x8C, 0x95, 0xA1, 0x9A, 0x99, 0x98, 0x98, 0x97, 0x8B,
	0x8F, 0x8C, 0x8B, 0x64, 0x64, 0x7E, 0x57, 0x69, 0x7B, 0x79, 0x82, 0x8D,
	0x86, 0x85, 0x84, 0x88, 0x8A, 0x83, 0x89, 0x87, 0x89, 0x64, 0x61, 0x7E,
	0x58, 0x67, 0x78, 0x77, 0x81, 0x8A, 0x80, 0x82, 0x7F, 0x82, 0x86, 0x7B,
	0x81, 0x7F, 0x81, 0x5D, 0x57, 0x75, 0x4D, 0x5B, 0x6E, 0x6F, 0x79, 0x85,
	0x85, 0x86, 0x85, 0x8A, 0x8E, 0x86, 0x8D, 0x8E, 0x94, 0x73, 0x70, 0x91,
	0x68, 0x75, 0x8B, 0x8B, 0x93, 0x9B, 0x96, 0x95, 0x92, 0x95, 0x97, 0x90,
	0x92, 0x90, 0x90, 0x71, 0x67, 0x89, 0x62, 0x6C, 0x82, 0x84, 0x88, 0x90,
	0x8E, 0x8C, 0x89, 0x8C, 0x90, 0x89, 0x8E, 0x8F, 0x92, 0x73, 0x67, 0x8B,
	0x63, 0x6B, 0x81, 0x84, 0x88, 0x8B, 0x8B, 0x82, 0x7C, 0x84, 0x87, 0x81,
	0x86, 0x88, 0x88, 0x6C, 0x5B, 0x7D, 0x5C, 0x5D, 0x75, 0x79, 0x7C, 0x81,
	0x82, 0x7C, 0x76, 0x79, 0x7A, 0x77, 0x7D, 0x7D, 0x81, 0x65, 0x56, 0x7C,
	0x5D, 0x5C, 0x74, 0x7D, 0x81, 0x84, 0x90, 0x8D, 0x84, 0x90, 0x93, 0x91,
	0x98, 0x9A, 0x9E, 0x88, 0x71, 0x90, 0x79, 0x71, 0x88, 0x92, 0x8E, 0x91,
	0x9B, 0x94, 0x8B, 0x95, 0x9A, 0x97, 0x9A, 0x9A, 0x95, 0x7B, 0x67, 0x7F,
	0x67, 0x5B, 0x73, 0x85, 0x7B, 0x80, 0x8B, 0x84, 0x77, 0x84, 0x8A, 0x89,
	0x92, 0x94, 0x8F, 0x77, 0x67, 0x81, 0x66, 0x5B, 0x7A, 0x82, 0x75, 0x7D,
	0x86, 0x7E, 0x6C, 0x79, 0x7F, 0x7B, 0x87, 0x89, 0x85, 0x6B, 0x5F, 0x72,
	0x54, 0x55, 0x73, 0x79, 0x74, 0x7A, 0x83, 0x7E, 0x70, 0x82, 0x8A, 0x8A,
	0x96, 0x98, 0x95, 0x7D, 0x79, 0x88, 0x6C, 0x73, 0x8E, 0x92, 0x8E, 0x92,
	0x97, 0x8F, 0x81, 0x90, 0x96, 0x91, 0x9F, 0x9F, 0x99, 0x7D, 0x7E, 0x89,
	0x6A, 0x74, 0x88, 0x8C, 0x86, 0x85, 0x89, 0x7E, 0x71, 0x7B, 0x83, 0x85,
	0x8F, 0x93, 0x8B, 0x6D, 0x77, 0x79, 0x5E, 0x71, 0x85, 0x89, 0x81, 0x81,
	0x82, 0x76, 0x6E, 0x76, 0x7E, 0x83, 0x89, 0x8D, 0x83, 0x68, 0x77, 0x6D,
	0x5B, 0x70, 0x7E, 0x85, 0x7E, 0x7E, 0x80, 0x75, 0x72, 0x73, 0x79, 0x83,
	0x84, 0x85, 0x7B, 0x68, 0x75, 0x6A, 0x62, 0x74, 0x7F, 0x87, 0x84, 0x84,
	0x86, 0x85, 0x87, 0x84, 0x8B, 0x98, 0x99, 0x9C, 0x8B, 0x81, 0x8E, 0x7C,
	0x81, 0x8D, 0x95, 0x99, 0x8E, 0x8B, 0x87, 0x82, 0x88, 0x85, 0x8C, 0x96,
	0x92, 0x90, 0x7F, 0x81, 0x81, 0x75, 0x82, 0x89, 0x8C, 0x8F, 0x87, 0x7F,
	0x7A, 0x79, 0x7E, 0x77, 0x83, 0x8E, 0x8C, 0x83, 0x7C, 0x80, 0x76, 0x75,
	0x7E, 0x81, 0x82, 0x85, 0x7B, 0x6E, 0x6D, 0x6F, 0x71, 0x6C, 0x74, 0x83,
	0x7D, 0x70, 0x7F, 0x7C, 0x6F, 0x7C, 0x7F, 0x7F, 0x7A, 0x7A, 0x70, 0x61,
	0x64, 0x6A, 0x6C, 0x70, 0x77, 0x81, 0x75, 0x72, 0x86, 0x7C, 0x81, 0x8F,
	0x8E, 0x8A, 0x86, 0x87, 0x7C, 0x70, 0x79, 0x7F, 0x86, 0x85, 0x8C, 0x8D,
	0x87, 0x91, 0x93, 0x96, 0xA0, 0xA9, 0xA5, 0xA0, 0x99, 0x90, 0x84, 0x7A,
	0x7C, 0x81, 0x7E, 0x7B, 0x7A, 0x77, 0x7E, 0x81, 0x8A, 0x94, 0x95, 0x9A,
	0x96, 0x90, 0x85, 0x7C, 0x77, 0x70, 0x73, 0x77, 0x76, 0x72, 0x6C, 0x75,
	0x76, 0x79, 0x8B, 0x91, 0x90, 0x92, 0x87, 0x7D, 0x71, 0x69, 0x6A, 0x64,
	0x65, 0x6A, 0x64, 0x5C, 0x6A, 0x6F, 0x75, 0x85, 0x93, 0x97, 0x93, 0x91,
	0x88, 0x7F, 0x77, 0x71, 0x72, 0x6A, 0x6B, 0x6E, 0x65, 0x6B, 0x74, 0x7C,
	0x89, 0x98, 0xA1, 0xA1, 0x96, 0x8F, 0x88, 0x81, 0x7D, 0x76, 0x75, 0x75,
	0x6E, 0x6F, 0x7A, 0x7C, 0x88, 0x9A, 0xA0, 0xAA, 0xB1, 0xA8, 0x99, 0x92,
	0x8C, 0x86, 0x81, 0x72, 0x75, 0x6B, 0x66, 0x73, 0x71, 0x7A, 0x8E, 0x9B,
	0x9F, 0xA1, 0xA2, 0x9B, 0x88, 0x83, 0x82, 0x75, 0x72, 0x62, 0x5F, 0x64,
	0x61, 0x69, 0x77, 0x7F, 0x8E, 0x9E, 0x98, 0x97, 0x9B, 0x8D, 0x85, 0x80,
	0x78, 0x6F, 0x63, 0x54, 0x5F, 0x60, 0x61, 0x72, 0x77, 0x83, 0x8D, 0x92,
	0x8F, 0x8D, 0x92, 0x8D, 0x7F, 0x78, 0x75, 0x65, 0x63, 0x60, 0x62, 0x70,
	0x6F, 0x7C, 0x88, 0x86, 0x8F, 0x94, 0x8E, 0x92, 0x94, 0x8B, 0x81, 0x71,
	0x75, 0x75, 0x6E, 0x76, 0x7F, 0x87, 0x8A, 0x8D, 0x92, 0x93, 0x95, 0x9F,
	0x9B, 0x96, 0x9A, 0x8B, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x85, 0x8B, 0x8C,
	0x83, 0x85, 0x85, 0x87, 0x8D, 0x89, 0x87, 0x7C, 0x79, 0x7C, 0x77, 0x76,
	0x7F, 0x7B, 0x7E, 0x82, 0x77, 0x7B, 0x75, 0x75, 0x7F, 0x7A, 0x7E, 0x78,
	0x6F, 0x73, 0x7A, 0x79, 0x7C, 0x7B, 0x84, 0x85, 0x78, 0x7B, 0x72, 0x6E,
	0x73, 0x70, 0x75, 0x72, 0x69, 0x6C, 0x76, 0x77, 0x87, 0x8F, 0x8F, 0x93,
	0x89, 0x81, 0x79, 0x78, 0x78, 0x73, 0x77, 0x77, 0x71, 0x71, 0x7F, 0x83,
	0x8E, 0x97, 0xA5, 0xAD, 0x9D, 0x96, 0x8F, 0x87, 0x81, 0x82, 0x80, 0x78,
	0x75, 0x77, 0x80, 0x7F, 0x8F, 0x98, 0xA2, 0xAB, 0xA5, 0xA3, 0x92, 0x88,
	0x86, 0x7F, 0x78, 0x73, 0x65, 0x5E, 0x6C, 0x6F, 0x75, 0x7C, 0x92, 0x95,
	0x8A, 0x8F, 0x8A, 0x82, 0x77, 0x74, 0x74, 0x67, 0x59, 0x5E, 0x65, 0x62,
	0x71, 0x7D, 0x8D, 0x8E, 0x94, 0x92, 0x8A, 0x8E, 0x87, 0x82, 0x77, 0x6F,
	0x69, 0x64, 0x61, 0x67, 0x6F, 0x72, 0x86, 0x89, 0x86, 0x85, 0x8B, 0x8C,
	0x84, 0x86, 0x80, 0x75, 0x69, 0x6C, 0x70, 0x6E, 0x71, 0x85, 0x91, 0x84,
	0x8B, 0x90, 0x8B, 0x8B, 0x96, 0x98, 0x8A, 0x85, 0x7E, 0x81, 0x7C, 0x7C,
	0x87, 0x8F, 0x8F, 0x93, 0x94, 0x86, 0x8C, 0x91, 0x8C, 0x8F, 0x90, 0x8A,
	0x7F, 0x86, 0x84, 0x81, 0x88, 0x90, 0x90, 0x8A, 0x7E, 0x7E, 0x82, 0x75,
	0x7E, 0x85, 0x7C, 0x77, 0x7F, 0x83, 0x73, 0x7C, 0x88, 0x85, 0x80, 0x7A,
	0x78, 0x75, 0x6D, 0x6D, 0x77, 0x69, 0x6A, 0x75, 0x77, 0x77, 0x80, 0x8C,
	0x85, 0x89, 0x86, 0x79, 0x75, 0x74, 0x73, 0x73, 0x69, 0x66, 0x6D, 0x64,
	0x6B, 0x78, 0x7C, 0x82, 0x8A, 0x8F, 0x7E, 0x7A, 0x7B, 0x76, 0x77, 0x77,
	0x79, 0x78, 0x74, 0x78, 0x8D, 0x8E, 0x92, 0xA3, 0xA0, 0x93, 0x93, 0x95,
	0x88, 0x88, 0x8C, 0x89, 0x87, 0x85, 0x85, 0x8E, 0x92, 0x97, 0xA7, 0x9E,
	0x92, 0x92, 0x8A, 0x81, 0x7C, 0x7D, 0x71, 0x71, 0x7B, 0x77, 0x79, 0x84,
	0x8E, 0x97, 0x95, 0x8C, 0x8E, 0x7E, 0x70, 0x76, 0x72, 0x66, 0x63, 0x6B,
	0x69, 0x6B, 0x78, 0x80, 0x86, 0x8D, 0x8F, 0x8E, 0x82, 0x78, 0x7B, 0x73,
	0x65, 0x65, 0x66, 0x5F, 0x65, 0x76, 0x7F, 0x85, 0x91, 0x93, 0x8B, 0x8A,
	0x89, 0x88, 0x7F, 0x73, 0x75, 0x6C, 0x5F, 0x62, 0x6C, 0x74, 0x7E, 0x8E,
	0x8F, 0x89, 0x8E, 0x8E, 0x89, 0x89, 0x82, 0x81, 0x7C, 0x72, 0x76, 0x76,
	0x74, 0x83, 0x91, 0x92, 0x90, 0x98, 0x9B, 0x96, 0x9B, 0x95, 0x8B, 0x8C,
	0x87, 0x86, 0x7F, 0x79, 0x83, 0x87, 0x80, 0x80, 0x86, 0x83, 0x84, 0x8E,
	0x8E, 0x87, 0x8A, 0x85, 0x7C, 0x81, 0x7E, 0x83, 0x84, 0x7B, 0x7B, 0x79,
	0x70, 0x72, 0x7D, 0x7D, 0x7D, 0x86, 0x81, 0x7C, 0x81, 0x84, 0x84, 0x87,
	0x82, 0x7C, 0x78, 0x6D, 0x6B, 0x71, 0x66, 0x65, 0x78, 0x79, 0x76, 0x7F,
	0x84, 0x87, 0x8E, 0x8C, 0x84, 0x83, 0x7E, 0x7E, 0x7C, 0x6B, 0x68, 0x72,
	0x6D, 0x6E, 0x7B, 0x7D, 0x7F, 0x8B, 0x8C, 0x85, 0x86, 0x84, 0x80, 0x86,
	0x7F, 0x7B, 0x7E, 0x77, 0x78, 0x84, 0x82, 0x83, 0x8F, 0x94, 0x8F, 0x90,
	0x8F, 0x8D, 0x92, 0x92, 0x8A, 0x8D, 0x89, 0x87, 0x91, 0x8D, 0x8A, 0x90,
	0x88, 0x7C, 0x81, 0x82, 0x7C, 0x85, 0x86, 0x83, 0x87, 0x83, 0x7D, 0x86,
	0x8A, 0x8C, 0x90, 0x85, 0x77, 0x73, 0x6F, 0x67, 0x70, 0x78, 0x71, 0x7C,
	0x7C, 0x78, 0x7D, 0x82, 0x84, 0x8C, 0x89, 0x7E, 0x79, 0x6D, 0x63, 0x65,
	0x64, 0x5F, 0x6D, 0x7A, 0x74, 0x7E, 0x84, 0x89, 0x93, 0x93, 0x89, 0x88,
	0x85, 0x7C, 0x7D, 0x73, 0x69, 0x6F, 0x73, 0x6F, 0x7A, 0x89, 0x88, 0x94,
	0x98, 0x92, 0x8D, 0x88, 0x82, 0x84, 0x7F, 0x77, 0x79, 0x76, 0x71, 0x73,
	0x7D, 0x7E, 0x8A, 0x9B, 0x92, 0x96, 0x94, 0x8E, 0x8E, 0x8B, 0x87, 0x84,
	0x83, 0x84, 0x87, 0x7E, 0x7A, 0x7F, 0x83, 0x7F, 0x83, 0x8F, 0x89, 0x86,
	0x8A, 0x89, 0x85, 0x7F, 0x82, 0x86, 0x89, 0x84, 0x84, 0x7F, 0x74, 0x71,
	0x74, 0x74, 0x74, 0x81, 0x81, 0x83, 0x83, 0x7F, 0x80, 0x81, 0x85, 0x83,
	0x7F, 0x7B, 0x7A, 0x71, 0x6B, 0x69, 0x6B, 0x70, 0x73, 0x82, 0x81, 0x7F,
	0x87, 0x89, 0x84, 0x7E, 0x7E, 0x7D, 0x7C, 0x7A, 0x77, 0x74, 0x75, 0x75,
	0x77, 0x7D, 0x7E, 0x8B, 0x8B, 0x87, 0x83, 0x7B, 0x74, 0x75, 0x7A, 0x76,
	0x77, 0x7C, 0x7D, 0x7E, 0x83, 0x83, 0x86, 0x8E, 0x92, 0x98, 0x90, 0x84,
	0x88, 0x88, 0x81, 0x82, 0x89, 0x89, 0x88, 0x8C, 0x8F, 0x8F, 0x91, 0x92,
	0x8F, 0x92, 0x8D, 0x8F, 0x8C, 0x86, 0x86, 0x85, 0x7F, 0x7D, 0x83, 0x83,
	0x84, 0x84, 0x84, 0x81, 0x7D, 0x79, 0x74, 0x78, 0x77, 0x7E, 0x7F, 0x78,
	0x78, 0x79, 0x77, 0x76, 0x79, 0x78, 0x73, 0x74, 0x73, 0x6F, 0x6D, 0x70,
	0x70, 0x7A, 0x7C, 0x7F, 0x86, 0x82, 0x82, 0x83, 0x7C, 0x75, 0x77, 0x77,
	0x75, 0x77, 0x78, 0x7A, 0x82, 0x83, 0x80, 0x87, 0x89, 0x8E, 0x8E, 0x87,
	0x7F, 0x7C, 0x7A, 0x74, 0x74, 0x75, 0x74, 0x78, 0x7F, 0x81, 0x84, 0x8B,
	0x8A, 0x91, 0x91, 0x89, 0x88, 0x86, 0x7F, 0x83, 0x81, 0x7A, 0x86, 0x8D,
	0x8B, 0x8E, 0x90, 0x94, 0x98, 0x96, 0x8D, 0x89, 0x85, 0x82, 0x82, 0x7E,
	0x77, 0x7D, 0x84, 0x80, 0x83, 0x8A, 0x8C, 0x8E, 0x91, 0x89, 0x84, 0x83,
	0x7C, 0x7C, 0x78, 0x73, 0x76, 0x79, 0x77, 0x7A, 0x7C, 0x79, 0x7F, 0x86,
	0x7F, 0x7A, 0x7D, 0x7D, 0x7E, 0x7E, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C,
	0x78, 0x76, 0x79, 0x73, 0x70, 0x73, 0x73, 0x75, 0x7C, 0x7C, 0x7E, 0x86,
	0x85, 0x86, 0x86, 0x87, 0x81, 0x7C, 0x74, 0x6D, 0x6C, 0x67, 0x6A, 0x74,
	0x76, 0x76, 0x81, 0x83, 0x88, 0x91, 0x94, 0x91, 0x8D, 0x8B, 0x81, 0x7B,
	0x76, 0x75, 0x79, 0x7A, 0x7F, 0x88, 0x8C, 0x8F, 0x9D, 0xA3, 0xA3, 0xA4,
	0xA2, 0x98, 0x8F, 0x8D, 0x82, 0x7D, 0x7A, 0x77, 0x76, 0x75, 0x7B, 0x83,
	0x8D, 0x8E, 0x96, 0x98, 0x92, 0x90, 0x8C, 0x81, 0x7C, 0x7E, 0x73, 0x70,
	0x70, 0x6D, 0x6F, 0x74, 0x7B, 0x7C, 0x80, 0x7E, 0x83, 0x82, 0x7A, 0x7D,
	0x7C, 0x74, 0x6E, 0x73, 0x6C, 0x6C, 0x74, 0x77, 0x77, 0x78, 0x7A, 0x79,
	0x7D, 0x7A, 0x82, 0x85, 0x7E, 0x7F, 0x80, 0x7B, 0x73, 0x7E, 0x7E, 0x7A,
	0x7E, 0x7E, 0x7C, 0x7C, 0x81, 0x83, 0x89, 0x87, 0x89, 0x88, 0x7F, 0x80,
	0x85, 0x85, 0x7B, 0x82, 0x7D, 0x76, 0x7A, 0x7A, 0x7C, 0x81, 0x8A, 0x87,
	0x8D, 0x8D, 0x8B, 0x8F, 0x8D, 0x8F, 0x8C, 0x89, 0x7F, 0x82, 0x7E, 0x78,
	0x7F, 0x82, 0x80, 0x7F, 0x86, 0x84, 0x8B, 0x92, 0x95, 0x96, 0x92, 0x8E,
	0x8B, 0x87, 0x79, 0x7F, 0x81, 0x78, 0x77, 0x77, 0x75, 0x75, 0x81, 0x86,
	0x89, 0x8B, 0x89, 0x88, 0x84, 0x81, 0x80, 0x81, 0x74, 0x72, 0x71, 0x66,
	0x68, 0x6E, 0x75, 0x77, 0x7F, 0x81, 0x82, 0x85, 0x85, 0x86, 0x87, 0x85,
	0x7E, 0x7C, 0x72, 0x70, 0x70, 0x6D, 0x73, 0x79, 0x7B, 0x77, 0x7C, 0x81,
	0x82, 0x87, 0x8A, 0x84, 0x82, 0x7C, 0x76, 0x79, 0x74, 0x7B, 0x82, 0x7D,
	0x7C, 0x7B, 0x7F, 0x7D, 0x82, 0x89, 0x86, 0x85, 0x86, 0x7F, 0x7E, 0x81,
	0x89, 0x91, 0x8B, 0x8B, 0x8C, 0x86, 0x85, 0x87, 0x8B, 0x87, 0x85, 0x87,
	0x83, 0x7E, 0x84, 0x8A, 0x91, 0x93, 0x93, 0x95, 0x8E, 0x8A, 0x89, 0x83,
	0x81, 0x7F, 0x7D, 0x77, 0x72, 0x77, 0x7D, 0x84, 0x8E, 0x8E, 0x8C, 0x88,
	0x86, 0x85, 0x7A, 0x76, 0x75, 0x6B, 0x65, 0x64, 0x67, 0x6B, 0x74, 0x82,
	0x88, 0x8A, 0x8D, 0x8D, 0x8A, 0x85, 0x7D, 0x7E, 0x71, 0x68, 0x6B, 0x65,
	0x65, 0x72, 0x82, 0x85, 0x89, 0x8F, 0x92, 0x92, 0x91, 0x8E, 0x87, 0x7C,
	0x6F, 0x6D, 0x65, 0x61, 0x6C, 0x74, 0x79, 0x83, 0x8E, 0x8B, 0x91, 0x97,
	0x93, 0x91, 0x8D, 0x80, 0x78, 0x71, 0x68, 0x6F, 0x76, 0x79, 0x82, 0x85,
	0x80, 0x85, 0x8E, 0x88, 0x8A, 0x8D, 0x83, 0x7E, 0x7E, 0x76, 0x78, 0x82,
	0x83, 0x8C, 0x90, 0x88, 0x8B, 0x90, 0x89, 0x89, 0x8F, 0x85, 0x81, 0x84,
	0x7E, 0x7D, 0x88, 0x8D, 0x91, 0x95, 0x8C, 0x8A, 0x8D, 0x85, 0x81, 0x82,
	0x78, 0x71, 0x77, 0x71, 0x6F, 0x7D, 0x82, 0x86, 0x8E, 0x8C, 0x87, 0x85,
	0x7D, 0x7A, 0x79, 0x70, 0x6A, 0x6B, 0x68, 0x66, 0x75, 0x7C, 0x83, 0x8E,
	0x8D, 0x84, 0x83, 0x81, 0x79, 0x77, 0x70, 0x6A, 0x67, 0x62, 0x62, 0x6A,
	0x76, 0x82, 0x94, 0x98, 0x95, 0x96, 0x92, 0x88, 0x82, 0x7F, 0x79, 0x71,
	0x6B, 0x6D, 0x6F, 0x76, 0x81, 0x8F, 0x97, 0x95, 0x99, 0x94, 0x8D, 0x8B,
	0x85, 0x7B, 0x73, 0x70, 0x6F, 0x6D, 0x6F, 0x7B, 0x88, 0x92, 0x98, 0x9B,
	0x98, 0x94, 0x97, 0x8E, 0x88, 0x86, 0x7D, 0x77, 0x77, 0x78, 0x81, 0x89,
	0x8C, 0x92, 0x92, 0x8D, 0x8A, 0x89, 0x84, 0x7D, 0x81, 0x76, 0x71, 0x76,
	0x72, 0x75, 0x80, 0x87, 0x8C, 0x8E, 0x86, 0x81, 0x7E, 0x77, 0x72, 0x74,
	0x70, 0x6D, 0x75, 0x71, 0x73, 0x84, 0x89, 0x89, 0x8C, 0x8B, 0x87, 0x85,
	0x77, 0x70, 0x74, 0x6E, 0x66, 0x6E, 0x71, 0x71, 0x81, 0x88, 0x8C, 0x94,
	0x8F, 0x88, 0x86, 0x7E, 0x77, 0x76, 0x73, 0x6D, 0x6E, 0x70, 0x70, 0x7D,
	0x88, 0x8B, 0x95, 0x93, 0x8B, 0x8C, 0x84, 0x78, 0x77, 0x75, 0x6F, 0x6E,
	0x6C, 0x6E, 0x77, 0x81, 0x88, 0x96, 0x9E, 0x98, 0x97, 0x93, 0x8B, 0x89,
	0x85, 0x7E, 0x79, 0x79, 0x7C, 0x83, 0x87, 0x8C, 0x95, 0x99, 0x99, 0x99,
	0x97, 0x90, 0x8C, 0x85, 0x7D, 0x78, 0x74, 0x72, 0x73, 0x7A, 0x85, 0x89,
	0x8A, 0x8A, 0x8A, 0x85, 0x7F, 0x82, 0x83, 0x7D, 0x78, 0x71, 0x6E, 0x71,
	0x74, 0x77, 0x79, 0x80, 0x84, 0x81, 0x78, 0x74, 0x76, 0x75, 0x75, 0x79,
	0x76, 0x6F, 0x73, 0x75, 0x75, 0x7E, 0x84, 0x84, 0x80, 0x7C, 0x77, 0x74,
	0x73, 0x74, 0x7A, 0x77, 0x77, 0x81, 0x84, 0x84, 0x8B, 0x8C, 0x8D, 0x91,
	0x8E, 0x85, 0x7D, 0x7D, 0x7E, 0x7C, 0x7A, 0x77, 0x7D, 0x82, 0x83, 0x8C,
	0x92, 0x93, 0x97, 0x94, 0x88, 0x7F, 0x7D, 0x7C, 0x79, 0x7D, 0x7B, 0x78,
	0x7C, 0x7F, 0x83, 0x89, 0x8F, 0x97, 0x9A, 0x92, 0x8A, 0x82, 0x7D, 0x7D,
	0x7F, 0x7B, 0x71, 0x78, 0x7E, 0x7D, 0x82, 0x8B, 0x92, 0x95, 0x94, 0x8F,
	0x89, 0x85, 0x83, 0x7F, 0x7D, 0x78, 0x76, 0x79, 0x73, 0x76, 0x7B, 0x7C,
	0x84, 0x8B, 0x87, 0x81, 0x81, 0x7F, 0x7C, 0x7B, 0x77, 0x6E, 0x6F, 0x70,
	0x6E, 0x71, 0x72, 0x7B, 0x83, 0x80, 0x7C, 0x80, 0x81, 0x80, 0x84, 0x80,
	0x79, 0x77, 0x77, 0x72, 0x70, 0x73, 0x79, 0x7F, 0x7E, 0x7C, 0x7D, 0x7F,
	0x80, 0x85, 0x87, 0x81, 0x7F, 0x82, 0x81, 0x7E, 0x7F, 0x80, 0x85, 0x8A,
	0x88, 0x84, 0x81, 0x85, 0x8B, 0x8A, 0x8A, 0x88, 0x84, 0x83, 0x82, 0x7D,
	0x7E, 0x85, 0x8C, 0x89, 0x83, 0x83, 0x85, 0x86, 0x86, 0x89, 0x88, 0x82,
	0x83, 0x87, 0x82, 0x7E, 0x87, 0x8C, 0x8F, 0x8C, 0x88, 0x87, 0x87, 0x89,
	0x89, 0x85, 0x7F, 0x7E, 0x81, 0x77, 0x75, 0x7D, 0x81, 0x84, 0x8A, 0x85,
	0x7F, 0x81, 0x7F, 0x79, 0x79, 0x74, 0x6D, 0x71, 0x70, 0x6C, 0x70, 0x75,
	0x7F, 0x88, 0x84, 0x7F, 0x88, 0x88, 0x82, 0x80, 0x7A, 0x72, 0x71, 0x6F,
	0x68, 0x6A, 0x72, 0x7A, 0x85, 0x86, 0x85, 0x88, 0x8C, 0x88, 0x89, 0x86,
	0x7A, 0x77, 0x77, 0x70, 0x6B, 0x6F, 0x77, 0x81, 0x87, 0x89, 0x8A, 0x8D,
	0x90, 0x90, 0x90, 0x88, 0x82, 0x7E, 0x79, 0x73, 0x71, 0x73, 0x7C, 0x86,
	0x88, 0x89, 0x8A, 0x8F, 0x8D, 0x88, 0x86, 0x81, 0x7D, 0x79, 0x77, 0x73,
	0x73, 0x7D, 0x86, 0x89, 0x89, 0x8D, 0x93, 0x96, 0x91, 0x90, 0x8C, 0x81,
	0x7D, 0x7B, 0x7A, 0x76, 0x80, 0x89, 0x8D, 0x90, 0x8D, 0x8C, 0x90, 0x8F,
	0x8B, 0x88, 0x7F, 0x79, 0x78, 0x70, 0x6A, 0x74, 0x80, 0x82, 0x8B, 0x8B,
	0x86, 0x89, 0x87, 0x7E, 0x7B, 0x79, 0x72, 0x6D, 0x6A, 0x65, 0x66, 0x6E,
	0x75, 0x82, 0x8A, 0x82, 0x86, 0x8A, 0x80, 0x7B, 0x7A, 0x73, 0x6D, 0x6F,
	0x6A, 0x6A, 0x71, 0x7A, 0x85, 0x8B, 0x8A, 0x8D, 0x93, 0x8C, 0x87, 0x89,
	0x7F, 0x76, 0x73, 0x6F, 0x6E, 0x75, 0x7D, 0x86, 0x90, 0x93, 0x94, 0x92,
	0x8F, 0x8F, 0x8E, 0x87, 0x7F, 0x7A, 0x73, 0x6F, 0x70, 0x76, 0x7D, 0x8A,
	0x91, 0x91, 0x90, 0x8E, 0x8C, 0x87, 0x83, 0x82, 0x7F, 0x76, 0x74, 0x75,
	0x74, 0x7B, 0x85, 0x8C, 0x8F, 0x92, 0x8F, 0x8B, 0x87, 0x86, 0x85, 0x7E,
	0x76, 0x77, 0x7C, 0x78, 0x7E, 0x8C, 0x8F, 0x93, 0x94, 0x8E, 0x8B, 0x8A,
	0x84, 0x7F, 0x7C, 0x75, 0x6F, 0x6F, 0x6E, 0x73, 0x7F, 0x86, 0x8B, 0x92,
	0x8C, 0x86, 0x84, 0x7E, 0x7B, 0x7B, 0x72, 0x68, 0x68, 0x6B, 0x6C, 0x72,
	0x7B, 0x85, 0x8F, 0x8C, 0x85, 0x86, 0x82, 0x7D, 0x7C, 0x77, 0x6E, 0x6A,
	0x69, 0x68, 0x6B, 0x74, 0x7E, 0x87, 0x8D, 0x8A, 0x87, 0x83, 0x83, 0x87,
	0x84, 0x7E, 0x78, 0x75, 0x77, 0x79, 0x7C, 0x84, 0x8E, 0x95, 0x95, 0x8D,
	0x88, 0x87, 0x87, 0x87, 0x85, 0x7F, 0x76, 0x77, 0x79, 0x75, 0x7A, 0x88,
	0x91, 0x92, 0x8F, 0x89, 0x88, 0x86, 0x86, 0x88, 0x84, 0x7A, 0x78, 0x7E,
	0x7A, 0x79, 0x82, 0x8B, 0x93, 0x96, 0x90, 0x8B, 0x8A, 0x8B, 0x8B, 0x87,
	0x7F, 0x77, 0x77, 0x78, 0x74, 0x78, 0x7F, 0x87, 0x8C, 0x89, 0x82, 0x82,
	0x84, 0x82, 0x81, 0x7E, 0x77, 0x6F, 0x72, 0x73, 0x6F, 0x74, 0x7E, 0x88,
	0x89, 0x82, 0x7F, 0x81, 0x81, 0x81, 0x81, 0x78, 0x6D, 0x6C, 0x70, 0x6B,
	0x6B, 0x78, 0x82, 0x89, 0x89, 0x84, 0x81, 0x84, 0x83, 0x82, 0x81, 0x7A,
	0x75, 0x74, 0x70, 0x6D, 0x74, 0x7A, 0x83, 0x8F, 0x8A, 0x87, 0x8E, 0x8F,
	0x8B, 0x89, 0x83, 0x78, 0x75, 0x75, 0x71, 0x71, 0x75, 0x7D, 0x88, 0x87,
	0x83, 0x8D, 0x90, 0x8E, 0x90, 0x8E, 0x88, 0x7E, 0x7C, 0x79, 0x79, 0x7C,
	0x80, 0x87, 0x8C, 0x8B, 0x8B, 0x8D, 0x8C, 0x91, 0x8F, 0x8A, 0x86, 0x80,
	0x7D, 0x7B, 0x7C, 0x7F, 0x87, 0x91, 0x92, 0x8F, 0x8C, 0x8B, 0x8B, 0x8A,
	0x84, 0x84, 0x7A, 0x71, 0x72, 0x6F, 0x70, 0x74, 0x7E, 0x86, 0x8C, 0x8D,
	0x89, 0x88, 0x84, 0x7E, 0x7C, 0x73, 0x67, 0x6B, 0x6C, 0x66, 0x6A, 0x71,
	0x79, 0x81, 0x85, 0x85, 0x89, 0x8A, 0x85, 0x84, 0x7F, 0x6F, 0x69, 0x6C,
	0x66, 0x6B, 0x71, 0x76, 0x85, 0x8D, 0x8A, 0x89, 0x8D, 0x8A, 0x8A, 0x8B,
	0x82, 0x76, 0x74, 0x70, 0x70, 0x74, 0x74, 0x83, 0x91, 0x90, 0x8F, 0x91,
	0x8E, 0x8D, 0x8E, 0x8A, 0x83, 0x7C, 0x77, 0x78, 0x7B, 0x77, 0x7D, 0x8D,
	0x91, 0x93, 0x92, 0x8A, 0x86, 0x87, 0x80, 0x7B, 0x75, 0x6D, 0x71, 0x74,
	0x71, 0x74, 0x81, 0x8B, 0x93, 0x96, 0x91, 0x92, 0x93, 0x8B, 0x84, 0x82,
	0x77, 0x71, 0x78, 0x77, 0x78, 0x80, 0x88, 0x95, 0x99, 0x93, 0x8F, 0x90,
	0x8B, 0x87, 0x83, 0x78, 0x6E, 0x6F, 0x71, 0x6E, 0x73, 0x78, 0x84, 0x90,
	0x8E, 0x89, 0x8B, 0x87, 0x7F, 0x7A, 0x73, 0x6F, 0x69, 0x68, 0x68, 0x6B,
	0x6F, 0x74, 0x85, 0x8D, 0x89, 0x89, 0x88, 0x84, 0x80, 0x77, 0x74, 0x70,
	0x65, 0x67, 0x6B, 0x6C, 0x72, 0x7D, 0x8B, 0x8F, 0x92, 0x93, 0x91, 0x8F,
	0x8A, 0x83, 0x81, 0x79, 0x6E, 0x71, 0x71, 0x74, 0x7C, 0x81, 0x8A, 0x90,
	0x92, 0x92, 0x95, 0x95, 0x8F, 0x8D, 0x8C, 0x7F, 0x75, 0x74, 0x75, 0x78,
	0x77, 0x7D, 0x8B, 0x8D, 0x89, 0x8C, 0x8F, 0x8C, 0x8C, 0x8D, 0x8A, 0x81,
	0x7A, 0x77, 0x78, 0x77, 0x74, 0x77, 0x81, 0x85, 0x87, 0x85, 0x85, 0x89,
	0x89, 0x86, 0x84, 0x82, 0x7B, 0x7B, 0x7E, 0x7B, 0x79, 0x7B, 0x84, 0x87,
	0x86, 0x87, 0x8C, 0x8D, 0x89, 0x87, 0x86, 0x82, 0x7C, 0x7D, 0x7B, 0x74,
	0x75, 0x76, 0x7B, 0x7D, 0x7F, 0x82, 0x85, 0x88, 0x87, 0x83, 0x7E, 0x7E,
	0x7C, 0x75, 0x73, 0x75, 0x75, 0x72, 0x75, 0x7A, 0x7B, 0x7F, 0x83, 0x86,
	0x84, 0x85, 0x85, 0x82, 0x7A, 0x73, 0x70, 0x70, 0x70, 0x73, 0x77, 0x78,
	0x81, 0x84, 0x83, 0x82, 0x83, 0x86, 0x88, 0x89, 0x84, 0x80, 0x7C, 0x7A,
	0x7A, 0x79, 0x7A, 0x82, 0x8A, 0x8A, 0x8A, 0x8A, 0x88, 0x89, 0x8B, 0x89,
	0x87, 0x84, 0x84, 0x83, 0x7C, 0x7D, 0x80, 0x85, 0x86, 0x87, 0x89, 0x83,
	0x83, 0x88, 0x85, 0x80, 0x81, 0x83, 0x82, 0x7F, 0x7C, 0x81, 0x81, 0x83,
	0x87, 0x87, 0x85, 0x86, 0x8B, 0x85, 0x81, 0x83, 0x81, 0x7E, 0x81, 0x80,
	0x7D, 0x80, 0x81, 0x82, 0x7E, 0x7C, 0x80, 0x82, 0x7E, 0x7C, 0x81, 0x7D,
	0x7C, 0x81, 0x7E, 0x7A, 0x7C, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x7F, 0x7B,
	0x78, 0x77, 0x77, 0x79, 0x81, 0x7D, 0x7A, 0x80, 0x80, 0x7C, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7C, 0x7B, 0x75, 0x73, 0x76, 0x78, 0x79, 0x7B, 0x83, 0x83,
	0x80, 0x84, 0x85, 0x80, 0x84, 0x84, 0x7E, 0x7A, 0x77, 0x78, 0x77, 0x78,
	0x7B, 0x81, 0x84, 0x86, 0x8A, 0x87, 0x84, 0x89, 0x8A, 0x83, 0x81, 0x80,
	0x7B, 0x7C, 0x7B, 0x7D, 0x82, 0x85, 0x88, 0x8A, 0x8A, 0x89, 0x8E, 0x8D,
	0x87, 0x85, 0x83, 0x7D, 0x7D, 0x7E, 0x7C, 0x81, 0x85, 0x89, 0x8C, 0x8A,
	0x89, 0x8C, 0x8D, 0x8A, 0x89, 0x87, 0x7F, 0x7E, 0x7F, 0x79, 0x7B, 0x82,
	0x83, 0x87, 0x89, 0x8A, 0x8C, 0x8C, 0x88, 0x85, 0x82, 0x7B, 0x7A, 0x76,
	0x6F, 0x71, 0x76, 0x76, 0x78, 0x7D, 0x7C, 0x7D, 0x81, 0x81, 0x80, 0x7E,
	0x7B, 0x79, 0x78, 0x72, 0x72, 0x77, 0x77, 0x79, 0x7F, 0x7F, 0x81, 0x84,
	0x83, 0x81, 0x7E, 0x7D, 0x7C, 0x7A, 0x77, 0x75, 0x78, 0x7A, 0x7D, 0x81,
	0x81, 0x82, 0x89, 0x88, 0x83, 0x84, 0x81, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A,
	0x7C, 0x81, 0x84, 0x84, 0x88, 0x8C, 0x8B, 0x89, 0x89, 0x87, 0x83, 0x82,
	0x7D, 0x7A, 0x79, 0x7B, 0x7E, 0x81, 0x81, 0x84, 0x86, 0x88, 0x89, 0x87,
	0x85, 0x84, 0x84, 0x81, 0x7C, 0x7D, 0x7D, 0x7E, 0x81, 0x85, 0x89, 0x8C,
	0x8C, 0x8A, 0x88, 0x86, 0x88, 0x87, 0x84, 0x82, 0x83, 0x83, 0x82, 0x84,
	0x85, 0x86, 0x88, 0x8A, 0x8A, 0x87, 0x84, 0x83, 0x81, 0x7C, 0x7C, 0x7B,
	0x7A, 0x7D, 0x7E, 0x7F, 0x7F, 0x83, 0x84, 0x83, 0x7E, 0x7B, 0x79, 0x77,
	0x75, 0x71, 0x6F, 0x6E, 0x71, 0x74, 0x73, 0x77, 0x7D, 0x81, 0x83, 0x81,
	0x7E, 0x7D, 0x7A, 0x78, 0x75, 0x72, 0x73, 0x75, 0x77, 0x77, 0x7B, 0x7F,
	0x84, 0x89, 0x8B, 0x89, 0x87, 0x86, 0x84, 0x80, 0x7A, 0x79, 0x7B, 0x7C,
	0x7E, 0x7E, 0x7E, 0x82, 0x89, 0x8C, 0x8B, 0x8C, 0x8C, 0x8A, 0x87, 0x82,
	0x80, 0x82, 0x80, 0x81, 0x81, 0x7E, 0x83, 0x87, 0x89, 0x89, 0x88, 0x88,
	0x88, 0x86, 0x82, 0x7E, 0x7C, 0x7D, 0x7C, 0x7B, 0x79, 0x7A, 0x7F, 0x80,
	0x83, 0x85, 0x85, 0x86, 0x88, 0x86, 0x83, 0x84, 0x86, 0x88, 0x86, 0x83,
	0x81, 0x82, 0x81, 0x81, 0x82, 0x82, 0x85, 0x86, 0x83, 0x7F, 0x81, 0x84,
	0x83, 0x85, 0x85, 0x81, 0x7F, 0x7F, 0x7C, 0x7B, 0x79, 0x7A, 0x7C, 0x79,
	0x78, 0x7A, 0x7B, 0x7D, 0x7E, 0x81, 0x80, 0x81, 0x81, 0x7E, 0x7A, 0x79,
	0x78, 0x77, 0x75, 0x71, 0x71, 0x73, 0x77, 0x7A, 0x7A, 0x7B, 0x7D, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x80, 0x7E, 0x7A, 0x78, 0x78, 0x7A, 0x7E, 0x7E,
	0x81, 0x85, 0x85, 0x87, 0x86, 0x87, 0x89, 0x8A, 0x89, 0x87, 0x83, 0x80,
	0x7F, 0x81, 0x82, 0x81, 0x84, 0x86, 0x88, 0x88, 0x86, 0x87, 0x89, 0x89,
	0x87, 0x85, 0x85, 0x85, 0x84, 0x84, 0x81, 0x82, 0x82, 0x81, 0x82, 0x7F,
	0x7E, 0x82, 0x81, 0x7D, 0x7B, 0x7C, 0x7E, 0x82, 0x84, 0x83, 0x83, 0x83,
	0x81, 0x81, 0x7F, 0x7E, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x82, 0x84,
	0x84, 0x86, 0x89, 0x8A, 0x88, 0x85, 0x81, 0x81, 0x82, 0x7E, 0x7D, 0x7C,
	0x7A, 0x7C, 0x7C, 0x7A, 0x7C, 0x7F, 0x82, 0x84, 0x84, 0x82, 0x81, 0x81,
	0x7C, 0x7B, 0x7A, 0x78, 0x79, 0x78, 0x75, 0x75, 0x77, 0x79, 0x7B, 0x7D,
	0x7D, 0x82, 0x84, 0x83, 0x7F, 0x7B, 0x79, 0x7A, 0x79, 0x75, 0x75, 0x77,
	0x77, 0x79, 0x7B, 0x7C, 0x7F, 0x84, 0x86, 0x88, 0x88, 0x88, 0x88, 0x86,
	0x81, 0x7E, 0x7F, 0x7C, 0x7F, 0x80, 0x7D, 0x7F, 0x84, 0x85, 0x86, 0x88,
	0x8A, 0x8E, 0x90, 0x8C, 0x88, 0x86, 0x84, 0x84, 0x82, 0x7D, 0x7F, 0x83,
	0x84, 0x83, 0x83, 0x83, 0x87, 0x8A, 0x88, 0x86, 0x86, 0x85, 0x83, 0x81,
	0x7A, 0x7A, 0x7C, 0x7B, 0x7D, 0x7D, 0x7A, 0x7D, 0x84, 0x84, 0x82, 0x83,
	0x84, 0x86, 0x87, 0x82, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7A, 0x7D, 0x83,
	0x81, 0x7D, 0x7E, 0x80, 0x82, 0x87, 0x84, 0x80, 0x83, 0x84, 0x83, 0x81,
	0x7C, 0x7B, 0x7D, 0x7B, 0x7A, 0x79, 0x77, 0x78, 0x7D, 0x7B, 0x78, 0x7B,
	0x7D, 0x7F, 0x84, 0x84, 0x81, 0x81, 0x7E, 0x7B, 0x78, 0x75, 0x76, 0x79,
	0x77, 0x75, 0x77, 0x79, 0x7E, 0x82, 0x83, 0x83, 0x86, 0x88, 0x83, 0x7F,
	0x7A, 0x78, 0x7A, 0x78, 0x77, 0x79, 0x7A, 0x7D, 0x82, 0x83, 0x85, 0x8B,
	0x8F, 0x8E, 0x8B, 0x89, 0x85, 0x85, 0x82, 0x7D, 0x7D, 0x7D, 0x82, 0x85,
	0x83, 0x83, 0x88, 0x8B, 0x8C, 0x8D, 0x8C, 0x8B, 0x8C, 0x89, 0x82, 0x7E,
	0x7C, 0x7B, 0x7E, 0x7E, 0x7E, 0x82, 0x83, 0x81, 0x83, 0x82, 0x82, 0x86,
	0x86, 0x83, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7A, 0x7E, 0x82, 0x82, 0x83,
	0x80, 0x7D, 0x81, 0x83, 0x7E, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F,
	0x83, 0x83, 0x83, 0x7F, 0x7E, 0x82, 0x84, 0x7C, 0x79, 0x78, 0x79, 0x7D,
	0x7E, 0x7F, 0x80, 0x85, 0x88, 0x85, 0x81, 0x7F, 0x7E, 0x7D, 0x79, 0x75,
	0x70, 0x6C, 0x71, 0x75, 0x77, 0x7C, 0x86, 0x8E, 0x8F, 0x8E, 0x8D, 0x8D,
	0x89, 0x83, 0x78, 0x6D, 0x6B, 0x6A, 0x69, 0x66, 0x6D, 0x7A, 0x88, 0x92,
	0x93, 0x96, 0x98, 0x9B, 0x9B, 0x91, 0x82, 0x71, 0x68, 0x61, 0x61, 0x61,
	0x63, 0x6E, 0x7D, 0x92, 0x9A, 0xA0, 0xA5, 0xA8, 0xA9, 0xA0, 0x98, 0x8D,
	0x7C, 0x6C, 0x60, 0x5B, 0x5F, 0x65, 0x6A, 0x74, 0x86, 0x9C, 0xA6, 0xA6,
	0xA1, 0x9D, 0x9C, 0x97, 0x8E, 0x83, 0x74, 0x67, 0x60, 0x59, 0x5E, 0x64,
	0x6F, 0x7A, 0x87, 0x9A, 0x9E, 0xA0, 0x9B, 0x93, 0x8F, 0x89, 0x88, 0x81,
	0x77, 0x68, 0x60, 0x5F, 0x67, 0x6E, 0x6E, 0x74, 0x7F, 0x94, 0x9C, 0x98,
	0x91, 0x8B, 0x8F, 0x8D, 0x8A, 0x83, 0x7B, 0x76, 0x6F, 0x66, 0x66, 0x6C,
	0x6E, 0x74, 0x77, 0x85, 0x92, 0x96, 0x95, 0x8C, 0x89, 0x89, 0x8F, 0x8E,
	0x82, 0x76, 0x6B, 0x66, 0x62, 0x66, 0x65, 0x68, 0x73, 0x82, 0x93, 0x95,
	0x96, 0x90, 0x8E, 0x8E, 0x8E, 0x8D, 0x85, 0x7F, 0x6E, 0x61, 0x5D, 0x63,
	0x6C, 0x6C, 0x72, 0x7E, 0x91, 0x9D, 0x9E, 0x94, 0x89, 0x8B, 0x8F, 0x91,
	0x86, 0x7C, 0x76, 0x6B, 0x67, 0x66, 0x71, 0x78, 0x7D, 0x86, 0x90, 0x9B,
	0xA2, 0x9E, 0x8F, 0x86, 0x86, 0x8C, 0x8D, 0x87, 0x81, 0x72, 0x6F, 0x73,
	0x7A, 0x7C, 0x79, 0x7E, 0x85, 0x90, 0x98, 0x95, 0x8A, 0x81, 0x83, 0x88,
	0x8E, 0x8E, 0x90, 0x80, 0x70, 0x6A, 0x6D, 0x75, 0x73, 0x6F, 0x6B, 0x74,
	0x87, 0x91, 0x8B, 0x81, 0x83, 0x8F, 0x9C, 0x9C, 0x97, 0x87, 0x73, 0x6B,
	0x63, 0x66, 0x65, 0x68, 0x66, 0x69, 0x7B, 0x8F, 0x9A, 0x97, 0x93, 0x91,
	0x97, 0x9F, 0x9F, 0x94, 0x76, 0x61, 0x56, 0x5A, 0x62, 0x63, 0x66, 0x66,
	0x7B, 0x92, 0xA1, 0x9F, 0x97, 0x93, 0x93, 0x98, 0x94, 0x8F, 0x7B, 0x60,
	0x4E, 0x4B, 0x5E, 0x6D, 0x78, 0x74, 0x79, 0x89, 0x9A, 0xA6, 0x9C, 0x8F,
	0x85, 0x88, 0x8F, 0x8D, 0x84, 0x6B, 0x5B, 0x54, 0x5E, 0x70, 0x79, 0x7A,
	0x77, 0x82, 0x8D, 0xA0, 0xA4, 0x9B, 0x8E, 0x83, 0x8A, 0x91, 0x9A, 0x8C,
	0x70, 0x5F, 0x59, 0x6C, 0x78, 0x80, 0x7A, 0x77, 0x7E, 0x8F, 0xA0, 0x9C,
	0x97, 0x8C, 0x8E, 0x95, 0x9C, 0x9D, 0x84, 0x6A, 0x53, 0x58, 0x6A, 0x79,
};

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

