/**
 ******************************************************************************
 *
 * @file        MG32_WWDT_Init.h
 *
 * @brief       This file is used to configure WWDT setting.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/03/09 16:00 (H File Generated Date)
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_WWDT.h"

#include "MG32__Common_DRV.h"

#if defined(IRQHandler_Middleware_Level_)       
#include "MG32_WWDT_MID.h"
#endif      // MG32 WWDT Middleware Define



#ifndef MG32_WWDT_Init_H
#define MG32_WWDT_Init_H

/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***
/**
 ******************************************************************************
 *
 * @brief       WWDT Initial Configure
 *
 ******************************************************************************
 */

//<h> WWDT Initialize Configure
    //<e0.0> WWDT Module Enable
    //  <i> When WWDT module not enable will not initialize WWDT module.
    #define CONF_WWDT_EN            0x00000001

        //<o0.0..9> WWDT Reload Value(0~1023) <0-1023>
        #define CONF_WWDT_RLR           1020

        //<o0.0..9> WWDT Window Compare Value(0~1023) <0-1023>
        #define CONF_WWDT_WIN           1020

        //<o0.0..9> WWDT Warning Compare Value(0~1023) <0-1023>
        #define CONF_WWDT_WRN           00000000

        //<o0.2>    WWDT Intput Clock Source Select <0=> CK_APB <1=> CK_UT
        #define CONF_WWDT_CK_SEL    0x00000000
        //<o0.6..4> WWDT Internal Clock Input Divider <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=> DIV8 <4=> DIV16 <5=> DIV32 <6=> DIV64 <7=> DIV128 
        #define CONF_WWDT_CK_DIV    0x00000000
        //<o0.8>    WWDT Internal Clock Pre-Divider <0=> DIV1 <1=> DIV256
        #define CONF_WWDT_CK_PDIV   0x00000000

        //<q0.4> WWDT Overfloat Reset Enable
        #define CONF_WWDT_RSTW_EN   0x00000000
        //<q0.5> WWDT Reload Counter Warning Reset Enable
        #define CONF_WWDT_RSTF_EN   0x00000000

        //<h> WWDT Interrupt Configure
            //<q0.1> WWDT Timeer Timeout Interrupt Enable.
            #define CONF_WWDT_TIE    0x00000000
            //<q0.2> WWDT Counter Window Compare Interrupt Enable.
            #define CONF_WWDT_WIN_IE    0x00000000
            //<q0.3> WWDT Counter Warning Interrupt Enable.
            #define CONF_WWDT_WRN_IE    0x00000000
        //</h>
    //</e>
//</h>

//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define CONF_WWDT_CLK   (CONF_WWDT_CK_SEL   |   \
                         CONF_WWDT_CK_DIV   |   \
                         CONF_WWDT_CK_PDIV)
#define CONF_WWDT_INT   (CONF_WWDT_TIE      |   \
                         CONF_WWDT_WIN_IE   |   \
                         CONF_WWDT_WRN_IE)
#define CONF_WWDT_CR0   (CONF_WWDT_RSTW_EN  |   \
                         CONF_WWDT_RSTF_EN)
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 * @name    Function announce
 *   
 */
///@{  
void WWDT_Init(void);
///@}


#endif // WWDT Configure Wizard Define End


