/**
 ******************************************************************************
 *
 * @file        MG32_CAN.h
 *
 * @brief       MG32 CAN Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.03 (Register File Date : 2025_0725)
 * @date        2025/08/11 17:18 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_CAN_H
#define _MG32_CAN_H
#define _MG32_CAN_H_VER                             103     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_CAN_H_VER)
    #error "_MG32_CAN_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      CAN_Struct
 *              CAN  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  BUSF          :1;     //[1] CAN bus-off interrupt flag. This bit is set when is happened bus-off (CAN_BUS_STA).
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EWF           :1;     //[2] CAN error warning interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WUPF          :1;     //[3] CAN wakeup from CAN low power state interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EPF           :1;     //[4] CAN error passive interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ALOSF         :1;     //[5] CAN bus arbitration lost interrupt flag. This bit is set when
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BERRF         :1;     //[6] CAN bus error interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  RX0F          :1;     //[8] CAN data receive message FIFO-0 interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RX1F          :1;     //[9] CAN data receive message FIFO-1 interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RFUL0F        :1;     //[10] CAN receive message FIFO-0 full interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RFUL1F        :1;     //[11] CAN receive message FIFO-1 full interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ROVR0F        :1;     //[12] CAN receive message FIFO-0 overrun interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ROVR1F        :1;     //[13] CAN receive message FIFO-1 overrun interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  RPEND0F       :1;     //[14] CAN receive data FIFO-1 remained pending interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  RPEND1F       :1;     //[15] CAN receive data FIFO-1 remained pending interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Pending (Event happened)
            __IO uint8_t  TX0F          :1;     //[16] CAN data transmit interrupt flag for TX message buffer-0.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TX1F          :1;     //[17] CAN data transmit interrupt flag for TX message buffer-1.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TX2F          :1;     //[18] CAN data transmit interrupt flag for TX message buffer-2.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :3;     //[26..24] 
            __I  uint8_t  EP_STA        :1;     //[27] CAN error passive status
                                        //0 = NonPassive : Error counter less than 128
                                        //1 = Passive : Error counter large than 127
            __I  uint8_t  EW_STA        :1;     //[28] CAN error counter status
                                        //0 = Normal
                                        //1 = ERR
            __I  uint8_t  BUS_STA       :1;     //[29] CAN bus status.
                                        //0 = ACT : The module is involved in bus activities.
                                        //1 = BOFF : The module is in Bus-Off state and is not involved in bus activities.
            __I  uint8_t  INIT_STA      :1;     //[30] CAN Initial mode status.This bit is set by hardware and cleared by hardware.
                                        //0 = Not : Not in Initial mode
                                        //1 = INIT : Now entered Initial mode
            __I  uint8_t  LP_STA        :1;     //[31] CAN low power mode status.This bit is set by hardware and cleared by hardware.
                                        //0 = Not : Not in CAN Sleep mode
                                        //1 = SLP : Now entered Sleep mode
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  CAN status register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] CAN interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BUS_IE        :1;     //[1] CAN bus-of interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EW_IE         :1;     //[2] CAN error warning interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WUP_IE        :1;     //[3] CAN wakeup from CAN sleep state interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP_IE         :1;     //[4] CAN error passive interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALOS_IE       :1;     //[5] CAN bus arbitration lost interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BERR_IE       :1;     //[6] CAN bus error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  RX0_IE        :1;     //[8] CAN data receive interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RX1_IE        :1;     //[9] CAN data receive interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RFUL0_IE      :1;     //[10] CAN receive message FIFO-0 full interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RFUL1_IE      :1;     //[11] CAN receive message FIFO-1 full interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ROVR0_IE      :1;     //[12] CAN receive message FIFO-0 overrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ROVR1_IE      :1;     //[13] CAN receive message FIFO-1 overrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RPEND0_IE     :1;     //[14] CAN receive data FIFO-0 remained pending interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RPEND1_IE     :1;     //[15] CAN receive data FIFO-1 remained pending interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX0_IE        :1;     //[16] CAN data transmit Interrupt enable for TX message buffer-0.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX1_IE        :1;     //[17] CAN data transmit Interrupt enable for TX message buffer-1.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX2_IE        :1;     //[18] CAN data transmit Interrupt enable for TX message buffer-2.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  CAN interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __IO uint8_t  CK_SEL        :2;     //[3..2] CAN internal clock CK_CANx source select.
                                        //0x0 = PROC : CK_CANx_PR process clock from CSC
                                        //0x1 = NCO_P0
                                        //0x2 = CK_LS
                                        //0x3 = Reserved
            __I  uint8_t                :3;     //[6..4] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CKO_DIV       :3;     //[10..8] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :4;     //[15..12] 
            __IO uint16_t BRP           :10;    //[25..16] CAN internal clock CK_CANx_TQ divider as baud rate prescaler
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  CAN clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX_STA        :1;     //[0] CAN data receive busy status.
                                        //0 = No : Nothing is currently being received.
                                        //1 = Busy : The module is in the process of receiving a message.
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t  RFUL0_STA     :1;     //[2] CAN data receive FIFO full status for RX message FIFO-0
                                        //0 = Normal
                                        //1 = Full
            __I  uint8_t  RFUL1_STA     :1;     //[3] CAN data receive FIFO full status for RX message FIFO-1
                                        //0 = Normal
                                        //1 = Full
            __I  uint8_t  ROVR0_STA     :1;     //[4] CAN data receive FIFO overrun status for RX message FIFO-0
                                        //0 = Normal
                                        //1 = Overrun
            __I  uint8_t  ROVR1_STA     :1;     //[5] CAN data receive FIFO overrun status for RX message FIFO-1
                                        //0 = Normal
                                        //1 = Overrun
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t  TX_STA        :1;     //[8] CAN data transmit busy status.
                                        //0 = No : No message is being transmitted.
                                        //1 = Busy : The module is in the process of transmitting a message.
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t  TC0_STA       :1;     //[12] CAN data transmit complete status for TX message buffer-0
                                        //0 = Normal
                                        //1 = Happened
            __I  uint8_t  TC1_STA       :1;     //[13] CAN data transmit complete status for TX message buffer-1
                                        //0 = Normal
                                        //1 = Happened
            __I  uint8_t  TC2_STA       :1;     //[14] CAN data transmit complete status for TX message buffer-2
                                        //0 = Normal
                                        //1 = Happened
            __I  uint8_t                :1;     //[15] 
            __I  uint8_t  TB0_STA       :1;     //[16] CAN data transmit buffer status for TX message buffer-0
                                        //0 = Lock : Transmit buffer locked.
                                        //1 = Release : Transmit buffer released.
            __I  uint8_t  TB1_STA       :1;     //[17] CAN data transmit buffer status for TX message buffer-1
                                        //0 = Lock : Transmit buffer locked.
                                        //1 = Release : Transmit buffer released.
            __I  uint8_t  TB2_STA       :1;     //[18] CAN data transmit buffer status for TX message buffer-2
                                        //0 = Lock : Transmit buffer locked.
                                        //1 = Release : Transmit buffer released.
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t  RX0_NUM       :3;     //[26..24] CAN  received and updated message buffer number value for RX FIFO-0
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t  RX1_NUM       :2;     //[29..28] CAN received and updated message buffer number value for RX FIFO-1
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }STA2;                              /*!< STA2       ~ Offset[0x0C]  CAN status register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] CAN function enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  INIT_EN       :1;     //[1] CAN Initial mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LP_EN         :1;     //[2] CAN Low Power mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WUP_MDS       :1;     //[3] CAN wakeup mode select
                                        //0 = Soft
                                        //1 = Auto
            __IO uint8_t  TST_MDS       :3;     //[6..4] CAN test mode select
                                        //0x0 = Disable
                                        //0x1 = LBM : Loop back mode
                                        //0x2 = SIL : Silent mode
                                        //0x3 = LBS : Loop back combined with silent mode
                                        //0x4 = Reserved
                                        //0x5 = Reserved
                                        //0x6 = Reserved
                                        //0x7 = Reserved
            __IO uint8_t  OS_MDS        :1;     //[7] CAN RX data oversampling mode select
                                        //0 = One
                                        //1 = Three
            __IO uint8_t  IO_SWP        :1;     //[8] CAN_RX/CAN_TX swap enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SYNC_MDS      :1;     //[9] 
            __IO uint8_t  RX_INV        :1;     //[10] CAN_RX input signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_INV        :1;     //[11] CAN_TX output signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  FDT_MDS       :1;     //[12] CAN receive FDF bit mode select
                                        //0 = Normal
                                        //1 = Skip
            __IO uint8_t  EDF_MDS       :1;     //[13] CAN receive edge detect filter mode select after FDF bit is detected
                                        //0 = Normal
                                        //1 = Sample
            __IO uint8_t  TXE_MDS       :1;     //[14] CAN message transmission mode select
                                        //0 = Resend
                                        //1 = Once
            __IO uint8_t  SRR_EN        :1;     //[15] CAN self reception request enable bit
                                        //0 = Disble
                                        //1 = Enable
            __IO uint8_t  S0_SEL        :2;     //[17..16] CAN_S0 output signal select
                                        //0x0 = STB : CAN_STB signal (active high)
                                        //0x1 = BCLK : Internal using
                                        //0x2 = TXINV : Inversed TX signal
                                        //0x3 = CKO : Internal using
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  S1_SEL        :2;     //[21..20] CAN_S1 output signal select
                                        //0x0 = OUT1 : Internal using
                                        //0x1 = TCLK : CK_CAN_TQ
                                        //0x2 = SMP : Internal using
                                        //0x3 = RXS : Internal using
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  ROVR_MDS      :1;     //[24] CAN receive message buffer overrun mode select.
                                        //0 = Overwritten (Overwritten by new message)
                                        //1 = Keep (Preserved old message)
            __IO uint8_t  RBUF_SEL      :1;     //[25] CAN receive message buffer type select
                                        //0x0 = Two : Two FIFO structure
                                        //0x1 = One : One FIFO structure
            __I  uint8_t                :1;     //[26] 
            __IO uint8_t  TX_PRI        :1;     //[27] CAN TX message buffer process priority mode select
                                        //0 = ID : message identifier 
                                        //1 = SEQ : request sequence order
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  CAN control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TSEG1         :4;     //[3..0] CAN Time segment 1 register
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  TSEG2         :3;     //[10..8] CAN time segment 2 register
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  SJW           :2;     //[17..16] CAN resynchronization jump width
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  CAN control register 1 */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x18]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EW_LIM        :8;     //[7..0] CAN error warning limit register
            __IO uint8_t  RXERR_CNT     :8;     //[15..8] CAN receive error counter. This counter is incremented when
            __IO uint8_t  TXERR_CNT     :8;     //[23..16] CAN transmit error counter
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  RXERR_MDS     :1;     //[31] CAN reveive error counter control mode select
                                        //0 = Normal
                                        //1 = Passive
        }MBIT;
    }CR3;                               /*!< CR3        ~ Offset[0x1C]  CAN control register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ECC_SEG       :5;     //[4..0] CAN error segment code capture register
            __I  uint8_t                :2;     //[6..5] 
            __I  uint8_t  ECC_DIR       :1;     //[7] CAN error code capture of direction
                                        //0 = TX : the error occurred during reception
                                        //1 = RX : the error occurred during transmission
            __I  uint8_t  ECC_ERR       :3;     //[10..8] CAN error code capture register
                                        //0x0 = No : No error
                                        //0x1 = Bit : Bit error
                                        //0x2 = Form : Form error
                                        //0x3 = Stuff : Stuff error
                                        //0x4 = CRC : CRC error
                                        //0x5 = Reserved
                                        //0x6 = Reserved
                                        //0x7 = Others : Some other type of error
            __I  uint8_t                :5;     //[15..11] 
            __I  uint8_t  ECC_ALC       :5;     //[20..16] CAN arbitration lost bit position capture register
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }STA3;                              /*!< STA3       ~ Offset[0x20]  CAN status register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  AF0_EN        :1;     //[0] CAN acceptance filter-0 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AF1_EN        :1;     //[1] CAN acceptance filter-1 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AF2_EN        :1;     //[2] CAN acceptance filter-2 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AF3_EN        :1;     //[3] CAN acceptance filter-3 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AF4_EN        :1;     //[4] CAN acceptance filter-4 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AF5_EN        :1;     //[5] CAN acceptance filter-5 enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  AF0_FSEL      :1;     //[16] CAN acceptance filter-0 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __IO uint8_t  AF1_FSEL      :1;     //[17] CAN acceptance filter-1 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __IO uint8_t  AF2_FSEL      :1;     //[18] CAN acceptance filter-2 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __IO uint8_t  AF3_FSEL      :1;     //[19] CAN acceptance filter-3 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __IO uint8_t  AF4_FSEL      :1;     //[20] CAN acceptance filter-4 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __IO uint8_t  AF5_FSEL      :1;     //[21] CAN acceptance filter-5 FIFO select.
                                        //0 = FIFO0
                                        //1 = FIFO1
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }AFC0;                              /*!< AFC0       ~ Offset[0x24]  CAN acceptance filter control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  AF0_MDS       :1;     //[0] CAN acceptance filter-0 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __IO uint8_t  AF1_MDS       :1;     //[1] CAN acceptance filter-1 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __IO uint8_t  AF2_MDS       :1;     //[2] CAN acceptance filter-2 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __IO uint8_t  AF3_MDS       :1;     //[3] CAN acceptance filter-3 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __IO uint8_t  AF4_MDS       :1;     //[4] CAN acceptance filter-4 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __IO uint8_t  AF5_MDS       :1;     //[5] CAN acceptance filter-5 mode select
                                        //0 = MaskMode
                                        //1 = ListMode
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  AF0_CFG       :1;     //[16] CAN acceptance filter-0 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __IO uint8_t  AF1_CFG       :1;     //[17] CAN acceptance filter-1 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __IO uint8_t  AF2_CFG       :1;     //[18] CAN acceptance filter-2 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __IO uint8_t  AF3_CFG       :1;     //[19] CAN acceptance filter-3 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __IO uint8_t  AF4_CFG       :1;     //[20] CAN acceptance filter-4 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __IO uint8_t  AF5_CFG       :1;     //[21] CAN acceptance filter-5 configuration
                                        //0 = Single: Single 32-bit filter
                                        //1 = Dual : Dual 16-bit filters
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }AFC1;                              /*!< AFC1       ~ Offset[0x28]  CAN acceptance filter control register 1 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x2C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF0R0         :32;    //[31..0] CAN acceptance filter-0 register 0.
        }MBIT;
    }AF0R0;                             /*!< AF0R0      ~ Offset[0x30]  CAN acceptance filter-0 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF0R1         :32;    //[31..0] CAN acceptance filter-0 register 1.
        }MBIT;
    }AF0R1;                             /*!< AF0R1      ~ Offset[0x34]  CAN acceptance filter-0 register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF1R0         :32;    //[31..0] CAN acceptance filter-1 register 0
        }MBIT;
    }AF1R0;                             /*!< AF1R0      ~ Offset[0x38]  CAN acceptance filter-1 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF1R1         :32;    //[31..0] CAN acceptance filter-1 register 1
        }MBIT;
    }AF1R1;                             /*!< AF1R1      ~ Offset[0x3C]  CAN acceptance filter-1 register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF2R0         :32;    //[31..0] CAN acceptance filter-1 register 0
        }MBIT;
    }AF2R0;                             /*!< AF2R0      ~ Offset[0x40]  CAN acceptance filter-2 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF2R1         :32;    //[31..0] CAN acceptance filter-1 register 1
        }MBIT;
    }AF2R1;                             /*!< AF2R1      ~ Offset[0x44]  CAN acceptance filter-2 register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF3R0         :32;    //[31..0] CAN acceptance filter-1 register 0
        }MBIT;
    }AF3R0;                             /*!< AF3R0      ~ Offset[0x48]  CAN acceptance filter-3 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF3R1         :32;    //[31..0] CAN acceptance filter-1 register 1
        }MBIT;
    }AF3R1;                             /*!< AF3R1      ~ Offset[0x4C]  CAN acceptance filter-3 register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF4R0         :32;    //[31..0] CAN acceptance filter-1 register 0
        }MBIT;
    }AF4R0;                             /*!< AF4R0      ~ Offset[0x50]  CAN acceptance filter-4 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF4R1         :32;    //[31..0] CAN acceptance filter-1 register 1
        }MBIT;
    }AF4R1;                             /*!< AF4R1      ~ Offset[0x54]  CAN acceptance filter-4 register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF5R0         :32;    //[31..0] CAN acceptance filter-1 register 0
        }MBIT;
    }AF5R0;                             /*!< AF5R0      ~ Offset[0x58]  CAN acceptance filter-5 register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t AF5R1         :32;    //[31..0] CAN acceptance filter-1 register 1
        }MBIT;
    }AF5R1;                             /*!< AF5R1      ~ Offset[0x5C]  CAN acceptance filter-5 register 1 */

    __I uint32_t  RESERVED2[16];        /*!< RESERVED2  ~ Offset[0x60]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t RX0_EID       :18;    //[17..0] CAN receiving message EID bits
            __I  uint16_t RX0_SID       :11;    //[28..18] CAN receiving message SID bits
            __I  uint8_t  RX0_RTR       :1;     //[29] CAN receiving message RTR bit.
                                        //0 = Date : Data frame
                                        //1 = Remote : Remote frame
            __I  uint8_t  RX0_IDE       :1;     //[30] CAN receiving message IDE bit.
                                        //0 = STD : Standard identifier
                                        //1 = EXT : Extended identifier
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }RDAT00;                            /*!< RDAT00     ~ Offset[0xA0]  CAN receive FIFO-0 data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX0_DLC       :4;     //[3..0] CAN receiving message DLC bits.
            __I  uint8_t                :4;     //[7..4] 
            __O  uint8_t  RX0_CLR       :1;     //[8] CAN receive message FIFO-0 active buffer clear and release enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __O  uint8_t  RX0_RST       :1;     //[9] CAN receive message FIFO-0 reset enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }RDAT01;                            /*!< RDAT01     ~ Offset[0xA4]  CAN receive FIFO-0 data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX0_D0        :8;     //[7..0] CAN receiving message data byte-0.
            __I  uint8_t  RX0_D1        :8;     //[15..8] CAN receiving message data byte-1.
            __I  uint8_t  RX0_D2        :8;     //[23..16] CAN receiving message data byte-2.
            __I  uint8_t  RX0_D3        :8;     //[31..24] CAN receiving message data byte-3.
        }MBIT;
    }RDAT02;                            /*!< RDAT02     ~ Offset[0xA8]  CAN receive FIFO-0 data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX0_D4        :8;     //[7..0] CAN receiving message data byte-4.
            __I  uint8_t  RX0_D5        :8;     //[15..8] CAN receiving message data byte-5.
            __I  uint8_t  RX0_D6        :8;     //[23..16] CAN receiving message data byte-6.
            __I  uint8_t  RX0_D7        :8;     //[31..24] CAN receiving message data byte-7.
        }MBIT;
    }RDAT03;                            /*!< RDAT03     ~ Offset[0xAC]  CAN receive FIFO-0 data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t RX1_EID       :18;    //[17..0] CAN receiving message EID bits
            __I  uint16_t RX1_SID       :11;    //[28..18] CAN receiving message SID bits
            __I  uint8_t  RX1_RTR       :1;     //[29] CAN receiving message RTR bit.
                                        //0 = Date : Data frame
                                        //1 = Remote : Remote frame
            __I  uint8_t  RX1_IDE       :1;     //[30] CAN receiving message IDE bit.
                                        //0 = STD : Standard identifier
                                        //1 = EXT : Extended identifier
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }RDAT10;                            /*!< RDAT10     ~ Offset[0xB0]  CAN receive FIFO-1 data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX1_DLC       :4;     //[3..0] CAN receiving message DLC bits.
            __I  uint8_t                :4;     //[7..4] 
            __O  uint8_t  RX1_CLR       :1;     //[8] CAN receive message FIFO-1 active buffer clear and release enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __O  uint8_t  RX1_RST       :1;     //[9] CAN receive message FIFO-1 reset enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }RDAT11;                            /*!< RDAT11     ~ Offset[0xB4]  CAN receive FIFO-1 data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX1_D0        :8;     //[7..0] CAN receiving message data byte-0.
            __I  uint8_t  RX1_D1        :8;     //[15..8] CAN receiving message data byte-1.
            __I  uint8_t  RX1_D2        :8;     //[23..16] CAN receiving message data byte-2.
            __I  uint8_t  RX1_D3        :8;     //[31..24] CAN receiving message data byte-3.
        }MBIT;
    }RDAT12;                            /*!< RDAT12     ~ Offset[0xB8]  CAN receive FIFO-1 data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RX1_D4        :8;     //[7..0] CAN receiving message data byte-4.
            __I  uint8_t  RX1_D5        :8;     //[15..8] CAN receiving message data byte-5.
            __I  uint8_t  RX1_D6        :8;     //[23..16] CAN receiving message data byte-6.
            __I  uint8_t  RX1_D7        :8;     //[31..24] CAN receiving message data byte-7.
        }MBIT;
    }RDAT13;                            /*!< RDAT13     ~ Offset[0xBC]  CAN receive FIFO-1 data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t TX0_EID       :18;    //[17..0] CAN transmitted message EID bits
            __IO uint16_t TX0_SID       :11;    //[28..18] CAN transmitted message SID bits
            __IO uint8_t  TX0_RTR       :1;     //[29] CAN transmitted message RTR bit.
                                        //0 = Date : Data frame
                                        //1 = Remote : Remote frame
            __IO uint8_t  TX0_IDE       :1;     //[30] CAN transmitted message IDE bit.
                                        //0 = STD : Standard identifier
                                        //1 = EXT : Extended identifier
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }TDAT00;                            /*!< TDAT00     ~ Offset[0xC0]  CAN transmit buffer-0 data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX0_DLC       :4;     //[3..0] CAN transmitted message DLC bits.
            __I  uint8_t                :4;     //[7..4] 
            __O  uint8_t  TX0_REQ       :1;     //[8] CAN transmission request enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __O  uint8_t  TX0_STOP      :1;     //[9] CAN abort transmission enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TDAT01;                            /*!< TDAT01     ~ Offset[0xC4]  CAN transmit buffer-0 data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX0_D0        :8;     //[7..0] CAN transmitted message data byte-0.
            __IO uint8_t  TX0_D1        :8;     //[15..8] CAN transmitted message data byte-1.
            __IO uint8_t  TX0_D2        :8;     //[23..16] CAN transmitted message data byte-2.
            __IO uint8_t  TX0_D3        :8;     //[31..24] CAN transmitted message data byte-3.
        }MBIT;
    }TDAT02;                            /*!< TDAT02     ~ Offset[0xC8]  CAN transmit buffer-0 data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX0_D4        :8;     //[7..0] CAN transmitted message data byte-4.
            __IO uint8_t  TX0_D5        :8;     //[15..8] CAN transmitted message data byte-5.
            __IO uint8_t  TX0_D6        :8;     //[23..16] CAN transmitted message data byte-6.
            __IO uint8_t  TX0_D7        :8;     //[31..24] CAN transmitted message data byte-7.
        }MBIT;
    }TDAT03;                            /*!< TDAT03     ~ Offset[0xCC]  CAN transmit buffer-0 data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t TX1_EID       :18;    //[17..0] CAN transmitted message EID bits
            __IO uint16_t TX1_SID       :11;    //[28..18] CAN transmitted message SID bits
            __IO uint8_t  TX1_RTR       :1;     //[29] CAN transmitted message RTR bit.
                                        //0 = Date : Data frame
                                        //1 = Remote : Remote frame
            __IO uint8_t  TX1_IDE       :1;     //[30] CAN transmitted message IDE bit.
                                        //0 = STD : Standard identifier
                                        //1 = EXT : Extended identifier
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }TDAT10;                            /*!< TDAT10     ~ Offset[0xD0]  CAN transmit buffer-1 data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX1_DLC       :4;     //[3..0] CAN transmitted message DLC bits.
            __I  uint8_t                :4;     //[7..4] 
            __O  uint8_t  TX1_REQ       :1;     //[8] CAN transmission request enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __O  uint8_t  TX1_STOP      :1;     //[9] CAN abort transmission enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TDAT11;                            /*!< TDAT11     ~ Offset[0xD4]  CAN transmit buffer-1 data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX1_D0        :8;     //[7..0] CAN transmitted message data byte-0.
            __IO uint8_t  TX1_D1        :8;     //[15..8] CAN transmitted message data byte-1.
            __IO uint8_t  TX1_D2        :8;     //[23..16] CAN transmitted message data byte-2.
            __IO uint8_t  TX1_D3        :8;     //[31..24] CAN transmitted message data byte-3.
        }MBIT;
    }TDAT12;                            /*!< TDAT12     ~ Offset[0xD8]  CAN transmit buffer-1 data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX1_D4        :8;     //[7..0] CAN transmitted message data byte-4.
            __IO uint8_t  TX1_D5        :8;     //[15..8] CAN transmitted message data byte-5.
            __IO uint8_t  TX1_D6        :8;     //[23..16] CAN transmitted message data byte-6.
            __IO uint8_t  TX1_D7        :8;     //[31..24] CAN transmitted message data byte-7.
        }MBIT;
    }TDAT13;                            /*!< TDAT13     ~ Offset[0xDC]  CAN transmit buffer-1 data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t TX2_EID       :18;    //[17..0] CAN transmitted message EID bits
            __IO uint16_t TX2_SID       :11;    //[28..18] CAN transmitted message SID bits
            __IO uint8_t  TX2_RTR       :1;     //[29] CAN transmitted message RTR bit.
                                        //0 = Date : Data frame
                                        //1 = Remote : Remote frame
            __IO uint8_t  TX2_IDE       :1;     //[30] CAN transmitted message IDE bit.
                                        //0 = STD : Standard identifier
                                        //1 = EXT : Extended identifier
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }TDAT20;                            /*!< TDAT20     ~ Offset[0xE0]  CAN transmit buffer-2 data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX2_DLC       :4;     //[3..0] CAN transmitted message DLC bits.
            __I  uint8_t                :4;     //[7..4] 
            __O  uint8_t  TX2_REQ       :1;     //[8] CAN transmission request enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __O  uint8_t  TX2_STOP      :1;     //[9] CAN abort transmission enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TDAT21;                            /*!< TDAT21     ~ Offset[0xE4]  CAN transmit buffer-2 data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX2_D0        :8;     //[7..0] CAN transmitted message data byte-0.
            __IO uint8_t  TX2_D1        :8;     //[15..8] CAN transmitted message data byte-1.
            __IO uint8_t  TX2_D2        :8;     //[23..16] CAN transmitted message data byte-2.
            __IO uint8_t  TX2_D3        :8;     //[31..24] CAN transmitted message data byte-3.
        }MBIT;
    }TDAT22;                            /*!< TDAT22     ~ Offset[0xE8]  CAN transmit buffer-2 data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TX2_D4        :8;     //[7..0] CAN transmitted message data byte-4.
            __IO uint8_t  TX2_D5        :8;     //[15..8] CAN transmitted message data byte-5.
            __IO uint8_t  TX2_D6        :8;     //[23..16] CAN transmitted message data byte-6.
            __IO uint8_t  TX2_D7        :8;     //[31..24] CAN transmitted message data byte-7.
        }MBIT;
    }TDAT23;                            /*!< TDAT23     ~ Offset[0xEC]  CAN transmit buffer-2 data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  SM            :6;     //[5..0] 
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t  WP0           :2;     //[9..8] 
            __I  uint8_t  RP0           :2;     //[11..10] 
            __I  uint8_t  WP1           :2;     //[13..12] 
            __I  uint8_t  RP1           :2;     //[15..14] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TST0;                              /*!< TST0       ~ Offset[0xF0]  CAN control register 0 */

} CAN_Struct;

/**
 ******************************************************************************
 *
 * @name        CAN  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CAN0_Base                       ((uint32_t)0x54080000)              /*!< Controller Area Network Control Module-0 */
#define CAN0                            ((CAN_Struct*) CAN0_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        CAN  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        CAN_STA  [register's definitions]
 *              Offset[0x00]  CAN status register 1
 ******************************************************************************
 */
///@{
#define CAN_STA_default                             ((uint32_t)0x40000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_STA */
#define CAN_STA_LP_STA_mask_w                       ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CAN_STA_LP_STA_mask_h1                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CAN_STA_LP_STA_mask_b3                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_STA_LP_STA_not_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define CAN_STA_LP_STA_not_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define CAN_STA_LP_STA_not_b3                       ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define CAN_STA_LP_STA_slp_w                        ((uint32_t)0x80000000)  /*!< Bit Value =(1):SLP of 32bit */
#define CAN_STA_LP_STA_slp_h1                       ((uint16_t)0x8000)      /*!< Bit Value =(1):SLP of 16bit */
#define CAN_STA_LP_STA_slp_b3                       ((uint8_t )0x80)        /*!< Bit Value =(1):SLP of 8bit */

#define CAN_STA_INIT_STA_mask_w                     ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_STA_INIT_STA_mask_h1                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_STA_INIT_STA_mask_b3                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_STA_INIT_STA_not_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define CAN_STA_INIT_STA_not_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define CAN_STA_INIT_STA_not_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define CAN_STA_INIT_STA_init_w                     ((uint32_t)0x40000000)  /*!< Bit Value =(1):INIT of 32bit */
#define CAN_STA_INIT_STA_init_h1                    ((uint16_t)0x4000)      /*!< Bit Value =(1):INIT of 16bit */
#define CAN_STA_INIT_STA_init_b3                    ((uint8_t )0x40)        /*!< Bit Value =(1):INIT of 8bit */

#define CAN_STA_BUS_STA_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_STA_BUS_STA_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_STA_BUS_STA_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_STA_BUS_STA_act_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):ACT of 32bit */
#define CAN_STA_BUS_STA_act_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):ACT of 16bit */
#define CAN_STA_BUS_STA_act_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):ACT of 8bit */
#define CAN_STA_BUS_STA_boff_w                      ((uint32_t)0x20000000)  /*!< Bit Value =(1):BOFF of 32bit */
#define CAN_STA_BUS_STA_boff_h1                     ((uint16_t)0x2000)      /*!< Bit Value =(1):BOFF of 16bit */
#define CAN_STA_BUS_STA_boff_b3                     ((uint8_t )0x20)        /*!< Bit Value =(1):BOFF of 8bit */

#define CAN_STA_EW_STA_mask_w                       ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CAN_STA_EW_STA_mask_h1                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CAN_STA_EW_STA_mask_b3                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_STA_EW_STA_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_EW_STA_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_EW_STA_normal_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_EW_STA_err_w                        ((uint32_t)0x10000000)  /*!< Bit Value =(1):ERR of 32bit */
#define CAN_STA_EW_STA_err_h1                       ((uint16_t)0x1000)      /*!< Bit Value =(1):ERR of 16bit */
#define CAN_STA_EW_STA_err_b3                       ((uint8_t )0x10)        /*!< Bit Value =(1):ERR of 8bit */

#define CAN_STA_EP_STA_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define CAN_STA_EP_STA_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CAN_STA_EP_STA_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_STA_EP_STA_nonpassive_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):NonPassive of 32bit */
#define CAN_STA_EP_STA_nonpassive_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):NonPassive of 16bit */
#define CAN_STA_EP_STA_nonpassive_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):NonPassive of 8bit */
#define CAN_STA_EP_STA_passive_w                    ((uint32_t)0x08000000)  /*!< Bit Value =(1):Passive of 32bit */
#define CAN_STA_EP_STA_passive_h1                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Passive of 16bit */
#define CAN_STA_EP_STA_passive_b3                   ((uint8_t )0x08)        /*!< Bit Value =(1):Passive of 8bit */

#define CAN_STA_TX2F_mask_w                         ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CAN_STA_TX2F_mask_h1                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_STA_TX2F_mask_b2                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_STA_TX2F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_TX2F_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_TX2F_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_TX2F_happened_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_TX2F_happened_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_TX2F_happened_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_TX1F_mask_w                         ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CAN_STA_TX1F_mask_h1                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_STA_TX1F_mask_b2                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_STA_TX1F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_TX1F_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_TX1F_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_TX1F_happened_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_TX1F_happened_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_TX1F_happened_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_TX0F_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CAN_STA_TX0F_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_STA_TX0F_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_STA_TX0F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_TX0F_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_TX0F_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_TX0F_happened_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_TX0F_happened_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_TX0F_happened_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_RPEND1F_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CAN_STA_RPEND1F_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CAN_STA_RPEND1F_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_STA_RPEND1F_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RPEND1F_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RPEND1F_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RPEND1F_pending_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Pending of 32bit */
#define CAN_STA_RPEND1F_pending_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Pending of 16bit */
#define CAN_STA_RPEND1F_pending_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Pending of 8bit */

#define CAN_STA_RPEND0F_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define CAN_STA_RPEND0F_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_STA_RPEND0F_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_STA_RPEND0F_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RPEND0F_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RPEND0F_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RPEND0F_happened_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_RPEND0F_happened_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_RPEND0F_happened_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_ROVR1F_mask_w                       ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define CAN_STA_ROVR1F_mask_h0                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_STA_ROVR1F_mask_b1                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_STA_ROVR1F_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_ROVR1F_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_ROVR1F_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_ROVR1F_happened_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_ROVR1F_happened_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_ROVR1F_happened_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_ROVR0F_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CAN_STA_ROVR0F_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CAN_STA_ROVR0F_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_STA_ROVR0F_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_ROVR0F_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_ROVR0F_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_ROVR0F_happened_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_ROVR0F_happened_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_ROVR0F_happened_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_RFUL1F_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CAN_STA_RFUL1F_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CAN_STA_RFUL1F_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_STA_RFUL1F_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RFUL1F_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RFUL1F_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RFUL1F_happened_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_RFUL1F_happened_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_RFUL1F_happened_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_RFUL0F_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define CAN_STA_RFUL0F_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CAN_STA_RFUL0F_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_STA_RFUL0F_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RFUL0F_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RFUL0F_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RFUL0F_happened_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_RFUL0F_happened_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_RFUL0F_happened_b1                  ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_RX1F_mask_w                         ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_STA_RX1F_mask_h0                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_STA_RX1F_mask_b1                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_STA_RX1F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RX1F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RX1F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RX1F_happened_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_RX1F_happened_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_RX1F_happened_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_RX0F_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_STA_RX0F_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_STA_RX0F_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_STA_RX0F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_RX0F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_RX0F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_RX0F_happened_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_RX0F_happened_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_RX0F_happened_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_BERRF_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CAN_STA_BERRF_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CAN_STA_BERRF_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_STA_BERRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_BERRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_BERRF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_BERRF_happened_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_BERRF_happened_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_BERRF_happened_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_ALOSF_mask_w                        ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CAN_STA_ALOSF_mask_h0                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_STA_ALOSF_mask_b0                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_STA_ALOSF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_ALOSF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_ALOSF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_ALOSF_happened_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_ALOSF_happened_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_ALOSF_happened_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_EPF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CAN_STA_EPF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_STA_EPF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_STA_EPF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_EPF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_EPF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_EPF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_EPF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_EPF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_WUPF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_STA_WUPF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_STA_WUPF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_STA_WUPF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_WUPF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_WUPF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_WUPF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_WUPF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_WUPF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_EWF_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_STA_EWF_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_STA_EWF_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_STA_EWF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_EWF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_EWF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_EWF_happened_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_EWF_happened_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_EWF_happened_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA_BUSF_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CAN_STA_BUSF_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_STA_BUSF_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_STA_BUSF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA_BUSF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA_BUSF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA_BUSF_happened_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA_BUSF_happened_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA_BUSF_happened_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_INT  [register's definitions]
 *              Offset[0x04]  CAN interrupt enable register
 ******************************************************************************
 */
///@{
#define CAN_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_INT */
#define CAN_INT_TX2_IE_mask_w                       ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CAN_INT_TX2_IE_mask_h1                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_INT_TX2_IE_mask_b2                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_INT_TX2_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_TX2_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_TX2_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_TX2_IE_enable_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_TX2_IE_enable_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_TX2_IE_enable_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_TX1_IE_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CAN_INT_TX1_IE_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_INT_TX1_IE_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_INT_TX1_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_TX1_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_TX1_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_TX1_IE_enable_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_TX1_IE_enable_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_TX1_IE_enable_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_TX0_IE_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CAN_INT_TX0_IE_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_INT_TX0_IE_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_INT_TX0_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_TX0_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_TX0_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_TX0_IE_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_TX0_IE_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_TX0_IE_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RPEND1_IE_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CAN_INT_RPEND1_IE_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CAN_INT_RPEND1_IE_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_INT_RPEND1_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RPEND1_IE_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RPEND1_IE_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RPEND1_IE_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RPEND1_IE_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RPEND1_IE_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RPEND0_IE_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define CAN_INT_RPEND0_IE_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_INT_RPEND0_IE_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_INT_RPEND0_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RPEND0_IE_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RPEND0_IE_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RPEND0_IE_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RPEND0_IE_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RPEND0_IE_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_ROVR1_IE_mask_w                     ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define CAN_INT_ROVR1_IE_mask_h0                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_INT_ROVR1_IE_mask_b1                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_INT_ROVR1_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_ROVR1_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_ROVR1_IE_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_ROVR1_IE_enable_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_ROVR1_IE_enable_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_ROVR1_IE_enable_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_ROVR0_IE_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CAN_INT_ROVR0_IE_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CAN_INT_ROVR0_IE_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_INT_ROVR0_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_ROVR0_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_ROVR0_IE_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_ROVR0_IE_enable_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_ROVR0_IE_enable_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_ROVR0_IE_enable_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RFUL1_IE_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CAN_INT_RFUL1_IE_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CAN_INT_RFUL1_IE_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_INT_RFUL1_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RFUL1_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RFUL1_IE_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RFUL1_IE_enable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RFUL1_IE_enable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RFUL1_IE_enable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RFUL0_IE_mask_w                     ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define CAN_INT_RFUL0_IE_mask_h0                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CAN_INT_RFUL0_IE_mask_b1                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_INT_RFUL0_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RFUL0_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RFUL0_IE_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RFUL0_IE_enable_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RFUL0_IE_enable_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RFUL0_IE_enable_b1                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RX1_IE_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_INT_RX1_IE_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_INT_RX1_IE_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_INT_RX1_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RX1_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RX1_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RX1_IE_enable_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RX1_IE_enable_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RX1_IE_enable_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_RX0_IE_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_INT_RX0_IE_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_INT_RX0_IE_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_INT_RX0_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_RX0_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_RX0_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_RX0_IE_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_RX0_IE_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_RX0_IE_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_BERR_IE_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CAN_INT_BERR_IE_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CAN_INT_BERR_IE_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_INT_BERR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_BERR_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_BERR_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_BERR_IE_enable_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_BERR_IE_enable_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_BERR_IE_enable_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_ALOS_IE_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CAN_INT_ALOS_IE_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_INT_ALOS_IE_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_INT_ALOS_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_ALOS_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_ALOS_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_ALOS_IE_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_ALOS_IE_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_ALOS_IE_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_EP_IE_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CAN_INT_EP_IE_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_INT_EP_IE_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_INT_EP_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_EP_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_EP_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_EP_IE_enable_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_EP_IE_enable_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_EP_IE_enable_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_WUP_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_INT_WUP_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_INT_WUP_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_INT_WUP_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_WUP_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_WUP_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_WUP_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_WUP_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_WUP_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_EW_IE_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_INT_EW_IE_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_INT_EW_IE_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_INT_EW_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_EW_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_EW_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_EW_IE_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_EW_IE_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_EW_IE_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_BUS_IE_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CAN_INT_BUS_IE_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_INT_BUS_IE_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_INT_BUS_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_BUS_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_BUS_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_BUS_IE_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_BUS_IE_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_BUS_IE_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CAN_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_CLK  [register's definitions]
 *              Offset[0x08]  CAN clock source register
 ******************************************************************************
 */
///@{
#define CAN_CLK_default                             ((uint32_t)0x00010000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_CLK */
#define CAN_CLK_BRP_mask_w                          ((uint32_t)0x03FF0000)  /*!< Bit Mask of 32bit */
#define CAN_CLK_BRP_mask_h1                         ((uint16_t)0x03FF)      /*!< Bit Mask of 16bit */
#define CAN_CLK_BRP_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define CAN_CLK_BRP_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define CAN_CLK_BRP_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define CAN_CLK_CKO_DIV_mask_w                      ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define CAN_CLK_CKO_DIV_mask_h0                     ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CAN_CLK_CKO_DIV_mask_b1                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CAN_CLK_CKO_DIV_div2_w                      ((uint32_t)0x00000000)
#define CAN_CLK_CKO_DIV_div2_h0                     ((uint16_t)0x0000)
#define CAN_CLK_CKO_DIV_div2_b1                     ((uint8_t )0x00)
#define CAN_CLK_CKO_DIV_div4_w                      ((uint32_t)0x00000100)
#define CAN_CLK_CKO_DIV_div4_h0                     ((uint16_t)0x0100)
#define CAN_CLK_CKO_DIV_div4_b1                     ((uint8_t )0x01)
#define CAN_CLK_CKO_DIV_div6_w                      ((uint32_t)0x00000200)
#define CAN_CLK_CKO_DIV_div6_h0                     ((uint16_t)0x0200)
#define CAN_CLK_CKO_DIV_div6_b1                     ((uint8_t )0x02)
#define CAN_CLK_CKO_DIV_div8_w                      ((uint32_t)0x00000300)
#define CAN_CLK_CKO_DIV_div8_h0                     ((uint16_t)0x0300)
#define CAN_CLK_CKO_DIV_div8_b1                     ((uint8_t )0x03)
#define CAN_CLK_CKO_DIV_div10_w                     ((uint32_t)0x00000400)
#define CAN_CLK_CKO_DIV_div10_h0                    ((uint16_t)0x0400)
#define CAN_CLK_CKO_DIV_div10_b1                    ((uint8_t )0x04)
#define CAN_CLK_CKO_DIV_div12_w                     ((uint32_t)0x00000500)
#define CAN_CLK_CKO_DIV_div12_h0                    ((uint16_t)0x0500)
#define CAN_CLK_CKO_DIV_div12_b1                    ((uint8_t )0x05)
#define CAN_CLK_CKO_DIV_div14_w                     ((uint32_t)0x00000600)
#define CAN_CLK_CKO_DIV_div14_h0                    ((uint16_t)0x0600)
#define CAN_CLK_CKO_DIV_div14_b1                    ((uint8_t )0x06)
#define CAN_CLK_CKO_DIV_div1_w                      ((uint32_t)0x00000700)
#define CAN_CLK_CKO_DIV_div1_h0                     ((uint16_t)0x0700)
#define CAN_CLK_CKO_DIV_div1_b1                     ((uint8_t )0x07)

#define CAN_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define CAN_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define CAN_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CAN_CLK_CK_SEL_proc_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PROC of 32bit */
#define CAN_CLK_CK_SEL_proc_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PROC of 16bit */
#define CAN_CLK_CK_SEL_proc_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):PROC of 8bit */
#define CAN_CLK_CK_SEL_nco_p0_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):NCO_P0 of 32bit */
#define CAN_CLK_CK_SEL_nco_p0_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(0x1):NCO_P0 of 16bit */
#define CAN_CLK_CK_SEL_nco_p0_b0                    ((uint8_t )0x04)        /*!< Bit Value =(0x1):NCO_P0 of 8bit */
#define CAN_CLK_CK_SEL_ck_ls_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):CK_LS of 32bit */
#define CAN_CLK_CK_SEL_ck_ls_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(0x2):CK_LS of 16bit */
#define CAN_CLK_CK_SEL_ck_ls_b0                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):CK_LS of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_STA2  [register's definitions]
 *              Offset[0x0C]  CAN status register 2
 ******************************************************************************
 */
///@{
#define CAN_STA2_default                            ((uint32_t)0x00070101)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_STA2 */
#define CAN_STA2_RX1_NUM_mask_w                     ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_RX1_NUM_mask_h1                    ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define CAN_STA2_RX1_NUM_mask_b3                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CAN_STA2_RX1_NUM_shift_w                    (28)                    /*!< Bit Shift of 32bit */
#define CAN_STA2_RX1_NUM_shift_h1                   (12)                    /*!< Bit Shift of 16bit */
#define CAN_STA2_RX1_NUM_shift_b3                   (4)                     /*!< Bit Shift of 8bit */

#define CAN_STA2_RX0_NUM_mask_w                     ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_RX0_NUM_mask_h1                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CAN_STA2_RX0_NUM_mask_b3                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CAN_STA2_RX0_NUM_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define CAN_STA2_RX0_NUM_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define CAN_STA2_RX0_NUM_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define CAN_STA2_TB2_STA_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TB2_STA_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TB2_STA_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TB2_STA_lock_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Lock of 32bit */
#define CAN_STA2_TB2_STA_lock_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Lock of 16bit */
#define CAN_STA2_TB2_STA_lock_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Lock of 8bit */
#define CAN_STA2_TB2_STA_release_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(1):Release of 32bit */
#define CAN_STA2_TB2_STA_release_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Release of 16bit */
#define CAN_STA2_TB2_STA_release_b2                 ((uint8_t )0x04)        /*!< Bit Value =(1):Release of 8bit */

#define CAN_STA2_TB1_STA_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TB1_STA_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TB1_STA_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TB1_STA_lock_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Lock of 32bit */
#define CAN_STA2_TB1_STA_lock_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Lock of 16bit */
#define CAN_STA2_TB1_STA_lock_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Lock of 8bit */
#define CAN_STA2_TB1_STA_release_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Release of 32bit */
#define CAN_STA2_TB1_STA_release_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Release of 16bit */
#define CAN_STA2_TB1_STA_release_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Release of 8bit */

#define CAN_STA2_TB0_STA_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TB0_STA_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TB0_STA_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TB0_STA_lock_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Lock of 32bit */
#define CAN_STA2_TB0_STA_lock_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Lock of 16bit */
#define CAN_STA2_TB0_STA_lock_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Lock of 8bit */
#define CAN_STA2_TB0_STA_release_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Release of 32bit */
#define CAN_STA2_TB0_STA_release_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Release of 16bit */
#define CAN_STA2_TB0_STA_release_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Release of 8bit */

#define CAN_STA2_TC2_STA_mask_w                     ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TC2_STA_mask_h0                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TC2_STA_mask_b1                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TC2_STA_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_TC2_STA_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_TC2_STA_normal_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_TC2_STA_happened_w                 ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA2_TC2_STA_happened_h0                ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA2_TC2_STA_happened_b1                ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA2_TC1_STA_mask_w                     ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TC1_STA_mask_h0                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TC1_STA_mask_b1                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TC1_STA_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_TC1_STA_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_TC1_STA_normal_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_TC1_STA_happened_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA2_TC1_STA_happened_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA2_TC1_STA_happened_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA2_TC0_STA_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TC0_STA_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TC0_STA_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TC0_STA_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_TC0_STA_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_TC0_STA_normal_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_TC0_STA_happened_w                 ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define CAN_STA2_TC0_STA_happened_h0                ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define CAN_STA2_TC0_STA_happened_b1                ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define CAN_STA2_TX_STA_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_STA2_TX_STA_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_STA2_TX_STA_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_STA2_TX_STA_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_STA2_TX_STA_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_STA2_TX_STA_no_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_STA2_TX_STA_busy_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Busy of 32bit */
#define CAN_STA2_TX_STA_busy_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Busy of 16bit */
#define CAN_STA2_TX_STA_busy_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Busy of 8bit */

#define CAN_STA2_ROVR1_STA_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CAN_STA2_ROVR1_STA_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_STA2_ROVR1_STA_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_STA2_ROVR1_STA_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_ROVR1_STA_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_ROVR1_STA_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_ROVR1_STA_overrun_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Overrun of 32bit */
#define CAN_STA2_ROVR1_STA_overrun_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Overrun of 16bit */
#define CAN_STA2_ROVR1_STA_overrun_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Overrun of 8bit */

#define CAN_STA2_ROVR0_STA_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CAN_STA2_ROVR0_STA_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_STA2_ROVR0_STA_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_STA2_ROVR0_STA_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_ROVR0_STA_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_ROVR0_STA_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_ROVR0_STA_overrun_w                ((uint32_t)0x00000010)  /*!< Bit Value =(1):Overrun of 32bit */
#define CAN_STA2_ROVR0_STA_overrun_h0               ((uint16_t)0x0010)      /*!< Bit Value =(1):Overrun of 16bit */
#define CAN_STA2_ROVR0_STA_overrun_b0               ((uint8_t )0x10)        /*!< Bit Value =(1):Overrun of 8bit */

#define CAN_STA2_RFUL1_STA_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_STA2_RFUL1_STA_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_STA2_RFUL1_STA_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_STA2_RFUL1_STA_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_RFUL1_STA_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_RFUL1_STA_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_RFUL1_STA_full_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Full of 32bit */
#define CAN_STA2_RFUL1_STA_full_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Full of 16bit */
#define CAN_STA2_RFUL1_STA_full_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Full of 8bit */

#define CAN_STA2_RFUL0_STA_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_STA2_RFUL0_STA_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_STA2_RFUL0_STA_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_STA2_RFUL0_STA_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_STA2_RFUL0_STA_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_STA2_RFUL0_STA_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_STA2_RFUL0_STA_full_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Full of 32bit */
#define CAN_STA2_RFUL0_STA_full_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Full of 16bit */
#define CAN_STA2_RFUL0_STA_full_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Full of 8bit */

#define CAN_STA2_RX_STA_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CAN_STA2_RX_STA_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_STA2_RX_STA_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_STA2_RX_STA_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_STA2_RX_STA_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_STA2_RX_STA_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_STA2_RX_STA_busy_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):Busy of 32bit */
#define CAN_STA2_RX_STA_busy_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Busy of 16bit */
#define CAN_STA2_RX_STA_busy_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):Busy of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_CR0  [register's definitions]
 *              Offset[0x10]  CAN control register 0
 ******************************************************************************
 */
///@{
#define CAN_CR0_default                             ((uint32_t)0x00000002)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_CR0 */
#define CAN_CR0_TX_PRI_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_TX_PRI_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CAN_CR0_TX_PRI_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_CR0_TX_PRI_id_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):ID of 32bit */
#define CAN_CR0_TX_PRI_id_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):ID of 16bit */
#define CAN_CR0_TX_PRI_id_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):ID of 8bit */
#define CAN_CR0_TX_PRI_seq_w                        ((uint32_t)0x08000000)  /*!< Bit Value =(1):SEQ of 32bit */
#define CAN_CR0_TX_PRI_seq_h1                       ((uint16_t)0x0800)      /*!< Bit Value =(1):SEQ of 16bit */
#define CAN_CR0_TX_PRI_seq_b3                       ((uint8_t )0x08)        /*!< Bit Value =(1):SEQ of 8bit */

#define CAN_CR0_RBUF_SEL_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_RBUF_SEL_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_CR0_RBUF_SEL_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_CR0_RBUF_SEL_two_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Two of 32bit */
#define CAN_CR0_RBUF_SEL_two_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Two of 16bit */
#define CAN_CR0_RBUF_SEL_two_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):Two of 8bit */
#define CAN_CR0_RBUF_SEL_one_w                      ((uint32_t)0x02000000)  /*!< Bit Value =(0x1):One of 32bit */
#define CAN_CR0_RBUF_SEL_one_h1                     ((uint16_t)0x0200)      /*!< Bit Value =(0x1):One of 16bit */
#define CAN_CR0_RBUF_SEL_one_b3                     ((uint8_t )0x02)        /*!< Bit Value =(0x1):One of 8bit */

#define CAN_CR0_ROVR_MDS_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_ROVR_MDS_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_CR0_ROVR_MDS_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_CR0_ROVR_MDS_overwritten_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define CAN_CR0_ROVR_MDS_overwritten_h1             ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define CAN_CR0_ROVR_MDS_overwritten_b3             ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define CAN_CR0_ROVR_MDS_keep_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(1):Keep of 32bit */
#define CAN_CR0_ROVR_MDS_keep_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Keep of 16bit */
#define CAN_CR0_ROVR_MDS_keep_b3                    ((uint8_t )0x01)        /*!< Bit Value =(1):Keep of 8bit */

#define CAN_CR0_S1_SEL_mask_w                       ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_S1_SEL_mask_h1                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CAN_CR0_S1_SEL_mask_b2                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CAN_CR0_S1_SEL_out1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):OUT1 of 32bit */
#define CAN_CR0_S1_SEL_out1_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):OUT1 of 16bit */
#define CAN_CR0_S1_SEL_out1_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):OUT1 of 8bit */
#define CAN_CR0_S1_SEL_tclk_w                       ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):TCLK of 32bit */
#define CAN_CR0_S1_SEL_tclk_h1                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):TCLK of 16bit */
#define CAN_CR0_S1_SEL_tclk_b2                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):TCLK of 8bit */
#define CAN_CR0_S1_SEL_smp_w                        ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):SMP of 32bit */
#define CAN_CR0_S1_SEL_smp_h1                       ((uint16_t)0x0020)      /*!< Bit Value =(0x2):SMP of 16bit */
#define CAN_CR0_S1_SEL_smp_b2                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):SMP of 8bit */
#define CAN_CR0_S1_SEL_rxs_w                        ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):RXS of 32bit */
#define CAN_CR0_S1_SEL_rxs_h1                       ((uint16_t)0x0030)      /*!< Bit Value =(0x3):RXS of 16bit */
#define CAN_CR0_S1_SEL_rxs_b2                       ((uint8_t )0x30)        /*!< Bit Value =(0x3):RXS of 8bit */

#define CAN_CR0_S0_SEL_mask_w                       ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_S0_SEL_mask_h1                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CAN_CR0_S0_SEL_mask_b2                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CAN_CR0_S0_SEL_stb_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):STB of 32bit */
#define CAN_CR0_S0_SEL_stb_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):STB of 16bit */
#define CAN_CR0_S0_SEL_stb_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):STB of 8bit */
#define CAN_CR0_S0_SEL_bclk_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):BCLK of 32bit */
#define CAN_CR0_S0_SEL_bclk_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):BCLK of 16bit */
#define CAN_CR0_S0_SEL_bclk_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):BCLK of 8bit */
#define CAN_CR0_S0_SEL_txinv_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):TXINV of 32bit */
#define CAN_CR0_S0_SEL_txinv_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(0x2):TXINV of 16bit */
#define CAN_CR0_S0_SEL_txinv_b2                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):TXINV of 8bit */
#define CAN_CR0_S0_SEL_cko_w                        ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):CKO of 32bit */
#define CAN_CR0_S0_SEL_cko_h1                       ((uint16_t)0x0003)      /*!< Bit Value =(0x3):CKO of 16bit */
#define CAN_CR0_S0_SEL_cko_b2                       ((uint8_t )0x03)        /*!< Bit Value =(0x3):CKO of 8bit */

#define CAN_CR0_SRR_EN_mask_w                       ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_SRR_EN_mask_h0                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CAN_CR0_SRR_EN_mask_b1                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_CR0_SRR_EN_disble_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disble of 32bit */
#define CAN_CR0_SRR_EN_disble_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disble of 16bit */
#define CAN_CR0_SRR_EN_disble_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disble of 8bit */
#define CAN_CR0_SRR_EN_enable_w                     ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_SRR_EN_enable_h0                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_SRR_EN_enable_b1                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_TXE_MDS_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_TXE_MDS_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_CR0_TXE_MDS_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_CR0_TXE_MDS_resend_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Resend of 32bit */
#define CAN_CR0_TXE_MDS_resend_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Resend of 16bit */
#define CAN_CR0_TXE_MDS_resend_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Resend of 8bit */
#define CAN_CR0_TXE_MDS_once_w                      ((uint32_t)0x00004000)  /*!< Bit Value =(1):Once of 32bit */
#define CAN_CR0_TXE_MDS_once_h0                     ((uint16_t)0x4000)      /*!< Bit Value =(1):Once of 16bit */
#define CAN_CR0_TXE_MDS_once_b1                     ((uint8_t )0x40)        /*!< Bit Value =(1):Once of 8bit */

#define CAN_CR0_EDF_MDS_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_EDF_MDS_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_CR0_EDF_MDS_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_CR0_EDF_MDS_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_CR0_EDF_MDS_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_CR0_EDF_MDS_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_CR0_EDF_MDS_sample_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Sample of 32bit */
#define CAN_CR0_EDF_MDS_sample_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Sample of 16bit */
#define CAN_CR0_EDF_MDS_sample_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Sample of 8bit */

#define CAN_CR0_FDT_MDS_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CAN_CR0_FDT_MDS_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CAN_CR0_FDT_MDS_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_CR0_FDT_MDS_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_CR0_FDT_MDS_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_CR0_FDT_MDS_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_CR0_FDT_MDS_skip_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):Skip of 32bit */
#define CAN_CR0_FDT_MDS_skip_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Skip of 16bit */
#define CAN_CR0_FDT_MDS_skip_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):Skip of 8bit */

#define CAN_CR0_TX_INV_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CAN_CR0_TX_INV_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CAN_CR0_TX_INV_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_CR0_TX_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_TX_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_TX_INV_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_TX_INV_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_TX_INV_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_TX_INV_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_RX_INV_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define CAN_CR0_RX_INV_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CAN_CR0_RX_INV_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_CR0_RX_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_RX_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_RX_INV_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_RX_INV_enable_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_RX_INV_enable_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_RX_INV_enable_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_SYNC_MDS_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_CR0_SYNC_MDS_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_CR0_SYNC_MDS_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_CR0_SYNC_MDS_run_w                      ((uint32_t)0x00000000)
#define CAN_CR0_SYNC_MDS_run_h0                     ((uint16_t)0x0000)
#define CAN_CR0_SYNC_MDS_run_b1                     ((uint8_t )0x00)
#define CAN_CR0_SYNC_MDS_hold_w                     ((uint32_t)0x00000200)
#define CAN_CR0_SYNC_MDS_hold_h0                    ((uint16_t)0x0200)
#define CAN_CR0_SYNC_MDS_hold_b1                    ((uint8_t )0x02)

#define CAN_CR0_IO_SWP_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_CR0_IO_SWP_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_CR0_IO_SWP_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_CR0_IO_SWP_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_IO_SWP_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_IO_SWP_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_IO_SWP_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_IO_SWP_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_IO_SWP_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_OS_MDS_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CAN_CR0_OS_MDS_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CAN_CR0_OS_MDS_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_CR0_OS_MDS_one_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):One of 32bit */
#define CAN_CR0_OS_MDS_one_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):One of 16bit */
#define CAN_CR0_OS_MDS_one_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):One of 8bit */
#define CAN_CR0_OS_MDS_three_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Three of 32bit */
#define CAN_CR0_OS_MDS_three_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Three of 16bit */
#define CAN_CR0_OS_MDS_three_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Three of 8bit */

#define CAN_CR0_TST_MDS_mask_w                      ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define CAN_CR0_TST_MDS_mask_h0                     ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define CAN_CR0_TST_MDS_mask_b0                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define CAN_CR0_TST_MDS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define CAN_CR0_TST_MDS_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define CAN_CR0_TST_MDS_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define CAN_CR0_TST_MDS_lbm_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):LBM of 32bit */
#define CAN_CR0_TST_MDS_lbm_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):LBM of 16bit */
#define CAN_CR0_TST_MDS_lbm_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):LBM of 8bit */
#define CAN_CR0_TST_MDS_sil_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):SIL of 32bit */
#define CAN_CR0_TST_MDS_sil_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):SIL of 16bit */
#define CAN_CR0_TST_MDS_sil_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):SIL of 8bit */
#define CAN_CR0_TST_MDS_lbs_w                       ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):LBS of 32bit */
#define CAN_CR0_TST_MDS_lbs_h0                      ((uint16_t)0x0030)      /*!< Bit Value =(0x3):LBS of 16bit */
#define CAN_CR0_TST_MDS_lbs_b0                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):LBS of 8bit */

#define CAN_CR0_WUP_MDS_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_CR0_WUP_MDS_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_CR0_WUP_MDS_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_CR0_WUP_MDS_soft_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Soft of 32bit */
#define CAN_CR0_WUP_MDS_soft_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Soft of 16bit */
#define CAN_CR0_WUP_MDS_soft_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Soft of 8bit */
#define CAN_CR0_WUP_MDS_auto_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Auto of 32bit */
#define CAN_CR0_WUP_MDS_auto_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Auto of 16bit */
#define CAN_CR0_WUP_MDS_auto_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Auto of 8bit */

#define CAN_CR0_LP_EN_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_CR0_LP_EN_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_CR0_LP_EN_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_CR0_LP_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_LP_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_LP_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_LP_EN_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_LP_EN_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_LP_EN_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_INIT_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CAN_CR0_INIT_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_CR0_INIT_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_CR0_INIT_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_INIT_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_INIT_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_INIT_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_INIT_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_INIT_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CAN_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_CR1  [register's definitions]
 *              Offset[0x14]  CAN control register 1
 ******************************************************************************
 */
///@{
#define CAN_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_CR1 */
#define CAN_CR1_SJW_mask_w                          ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define CAN_CR1_SJW_mask_h1                         ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CAN_CR1_SJW_mask_b2                         ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CAN_CR1_SJW_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define CAN_CR1_SJW_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define CAN_CR1_SJW_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define CAN_CR1_TSEG2_mask_w                        ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define CAN_CR1_TSEG2_mask_h0                       ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CAN_CR1_TSEG2_mask_b1                       ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CAN_CR1_TSEG2_shift_w                       (8)                     /*!< Bit Shift of 32bit */
#define CAN_CR1_TSEG2_shift_h0                      (8)                     /*!< Bit Shift of 16bit */
#define CAN_CR1_TSEG2_shift_b1                      (0)                     /*!< Bit Shift of 8bit */

#define CAN_CR1_TSEG1_mask_w                        ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_CR1_TSEG1_mask_h0                       ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_CR1_TSEG1_mask_b0                       ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_CR1_TSEG1_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define CAN_CR1_TSEG1_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define CAN_CR1_TSEG1_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_CR3  [register's definitions]
 *              Offset[0x1C]  CAN control register 3
 ******************************************************************************
 */
///@{
#define CAN_CR3_default                             ((uint32_t)0x00000060)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_CR3 */
#define CAN_CR3_RXERR_MDS_mask_w                    ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CAN_CR3_RXERR_MDS_mask_h1                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CAN_CR3_RXERR_MDS_mask_b3                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_CR3_RXERR_MDS_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CAN_CR3_RXERR_MDS_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CAN_CR3_RXERR_MDS_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CAN_CR3_RXERR_MDS_passive_w                 ((uint32_t)0x80000000)  /*!< Bit Value =(1):Passive of 32bit */
#define CAN_CR3_RXERR_MDS_passive_h1                ((uint16_t)0x8000)      /*!< Bit Value =(1):Passive of 16bit */
#define CAN_CR3_RXERR_MDS_passive_b3                ((uint8_t )0x80)        /*!< Bit Value =(1):Passive of 8bit */

#define CAN_CR3_TXERR_CNT_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_CR3_TXERR_CNT_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_CR3_TXERR_CNT_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_CR3_TXERR_CNT_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_CR3_TXERR_CNT_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_CR3_TXERR_CNT_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_CR3_RXERR_CNT_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_CR3_RXERR_CNT_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_CR3_RXERR_CNT_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_CR3_RXERR_CNT_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_CR3_RXERR_CNT_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_CR3_RXERR_CNT_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_CR3_EW_LIM_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_CR3_EW_LIM_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_CR3_EW_LIM_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_CR3_EW_LIM_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define CAN_CR3_EW_LIM_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define CAN_CR3_EW_LIM_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_STA3  [register's definitions]
 *              Offset[0x20]  CAN status register 3
 ******************************************************************************
 */
///@{
#define CAN_STA3_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_STA3 */
#define CAN_STA3_ECC_ALC_mask_w                     ((uint32_t)0x001F0000)  /*!< Bit Mask of 32bit */
#define CAN_STA3_ECC_ALC_mask_h1                    ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define CAN_STA3_ECC_ALC_mask_b2                    ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define CAN_STA3_ECC_ALC_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define CAN_STA3_ECC_ALC_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define CAN_STA3_ECC_ALC_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define CAN_STA3_ECC_ERR_mask_w                     ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define CAN_STA3_ECC_ERR_mask_h0                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CAN_STA3_ECC_ERR_mask_b1                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CAN_STA3_ECC_ERR_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define CAN_STA3_ECC_ERR_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define CAN_STA3_ECC_ERR_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define CAN_STA3_ECC_ERR_bit_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Bit of 32bit */
#define CAN_STA3_ECC_ERR_bit_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Bit of 16bit */
#define CAN_STA3_ECC_ERR_bit_b1                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):Bit of 8bit */
#define CAN_STA3_ECC_ERR_form_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Form of 32bit */
#define CAN_STA3_ECC_ERR_form_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Form of 16bit */
#define CAN_STA3_ECC_ERR_form_b1                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):Form of 8bit */
#define CAN_STA3_ECC_ERR_stuff_w                    ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Stuff of 32bit */
#define CAN_STA3_ECC_ERR_stuff_h0                   ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Stuff of 16bit */
#define CAN_STA3_ECC_ERR_stuff_b1                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):Stuff of 8bit */
#define CAN_STA3_ECC_ERR_crc_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):CRC of 32bit */
#define CAN_STA3_ECC_ERR_crc_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CRC of 16bit */
#define CAN_STA3_ECC_ERR_crc_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x4):CRC of 8bit */
#define CAN_STA3_ECC_ERR_others_w                   ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):Others of 32bit */
#define CAN_STA3_ECC_ERR_others_h0                  ((uint16_t)0x0700)      /*!< Bit Value =(0x7):Others of 16bit */
#define CAN_STA3_ECC_ERR_others_b1                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):Others of 8bit */

#define CAN_STA3_ECC_DIR_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CAN_STA3_ECC_DIR_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CAN_STA3_ECC_DIR_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CAN_STA3_ECC_DIR_tx_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):TX of 32bit */
#define CAN_STA3_ECC_DIR_tx_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):TX of 16bit */
#define CAN_STA3_ECC_DIR_tx_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):TX of 8bit */
#define CAN_STA3_ECC_DIR_rx_w                       ((uint32_t)0x00000080)  /*!< Bit Value =(1):RX of 32bit */
#define CAN_STA3_ECC_DIR_rx_h0                      ((uint16_t)0x0080)      /*!< Bit Value =(1):RX of 16bit */
#define CAN_STA3_ECC_DIR_rx_b0                      ((uint8_t )0x80)        /*!< Bit Value =(1):RX of 8bit */

#define CAN_STA3_ECC_SEG_mask_w                     ((uint32_t)0x0000001F)  /*!< Bit Mask of 32bit */
#define CAN_STA3_ECC_SEG_mask_h0                    ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define CAN_STA3_ECC_SEG_mask_b0                    ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define CAN_STA3_ECC_SEG_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CAN_STA3_ECC_SEG_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CAN_STA3_ECC_SEG_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AFC0  [register's definitions]
 *              Offset[0x24]  CAN acceptance filter control register 0
 ******************************************************************************
 */
///@{
#define CAN_AFC0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AFC0 */
#define CAN_AFC0_AF5_FSEL_mask_w                    ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF5_FSEL_mask_h1                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF5_FSEL_mask_b2                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF5_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF5_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF5_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF5_FSEL_fifo1_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF5_FSEL_fifo1_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF5_FSEL_fifo1_b2                  ((uint8_t )0x20)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF4_FSEL_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF4_FSEL_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF4_FSEL_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF4_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF4_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF4_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF4_FSEL_fifo1_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF4_FSEL_fifo1_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF4_FSEL_fifo1_b2                  ((uint8_t )0x10)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF3_FSEL_mask_w                    ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF3_FSEL_mask_h1                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF3_FSEL_mask_b2                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF3_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF3_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF3_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF3_FSEL_fifo1_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF3_FSEL_fifo1_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF3_FSEL_fifo1_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF2_FSEL_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF2_FSEL_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF2_FSEL_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF2_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF2_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF2_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF2_FSEL_fifo1_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF2_FSEL_fifo1_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF2_FSEL_fifo1_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF1_FSEL_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF1_FSEL_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF1_FSEL_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF1_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF1_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF1_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF1_FSEL_fifo1_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF1_FSEL_fifo1_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF1_FSEL_fifo1_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF0_FSEL_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF0_FSEL_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF0_FSEL_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF0_FSEL_fifo0_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):FIFO0 of 32bit */
#define CAN_AFC0_AF0_FSEL_fifo0_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):FIFO0 of 16bit */
#define CAN_AFC0_AF0_FSEL_fifo0_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):FIFO0 of 8bit */
#define CAN_AFC0_AF0_FSEL_fifo1_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):FIFO1 of 32bit */
#define CAN_AFC0_AF0_FSEL_fifo1_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):FIFO1 of 16bit */
#define CAN_AFC0_AF0_FSEL_fifo1_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):FIFO1 of 8bit */

#define CAN_AFC0_AF5_EN_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF5_EN_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF5_EN_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF5_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF5_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF5_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF5_EN_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF5_EN_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF5_EN_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_AFC0_AF4_EN_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF4_EN_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF4_EN_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF4_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF4_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF4_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF4_EN_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF4_EN_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF4_EN_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_AFC0_AF3_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF3_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF3_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF3_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF3_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF3_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF3_EN_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF3_EN_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF3_EN_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_AFC0_AF2_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF2_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF2_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF2_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF2_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF2_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF2_EN_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF2_EN_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF2_EN_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_AFC0_AF1_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF1_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF1_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF1_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF1_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF1_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF1_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF1_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF1_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_AFC0_AF0_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CAN_AFC0_AF0_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_AFC0_AF0_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_AFC0_AF0_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CAN_AFC0_AF0_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CAN_AFC0_AF0_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CAN_AFC0_AF0_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_AFC0_AF0_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_AFC0_AF0_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AFC1  [register's definitions]
 *              Offset[0x28]  CAN acceptance filter control register 1
 ******************************************************************************
 */
///@{
#define CAN_AFC1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AFC1 */
#define CAN_AFC1_AF5_CFG_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF5_CFG_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF5_CFG_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF5_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF5_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF5_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF5_CFG_dual_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF5_CFG_dual_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF5_CFG_dual_b2                    ((uint8_t )0x20)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF4_CFG_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF4_CFG_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF4_CFG_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF4_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF4_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF4_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF4_CFG_dual_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF4_CFG_dual_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF4_CFG_dual_b2                    ((uint8_t )0x10)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF3_CFG_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF3_CFG_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF3_CFG_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF3_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF3_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF3_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF3_CFG_dual_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF3_CFG_dual_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF3_CFG_dual_b2                    ((uint8_t )0x08)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF2_CFG_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF2_CFG_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF2_CFG_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF2_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF2_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF2_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF2_CFG_dual_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF2_CFG_dual_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF2_CFG_dual_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF1_CFG_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF1_CFG_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF1_CFG_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF1_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF1_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF1_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF1_CFG_dual_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF1_CFG_dual_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF1_CFG_dual_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF0_CFG_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF0_CFG_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF0_CFG_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF0_CFG_single_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Single of 32bit */
#define CAN_AFC1_AF0_CFG_single_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Single of 16bit */
#define CAN_AFC1_AF0_CFG_single_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Single of 8bit */
#define CAN_AFC1_AF0_CFG_dual_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Dual of 32bit */
#define CAN_AFC1_AF0_CFG_dual_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Dual of 16bit */
#define CAN_AFC1_AF0_CFG_dual_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Dual of 8bit */

#define CAN_AFC1_AF5_MDS_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF5_MDS_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF5_MDS_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF5_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF5_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF5_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF5_MDS_listmode_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF5_MDS_listmode_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF5_MDS_listmode_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):ListMode of 8bit */

#define CAN_AFC1_AF4_MDS_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF4_MDS_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF4_MDS_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF4_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF4_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF4_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF4_MDS_listmode_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF4_MDS_listmode_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF4_MDS_listmode_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):ListMode of 8bit */

#define CAN_AFC1_AF3_MDS_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF3_MDS_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF3_MDS_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF3_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF3_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF3_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF3_MDS_listmode_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF3_MDS_listmode_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF3_MDS_listmode_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):ListMode of 8bit */

#define CAN_AFC1_AF2_MDS_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF2_MDS_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF2_MDS_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF2_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF2_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF2_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF2_MDS_listmode_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF2_MDS_listmode_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF2_MDS_listmode_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):ListMode of 8bit */

#define CAN_AFC1_AF1_MDS_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF1_MDS_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF1_MDS_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF1_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF1_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF1_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF1_MDS_listmode_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF1_MDS_listmode_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF1_MDS_listmode_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):ListMode of 8bit */

#define CAN_AFC1_AF0_MDS_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CAN_AFC1_AF0_MDS_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CAN_AFC1_AF0_MDS_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_AFC1_AF0_MDS_maskmode_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):MaskMode of 32bit */
#define CAN_AFC1_AF0_MDS_maskmode_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):MaskMode of 16bit */
#define CAN_AFC1_AF0_MDS_maskmode_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):MaskMode of 8bit */
#define CAN_AFC1_AF0_MDS_listmode_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):ListMode of 32bit */
#define CAN_AFC1_AF0_MDS_listmode_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):ListMode of 16bit */
#define CAN_AFC1_AF0_MDS_listmode_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):ListMode of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF0R0  [register's definitions]
 *              Offset[0x30]  CAN acceptance filter-0 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF0R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF0R0 */
#define CAN_AF0R0_AF0R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF0R0_AF0R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF0R0_AF0R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF0R0_AF0R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF0R1  [register's definitions]
 *              Offset[0x34]  CAN acceptance filter-0 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF0R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF0R1 */
#define CAN_AF0R1_AF0R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF0R1_AF0R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF0R1_AF0R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF0R1_AF0R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF1R0  [register's definitions]
 *              Offset[0x38]  CAN acceptance filter-1 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF1R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF1R0 */
#define CAN_AF1R0_AF1R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF1R0_AF1R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF1R0_AF1R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF1R0_AF1R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF1R1  [register's definitions]
 *              Offset[0x3C]  CAN acceptance filter-1 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF1R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF1R1 */
#define CAN_AF1R1_AF1R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF1R1_AF1R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF1R1_AF1R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF1R1_AF1R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF2R0  [register's definitions]
 *              Offset[0x40]  CAN acceptance filter-2 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF2R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF2R0 */
#define CAN_AF2R0_AF2R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF2R0_AF2R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF2R0_AF2R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF2R0_AF2R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF2R1  [register's definitions]
 *              Offset[0x44]  CAN acceptance filter-2 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF2R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF2R1 */
#define CAN_AF2R1_AF2R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF2R1_AF2R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF2R1_AF2R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF2R1_AF2R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF3R0  [register's definitions]
 *              Offset[0x48]  CAN acceptance filter-3 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF3R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF3R0 */
#define CAN_AF3R0_AF3R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF3R0_AF3R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF3R0_AF3R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF3R0_AF3R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF3R1  [register's definitions]
 *              Offset[0x4C]  CAN acceptance filter-3 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF3R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF3R1 */
#define CAN_AF3R1_AF3R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF3R1_AF3R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF3R1_AF3R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF3R1_AF3R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF4R0  [register's definitions]
 *              Offset[0x50]  CAN acceptance filter-4 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF4R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF4R0 */
#define CAN_AF4R0_AF4R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF4R0_AF4R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF4R0_AF4R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF4R0_AF4R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF4R1  [register's definitions]
 *              Offset[0x54]  CAN acceptance filter-4 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF4R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF4R1 */
#define CAN_AF4R1_AF4R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF4R1_AF4R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF4R1_AF4R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF4R1_AF4R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF5R0  [register's definitions]
 *              Offset[0x58]  CAN acceptance filter-5 register 0
 ******************************************************************************
 */
///@{
#define CAN_AF5R0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF5R0 */
#define CAN_AF5R0_AF5R0_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF5R0_AF5R0_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF5R0_AF5R0_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF5R0_AF5R0_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_AF5R1  [register's definitions]
 *              Offset[0x5C]  CAN acceptance filter-5 register 1
 ******************************************************************************
 */
///@{
#define CAN_AF5R1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_AF5R1 */
#define CAN_AF5R1_AF5R1_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CAN_AF5R1_AF5R1_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CAN_AF5R1_AF5R1_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CAN_AF5R1_AF5R1_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT00  [register's definitions]
 *              Offset[0xA0]  CAN receive FIFO-0 data register 0
 ******************************************************************************
 */
///@{
#define CAN_RDAT00_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT00 */
#define CAN_RDAT00_RX0_IDE_mask_w                   ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT00_RX0_IDE_mask_h1                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_RDAT00_RX0_IDE_mask_b3                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_RDAT00_RX0_IDE_std_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):STD of 32bit */
#define CAN_RDAT00_RX0_IDE_std_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):STD of 16bit */
#define CAN_RDAT00_RX0_IDE_std_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):STD of 8bit */
#define CAN_RDAT00_RX0_IDE_ext_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):EXT of 32bit */
#define CAN_RDAT00_RX0_IDE_ext_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):EXT of 16bit */
#define CAN_RDAT00_RX0_IDE_ext_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):EXT of 8bit */

#define CAN_RDAT00_RX0_RTR_mask_w                   ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT00_RX0_RTR_mask_h1                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_RDAT00_RX0_RTR_mask_b3                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_RDAT00_RX0_RTR_date_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Date of 32bit */
#define CAN_RDAT00_RX0_RTR_date_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Date of 16bit */
#define CAN_RDAT00_RX0_RTR_date_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Date of 8bit */
#define CAN_RDAT00_RX0_RTR_remote_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Remote of 32bit */
#define CAN_RDAT00_RX0_RTR_remote_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Remote of 16bit */
#define CAN_RDAT00_RX0_RTR_remote_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Remote of 8bit */

#define CAN_RDAT00_RX0_SID_mask_w                   ((uint32_t)0x1FFC0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT00_RX0_SID_mask_h1                  ((uint16_t)0x1FFC)      /*!< Bit Mask of 16bit */
#define CAN_RDAT00_RX0_SID_shift_w                  (18)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT00_RX0_SID_shift_h1                 (2)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT00_RX0_SID_shift_b2                 (2)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT00_RX0_EID_mask_w                   ((uint32_t)0x0003FFFF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT00_RX0_EID_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT00_RX0_EID_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT00_RX0_EID_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT01  [register's definitions]
 *              Offset[0xA4]  CAN receive FIFO-0 data register 1
 ******************************************************************************
 */
///@{
#define CAN_RDAT01_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT01 */
#define CAN_RDAT01_RX0_RST_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_RDAT01_RX0_RST_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_RDAT01_RX0_RST_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_RDAT01_RX0_RST_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_RDAT01_RX0_RST_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_RDAT01_RX0_RST_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_RDAT01_RX0_RST_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_RDAT01_RX0_RST_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_RDAT01_RX0_RST_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_RDAT01_RX0_CLR_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_RDAT01_RX0_CLR_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_RDAT01_RX0_CLR_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_RDAT01_RX0_CLR_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_RDAT01_RX0_CLR_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_RDAT01_RX0_CLR_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_RDAT01_RX0_CLR_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_RDAT01_RX0_CLR_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_RDAT01_RX0_CLR_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_RDAT01_RX0_DLC_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_RDAT01_RX0_DLC_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_RDAT01_RX0_DLC_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_RDAT01_RX0_DLC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT01_RX0_DLC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT01_RX0_DLC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT02  [register's definitions]
 *              Offset[0xA8]  CAN receive FIFO-0 data register 2
 ******************************************************************************
 */
///@{
#define CAN_RDAT02_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT02 */
#define CAN_RDAT02_RX0_D3_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT02_RX0_D3_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT02_RX0_D3_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT02_RX0_D3_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT02_RX0_D3_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT02_RX0_D3_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT02_RX0_D2_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT02_RX0_D2_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT02_RX0_D2_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT02_RX0_D2_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT02_RX0_D2_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT02_RX0_D2_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT02_RX0_D1_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_RDAT02_RX0_D1_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT02_RX0_D1_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT02_RX0_D1_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT02_RX0_D1_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT02_RX0_D1_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT02_RX0_D0_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT02_RX0_D0_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT02_RX0_D0_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT02_RX0_D0_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT02_RX0_D0_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT02_RX0_D0_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT03  [register's definitions]
 *              Offset[0xAC]  CAN receive FIFO-0 data register 3
 ******************************************************************************
 */
///@{
#define CAN_RDAT03_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT03 */
#define CAN_RDAT03_RX0_D7_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT03_RX0_D7_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT03_RX0_D7_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT03_RX0_D7_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT03_RX0_D7_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT03_RX0_D7_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT03_RX0_D6_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT03_RX0_D6_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT03_RX0_D6_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT03_RX0_D6_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT03_RX0_D6_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT03_RX0_D6_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT03_RX0_D5_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_RDAT03_RX0_D5_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT03_RX0_D5_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT03_RX0_D5_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT03_RX0_D5_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT03_RX0_D5_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT03_RX0_D4_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT03_RX0_D4_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT03_RX0_D4_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT03_RX0_D4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT03_RX0_D4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT03_RX0_D4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT10  [register's definitions]
 *              Offset[0xB0]  CAN receive FIFO-1 data register 0
 ******************************************************************************
 */
///@{
#define CAN_RDAT10_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT10 */
#define CAN_RDAT10_RX1_IDE_mask_w                   ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT10_RX1_IDE_mask_h1                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_RDAT10_RX1_IDE_mask_b3                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_RDAT10_RX1_IDE_std_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):STD of 32bit */
#define CAN_RDAT10_RX1_IDE_std_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):STD of 16bit */
#define CAN_RDAT10_RX1_IDE_std_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):STD of 8bit */
#define CAN_RDAT10_RX1_IDE_ext_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):EXT of 32bit */
#define CAN_RDAT10_RX1_IDE_ext_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):EXT of 16bit */
#define CAN_RDAT10_RX1_IDE_ext_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):EXT of 8bit */

#define CAN_RDAT10_RX1_RTR_mask_w                   ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT10_RX1_RTR_mask_h1                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_RDAT10_RX1_RTR_mask_b3                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_RDAT10_RX1_RTR_date_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Date of 32bit */
#define CAN_RDAT10_RX1_RTR_date_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Date of 16bit */
#define CAN_RDAT10_RX1_RTR_date_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Date of 8bit */
#define CAN_RDAT10_RX1_RTR_remote_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Remote of 32bit */
#define CAN_RDAT10_RX1_RTR_remote_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Remote of 16bit */
#define CAN_RDAT10_RX1_RTR_remote_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Remote of 8bit */

#define CAN_RDAT10_RX1_SID_mask_w                   ((uint32_t)0x1FFC0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT10_RX1_SID_mask_h1                  ((uint16_t)0x1FFC)      /*!< Bit Mask of 16bit */
#define CAN_RDAT10_RX1_SID_shift_w                  (18)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT10_RX1_SID_shift_h1                 (2)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT10_RX1_SID_shift_b2                 (2)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT10_RX1_EID_mask_w                   ((uint32_t)0x0003FFFF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT10_RX1_EID_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT10_RX1_EID_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT10_RX1_EID_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT11  [register's definitions]
 *              Offset[0xB4]  CAN receive FIFO-1 data register 1
 ******************************************************************************
 */
///@{
#define CAN_RDAT11_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT11 */
#define CAN_RDAT11_RX1_RST_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_RDAT11_RX1_RST_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_RDAT11_RX1_RST_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_RDAT11_RX1_RST_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_RDAT11_RX1_RST_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_RDAT11_RX1_RST_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_RDAT11_RX1_RST_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_RDAT11_RX1_RST_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_RDAT11_RX1_RST_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_RDAT11_RX1_CLR_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_RDAT11_RX1_CLR_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_RDAT11_RX1_CLR_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_RDAT11_RX1_CLR_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_RDAT11_RX1_CLR_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_RDAT11_RX1_CLR_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_RDAT11_RX1_CLR_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_RDAT11_RX1_CLR_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_RDAT11_RX1_CLR_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_RDAT11_RX1_DLC_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_RDAT11_RX1_DLC_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_RDAT11_RX1_DLC_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_RDAT11_RX1_DLC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT11_RX1_DLC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT11_RX1_DLC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT12  [register's definitions]
 *              Offset[0xB8]  CAN receive FIFO-1 data register 2
 ******************************************************************************
 */
///@{
#define CAN_RDAT12_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT12 */
#define CAN_RDAT12_RX1_D3_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT12_RX1_D3_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT12_RX1_D3_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT12_RX1_D3_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT12_RX1_D3_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT12_RX1_D3_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT12_RX1_D2_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT12_RX1_D2_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT12_RX1_D2_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT12_RX1_D2_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT12_RX1_D2_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT12_RX1_D2_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT12_RX1_D1_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_RDAT12_RX1_D1_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT12_RX1_D1_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT12_RX1_D1_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT12_RX1_D1_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT12_RX1_D1_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT12_RX1_D0_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT12_RX1_D0_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT12_RX1_D0_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT12_RX1_D0_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT12_RX1_D0_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT12_RX1_D0_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_RDAT13  [register's definitions]
 *              Offset[0xBC]  CAN receive FIFO-1 data register 3
 ******************************************************************************
 */
///@{
#define CAN_RDAT13_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_RDAT13 */
#define CAN_RDAT13_RX1_D7_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT13_RX1_D7_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT13_RX1_D7_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT13_RX1_D7_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT13_RX1_D7_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT13_RX1_D7_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT13_RX1_D6_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_RDAT13_RX1_D6_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT13_RX1_D6_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT13_RX1_D6_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_RDAT13_RX1_D6_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT13_RX1_D6_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT13_RX1_D5_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_RDAT13_RX1_D5_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_RDAT13_RX1_D5_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT13_RX1_D5_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT13_RX1_D5_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT13_RX1_D5_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_RDAT13_RX1_D4_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_RDAT13_RX1_D4_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_RDAT13_RX1_D4_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_RDAT13_RX1_D4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_RDAT13_RX1_D4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_RDAT13_RX1_D4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT00  [register's definitions]
 *              Offset[0xC0]  CAN transmit buffer-0 data register 0
 ******************************************************************************
 */
///@{
#define CAN_TDAT00_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT00 */
#define CAN_TDAT00_TX0_IDE_mask_w                   ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT00_TX0_IDE_mask_h1                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT00_TX0_IDE_mask_b3                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_TDAT00_TX0_IDE_std_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):STD of 32bit */
#define CAN_TDAT00_TX0_IDE_std_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):STD of 16bit */
#define CAN_TDAT00_TX0_IDE_std_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):STD of 8bit */
#define CAN_TDAT00_TX0_IDE_ext_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):EXT of 32bit */
#define CAN_TDAT00_TX0_IDE_ext_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):EXT of 16bit */
#define CAN_TDAT00_TX0_IDE_ext_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):EXT of 8bit */

#define CAN_TDAT00_TX0_RTR_mask_w                   ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT00_TX0_RTR_mask_h1                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT00_TX0_RTR_mask_b3                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_TDAT00_TX0_RTR_date_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Date of 32bit */
#define CAN_TDAT00_TX0_RTR_date_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Date of 16bit */
#define CAN_TDAT00_TX0_RTR_date_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Date of 8bit */
#define CAN_TDAT00_TX0_RTR_remote_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Remote of 32bit */
#define CAN_TDAT00_TX0_RTR_remote_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Remote of 16bit */
#define CAN_TDAT00_TX0_RTR_remote_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Remote of 8bit */

#define CAN_TDAT00_TX0_SID_mask_w                   ((uint32_t)0x1FFC0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT00_TX0_SID_mask_h1                  ((uint16_t)0x1FFC)      /*!< Bit Mask of 16bit */
#define CAN_TDAT00_TX0_SID_shift_w                  (18)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT00_TX0_SID_shift_h1                 (2)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT00_TX0_SID_shift_b2                 (2)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT00_TX0_EID_mask_w                   ((uint32_t)0x0003FFFF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT00_TX0_EID_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT00_TX0_EID_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT00_TX0_EID_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT01  [register's definitions]
 *              Offset[0xC4]  CAN transmit buffer-0 data register 1
 ******************************************************************************
 */
///@{
#define CAN_TDAT01_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT01 */
#define CAN_TDAT01_TX0_STOP_mask_w                  ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_TDAT01_TX0_STOP_mask_h0                 ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_TDAT01_TX0_STOP_mask_b1                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_TDAT01_TX0_STOP_no_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT01_TX0_STOP_no_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT01_TX0_STOP_no_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT01_TX0_STOP_enable_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT01_TX0_STOP_enable_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT01_TX0_STOP_enable_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT01_TX0_REQ_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_TDAT01_TX0_REQ_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_TDAT01_TX0_REQ_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_TDAT01_TX0_REQ_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT01_TX0_REQ_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT01_TX0_REQ_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT01_TX0_REQ_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT01_TX0_REQ_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT01_TX0_REQ_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT01_TX0_DLC_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_TDAT01_TX0_DLC_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_TDAT01_TX0_DLC_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_TDAT01_TX0_DLC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT01_TX0_DLC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT01_TX0_DLC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT02  [register's definitions]
 *              Offset[0xC8]  CAN transmit buffer-0 data register 2
 ******************************************************************************
 */
///@{
#define CAN_TDAT02_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT02 */
#define CAN_TDAT02_TX0_D3_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT02_TX0_D3_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT02_TX0_D3_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT02_TX0_D3_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT02_TX0_D3_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT02_TX0_D3_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT02_TX0_D2_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT02_TX0_D2_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT02_TX0_D2_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT02_TX0_D2_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT02_TX0_D2_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT02_TX0_D2_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT02_TX0_D1_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT02_TX0_D1_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT02_TX0_D1_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT02_TX0_D1_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT02_TX0_D1_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT02_TX0_D1_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT02_TX0_D0_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT02_TX0_D0_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT02_TX0_D0_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT02_TX0_D0_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT02_TX0_D0_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT02_TX0_D0_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT03  [register's definitions]
 *              Offset[0xCC]  CAN transmit buffer-0 data register 3
 ******************************************************************************
 */
///@{
#define CAN_TDAT03_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT03 */
#define CAN_TDAT03_TX0_D7_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT03_TX0_D7_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT03_TX0_D7_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT03_TX0_D7_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT03_TX0_D7_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT03_TX0_D7_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT03_TX0_D6_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT03_TX0_D6_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT03_TX0_D6_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT03_TX0_D6_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT03_TX0_D6_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT03_TX0_D6_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT03_TX0_D5_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT03_TX0_D5_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT03_TX0_D5_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT03_TX0_D5_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT03_TX0_D5_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT03_TX0_D5_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT03_TX0_D4_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT03_TX0_D4_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT03_TX0_D4_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT03_TX0_D4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT03_TX0_D4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT03_TX0_D4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT10  [register's definitions]
 *              Offset[0xD0]  CAN transmit buffer-1 data register 0
 ******************************************************************************
 */
///@{
#define CAN_TDAT10_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT10 */
#define CAN_TDAT10_TX1_IDE_mask_w                   ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT10_TX1_IDE_mask_h1                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT10_TX1_IDE_mask_b3                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_TDAT10_TX1_IDE_std_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):STD of 32bit */
#define CAN_TDAT10_TX1_IDE_std_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):STD of 16bit */
#define CAN_TDAT10_TX1_IDE_std_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):STD of 8bit */
#define CAN_TDAT10_TX1_IDE_ext_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):EXT of 32bit */
#define CAN_TDAT10_TX1_IDE_ext_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):EXT of 16bit */
#define CAN_TDAT10_TX1_IDE_ext_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):EXT of 8bit */

#define CAN_TDAT10_TX1_RTR_mask_w                   ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT10_TX1_RTR_mask_h1                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT10_TX1_RTR_mask_b3                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_TDAT10_TX1_RTR_date_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Date of 32bit */
#define CAN_TDAT10_TX1_RTR_date_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Date of 16bit */
#define CAN_TDAT10_TX1_RTR_date_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Date of 8bit */
#define CAN_TDAT10_TX1_RTR_remote_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Remote of 32bit */
#define CAN_TDAT10_TX1_RTR_remote_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Remote of 16bit */
#define CAN_TDAT10_TX1_RTR_remote_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Remote of 8bit */

#define CAN_TDAT10_TX1_SID_mask_w                   ((uint32_t)0x1FFC0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT10_TX1_SID_mask_h1                  ((uint16_t)0x1FFC)      /*!< Bit Mask of 16bit */
#define CAN_TDAT10_TX1_SID_shift_w                  (18)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT10_TX1_SID_shift_h1                 (2)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT10_TX1_SID_shift_b2                 (2)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT10_TX1_EID_mask_w                   ((uint32_t)0x0003FFFF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT10_TX1_EID_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT10_TX1_EID_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT10_TX1_EID_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT11  [register's definitions]
 *              Offset[0xD4]  CAN transmit buffer-1 data register 1
 ******************************************************************************
 */
///@{
#define CAN_TDAT11_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT11 */
#define CAN_TDAT11_TX1_STOP_mask_w                  ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_TDAT11_TX1_STOP_mask_h0                 ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_TDAT11_TX1_STOP_mask_b1                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_TDAT11_TX1_STOP_no_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT11_TX1_STOP_no_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT11_TX1_STOP_no_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT11_TX1_STOP_enable_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT11_TX1_STOP_enable_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT11_TX1_STOP_enable_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT11_TX1_REQ_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_TDAT11_TX1_REQ_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_TDAT11_TX1_REQ_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_TDAT11_TX1_REQ_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT11_TX1_REQ_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT11_TX1_REQ_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT11_TX1_REQ_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT11_TX1_REQ_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT11_TX1_REQ_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT11_TX1_DLC_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_TDAT11_TX1_DLC_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_TDAT11_TX1_DLC_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_TDAT11_TX1_DLC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT11_TX1_DLC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT11_TX1_DLC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT12  [register's definitions]
 *              Offset[0xD8]  CAN transmit buffer-1 data register 2
 ******************************************************************************
 */
///@{
#define CAN_TDAT12_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT12 */
#define CAN_TDAT12_TX1_D3_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT12_TX1_D3_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT12_TX1_D3_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT12_TX1_D3_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT12_TX1_D3_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT12_TX1_D3_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT12_TX1_D2_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT12_TX1_D2_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT12_TX1_D2_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT12_TX1_D2_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT12_TX1_D2_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT12_TX1_D2_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT12_TX1_D1_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT12_TX1_D1_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT12_TX1_D1_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT12_TX1_D1_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT12_TX1_D1_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT12_TX1_D1_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT12_TX1_D0_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT12_TX1_D0_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT12_TX1_D0_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT12_TX1_D0_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT12_TX1_D0_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT12_TX1_D0_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT13  [register's definitions]
 *              Offset[0xDC]  CAN transmit buffer-1 data register 3
 ******************************************************************************
 */
///@{
#define CAN_TDAT13_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT13 */
#define CAN_TDAT13_TX1_D7_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT13_TX1_D7_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT13_TX1_D7_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT13_TX1_D7_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT13_TX1_D7_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT13_TX1_D7_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT13_TX1_D6_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT13_TX1_D6_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT13_TX1_D6_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT13_TX1_D6_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT13_TX1_D6_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT13_TX1_D6_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT13_TX1_D5_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT13_TX1_D5_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT13_TX1_D5_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT13_TX1_D5_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT13_TX1_D5_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT13_TX1_D5_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT13_TX1_D4_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT13_TX1_D4_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT13_TX1_D4_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT13_TX1_D4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT13_TX1_D4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT13_TX1_D4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT20  [register's definitions]
 *              Offset[0xE0]  CAN transmit buffer-2 data register 0
 ******************************************************************************
 */
///@{
#define CAN_TDAT20_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT20 */
#define CAN_TDAT20_TX2_IDE_mask_w                   ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT20_TX2_IDE_mask_h1                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT20_TX2_IDE_mask_b3                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CAN_TDAT20_TX2_IDE_std_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):STD of 32bit */
#define CAN_TDAT20_TX2_IDE_std_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):STD of 16bit */
#define CAN_TDAT20_TX2_IDE_std_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):STD of 8bit */
#define CAN_TDAT20_TX2_IDE_ext_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):EXT of 32bit */
#define CAN_TDAT20_TX2_IDE_ext_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):EXT of 16bit */
#define CAN_TDAT20_TX2_IDE_ext_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):EXT of 8bit */

#define CAN_TDAT20_TX2_RTR_mask_w                   ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT20_TX2_RTR_mask_h1                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CAN_TDAT20_TX2_RTR_mask_b3                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CAN_TDAT20_TX2_RTR_date_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Date of 32bit */
#define CAN_TDAT20_TX2_RTR_date_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Date of 16bit */
#define CAN_TDAT20_TX2_RTR_date_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Date of 8bit */
#define CAN_TDAT20_TX2_RTR_remote_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Remote of 32bit */
#define CAN_TDAT20_TX2_RTR_remote_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Remote of 16bit */
#define CAN_TDAT20_TX2_RTR_remote_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Remote of 8bit */

#define CAN_TDAT20_TX2_SID_mask_w                   ((uint32_t)0x1FFC0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT20_TX2_SID_mask_h1                  ((uint16_t)0x1FFC)      /*!< Bit Mask of 16bit */
#define CAN_TDAT20_TX2_SID_shift_w                  (18)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT20_TX2_SID_shift_h1                 (2)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT20_TX2_SID_shift_b2                 (2)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT20_TX2_EID_mask_w                   ((uint32_t)0x0003FFFF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT20_TX2_EID_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT20_TX2_EID_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT20_TX2_EID_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT21  [register's definitions]
 *              Offset[0xE4]  CAN transmit buffer-2 data register 1
 ******************************************************************************
 */
///@{
#define CAN_TDAT21_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT21 */
#define CAN_TDAT21_TX2_STOP_mask_w                  ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CAN_TDAT21_TX2_STOP_mask_h0                 ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CAN_TDAT21_TX2_STOP_mask_b1                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CAN_TDAT21_TX2_STOP_no_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT21_TX2_STOP_no_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT21_TX2_STOP_no_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT21_TX2_STOP_enable_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT21_TX2_STOP_enable_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT21_TX2_STOP_enable_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT21_TX2_REQ_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CAN_TDAT21_TX2_REQ_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CAN_TDAT21_TX2_REQ_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CAN_TDAT21_TX2_REQ_no_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define CAN_TDAT21_TX2_REQ_no_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define CAN_TDAT21_TX2_REQ_no_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define CAN_TDAT21_TX2_REQ_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CAN_TDAT21_TX2_REQ_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CAN_TDAT21_TX2_REQ_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CAN_TDAT21_TX2_DLC_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CAN_TDAT21_TX2_DLC_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CAN_TDAT21_TX2_DLC_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CAN_TDAT21_TX2_DLC_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT21_TX2_DLC_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT21_TX2_DLC_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT22  [register's definitions]
 *              Offset[0xE8]  CAN transmit buffer-2 data register 2
 ******************************************************************************
 */
///@{
#define CAN_TDAT22_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT22 */
#define CAN_TDAT22_TX2_D3_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT22_TX2_D3_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT22_TX2_D3_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT22_TX2_D3_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT22_TX2_D3_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT22_TX2_D3_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT22_TX2_D2_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT22_TX2_D2_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT22_TX2_D2_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT22_TX2_D2_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT22_TX2_D2_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT22_TX2_D2_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT22_TX2_D1_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT22_TX2_D1_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT22_TX2_D1_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT22_TX2_D1_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT22_TX2_D1_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT22_TX2_D1_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT22_TX2_D0_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT22_TX2_D0_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT22_TX2_D0_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT22_TX2_D0_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT22_TX2_D0_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT22_TX2_D0_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TDAT23  [register's definitions]
 *              Offset[0xEC]  CAN transmit buffer-2 data register 3
 ******************************************************************************
 */
///@{
#define CAN_TDAT23_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TDAT23 */
#define CAN_TDAT23_TX2_D7_mask_w                    ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT23_TX2_D7_mask_h1                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT23_TX2_D7_mask_b3                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT23_TX2_D7_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT23_TX2_D7_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT23_TX2_D7_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT23_TX2_D6_mask_w                    ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define CAN_TDAT23_TX2_D6_mask_h1                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT23_TX2_D6_mask_b2                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT23_TX2_D6_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CAN_TDAT23_TX2_D6_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT23_TX2_D6_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT23_TX2_D5_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define CAN_TDAT23_TX2_D5_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CAN_TDAT23_TX2_D5_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT23_TX2_D5_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT23_TX2_D5_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT23_TX2_D5_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CAN_TDAT23_TX2_D4_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define CAN_TDAT23_TX2_D4_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define CAN_TDAT23_TX2_D4_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CAN_TDAT23_TX2_D4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CAN_TDAT23_TX2_D4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CAN_TDAT23_TX2_D4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CAN_TST0  [register's definitions]
 *              Offset[0xF0]  CAN control register 0
 ******************************************************************************
 */
///@{
#define CAN_TST0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CAN_TST0 */
#define CAN_TST0_RP1_mask_w                         ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CAN_TST0_RP1_mask_h0                        ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CAN_TST0_RP1_mask_b1                        ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CAN_TST0_RP1_shift_w                        (14)                    /*!< Bit Shift of 32bit */
#define CAN_TST0_RP1_shift_h0                       (14)                    /*!< Bit Shift of 16bit */
#define CAN_TST0_RP1_shift_b1                       (6)                     /*!< Bit Shift of 8bit */

#define CAN_TST0_WP1_mask_w                         ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define CAN_TST0_WP1_mask_h0                        ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define CAN_TST0_WP1_mask_b1                        ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CAN_TST0_WP1_shift_w                        (12)                    /*!< Bit Shift of 32bit */
#define CAN_TST0_WP1_shift_h0                       (12)                    /*!< Bit Shift of 16bit */
#define CAN_TST0_WP1_shift_b1                       (4)                     /*!< Bit Shift of 8bit */

#define CAN_TST0_RP0_mask_w                         ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define CAN_TST0_RP0_mask_h0                        ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define CAN_TST0_RP0_mask_b1                        ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CAN_TST0_RP0_shift_w                        (10)                    /*!< Bit Shift of 32bit */
#define CAN_TST0_RP0_shift_h0                       (10)                    /*!< Bit Shift of 16bit */
#define CAN_TST0_RP0_shift_b1                       (2)                     /*!< Bit Shift of 8bit */

#define CAN_TST0_WP0_mask_w                         ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define CAN_TST0_WP0_mask_h0                        ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CAN_TST0_WP0_mask_b1                        ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CAN_TST0_WP0_shift_w                        (8)                     /*!< Bit Shift of 32bit */
#define CAN_TST0_WP0_shift_h0                       (8)                     /*!< Bit Shift of 16bit */
#define CAN_TST0_WP0_shift_b1                       (0)                     /*!< Bit Shift of 8bit */

#define CAN_TST0_SM_mask_w                          ((uint32_t)0x0000003F)  /*!< Bit Mask of 32bit */
#define CAN_TST0_SM_mask_h0                         ((uint16_t)0x003F)      /*!< Bit Mask of 16bit */
#define CAN_TST0_SM_mask_b0                         ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define CAN_TST0_SM_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define CAN_TST0_SM_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define CAN_TST0_SM_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_CAN_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_CAN.h                           */
/*----------------------------------------------------------------------------*/
