


/**
 ******************************************************************************
 *
 * @file        BSP_USBD_4x4Keyboard.h
 * @brief       The 4 X 4 KEYBOARD Code's h file.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/05/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#ifndef __KEYBOARD_H
#define __KEYBOARD_H

#include <string.h>
#include "MG32_GPIO_DRV.h"



/**
 * @name define
 *   		
 */ 
///@{
#define KEY_BUFFER_MAX          3


/**
 * @name typedef
 *   		
 */ 
///@{

/** 
 * @struct	KBCTR_TypeDef
 * @brief	Control Keyboard.
 */
typedef struct
{
    uint8_t    KeybufferChangeFlag;          /*!<4X4 Keyboard status change flag.*/
    uint8_t    Keybuffer[KEY_BUFFER_MAX];    /*!<Already trigger 4x4 Keyboard function.*/

}KBCTR_TypeDef;
///@}


/**
 * @name variables
 *   		
 */ 
///@{

extern KBCTR_TypeDef KB_CTR;

///@}


/**
 * @name function
 *   		
 */ 
///@{
void BSP_4X4Keyboard_Init(void);
void BSP_4X4Keyboard_main(void);


///@}



#endif








