/**
 ******************************************************************************
 *
 * @file        BSP_12_BLE.h
 * @brief       BLE_MG126 BSP h Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/01/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2021 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 

#ifndef _BSP_BLE_H
#define _BSP_BLE_H


#include "MG32__Common_DRV.h"
#include "MG32_SYS_DRV.h"
#include "MG32_CSC_DRV.h"
#include "MG32_RST_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_EXIC_DRV.h"
#include "MG32_SPI_DRV.h"
#include "MG32_TM_DRV.h"
#include "MG32_IWDT_DRV.h"

/**
 * @name define
 *   		
 */ 
///@{
//EXIC 
#define BLE_CSN_EXIC_PORT      EXIC_PE
#define BLE_CSN_EXIC_TRGSPIN   EXIC_TRGS_PIN0
#define BLE_CSN_EXIC_OR_MASK   EXIC_PX_PIN0
#define BLE_CSN_EXIC_FLAG      EXIC_PX_PIN0
#define BLE_CSN_EXIC_IT        EXIC_PE_IT
#define BLE_CSN_EXIC_IRQn      EXINT3_IRQn  
///@}


/**
 * @name typedef
 *   		
 */ 
///@{
typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

typedef struct ble_character16
{
    u16 type16;             //type2
    u16 handle_rec;         //handle
    u8  characterInfo[5];   //property1 - handle2 - uuid2
    u8  uuid128_idx;        //0xff means uuid16,other is idx of uuid128
}BLE_CHAR;

typedef struct ble_UUID128
{
    u8  uuid128[16];//uuid128 string: little endian
}BLE_UUID128;


///@}

/**
 * @name variables
 *   		
 */ 
///@{
extern byte BLE_RXF;
extern byte BLE_TCF;


///@}

/**
 * @name function
 *   		
 */ 
///@{
void BSP_BLE_Init(void);
uint8_t BSP_BLE_GetConnectStatus(void);
void BSP_BLE_WriteTxBuffer (u8* Index, u8 len);
u8 BSP_BLE_ReadRxBuffer (u8* DestIndex);
void BSP_BLE_ClearBleTxBuffer (void);
void BSP_BLE_ClearBleRxBuffer (void);
void BSP_BLE_IrqMcuGotoSleepAndWakeup(void);
void BLE_IRQHandler(void);


//For BSP_12_BLE_app
void BSP_BLE_WriteRxBuffer (u8* DestIndex, u8 len);
void BSP_BLE_ReadCallback(void);

//For mg_BLE_libv4_m0.lib use.
char IsIrqEnabled(void);
unsigned int GetSysTickCount(void);
unsigned char SPI_WriteBuf(unsigned char reg, unsigned char const *pBuf, unsigned char len);
unsigned char SPI_ReadBuf(unsigned char reg, unsigned char *pBuf, unsigned char len);
void UsrProcCallback(void);
void SysClk8to48(void);
void SysClk48to8(void);
void DisableEnvINT(void);
void EnableEnvINT(void);
void McuGotoSleepAndWakeup(void);
void UpdateLEDValueAll(void);


///@}



#endif



