/**
 ******************************************************************************
 *
 * @file        MG82F6D64_WIZARD.h
 *
 * @brief       This is a C code for Wizard interface.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V2.02
 * @date        2024/05/09
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IS" without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the worldwide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

//*** <<< Use Configuration Wizard in Context Menu >>> ***



/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize GPIO
//<i>  Check this term to initialize GPIO.
//<i>  Date: 2021/10/18     Version: 1.01
#define MG82F6D64_GPIO_WIZARD  0
//  <e0> Port0 Config
//  <i> P00: AD0, KBI0, AC0OUT, nINT3, T3EX
//  <i> P01: AD1, KBI1, AC0NI, nINT2
//  <i> P02: AD2, KBI2, AC0PI0, nINT3
//  <i> P03: AD3, KBI3, AC0PI1
//  <i> P04: AD4, KBI4, AC0PI2
//  <i> P05: AD5, KBI5, AC0PI3, nINT0
//  <i> P06: AD6, KBI6, AC1NI, nINT3
//  <i> P07: AD7, KBI7, AC1PI, nINT1
    #define WizGPIO_P0_EN  0
//      <e0> P0.0
//      <i> P00: AD0, KBI0, AC0OUT, nINT3, T3EX
        #define WizGPIO_P00_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.0 mode.
//              <0x01010001=> Analog Input Only (P0M0.0=0, P0M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P0M0.0=1, P0M1.0=1)
//              <0x01010000=> Open Drain (P0M0.0=0, P0M1.0=0)
//              <0x01010100=> Push Pull (P0M0.0=1, P0M1.0=0)
            #define WizGPIO_P00_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P0.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.0=1)
            #define WizGPIO_P00_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD5A40301=> T3EX (T3PS1=0, T3PS0=0)
//              <0xD3A43000=> KBI0 (KBILPS1=0, KBILPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=0, INT3IS1=1, INT3IS0=0)
//              <0xEBA4C000=> AD0 (ADLPS1=0, ADLPS0=0)
//              <0xD1A40200=> AC0OUT
            #define WizGPIO_P00_AF  0x00000000
//      </e> P0.0 End

//      <e0> P0.1
//      <i> P01: AD1, KBI1, AC0NI, nINT2
        #define WizGPIO_P01_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.1mode.
//              <0x02020002=> Analog Input Only (P0M0.1=0, P0M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P0M0.1=1, P0M1.1=1)
//              <0x02020000=> Open Drain (P0M0.1=0, P0M1.1=0)
//              <0x02020200=> Push Pull (P0M0.1=1, P0M1.1=0)
            #define WizGPIO_P01_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P0.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.1=1)
            #define WizGPIO_P01_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A43001=> KBI1 (KBILPS1=0, KBILPS0=1)
//              <0xD1C13000=> nINT2 (INT2IS2=1, INT2IS1=1, INT2IS0=0)
//              <0xEBA4C001=> AD1 (ADLPS1=0, ADLPS0=0)
//              <0xA09FF000=> AC0NI
            #define WizGPIO_P01_AF  0x00000000
//      </e> P0.1 End

//      <e0> P0.2
//      <i> P02: AD2, KBI2, AC0PI0, nINT3
        #define WizGPIO_P02_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.2mode.
//              <0x04040004=> Analog Input Only (P0M0.2=0, P0M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P0M0.2=1, P0M1.2=1)
//              <0x04040000=> Open Drain (P0M0.2=0, P0M1.2=0)
//              <0x04040400=> Push Pull (P0M0.2=1, P0M1.2=0)
            #define WizGPIO_P02_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P0.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.2=1)
            #define WizGPIO_P02_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A43002=> KBI2 (KBILPS1=0, KBILPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=1, INT3IS1=0, INT3IS0=0)
//              <0xEBA4C002=> AD2 (ADLPS1=0, ADLPS0=0)
//              <0xA09F0300=> AC0PI0
            #define WizGPIO_P02_AF  0x00000000
//      </e> P0.2 End

//      <e0> P0.3
//      <i> P03: AD3, KBI3, AC0PI1
        #define WizGPIO_P03_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.3mode.
//              <0x08080008=> Analog Input Only (P0M0.3=0, P0M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P0M0.3=1, P0M1.3=1)
//              <0x08080000=> Open Drain (P0M0.3=0, P0M1.3=0)
//              <0x08080800=> Push Pull (P0M0.3=1, P0M1.3=0)
            #define WizGPIO_P03_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P0.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.3=1)
            #define WizGPIO_P03_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A43003=> KBI3 (KBILPS1=0, KBILPS0=1)
//              <0xEBA4C003=> AD3 (ADLPS1=0, ADLPS0=0)
//              <0xA09F0301=> AC0PI1
            #define WizGPIO_P03_AF  0x00000000
//      </e> P0.3 End

//      <e0> P0.4
//      <i> P04: AD4, KBI4, AC0PI2
        #define WizGPIO_P04_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.4mode.
//              <0x10100010=> Analog Input Only (P0M0.4=0, P0M1.4=1)(Default)
//              <0x10101010=> Open Drain with Pull-up Resistor (P0M0.4=1, P0M1.4=1)
//              <0x10100000=> Open Drain (P0M0.4=0, P0M1.4=0)
//              <0x10101000=> Push Pull (P0M0.4=1, P0M1.4=0)
            #define WizGPIO_P04_MODE  0x10100010

//          <o0> Fast Driving Control
//          <i>  P0.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.4=1)
            #define WizGPIO_P04_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C004=> KBI4 (KBIHPS1=0, KBIHPS0=1)
//              <0xEBA4C004=> AD4 (ADLPS1=0, ADLPS0=0)
//              <0xA09F0302=> AC0PI2
            #define WizGPIO_P04_AF  0x00000000
//      </e> P0.4 End

//      <e0> P0.5
//      <i> P05: AD5, KBI5, AC0PI3, nINT0
        #define WizGPIO_P05_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.5mode.
//              <0x20200020=> Analog Input Only (P0M0.5=0, P0M1.5=1)(Default)
//              <0x20202020=> Open Drain with Pull-up Resistor (P0M0.6=1, P0M1.6=1)
//              <0x20200000=> Open Drain (P0M0.1=0, P0M1.1=0)
//              <0x20202000=> Push Pull (P0M0.5=1, P0M1.5=0)
            #define WizGPIO_P05_MODE  0x20200020

//          <o0> Fast Driving Control
//          <i> P0.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.5=1)
            #define WizGPIO_P05_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C005=> KBI5 (KBIHPS1=0, KBIHPS0=1)
//              <0xD0C13000=> nINT0 (INT0IS2=1, INT0IS1=1, INT0IS0=1)
//              <0xEBA4C005=> AD5 (ADLPS1=0, ADLPS0=0)
//              <0xA09F0303=> AC0PI3
            #define WizGPIO_P05_AF  0x00000000
//      </e> P0.5 End

//      <e0> P0.6
//      <i> P06: AD6, KBI6, AC1NI, nINT3
        #define WizGPIO_P06_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.6mode.
//              <0x40400040=> Analog Input Only (P0M0.6=0, P0M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P0M0.6=1, P0M1.6=1)
//              <0x40400000=> Open Drain (P0M0.1=0, P0M1.1=0)
//              <0x40404000=> Push Pull (P0M0.6=1, P0M1.6=0)
            #define WizGPIO_P06_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P0.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.6=1)
            #define WizGPIO_P06_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C006=> KBI6 (KBIHPS1=0, KBIHPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=1, INT3IS1=1, INT3IS0=0)
//              <0xEBA4C006=> AD6 (ADLPS1=0, ADLPS0=0)
//              <0xA19F1800=> AC1NI
            #define WizGPIO_P06_AF  0x00000000
//      </e> P0.6 End

//      <e0> P0.7
//      <i> P07: AD7, KBI7, AC1PI, nINT1
        #define WizGPIO_P07_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P0.7mode.
//              <0x80800080=> Analog Input Only (P0M0.7=0, P0M1.7=1)(Default)
//              <0x80808080=> Open Drain with Pull-up Resistor (P0M0.7=1, P0M1.7=1)
//              <0x80800000=> Open Drain (P0M0.7=0, P0M1.7=0)
//              <0x80808000=> Push Pull (P0M0.7=1, P0M1.7=0)
            #define WizGPIO_P07_MODE  0x80800080

//          <o0> Fast Driving Control
//          <i>  P0.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P0FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P0FDC.7=1)
            #define WizGPIO_P07_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C007=> KBI7 (KBIHPS1=0, KBIHPS0=1)
//              <0xD0C1C000=> nINT1 (INT1IS2=1, INT1IS1=1, INT1IS0=1)
//              <0xEBA4C007=> AD7 (ADLPS1=0, ADLPS0=0)
//              <0xAC100010=> AC1PI
            #define WizGPIO_P07_AF  0x00000000
//      </e> P0.7 End

#define P0_MODE     (WizGPIO_P00_MODE | WizGPIO_P01_MODE | WizGPIO_P02_MODE | WizGPIO_P03_MODE | WizGPIO_P04_MODE | WizGPIO_P15_MODE | WizGPIO_P16_MODE | WizGPIO_P17_MODE)
#define P0_FDC      (WizGPIO_P00_FDC | (WizGPIO_P01_FDC<<1) | (WizGPIO_P02_FDC<<2) | (WizGPIO_P03_FDC<<3) | (WizGPIO_P04_FDC<<4) | (WizGPIO_P05_FDC<<5) | (WizGPIO_P06_FDC<<6) | (WizGPIO_P07_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Port 0 driving strength.
        #define P0_DRIVEIN_STRENGTH  0

//          <o0> P07 ~ P04
//              <1=> Low Driving Strength (P0DC1=1)
//              <0=> High Driving Strength (P0DC1=0)(Default)
            #define P0DC_1  0

//          <o0> P03 ~ P00
//              <1=> Low Driving Strength (P0DC0=1)
//              <0=> High Driving Strength (P0DC0=0)(Default)
            #define P0DC_0  0
//      </e>
//  </e> Port0 Config End

//  <e0> Port1 Config
//  <i> P10: AIN0, KBI0, T2/T2CKO, nINT0
//  <i> P11: AIN1, KBI1, T2EX, nINT2
//  <i> P12: AIN2, KBI2, RXD1
//  <i> P13: AIN3, KBI3, TXD1
//  <i> P14: AIN4, KBI4, nSS, nINT0
//  <i> P15: AIN5, KBI5, MOSI, nINT1
//  <i> P16: AIN6, KBI6, MISO, nINT3
//  <i> P17: AIN7, KBI7, SPICLK, T0/T0CKO
    #define WizGPIO_P1_EN  0
//      <e0> P1.0
//      <i> P10: AIN0, KBI0, T2/T2CKO, nINT0
        #define WizGPIO_P10_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.0 mode.
//              <0x01010001=> Analog Input Only (P1M0.0=0, P1M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P1M0.0=1, P1M1.0=1)
//              <0x01010000=> Open Drain (P1M0.1=0, P1M1.1=0)
//              <0x01010100=> Push Pull (P1M0.0=1, P1M1.0=0)
            #define WizGPIO_P10_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P1.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.0=1)
            #define WizGPIO_P10_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD1A4C000=> T2 (T2PS1=0, T2PS0=0)
//              <0xD1A4C000=> T2CKO (T2PS1=0, T2PS0=0)
//              <0xD3A43000=> KBI0 (KBILPS1=0,KBILPS0=0)
//              <0xD0C13000=> nINT0 (INT0IS2=1, INT0IS1=0, INT0IS0=0)
//              <0xA0C40700=> AIN0
            #define WizGPIO_P10_AF  0x00000000
//      </e> P1.0 End

//      <e0> P1.1
//      <i> P11: AIN1, KBI1, T2EX, nINT2
        #define WizGPIO_P11_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.1mode.
//              <0x02020002=> Analog Input Only (P1M0.1=0, P1M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P1M0.1=1, P1M1.1=1)
//              <0x02020000=> Open Drain (P1M0.1=0, P1M1.1=0)
//              <0x02020200=> Push Pull (P1M0.1=1, P1M1.1=0)
            #define WizGPIO_P11_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P1.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.1=1)
            #define WizGPIO_P11_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A43001=> KBI1 (KBILPS1=0, KBILPS0=0)
//              <0xD1A4C001=> T2EX (T2PS1=0, T2PS0=0)
//              <0xD1C13000=> nINT2 (INT2IS2=0, INT2IS1=1, INT2IS0=0)
//              <0xA0C40701=> AIN1
            #define WizGPIO_P11_AF  0x00000000
//      </e> P1.1 End

//      <e0> P1.2
//      <i> P12: AIN2, KBI2, RXD1
        #define WizGPIO_P12_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.2mode.
//              <0x04040004=> Analog Input Only (P1M0.2=0, P1M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P1M0.2=1, P1M1.2=1)
//              <0x04040000=> Open Drain (P1M0.2=0, P1M1.2=0)
//              <0x04040400=> Push Pull (P1M0.2=1, P1M1.2=0)
            #define WizGPIO_P12_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P1.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.2=1)
            #define WizGPIO_P12_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40300=> RXD1 (S1PS1=0, S1PS0=0)
//              <0xD3A43002=> KBI2 (KBILPS1=0, KBILPS0=0)
//              <0xA0C40702=> AIN2
            #define WizGPIO_P12_AF  0x00000000
//      </e> P1.2 End

//      <e0> P1.3
//      <i> P13: AIN3, KBI3, TXD1
        #define WizGPIO_P13_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.3mode.
//              <0x08080008=> Analog Input Only (P1M0.3=0, P1M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P1M0.3=1, P1M1.3=1)
//              <0x08080000=> Open Drain (P1M0.3=0, P1M1.3=0)
//              <0x08080800=> Push Pull (P1M0.3=1, P1M1.3=0)
            #define WizGPIO_P13_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P1.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.3=1)
            #define WizGPIO_P13_FDC  1

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40301=> TXD1 (S1PS1=0, S1PS0=0)
//              <0xD3A43003=> KBI3 (KBILPS1=0, KBILPS0=0)
//              <0xA0C40703=> AIN3
            #define WizGPIO_P13_AF  0x00000000
//      </e> P1.3 End

//      <e0> P1.4
//      <i> P14: AIN4, KBI4, nSS, nINT0
        #define WizGPIO_P14_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.4mode.
//              <0x10100010=> Analog Input Only (P1M0.4=0, P1M1.4=1)(Default)
//              <0x10101010=> Open Drain with Pull-up Resistor (P1M0.4=1, P1M1.4=1)
//              <0x10100000=> Open Drain (P1M0.4=0, P1M1.4=0)
//              <0x10101000=> Push Pull (P1M0.4=1, P1M1.4=0)
            #define WizGPIO_P14_MODE  0x10100010

//          <o0> Fast Driving Control
//          <i>  P1.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.4=1)
            #define WizGPIO_P14_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C004=> KBI4 (KBIHPS1=0, KBIHPS0=0)
//              <0xD0C13000=> nINT0 (INT0IS2=1, INT0IS1=0, INT0IS0=1)
//              <0xD7A43000=> Pin Option 0 nSS (SPIPS1=0, SPIPS0=0)
//              <0xA0C40704=> AIN4
            #define WizGPIO_P14_AF  0x00000000
//      </e> P1.4 End

//      <e0> P1.5
//      <i> P15: AIN5, KBI5, MOSI, nINT1
        #define WizGPIO_P15_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.5mode.
//              <0x20200020=> Analog Input Only (P1M0.5=0, P1M1.5=1)(Default)
//              <0x20202020=> Open Drain with Pull-up Resistor (P1M0.6=1, P1M1.6=1)
//              <0x20200000=> Open Drain (P1M0.1=0, P1M1.1=0)
//              <0x20202000=> Push Pull (P1M0.5=1, P1M1.5=0)
            #define WizGPIO_P15_MODE  0x20200020

//          <o0> Fast Driving Control
//          <i>  P1.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.5=1)
            #define WizGPIO_P15_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C005=> KBI5 (KBIHPS1=0, KBIHPS0=0)
//              <0xD0C1C000=> nINT1 (INT1IS2=1, INT1IS1=0, INT1IS0=1)
//              <0xD7A43001=> Pin Option 0 MOSI (SPID0)(SPIPS1=0, SPIPS0=0)
//              <0xA0C40705=> AIN5
            #define WizGPIO_P15_AF  0x00000000
//      </e> P1.5 End

//      <e0> P1.6
//      <i> P16: AIN6, KBI6, MISO, nINT3
        #define WizGPIO_P16_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.6mode.
//              <0x40400040=> Analog Input Only (P1M0.6=0, P1M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P1M0.6=1, P1M1.6=1)
//              <0x40400000=> Open Drain (P1M0.1=0, P1M1.1=0)
//              <0x40404000=> Push Pull (P1M0.6=1, P1M1.6=0)
            #define WizGPIO_P16_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P1.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.6=1)
            #define WizGPIO_P16_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A4C006=> KBI6 (KBIHPS1=0, KBIHPS0=0)
//              <0xD2C10E00=> nINT3 (INT3IS2=0, INT3IS1=1, INT3IS0=1)
//              <0xD7A43002=> Pin Option 0 MISO (SPID1)(SPIPS1=0, SPIPS0=0)
//              <0xA0C40706=> AIN6
            #define WizGPIO_P16_AF  0x00000000
//      </e> P1.6 End

//      <e0> P1.7
//      <i> P17: AIN7, KBI7, SPICLK, T0/T0CKO
        #define WizGPIO_P17_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P1.7mode.
//              <0x80800080=> Analog Input Only (P1M0.7=0,  P1M1.7=1)(Default)
//              <0x80808080=> Open Drain with Pull-up Resistor (P1M0.7=1, P1M1.7=1)
//              <0x80800000=> Open Drain (P1M0.7=0, P1M1.7=0)
//              <0x80808000=> Push Pull (P1M0.7=1, P1M1.7=0)
            #define WizGPIO_P17_MODE  0x80800080

//          <o0> Fast Driving Control
//          <i>  P1.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P1FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P1FDC.7=1)
            #define WizGPIO_P17_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO(Default)
//              <0xD0A4C000=> T0 (T0PS1=1, T0PS0=1)
//              <0xD0A4C000=> T0CKO (T0PS1=1, T0PS0=1)
//              <0xD3A4C007=> KBI7 (KBIHPS1=0, KBIHPS0=0)
//              <0xD7A43003=> Pin Option 0 SPICLK (SPIPS1=0, SPIPS0=0)
//              <0xA0C40707=> AIN7
            #define WizGPIO_P17_AF  0x00000000
//      </e> P1.7 End

#define P1_MODE     (WizGPIO_P10_MODE | WizGPIO_P11_MODE | WizGPIO_P12_MODE | WizGPIO_P13_MODE | WizGPIO_P14_MODE | WizGPIO_P15_MODE | WizGPIO_P16_MODE | WizGPIO_P17_MODE)
#define P1_FDC      (WizGPIO_P10_FDC | (WizGPIO_P11_FDC<<1) | (WizGPIO_P12_FDC<<2) | (WizGPIO_P13_FDC<<3) | (WizGPIO_P14_FDC<<4) | (WizGPIO_P15_FDC<<5) | (WizGPIO_P16_FDC<<6) | (WizGPIO_P17_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Port 1 driving strength.
        #define P1_DRIVEIN_STRENGTH  0

//          <o0> P14 ~ P17
//              <1=> Low Driving Strength (P1DC1=1)
//              <0=> High Driving Strength (P1DC1=0)(Default)
            #define P1DC_1  0

//          <o0> P13 ~ P10
//              <1=> Low Driving Strength (P1DC0=1)
//              <0=> High Driving Strength (P1DC0=0)(Default)
            #define P1DC_0  0
//      </e>
//  </e> Port1 Config End

//  <e0> Port2 Config
//  <i> P20: AD0, AIN8, KBI0, RXD1, T3EX, nINT2
//  <i> P21: AD1, AIN9, KBI1, TXD1, ECI, nINT3, T3/T3CKO
//  <i> P22: AD2, CEX0, KBI2
//  <i> P23: AD3, CEX1, KBI3, TWI0_SDA
//  <i> P24: AD4, CEX2, KBI4
//  <i> P25: AD5, CEX3, KBI5, TWI0_SCL, nINT2
//  <i> P26: AD6, CEX4, KBI6
//  <i> P27: AD7, CEX5, KBI7
    #define WizGPIO_P2_EN  0
//      <e0> P2.0
//      <i> P20: AD0, AIN8, KBI0, RXD1, T3EX, nINT2
        #define WizGPIO_P20_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.0 mode.
//              <0x01010001=> Analog Input Only (P2M0.0=0, P2M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P2M0.0=1, P2M1.0=1)
//              <0x01010000=> Open Drain (P2M0.0=0, P2M1.0=0)
//              <0x01010100=> Push Pull (P2M0.0=1, P2M1.0=0)
            #define WizGPIO_P20_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P2.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.0=1)
            #define WizGPIO_P20_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40300=> RXD1 (S1PS1=1, S1PS0=0)
//              <0xD5A40301=> T3EX (T3PS1=1, T3PS0=0)
//              <0xEBA4C000=> AD0 (ADLPS1=0, ADLPS0=1)
//              <0xD3A43000=> KBI0 (KBILPS1=1, KBILPS0=0)
//              <0xD1C13000=> nINT2 (INT2IS2=0, INT2IS1=0, INT2IS0=1)
//              <0xA0C40708=> AIN8
            #define WizGPIO_P20_AF  0x00000000
//      </e> P2.0 End

//      <e0> P2.1
//      <i> P21: AD1, AIN9, KBI1, TXD1, ECI, nINT3, T3/T3CKO
        #define WizGPIO_P21_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.1 mode.
//              <0x02020002=> Analog Input Only (P2M0.1=0, P2M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P2M0.1=1, P2M1.1=1)
//              <0x02020000=> Open Drain (P2M0.1=0, P2M1.1=0)
//              <0x02020200=> Push Pull (P2M0.1=1, P2M1.1=0)
            #define WizGPIO_P21_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P2.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.1=1)
            #define WizGPIO_P21_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40301=> TXD1 (S1PS1=1, S1PS0=0)
//              <0xD2A40200=> ECI (ECIPS0=1)
//              <0xD5A40300=> T3 (T3PS1=1, T3PS0=0)
//              <0xD5A40300=> T3CKO (T3PS1=1, T3PS0=0)
//              <0xD3A43001=> KBI1 (KBILPS1=1, KBILPS0=0)
//              <0xD2C10E00=> nINT3 (INT3IS2=0, INT3IS1=0, INT3IS0=1)
//              <0xEBA4C001=> AD1 (ADLPS1=0, ADLPS0=1)
//              <0xA0C40709=> AIN9
            #define WizGPIO_P21_AF  0x00000000
//      </e> P2.1 End

//      <e0> P2.2
//      <i> P22: AD2, CEX0, KBI2
        #define WizGPIO_P22_EN  0
//          <o0> Mode Assignment
//          <i> Specify P2.2 mode.
//              <0x04040004=> Analog Input Only (P2M0.2=0, P2M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P2M0.2=1, P2M1.2=1)
//              <0x04040000=> Open Drain (P2M0.2=0, P2M1.2=0)
//              <0x04040400=> Push Pull (P2M0.2=1, P2M1.2=0)
            #define WizGPIO_P22_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P2.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.2=1)
            #define WizGPIO_P22_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD2A40400=> CEX0 (C0PS0=0)
//              <0xD3A43002=> KBI2 (KBILPS1=1, KBILPS0=0)
//              <0xEBA4C002=> AD2 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P22_AF  0x00000000
//      </e> P2.2 End

//      <e0> P2.3
//      <i> P23: AD3, CEX1, KBI3, TWI0_SDA
        #define WizGPIO_P23_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.3 mode.
//              <0x08080008=> Analog Input Only (P2M0.3=0, P2M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P2M0.3=1, P2M1.3=1)
//              <0x08080000=> Open Drain (P2M0.3=0, P2M1.3=0)
//              <0x08080800=> Push Pull (P2M0.3=1, P2M1.3=0)
            #define WizGPIO_P23_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P2.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.3=1)
            #define WizGPIO_P23_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD2A40800=> CEX1 (C0PS1=0)
//              <0xD0A40601=> TWI0_SDA (TWIPS1=1, TWIPS0=1)
//              <0xD3A43003=> KBI3 (KBILPS1=1, KBILPS0=0)
//              <0xEBA4C003=> AD3 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P23_AF  0x00000000
//      </e> P2.3 End

//      <e0> P2.4
//      <i> P24: AD4, CEX2, KBI4
        #define WizGPIO_P24_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.4 mode.
//              <0x10100010=> Analog Input Only (P2M0.4=0, P2M1.4=1)(Default)
//              <0x10101010=> Open Drain with Pull-up Resistor (P2M0.4=1, P2M1.4=1)
//              <0x10100000=> Open Drain (P2M0.2=0, P2M1.2=0)
//              <0x10101000=> Push Pull (P2M0.4=1, P2M1.4=0)
            #define WizGPIO_P24_MODE  0x10100010

//          <o0> Fast Driving Control
//          <i>  P2.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.4=1)
            #define WizGPIO_P24_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD2A40401=> CEX2 (C0PS0=0)
//              <0xD3A4C004=> KBI4 (KBIHPS1=1, KBIHPS0=0)
//              <0xEBA4C004=> AD4 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P24_AF  0x00000000
//      </e> P2.4 End

//      <e0> P2.5
//      <i> P25: AD5, CEX3, KBI5, TWI0_SCL, nINT2
        #define WizGPIO_P25_EN  0

//          <o0> Mode Assignment
//          <i>  Specify P2.5 mode.
//              <0x20200020=> Analog Input Only (P2M0.5=0, P2M1.5=1)(Default)
//              <0x20202020=> Open Drain with Pull-up Resistor (P2M0.5=1, P2M1.5=1)
//              <0x20200000=> Open Drain (P2M0.5=0, P2M1.5=0)
//              <0x20202000=> Push Pull (P2M0.5=1, P2M1.5=0)
            #define WizGPIO_P25_MODE  0x20200020

//          <o0> Fast Driving Control
//          <i> P2.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.5=1)
            #define WizGPIO_P25_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40600=> TWI0_SCL (TWIPS1=1, TWIPS0=1)
//              <0xD2A40801=> CEX3 (C0PS1=0)
//              <0xD3A4C005=> KBI5 (KBIHPS1=1, KBIHPS0=0)
//              <0xD1C13000=> nINT2 (INT2IS2=0, INT2IS1=1, INT2IS0=1)
//              <0xEBA4C005=> AD5 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P25_AF  0x00000000
//      </e> P2.5 End

//      <e0> P2.6
//      <i> P26: AD6, CEX4, KBI6
        #define WizGPIO_P26_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.6 mode.
//              <0x40400040=> Analog Input Only (P2M0.6=0, P2M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P2M0.6=1, P2M1.6=1)
//              <0x40400000=> Open Drain (P2M0.6=0, P2M1.6=0)
//              <0x40404000=> Push Pull (P2M0.6=1, P2M1.6=0)
            #define WizGPIO_P26_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P2.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.6=1)
            #define WizGPIO_P26_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD2A40402=> CEX4 (C0PS0=0)
//              <0xD3A4C006=> KBI6 (KBIHPS1=1, KBIHPS0=0)
//              <0xEBA4C006=> AD6 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P26_AF  0x00000000
//      </e> P2.6 End

//      <e0> P2.7
//      <i> P27: AD7, CEX5, KBI7
        #define WizGPIO_P27_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P2.7 mode.
//              <0x80800080=> Analog Input Only (P2M0.7=0, P2M1.7=1)(Default)
//              <0x80808080=> Open Drain with Pull-up Resistor (P2M0.7=1, P2M1.7=1)
//              <0x80800000=> Open Drain (P2M0.7=0, P2M1.7=0)
//              <0x80808000=> Push Pull (P2M0.7=1, P2M1.7=0)
            #define WizGPIO_P27_MODE  0x80800080

//          <o0> Fast Driving Control
//          <i> P2.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P2FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P2FDC.7=1)
            #define WizGPIO_P27_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD2A40802=> CEX5 (C0PS1=0)
//              <0xD3A4C007=> KBI7 (KBIHPS1=1, KBIHPS0=0)
//              <0xEBA4C007=> AD7 (ADLPS1=0, ADLPS0=1)
            #define WizGPIO_P27_AF  0x00000000
//      </e> P2.7 End

#define P2_MODE     (WizGPIO_P20_MODE | WizGPIO_P21_MODE | WizGPIO_P22_MODE | WizGPIO_P23_MODE | WizGPIO_P24_MODE | WizGPIO_P25_MODE | WizGPIO_P26_MODE | WizGPIO_P27_MODE)
#define P2_FDC      ((WizGPIO_P20_FDC) | (WizGPIO_P21_FDC<<1) | (WizGPIO_P22_FDC<<2) | (WizGPIO_P23_FDC<<3) | (WizGPIO_P24_FDC<<4) | (WizGPIO_P25_FDC<<5) | (WizGPIO_P26_FDC<<6) | (WizGPIO_P27_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Specify Port 2 driving strength.
        #define P2_DRIVEIN_STRENGTH  0
//          <o0> P27 ~ P24
//              <1=> Low Driving Strength (P2DC1=1)
//              <0=> High Driving Strength (P2DC1=0)(Default)
            #define P2DC_1  0
//          <o0> P23 ~ P20
//              <1=> Low Driving Strength (P2DC0=1)
//              <0=> High Driving Strength (P2DC0=0)(Default)
            #define P2DC_0  0
//      </e>
//  </e> Port2 Config End

//  <e0> Port3 Config
//  <i> P30: RXD0, TXD0, nINT0, TWI0_SDA, BM0OUT
//  <i> P31: TXD0, RXD0, nINT1, TWI0_SCL, BM1OUT
//  <i> P32: RXD2, CEX4, nINT0, T2/T2CKO, T3EX
//  <i> P33: TXD2, CEX1, nINT1, T2EX, T3/T3CKO
//  <i> P34: RXD1, CEX3, nINT0, T0/T0CKO, T5, PWM2A
//  <i> P35: TXD1, CEX5, nINT1, T1/T1CKO, T6, PWM2B
//  <i> P36: RXD3, nINT0, T1/T1CKO, T4/T4CKO, T4EX, PWM0A, SPID2, nWR, nRD
//  <i> P37: TXD3, nINT1, T1/T1CKO, T4/T4CKO, T4EX, PWM0B, SPID3, nRD, nWR
    #define WizGPIO_P3_EN  0
//      <e0> P3.0
//      <i> P30: RXD0, TXD0, nINT0, TWI0_SDA, BM0OUT
        #define WizGPIO_P30_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.0 mode.
//              <0x01010001=> Push Pull (P3M0.0=0, P3M1.0=1)
//              <0x01010101=> Open Drain (P3M0.0=1, P3M1.0=1)
//              <0x01010000=> Quasi-Bidirectional (P3M0.0=0, P3M1.0=0)(Default)
//              <0x01010100=> Input Only (P3M0.0=1, P3M1.0=0)
            #define WizGPIO_P30_MODE  0x01010000

//          <o0> Fast Driving Control
//          <i>  P3.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.0=1)
            #define WizGPIO_P30_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40800=> RXD0 (S0PS1=0, S0PS0=0)
//              <0xD0A40801=> TXD0 (S0PS1=1, S0PS0=0)
//              <0xD0A40601=> TWI0_SDA (TWIPS1=1, TWIPS0=0)
//              <0xD0C13000=> nINT0 (INT0IS2=0, INT0IS1=0, INT0IS0=1)
//              <0xD4A40C00=> BM0OUT (BM0OE1=1, BM0OE0=0)
            #define WizGPIO_P30_AF  0x00000000
//      </e> P3.0 End

//      <e0> P3.1
//      <i> P31: TXD0, RXD0, nINT1, TWI0_SCL, BM1OUT
        #define WizGPIO_P31_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.1 mode.
//              <0x02020002=> Push Pull (P3M0.1=0, P3M1.1=1)
//              <0x02020202=> Open Drain (P3M0.1=1, P3M1.1=1)
//              <0x02020000=> Quasi-Bidirectional (P3M0.1=0, P3M1.1=0)(Default)
//              <0x02020200=> Input Only (P3M0.1=1, P3M1.1=0)
            #define WizGPIO_P31_MODE  0x02020000

//          <o0> Fast Driving Control
//          <i>  P3.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.1=1)
            #define WizGPIO_P31_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40801=> TXD0 (S0PS1=0, S0PS0=0)
//              <0xD0A40800=> RXD0 (S0PS1=1, S0PS0=0)
//              <0xD0A40600=> TWI0_SCL (TWIPS1=1, TWIPS0=0)
//              <0xD0C1C000=> nINT1 (INT1IS2=0, INT1IS1=0, INT1IS0=1)
//              <0xD4A40300=> BM1OUT (BM1OE1=1, BM1OE0=0)
            #define WizGPIO_P31_AF  0x00000000
//      </e> P3.1 End

//      <e0> P3.2
//      <i> P32: RXD2, CEX4, nINT0, T2/T2CKO, T3EX
        #define WizGPIO_P32_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.2 mode.
//              <0x04040004=> Push Pull (P3M0.2=0, P3M1.2=1)
//              <0x04040404=> Open Drain (P3M0.2=1, P3M1.2=1)
//              <0x04040000=> Quasi-Bidirectional (P3M0.2=0, P3M1.2=0)(Default)
//              <0x04040400=> Input Only (P3M0.2=1, P3M1.2=0)
            #define WizGPIO_P32_MODE  0x04040000

//          <o0> Fast Driving Control
//          <i>  P3.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.2=1)
            #define WizGPIO_P32_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA41000=> RXD2 (S2PS0=0)
//              <0xD2A40402=> CEX4 (C0PS0=1)
//              <0xD1A4C000=> T2 (T2PS1=0, T2PS0=1)
//              <0xD1A4C000=> T2CKO (T2PS1=0, T2PS0=1)
//              <0xD5A40301=> T3EX (T3PS1=0, T3PS0=1)
//              <0xD0C13000=> nINT0 (INT0IS2=0, INT0IS1=0, INT0IS0=0)
            #define WizGPIO_P32_AF  0x00000000
//      </e> P3.2 End

//      <e0> P3.3
//      <i> P33: TXD2, CEX1, nINT1, T2EX, T3/T3CKO
        #define WizGPIO_P33_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.3 mode.
//              <0x08080008=> Push Pull (P3M0.3=0, P3M1.3=1)
//              <0x08080808=> Open Drain (P3M0.3=1, P3M1.3=1)
//              <0x08080000=> Quasi-Bidirectional (P3M0.3=0, P3M1.3=0)(Default)
//              <0x08080800=> Input Only (P3M0.3=1, P3M1.3=0)
            #define WizGPIO_P33_MODE  0x08080000

//          <o0> Fast Driving Control
//          <i>  P3.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.3=1)
            #define WizGPIO_P33_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA41001=> TXD2 (S2PS0=0)
//              <0xD2A40800=> CEX1 (C0PS1=1)
//              <0xD1A4C001=> T2EX (T2PS1=0, T2PS0=1)
//              <0xD5A40300=> T3 (T3PS1=0, T3PS0=1)
//              <0xD5A40300=> T3CKO (T3PS1=0, T3PS0=1)
//              <0xD0C1C000=> nINT1 (INT1IS2=0, INT1IS1=0, INT1IS0=0)
            #define WizGPIO_P33_AF  0x00000000
//      </e> P3.3 End

//      <e0> P3.4
//      <i> P34: RXD1, CEX3, nINT0, T0/T0CKO, T5, PWM2A
        #define WizGPIO_P34_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.4 mode.
//              <0x10100010=> Push Pull (P3M0.4=0, P3M1.4=1)
//              <0x10101010=> Open Drain (P3M0.4=1, P3M1.4=1)
//              <0x10100000=> Quasi-Bidirectional (P3M0.4=0, P3M1.4=0)(Default)
//              <0x10101000=> Input Only (P3M0.4=1, P3M1.4=0)
            #define WizGPIO_P34_MODE  0x10100000

//          <o0> Fast Driving Control
//          <i>  P3.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.4=1)
            #define WizGPIO_P34_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40300=> RXD1 (S1PS1=1, S1PS0=1)
//              <0xD2A40801=> CEX3 (C0PS1=1)
//              <0xD2A42000=> PWM2A (C0PPS1=1)
//              <0xD0A4C000=> T0 (T0PS1=0, T0PS0=0)
//              <0xD0A4C000=> T0CKO (T0PS1=0, T0PS0=0)
//              <0xD1000005=> T5
//              <0xD0C13000=> nINT0 (INT0IS2=0, INT0IS1=1, INT0IS0=0)
            #define WizGPIO_P34_AF  0x00000000
//      </e> P3.4 End

//      <e0> P3.5
//      <i> P35: TXD1, CEX5, nINT1, T1/T1CKO, T6, PWM2B
        #define WizGPIO_P35_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.5 mode.
//              <0x20200020=> Push Pull (P3M0.5=0, P3M1.5=1)
//              <0x20202020=> Open Drain (P3M0.5=1, P3M1.5=1)
//              <0x20200000=> Quasi-Bidirectional (P3M0.5=0, P3M1.5=0)(Default)
//              <0x20202000=> Input Only (P3M0.5=1, P3M1.5=0)
            #define WizGPIO_P35_MODE  0x20200000

//          <o0> Fast Driving Control
//          <i>  P3.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.5=1)
            #define WizGPIO_P35_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD6A40301=> TXD1 (S1PS1=1, S1PS0=1)
//              <0xD2A40802=> CEX5 (C0PS1=1)
//              <0xD2A42001=> PWM2B (C0PPS1=1)
//              <0xD1A43000=> T1 (T1PS1=0, T1PS0=0)
//              <0xD1A43000=> T1CKO (T1PS1=0, T1PS0=0)
//              <0xD1000006=> T6
//              <0xD0C1C000=> nINT1 (INT1IS2=0, INT1IS1=1, INT1IS0=0)
            #define WizGPIO_P35_AF  0x00000000
//      </e> P3.5 End

//      <e0> P3.6
//      <i> P36: RXD3, nINT0, T1/T1CKO, T4/T4CKO, T4EX, PWM0A, SPID2, nWR, nRD
        #define WizGPIO_P36_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.6 mode.
//              <0x40400040=> Push Pull (P3M0.6=0, P3M1.6=1)
//              <0x40404040=> Open Drain (P3M0.6=1, P3M1.6=1)
//              <0x40400000=> Quasi-Bidirectional (P3M0.6=0, P3M1.6=0)(Default)
//              <0x40404000=> Input Only (P3M0.6=1, P3M1.6=0)
            #define WizGPIO_P36_MODE  0x40400000

//          <o0> Fast Driving Control
//          <i>  P3.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.6=1)
            #define WizGPIO_P36_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA44000=> RXD3 (S3PS0=0)
//              <0xD2A41000=> PWM0A (C0PPS0=0)
//              <0xD1A43000=> T1 (T1PS1=1, T1PS0=0)
//              <0xD1A43000=> T1CKO (T1PS1=1, T1PS0=0)
//              <0xDAA40300=> T4 (T4PS1=1, T4PS0=1)
//              <0xDAA40300=> T4CKO (T4PS1=1, T4PS0=1)
//              <0xDAA40301=> T4EX (T4PS1=0, T4PS0=1)
//              <0xD0C13000=> nINT0 (INT0IS2=1, INT0IS1=1, INT0IS0=0)
//              <0xEBA40800=> nWR (RWPS0=0)
//              <0xEBA40801=> nRD (RWPS0=1)
//              <0xD7A43014=> Pin Ooption 1 SPID2 (SPIPS1=0, SPIPS0=1)
            #define WizGPIO_P36_AF  0x00000000
//      </e> P3.6 End

//      <e0> P3.7
//      <i> P37: TXD3, nINT1, T1/T1CKO, T4/T4CKO, T4EX, PWM0B, SPID3, nRD, nWR
        #define WizGPIO_P37_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P3.7 mode.
//              <0x80800080=> Push Pull (P3M0.7=0, P3M1.7=1)
//              <0x80808080=> Open Drain (P3M0.7=1, P3M1.7=1)
//              <0x80800000=> Quasi-Bidirectional (P3M0.7=0, P3M1.7=0)(Default)
//              <0x80808000=> Input Only (P3M0.7=1, P3M1.7=0)
            #define WizGPIO_P37_MODE  0x80800000

//          <o0> Fast Driving Control
//          <i>  P3.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P3FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P3FDC.7=1)
            #define WizGPIO_P37_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA44001=> TXD3 (S3PS0=0)
//              <0xD2A41001=> PWM0B (C0PPS0=0)
//              <0xD1A43000=> T1 (T1PS1=1, T1PS0=1)
//              <0xD1A43000=> T1CKO (T1PS1=1, T1PS0=1)
//              <0xDAA40300=> T4 (T4PS1=0, T4PS0=1)
//              <0xDAA40300=> T4CKO (T4PS1=0, T4PS0=1)
//              <0xDAA40301=> T4EX (T4PS1=1, T4PS0=1)
//              <0xD0C1C000=> nINT1 (INT1IS2=1, INT1IS1=1, INT1IS0=0)
//              <0xEBA40800=> nWR (RWPS0=1)
//              <0xEBA40801=> nRD (RWPS0=0)
//              <0xD7A43015=> Pin Option 1 SPID3 (SPIPS1=0, SPIPS0=1)
            #define WizGPIO_P37_AF  0x00000000
//      </e> P3.7 End

#define P3_MODE     (WizGPIO_P30_MODE | WizGPIO_P31_MODE | WizGPIO_P32_MODE | WizGPIO_P33_MODE | WizGPIO_P34_MODE | WizGPIO_P35_MODE | WizGPIO_P36_MODE | WizGPIO_P37_MODE)
#define P3_FDC      ((WizGPIO_P30_FDC<<0) | (WizGPIO_P31_FDC<<1) | WizGPIO_P32_FDC<<2) | (WizGPIO_P33_FDC<<3) | (WizGPIO_P34_FDC<<4) | WizGPIO_P35_FDC<<5) | WizGPIO_P36_FDC<<6) | (WizGPIO_P37_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Specify Port 3 driving strength.
        #define P3_DRIVEIN_STRENGTH  0
//          <o0> P37 ~ P34
//              <1=> Low Driving Strength (P3DC1=1)
//              <0=> High Driving Strength (P3DC1=0)(Default)
            #define P3DC_1  0
//          <o0> P33 ~ P30
//              <1=> Low Driving Strength (P3DC0=1)
//              <0=> High Driving Strength (P3DC0=0)(Default)
            #define P3DC_0  0
//      </e>
//  </e> Port3 Config End

//  <e0> Port4 Config
//  <i> P40: KBI0, nINT0, TWI0_SCL, nSS, SPICLK, T0COA, CEX0, PWM2A
//  <i> P41: KBI1, nINT1, TWI0_SDA, MISO, MOSI, CEX2, PWM2B
//  <i> P42: KBI2, nINT3, TWI1_SCL, MOSI, MISO, BM0OUT
//  <i> P43: KBI3, nINT2, TWI1_SDA, nSS, SPICLK, BM1OUT, T0COB
//  <i> P44: OCD_SCL, RXD0, nINT2, T0/T0CKO, T2EX, S0CKO, BEEP
//  <i> P45: OCD_SDA, TXD0, nINT1, T1/T1CKO, T2/T2CKO, S1CKO, RTCKO
//  <i> P46: T0/T0CKO, T3/T3CKO, ECI, S1CKO
//  <i> P47: RST, C0CKO, S0CKO
    #define WizGPIO_P4_EN  0
//      <e0> P4.0
//      <i> P40: KBI0, nINT0, TWI0_SCL, nSS, SPICLK, T0COA, CEX0, PWM2A
        #define WizGPIO_P40_EN 0
//          <o0> Mode Assignment
//          <i>  Specify P4.0 mode.
//              <0x01010001=> Analog Input Only (P4M0.0=0, P4M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P4M0.0=1, P4M1.0=1)
//              <0x01010000=> Open Drain (P4M0.0=0, P4M1.0=0)
//              <0x01010100=> Push Pull (P4M0.0=1, P4M1.0=0)
            #define WizGPIO_P40_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P4.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.0=1)
            #define WizGPIO_P40_FDC  0

//          <o0> Alternate Function
//          <i> P40: KBI0, nINT0, TWI0_SCL, nSS, SPICLK, T0COA, CEX0, PWM2A
//              <0x00000000=> GPIO (Default)
//              <0xD0A40600=> TWI0_SCL (TWIPS1=0, TWIPS0=0)
//              <0xD2A40400=> CEX0 (C0PS0=1)
//              <0xD2A42000=> PWM2A (C0PPS1=0)
//              <0xD9A41000=> T0COA
//              <0xD3A43000=> KBI0 (KBILPS1=1, KBILPS0=1)
//              <0xD0C13000=> nINT0 (INT0IS2=0, INT0IS1=1, INT0IS0=1)
//              <0xD7A43013=> Pin Option 1 SPICLK (SPIPS1=0, SPIPS0=1)
//              <0xD7A43020=> Pin Option 2 nSS (SPIPS1=1, SPIPS0=0)
//              <0xD7A43033=> Pin Option 3 SPICLK (SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P40_AF  0x00000000
//      </e> P4.0 End

//      <e0> P4.1
//      <i> P41: KBI1, nINT1, CEX2, TWI0_SDA, PWM2B, MISO, MOSI
        #define WizGPIO_P41_EN 0
//          <o0> Mode Assignment
//          <i>  Specify P4.1 mode.
//              <0x02020002=> Analog Input Only (P4M0.1=0, P4M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P4M0.1=1, P4M1.1=1)
//              <0x02020000=> Open Drain (P4M0.1=0, P4M1.1=0)
//              <0x02020200=> Push Pull (P4M0.1=1, P4M1.1=0)
            #define WizGPIO_P41_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P4.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.1=1)
            #define WizGPIO_P41_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40601=> TWI0_SDA (TWIPS1=0, TWIPS0=0)
//              <0xD2A40401=> CEX2 (C0PS0=1)
//              <0xD2A42001=> PWM2B (C0PPS1=0)
//              <0xD3A43001=> KBI1 (KBILPS1=1, KBILPS0=1)
//              <0xD0C1C000=> nINT1 (INT1IS2=0, INT1IS1=1, INT1IS0=1)
//              <0xD7A43012=> Pin Option 1 MISO (SPID1)(SPIPS1=0, SPIPS0=1)
//              <0xD7A43021=> Pin Option 2 MOSI (SPID0)(SPIPS1=1, SPIPS0=0)
//              <0xD7A43031=> Pin Option 3 MOSI (SPID0)(SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P41_AF  0x00000000
//      </e> P4.1 End

//      <e0> P4.2
//      <i> P42: KBI2, nINT3, TWI1_SCL, MOSI, MISO, BM0OUT
        #define WizGPIO_P42_EN 0
//          <o0> Mode Assignment
//          <i> Specify P4.2 mode.
//              <0x04040004=> Analog Input Only (P4M2.0=0, P4M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P4M0.2=1, P4M1.2=1)
//              <0x04040000=> Open Drain (P4M0.2=0, P4M1.2=0)
//              <0x04040400=> Push Pull (P4M0.2=1, P4M1.2=0)
            #define WizGPIO_P42_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P4.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.2=1)
            #define WizGPIO_P42_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD8A43000=> TWI1_SCL (I2C1PS1=0, I2C1PS0=0)
//              <0xD3A43002=> KBI2 (KBILPS1=1, KBILPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=0, INT3IS1=0, INT3IS0=0)
//              <0xD4A40C00=> BM0OUT (BM0OE1=0, BM0OE0=1)
//              <0xD7A43011=> Pin Option 1 MOSI (SPID0)(SPIPS1=0, SPIPS0=1)
//              <0xD7A43022=> Pin Option 2 MISO (SPID1)(SPIPS1=1, SPIPS0=0)
//              <0xD7A43032=> Pin Option 3 MISO (SPID1)(SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P42_AF  0x00000000
//      </e> P4.2 End

//      <e0> P4.3
//      <i> P43: KBI3, nINT2, TWI1_SDA, nSS, SPICLK, BM1OUT, T0COB
        #define WizGPIO_P43_EN 0
//          <o0> Mode Assignment
//          <i>  Specify P4.3 mode.
//              <0x08080008=> Analog Input Only (P4M0.3=0, P4M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P4M0.3=1, P4M1.3=1)
//              <0x08080000=> Open Drain (P4M0.3=0, P4M1.3=0)
//              <0x08080800=> Push Pull (P4M0.3=1, P4M1.3=0)
            #define WizGPIO_P43_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P4.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.3=1)
            #define WizGPIO_P43_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD8A43001=> TWI1_SDA (I2C1PS1=0, I2C1PS0=0)
//              <0xD9A42000=> T0COB
//              <0xD3A43003=> KBI3 (KBILPS1=1, KBILPS0=1)
//              <0xD1C13000=> nINT2 (INT2IS2=0, INT2IS1=0, INT2IS0=0)
//              <0xD4A40300=> BM1OUT (BM1OE1=0, BM1OE0=1)
//              <0xD7A43010=> Pin option 1 nSS (SPIPS1=0, SPIPS0=1)
//              <0xD7A43023=> Pin option 2 SPICLK (SPIPS1=1, SPIPS0=0)
//              <0xD7A43030=> Pin option 3 nSS (SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P43_AF  0x00000000
//      </e> P4.3 End

//      <e0> P4.4 (OCD_ICE)
//      <i> P44: OCD_SCL, RXD0, nINT2, T0/T0CKO, T2EX, S0CKO, BEEP
        #define WizGPIO_P44_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P4.4 mode.
//              <0x10100010=> Analog Input Only (P4M0.4=0, P4M1.4=1)
//              <0x10101010=> Open Drain with Pull-up Resistor (P4M0.4=1, P4M1.4=1)(Default)
//              <0x10100000=> Open Drain (P4M0.4=0, P4M1.4=0)
//              <0x10101000=> Push Pull (P4M0.4=1, P4M1.4=0)
            #define WizGPIO_P44_MODE  0x10101010

//          <o0> Fast Driving Control
//          <i>  P4.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.4=1)
            #define WizGPIO_P44_FDC  0

//          <o0> Alternate Function
//              <0xDF4C0100=> OCD_SCL (ICE)(Default)
//              <0x00000000=> GPIO
//              <0xC0A43000=> BEEP
//              <0xD0A40800=> RXD0 (S0PS1=0, S0PS0=1)
//              <0xD3A40100=> S0CKO (S0COPS=1)
//              <0xD0A4C000=> T0 (T0PS1=0, T0PS0=1)
//              <0xD0A4C000=> T0CKO (T0PS1=0, T0PS0=1)
//              <0xD1A4C001=> T2EX (T2PS1=1, T2PS0=1)
//              <0xD1C13000=> nINT2 (INT2IS2=1, INT2IS1=0, INT2IS0=0)
            #define WizGPIO_P44_AF  0xDF4C0100
//      </e> P4.4 End

//      <e0> P4.5 (OCD_ICE)
//      <i> P45: OCD_SDA, TXD0, nINT1, T1/T1CKO, T2/T2CKO, S1CKO, RTCKO
        #define WizGPIO_P45_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P4.5 mode.
//              <0x20200020=> Analog Input Only (P4M0.5=0, P4M1.5=1)
//              <0x20202020=> Open Drain with Pull-up Resistor (P4M0.5=1, P4M1.5=1)(Default)
//              <0x20200000=> Open Drain (P4M0.5=0, P4M1.5=0)
//              <0x20202000=> Push Pull (P4M0.5=1, P4M1.5=0)
            #define WizGPIO_P45_MODE  0x20202020

//          <o0> Fast Driving Control
//          <i>  P4.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.5=1)
            #define WizGPIO_P45_FDC  0

//          <o0> Alternate Function
//              <0xDF4C0100=> OCD_SDA (ICE)(Default)
//              <0x00000000=> GPIO
//              <0xC0BE4000=> RTCKO
//              <0xD0A40801=> TXD0 (S0PS1=0, S0PS0=1)
//              <0xD5A40400=> S1CKO (S1COPS=1)
//              <0xD1A43000=> T1 (T1PS1=0, T1PS0=1)
//              <0xD1A43000=> T1CKO (T1PS1=0, T1PS0=1)
//              <0xD1A4C000=> T2 (T2PS1=1, T2PS0=1)
//              <0xD1A4C000=> T2CKO (T2PS1=1, T2PS0=1)
//              <0xD0C1C000=> nINT1 (INT1IS2=1, INT1IS1=0, INT1IS0=0)
            #define WizGPIO_P45_AF  0xDF4C0100
//      </e> P4.5 End

//      <e0> P4.6
//      <i> P46: T0/T0CKO, T3/T3CKO, ECI, S1CKO
        #define WizGPIO_P46_EN 0
//          <o0> Mode Assignment
//          <i>  Specify P4.6 mode.
//              <0x40400040=> Analog Input Only (P4M0.6=0, P4M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P4M0.6=1, P4M1.6=1)
//              <0x40400000=> Open Drain (P4M0.6=0, P4M1.6=0)
//              <0x40404000=> Push Pull (P4M0.6=1, P4M1.6=0)
            #define WizGPIO_P46_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P4.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.6=1)
            #define WizGPIO_P46_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD5A40400=> S1CKO (S1COPS=0)
//              <0xD2A40200=> ECI (ECIPS0=1)
//              <0xD0A4C000=> T0 (T1PS1=1, T1PS0=0)
//              <0xD0A4C000=> T0CKO (T1PS1=1, T1PS0=0)
//              <0xD5A40300=> T3 (T3PS1=0, T3PS0=0)
//              <0xD5A40300=> T3CKO (T3PS1=0, T3PS0=0)
            #define WizGPIO_P46_AF  0x00000000
//      </e> P4.6 End

//      <e0> P4.7 (RST)
//      <i> P47: RST, C0CKO, S0CKO
        #define WizGPIO_P47_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P4.7 mode.
//              <0x80800080=> Analog Input Only (P4M0.7=0, P4M1.7=1)
//              <0x80808080=> Open Drain with Pull-up Resistor (P4M0.7=1, P4M1.7=1)(Default)
//              <0x80800000=> Open Drain (P4M0.7=0, P4M1.7=0)
//              <0x80808000=> Push Pull (P4M0.7=1, P4M1.7=0)
            #define WizGPIO_P47_MODE  0x80808080

//          <o0> Fast Driving Control
//          <i>  P4.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P4FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P4FDC.7=1)
            #define WizGPIO_P47_FDC  0

//          <o0> Alternate Function
//              <0xDF4C0200=> RST (Default)
//              <0x00000000=> GPIO
//              <0xD3A40100=> S0CKO (S0COPS=0)
//              <0xD2A40100=> C0CKO (C0COPS=0)
            #define WizGPIO_P47_AF  0xDF4C0200
//      </e> P4.7 End

#define P4_MODE     (WizGPIO_P40_MODE | WizGPIO_P41_MODE | WizGPIO_P42_MODE | WizGPIO_P43_MODE | WizGPIO_P44_MODE | WizGPIO_P45_MODE | WizGPIO_P46_MODE | WizGPIO_P47_MODE)
#define P4_FDC      ((WizGPIO_P40_FDC) | (WizGPIO_P41_FDC<<1) | (WizGPIO_P42_FDC<<2) | (WizGPIO_P43_FDC<<3) | (WizGPIO_P44_FDC<<4) | (WizGPIO_P45_FDC<<5) | (WizGPIO_P46_FDC<<6) | (WizGPIO_P47_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Specify Port 4 driving strength.
        #define P4_DRIVEIN_STRENGTH  0
//          <o0> P44 ~ P46
//              <1=> Low Driving Strength (P4DC1=1)
//              <0=> High Driving Strength (P4DC1=0)(Default)
            #define P4DC_1  0
//          <o0> P43 ~ P40
//              <1=> Low Driving Strength (P4DC0=1)
//              <0=> High Driving Strength (P4DC0=0)(Default)
            #define P4DC_0  0
//      </e>

//      <e0> GPIO Port Protection
//      <i>  Users can activate writing protection of Port4 using this option.
//      <i>  Then, only PageP access can modify.
        #define MG82F6D64_GPIO_Port4_Protection  0

//          <o0> Port 4
//          <i> Enable, only PageP access can modify P4.
//          <i> Modifications in Page 0~F are not allowed.
//              <0=> Disable (P4CTL=0)(Default)
//              <1=> Enable (P4CTL=1)
            #define SPCON0_P4CTL  0
//      </e>
//  </e> Port4 Config End

//  <e0> Port5 Config
//  <i> P50: T4EX, BM0OUT
//  <i> P51: AIN15
//  <i> P52: AIN10
//  <i> P53: AIN11, SPID2
//  <i> P54: AIN12, SPID3
//  <i> P55: AIN13
//  <i> P56: AIN14
//  <i> P57: AD4, TXD2, T2EX, S0MI, SPID3
    #define WizGPIO_P5_EN  0
//      <e0> P5.0
//      <i> P50: T4EX, BM0OUT
        #define WizGPIO_P50_EN  0
//          <o0> Mode Assignment
//          <i> Specify P5.0 mode.
//              <0x01010001=> Analog Input Only (P5M0.0=0,P5M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P5M0.0=1, P5M1.0=1)
//              <0x01010000=> Open Drain (P5M0.0=0, P5M1.0=0)
//              <0x01010100=> Push Pull (P5M0.0=1, P5M1.0=0)
            #define WizGPIO_P50_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P5.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.0=1)
            #define WizGPIO_P50_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA40301=> T4EX (T4PS1=1, T4PS0=0)
//              <0xD4A40C00=> BM0OUT (BM0OE1=1, BM0OE0=1)
            #define WizGPIO_P50_AF  0x00000000
//      </e> P5.0 End

//      <e0> P5.1
//      <i> P51: AIN15
        #define WizGPIO_P51_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P5.1 mode.
//              <0x02020002=> Analog Input Only (P5M0.1=0, P5M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P5M0.1=1, P5M1.1=1)
//              <0x02020000=> Open Drain (P5M0.1=0, P5M1.1=0)
//              <0x02020200=> Push Pull (P5M0.1=1, P5M1.1=0)
            #define WizGPIO_P51_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P5.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.1=1)
            #define WizGPIO_P51_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xA0C4070F=> AIN15
            #define WizGPIO_P51_AF  0x00000000
//      </e> P5.1 End

//      <e0> P5.2
//      <i> P52: AIN10
        #define WizGPIO_P52_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P5.2 mode.
//              <0x04040004=> Analog Input Only (P5M0.2=0, P5M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P5M0.2=1, P5M1.2=1)
//              <0x04040000=> Open Drain (P5M0.2=0, P5M1.2=0)
//              <0x04040400=> Push Pull (P5M0.2=1, P5M1.2=0)
            #define WizGPIO_P52_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P5.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.2=1)
            #define WizGPIO_P52_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xA0C4070A=> AIN10
            #define WizGPIO_P52_AF  0x00000000
//      </e> P5.2 End

//      <e0> P5.3
//      <i> P53: AIN11, SPID2
        #define WizGPIO_P53_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P5.3 mode.
//              <0x08080008=> Analog Input Only (P5M0.3=0, P5M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P5M0.3=1, P5M1.3=1)
//              <0x08080000=> Open Drain (P5M0.3=0, P5M1.3=0)
//              <0x08080800=> Push Pull (P5M0.3=1, P5M1.3=0)
            #define WizGPIO_P53_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P5.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.3=1)
            #define WizGPIO_P53_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xA0C4070B=> AIN11
//              <0xD7A43004=> Pin Ooption 0 SPID2 (SPIPS1=0, SPIPS0=0)
            #define WizGPIO_P53_AF  0x00000000
//      </e> P5.3 End

//      <e0> P5.4
//      <i> P54: AIN12, SPID3
        #define WizGPIO_P54_EN  0
//          <o0> Mode Assignment
//          <i> Specify P5.4 mode.
//              <0x10100010=> Analog Input Only (P5M0.4=0,P5M1.4=1)(Default)
//              <0x10101010=> Open Drain with Pull-up Resistor (P5M0.4=1, P5M1.4=1)
//              <0x10100000=> Open Drain (P5M0.4=0, P5M1.4=0)
//              <0x10101000=> Push Pull  (P5M0.4=1, P5M1.4=0)
            #define WizGPIO_P54_MODE  0x10100010

//          <o0> Fast Driving Control
//          <i>  P5.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.4=1)
            #define WizGPIO_P54_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD7A43005=> Pin Option 0 SPID3 (SPIPS1=0, SPIPS0=0)
//              <0xA0C4070C=> AIN12
            #define WizGPIO_P54_AF  0x00000000
//      </e> P5.4 End

//      <e0> P5.5
//      <i> P55: AIN13
        #define WizGPIO_P55_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P5.5 mode.
//              <0x20200020=> Analog Input Only (P5M0.5=0,P5M1.5=1)(Default)
//              <0x20202020=> Open Drain with Pull-up Resistor (P5M0.5=1, P5M1.5=1)
//              <0x20200000=> Open Drain (P5M0.5=0, P5M1.5=0)
//              <0x20202000=> Push Pull (P5M0.5=1, P5M1.5=0)
            #define WizGPIO_P55_MODE  0x20200020

//          <o0> Fast Driving Control
//          <i>  P5.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.5=1)
            #define WizGPIO_P55_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xA0C4070D=> AIN13
            #define WizGPIO_P55_AF  0x00000000
//      </e> P5.5 End

//      <e0> P5.6
//      <i> P56: AIN14
        #define WizGPIO_P56_EN  0
//          <o0> Mode Assignment
//          <i> Specify P5.6 mode.
//              <0x40400040=> Analog Input Only (P5M0.6=0, P5M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P5M0.6=1, P5M1.6=1)
//              <0x40400000=> Open Drain (P5M0.6=0, P5M1.6=0)
//              <0x40404000=> Push Pull (P5M0.6=1, P5M1.6=0)
            #define WizGPIO_P56_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P5.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.6=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.6=1)
            #define WizGPIO_P56_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xA0C4070E=> AIN14
            #define WizGPIO_P56_AF  0x00000000
//      </e> P5.6 End

//      <e0> P5.7
//      <i> P57: AD4, TXD2, T2EX, S0MI, SPID3
        #define WizGPIO_P57_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P5.7 mode.
//              <0x80800080=> Analog Input Only (P5M0.7=0, P5M1.7=1)(Default)
//              <0x80808080=> Open Drain with Pull-up Resistor (P5M0.7=1, P5M1.7=1)
//              <0x80800000=> Open Drain (P5M0.7=0, P5M1.7=0)
//              <0x80808000=> Push Pull (P5M0.7=1, P5M1.7=0)
            #define WizGPIO_P57_MODE  0x80800080

//          <o0> Fast Driving Control
//          <i>  P5.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P5FDC.7=0)(Default)
//              <1=> Enable Fast Driving (P5FDC.7=1)
            #define WizGPIO_P57_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A40200=> S0MI (SnMIPS=1)
//              <0xDAA41001=> TXD2 (S2PS0=1)
//              <0xD1A4C001=> T2EX (T2PS1=1, T2PS0=0)
//              <0xEBA4C004=> AD4 (ADLPS1=1, ADLPS0=0)
//              <0xD7A43025=> Pin Option 2 SPID3 (SPIPS1=1, SPIPS0=0)
//              <0xD7A43035=> Pin Option 3 SPID3 (SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P57_AF  0x00000000
//      </e> P5.7 End

#define P5_MODE     (WizGPIO_P50_MODE | WizGPIO_P51_MODE | WizGPIO_P52_MODE | WizGPIO_P53_MODE | WizGPIO_P54_MODE | WizGPIO_P55_MODE | WizGPIO_P56_MODE | WizGPIO_P57_MODE)
#define P5_FDC      (WizGPIO_P50_FDC | (WizGPIO_P51_FDC<<1) | (WizGPIO_P52_FDC<<2) | (WizGPIO_P53_FDC<<3) | (WizGPIO_P54_FDC<<4) | (WizGPIO_P55_FDC<<5) | (WizGPIO_P56_FDC<<6) | (WizGPIO_P57_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Port 5 driving strength.
        #define P5_DRIVEIN_STRENGTH  0

//          <o0> P54 ~ P57
//              <1=> Low Driving Strength (P5DC1=1)
//              <0=> High Driving Strength (P5DC1=0)(Default)
            #define P5DC_1  0

//          <o0> P53 ~ P50
//              <1=> Low Driving Strength (P5DC0=1)
//              <0=> High Driving Strength (P5DC0=0)(Default)
            #define P5DC_0  0
//      </e>
//  </e> Port5 Config End

//  <e0> Port6 Config
//  <i> P60: KBI4, TWI1_SCL, TWI0_SCL, XTAL2, PWM0A, PWM6, nINT2, ECKI, ICKO
//  <i> P61: KBI5, TWI1_SDA, TWI0_SDA, XTAL1, PWM0B, PWM7, nINT3
//  <i> P62: KBI6, TWI1_SDA, AC2NI, PWM6, S0MI, nINT2
//  <i> P63: KBI7, TWI1_SCL, AC2PI, PWM7, S1MI, nINT3
//  <i> P64: AD0, S2CKO, AC2OUT
//  <i> P65: AD1, TWI1_SCL, RXD3, T3EX, SPID2, S3MI
//  <i> P66: AD2, TWI1_SDA, TXD3, T3/T3CKO, S2MI
//  <i> P67: AD3, T2/T2CKO, S1MI, RXD2
    #define WizGPIO_P6_EN  0
//      <e0> P6.0
//      <i> P60: KBI4, TWI1_SCL, TWI0_SCL, XTAL2, PWM0A, PWM6, nINT2, ECKI, ICKO
        #define WizGPIO_P60_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.0 mode.
//              <0x01010001=> Analog Input Only (P6M0.0=0, P6M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P6M0.0=1, P6M1.0=1)
//              <0x01010000=> Open Drain (P6M0.0=0, P6M1.0=0)
//              <0x01010100=> Push Pull (P6M0.0=1, P6M1.0=0)
            #define WizGPIO_P60_MODE  0x01010001

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xC0A1C000=> ICKO
//              <0xC0000001=> ECKI
//              <0xC0000003=> XTAL2
//              <0xD0A40600=> TWI0_SCL (TWIPS1=0, TWIPS0=1)
//              <0xD8A43000=> TWI1_SCL (I2C1PS1=0, I2C1PS0=1)
//              <0xD2A41000=> PWM0A (C0PPS0=1)
//              <0xD5A42000=> PWM6 (C0PPS2=1)
//              <0xD3A4C004=> KBI4 (KBIHPS1=1, KBIHPS0=1)
//              <0xD1C13000=> nINT2 (INT2IS2=1, INT2IS1=0, INT2IS0=1)
            #define WizGPIO_P60_AF  0x00000000
//      </e> P6.0 End

//      <e0> P6.1
//      <i> P61: KBI5, TWI1_SDA, TWI0_SDA, XTAL1, PWM0B, PWM7, nINT3
        #define WizGPIO_P61_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.1 mode.
//              <0x02020002=> Analog Input Only (P6M0.1=0, P6M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P6M0.1=1, P6M1.1=1)
//              <0x02020000=> Open Drain (P6M0.1=0, P6M1.1=0)
//              <0x02020200=> Push Pull (P6M0.1=1, P6M1.1=0)
            #define WizGPIO_P61_MODE  0x02020002

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xC0000002=> XTAL1
//              <0xD0A40601=> TWI0_SDA (TWIPS1=0, TWIPS0=1)
//              <0xD8A43001=> TWI1_SDA (I2C1PS1=0, I2C1PS0=1)
//              <0xD2A41001=> PWM0B (C0PPS0=1)
//              <0xD5A42001=> PWM7 (C0PPS2=1)
//              <0xD3A4C005=> KBI5 (KBIHPS1=1, KBIHPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=1, INT3IS1=0, INT3IS0=1)
            #define WizGPIO_P61_AF  0x00000000
//      </e> P6.1 End

//      <e0> P6.2
//      <i> P62: KBI6, TWI1_SDA, AC2NI, PWM6, S0MI, nINT2
        #define WizGPIO_P62_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.2 mode.
//              <0x04040004=> Analog Input Only (P6M0.2=0, P6M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P6M0.2=1, P6M1.2=1)
//              <0x04040000=> Open Drain (P6M0.2=0, P6M1.2=0)
//              <0x04040400=> Push Pull (P6M0.2=1, P6M1.2=0)
            #define WizGPIO_P62_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P6.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P6FDC.2=1)
            #define WizGPIO_P62_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)r
//              <0xD3A40200=> S0MI (SnMIPS=0)
//              <0xD8A43001=> TWI1_SDA (I2C1PS1=1, I2C1PS0=1)
//              <0xD5A42000=> PWM6 (C0PPS2=0)
//              <0xD3A4C006=> KBI6 (KBIHPS1=1,KBIHPS0=1)
//              <0xD1C13000=> nINT2 (INT2IS2=1, INT2IS1=1, INT2IS0=1)
//              <0xA29F1800=> AC2NI
            #define WizGPIO_P62_AF  0x00000000
//      </e> P6.2 End

//      <e0> P6.3
//      <i> P63: KBI7, TWI1_SCL, AC2PI, PWM7, S1MI, nINT3
        #define WizGPIO_P63_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.3 mode.
//              <0x08080008=> Analog Input Only (P6M0.3=0,P6M1.3=1)(Default)
//              <0x08080808=> Open Drain with Pull-up Resistor (P6M0.3=1, P6M1.3=1)
//              <0x08080000=> Open Drain (P6M0.3=0, P6M1.3=0)
//              <0x08080800=> Push Pull (P6M0.3=1, P6M1.3=0)
            #define WizGPIO_P63_MODE  0x08080008

//          <o0> Fast Driving Control
//          <i>  P6.3 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.3=0)(Default)
//              <1=> Enable Fast Driving (P6FDC.3=1)
            #define WizGPIO_P63_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A40201=> S1MI (SnMIPS=0)
//              <0xD8A43000=> TWI1_SCL (I2C1PS1=1, I2C1PS0=1)
//              <0xD5A42001=> PWM7 (C0PPS2=0)
//              <0xD3A4C007=> KBI7 (KBIHPS1=1, KBIHPS0=1)
//              <0xD2C10E00=> nINT3 (INT3IS2=1, INT3IS1=1, INT3IS0=1)
//              <0xAC200010=> AC2PI
            #define WizGPIO_P63_AF  0x00000000
//      </e> P6.3 End

//      <e0> P6.4
//      <i> P64: AD0, S2CKO, AC2OUT
        #define WizGPIO_P64_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.4 mode.
//              <0x10100010=> Analog Input Only (P6M0.4=0, P6M1.4=1)(Default)
//              <0x10101010=> Open Drain with Pull-up Resistor (P6M0.4=1, P6M1.4=1)
//              <0x10100000=> Open Drain (P6M0.4=0, P6M1.4=0)
//              <0x10101000=> Push Pull (P6M0.4=1, P6M1.4=0)
            #define WizGPIO_P64_MODE  0x10100010

//          <o0> Fast Driving Control
//          <i>  P6.4 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.4=0)(Default)
//              <1=> Enable Fast Driving (P6FDC.4=1)
            #define WizGPIO_P64_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD39C0200=> S2CKO
//              <0xEBA4C000=> AD0 (ADLPS1=1, ADLPS0=0)
//              <0xABA40200=> AC2OUT
            #define WizGPIO_P64_AF  0x00000000
//      </e> P6.4 End

//      <e0> P6.5
//      <i> P65: AD1, TWI1_SCL, RXD3, T3EX, SPID2, S3MI
        #define WizGPIO_P65_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.5 mode.
//              <0x20200020=> Analog Input Only (P6M0.5=0, P6M1.5=1)(Default)
//              <0x20202020=> Open Drain with Pull-up Resistor (P6M0.5=1, P6M1.5=1)
//              <0x20200000=> Open Drain (P6M0.5=0, P6M1.5=0)
//              <0x20202000=> Push Pull (P6M0.5=1, P6M1.5=0)
            #define WizGPIO_P65_MODE  0x20200020

//          <o0> Fast Driving Control
//          <i>  P6.5 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.5=0)(Default)
//              <1=> Enable Fast Driving (P6FDC.5=1)
            #define WizGPIO_P65_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xDAA44000=> RXD3 (S3PS0=1)
//              <0xD3A40203=> S3MI (SnMIPS=1)
//              <0xD8A43000=> TWI1_SCL (I2C1PS1=1, I2C1PS0=0)
//              <0xD5A40301=> T3EX (T3PS1=1, T3PS0=1)
//              <0xEBA4C001=> AD1 (ADLPS1=1, ADLPS0=0)
//              <0xD7A43024=> Pin Ooption 2 SPID2 (SPIPS1=1, SPIPS0=0)
//              <0xD7A43034=> Pin Ooption 3 SPID2 (SPIPS1=1, SPIPS0=1)
            #define WizGPIO_P65_AF  0x00000000
//      </e> P6.5 End

//      <e0> P6.6
//      <i> P66: AD2, TWI1_SDA, TXD3, T3/T3CKO, S2MI
        #define WizGPIO_P66_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.6 mode.
//              <0x40400040=> Analog Input Only (P6M0.6=0, P6M1.6=1)(Default)
//              <0x40404040=> Open Drain with Pull-up Resistor (P6M0.6=1, P6M1.6=1)
//              <0x40400000=> Open Drain (P6M0.6=0, P6M1.6=0)
//              <0x40404000=> Push Pull (P6M0.6=1, P6M1.6=0)
            #define WizGPIO_P66_MODE  0x40400040

//          <o0> Fast Driving Control
//          <i>  P6.6 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.6=0)(Default)
//              <1=> Enable Fast Driving  (P6FDC.6=1)
            #define WizGPIO_P66_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A40202=> S2MI (SnMIPS=1)
//              <0xDAA44001=> TXD3 (S3PS0=1)
//              <0xD8A43001=> TWI1_SDA (I2C1PS1=1, I2C1PS0=0)
//              <0xD5A40300=> T3 (T3PS1=1, T3PS0=1)
//              <0xD5A40300=> T3CKO (T3PS1=1, T3PS0=1)
//              <0xEBA4C002=> AD2 (ADLPS1=1, ADLPS0=0)
            #define WizGPIO_P66_AF  0x00000000
//      </e> P6.6 End

//      <e0> P6.7
//      <i> P67: AD3, T2/T2CKO, S1MI, RXD2
        #define WizGPIO_P67_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P6.7 mode.
//              <0x80800080=> Analog Input Only (P6M0.7=0, P6M1.7=1)(Default)
//              <0x80808080=> Open Drain with Pull-up Resistor (P6M0.7=1, P6M1.7=1)
//              <0x80800000=> Open Drain (P6M0.7=0, P6M1.7=0)
//              <0x80808000=> Push Pull (P6M0.7=1, P6M1.7=0)
            #define WizGPIO_P67_MODE  0x80800080

//          <o0> Fast Driving Control
//          <i>  P6.7 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P6FDC.7=0)(Default)
//              <1=> Enable Fast Driving  (P6FDC.7=1)
            #define WizGPIO_P67_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD3A40201=> S1MI (SnMIPS=1)
//              <0xDAA41000=> RXD2 (S2PS0=1)
//              <0xD1A4C000=> T2 (T2PS1=1, T2PS0=0)
//              <0xD1A4C000=> T2CKO (T2PS1=1, T2PS0=0)
//              <0xEBA4C003=> AD3 (ADLPS1=1, ADLPS0=0)
            #define WizGPIO_P67_AF  0x00000000
//      </e> P6.7 End

#define P6_MODE   (WizGPIO_P60_MODE | WizGPIO_P61_MODE | WizGPIO_P62_MODE | WizGPIO_P63_MODE | WizGPIO_P64_MODE | WizGPIO_P66_MODE | WizGPIO_P66_MODE | WizGPIO_P67_MODE)
#define P6_FDC    ((WizGPIO_P62_FDC<<2) | (WizGPIO_P63_FDC<<3) | (WizGPIO_P64_FDC<<4) | (WizGPIO_P65_FDC<<5) | (WizGPIO_P66_FDC<<6) | (WizGPIO_P67_FDC<<7))

//      <e0> Driving Strength Control
//      <i>  Port 6 driving strength.
        #define P6_DRIVEIN_STRENGTH  0

//          <o0> P64 ~ P67
//              <1=> Low Driving Strength (P6DC1=1)
//              <0=> High Driving Strength(P6DC1=0)(Default)
            #define P6DC_1  0

//          <o0> P62 ~ P63
//              <1=> Low Driving Strength (P6DC0=1)
//              <0=> High Driving Strength(P6DC0=0)(Default)
            #define P6DC_0  0
//      </e>

//      <e0> GPIO Port Protection
//      <i>  Users can activate writing protection of Port6 using this option.
//      <i>  Then, only PageP access can modify.
        #define MG82F6D64_GPIO_Port6_Protection  0
//          <o0> Port 6
//          <i>  Enable, only PageP access can modify P6.
//          <i>  Modifications in Page 0~F are not allowed.
//              <0=> Disable (P6CTL=0)(Default)
//              <1=> Enable  (P6CTL=1)
            #define     SPCON0_P6CTL  0
//      </e>
//  </e> Port6 Config End

//  <e0> Port7 Config
//  <i> P70: AD5, RXD0, TXD1, T4/T4CKO, S2MI
//  <i> P71: AD6, TXD0, RXD1, T4EX, S3MI
//  <i> P72: AD7, S3CKO, AC1OUT, C0CKO, BM1OUT, T4/T4CKO
    #define WizGPIO_P7_EN  0
//      <e0> P7.0
//      <i> P70: AD5, RXD0, TXD1, T4/T4CKO, S2MI
        #define WizGPIO_P70_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P7.0 mode.
//              <0x01010001=> Analog Input Only (P7M0.0=0, P7M1.0=1)(Default)
//              <0x01010101=> Open Drain with Pull-up Resistor (P7M0.0=1, P7M1.0=1)
//              <0x01010000=> Open Drain (P7M0.0=0, P7M1.0=0)
//              <0x01010100=> Push Pull (P7M0.0=1, P7M1.0=0)
            #define WizGPIO_P70_MODE  0x01010001

//          <o0> Fast Driving Control
//          <i>  P7.0 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P7FDC.0=0)(Default)
//              <1=> Enable Fast Driving (P7FDC.0=1)
            #define WizGPIO_P70_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40800=> RXD0 (S0PS1=1, S0PS0=1)
//              <0xD6A40301=> TXD1 (S1PS1=0, S1PS0=1)
//              <0xD3A40202=> S2MI (SnMIPS=0)
//              <0xDAA40300=> T4 (T4PS1=0, T4PS0=0)
//              <0xDAA40300=> T4CKO (T4PS1=0, T4PS0=0)
//              <0xEBA4C005=> AD5 (ADLPS1=1, ADLPS0=0)
            #define WizGPIO_P70_AF  0x00000000
//      </e> P7.0 End

//      <e0> P7.1
//      <i> P71: AD6, TXD0, RXD1, T4EX, S3MI
        #define WizGPIO_P71_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P7.1 mode.
//              <0x02020002=> Analog Input Only (P7M0.1=0, P7M1.1=1)(Default)
//              <0x02020202=> Open Drain with Pull-up Resistor (P7M0.1=1, P7M1.1=1)
//              <0x02020000=> Open Drain (P7M0.1=0, P7M1.1=0)
//              <0x02020200=> Push Pull (P7M0.1=1, P7M1.1=0)
            #define WizGPIO_P71_MODE  0x02020002

//          <o0> Fast Driving Control
//          <i>  P7.1 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P7FDC.1=0)(Default)
//              <1=> Enable Fast Driving (P7FDC.1=1)
            #define WizGPIO_P71_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD0A40801=> TXD0 (S0PS1=1, S0PS0=1)
//              <0xD6A40300=> RXD1 (S1PS1=0, S1PS0=1)
//              <0xD3A40203=> S3MI (SnMIPS=0)
//              <0xDAA40301=> T4EX (T4PS1=0, T4PS0=0)
//              <0xEBA4C006=> AD6 (ADLPS1=1, ADLPS0=0)
            #define WizGPIO_P71_AF  0x00000000
//      </e> P7.1 End

//      <e0> P7.2
//      <i> P72: AD7, S3CKO, AC1OUT, C0CKO, BM1OUT, T4/T4CKO
        #define WizGPIO_P72_EN  0
//          <o0> Mode Assignment
//          <i>  Specify P7.2 mode.
//              <0x04040004=> Analog Input Only (P7M0.2=0, P7M1.2=1)(Default)
//              <0x04040404=> Open Drain with Pull-up Resistor (P7M0.2=1, P7M1.2=1)
//              <0x04040000=> Open Drain (P7M0.2=0, P7M1.2=0)
//              <0x04040400=> Push Pull (P7M0.2=1, P7M1.2=0)
            #define WizGPIO_P72_MODE  0x04040004

//          <o0> Fast Driving Control
//          <i>  P7.2 fast/slow driving control set-up.
//              <0=> Disable Fast Driving (P7FDC.2=0)(Default)
//              <1=> Enable Fast Driving (P7FDC.2=1)
            #define WizGPIO_P72_FDC  0

//          <o0> Alternate Function
//              <0x00000000=> GPIO (Default)
//              <0xD49C0200=> S3CKO
//              <0xD2A40100=> C0CKO (C0COPS=1)
//              <0xDAA40300=> T4 (T4PS1=1, T4PS0=0)
//              <0xDAA40300=> T4CKO (T4PS1=1, T4PS0=0)
//              <0xD4A40300=> BM1OUT (BM1OE1=1, BM1OE0=1)
//              <0xEBA4C007=> AD7 (ADLPS1=1, ADLPS0=0)
//              <0xD1A40800=> AC1OUT
            #define WizGPIO_P72_AF  0x00000000
//      </e> P7.2 End

#define P7_MODE     (WizGPIO_P70_MODE | WizGPIO_P71_MODE | WizGPIO_P72_MODE)
#define P7_FDC      (WizGPIO_P70_FDC | (WizGPIO_P71_FDC<<1) | (WizGPIO_P72_FDC<<2))

//      <e0> Driving Strength Control
//      <i>  Port 7 driving strength.
        #define P7_DRIVEIN_STRENGTH  0

//          <o0> P72 ~ P70
//              <1=> Low Driving Strength (P7DC0=1)
//              <0=> High Driving Strength (P7DC0=0)(Default)
            #define P7DC_0  0
//      </e>
//  </e> Port7 Config End

//</e> General Purposes Input Output(GPIO) END


#define WizDef_OCD          0xDF4C0100  //@C
#define WizDef_OCD_SDA      0xFFFFFFFF  //P45 @Pin
#define WizDef_OCD_SCL      0xFFFFFFFF  //P44 @Pin
#define WizDef_RST          0xDF4C0200  //P47 @Pin @C
#define WizDef_BEEP         0xC0A43000  //P44 @Pin @C_rev
#define WizDef_RTCKO        0xC0BE4000  //P45 @Pin @C_rev
#define WizDef_ICKO         0xC0A1C000  //P60 @Pin @C_rev
#define WizDef_ECKI         0xC0000001  //P60 @Pin @C_rev
#define WizDef_XTAL1        0xC0000002  //P61 @Pin @C_rev
#define WizDef_XTAL2        0xC0000003  //P60 @Pin @C_rev

#define WizDef_RXD0         0xD0A40800  //P30, P44, P31, P70 @AF @Pin @C
#define WizDef_TXD0         0xD0A40801  //P31, P45, P30, P71 @AF @Pin @C
#define WizDef_S0CKO        0xD3A40100  //P47, P44 @AF @Pin @C

#define WizDef_RXD1         0xD6A40300  //P12, P71, P20, P34 @AF @Pin @C
#define WizDef_TXD1         0xD6A40301  //P13, P70, P21, P35 @AF @Pin @C
#define WizDef_S1CKO        0xD5A40400  //P46, P45 @AF @Pin @C

#define WizDef_RXD2         0xDAA41000  //P32, P67 @AF @Pin @C
#define WizDef_TXD2         0xDAA41001  //P33, P57 @AF @Pin @C
#define WizDef_S2CKO        0xD39C0200  //P64 @Pin @C_rev

#define WizDef_RXD3         0xDAA44000  //P36, P65 @AF @Pin @C
#define WizDef_TXD3         0xDAA44001  //P37, P66 @AF @Pin @C
#define WizDef_S3CKO        0xD49C0200  //P72 @Pin @C_rev

#define WizDef_S0MI         0xD3A40200  //P62, P57 @AF @Pin @C
#define WizDef_S1MI         0xD3A40201  //P63, P67 @AF @Pin @C
#define WizDef_S2MI         0xD3A40202  //P70, P66 @AF @Pin @C
#define WizDef_S3MI         0xD3A40203  //P71, P65 @AF @Pin @C

#define WizDef_TWI0_SCL     0xD0A40600  //P40, P60, P31, P25 @AF @Pin @C
#define WizDef_TWI0_SDA     0xD0A40601  //P41, P61, P30, P23 @AF @Pin @C
#define WizDef_TWI1_SCL     0xD8A43000  //P42, P60, P65, P63 @AF @Pin @C
#define WizDef_TWI1_SDA     0xD8A43001  //P43, P61, P66, P62 @AF @Pin @C

#define WizDef_PCA0_CEX1    0xD2A40800  //P23, P33 @AF @Pin @C
#define WizDef_PCA0_CEX3    0xD2A40801  //P25, P34 @AF @Pin @C
#define WizDef_PCA0_CEX5    0xD2A40802  //P27, P35 @AF @Pin @C
#define WizDef_PCA0_CEX0    0xD2A40400  //P22, P40 @AF @Pin @C
#define WizDef_PCA0_CEX2    0xD2A40401  //P24, P41 @AF @Pin @C
#define WizDef_PCA0_CEX4    0xD2A40402  //P26, P32 @AF @Pin @C
#define WizDef_PCA0_ECI     0xD2A40200  //P21, P46 @AF @Pin @C
#define WizDef_PCA0_C0CKO   0xD2A40100  //P47, P72 @AF @Pin @C

#define WizDef_PWM0A        0xD2A41000  //P36, P60 @AF @Pin
#define WizDef_PWM0B        0xD2A41001  //P37, P61 @AF @Pin
#define WizDef_PWM2A        0xD2A42000  //P40, P34 @AF @Pin
#define WizDef_PWM2B        0xD2A42001  //P41, P35 @AF @Pin
#define WizDef_PWM6         0xD5A42000  //P62, P60 @AF @Pin
#define WizDef_PWM7         0xD5A42001  //P63, P61 @AF @Pin

#define WizDef_T0           0xD0A4C000  //P34, P44, P46, P17 @AF @Pin @C
#define WizDef_T0CKO        0xD0A4C000  //P34, P44, P46, P17 @AF @Pin @C
#define WizDef_T0EX         0xFFFFFFFF  //NC
#define WizDef_T0COA        0xD9A41000  //P40 @AF @Pin @C_rev
#define WizDef_T0COB        0xD9A42000  //P43 @AF @Pin @C_rev

#define WizDef_T1           0xD1A43000  //P35, P45, P36, P37 @AF @Pin @C
#define WizDef_T1CKO        0xD1A43000  //P35, P45, P36, P37 @AF @Pin @C
#define WizDef_T1EX         0xFFFFFFFF  //NC

#define WizDef_T2           0xD1A4C000  //P10, P32, P67, P45 @AF @Pin @C
#define WizDef_T2CKO        0xD1A4C000  //P10, P32, P67, P45 @AF @Pin @C
#define WizDef_T2EX         0xD1A4C001  //P11, P33, P57, P44 @AF @Pin @C
#define WizDef_T2EXI        0xFFFFFFFF  //Timer 2 internal signal

#define WizDef_T3           0xD5A40300  //P46, P33, P21, P66 @AF @Pin @C
#define WizDef_T3CKO        0xD5A40300  //P46, P33, P21, P66 @AF @Pin @C
#define WizDef_T3EX         0xD5A40301  //P00, P32, P20, P65 @AF @Pin @C
#define WizDef_T3EXI        0xFFFFFFFF  //Timer 3 internal signal

#define WizDef_T4           0xDAA40300  //P70, P37, P72, P36 @AF @Pin @C
#define WizDef_T4CKO        0xDAA40300  //P70, P37, P72, P36 @AF @Pin @C
#define WizDef_T4EX         0xDAA40301  //P71, P36, P50, P37 @AF @Pin @C

#define WizDef_T5           0xD1000005  //P34 @Pin
#define WizDef_T5CKO        0xFFFFFFFF  //NC
#define WizDef_T5EX         0xFFFFFFFF  //NC

#define WizDef_T6           0xD1000006  //P35 @Pin
#define WizDef_T6CKO        0xFFFFFFFF  //NC
#define WizDef_T6EX         0xFFFFFFFF  //NC

#define WizDef_KBI0         0xD3A43000  //P10, P00, P20, P40 @AF @Pin @C
#define WizDef_KBI1         0xD3A43001  //P11, P01, P21, P41 @AF @Pin @C
#define WizDef_KBI2         0xD3A43002  //P12, P02, P22, P42 @AF @Pin @C
#define WizDef_KBI3         0xD3A43003  //P13, P03, P23, P43 @AF @Pin @C
#define WizDef_KBI4         0xD3A4C004  //P14, P04, P24, P60 @AF @Pin @C
#define WizDef_KBI5         0xD3A4C005  //P15, P05, P25, P61 @AF @Pin @C
#define WizDef_KBI6         0xD3A4C006  //P16, P06, P26, P62 @AF @Pin @C
#define WizDef_KBI7         0xD3A4C007  //P17, P07, P27, P63 @AF @Pin @C

#define WizDef_nINT0        0xD0C13000  //P32, P30, P34, P40, P10, P14, P36, P05 @AF @Pin @C
#define WizDef_nINT1        0xD0C1C000  //P33, P31, P35, P41, P45, P15, P37, P07 @AF @Pin @C
#define WizDef_nINT2        0xD1C13000  //P43, P20, P11, P25, P44, P60, P01, P62 @AF @Pin @C
#define WizDef_nINT3        0xD2C10E00  //P42, P21, P00, P16, P02, P61, P06, P63 @AF @Pin @C

#define WizDef_BM0OUT       0xD4A40C00  //P42, P30, P50 @AF @Pin @C
#define WizDef_BM1OUT       0xD4A40300  //P43, P31, P72 @AF @Pin @C

#define WizDef_EMB_AD0      0xEBA4C000  //P00, P20, P64 @AF @Pin @C
#define WizDef_EMB_AD1      0xEBA4C001  //P01, P21, P65 @AF @Pin @C
#define WizDef_EMB_AD2      0xEBA4C002  //P02, P22, P66 @AF @Pin @C
#define WizDef_EMB_AD3      0xEBA4C003  //P03, P23, P67 @AF @Pin @C
#define WizDef_EMB_AD4      0xEBA4C004  //P04, P24, P57 @AF @Pin @C
#define WizDef_EMB_AD5      0xEBA4C005  //P05, P25, P70 @AF @Pin @C
#define WizDef_EMB_AD6      0xEBA4C006  //P06, P26, P71 @AF @Pin @C
#define WizDef_EMB_AD7      0xEBA4C007  //P07, P27, P72 @AF @Pin @C
#define WizDef_EMB_nWR      0xEBA40800  //P36, P37 @AF @Pin @C
#define WizDef_EMB_nRD      0xEBA40801  //P37, P36 @AF @Pin @C

#define WizDef_0_nSS        0xD7A43000  //P14 @AF @Pin @C
#define WizDef_0_MOSI       0xD7A43001  //P15 (SPID0) @AF @Pin @C
#define WizDef_0_MISO       0xD7A43002  //P16 (SPID1) @AF @Pin @C
#define WizDef_0_SPICLK     0xD7A43003  //P17 @AF @Pin @C
#define WizDef_0_SPID2      0xD7A43004  //P53 @AF @Pin @C
#define WizDef_0_SPID3      0xD7A43005  //P54 @AF @Pin @C

#define WizDef_1_nSS        0xD7A43010  //P43 @AF @C
#define WizDef_1_MOSI       0xD7A43011  //P42 (SPID0) @AF @C
#define WizDef_1_MISO       0xD7A43012  //P41 (SPID1) @AF @C
#define WizDef_1_SPICLK     0xD7A43013  //P40 @AF @C
#define WizDef_1_SPID2      0xD7A43014  //P36 @AF @C
#define WizDef_1_SPID3      0xD7A43015  //P37 @AF @C

#define WizDef_2_nSS        0xD7A43020  //P40 @AF @C
#define WizDef_2_MOSI       0xD7A43021  //P41 (SPID0) @AF @C
#define WizDef_2_MISO       0xD7A43022  //P42 (SPID1) @AF @C
#define WizDef_2_SPICLK     0xD7A43023  //P43 @AF @C
#define WizDef_2_SPID2      0xD7A43024  //P65 @AF @C
#define WizDef_2_SPID3      0xD7A43025  //P57 @AF @C

#define WizDef_3_nSS        0xD7A43030  //P43 @AF @C
#define WizDef_3_MOSI       0xD7A43031  //P41 (SPID0) @AF @C
#define WizDef_3_MISO       0xD7A43032  //P42 (SPID1) @AF @C
#define WizDef_3_SPICLK     0xD7A43033  //P40 @AF @C
#define WizDef_3_SPID2      0xD7A43034  //P65 @AF @C
#define WizDef_3_SPID3      0xD7A43035  //P57 @AF @C

#define WizDef_AC0NI        0xA09FF000  //P01 @Pin @C_rev
#define WizDef_AC0PI        0xFFFFFFFF  //NC
#define WizDef_AC0PI0       0xA09F0300  //P02 @Pin @C_rev
#define WizDef_AC0PI1       0xA09F0301  //P03 @Pin @C_rev
#define WizDef_AC0PI2       0xA09F0302  //P04 @Pin @C_rev
#define WizDef_AC0PI3       0xA09F0303  //P05 @Pin @C_rev
#define WizDef_AC0OUT       0xD1A40200  //P00 @AF @Pin @C_rev

#define WizDef_AC1NI        0xA19F1800  //P06 @Pin @C_rev
#define WizDef_AC1PI        0xAC100010  //P07 @Pin @C_rev
#define WizDef_AC1OUT       0xD1A40800  //P72 @AF @Pin @C_rev

#define WizDef_AC2NI        0xA29F1800  //P62 @Pin @C_rev
#define WizDef_AC2PI        0xAC200010  //P63 @Pin @C_rev
#define WizDef_AC2OUT       0xABA40200  //P64 @AF @C_rev

#define WizDef_AIN0         0xA0C40700  //P10 @Pin @C_rev
#define WizDef_AIN1         0xA0C40701  //P11 @Pin @C_rev
#define WizDef_AIN2         0xA0C40702  //P12 @Pin @C_rev
#define WizDef_AIN3         0xA0C40703  //P13 @Pin @C_rev
#define WizDef_AIN4         0xA0C40704  //P14 @Pin @C_rev
#define WizDef_AIN5         0xA0C40705  //P15 @Pin @C_rev
#define WizDef_AIN6         0xA0C40706  //P16 @Pin @C_rev
#define WizDef_AIN7         0xA0C40707  //P17 @Pin @C_rev
#define WizDef_AIN8         0xA0C40708  //P20 @Pin @C_rev
#define WizDef_AIN9         0xA0C40709  //P21 @Pin @C_rev
#define WizDef_AIN10        0xA0C4070A  //P52 @Pin @C_rev
#define WizDef_AIN11        0xA0C4070B  //P53 @Pin @C_rev
#define WizDef_AIN12        0xA0C4070C  //P54 @Pin @C_rev
#define WizDef_AIN13        0xA0C4070D  //P55 @Pin @C_rev
#define WizDef_AIN14        0xA0C4070E  //P56 @Pin @C_rev
#define WizDef_AIN15        0xA0C4070F  //P51 @Pin @C_rev
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize System Clock
//<i> Check this term to initialize system clock.
//<i> Date: 2020/11/23     Version: 1.00
#define MG82F6D64_CLK_WIZARD 0

//  <o0> Select Config Mode
//  <i> This only changes the parameters of "__DRV_CLK_SystemClock_Wizard_Init();"
//  <i> System clock 50MHz max. CPU clock 36MHz max.
//      <1=> Easy Mode
//      <2=> Advanced Mode
    #define DRV_CLK_Wizard_Mode 1

//  <e0> Easy Mode
//  <i> The setting only change the parameter of "__DRV_CLK_SystemClock_Wizard_Init ();"
    #define DRV_CLK_Wizard_Easy_Check 1

//      <o0>  Select System Clock and CPU Clock
//      <i> Easy select clock by "__DRV_CLK_Easy_Select(__SELECT__);"
//          <0x80020010=> PCA CKMIX16=NA, MCKDO=12MHz; SYSCLK=12MHz, CPUCLK=12MHz(Default)
//          <0x80020450=> PCA CKMIX16=96MHz, MCKDO=24MHz; SYSCLK=24MHz, CPUCLK=24MHz
//          <0x80020858=> PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=16MHz
//          <0xA0020850=> PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=32MHz
//          <0x80020C58=> PCA CKMIX16=96MHz, MCKDO=48MHz; SYSCLK=48MHz, CPUCLK=24MHz
//          <0xA1020450=> PCA CKMIX16=144MHz, MCKDO=36MHz; SYSCLK=36MHz, CPUCLK=36MHz
//          <0x81020858=> PCA CKMIX16=144MHz, MCKDO=48MHz; SYSCLK=48MHz, CPUCLK=24MHz
//          <0x80021010=> PCA CKMIX16=NA, MCKDO=11.06MHz; SYSCLK=11.06MHz, CPUCLK=11.06MHz
//          <0x80021450=> PCA CKMIX16=88.47MHz, MCKDO=22.12MHz; SYSCLK=22.12MHz, CPUCLK=22.12MHz
//          <0x80021858=> PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=14.75MHz
//          <0xA0021850=> PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=29.49MHz
//          <0x80021C58=> PCA CKMIX16=88.47MHz, MCKDO=44.24MHz; SYSCLK=44.24MHz, CPUCLK=22.12MHz
//          <0xA1021450=> PCA CKMIX16=132.71MHz, MCKDO=33.18MHz; SYSCLK=33.18MHz, CPUCLK=33.18MHz
//          <0x81021858=> PCA CKMIX16=132.71MHz, MCKDO=44.24MHz; SYSCLK=44.24MHz, CPUCLK=22.12MHz
//          <0x80022010=> PCA CKMIX16=NA, MCKDO=XTAL; SYSCLK=XTAL, CPUCLK=XTAL
//          <0x00023010=> PCA CKMIX16=NA, MCKDO=XTAL(32768); SYSCLK=CPUCLK=XTAL(32768)
//          <0x00024010=> PCA CKMIX16=NA, MCKDO=XTAL(32768)(Low Gain); SYSCLK=CPUCLK=XTAL(32768)(Low Gain)
//          <0x00025010=> PCA CKMIX16=NA, MCKDO=ILRCO(32KHz); SYSCLK=CPUCLK=ILRCO(32KHz)
//          <0x80026010=> PCA CKMIX16=NA, MCKDO=ECKI; SYSCLK=ECKI, CPUCLK=ECKI
        #define DRV_CLK_Easy_Config 0x80020010
//  </e> Easy Mode

//  <e0> Advanced Mode
//  <i> The setting only change the parameter of "__DRV_CLK_SystemClock_Wizard_Init ();"
    #define DRV_CLK_Wizard_Advanced_Check 0

//      <o0.12..15> OSCin Clock Source Select
//      <i> Select OSCin by "__DRV_CLK_OSCin_Select(__SELECT__);"
//          <0=> OSCin = IHRCO 12MHz (OSCS1=0, OSCS0=0, AFS=0)(Default)
//          <1=> OSCin = IHRCO 11.059MHz (OSCS1=0, OSCS0=0, AFS=1)
//          <2=> OSCin = XTAL Medium Gain for 2MHz~25MHz (OSCS1=0, OSCS0=1, XTGS1=0, XTGS0=1)
//          <3=> OSCin = XTAL Low gain for 32.768KHz (OSCS1=0, OSCS0=1, XTGS1=0, XTGS0=0)
//          <4=> OSCin = XTAL Lower gain for 32.768KHz (OSCS1=0, OSCS0=1, XTGS1=1, XTGS0=0)
//          <5=> OSCin = ILRCO (32KHz)(OSCS1=1, OSCS0=0)
//          <6=> OSCin = ECKI: External clock input (P6.0)(OSCS1=1, OSCS0=1)
//      <e1.0> OSCin XTAL sub menu
//          <o1.5..6> XTAL Missing clock interrupt/reset.
//          <i> Select XTAL MCDF interrupt by "__DRV_CLK_XTAL_MCDF_IT_Cmd(__STATE__);"
//          <i> Select XTAL MCDF reset by "__DRV_CLK_XTAL_MCDF_RST_Cmd(__SELECT__);"
//              <0=> Disable missing clock detection. (MCDRE=0, MCDFIE=0)
//              <1=> Enable MCDF interrupt. (MCDRE=0, MCDFIE=1)
//              <3=> Enable MCDF interrupt & reset. (MCDRE=1, MCDFIE=1)(Default)
//          </e>

//      <e0.6> Enable Clock Multiplier (PLL)
//      <i> Enable/Disable by "__DRV_CLK_PLL_Cmd(__STATE__);"
//      <i> DT reference: CKCON0.6(ENCKM)
//          <o0.4..5> Multiplier Clock Input (5~6.5MHZ)
//          <i> Config PLL by call "__DRV_CLK_PLL_Config(__SELECT__, __MODE__);"
//              <0=> OSCin = 5~6.5MHz (CKMIS1=0, CKMIS0=0)
//              <1=> OSCin = 10~13MHz (CKMIS1=0, CKMIS0=1)(Default)
//              <2=> OSCin = 20~26MHz (CKMIS1=1, CKMIS0=0)
//          <o0.24> Clock Multiplier Mode
//          <i> Config PLL by call "__DRV_CLK_PLL_Config(__SELECT__, __MODE__);"
//              <0=> Set CKM to CKMI X8 output mode. (96MHz for PCA)(CKMS0=0)(Default)
//              <1=> Set CKM to CKMI X12 output mode. (144MHz for PCA)(CKMS1=0)
//          <o0.10..11> Multiplier Clock Output Select. (MCK)
//          <i> Select MCK by "__DRV_CLK_MCK_Select(__SELECT__);"
//              <0=> MCK = OSCin (MCKS1=0, MCKS0=0)(Default)
//              <1=> MCK = 24MHz, To PCA = 96MHz (MCKS1=0, MCKS0=1)
//              <2=> MCK = 32MHz, To PCA = 96MHz (MCKS1=1, MCKS0=0)
//              <3=> MCK = 48MHz, To PCA = 96MHz (MCKS1=1, MCKS0=1)
//              <1=> MCK = 36MHz, To PCA = 144MHz (MCKS1=0, MCKS0=1)
//              <2=> MCK = 48MHz, To PCA = 144MHz (MCKS1=1, MCKS0=0)
//              <3=> MCK = 72MHz, To PCA = 144MHz (MCKS1=1, MCKS0=1)
//              <1=> MCK = 22.118MHz, To PCA = 88.4736MHz (MCKS1=0, MCKS0=1)
//              <2=> MCK = 29.491MHz, To PCA = 88.4736MHz (MCKS1=1, MCKS0=0)
//              <3=> MCK = 44.236MHz, To PCA = 88.4736MHz (MCKS1=1, MCKS0=1)
//              <1=> MCK = 33.177MHz, To PCA = 132.7104MHz (MCKS1=0, MCKS0=1)
//              <2=> MCK = 44.236MHz, To PCA = 132.7104MHz (MCKS1=1, MCKS0=0)
//              <3=> MCK = 66.354MHz, To PCA = 132.7104MHz (MCKS1=1, MCKS0=1)
//      </e> Enable Clock Multiplier (PLL)

//      <o0.18..19> MCK Divider Output Select. (MCKDO)
//      <i> Select MCKDO by "__DRV_CLK_MCKDO_Select(__SELECT__);"
//          <0=> MCKDO = MCK/1 (MCKD1=0, MCKD0=0)(Default)
//          <1=> MCKDO = MCK/2 (MCKD1=0, MCKD0=1)
//          <2=> MCKDO = MCK/4 (MCKD1=1, MCKD0=0)
//          <3=> MCKDO = MCK/8 (MCKD1=1, MCKD0=1)

//      <o0.0..2> System Clock Select. (SYSCLK)(50MHz Max.)
//      <i> Select SYSCLK by "__DRV_CLK_SYSCLK_Select(__SELECT__);"
//          <0=> SYSCLK = MCKDO/1 (SCKS2=0, SCKS1=0, SCKS0=0)(Default)
//          <1=> SYSCLK = MCKDO/2 (SCKS2=0, SCKS1=0, SCKS0=1)
//          <2=> SYSCLK = MCKDO/4 (SCKS2=0, SCKS1=1, SCKS0=0)
//          <3=> SYSCLK = MCKDO/8 (SCKS2=0, SCKS1=1, SCKS0=1)
//          <4=> SYSCLK = MCKDO/16 (SCKS2=1, SCKS1=0, SCKS0=0)
//          <5=> SYSCLK = MCKDO/32 (SCKS2=1, SCKS1=0, SCKS0=1)
//          <6=> SYSCLK = MCKDO/64 (SCKS2=1, SCKS1=1, SCKS0=0)
//          <7=> SYSCLK = MCKDO/128 (SCKS2=1, SCKS1=1, SCKS0=1)

//      <o0.3> CPU Clock Select. (CPUCLK)(36MHz Max.)
//      <i> Select CPUCLK by "__DRV_CLK_CPUCLK_Select(__SELECT__);"
//          <0=> CPUCLK = SYSCLK/1 (CCKS=0)(Default)
//          <1=> CPUCLK = SYSCLK/2 (CCKS=1)

//      <o0.29..31> CPU Clock Range Select (0~36MHz)
//      <i> Select CPUCLK range "__DRV_CLK_CPUCLK_Range_Select(__SELECT__);"
//          <5=> CPUCLK is faster than 25MHz (HSE=1, HSE1=1)
//          <4=> CPUCLK is between 25MHz~6MHz (HSE=1, HSE1=0)(Default)
//          <0=> CPUCLK equal or slower than 6MHz (HSE=0, HSE1=0)

//      <o0.21> MCU Power Down Wakeup Select.
//      <i> Select CPUCLK range "__DRV_CLK_Wakeup_Select(__SELECT__);"
//          <0=> Power down normal wakeup. (120us)(FWKP=0)(Default)
//          <1=> Power down fast wakeup. (30us)(FWKP=1)
        #define DRV_CLK_Advanced_Config 0x80020010
        #define DRV_CLK_Advanced_MCD 0x60
//  </e>    Advanced Mode End

//<o0.6..7> P60(ICKO) Alternate Function Select
//<i> Select P60 Function by "__DRV_CLK_P60Mux_Select(__SELECT__);"
//  <0=> P60 is normal GPIO (P60OC1=0, P60OC0=0)(Default)
//  <1=> P60 = MCK/1 output (P60OC1=0, P60OC0=1)
//  <2=> P60 = MCK/2 output (P60OC1=1, P60OC0=0)
//  <3=> P60 = MCK/4 output (P60OC1=1, P60OC0=1)
//<q0.5> P60 Fast Driving Enable/Disable
//<i> Enable P60 Fast Driving by "__DRV_CLK_P60FastDrive_Cmd(__STATE__);""
#define DRV_CLK_Wizard_AUXR0_SEL 0x00

//</e> Initialize System Clock End

#if (MG82F6D64_CLK_WIZARD==1)
    #if (DRV_CLK_Wizard_Mode==1)
        #if (DRV_CLK_Wizard_Easy_Check==1)
            #define Wizard_SysClk_Select  DRV_CLK_Easy_Config
        #else
            //#error "Initialize System Clock error: Please check box at Easy Mode."
            //#define Wizard_SysClk_Select  SYS_12M_CPU_12M
            #undef Wizard_SysClk_Select
        #endif
    #elif (DRV_CLK_Wizard_Mode==2)
        #if (DRV_CLK_Wizard_Advanced_Check==1)
            #define Wizard_SysClk_Select  DRV_CLK_Advanced_Config
        #else
            //#error "Initialize System Clock error: Please check box at Advanced Mode."
            //#define Wizard_SysClk_Select  SYS_12M_CPU_12M
            #undef Wizard_SysClk_Select
        #endif
    #endif
#endif


#define Wizard_SYS_CPU_12M_Default  0x80020010

#define Wizard_OSCin_SEL        (Wizard_SysClk_Select & 0x0000F000)
#define Wizard_OSCin_IH12M      0<<12
#define Wizard_OSCin_IH11M      1<<12
#define Wizard_OSCin_XT2M_25M   2<<12
#define Wizard_OSCin_XT32K      3<<12
#define Wizard_OSCin_XT32K_L    4<<12
#define Wizard_OSCin_IL32K      5<<12
#define Wizard_OSCin_ECKI       6<<12

#define Wizard_CKCON0_ENCKM     (Wizard_SysClk_Select & ENCKM)
#define Wizard_CKCON0_CKMIS     (Wizard_SysClk_Select & (CKMIS1|CKMIS0))
#define Wizard_CKCON5_CKMS0     (Wizard_SysClk_Select & CKMS0_P<<24)
#define Wizard_CKCON2_MCKS      (Wizard_SysClk_Select & ((MCKS1_P|MCKS0_P)<<8))
#define Wizard_CKCON2_P         u32B1(Wizard_SysClk_Select) //P

#define Wizard_CKCON0_CLKSEL    (Wizard_SysClk_Select & (CCKS|SCKS2|SCKS1|SCKS0))

#define Wizard_CKCON3_P         u32B2(Wizard_SysClk_Select) //P
#define Wizard_CKCON3_Default   0x02<<16
#define Wizard_CKCON3_SEL       (Wizard_SysClk_Select & ((FWKP_P|MCKD1_P|MCKD0_P|0x03)<<16))

#define Wizard_DCON0_P          u32B3(Wizard_SysClk_Select & ((HSE_P|HSE1_P)<<24)) //P
#define Wizard_DCON0_HSEx_Default   HSE_P<<24
#define Wizard_DCON0_HSEx       (Wizard_SysClk_Select & ((HSE_P|HSE1_P)<<24))



/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize EMB
//<i> Check this term to initialize EMB (Off-Chip External data Memory Bus).
//<i> Date: 2020/09/04     Version: 1.00
#define MG82F6D64_EMB_WIZARD 0

//      <O0> EMB Command Pulse Width Selection
//      <i> Select by "__DRV_EMB_CommandPulse_Width_Select(__SELECT__);"
//          <0x00=> 1 SYSCLK/CPUCLK cycle (RWS2=0, RWS1=0, RWS0=0)(Default)
//          <0x01=> 2 SYSCLK/CPUCLK cycle (RWS2=0, RWS1=0, RWS0=1)
//          <0x02=> 3 SYSCLK/CPUCLK cycle (RWS2=0, RWS1=1, RWS0=0)
//          <0x03=> 4 SYSCLK/CPUCLK cycle (RWS2=0, RWS1=1, RWS0=1)
//          <0x04=> 5 SYSCLK/CPUCLK cycle (RWS2=1, RWS1=0, RWS0=0)
//          <0x05=> 6 SYSCLK/CPUCLK cycle (RWS2=1, RWS1=0, RWS0=1)
//          <0x06=> 7 SYSCLK/CPUCLK cycle (RWS2=1, RWS1=1, RWS0=0)
//          <0x07=> 8 SYSCLK/CPUCLK cycle (RWS2=1, RWS1=1, RWS0=1)
            #define DRV_EMB_CommandPulse_Width_Select 0x00

//      <O0> EMB Data Bus Setup Hold Time Selection
//      <i> Select by "__DRV_EMB_DataSetupHold_Time_Select(__SELECT__);"
//          <0x00=> 1 SYSCLK/CPUCLK cycle (RWSH=0)(Default)
//          <0x08=> 2 SYSCLK/CPUCLK cycle (RWSH=1)
            #define DRV_EMB_DataSetupHold_Time_Select 0x00


//</e> Initialize EMB End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize DMA
//<i> Check this term to initialize DMA Controller.
//<i> Date: 2021/10/20     Version: 1.01
#define MG82F6D64_DMA_WIZARD 0

//      <O0> DMA Source Selection
//      <i> Select Data Source by "__DRV_DMA_Source_Select(__SELECT__);"
//          <0x00=> Disable (DSS30=0, DSS20=0, DSS10=0, DSS00=0)(Default)
//          <0x10=> S0 RX (DSS30=0, DSS20=0, DSS10=0, DSS00=1)
//          <0x20=> S1 RX (DSS30=0, DSS20=0, DSS10=1, DSS00=0)
//          <0x30=> S2 RX (DSS30=0, DSS20=0, DSS10=1, DSS00=1)
//          <0x40=> S3 RX (DSS30=0, DSS20=1, DSS10=0, DSS00=0)
//          <0x50=> I2C0 RX (DSS30=0, DSS20=1, DSS10=0, DSS00=1)
//          <0x60=> I2C1 RX (DSS30=0, DSS20=1, DSS10=1, DSS00=0)
//          <0x70=> SPI0 RX (DSS30=0, DSS20=1, DSS10=1, DSS00=1)
//          <0x90=> ADC0 (DSS30=1, DSS20=0, DSS10=0, DSS00=1)
//          <0xB0=> EMB (DSS30=1, DSS20=0, DSS10=1, DSS00=1)
//          <0xF0=> XRAM (DSS30=1, DSS20=1, DSS10=1, DSS00=1)
            #define DRV_DMA_Souece_Select 0x00

//      <O0> DMA Destination Selection
//      <i> Select Data Destination by "__DRV_DMA_Destination_Select(__SELECT__);"
//          <0x00=> Disable (DDS30=0, DDS20=0, DDS10=0, DDS00=0)(Default)
//          <0x01=> S0 TX (DDS30=0, DDS20=0, DDS10=0, DDS00=1)
//          <0x02=> S1 TX (DDS30=0, DDS20=0, DDS10=1, DDS00=0)
//          <0x03=> S2 TX (DDS30=0, DDS20=0, DDS10=1, DDS00=1)
//          <0x04=> S3 TX (DDS30=0, DDS20=1, DDS10=0, DDS00=0)
//          <0x05=> I2C0 TX (DDS30=0, DDS20=1, DDS10=0, DDS00=1)
//          <0x06=> I2C1 TX (DDS30=0, DDS20=1, DDS10=1, DDS00=0)
//          <0x07=> SPI0 TX (DDS30=0, DDS20=1, DDS10=1, DDS00=1)
//          <0x0B=> EMB (DDS30=1, DDS20=0, DDS10=1, DDS00=1)
//          <0x0D=> CRC (DDS30=1, DDS20=1, DDS10=0, DDS00=1)
//          <0x0F=> XRAM (DDS30=1, DDS20=1, DDS10=1, DDS00=1)
            #define DRV_DMA_Destination_Select 0x00

//      <O0> DMA External_Trigger_Source Selection
//      <i> Select Data Destination by "__DRV_DMA_ExternalTriggerSource_Select(__SELECT__);"
//          <0x00=> Disable, software trigger (EXTS10=0, EXTS00=0)(Default)
//          <0x04=> INT2ET (EXTS10=0, EXTS00=1)
//          <0x0C=> KBIET (EXTS10=1, EXTS00=1)
            #define DRV_DMA_External_TriggerSource_Select 0x00


//      <o> LOOP Mode Operation
//      <i> The setting only change the parameter of "__DRV_DMA_LoopMode_Select(__SELECT__);"
//          <0=> Disable (LOOP0=0)(Default)
//          <1=> Enable (LOOP0=1)
            #define DRV_DMA_LoopMode_En 0


//      <o> CRC16 Write Operation
//      <i> The setting only change the parameter of "__DRV_DMA_CRC16_Write_Select(__SELECT__);"
//          <0=> Disable (CRCW0=0)(Default)
//          <1=> Enable (CRCW0=1)
            #define DRV_DMA_CRC16_Write_En 0



//  <e0> Timer5/6 Function Selection
//  <i> The Timer5 & Timer6 function enable by user.
    #define DRV_DMA_Timer56_En    0


//  <O0> DMA Mode or Timer Counter Mode
//  <i> The Timer5 & Timer6 function mode selection by user.
//      <1=> M2P or P2M
//      <2=> P2P
//      <3=> Timer Counter
    #define DRV_DMA_Timer56_Mode    1


//  <e0> M2P or P2M
//  <i> DMA Memory access function enable by user.
    #define DRV_DMA_M2P_En    0
//  <O0> XRAM Data Length <1-3839>
//  <i> The setting only change the parameter of "__DRV_DMA_SetDataLength(__SELECT__);"
//  <i> The timer5 counter be use to data length counter while DMA source or destination select to XRAM
//  <i> Setting value is limited by XRAM size "1-3839"
            #define DRV_DMA_XRAM_Data_Length 1

//  <O0> XRAM Address Pointer <0x0000-0x0eff>
//  <i> The setting only change the parameter of "__DRV_DMA_SetXRAMAddressPointer(__SELECT__);"
//  <i> The timer6 counter be use to address pointer while DMA source or destination select to XRAM
//  <i> Setting value is limited by XRAM address "0x0000-0x0eff"
            #define DRV_DMA_XRAM_Address_Pointer 0x0000
//  </e>

//  <e0> P2P
//  <i> DMA P2P function enable by user.
    #define DRV_DMA_P2P_En    0
//  <O0> Data Length <1-65535>
//  <i> The setting only change the parameter of "__DRV_DMA_SetDataLength(__SELECT__);"
//  <i> The timer5 counter be use to data length counter while DMA enable
//  <i> Setting data length "1-65535"
            #define DRV_DMA_Data_Length 1
//  </e>


//  <e0> Timer Counter
//  <i> Normal timer counter enable by user.
    #define DRV_DMA_Timer_En    0
//  <h> Timer5
//  <i> If DMA Memory is disabled, Timer5 is a 16-bit auto-reloadable timer/counter with Gate control function as Timer0.

//       <O0> Clock Source Select
//       <i> Select Clock Source by "__DRV_TIMER5_Clock_Source_Select(__SELECT__);"
//              <0x00=> SYSCLK/12 (T5CKS1=0, T5CKS0=0)(Default)
//              <0x01=> T5 Pin (T5CKS1=0, T5CKS0=1)
//              <0x02=> SYSCLK (T5CKS1=1, T5CKS0=0)
//              <0x03=> T2EXI input selection (T5CKS1=1, T5CKS0=1)
         #define DRV_DMA_Timer5_ClockSource_Config 0x00
//       <O0> Gating Source Select
//       <i> Select Gating Source by "__DRV_TIMER5_Gating_Source_Select(__SELECT__);"
//              <0x00=> Disable (T5GAT1=0, T5GAT0=0)(Default)
//              <0x01=> Inverted INT0ET (T5GAT1=0, T5GAT0=1)
//              <0x02=> Inverted INT2ET (T5GAT1=1, T5GAT0=0)
//              <0x03=> T3EXI input selection (T5GAT1=1, T5GAT0=1)
         #define DRV_DMA_Timer5_GatingSource_Config 0x00
//       <O0> Timer5 Counter 16Bits Value (0~65535) <0-65535>
//       <i> Users only need to enter numbers for current value, from 0~65535
//       <i> The time base formula of default setting is "(1/(SYSCLK/12))* (65536 - Timer5 Count Value)", for example 12MHz SYSCLK & Timer5 Count Value are set to 65535, the time base is 1us.
         #define DRV_DMA_Timer5_Current_Value 0
//       <O0> Timer5 16Bits Reload Value (0~65535) <0-65535>
//       <i> Users only need to enter numbers for base reload value, from 0~65535
         #define DRV_DMA_Timer5_Base_Reload_Value 0
//       <o> Timer5 Timer/Counter Run
//              <0=> Disable (TR5=0)(Default)
//              <1=> Enable (TR5=1)
            #define DRV_DMA_Timer5_TR5_En 0
//  </h>

//  <h> Timer6
//  <i> If DMA Memory is disabled, Timer6 is a 16-bit auto-reloadable timer/counter with Gate control function as Timer0.

//       <O0> Clock Source Select
//       <i> Select Clock Source by "__DRV_TIMER6_Clock_Source_Select(__SELECT__);"
//              <0x00=> SYSCLK/12 (T6CKS1=0, T6CKS0=0)(Default)
//              <0x01=> T6 Pin (T6CKS1=0, T6CKS0=1)
//              <0x02=> SYSCLK (T6CKS1=1, T6CKS0=0)
//              <0x03=> T3EXI input selection (T6CKS1=1, T6CKS0=1)
         #define DRV_DMA_Timer6_ClockSource_Config 0x00
//       <O0> Gating Source Select
//       <i> Select Gating Source by "__DRV_TIMER6_Gating_Source_Select(__SELECT__);"
//              <0x00=> Disable (T6GAT1=0, T6GAT0=0)(Default)
//              <0x01=> Inverted INT0ET (T6GAT1=0, T6GAT0=1)
//              <0x02=> Inverted INT2ET (T6GAT1=1, T6GAT0=0)
//              <0x03=> T2EXI input selection (T6GAT1=1, T6GAT0=1)
         #define DRV_DMA_Timer6_GatingSource_Config 0x00
//       <O0> Timer6 Counter 16Bits Value (0~65535) <0-65535>
//       <i> Users only need to enter numbers for current value, from 0~65535
//       <i> The time base formula of default setting is "(1/(SYSCLK/12))* (65536 - Timer6 Count Value)"
         #define DRV_DMA_Timer6_Current_Value 0
//       <O0> Timer6 16Bits Reload Value (0~65535) <0-65535>
//       <i> Users only need to enter numbers for base reload value, from 0~65535
         #define DRV_DMA_Timer6_Base_Reload_Value 0
//       <o> Timer6 Timer/Counter Run
//              <0=> Disable (TR6=0)(Default)
//              <1=> Enable (TR6=1)
            #define DRV_DMA_Timer6_TR6_En 0
//  </h>
//  </e>
//  </e>

//      <o> DMA Strat Run
//      <i> The setting only change the parameter of "__DRV_DMA_SetTransferStart();"
//          <0=> Disable (DMAS0=0)(Default)
//          <1=> Enable (DMAS0=1)
            #define DRV_DMA_Start_En 0

//</e> Initialize DMA End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize WDT
//<i> Check this term to initialize WDT.
//<i> Date: 2022/06/09     Version: 1.01
#define MG82F6D64_WDT_WIZARD      0

//  <o0> WDT Clock Source Selection
//  <i> Select WDT clock source.
//      <0=>ILRCO (WDTCS1=0, WDTCS0=0)(Default)
//      <1=>P60 (WDTCS1=0, WDTCS0=1)
//      <2=>SYSCLK/12 (WDTCS1=1, WDTCS0=0)
//      <3=>S0TOF (WDTCS1=1, WDTCS0=1)
        #define CKCON3_WDTCS    0

//  <o0> Non-Stopped WDT
//      <0=> Disable (NSW=0)
//      <1=> Enable (NSW=1)
//  <i> This enables WDT to keep counting in power-down or idle mode.
        #define WDTCR_NSW       0

//  <o0> WDT Idle Control
//      <0=> Disable (WIDL=0)
//      <1=> Enable (WIDL=1)
//  <i> This enables WDT to keep counting in the idle mode.
        #define WDTCR_WIDL      0

//  <o0> Select Prescaler Output for WDT
//  <i> Determine WDT time base input.
//      <0=> 1/2   (PS2=0, PS1=0, PS0=0)
//      <1=> 1/4   (PS2=0, PS1=0, PS0=1)
//      <2=> 1/8   (PS2=0, PS1=1, PS0=0)
//      <3=> 1/16  (PS2=0, PS1=1, PS0=1)
//      <4=> 1/32  (PS2=1, PS1=0, PS0=0)
//      <5=> 1/64  (PS2=1, PS1=0, PS0=1)
//      <6=> 1/128 (PS2=1, PS1=1, PS0=0)
//      <7=> 1/256 (PS2=1, PS1=1, PS0=1)
        #define PreScaler       7

//  <o0> WDT Overflow Source Selection
//  <i> Determine WDT event source.
//      <0=> Select WDT bit-8 overflow as WDT event source (WDTFS=0)(Default)
//      <1=> Select WDT bit-0 overflow as WDT event source (WDTFS=1)
        #define CKCON3_WDTFS    0

//  <o0> WDT Reset Enable
//  <i> Enable/Disable WDT reset.
//      <0=> Disable (WREN=0)
//      <1=> Enable (WREN=1)
        #define WDTCR_WREN      0

//  <o0> WDT ENW
//  <i>  Enable/Disable WDT .
//      <0=> Disable (ENW=0)
//      <1=> Enable (ENW=1)
        #define WDTCR_ENW       0
//</e> Watch Dog Timer(WDT) End
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize RTC
//<i> Check this term to initialize RTC.
//<i> Date: 2021/10/18     Version: 1.01
#define MG82F6D64_RTC_WIZARD    0

//  <o0> RTC Clock Source Selection
//  <i> Select RTC clock source.
//      <0=> P60       (RCSS2=0, RCSS1=0, RCSS0=0)(Default)
//      <1=> ILRCO     (RCSS2=0, RCSS1=0, RCSS0=1)
//      <2=> WDTPS     (RCSS2=0, RCSS1=1, RCSS0=0)
//      <3=> WDTOF     (RCSS2=0, RCSS1=1, RCSS0=1)
//      <4=> SYSCLK    (RCSS2=1, RCSS1=0, RCSS0=0)
//      <5=> SYSCLK/12 (RCSS2=1, RCSS1=0, RCSS0=1)
        #define CKCON4_RCSS     0

//  <o0> RTC Prescaler
//  <i> Determine RTC time base input.
//      <0=> DIV 2^15 (RTCCS3=0, RTCCS2=0, RTCCS1=0, RTCCS0=0)
//      <1=> DIV 2^14 (RTCCS3=0, RTCCS2=0, RTCCS1=0, RTCCS0=1)(Default)
//      <2=> DIV 2^13 (RTCCS3=0, RTCCS2=0, RTCCS1=1, RTCCS0=0)
//      <3=> DIV 2^12 (RTCCS3=0, RTCCS2=0, RTCCS1=1, RTCCS0=1)
//      <4=> DIV 2^11 (RTCCS3=0, RTCCS2=1, RTCCS1=0, RTCCS0=0)
//      <5=> DIV 2^10 (RTCCS3=0, RTCCS2=1, RTCCS1=0, RTCCS0=1)
//      <6=> DIV 2^9  (RTCCS3=0, RTCCS2=1, RTCCS1=1, RTCCS0=0)
//      <7=> DIV 2^8  (RTCCS3=0, RTCCS2=1, RTCCS1=1, RTCCS0=1)
//      <8=> DIV 2^7  (RTCCS3=1, RTCCS2=0, RTCCS1=0, RTCCS0=0)
//      <9=> DIV 2^6  (RTCCS3=1, RTCCS2=0, RTCCS1=0, RTCCS0=1)
//      <10=> DIV 2^5 (RTCCS3=1, RTCCS2=0, RTCCS1=1, RTCCS0=0)
//      <11=> DIV 2^4 (RTCCS3=1, RTCCS2=0, RTCCS1=1, RTCCS0=1)
//      <12=> DIV 2^3 (RTCCS3=1, RTCCS2=1, RTCCS1=0, RTCCS0=0)
//      <13=> DIV 2^2 (RTCCS3=1, RTCCS2=1, RTCCS1=0, RTCCS0=1)
//      <14=> DIV 2^1 (RTCCS3=1, RTCCS2=1, RTCCS1=1, RTCCS0=0)
//      <15=> DIV 2^0 (RTCCS3=1, RTCCS2=1, RTCCS1=1, RTCCS0=1)
        #define CKCON4_RTCCS    1

//  <o0> RTC Output enable
//      <0=> Disable (RTCO=0)(Default)
//      <1=> Enable (RTCO=1)
//  <i> Select P45 as RTC output. The frequency of RTCO will be a half of RTC overflow rate.
        #define RTCCR_RTCO      0

//  <o0> RTC counter value (0~63) <0-63>
//  <i>  Assign a number to the RTC counter.
        #define RTCTM_RTCCT     0

//  <o0> RTC counter reload value (0~63) <0-63>
//  <i>  Assign a number to the RTC reloader, which determines the time period after reloading.
        #define RTCCR_RTCRL     63

//  <o0> RTC Output enable
//      <0=> Disable (RTCE=0)(Default)
//      <1=> Enable (RTCE=1)
//  <i> Enable/Disable RTC .
        #define RTCCR_RTCE      0
//</e> Real Time Clock(RTC) END
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize Power Management
//<i> Check this term to initialize power control.
//<i> Date: 2020/11/12     Version: 1.00
#define MG82F6D64_PW_WIZARD 0

//  <e0> Initialize Brown-Out Detector(BODx)
//  <i> Check this term, then macro __DRV_BODx_Wizard_Init() will initialize BODx.
    #define MG82F6D64_BODx_WIZARD   0

//      <e> Initialize BOD0
        #define MG82F6D64_BODx_BOD0 0
//      <i> Enable/Disable BOD0 Reset.
//          <o0> BOD0 Reset
//              <0=> Disable (BO0RE=0)(Default)
//              <1=> Enable (BO0RE=1)
            #define PCON2_BO0RE     0
//      </e> Initialize BOD0 END

//      <e> Initialize BOD1
        #define MG82F6D64_BODx_BOD1 0
//      <i> Enable/Disable BOD1, specify BOD1 monitored level, awake BOD1 in PD mode, enable/disable BOD1 reset.
//          <o0> BOD1 Enable
//          <i>Enable BOD1 that monitors VDD power dropped at a BO1S specified voltage level.
//              <0=> Disable (EBOD1=0)
//              <1=> Enable (EBOD1=1)(Default)
            #define PCON2_EBOD1     1

//          <o0> Brown-Out Detector 1 Level
//          <i> Brown-out detector 1 monitored level selection.
//              <0=> 2.0V (BO1S1=0, BO1S0=0)
//              <1=> 2.4V (BO1S1=0, BO1S0=1)
//              <2=> 3.7V (BO1S1=1, BO1S0=0)
//              <3=> 4.2V (BO1S1=1, BO1S0=1)(Default)
            #define PCON2_BO1S       3

//          <o0> Awake BOD1 in PD mode
//              <0=> Disable (AWBOD1=0)(Default)
//              <1=> Enable (AWBOD1=1)
            #define PCON2_AWBOD1     0

//          <o0> BOD1 Reset
//          <i> Enable/Disable BOD1 Reset.
//              <0=> Disable (BO1RE=0)(Default)
//              <1=> Enable (BO1RE=1)
            #define PCON2_BO1RE      0
//      </e> Initialize BOD1 END

//  </e> Brown-Out Detector(BODx) END

//</e> Initialize Power Management
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize Timers/Counters
//<i> Check this term to initialize Timers/Counters.
//<i> Date: 2021/12/16     Version: 1.01
#define MG82F6D64_TIMER_WIZARD 0

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  <e>Timer0 Enable
//  <i>Mode0 8Bit pwm.
//  <i>Mode1 16 bit timer/counter.
//  <i>Mode2 8Bit timer/counter auto-reload.
//  <i>Mode3 two separate timer/counter.
    #define TM0_Wizard_init_EN 0

//      <o>Mode
//      <i> Mode0~mode3 select
//          <0x00=>Mode 0 8 Bit PWM (T0M1=0,T0M0=0)(Default)
//          <0x01=>Mode 1 16 Bit Timer/Counter (T0M1=0,T0M0=1)
//          <0x02=>Mode 2 8Bit Timer/Counter Auto Reload (T0M1=1,T0M0=0)
//          <0x03=>Mode 3 Two Separate Timer/Counter (T0M1=1,T0M0=1)
        #define TM0_Wizard_Mode 0x00

//===========================================================
//      <e>Mode 0 8 Bit PWM Enable
//      <i>Mode 0 8 bit pwm enable.
//      <i>T0OF (Hz) :
//      <i>First run => T0OF = T0CKI/(256-TL0)
//      <i>After first run => T0OF = T0CKI/256
        #define TIMER0_Mode0_8Bit_PWM 0
//===========================================================
//          <o>Clock Output
//          <i>Note:T0CKOE=1,gpio wizard p3.4 or p4.4 or p4.6 or p1.7 select T0CKO.
//              <0=>Disable (T0CKOE=0)(Default)
//              <1=>Enable (T0CKOE=1)
            #define TIMER0_Mode0_Clock_Output_Enable 0

//          <o>Clock Source(T0CKI)
//              <0x00=> SYSCLK/12 (T0XL=0,T0X12=0,T0C_T=0)(Default)
//              <0x01=> T0 Pin (T0XL=0,T0X12=0,T0C_T=1)
//              <0x02=> SYSCLK (T0XL=0,T0X12=1,T0C_T=0)
//              <0x03=> ILRCO (T0XL=0,T0X12=1,T0C_T=1)
//              <0x04=> SYSCLK/48 (T0XL=1,T0X12=0,T0C_T=0)
//              <0x05=> WDTPS (T0XL=1,T0X12=0,T0C_T=1)
//              <0x06=> SYSCLK/192 (T0XL=1,T0X12=1,T0C_T=0)
//              <0x07=> T1OF (T0XL=1,T0X12=1,T0C_T=1)
            #define TIMER0_Mode0_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T0G1=0,T0GATE=0)(Default)
//              <0x01=> INT0ET (T0G1=0,T0GATE=1)
//              <0x02=> TF2 (T0G1=1,T0GATE=0)
//              <0x03=> KBIET (T0G1=1,T0GATE=1)
            #define TIMER0_Mode0_Gating_Source 0x00

//          <o>Initialize Compare Value (0~255) <0-255>
//          <i>Setting TH0.
//          <i>Duty cucle:1/256~256/256(timer interval low byte=0,timer interval high byte=255~0).
            #define TIMER0_Mode0_TH0 0

//          <o>Initialize Counter Value (0~255) <0-255>
//          <i>Setting TL0.
//          <i>Example:
//          <i>Timer interval low byte=0(Total interval=255-0+1=256count,aviliable on first cycle).
//          <i>Timer interval high byte=1(high level interval=255count(256-1=255),low level interval=1count).
            #define TIMER0_Mode0_TL0 0

//          <o>8Bits Timer/Counter TL0 Run
//              <0=>Disable (TR0=0)(Default)
//              <1=>Enable (TR0=1)
            #define TIMER0_Mode0_TR0 0
//      </e>  //Mode0 8 Bit PWM Enable

//===========================================================
//      <e>Mode 1 16 Bit Timer/Counter Enable
//      <i>Mode 1 16 bit timer/counter enable.
//      <i>T0OF (Hz) :
//      <i>First run => T0OF = T0CKI/(65536-[TH0:TL0])
//      <i>After first run => T0OF = T0CKI/65536
        #define TIMER0_Mode1_16Bit_Timer_Counter 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T0CKOE=0)(Default)
//              <1=>Enable (T0CKOE=1)
//          <i>Note:T0CKOE=1,gpio wizard p3.4 or p4.4 or p4.6 or p1.7 select T0CKO.
            #define TIMER0_Mode1_Clock_Output_Enable 0

//          <o>Clock Source(T0CKI)
//              <0x00=> SYSCLK/12 (T0XL=0,T0X12=0,T0C_T=0)(Default)
//              <0x01=> T0 Pin (T0XL=0,T0X12=0,T0C_T=1)
//              <0x02=> SYSCLK (T0XL=0,T0X12=1,T0C_T=0)
//              <0x03=> ILRCO (T0XL=0,T0X12=1,T0C_T=1)
//              <0x04=> SYSCLK/48 (T0XL=1,T0X12=0,T0C_T=0)
//              <0x05=> WDTPS (T0XL=1,T0X12=0,T0C_T=1)
//              <0x06=> SYSCLK/192 (T0XL=1,T0X12=1,T0C_T=0)
//              <0x07=> T1OF (T0XL=1,T0X12=1,T0C_T=1)
            #define TIMER0_Mode1_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T0G1=0,T0GATE=0)(Default)
//              <0x01=> INT0ET (T0G1=0,T0GATE=1)
//              <0x02=> TF2 (T0G1=1,T0GATE=0)
//              <0x03=> KBIET (T0G1=1,T0GATE=1)
            #define TIMER0_Mode1_Gating_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH0(16Bits value high byte) & TL0(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER0_Mode1_16Bits_Counter_Value 0

//          <o>16Bits Timer/Counter Run
//              <0=>Disable (TR0=0)(Default)
//              <1=>Enable (TR0=1)
            #define TIMER0_Mode1_TR0 0

//      </e>  //Mode0 16 Bit Timer/Counter Enable

//===========================================================
//      <e> Mode 2 8Bit Timer/Counter Auto Reload Enable
//      <i> Mode 2 8Bit timer/counter auto reload enable.
//      <i>T0OF (Hz) :
//      <i>First run => T0OF = T0CKI/(256-TL0)
//      <i>After first run => T0OF = T0CKI/(256-TH0)
        #define TIMER0_Mode2_8Bit_Timer_Counter_Auto_Reload 0
//===========================================================
//          <o>Clock Output
//          <i>Note:T0CKOE=1,gpio wizard p3.4 or p4.4 or p4.6 or p1.7 select T0CKO.
//              <0=>Disable (T0CKOE=0)(Default)
//              <1=>Enable (T0CKOE=1)
            #define TIMER0_Mode2_Clock_Output_Enable 0

//          <o>Clock Source(T0CKI)
//              <0x00=> SYSCLK/12 (T0XL=0,T0X12=0,T0C_T=0)(Default)
//              <0x01=> T0 Pin (T0XL=0,T0X12=0,T0C_T=1)
//              <0x02=> SYSCLK (T0XL=0,T0X12=1,T0C_T=0)
//              <0x03=> ILRCO (T0XL=0,T0X12=1,T0C_T=1)
//              <0x04=> SYSCLK/48 (T0XL=1,T0X12=0,T0C_T=0)
//              <0x05=> WDTPS (T0XL=1,T0X12=0,T0C_T=1)
//              <0x06=> SYSCLK/192 (T0XL=1,T0X12=1,T0C_T=0)
//              <0x07=> T1OF (T0XL=1,T0X12=1,T0C_T=1)
            #define TIMER0_Mode2_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T0G1=0,T0GATE=0)(Default)
//              <0x01=> INT0ET (T0G1=0,T0GATE=1)
//              <0x02=> TF2 (T0G1=1,T0GATE=0)
//              <0x03=> KBIET (T0G1=1,T0GATE=1)
            #define TIMER0_Mode2_Gating_Source 0x00

//          <o>Initialize Counter Value (0~255) <0-255>
//          <i>Setting TL0.
            #define TIMER0_Mode2_TL0 0

//          <o>Initialize Reload Value (0~255) <0-255>
//          <i>Setting TH0.
            #define TIMER0_Mode2_Timer_Reload   0

//          <o>8Bits Timer/Counter TL0 Run
//              <0=>Disable (TR0=0)(Default)
//              <1=>Enable (TR0=1)
            #define TIMER0_Mode2_TR0 0

//      </e>  //Mode2 8Bit Timer/Counter Auto Reload Enable

//===========================================================
//      <e>Mode 3 Two Separate Timer/Counter Enable
//      <i>**Note:when timer0 in mode3,Timer 1 is halt.
//      <i>T0OF (Hz) :
//      <i>First run => T0OF = T0CKI/(256-TL0)
//      <i>After first run => T0OF = T0CKI/256
        #define TIMER0_Mode3_Two_Separate_Timer_Counter 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T0CKOE=0)(Default)
//              <1=>Enable (T0CKOE=1)
//          <i>Note:T0CKOE=1,gpio wizard p3.4 or p4.4 or p4.6 or p1.7 select T0CKO.
            #define TIMER0_Mode3_T0CKO_Clock_Output_Enable 0

//          <o>Clock Source(T0CKI)
//              <0x00=> SYSCLK/12 (T0XL=0,T0X12=0,T0C_T=0)(Default)
//              <0x01=> T0 Pin (T0XL=0,T0X12=0,T0C_T=1)
//              <0x02=> SYSCLK (T0XL=0,T0X12=1,T0C_T=0)
//              <0x03=> ILRCO (T0XL=0,T0X12=1,T0C_T=1)
//              <0x04=> SYSCLK/48 (T0XL=1,T0X12=0,T0C_T=0)
//              <0x05=> WDTPS (T0XL=1,T0X12=0,T0C_T=1)
//              <0x06=> SYSCLK/192 (T0XL=1,T0X12=1,T0C_T=0)
//              <0x07=> T1OF (T0XL=1,T0X12=1,T0C_T=1)
            #define TIMER0_Mode3_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T0G1=0,T0GATE=0)(Default)
//              <0x01=> INT0ET (T0G1=0,T0GATE=1)
//              <0x02=> TF2 (T0G1=1,T0GATE=0)
//              <0x03=> KBIET (T0G1=1,T0GATE=1)
            #define TIMER0_Mode3_Gating_Source 0x00

//          <o>Initialize Interval High Byte Value (0~255) <0-255>
//          <i>Setting TH0.
            #define TIMER0_Mode3_TH0 0

//          <o>Initialize Interval Low Byte Value (0~255) <0-255>
//          <i>Setting TL0.
            #define TIMER0_Mode3_TL0 0

//          <o>8Bits Timer/Counter TL0 Run
//              <0=>Disable (TR0=0)(Default)
//              <1=>Enable (TR0=1)
            #define TIMER0_Mode3_TR0_Run 0

//          <o>8Bits Timer/Counter TH0 Run
//              <0=>Disable (TR1=0)(Default)
//              <1=>Enable (TR1=1)
            #define TIMER0_Mode3_TR1_Run 0

//      </e>  //Mode 3 Two Separate Timer/Counter Enable
//  </e>  //Timer0 Enable

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  <e>Timer1 Enable
//  <i>Mode0 8 bit pwm ready.
//  <i>Mode1 16 bit timer/counter.
//  <i>Mode2 8Bit timer/counter auto-reload.
    #define TM1_Wizard_init_EN 0
//      <o>Mode
//      <i> Mode0~mode2 select
//          <0x00=>Mode 0 8 Bit PWM (T1M1=0,T1M0=0)(Default)
//          <0x01=>Mode 1 16 Bit Timer/Counter (T1M1=0,T1M0=1)
//          <0x02=>Mode 2 8Bit Timer/Counter Auto Reload (T1M1=1,T1M0=0)
        #define TIMER1_Mode  0x00

//===========================================================
//      <e>Mode 0 8 Bit PWM Enable
//      <i>Mode 0 8 bit pwm enable.
//      <i>T1OF (Hz) :
//      <i>First run => T1OF = T1CKI/(256-TL1)
//      <i>After first run => T1OF = T1CKI/256
        #define TIMER1_Mode0_8Bit_PWM 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T1CKOE=0)(Default)
//              <1=>Enable (T1CKOE=1)
//          <i>Note:T1CKOE=1,gpio wizard p3.5 or p4.5 or p3.6 or p3.7 select T1CKO.
            #define TIMER1_Mode0_Clock_Output_Enable 0

//          <o>Clock Source(T1CKI)
//              <0x00=> SYSCLK/12 (T1X12=0,T1C_T=0)(Default)
//              <0x01=> T1 Pin (T1X12=0,T1C_T=1)
//              <0x02=> SYSCLK (T1X12=1,T1C_T=0)
//              <0x03=> SYSCLK/48 (T1X12=1,T1C_T=1)
            #define TIMER1_Mode0_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T1G1=0,T1GATE=0)(Default)
//              <0x01=> INT1ET (T1G1=0,T1GATE=1)
//              <0x02=> TF3 (T1G1=1,T1GATE=0)
//              <0x03=> TI1 (T1G1=1,T1GATE=1)
            #define TIMER1_Mode0_Gating_Source 0x00

//          <o>Initialize Compare Value (0~255) <0-255>
//          <i>Setting TH1.
//          <i>Duty cucle:1/256~256/256(Timer interval low byte=0,Timer interval high byte=255~0).
            #define TIMER1_Mode0_TH1 0

//          <o>Initialize Counter Value (0~255) <0-255>
//          <i>Setting TL1.
//          <i>Example:
//          <i>Timer interval low byte=0(Total interval=255-0+1=256count,aviliable on first cycle).
//          <i>Timer interval high byte=1(high level interval=255count(256-1=255),low level interval=1count).
            #define TIMER1_Mode0_TL1 0

//           <o>8Bit Timer/Counter Run
//              <0=>Disable (TR1=0)(Default)
//              <1=>Enable (TR1=1)
            #define TIMER1_Mode0_TR1_Run 0

//      </e>  //Mode0 8 Bit PWM Enable

//===========================================================
//      <e>Mode 1 16 Bit Timer/Counter Enable
//      <i>Mode 1 16 bit timer/counter enable.
//      <i>T1OF (Hz) :
//      <i>First run => T1OF = T1CKI/(65536-[TH1:TL1])
//      <i>After first run => T1OF = T1CKI/65536
        #define TIMER1_Mode1_16Bit_Timer_Counter 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T1CKOE=0)(Default)
//              <1=>Enable (T1CKOE=1)
//          <i>Note:T1CKOE=1,gpio wizard p3.5 or p4.5 or p3.6 or p3.7 select T1CKO.
            #define TIMER1_Mode1_Clock_Output_Enable 0

//          <o>Clock Source(T1CKI)
//              <0x00=> SYSCLK/12 (T1X12=0,T1C_T=0)(Default)
//              <0x01=> T1 Pin (T1X12=0,T1C_T=1)
//              <0x02=> SYSCLK (T1X12=1,T1C_T=0)
//              <0x03=> SYSCLK/48 (T1X12=1,T1C_T=1)
            #define TIMER1_Mode1_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T1G1=0,T1GATE=0)(Default)
//              <0x01=> INT1ET (T1G1=0,T1GATE=1)
//              <0x02=> TF3 (T1G1=1,T1GATE=0)
//              <0x03=> TI1 (T1G1=1,T1GATE=1)
            #define TIMER1_Mode1_Gating_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH1(16Bits value high byte) & TL1(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER1_Mode1_16Bits_Counter_Value 0

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR1=0)(Default)
//              <1=>Enable (TR1=1)
            #define TIMER1_Mode1_TR1_Run 0

//      </e>  //Mode1 16 Bit Timer/Counter Enable

//===========================================================
//      <e>Mode 2 8Bit Timer/Counter Auto Reload Enable
//      <i>Mode 2 8Bit timer/counter auto reload enable.
//      <i>T1OF (Hz) :
//      <i>First run => T1OF = T1CKI/(256-TL1)
//      <i>After first run => T1OF = T1CKI/(256-TH1)
        #define TIMER1_Mode2_8Bit_Timer_Counter_Auto_Reload 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T1CKOE=0)(Default)
//              <1=>Enable (T1CKOE=1)
//          <i>Note:T1CKOE=1,gpio wizard p3.5 or p4.5 or p3.6 or p3.7 select T1CKO.
            #define TIMER1_Mode2_Clock_Output_Enable 0

//          <o>Clock Source(T1CKI)
//              <0x00=> SYSCLK/12 (T1X12=0,T1C_T=0)(Default)
//              <0x01=> T1 Pin (T1X12=0,T1C_T=1)
//              <0x02=> SYSCLK (T1X12=1,T1C_T=0)
//              <0x03=> SYSCLK/48 (T1X12=1,T1C_T=1)
            #define TIMER1_Mode2_Clock_Source 0x00

//          <o>Gating Source
//              <0x00=> 1 (T1G1=0,T1GATE=0)(Default)
//              <0x01=> INT1ET (T1G1=0,T1GATE=1)
//              <0x02=> TF3 (T1G1=1,T1GATE=0)
//              <0x03=> TI1 (T1G1=1,T1GATE=1)
            #define TIMER1_Mode2_Gating_Source 0x00

//          <o>Initialize Counter Value (0~255) <0-255>
//          <i>Setting TL1.
            #define TIMER1_Mode2_TL1 0

//          <o>Initialize Reload Value (0~255) <0-255>
//          <i>Setting TH1.
            #define TIMER1_Mode2_Timer_Reload   0

//          <o>8Bit Timer/Counter Run
//              <0=>Disable (TR1=0)(Default)
//              <1=>Enable (TR1=1)
            #define TIMER1_Mode2_TR1_Run 0

//      </e>  //Mode2 8Bit Timer/Counter Auto Reload Enable
//  </e>  //Timer 1 Enable

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  <e>Timer2 Enable
//  <i>Mode0 16bit timer/counter auto-reload and external interrupt.
//  <i>Mode1 16bit timer/counter auto-reload with external interrupt.
//  <i>Mode2 16bit timer/counter capture.
//  <i>Mode3 16bit timer/counter capture auto_zero.
//  <i>Mode6 Duty Capture.
//  <i>Spilt mode0 two 8Bit timer/counter auto-reload and external interrupt.
//  <i>Spilt mode1 two 8Bit timer/counter auto-reload with external interrupt.
//  <i>Spilt mode2 two 8Bit timer/counter capture.
//  <i>Spilt mode3 two 8Bit timer/counter capture with auto zero.
//  <i>Spilt mode4 two 8Bit pwm.
//  <i>Spilt mode6 duty capture.
//  <i>Baud-Rate Generator
//  <i>Split Baud-Rate Generator
#define TM2_Wizard_init_EN 0
//      <o>Mode
//          <0x00=>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt (T2SPL=0,T2MS1=0,CP/RL2=0,T2MS0=0)(Default)
//          <0x01=>Mode 1 16Bit Timer/Counter Auto-Reload with External Interrupt (T2SPL=0,T2MS1=0,CP/RL2=0,T2MS0=1)
//          <0x02=>Mode 2 16Bit Timer/Counter Capture (T2SPL=0,T2MS1=0,CP/RL2=1,T2MS0=0)
//          <0x03=>Mode 3 16Bit Timer/Counter Capture Auto_Zero(T2SPL=0,T2MS1=0,CP/RL2=1,T2MS0=1)
//          <0x09=>Mode 6 Duty Capture(T2SPL=0,T2MS1=1,CP/RL2=1,T2MS0=0)
//          <0x04=>Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt (T2SPL=1,T2MS1=0,CP/RL2=0,T2MS0=0)
//          <0x05=>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt (T2SPL=1,T2MS1=0,CP/RL2=0,T2MS0=1)
//          <0x06=>Split Mode 2 Two 8Bit Timer/Counter Capture (T2SPL=1,T2MS1=0,CP/RL2=1,T2MS0=0)
//          <0x07=>Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero (T2SPL=1,T2MS1=0,CP/RL2=1,T2MS0=1)
//          <0x08=>Split Mode 4 8Bit Pwm (T2SPL=1,T2MS1=1,CP/RL2=0,T2MS0=0)
//          <0x0A=>Split Mode 6 Duty Capture(T2SPL=1,T2MS1=1,CP/RL2=1,T2MS0=0)
//          <0x0B=>Baud-Rate Generator Mode(T2SPL=0,T2MS1=0,CP/RL2=1,T2MS0=0)
//          <0x0C=>Split Baud-Rate Generator Mode(T2SPL=1,T2MS1=0,CP/RL2=0/1,T2MS0=0/1)
        #define TIMER2_Mode  0x00

//===========================================================
//      <e>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i>Mode 0 16bit auto-reload and external interrupt enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = T2CKI/(65536-[TH2:TL2])
//      <i>After first run => T2OF = T2CKI/(65536-[RCAP2H:RCAP2L])
        #define TIMER2_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable  (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.2 or p6.7 or p4.5 select T2CKO.
            #define TIMER2_Mode0_Clock_Output_Enable 0

//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Mode0_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Mode0_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode0_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP2H(16Bits value high byte) & RCAP2L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16 bit timer overflow),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode0_16Bits_Reload_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable  (TF2IG=1)
            #define TIMER2_Mode0_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>16Bits Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Mode0_16Bit_TR2_Run 0

//      </e>  //Mode0 16Bit Auto-Reload and External Interrupt Enable

//===========================================================
//      <e>Mode 1 16Bit Auto-Reload with External Interrupt Enable
//      <i>Mode 1 16bit timer auto-reload with external interrupt enable.
//      <i>T2OF period will be changed when capture value to RCAP2 buffer.
        #define TIMER2_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Mode1_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Mode1_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode1_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP2H(16Bits value high byte) & RCAP2L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16bit timer/counter overflow or capture source dectect edge),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode1_16Bits_Reload_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Mode1_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Mode1_TR2_Run 0

//      </e>  //Mode 1 16Bit Auto-Reload with External Interrupt Enable

//===========================================================
//      <e>Mode 2 16Bit Timer/Counter Capture Enable
//      <i>Mode 2 16bit timer/counter capture enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = T2CKI/(65536-[TH2:TL2])
//      <i>After first run => T2OF = T2CKI/65536
        #define TIMER2_Mode2_16Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Mode2_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Mode2_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,timer2 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer 2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer 2 external inputs, that causes the current value in the timer 2 registers, TH2 and TL2,to be captured into registers RCAP2H and RCAP2L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF2 in T2CON to be set, and the EXF2 bit (like TF2) can generate an interrupt which vectors to the same location as Timer 2 overflow interrupt.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode2_16Bits_Counter_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Mode2_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Mode2_TR2_Run 0

//      </e>  //Mode 2 16Bit Timer/Counter Capture Enable

//===========================================================
//      <e>Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable
//      <i>Mode 3 16bit timer/counter capture with auto zero enable.
//      <i>T2OF period will be changed when capture counter value to RCAP2 buffer..
        #define TIMER2_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero 0
//===========================================================
//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Mode3_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Mode3_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,timer2 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer 2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer 2 external inputs, that causes the current value in the timer 2 registers, TH2 and TL2,to be captured into registers RCAP2H and RCAP2L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF2 in T2CON to be set, and the EXF2 bit (like TF2) can generate an interrupt which vectors to the same location as Timer 2 overflow interrupt.
//          <i>Note:Timer 2 mode 3 is the similar function with timer 2 mode 2. There is one difference that the capture source trigger(T2EXES), EXF2 event set signal, not only is the capture source of Timer 2 but also clears the content of TL2 and TH2 to 0x0000H.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode3_16Bits_Counter_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Mode3_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Mode3_TR2_Run 0

//      </e>  //Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable

//===========================================================
//      <e>Mode 6 Duty Capture Enable
//      <i>Mode 6 duty capture enable.
//      <i>T2OF period will be stop by duty capture finish.
        #define TIMER2_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Mode6_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Mode6_16Bits_Counter_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Mode6_TR2_Run 0

//      </e>  //Mode6 Duty Capture Enable

//===========================================================
//      <e> Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i> Split mode 0 two 8Bit timer/counter auto-reload and external interrupt enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = TL2CKI/(256-TL2)
//      <i>After first run => T2OF = TL2CKI/(256-RCAP2L)
        #define TIMER2_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.0 or p6.0 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode0_Clock_Output_Enable 0

//          <o>TH2 Clock Source(TH2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> TL2OF (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode0_TH2_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode0_TH2 0

//          <o>Initialize RCAP2H Reload Value (0~255) <0-255>
//          <i>Setting RCAP2H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte Reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow).
            #define TIMER2_Split_Mode0_RCAP2H 0

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Mode0_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode0_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Mode0_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode0_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode0_Overflow_Flag_Ignored 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:TL2 stop by TH2 overflow.When TH2 over flow ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode0_TL2LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Mode0_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Mode0_TR2L_Run 0

//      </e>  //Split mode0 two 8Bit timer auto-reload and external interrupt Enable

//===========================================================
//      <e>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt Enable
//      <i>Split mode 1 two 8Bit timer/counter auto-reload with external interrupt enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = TL2CKI/(256-TL2)
//      <i>After first run => T2OF = TL2CKI/(256-RCAP2L)
        #define TIMER2_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.2 or p6.7 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode1_Clock_Output_Enable 0

//          <o>TH2 Clock Source(TH2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> TL2OF (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode1_TH2_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode1_TH2 0

//          <o>Initialize RCAP2H Reload Value (0~255) <0-255>
//          <i>Setting RCAP2H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow or capture source dectect edge).
            #define TIMER2_Split_Mode1_RCAP2H 0

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Mode1_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode1_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Mode1_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode1_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode1_Overflow_Flag_Ignored 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:TL2 stop by TH2 overflow.When TH2 over flow ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode1_TR2LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Mode1_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Mode1_TR2L_Run 0

//      </e>  //Split Mode1 Two 8Bit Timer Auto-Reload and External Interrupt Enable

//===========================================================
//      <e> Split Mode 2 Two 8Bit Timer/Counter Capture Enable
//      <i> Split mode 2 two 8Bit timer/counter Capture enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = TL2CKI/(256-TL2)
//      <i>After first run => T2OF = TL2CKI/(256-RCAP2L)
        #define TIMER2_Split_Mode2_Two_8Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.2 or p6.7 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode2_Clock_Output_Enable 0

//          <o>TH2 Clock Source(TH2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> TL2OF (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode2_TH2_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Note:If capture source dectect edge select ignored,timer2 TH2 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer2 external inputs, that causes the current value in the timer2 registers, TH2 ,to be captured into registers RCAP2H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF2 in T2CON to be set, and the EXF2 bit (like TF2) can generate an interrupt which vectors to the same location as Timer2 overflow interrupt.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode2_TH2 0

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Mode2_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode2_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Mode2_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode2_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode2_Overflow_Flag_Ignored 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer2 external inputs, that causes timer2 TL2 8 bit timer or counter stop ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode2_TR2LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Mode2_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Mode2_TR2L_Run 0

//      </e>  //Split Mode2 Two 8Bit Timer/Counter Capture Enable

//===========================================================
//      <e> Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero Enable
//      <i> Split mode 3 two 8Bit timer/counter capture with auto zero enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = TL2CKI/(256-TL2)
//      <i>After first run => T2OF = TL2CKI/(256-RCAP2L)
        #define TIMER2_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.2 or p6.7 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode3_Clock_Output_Enable 0

//          <o>TH2 Clock Source(TH2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> Reserved (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode3_TH2_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Note:If capture source dectect edge select ignored,timer2 TH2 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer2 external inputs, that causes the current value in the timer 2 registers, TH2 ,to be captured into registers RCAP2H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF2 in T2CON to be set, and the EXF2 bit (like TF2) can generate an interrupt which vectors to the same location as Timer2 overflow interrupt.
//          <i>Note:Timer2 split mode3 is the similar function with timer2 split mode 2. There is one difference that the capture source trigger(T2EXES), EXF2 event set signal, not only is the capture source of Timer2 but also clears the content of TH2 to 0x00H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode3_TH2 0

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Mode3_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode3_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Mode3_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> Reserved (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode3_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode3_Overflow_Flag_Ignored 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer2 external inputs, that causes timer2 TL2 8 bit timer or counter stop ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode3_TR2LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Mode3_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Mode3_TR2L_Run 0

//      </e>  //Split Mode3 Two 8Bit Timer/Counter Capture with Auto Zero Enable

//===========================================================
//      <e> Split Mode 4 8Bit Pwm
//      <i> Split mode 4 8Bit pwm.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = T2CKI/(256-TH2)
//      <i>After first run => T2OF = T2CKI/(256-RCAP2H)
        #define TIMER2_Split_Mode4_8Bit_Pwm 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.0 or p6.0 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode4_Clock_Output_Enable 0

//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> Reserved (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode4_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>TH2 and RCAP2H are combined to an 8-bit auto-reload counter.
//          <i>TH2 and RCAP2H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode4_TH2 0

//          <o>Initialize RCAP2H Reload Value (0~255) <0-255>
//          <i>Setting RCAP2H.
//          <i>TH2 and RCAP2H are combined to an 8-bit auto-reload counter.
//          <i>TH2 and RCAP2H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow).
            #define TIMER2_Split_Mode4_RCAP2H 0

//          <o>Initialize TL2 PWM Compare Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>TL2 is the PWM compare register to generate PWM waveform.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode4_TL2 0

//          <o>Timer PWM Compare Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>RCAP2L is the PWM buffer register and software will update PWM data in this register. Each TH2 overflow event will set TF2 and load RCAP2L value into TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval low byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow).
            #define TIMER2_Split_Mode4_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> Reserved (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode4_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode4_Overflow_Flag_Ignored 0

//          <o>Timer2 T2CKO Invert
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode4_T2CKO_Invert 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode4_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable  (TR2=1)
            #define TIMER2_Split_Mode4_TR2_Run 0

//      </e>  //Split Mode4 Two 8Bit Pwm

//===========================================================
//      <e>Split Mode 6 Duty Capture Enable
//      <i>Split Mode 6 duty capture enable.
//      <i>T2OF period will be stop by duty capture finish.
        #define TIMER2_Split_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T2OE=0)(Default)
//              <1=>Enable (T2OE=1)
//          <i>Note:T2OE=1,gpio wizard p1.0 or p3.0 or p6.0 or p4.5 select T2CKO.
            #define TIMER2_Split_Mode6_Clock_Output_Enable 0

//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Mode6_Capture_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Split_Mode6_TH2 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Mode6_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Mode6_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Mode6_RCAP2L 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer2 external inputs, that causes timer2 TL2 8 bit timer or counter stop ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Mode6_TR2LC 0

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Mode6_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Mode6_TR2L_Run 0
//      </e>  //Mode6 Duty Capture Enable

//===========================================================
//      <e>Baud-Rate Generator Mode Enable
//      <i>Baud-Rate generator mode enable.
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = T2CKI/(65536-[TH2:TL2])
//      <i>After first run => T2OF = T2CKI/(65536-[RCAP2H:RCAP2L])
        #define TIMER2_Baud_Rate_Generator 0
//===========================================================
//          <o>Clock Source(T2CKI)
//              <0x00=> SYSCLK/2 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> INT0ET (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Baud_Rate_Generator_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Baud_Rate_Generator_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH2(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Baud_Rate_Generator_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP2H(16Bits value high byte) & RCAP2L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16 bit timer overflow),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER2_Baud_Rate_Generator_Reload_Value 0

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable  (TF2IG=1)
            #define TIMER2_Baud_Rate_Generator_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Baud_Rate_Generator_Capture_Source_Dectect_Edge 0x00

//          <o>16Bits Timer/Counter Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Baud_Rate_Generator_16Bit_TR2_Run 0

//      </e>  //Baud-Rate Generator Mode Enable

//===========================================================
//      <e> Split Baud-Rate Generator Mode Enable
//      <i> Split Baud-Rate Generator Mode Enable
//      <i>T2OF (Hz) :
//      <i>First run => T2OF = TL2CKI/(256-TL2)
//      <i>After first run => T2OF = TL2CKI/(256-RCAP2L)
        #define TIMER2_Split_Baud_Rate_Generator 0
//===========================================================
//          <o>TH2 Clock Source(TH2CKI)
//              <0x00=> SYSCLK/12 (T2CKS=0,T2X12=0,C_T2=0)(Default)
//              <0x01=> T2 Pin (T2CKS=0,T2X12=0,C_T2=1)
//              <0x02=> SYSCLK (T2CKS=0,T2X12=1,C_T2=0)
//              <0x03=> TL2OF (T2CKS=0,T2X12=1,C_T2=1)
//              <0x04=> S0TOF (T2CKS=1,T2X12=0,C_T2=0)
//              <0x05=> T0OF (T2CKS=1,T2X12=0,C_T2=1)
//              <0x06=> AC0ES (T2CKS=1,T2X12=1,C_T2=0)
//              <0x07=> KBIET (T2CKS=1,T2X12=1,C_T2=1)
            #define TIMER2_Split_Baud_Rate_Generator_TH2_Clock_Source 0x00

//          <o>Initialize TH2 Counter Value (0~255) <0-255>
//          <i>Setting TH2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Baud_Rate_Generator_TH2 0

//          <o>Initialize RCAP2H Reload Value (0~255) <0-255>
//          <i>Setting RCAP2H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte Reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow).
            #define TIMER2_Split_Baud_Rate_Generator_RCAP2H 0

//          <o>TL2 Clock Source(TL2CKI)
//              <0x00=> SYSCLK/12 (TL2CS=0,TL2X12=0)(Default)
//              <0x01=> SYSCLK (TL2CS=0,TL2X12=0)
//              <0x02=> S0TOF (TL2CS=0,TL2X12=1)
//              <0x03=> INT0ET (TL2CS=0,TL2X12=1)
            #define TIMER2_Split_Baud_Rate_Generator_TL2_Clock_Source 0x00

//          <o>Initialize TL2 Counter Value (0~255) <0-255>
//          <i>Setting TL2.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER2_Split_Baud_Rate_Generator_TL2 0

//          <o>Initialize RCAP2L Reload Value (0~255) <0-255>
//          <i>Setting RCAP2L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER2_Split_Baud_Rate_Generator_RCAP2L 0

//          <o>Capture Source
//              <0x00=> T2EX Pin (CP2S2=0,CP2S1=0,CP2S0=0)(Default)
//              <0x01=> RXD0 (CP2S2=0,CP2S1=0,CP2S0=1)
//              <0x02=> P60 (CP2S2=0,CP2S1=1,CP2S0=0)
//              <0x03=> INT2ET (CP2S2=0,CP2S1=1,CP2S0=1)
//              <0x04=> ILRCO (CP2S2=1,CP2S1=0,CP2S0=0)
//              <0x05=> AC0OUT (CP2S2=1,CP2S1=0,CP2S0=1)
//              <0x06=> KBIET (CP2S2=1,CP2S1=1,CP2S0=0)
//              <0x07=> TWI0_SCL (CP2S2=1,CP2S1=1,CP2S0=1)
            #define TIMER2_Split_Baud_Rate_Generator_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER2_Split_Baud_Rate_Generator_Overflow_Flag_Ignored 0

//          <o>TL2 Timer/counter Stop
//          <i>Note:TL2 stop by TH2 overflow.When TH2 over flow ,TR2L=0.
//              <0=>Disable (TR2LC=0)(Default)
//              <1=>Enable (TR2LC=1)
            #define TIMER2_Split_Baud_Rate_Generator_TL2LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN2=0,T2EXH=0)(Default)
//              <0x01=>Rising (EXEN2=0,T2EXH=1)
//              <0x02=>Falling (EXEN2=1,T2EXH=0)
//              <0x03=>Dual (EXEN2=1,T2EXH=1)
            #define TIMER2_Split_Baud_Rate_Generator_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH2 Run
//              <0=>Disable (TR2=0)(Default)
//              <1=>Enable (TR2=1)
            #define TIMER2_Split_Baud_Rate_Generator_TR2_Run 0

//          <o>8Bit Timer/Counter TL2 Run
//              <0=>Disable (TR2L=0)(Default)
//              <1=>Enable (TR2L=1)
            #define TIMER2_Split_Baud_Rate_Generator_TR2L_Run 0

//      </e>  //Split mode0 two 8Bit timer auto-reload and external interrupt Enable

//  </e>  //Timer2 Enable

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  <e>Timer3 Enable
//  <i>Mode0 16bit timer/counter auto-reload and external interrupt.
//  <i>Mode1 16bit timer/counter auto-reload with external interrupt.
//  <i>Mode2 16bit timer/counter capture.
//  <i>Mode3 16bit timer/counter capture auto_zero.
//  <i>Mode6 Duty Capture.
//  <i>Spilt mode0 two 8Bit timer/counter auto-reload and external interrupt.
//  <i>Spilt mode1 two 8Bit timer/counter auto-reload with external interrupt.
//  <i>Spilt mode2 two 8Bit timer/counter capture.
//  <i>Spilt mode3 two 8Bit timer/counter capture with auto zero.
//  <i>Spilt mode4 two 8Bit pwm.
//  <i>Spilt mode6 duty capture.
//  <i>Baud-Rate Generator
    #define TM3_Wizard_init_EN 0
//      <o>Mode
//          <0x00=>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt (T3SPL=0,T3MS1=0,CP/RL3=0,T3MS0=0)(Default)
//          <0x01=>Mode 1 16Bit Timer/Counter Auto-Reload with External Interrupt (T3SPL=0,T3MS1=0,CP/RL3=0,T3MS0=1)
//          <0x02=>Mode 2 16Bit Timer/Counter Capture (T3SPL=0,T3MS1=0,CP/RL3=1,T3MS0=0)
//          <0x03=>Mode 3 16Bit Timer/Counter Capture Auto_Zero(T3SPL=0,T3MS1=0,CP/RL3=1,T3MS0=1)
//          <0x09=>Mode 6 Duty Capture(T3SPL=0,T3MS1=1,CP/RL3=1,T3MS0=0)
//          <0x04=>Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt (T3SPL=1,T3MS1=0,CP/RL3=0,T3MS0=0)
//          <0x05=>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt (T3SPL=1,T3MS1=0,CP/RL3=0,T3MS0=1)
//          <0x06=>Split Mode 2 Two 8Bit Timer/Counter Capture (T3SPL=1,T3MS1=0,CP/RL3=1,T3MS0=0)
//          <0x07=>Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero (T3SPL=1,T3MS1=0,CP/RL3=1,T3MS0=1)
//          <0x08=>Split Mode 4 8Bit Pwm (T3SPL=1,T3MS1=1,CP/RL3=0,T3MS0=0)
//          <0x0A=>Split Mode 6 Duty Capture(T3SPL=1,T3MS1=1,CP/RL3=1,T3MS0=0)
        #define TIMER3_Mode  0x00

//===========================================================
//      <e>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i>Mode 0 16bit auto-reload and external interrupt enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = T3CKI/(65536-[TH3:TL3])
//      <i>After first run => T3OF = T3CKI/(65536-[RCAP3H:RCAP3L])
        #define TIMER3_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable  (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.3 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Mode0_Clock_Output_Enable 0

//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> INT1ET (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Mode0_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Mode0_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH3(16Bits value high byte) & TL3(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode0_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP3H(16Bits value high byte) & RCAP3L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16 bit timer overflow),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode0_16Bits_Reload_Value 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable  (TF3IG=1)
            #define TIMER3_Mode0_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>16Bits Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Mode0_16Bit_TR3_Run 0

//      </e>  //Mode0 16Bit Auto-Reload and External Interrupt Enable

//===========================================================
//      <e>Mode 1 16Bit Auto-Reload with External Interrupt Enable
//      <i>Mode 1 16bit timer auto-reload with external interrupt enable.
//      <i>T3OF period will be changed when capture value to RCAP3 buffer.
        #define TIMER3_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> INT1ET (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Mode1_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Mode1_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH3(16Bits value high byte) & TL3(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode1_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP3H(16Bits value high byte) & RCAP3L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16bit timer/counter overflow or capture source dectect edge),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode1_16Bits_Reload_Value 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Mode1_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Mode1_TR3_Run 0

//      </e>  //Mode 1 16Bit Auto-Reload with External Interrupt Enable

//===========================================================
//      <e>Mode 2 16Bit Timer/Counter Capture Enable
//      <i>Mode 2 16bit timer/counter capture enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = T3CKI/(65536-[TH3:TL3])
//      <i>After first run => T3OF = T3CKI/65536
        #define TIMER3_Mode2_16Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> INT1ET (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Mode2_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Mode2_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH3(16Bits value high byte) & TL3(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,TIMER3 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer3 external inputs, that causes the current value in the timer3 registers, TH3 and TL3,to be captured into registers RCAP3H and RCAP3L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF3 in T3CON to be set, and the EXF3 bit (like TF3) can generate an interrupt which vectors to the same location as Timer3 overflow interrupt.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode2_16Bits_Counter_Value 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Mode2_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Mode2_TR3_Run 0

//      </e>  //Mode 2 16Bit Timer/Counter Capture Enable

//===========================================================
//      <e>Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable
//      <i>Mode 3 16bit timer/counter capture with auto zero enable.
//      <i>T3OF period will be changed when capture value to RCAP3 buffer.
        #define TIMER3_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero 0
//===========================================================
//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> INT1ET (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Mode3_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Mode3_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH3(16Bits value high byte) & TL2(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,TIMER3 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer3 external inputs, that causes the current value in the timer3 registers, TH3 and TL3,to be captured into registers RCAP3H and RCAP3L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF3 in T3CON to be set, and the EXF3 bit (like TF3) can generate an interrupt which vectors to the same location as Timer3 overflow interrupt.
//          <i>Note:Timer3 mode3 is the similar function with timer3 mode2. There is one difference that the capture source trigger(T3EXES), EXF3 event set signal, not only is the capture source of Timer3 but also clears the content of TL3 and TH3 to 0x0000H.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode3_16Bits_Counter_Value 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Mode3_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Mode3_TR3_Run 0

//      </e>  //Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable

//===========================================================
//      <e>Mode 6 Duty Capture Enable
//      <i>Mode 6 duty capture enable.
//      <i>T3OF period will be stop by duty capture finish.
        #define TIMER3_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> INT1ET (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Mode6_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH3(16Bits value high byte) & TL3(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Mode6_16Bits_Counter_Value 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Mode6_TR3_Run 0

//      </e>  //Mode6 Duty Capture Enable

//===========================================================
//      <e>Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i>Split mode 0 two 8Bit timer/counter auto-reload and external interrupt enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = TL3CKI/(256-TL3)
//      <i>After first run => T3OF = TL3CKI/(256-RCAP3L)
        #define TIMER3_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode0_Clock_Output_Enable 0

//          <o>TH3 Clock Source(TH3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode0_TH3_Clock_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode0_TH3 0

//          <o>Initialize RCAP3H Reload Value (0~255) <0-255>
//          <i>Setting RCAP3H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte Reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH2 overflow).
            #define TIMER3_Split_Mode0_RCAP3H 0

//          <o>TL3 Clock Source(TL3CKI)
//              <0x00=> SYSCLK/12 (TL3CS=0,TL3X12=0)(Default)
//              <0x01=> SYSCLK (TL3CS=0,TL3X12=1)
//              <0x02=> S0TOF (TL3CS=1,TL3X12=0)
//              <0x03=> INT1ET (TL3CS=1,TL3X12=1)
            #define TIMER3_Split_Mode0_TL3_Clock_Source 0x00

//          <o>Initialize TL3 Counter Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode0_TL3 0

//          <o>Initialize RCAP3L Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER3_Split_Mode0_RCAP3L 0

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode0_Capture_Source 0x00

//          <o>Timer2 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Split_Mode0_Overflow_Flag_Ignored 0

//          <o>TL3 Timer/counter Stop
//          <i>Note:TL3 stop by TH3 overflow.When TH3 over flow ,TR3L=0.
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode0_TL3LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH3 Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Split_Mode0_TR3_Run 0

//          <o>8Bit Timer/Counter TL3 Run
//              <0=>Disable (TR3L=0)(Default)
//              <1=>Enable (TR3L=1)
            #define TIMER3_Split_Mode0_TR3L_Run 0

//      </e>  //Split mode0 two 8Bit timer auto-reload and external interrupt Enable

//===========================================================
//      <e>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt Enable
//      <i>Split mode 1 two 8Bit timer/counter auto-reload with external interrupt enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = TL3CKI/(256-TL3)
//      <i>After first run => T3OF = TL3CKI/(256-RCAP3L)
        #define TIMER3_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode1_Clock_Output_Enable 0

//          <o>TH3 Clock Source(TH3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode1_TH3_Clock_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode1_TH3 0

//          <o>Initialize RCAP3H Reload Value (0~255) <0-255>
//          <i>Setting RCAP3H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH3 overflow or capture source dectect edge).
            #define TIMER3_Split_Mode1_RCAP3H 0

//          <o>TL3 Clock Source(TL3CKI)
//              <0x00=> SYSCLK/12 (TL3CS=0,TL3X12=0)(Default)
//              <0x01=> SYSCLK (TL3CS=0,TL3X12=1)
//              <0x02=> S0TOF (TL3CS=1,TL3X12=0)
//              <0x03=> INT1ET (TL3CS=1,TL3X12=1)
            #define TIMER3_Split_Mode1_TL3_Clock_Source 0x00

//          <o>Initialize TL3 Counter Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode1_TL3 0

//          <o>Initialize RCAP3L Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL3 overflow).
            #define TIMER3_Split_Mode1_RCAP3L 0

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode1_Capture_Source 0x00

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Split_Mode1_Overflow_Flag_Ignored 0

//          <o>TL3 Timer/counter Stop
//          <i>Note:TL3 stop by TH3 overflow.When TH3 over flow ,TR3L=0.
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode1_TR3LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH3 Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Split_Mode1_TR3_Run 0

//          <o>8Bit Timer/Counter TL3 Run
//              <0=>Disable (TR3L=0)(Default)
//              <1=>Enable (TR3L=1)
            #define TIMER3_Split_Mode1_TR3L_Run 0

//      </e>  //Split Mode1 Two 8Bit Timer Auto-Reload and External Interrupt Enable

//===========================================================
//      <e>Split Mode 2 Two 8Bit Timer/Counter Capture Enable
//      <i>Split mode 2 two 8Bit timer/counter Capture enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = TL3CKI/(256-TL3)
//      <i>After first run => T3OF = TL3CKI/(256-RCAP3L)
        #define TIMER3_Split_Mode2_Two_8Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode2_Clock_Output_Enable 0

//          <o>TH3 Clock Source(TH3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode2_TH3_Clock_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>Note:If capture source dectect edge select ignored,TIMER3 TH2 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, TIMER3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 TIMER3 external inputs, that causes the current value in the timer3 registers, TH3 ,to be captured into registers RCAP3H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF3 in T3CON to be set, and the EXF3 bit (like TF3) can generate an interrupt which vectors to the same location as Timer3 overflow interrupt.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode2_TH3 0

//          <o>TL3 Clock Source(TL3CKI)
//              <0x00=> SYSCLK/12 (TL3CS=0,TL3X12=0)(Default)
//              <0x01=> SYSCLK (TL3CS=0,TL3X12=1)
//              <0x02=> S0TOF (TL3CS=1,TL3X12=0)
//              <0x03=> INT1ET (TL3CS=1,TL3X12=1)
            #define TIMER3_Split_Mode2_TL3_Clock_Source 0x00

//          <o>Initialize TL3 Counter Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode2_TL3 0

//          <o>Initialize RCAP3L Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL3 overflow).
            #define TIMER3_Split_Mode2_RCAP3L 0

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode2_Capture_Source 0x00

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Split_Mode2_Overflow_Flag_Ignored 0

//          <o>TL3 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer2 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer3 external inputs, that causes timer3 TL3 8 bit timer or counter stop ,TR3L=0.
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode2_TR3LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH3 Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Split_Mode2_TR3_Run 0

//          <o>8Bit Timer/Counter TL3 Run
//              <0=>Disable (TR3L=0)(Default)
//              <1=>Enable (TR3L=1)
            #define TIMER3_Split_Mode2_TR3L_Run 0

//      </e>  //Split Mode2 Two 8Bit Timer/Counter Capture Enable

//===========================================================
//      <e>Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero Enable
//      <i>Split mode 3 two 8Bit timer/counter capture with auto zero enable.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = TL3CKI/(256-TL3)
//      <i>After first run => T3OF = TL3CKI/(256-RCAP3L)
        #define TIMER3_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode3_Clock_Output_Enable 0

//          <o>TH3 Clock Source(TH3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode3_TH3_Clock_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>Note:If capture source dectect edge select ignored,TIMER3 TH3 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, TIMER3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 TIMER3 external inputs, that causes the current value in the timer3 registers, TH3 ,to be captured into registers RCAP3H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF3 in T3CON to be set, and the EXF3 bit (like TF3) can generate an interrupt which vectors to the same location as Timer3 overflow interrupt.
//          <i>Note:TIMER3 split mode3 is the similar function with TIMER3 split mode2. There is one difference that the capture source trigger(T3EXES), EXF3 event set signal, not only is the capture source of Timer3 but also clears the content of TH3 to 0x00H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode3_TH3 0

//          <o>TL3 Clock Source(TL3CKI)
//              <0x00=> SYSCLK/12 (TL3CS=0,TL3X12=0)(Default)
//              <0x01=> SYSCLK (TL3CS=0,TL3X12=1)
//              <0x02=> S0TOF (TL3CS=1,TL3X12=0)
//              <0x03=> INT1ET (TL3CS=1,TL3X12=1)
            #define TIMER3_Split_Mode3_TL3_Clock_Source 0x00

//          <o>Initialize TL3 Counter Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode3_TL3 0

//          <o>Initialize RCAP3L Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL3 overflow).
            #define TIMER3_Split_Mode3_RCAP3L 0

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode3_Capture_Source 0x00

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Split_Mode3_Overflow_Flag_Ignored 0

//          <o>TL3 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer3 external inputs, that causes timer3 TL3 8 bit timer or counter stop ,TR3L=0.
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode3_TR3LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH3 Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Split_Mode3_TR3_Run 0

//          <o>8Bit Timer/Counter TL3 Run
//              <0=>Disable (TR3L=0)(Default)
//              <1=>Enable (TR3L=1)
            #define TIMER3_Split_Mode3_TR3L_Run 0

//      </e>  //Split Mode3 Two 8Bit Timer/Counter Capture with Auto Zero Enable

//===========================================================
//      <e>Split Mode 4 8Bit Pwm
//      <i>Split mode 4 8Bit pwm.
//      <i>T3OF (Hz) :
//      <i>First run => T3OF = T3CKI/(256-TH3)
//      <i>After first run => T3OF = T3CKI/(256-RCAP3H)
        #define TIMER3_Split_Mode4_8Bit_Pwm 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode4_Clock_Output_Enable 0

//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode4_Clock_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>TH3 and RCAP3H are combined to an 8-bit auto-reload counter.
//          <i>TH3 and RCAP3H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode4_TH3 0

//          <o>Initialize RCAP3H Reload Value (0~255) <0-255>
//          <i>Setting RCAP3H.
//          <i>TH3 and RCAP3H are combined to an 8-bit auto-reload counter.
//          <i>TH3 and RCAP3H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH3 overflow).
            #define TIMER3_Split_Mode4_RCAP3H 0

//          <o>Initialize TL3 PWM Compare Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>TL3 is the PWM compare register to generate PWM waveform.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode4_TL3 0

//          <o>Timer PWM Compare Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>RCAP3L is the PWM buffer register and software will update PWM data in this register. Each TH3 overflow event will set TF3 and load RCAP3L value into TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval low byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH3 overflow).
            #define TIMER3_Split_Mode4_RCAP3L 0

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode4_Capture_Source 0x00

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF3IG=0)(Default)
//              <1=>Enable (TF3IG=1)
            #define TIMER3_Split_Mode4_Overflow_Flag_Ignored 0

//          <o>Timer3 T3CKO Invert
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode4_T3CKO_Invert 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode4_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable  (TR3=1)
            #define TIMER3_Split_Mode4_TR3_Run 0

//      </e>  //Split Mode4 Two 8Bit Pwm

//===========================================================
//      <e>Split Mode 6 Duty Capture Enable
//      <i>Split Mode 6 duty capture enable.
//      <i>T3OF period will be stop by duty capture finish.
        #define TIMER3_Split_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T3OE=0)(Default)
//              <1=>Enable (T3OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER3_Split_Mode6_Clock_Output_Enable 0

//          <o>Clock Source(T3CKI)
//              <0x00=> SYSCLK/12 (T3CKS=0,T3X12=0,C_T3=0)(Default)
//              <0x01=> T3 Pin (T3CKS=0,T3X12=0,C_T3=1)
//              <0x02=> SYSCLK (T3CKS=0,T3X12=1,C_T3=0)
//              <0x03=> TL3OF (T3CKS=0,T3X12=1,C_T3=1)
//              <0x04=> S1TOF (T3CKS=1,T3X12=0,C_T3=0)
//              <0x05=> T0OF (T3CKS=1,T3X12=0,C_T3=1)
//              <0x06=> AC1ES (T3CKS=1,T3X12=1,C_T3=0)
//              <0x07=> T1OF (T3CKS=1,T3X12=1,C_T3=1)
            #define TIMER3_Split_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T3EX Pin (CP3S2=0,CP3S1=0,CP3S0=0)(Default)
//              <0x01=> INT0ET (CP3S2=0,CP3S1=0,CP3S0=1)
//              <0x02=> P60 (CP3S2=0,CP3S1=1,CP3S0=0)
//              <0x03=> nSS Pin (CP3S2=0,CP3S1=1,CP3S0=1)
//              <0x04=> KBIET (CP3S2=1,CP3S1=0,CP3S0=0)
//              <0x05=> AC0OUT (CP3S2=1,CP3S1=0,CP3S0=1)
//              <0x06=> AC1OUT (CP3S2=1,CP3S1=1,CP3S0=0)
//              <0x07=> ILRCO (CP3S2=1,CP3S1=1,CP3S0=1)
            #define TIMER3_Split_Mode6_Capture_Source 0x00

//          <o>Initialize TH3 Counter Value (0~255) <0-255>
//          <i>Setting TH3.
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER3_Split_Mode6_TH3 0

//          <o>Timer3 Overflow Flag Ignored
//              <0=>Disable (TF2IG=0)(Default)
//              <1=>Enable (TF2IG=1)
            #define TIMER3_Split_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN3=0,T3EXH=0)(Default)
//              <0x01=>Rising (EXEN3=0,T3EXH=0)
//              <0x02=>Falling (EXEN3=0,T3EXH=0)
//              <0x03=>Dual (EXEN3=0,T3EXH=0)
            #define TIMER3_Split_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>TL3 Clock Source(TL3CKI)
//              <0x00=> SYSCLK/12 (TL3CS=0,TL3X12=0)(Default)
//              <0x01=> SYSCLK (TL3CS=0,TL3X12=1)
//              <0x02=> S0TOF (TL3CS=1,TL3X12=0)
//              <0x03=> INT1ET (TL3CS=1,TL3X12=1)
            #define TIMER3_Split_Mode6_TL3_Clock_Source 0x00

//          <o>Initialize TL3 Counter Value (0~255) <0-255>
//          <i>Setting TL3.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER3_Split_Mode6_TL3 0

//          <o>Initialize RCAP3L Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER3_Split_Mode6_RCAP3L 0

//          <o>TL3 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer3 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer3 external inputs, that causes timer3 TL3 8 bit timer or counter stop ,TR3L=0.
//              <0=>Disable (TR3LC=0)(Default)
//              <1=>Enable (TR3LC=1)
            #define TIMER3_Split_Mode6_TR3LC 0

//          <o>8Bit Timer/Counter TH3 Run
//              <0=>Disable (TR3=0)(Default)
//              <1=>Enable (TR3=1)
            #define TIMER3_Split_Mode6_TR3_Run 0

//          <o>8Bit Timer/Counter TL3 Run
//              <0=>Disable (TR3L=0)(Default)
//              <1=>Enable (TR3L=1)
            #define TIMER3_Split_Mode6_TR3L_Run 0
//      </e>  //Mode6 Duty Capture Enable
//  </e>  //Timer3 Enable

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  <e>Timer4 Enable
//  <i>Mode0 16bit timer/counter auto-reload and external interrupt.
//  <i>Mode1 16bit timer/counter auto-reload with external interrupt.
//  <i>Mode2 16bit timer/counter capture.
//  <i>Mode3 16bit timer/counter capture auto_zero.
//  <i>Mode6 Duty Capture.
//  <i>Spilt mode0 two 8Bit timer/counter auto-reload and external interrupt.
//  <i>Spilt mode1 two 8Bit timer/counter auto-reload with external interrupt.
//  <i>Spilt mode2 two 8Bit timer/counter capture.
//  <i>Spilt mode3 two 8Bit timer/counter capture with auto zero.
//  <i>Spilt mode4 two 8Bit pwm.
//  <i>Spilt mode6 duty capture.
    #define TM4_Wizard_init_EN 0
//      <o>Mode
//          <0x00=>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt (T4SPL=0,T4MS1=0,CP/RL4=0,T4MS0=0)(Default)
//          <0x01=>Mode 1 16Bit Timer/Counter Auto-Reload with External Interrupt (T4SPL=0,T4MS1=0,CP/RL4=0,T4MS0=1)
//          <0x02=>Mode 2 16Bit Timer/Counter Capture (T4SPL=0,T4MS1=0,CP/RL4=1,T4MS0=0)
//          <0x03=>Mode 3 16Bit Timer/Counter Capture Auto_Zero(T4SPL=0,T4MS1=0,CP/RL4=1,T4MS0=1)
//          <0x09=>Mode 6 Duty Capture(T4SPL=0,T4MS1=1,CP/RL4=1,T4MS0=0)
//          <0x04=>Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt (T4SPL=1,T4MS1=0,CP/RL4=0,T4MS0=0)
//          <0x05=>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt (T4SPL=1,T4MS1=0,CP/RL4=0,T4MS0=1)
//          <0x06=>Split Mode 2 Two 8Bit Timer/Counter Capture (T4SPL=1,T4MS1=0,CP/RL4=1,T4MS0=0)
//          <0x07=>Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero (T4SPL=1,T4MS1=0,CP/RL4=1,T4MS0=1)
//          <0x08=>Split Mode 4 8Bit Pwm (T4SPL=1,T4MS1=1,CP/RL4=0,T4MS0=0)
//          <0x0A=>Split Mode 6 Duty Capture(T4SPL=1,T4MS1=1,CP/RL4=1,T4MS0=0)
        #define TIMER4_Mode  0x00

//===========================================================
//      <e>Mode 0 16Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i>Mode 0 16bit auto-reload and external interrupt enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = T4CKI/(65536-[TH4:TL4])
//      <i>After first run => T4OF = T4CKI/(65536-[RCAP4H:RCAP4L])
        #define TIMER4_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable  (T4OE=1)
//          <i>Note:T4OE=1,gpio wizard p7.0 or p3.7 or p7.2 or p3.6 select T4CKO.
            #define TIMER4_Mode0_Clock_Output_Enable 0

//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> INT2ET (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Mode0_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Mode0_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH4(16Bits value high byte) & TL4(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode0_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP4H(16Bits value high byte) & RCAP4L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16 bit timer overflow),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode0_16Bits_Reload_Value 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable  (TF4IG=1)
            #define TIMER4_Mode0_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>16Bits Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Mode0_16Bit_TR4_Run 0

//      </e>  //Mode0 16Bit Auto-Reload and External Interrupt Enable

//===========================================================
//      <e>Mode 1 16Bit Auto-Reload with External Interrupt Enable
//      <i>Mode 1 16bit timer auto-reload with external interrupt enable.
//      <i>T4OF period will be changed when capture value to RCAP4 buffer.
        #define TIMER4_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> INT2ET (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Mode1_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Mode1_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH4(16Bits value high byte) & TL4(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode1_16Bits_Counter_Value 0

//          <o>Initialize 16Bits Reload Value (0~65535) <0-65535>
//          <i>Setting RCAP4H(16Bits value high byte) & RCAP4L(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval reload =1(auto reload by 16bit timer/counter overflow or capture source dectect edge),Timer interval=1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode1_16Bits_Reload_Value 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Mode1_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Mode1_TR4_Run 0

//      </e>  //Mode 1 16Bit Auto-Reload with External Interrupt Enable

//===========================================================
//      <e>Mode 2 16Bit Timer/Counter Capture Enable
//      <i>Mode 2 16bit timer/counter capture enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = T4CKI/(65536-[TH4:TL4])
//      <i>After first run => T4OF = T4CKI/65536
        #define TIMER4_Mode2_16Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> INT2ET (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Mode2_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Mode2_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH4(16Bits value high byte) & TL4(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,TIMER4 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer4 external inputs, that causes the current value in the timer4 registers, TH4 and TL4,to be captured into registers RCAP4H and RCAP4L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF4 in T4CON to be set, and the EXF4 bit (like TF4) can generate an interrupt which vectors to the same location as Timer4 overflow interrupt.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode2_16Bits_Counter_Value 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Mode2_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Mode2_TR4_Run 0

//      </e>  //Mode 2 16Bit Timer/Counter Capture Enable

//===========================================================
//      <e>Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable
//      <i>Mode 3 16bit timer/counter capture with auto zero enable.
//      <i>T4OF period will be changed when capture value to RCAP4 buffer.
        #define TIMER4_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero 0
//===========================================================
//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> INT2ET (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Mode3_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Mode3_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH4(16Bits value high byte) & TL4(16Bits value low byte).
//          <i>Note:If capture source dectect edge select ignored,TIMER4 is a 16 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual,timer4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer4 external inputs, that causes the current value in the timer4 registers, TH4 and TL4,to be captured into registers RCAP4H and RCAP4L(capture reload registers),respectively.
//          <i>Note:In addition, the transition at capture source input causes bit EXF4 in T4CON to be set, and the EXF4 bit (like TF4) can generate an interrupt which vectors to the same location as Timer4 overflow interrupt.
//          <i>Note:Timer4 mode3 is the similar function with timer4 mode2. There is one difference that the capture source trigger(T4EXES), EXF4 event set signal, not only is the capture source of Timer4 but also clears the content of TL4 and TH4 to 0x0000H.
//          <i>Example: for 16 bit timer or counter
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode3_16Bits_Counter_Value 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Mode3_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Mode3_TR4_Run 0

//      </e>  //Mode 3 16Bit Timer/Counter Capture With Auto Zero Enable

//===========================================================
//      <e>Mode 6 Duty Capture Enable
//      <i>Mode 6 duty capture enable.
//      <i>T4OF period will be stop by duty capture finish.
        #define TIMER4_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> INT2ET (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Mode6_Capture_Source 0x00

//          <o>Initialize Counter 16Bits Value (0~65535) <0-65535>
//          <i>Setting TH4(16Bits value high byte) & TL4(16Bits value low byte).
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Mode6_16Bits_Counter_Value 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>16Bit Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Mode6_TR4_Run 0

//      </e>  //Mode6 Duty Capture Enable

//===========================================================
//      <e>Split Mode 0 Two 8Bit Timer/Counter Auto-Reload and External Interrupt Enable
//      <i>Split mode 0 two 8Bit timer/counter auto-reload and external interrupt enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = TL4CKI/(256-TL4)
//      <i>After first run => T4OF = TL4CKI/(256-RCAP4L)
        #define TIMER4_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable  (T4OE=1)
//          <i>Note:T4OE=1,gpio wizard p7.0 or p3.7 or p7.2 or p3.6 select T4CKO.
            #define TIMER4_Split_Mode0_Clock_Output_Enable 0

//          <o>TH4 Clock Source(TH4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode0_TH4_Clock_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode0_TH4 0

//          <o>Initialize RCAP4H Reload Value (0~255) <0-255>
//          <i>Setting RCAP4H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval High Byte Reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH4 overflow).
            #define TIMER4_Split_Mode0_RCAP4H 0

//          <o>TL4 Clock Source(TL4CKI)
//              <0x00=> SYSCLK/12 (TL4CS=0,TL4X12=0)(Default)
//              <0x01=> SYSCLK (TL4CS=0,TL4X12=1)
//              <0x02=> xxx (TL4CS=1,TL4X12=0)
//              <0x03=> INT2ET (TL4CS=1,TL4X12=1)
            #define TIMER4_Split_Mode0_TL4_Clock_Source 0x00

//          <o>Initialize TL4 Counter Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode0_TL4 0

//          <o>Initialize RCAP4L Reload Value (0~255) <0-255>
//          <i>Setting RCAP4L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL4 overflow).
            #define TIMER4_Split_Mode0_RCAP4L 0

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode0_Capture_Source 0x00

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode0_Overflow_Flag_Ignored 0

//          <o>TL4 Timer/counter Stop
//          <i>Note:TL4 stop by TH4 overflow.When TH4 over flow ,TR4L=0.
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode0_TL4LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode0_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH4 Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Split_Mode0_TR4_Run 0

//          <o>8Bit Timer/Counter TL4 Run
//              <0=>Disable (TR4L=0)(Default)
//              <1=>Enable (TR4L=1)
            #define TIMER4_Split_Mode0_TR4L_Run 0

//      </e>  //Split mode0 two 8Bit timer auto-reload and external interrupt Enable

//===========================================================
//      <e>Split Mode 1 Two 8Bit Timer/Counter Auto-Reload with External Interrupt Enable
//      <i>Split mode 1 two 8Bit timer/counter auto-reload with external interrupt enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = TL4CKI/(256-TL4)
//      <i>After first run => T4OF = TL4CKI/(256-RCAP4L)
        #define TIMER4_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable  (T4OE=1)
//          <i>Note:T4OE=1,gpio wizard p7.0 or p3.7 or p7.2 or p3.6 select T4CKO.
            #define TIMER4_Split_Mode1_Clock_Output_Enable 0

//          <o>TH4 Clock Source(TH4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode1_TH4_Clock_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode1_TH4 0

//          <o>Initialize RCAP4H Reload Value (0~255) <0-255>
//          <i>Setting RCAP4H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH4 overflow or capture source dectect edge).
            #define TIMER4_Split_Mode1_RCAP4H 0

//          <o>TL4 Clock Source(TL4CKI)
//              <0x00=> SYSCLK/12 (TL4CS=0,TL4X12=0)(Default)
//              <0x01=> SYSCLK (TL4CS=0,TL4X12=1)
//              <0x02=> xxx (TL4CS=1,TL4X12=0)
//              <0x03=> INT2ET (TL4CS=1,TL4X12=1)
            #define TIMER4_Split_Mode1_TL4_Clock_Source 0x00

//          <o>Initialize TL4 Counter Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode1_TL4 0

//          <o>Initialize RCAP4L Reload Value (0~255) <0-255>
//          <i>Setting RCAP4L.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL4 overflow).
            #define TIMER4_Split_Mode1_RCAP4L 0

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode1_Capture_Source 0x00

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode1_Overflow_Flag_Ignored 0

//          <o>TL4 Timer/counter Stop
//          <i>Note:TL4 stop by TH4 overflow.When TH4 over flow ,TR4L=0.
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode1_TR4LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode1_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH4 Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Split_Mode1_TR4_Run 0

//          <o>8Bit Timer/Counter TL4 Run
//              <0=>Disable (TR4L=0)(Default)
//              <1=>Enable (TR4L=1)
            #define TIMER4_Split_Mode1_TR4L_Run 0

//      </e>  //Split Mode1 Two 8Bit Timer Auto-Reload and External Interrupt Enable

//===========================================================
//      <e>Split Mode 2 Two 8Bit Timer/Counter Capture Enable
//      <i>Split mode 2 two 8Bit timer/counter Capture enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = TL4CKI/(256-TL4)
//      <i>After first run => T4OF = TL4CKI/(256-RCAP4L)
        #define TIMER4_Split_Mode2_Two_8Bit_Timer_Counter_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable (T4OE=1)
//          <i>Note:T4OE=1,gpio wizard p4.6 or p4.6 or p2.1 or p6.6 select T4CKO.
            #define TIMER4_Split_Mode2_Clock_Output_Enable 0

//          <o>TH4 Clock Source(TH4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode2_TH4_Clock_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>Note:If capture source dectect edge select ignored,TIMER4 TH4 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, TIMER4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 TIMER4 external inputs, that causes the current value in the timer4 registers, TH4 ,to be captured into registers RCAP4H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF4 in T4CON to be set, and the EXF4 bit (like TF4) can generate an interrupt which vectors to the same location as Timer4 overflow interrupt.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode2_TH4 0

//          <o>TL4 Clock Source(TL4CKI)
//              <0x00=> SYSCLK/12 (TL4CS=0,TL4X12=0)(Default)
//              <0x01=> SYSCLK (TL4CS=0,TL4X12=1)
//              <0x02=> xxx (TL4CS=1,TL4X12=0)
//              <0x03=> INT2ET (TL4CS=1,TL4X12=1)
            #define TIMER4_Split_Mode2_TL4_Clock_Source 0x00

//          <o>Initialize TL4 Counter Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode2_TL4 0

//          <o>Initialize RCAP4L Reload Value (0~255) <0-255>
//          <i>Setting RCAP4L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL4 overflow).
            #define TIMER4_Split_Mode2_RCAP4L 0

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode2_Capture_Source 0x00

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode2_Overflow_Flag_Ignored 0

//          <o>TL4 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer4 external inputs, that causes timer4 TL4 8 bit timer or counter stop ,TR4L=0.
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode2_TR4LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode2_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH4 Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Split_Mode2_TR4_Run 0

//          <o>8Bit Timer/Counter TL4 Run
//              <0=>Disable (TR4L=0)(Default)
//              <1=>Enable (TR4L=1)
            #define TIMER4_Split_Mode2_TR4L_Run 0

//      </e>  //Split Mode2 Two 8Bit Timer/Counter Capture Enable

//===========================================================
//      <e>Split Mode 3 Two 8Bit Timer/Counter Capture with Auto Zero Enable
//      <i>Split mode 3 two 8Bit timer/counter capture with auto zero enable.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = TL4CKI/(256-TL4)
//      <i>After first run => T4OF = TL4CKI/(256-RCAP4L)
        #define TIMER4_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable (T4OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER4_Split_Mode3_Clock_Output_Enable 0

//          <o>TH4 Clock Source(TH4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode3_TH4_Clock_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>Note:If capture source dectect edge select ignored,TIMER4 TH4 is a 8 bit timer or counter.
//          <i>Note:If capture source dectect edge select falling,rising,dual, TIMER4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 TIMER4 external inputs, that causes the current value in the timer4 registers, TH4 ,to be captured into registers RCAP4H (capture reload registers).
//          <i>Note:In addition, the transition at capture source input causes bit EXF4 in T4CON to be set, and the EXF4 bit (like TF4) can generate an interrupt which vectors to the same location as Timer4 overflow interrupt.
//          <i>Note:TIMER4 split mode4 is the similar function with TIMER4 split mode2. There is one difference that the capture source trigger(T4EXES), EXF4 event set signal, not only is the capture source of Timer4 but also clears the content of TH4 to 0x00H.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode3_TH4 0

//          <o>TL4 Clock Source(TL4CKI)
//              <0x00=> SYSCLK/12 (TL4CS=0,TL4X12=0)(Default)
//              <0x01=> SYSCLK (TL4CS=0,TL4X12=1)
//              <0x02=> xxx (TL4CS=1,TL4X12=0)
//              <0x03=> INT2ET (TL4CS=1,TL4X12=1)
            #define TIMER4_Split_Mode3_TL4_Clock_Source 0x00

//          <o>Initialize TL4 Counter Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode3_TL4 0

//          <o>Initialize RCAP4L Reload Value (0~255) <0-255>
//          <i>Setting RCAP4L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL4 overflow).
            #define TIMER4_Split_Mode3_RCAP4L 0

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode3_Capture_Source 0x00

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode3_Overflow_Flag_Ignored 0

//          <o>TL4 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer4 external inputs, that causes timer4 TL4 8 bit timer or counter stop ,TR4L=0.
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode3_TR4LC 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode3_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter TH4 Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Split_Mode3_TR4_Run 0

//          <o>8Bit Timer/Counter TL4 Run
//              <0=>Disable (TR4L=0)(Default)
//              <1=>Enable (TR4L=1)
            #define TIMER4_Split_Mode3_TR4L_Run 0

//      </e>  //Split Mode3 Two 8Bit Timer/Counter Capture with Auto Zero Enable

//===========================================================
//      <e>Split Mode 4 8Bit Pwm
//      <i>Split mode 4 8Bit pwm.
//      <i>T4OF (Hz) :
//      <i>First run => T4OF = T4CKI/(256-TH4)
//      <i>After first run => T4OF = T4CKI/(256-RCAP4H)
        #define TIMER4_Split_Mode4_8Bit_Pwm 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable (T4OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER4_Split_Mode4_Clock_Output_Enable 0

//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode4_Clock_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>TH4 and RCAP4H are combined to an 8-bit auto-reload counter.
//          <i>TH4 and RCAP4H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval high byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode4_TH4 0

//          <o>Initialize RCAP4H Reload Value (0~255) <0-255>
//          <i>Setting RCAP4H.
//          <i>TH4 and RCAP4H are combined to an 8-bit auto-reload counter.
//          <i>TH4 and RCAP4H configures to decide the PWM cycle time.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH4 overflow).
            #define TIMER4_Split_Mode4_RCAP4H 0

//          <o>Initialize TL4 PWM Compare Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>TL4 is the PWM compare register to generate PWM waveform.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode4_TL4 0

//          <o>Timer PWM Compare Reload Value (0~255) <0-255>
//          <i>Setting RCAP3L.
//          <i>RCAP4L is the PWM buffer register and software will update PWM data in this register. Each TH4 overflow event will set TF4 and load RCAP4L value into TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval low byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TH4 overflow).
            #define TIMER4_Split_Mode4_RCAP4L 0

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode4_Capture_Source 0x00

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode4_Overflow_Flag_Ignored 0

//          <o>Timer4 T4CKO Invert
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode4_T4CKO_Invert 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode4_Capture_Source_Dectect_Edge 0x00

//          <o>8Bit Timer/Counter Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable  (TR4=1)
            #define TIMER4_Split_Mode4_TR4_Run 0

//      </e>  //Split Mode4 Two 8Bit Pwm

//===========================================================
//      <e>Split Mode 6 Duty Capture Enable
//      <i>Split Mode 6 duty capture enable.
//      <i>T4OF period will be stop by duty capture finish.
        #define TIMER4_Split_Mode6_Duty_Capture 0
//===========================================================
//          <o>Clock Output
//              <0=>Disable (T4OE=0)(Default)
//              <1=>Enable (T4OE=1)
//          <i>Note:T3OE=1,gpio wizard p4.6 or p3.6 or p2.1 or p6.6 select T3CKO.
            #define TIMER4_Split_Mode6_Clock_Output_Enable 0

//          <o>Clock Source(T4CKI)
//              <0x00=> SYSCLK/12 (T4CKS=0,T4X12=0,C_T4=0)(Default)
//              <0x01=> T4 Pin (T4CKS=0,T4X12=0,C_T4=1)
//              <0x02=> SYSCLK (T4CKS=0,T4X12=1,C_T4=0)
//              <0x03=> TL4OF (T4CKS=0,T4X12=1,C_T4=1)
//              <0x04=> xxx (T4CKS=1,T4X12=0,C_T4=0)
//              <0x05=> T0OF (T4CKS=1,T4X12=0,C_T4=1)
//              <0x06=> AC2ES (T4CKS=1,T4X12=1,C_T4=0)
//              <0x07=> AC0ES (T4CKS=1,T4X12=1,C_T4=1)
            #define TIMER4_Split_Mode6_Clock_Source 0x00

//          <o>Capture Source
//              <0x00=> T4EX Pin (CP4S2=0,CP4S1=0,CP4S0=0)(Default)
//              <0x01=> nSS Pin (CP4S2=0,CP4S1=0,CP4S0=1)
//              <0x02=> INT3ET (CP4S2=0,CP4S1=1,CP4S0=0)
//              <0x03=> xxx (CP4S2=0,CP4S1=1,CP4S0=1)
//              <0x04=> xxx (CP4S2=1,CP4S1=0,CP4S0=0)
//              <0x05=> AC0OUT (CP4S2=1,CP4S1=0,CP4S0=1)
//              <0x06=> AC2OUT (CP4S2=1,CP4S1=1,CP4S0=0)
//              <0x07=> TWI1_SCL (CP4S2=1,CP4S1=1,CP4S0=1)
            #define TIMER4_Split_Mode6_Capture_Source 0x00

//          <o>Initialize TH4 Counter Value (0~255) <0-255>
//          <i>Setting TH4.
//          <i>Example:
//          <i>Timer interval =1(Total interval=65535-1+1=65535count,aviliable on first cycle).
            #define TIMER4_Split_Mode6_TH4 0

//          <o>Timer4 Overflow Flag Ignored
//              <0=>Disable (TF4IG=0)(Default)
//              <1=>Enable (TF4IG=1)
            #define TIMER4_Split_Mode6_Overflow_Flag_Ignored 0

//          <o>Capture Source Dectect Edge
//              <0x00=>Ignored (EXEN4=0,T4EXH=0)(Default)
//              <0x01=>Rising (EXEN4=0,T4EXH=1)
//              <0x02=>Falling (EXEN4=1,T4EXH=0)
//              <0x03=>Dual (EXEN4=1,T4EXH=1)
            #define TIMER4_Split_Mode6_Capture_Source_Dectect_Edge 0x00

//          <o>TL4 Clock Source(TL4CKI)
//              <0x00=> SYSCLK/12 (TL4CS=0,TL4X12=0)(Default)
//              <0x01=> SYSCLK (TL4CS=0,TL4X12=1)
//              <0x02=> xxx (TL4CS=1,TL4X12=0)
//              <0x03=> INT2ET (TL4CS=1,TL4X12=1)
            #define TIMER4_Split_Mode6_TL4_Clock_Source 0x00

//          <o>Initialize TL4 Counter Value (0~255) <0-255>
//          <i>Setting TL4.
//          <i>Example: for 8 bit timer or counter
//          <i>Timer interval Low Byte=1(Total interval=255-1+1=255count,aviliable on first cycle).
            #define TIMER4_Split_Mode6_TL4 0

//          <o>Initialize RCAP4L Reload Value (0~255) <0-255>
//          <i>Setting RCAP4L.
//          <i>Example: for 8 bit timer or counter
//          <i>timer interval high byte reload =1(Total interval=255-1+1=255count,auto reload by 8Bit timer/counter TL2 overflow).
            #define TIMER4_Split_Mode6_RCAP4L 0

//          <o>TL4 Timer/counter Stop
//          <i>Note:If capture source dectect edge select falling,rising,dual, timer4 still does the above,but with the added feature that a 1-to-0 or a 0-to-1 or 1-to-0,0-to-1 both, transition at capture source input,one of 8 timer4 external inputs, that causes timer4 TL4 8 bit timer or counter stop ,TR4L=0.
//              <0=>Disable (TR4LC=0)(Default)
//              <1=>Enable (TR4LC=1)
            #define TIMER4_Split_Mode6_TR4LC 0

//          <o>8Bit Timer/Counter TH4 Run
//              <0=>Disable (TR4=0)(Default)
//              <1=>Enable (TR4=1)
            #define TIMER4_Split_Mode6_TR4_Run 0

//          <o>8Bit Timer/Counter TL4 Run
//              <0=>Disable (TR4L=0)(Default)
//              <1=>Enable (TR4L=1)
            #define TIMER4_Split_Mode6_TR4L_Run 0
//      </e>  //Mode6 Duty Capture Enable

//  </e>  //Timer4 Enable
//</e>  //Initialize Timers/Counters


/**
*****************************************************************************
* @brief        TIMER0 Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (T0CKO PinMux) (Gating Source) (Reload)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER0_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER0_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);\
        __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode0_Clock_Source);\
        __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode0_Gating_Source);\
        __DRV_TIMER0_SetHighByte(TIMER0_Mode0_Timer_Interval_High_Byte);\
        __DRV_TIMER0_SetLowByte(TIMER0_Mode0_Timer_Interval_Low_Byte);\
        __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode0_Clock_Output_Enable);\
        __DRV_TIMER0_Run_Cmd(TIMER0_Mode0_8Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER1 Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (T1CKO PinMux) (Gating Source) (Reload)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER1_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER1_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER1_Mode_Select(TIMER1_Mode);\
        __DRV_TIMER1_Clock_Source_Select(TIMER1_Mode0_Clock_Source);\
        __DRV_TIMER1_Gating_Source_Select(TIMER1_Mode0_Gating_Source);\
        __DRV_TIMER1_SetHighByte(TIMER1_Mode0_Timer_Interval_High_Byte);\
        __DRV_TIMER1_SetLowByte(TIMER1_Mode0_Timer_Interval_Low_Byte);\
        __DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode0_Clock_Output_Enable);\
        __DRV_TIMER1_Run_Cmd(TIMER1_Mode0_8Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER0 Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (Gating Source)(Reload)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER0_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER0_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);\
        __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode1_Clock_Source);\
        __DRV_TIMER0_Gating_Source_Select(TIMER1_Mode1_Gating_Source);\
        __DRV_TIMER0_Set16BitInterval(TIMER0_Mode1_Timer_Interval);\
        __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode1_Clock_Output_Enable);\
        __DRV_TIMER0_Run_Cmd(TIMER0_Mode0_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER1 Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (Gating Source) (Reload)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER1_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER1_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER1_Mode_Select(TIMER1_Mode);\
        __DRV_TIMER1_Clock_Source_Select(TIMER1_Mode1_Clock_Source);\
        __DRV_TIMER1_Gating_Source_Select(TIMER1_Mode1_Gating_Source);\
        __DRV_TIMER1_Set16BitInterval(TIMER1_Mode1_Timer_Interval);\
        __DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode1_Clock_Output_Enable);\
        __DRV_TIMER1_Run_Cmd(TIMER1_Mode1_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER0 Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (Gating Source) (Reload)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER0_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER0_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);\
        __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode2_Clock_Source);\
        __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode2_Gating_Source);\
        __DRV_TIMER0_Set8BitIntervalAutoReload(TIMER0_Mode2_Timer_Interval);\
        __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode2_Clock_Output_Enable);\
        __DRV_TIMER0_Run_Cmd(TIMER0_Mode2_8Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER1 Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (T0CKO PinMux) (Gating Source)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER1_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER1_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER1_Mode_Select(TIMER1_Mode);\
        __DRV_TIMER1_Clock_Source_Select(TIMER1_Mode2_Clock_Source);\
        __DRV_TIMER1_Gating_Source_Select(TIMER1_Mode2_Gating_Source);\
        __DRV_TIMER1_Set8BitIntervalAutoReload(TIMER1_Mode2_Timer_Interval);\
        __DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode2_Clock_Output_Enable);\
        __DRV_TIMER1_Run_Cmd(TIMER1_Mode2_8Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER0 Mode3 Init from Wizard
* @details      Initial (MODE) (Clock Source) (T0CKO PinMux) (Gating Source)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER0_Mode3_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER0_Mode3_Wizard_Init()\
    MWT(\
        __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);\
        __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode3_Clock_Source);\
        __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode3_Gating_Source);\
        __DRV_TIMER0_SetHighByte(TIMER0_Mode3_Timer_Interval_High_Byte);\
        __DRV_TIMER0_SetLowByte(TIMER0_Mode3_Timer_Interval_Low_Byte);\
        __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode3_T0CKO_Clock_Output_Enable);\
        __DRV_TIMER1_Run_Cmd(TIMER0_Mode3_8Bit_Timer_Counter_TH0_Run);\
        __DRV_TIMER0_Run_Cmd(TIMER0_Mode3_8Bit_Timer_Counter_TL0_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_Clock_Source_Select(TIMER2_Mode0_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Mode0_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Mode0_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode0_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode0_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_Set16BitInterval(TIMER2_Mode0_Timer_Interval);\
        __DRV_TIMER2_Set16BCaptureitInterval(TIMER2_Mode0_Timer_Interval_Reload);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Mode0_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_Clock_Source_Select(TIMER2_Mode1_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Mode1_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Mode1_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode1_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode1_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_Set16BitInterval(TIMER2_Mode1_Timer_Interval);\
        __DRV_TIMER2_Set16BCaptureitInterval(TIMER2_Mode1_Timer_Interval_Reload);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Mode1_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_Clock_Source_Select(TIMER2_Mode2_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Mode2_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Mode2_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode2_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode2_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_Set16BitInterval(TIMER2_Mode2_Timer_Interval);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Mode2_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Mode3 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Mode3_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Mode3_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_Clock_Source_Select(TIMER2_Mode3_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Mode3_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Mode3_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode3_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode3_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_Set16BitInterval(TIMER2_Mode3_Timer_Interval);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Mode3_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Split Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Split_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Split_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode0_TH2_Clock_Source);\
        __DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode0_TL2_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode0_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode0_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode0_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode0_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_SetHighByte(TIMER2_Split_Mode0_Timer_Interval_High_Byte);\
        __DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode0_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER2_SetLowByte(TIMER2_Split_Mode0_Timer_Interval_Low_Byte);\
        __DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode0_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode0_8Bit_Timer_Counter_TL2_Run);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode0_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode0_TL2_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Split Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Split_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Split_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode1_TH2_Clock_Source);\
        __DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode1_TL2_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode1_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode1_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode1_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode1_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_SetHighByte(TIMER2_Split_Mode1_Timer_Interval_High_Byte);\
        __DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode1_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER2_SetLowByte(TIMER2_Split_Mode1_Timer_Interval_Low_Byte);\
        __DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode1_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode1_8Bit_Timer_Counter_TL2_Run);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode1_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode1_TL2_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Split Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Split_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Split_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode2_TH2_Clock_Source);\
        __DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode2_TL2_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode2_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode2_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode2_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode2_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_SetHighByte(TIMER2_Split_Mode2_Timer_Interval_High_Byte);\
        __DRV_TIMER2_SetLowByte(TIMER2_Split_Mode2_Timer_Interval_Low_Byte);\
        __DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode2_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode2_8Bit_Timer_Counter_TL2_Run);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode2_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode2_TL2_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Split Mode3 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Split_Mode3_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Split_Mode3_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode3_TH2_Clock_Source);\
        __DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode3_TL2_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode3_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode3_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode3_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode3_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_SetHighByte(TIMER2_Split_Mode3_Timer_Interval_High_Byte);\
        __DRV_TIMER2_SetLowByte(TIMER2_Split_Mode3_Timer_Interval_Low_Byte);\
        __DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode3_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode3_8Bit_Timer_Counter_TL2_Run);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode3_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode3_TL2_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER2 Split Mode4 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER2_Split_Mode4_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER2_Split_Mode4_Wizard_Init()\
    MWT(\
        __DRV_TIMER2_Mode_Select(TIMER2_Mode);\
        __DRV_TIMER2_Clock_Source_Select(TIMER2_Split_Mode4_Clock_Source);\
        __DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode4_Capture_Source);\
        __DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode4_Clock_Output_Enable);\
        __DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode4_Overflow_Flag_Ignored);\
        __DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode4_Capture_Source_Dectect_Edge);\
        __DRV_TIMER2_SetHighByte(TIMER2_Split_Mode4_Timer_Interval_High_Byte);\
        __DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode4_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER2_SetLowByte(TIMER2_Split_Mode4_Timer_Interval_Low_Byte);\
        __DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode4_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER2_T2CKO_Invert_Cmd(TIMER2_Split_Mode4_T2CKO_Invert);\
        __DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode4_8Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_Clock_Source_Select(TIMER3_Mode0_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Mode0_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Mode0_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode0_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode0_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_Set16BitInterval(TIMER3_Mode0_Timer_Interval);\
        __DRV_TIMER3_Set16BCaptureitInterval(TIMER3_Mode0_Timer_Interval_Reload);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Mode0_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_Clock_Source_Select(TIMER3_Mode1_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Mode1_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Mode1_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode1_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode1_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_Set16BitInterval(TIMER3_Mode1_Timer_Interval);\
        __DRV_TIMER3_Set16BCaptureitInterval(TIMER3_Mode1_Timer_Interval_Reload);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Mode1_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_Clock_Source_Select(TIMER3_Mode2_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Mode2_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Mode2_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode2_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode2_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_Set16BitInterval(TIMER3_Mode2_Timer_Interval);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Mode2_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Mode3 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Mode3_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Mode3_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_Clock_Source_Select(TIMER3_Mode3_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Mode3_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Mode3_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode3_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode3_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_Set16BitInterval(TIMER3_Mode3_Timer_Interval);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Mode3_16Bit_Timer_Counter_Run);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Split Mode0 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Split_Mode0_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Split_Mode0_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode0_TH3_Clock_Source);\
        __DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode0_TL3_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode0_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode0_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode0_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode0_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_SetHighByte(TIMER3_Split_Mode0_Timer_Interval_High_Byte);\
        __DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode0_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER3_SetLowByte(TIMER3_Split_Mode0_Timer_Interval_Low_Byte);\
        __DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode0_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode0_8Bit_Timer_Counter_TL3_Run);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode0_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode0_TL3_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Split Mode1 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Split_Mode1_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Split_Mode1_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode1_TH3_Clock_Source);\
        __DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode1_TL3_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode1_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode1_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode1_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode1_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_SetHighByte(TIMER3_Split_Mode1_Timer_Interval_High_Byte);\
        __DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode1_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER3_SetLowByte(TIMER3_Split_Mode1_Timer_Interval_Low_Byte);\
        __DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode1_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode1_8Bit_Timer_Counter_TL3_Run);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode1_8Bit_Timer_Counter_TH3_Run);\
        __DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode1_TL3_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Split Mode2 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Split_Mode2_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Split_Mode2_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode2_TH3_Clock_Source);\
        __DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode2_TL3_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode2_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode2_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode2_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode2_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_SetHighByte(TIMER3_Split_Mode2_Timer_Interval_High_Byte);\
        __DRV_TIMER3_SetLowByte(TIMER3_Split_Mode2_Timer_Interval_Low_Byte);\
        __DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode2_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode2_8Bit_Timer_Counter_TL3_Run);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode2_8Bit_Timer_Counter_TH3_Run);\
        __DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode2_TL3_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Split Mode3 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Split_Mode3_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Split_Mode3_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode3_TH3_Clock_Source);\
        __DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode3_TL3_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode3_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode3_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode3_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode3_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_SetHighByte(TIMER3_Split_Mode3_Timer_Interval_High_Byte);\
        __DRV_TIMER3_SetLowByte(TIMER3_Split_Mode3_Timer_Interval_Low_Byte);\
        __DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode3_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode3_8Bit_Timer_Counter_TL2_Run);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode3_8Bit_Timer_Counter_TH2_Run);\
        __DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode3_TL3_Stop);\
    ;)


/**
*****************************************************************************
* @brief        TIMER3 Split Mode4 Init from Wizard
* @details      Initial (MODE) (Clock Source) (PinMux) (Capture Source) (Dectect Edge)
* @return       None
* @note         None
* @par          Example
* @code
                 __DRV_TIMER3_Split_Mode4_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_TIMER3_Split_Mode4_Wizard_Init()\
    MWT(\
        __DRV_TIMER3_Mode_Select(TIMER3_Mode);\
        __DRV_TIMER3_Clock_Source_Select(TIMER3_Split_Mode4_Clock_Source);\
        __DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode4_Capture_Source);\
        __DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode4_Clock_Output_Enable);\
        __DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode4_Overflow_Flag_Ignored);\
        __DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode4_Capture_Source_Dectect_Edge);\
        __DRV_TIMER3_SetHighByte(TIMER3_Split_Mode4_Timer_Interval_High_Byte);\
        __DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode4_Timer_Interval_High_Byte_Reload);\
        __DRV_TIMER3_SetLowByte(TIMER3_Split_Mode4_Timer_Interval_Low_Byte);\
        __DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode4_Timer_Interval_Low_Byte_Reload);\
        __DRV_TIMER3_T3CKO_Invert_Cmd(TIMER3_Split_Mode4_T3CKO_Invert);\
        __DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode4_8Bit_Timer_Counter_Run);\
    ;)

void DRV_TIMER_Wizard_Init(void);

/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0> Initialize PCA
//  <i> Check this term to initialize PCA.
//  <i> Date: 2020/12/02     Version: 1.00
#define MG82F6D64_PCA_WIZARD  0x00

//      <o0> PCA Start Run
//          <i> PCA Counter Run
//          <i> Use Macro : "__DRV_PCA_Enable();" or "__DRV_PCA_Disable()";
//          <i> Enable : Start operation after initializing PCA.
//          <0x00=> Disable (CR=0)(Default)
//          <0x01=> Enable (CR=1)
            #define PCA_ENABLE 0x00
//      <o0> PCA Mode
//          <i>Select the function
//          <0x00=> Input Capture
//          <0x01=> Output Compare
//          <0x02=> PWM
//          <0x03=> PWM with Dead Time
//          <0x04=> 16-bit Software Timer Mode
            #define PCA_MODE 0x02

//====================================================================
//<e0> Initialize PCA Input Capture
//      <i> Initialize the PCA base unit for input capture according to the specified
//      <i> This only changes the parameters of "DRV_PCA_IC_Wizard_Init()"
//      <i> Module 6 and module 7 not support the capture mode.
        #define PWM_IC_EN  0x00

//      <o0> PCA Clock Source
//      <i> Select PCA clock source
//      <0x00=> System clock/12 (CPS2=0,CPS1=0,CPS0=0)(Default)
//      <0x02=> System clock/2 (CPS2=0,CPS1=0,CPS0=1)
//      <0x04=> Timer0 overflow (CPS2=0,CPS1=1,CPS0=0)
//      <0x06=> ECI pin (CPS2=0,CPS1=1,CPS0=1)
//      <0x08=> CKMIX16 output (CPS2=1,CPS1=0,CPS0=0)
//      <0x0A=> System clock/1 (CPS2=1,CPS1=0,CPS0=1)
//      <0x0C=> S0BRG overflow (CPS2=1,CPS1=1,CPS0=0)
//      <0x0E=> MCK divider output (CPS2=1,CPS1=1,CPS0=1)
            #define IC_CKSRC   0x00

//      <o0> PCA Input Capture Period (0~65536)<0-65536>
            #define IC_PERIOD  65536

//      <q0.4> PCA Input Capture PWM0 & PWM1 Buffer Mode (BME0)
//      <q0.5> PCA Input Capture PWM2 & PWM3 Buffer Mode (BME2)
//      <q0.6> PCA Input Capture PWM4 & PWM5 Buffer Mode (BME4)
            #define IC_BUFFER  0x07

//      <e0> Capture Channel 0
            #define IC0_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP0=1,CAPN0=0)
//              <0x10=> Negative edge trigger (CAPP0=0,CAPN0=1)
//              <0x30=> Dual edge trigger (CAPP0=1,CAPN0=1)
                #define IC0_EDGE 0x00
//      </e>

//      <e0> Capture Channel 1
            #define IC1_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP1=1,CAPN1=0)
//              <0x10=> Negative edge trigger (CAPP1=0,CAPN1=1)
//              <0x30=> Dual edge trigger (CAPP1=1,CAPN1=1)
                #define IC1_EDGE 0x00
//      </e>

//      <e0> Capture Channel 2
            #define IC2_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP2=1,CAPN2=0)
//              <0x10=> Negative edge trigger (CAPP2=0,CAPN2=1)
//              <0x30=> Dual edge trigger (CAPP2=1,CAPN2=1)
                #define IC2_EDGE 0x00
//          <o0> Input capture port pin
//          <i> Input capture module 2 pin selection
//              <0x00=> CEX2 (C0IC2S0=0)(Default)
//              <0x01=> T3EXI (C0IC2S0=1)
                #define IC2_PIN 0x00
//      </e>

//      <e0> Capture Channel 3
            #define IC3_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP3=1,CAPN3=0)
//              <0x10=> Negative edge trigger (CAPP3=0,CAPN3=1)
//              <0x30=> Dual edge trigger (CAPP3=1,CAPN3=1)
                #define IC3_EDGE 0x00
//      </e>

//      <e0> Capture Channel 4
            #define IC4_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP4=1,CAPN4=0)
//              <0x10=> Negative edge trigger (CAPP4=0,CAPN4=1)
//              <0x30=> Dual edge trigger (CAPP4=1,CAPN4=1)
                #define IC4_EDGE 0x00
//          <o0> Input capture port pin
//          <i> Input capture module 4 pin selection
//              <0x00=> CEX4 (C0IC4S0=0)(Default)
//              <0x01=> T2EXI (C0IC4S0=1)
                #define IC4_PIN 0x00
//      </e>

//      <e0> Capture Channel 5
            #define IC5_EN 0
//          <o0> PCA Capture Edge
//          <i> Drop-down menu to select type.
//              <0x20=> Positive edge trigger (CAPP5=1,CAPN5=0)
//              <0x10=> Negative edge trigger (CAPP5=0,CAPN5=1)
//              <0x30=> Dual edge trigger (CAPP5=1,CAPN5=1)
                #define IC5_EDGE 0x00
//      </e>
//</e>
//====================================================================
//<e> Initialize PCA Output Compare
//  <i> Initialize the PCA base unit for output compare according to the specified
//  <i> This only changes the parameters of "DRV_PCA_OC_Wizard_Init()"
#define PWM_OC_EN  0x00

//  <o0> PCA clock source
//      <i> Select PCA clock source
//      <0x00=> System clock/12 (CPS2=0,CPS1=0,CPS0=0)(Default)
//      <0x02=> System clock/2 (CPS2=0,CPS1=0,CPS0=1)
//      <0x04=> Timer0 overflow (CPS2=0,CPS1=1,CPS0=0)
//      <0x06=> ECI pin (CPS2=0,CPS1=1,CPS0=1)
//      <0x08=> CKMIX16 output (CPS2=1,CPS1=0,CPS0=0)
//      <0x0A=> System clock/1 (CPS2=1,CPS1=0,CPS0=1)
//      <0x0C=> S0BRG overflow (CPS2=1,CPS1=1,CPS0=0)
//      <0x0E=> MCK divider output (CPS2=1,CPS1=1,CPS0=1)
        #define OC_CKSRC   0x00

//  <o0> PCA Output Compare Period  (0~65536)<0-65536>
        #define OC_PERIOD  65536
//  <q0.4> PCA Output Compare PWM0 & PWM1 Buffer Mode (BME0)
//  <q0.5> PCA Output Compare PWM2 & PWM3 Buffer Mode (BME2)
//  <q0.6> PCA Output Compare PWM4 & PWM5 Buffer Mode (BME4)
//  <q0.7> PCA Output Compare PWM6 & PWM7 Buffer Mode (BME6)
    #define OC_BUFFER  0x00

//  <e0> PCA Channel 0
        #define OC0_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P0INV=0)(Default)
//          <0x01=> Enable (P0INV=1)
            #define OC0_INV  0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P0RS1=0,P0RS0=0)(Default)
//          <0x40=> 10-bit (P0RS1=0,P0RS0=1)
//          <0x80=> 12-bit (P0RS1=1,P0RS0=0)
//          <0xC0=> 16-bit (P0RS1=1,P0RS0=1)
            #define OC0_RES  0x80
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC0_COPM  2048
//  </e>

//  <e0> PCA Channel 1
        #define OC1_EN 0

//      <o0> Inverted
//          <0x00=> Disable (P1INV=0)(Default)
//          <0x01=> Enable (P1INV=1)
            #define OC1_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P1RS1=0,P1RS0=0)(Default)
//          <0x40=> 10-bit (P1RS1=0,P1RS0=1)
//          <0x80=> 12-bit (P1RS1=1,P1RS0=0)
//          <0xC0=> 16-bit (P1RS1=1,P1RS0=1)
            #define OC1_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC1_COPM  65535
//  </e>

//  <e0> PCA Channel 2
        #define OC2_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P2INV=0)(Default)
//          <0x01=> Enable (P2INV=1)
            #define OC2_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P2RS1=0,P2RS0=0)(Default)
//          <0x40=> 10-bit (P2RS1=0,P2RS0=1)
//          <0x80=> 12-bit (P2RS1=1,P2RS0=0)
//          <0xC0=> 16-bit (P2RS1=1,P2RS0=1)
            #define OC2_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC2_COPM  65535
//  </e>

//  <e0> PCA Channel 3
        #define OC3_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P3INV=0)(Default)
//          <0x01=> Enable (P3INV=1)
            #define OC3_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P3RS1=0,P3RS0=0)(Default)
//          <0x40=> 10-bit (P3RS1=0,P3RS0=1)
//          <0x80=> 12-bit (P3RS1=1,P3RS0=0)
//          <0xC0=> 16-bit (P3RS1=1,P3RS0=1)
            #define OC3_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC3_COPM  65535
//  </e>

//  <e0> PCA Channel 4
        #define OC4_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P4INV=0)(Default)
//          <0x01=> Enable (P4INV=1)
            #define OC4_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P4RS1=0,P4RS0=0)(Default)
//          <0x40=> 10-bit (P4RS1=0,P4RS0=1)
//          <0x80=> 12-bit (P4RS1=1,P4RS0=0)
//          <0xC0=> 16-bit (P4RS1=1,P4RS0=1)
            #define OC4_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC4_COPM  65535
//  </e>

//  <e0> PCA Channel 5
        #define OC5_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P5INV=0)(Default)
//          <0x01=> Enable (P5INV=1)
            #define OC5_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P5RS1=0,P5RS0=0)(Default)
//          <0x40=> 10-bit (P5RS1=0,P5RS0=1)
//          <0x80=> 12-bit (P5RS1=1,P5RS0=0)
//          <0xC0=> 16-bit (P5RS1=1,P5RS0=1)
            #define OC5_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC5_COPM  65535
//  </e>

//  <e0> PCA Channel 6
        #define OC6_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P6INV=0)(Default)
//          <0x01=> Enable (P6INV=1)
            #define OC6_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P6RS1=0,P6RS0=0)(Default)
//          <0x40=> 10-bit (P6RS1=0,P6RS0=1)
//          <0x80=> 12-bit (P6RS1=1,P6RS0=0)
//          <0xC0=> 16-bit (P6RS1=1,P6RS0=1)
            #define OC6_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC6_COPM  65535
//  </e>

//  <e0> PCA Channel 7
        #define OC7_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P7INV=0)(Default)
//          <0x01=> Enable (P7INV=1)
            #define OC7_INV 0x00
//      <o0> Resolution
//          <0x00=> 8-bit (P7RS1=0,P7RS0=0)(Default)
//          <0x40=> 10-bit (P7RS1=0,P7RS0=1)
//          <0x80=> 12-bit (P7RS1=1,P7RS0=0)
//          <0xC0=> 16-bit (P7RS1=1,P7RS0=1)
            #define OC7_RES  0x00
//      <o0> Compare Value (0~65535)
//          <i> 8-bit Resolution 0~255
//          <i> 10-bit Resolution 0~1023
//          <i> 12-bit Resolution 0~4095
//          <i> 16-bit Resolution 0~65535
            #define OC7_COPM  65535
//  </e>
//</e>
//====================================================================
//<e> Initialize PCA PWM
//  <i> Initialize the PCA base unit for PWM according to the specified
//  <i> This only changes the parameters of "DRV_PCA_PWM_Wizard_Init()"
    #define PWM_EN  0x00

//  <o0> PCA clock source
//      <i> Select PCA clock source
//      <0x00=> System clock/12 (CPS2=0,CPS1=0,CPS0=0)(Default)
//      <0x02=> System clock/2 (CPS2=0,CPS1=0,CPS0=1)
//      <0x04=> Timer0 overflow (CPS2=0,CPS1=1,CPS0=0)
//      <0x06=> ECI pin (CPS2=0,CPS1=1,CPS0=1)
//      <0x08=> CKMIX16 output (CPS2=1,CPS1=0,CPS0=0)
//      <0x0A=> System clock/1 (CPS2=1,CPS1=0,CPS0=1)
//      <0x0C=> S0BRG overflow (CPS2=1,CPS1=1,CPS0=0)
//      <0x0E=> MCK divider output (CPS2=1,CPS1=1,CPS0=1)
        #define PWM_CKSRC   0x00

//  <o0> PCA clock source frequency(Hz)
//      <i> Fill in the clock frequency of the PCA module.
//      <i> If the PCA source clock is System clock/12, when the system clock is 12MHz, the input frequency of PCA is 1MHz. 1MHz=1000000.
//      <i> Example: 1000000
        #define PWM_CKS_FREQ  1000000

//  <o0> PCA PWM frequency(Hz)
//      <i> Fill in the PWM output frequency.
//      <i> If you select central aligned mode, the output frequency will be divided by 2.
//      <i> Example: 30000
        #define PWM_FREQ  30000
//  <o0> PCA PWM aligned mode
//      <i> Central aligned function is only active on PWM0~5, PWM6/PWM7 not support central aligned.
//      <0x00=> Edge aligned (PCAE=0,C0M0=0)(Default)
//      <0x01=> Central aligned (PCAE=1,C0M0=1)
        #define PWM_ALIGN   0x00
//  <q0.4> PCA PWM0 & PWM1 Buffer Mode (BME0)
//  <q0.5> PCA PWM2 & PWM3 Buffer Mode (BME2)
//  <q0.6> PCA PWM4 & PWM5 Buffer Mode (BME4)
//  <q0.7> PCA PWM6 & PWM7 Buffer Mode (BME6)
        #define PWM_BUFFER  0x00
//  <e0> PCA Channel 0
        #define PWM0_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P0INV=0)(Default)
//          <0x01=> Enable (P0INV=1)
            #define PWM0_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM0_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 1
        #define PWM1_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P1INV=0)(Default)
//          <0x01=> Enable (P1INV=1)
            #define PWM1_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM1_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 2
        #define PWM2_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P2INV=0)(Default)
//          <0x01=> Enable (P2INV=1)
            #define PWM2_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM2_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 3
        #define PWM3_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P3INV=0)(Default)
//          <0x01=> Enable (P3INV=1)
            #define PWM3_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM3_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 4
        #define PWM4_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P4INV=0)(Default)
//          <0x01=> Enable (P4INV=1)
            #define PWM4_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM4_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 5
        #define PWM5_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P5INV=0)(Default)
//          <0x01=> Enable (P5INV=1)
            #define PWM5_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM5_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 6
        #define PWM6_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P6INV=0)(Default)
//          <0x01=> Enable (P6INV=1)
            #define PWM6_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM6_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 7
        #define PWM7_EN 0
//      <o0> Inverted
//          <0x00=> Disable (P7INV=0)(Default)
//          <0x01=> Enable (P7INV=1)
            #define PWM7_INV  0x00
//      <o0> Duty cycle percentage (0~100)  <0-100>
//          <i> PWM high level percentage
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM7_DUTY_PERC  50
//  </e>
//</e>
//====================================================================
//<e> Initialize PCA PWM with Dead Time
//  <i> Initialize the PCA base unit for PWM with dead time according to the specified
//  <i> This only changes the parameters of "DRV_PCA_PWM_DTG_Wizard_Init()"
    #define PWM_DTG_EN  0x00

//  <o0> PCA clock source
//      <i> Select PCA clock source
//      <0x00=> System clock/12 (CPS2=0,CPS1=0,CPS0=0)(Default)
//      <0x02=> System clock/2 (CPS2=0,CPS1=0,CPS0=1)
//      <0x04=> Timer0 overflow (CPS2=0,CPS1=1,CPS0=0)
//      <0x06=> ECI pin (CPS2=0,CPS1=1,CPS0=1)
//      <0x08=> CKMIX16 output (CPS2=1,CPS1=0,CPS0=0)
//      <0x0A=> System clock/1 (CPS2=1,CPS1=0,CPS0=1)
//      <0x0C=> S0BRG overflow (CPS2=1,CPS1=1,CPS0=0)
//      <0x0E=> MCK divider output (CPS2=1,CPS1=1,CPS0=1)
        #define PWM_DTG_CKSRC   0x00
//  <o0> PCA clock fource frequency(Hz)
//      <i> Fill in the clock frequency of the PCA module.
//      <i> If the PCA source clock is System clock/12, when the system clock is 12MHz, the input frequency of PCA is 1MHz. 1MHz=1000000.
//      <i> Example: 1000000
        #define PWM_DTG_CKS_FREQ  1000000
//  <o0> PCA PWM frequency(Hz)
//      <i> Fill in the PWM output frequency.
//      <i> Example: 30000
        #define PWM_DTG_FREQ  30000
//  <o0> PWM dead time clock source
//      <0x00=> System clock (DTPS1=0,DTPS0=0]=0)(Default)
//      <0x40=> System clock/2 (DTPS1=0,DTPS0=0]=1)
//      <0x80=> System clock/4 (DTPS1=1,DTPS0=0]=0)
//      <0xC0=> System clock/8 (DTPS1=1,DTPS0=0]=1)
        #define PWM_DTG_DTCKSRC  0x00
//  <o0> PCA PWM dead time period  (0~63)<0-63>
//      <i> PWM dead time = dead time clock source * dead time period
        #define PWM_DTG_DTPERIOD  1

//  <e0> PCA Channel 0 & PCA Channel 1
        #define PWM01_DTG_EN 0
//      <o0> PWM0 Inverted
//          <0x00=> Disable (P0INV=0)(Default)
//          <0x01=> Enable (P0INV=1)
            #define PWM0_DTG_INV  0x00
//      <o0> PWM1 Inverted
//          <0x00=> Disable (P1INV=0)(Default)
//          <0x01=> Enable (P1INV=1)
            #define PWM1_DTG_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> Setting dead-time will affect duty cycle percentage.
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM01_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 2 & PCA Channel 3
        #define PWM23_DTG_EN 0
//      <o0> PWM2 Inverted
//          <0x00=> Disable (P2INV=0)(Default)
//          <0x01=> Enable (P2INV=1)
            #define PWM2_DTG_INV  0x00
//      <o0> PWM3 Inverted
//          <0x00=> Disable (P3INV=0)(Default)
//          <0x01=> Enable (P3INV=1)
            #define PWM3_DTG_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> Setting dead-time will affect duty cycle percentage.
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM23_DUTY_PERC  50
//  </e>

//  <e0> PCA Channel 4 & PCA Channel 5
        #define PWM45_DTG_EN 0
//      <o0> PWM4 Inverted
//          <0x00=> Disable (P4INV=0)(Default)
//          <0x01=> Enable (P4INV=1)
            #define PWM4_DTG_INV  0x00
//      <o0> PWM5 Inverted
//          <0x00=> Disable (P5INV=0)(Default)
//          <0x01=> Enable (P5INV=1)
            #define PWM5_DTG_INV  0x00
//      <o0> Duty cycle percentage (0~100) <0-100>
//          <i> PWM high level percentage
//          <i> Setting dead-time will affect duty cycle percentage.
//          <i> The higher the PWM frequency, the lower the resolution of duty time.
//          <i> PWM resolution = PCA clock frequency / PWM frequency
            #define PWM45_DUTY_PERC  50
//  </e>
//</e>
//====================================================================
//  <e0> Initialize PCA 16 bit Timer
//      <i> Initialize the PCA base unit for 16 bit Timer according to the specified
//      <i> This only changes the parameters of "DRV_PCA_Timer_Wizard_Init()"
        #define TIM_EN  0x00

//  <o0> PCA Clock Source
//      <i> Select PCA clock source
//      <0x00=> System clock/12 (CPS2=0,CPS1=0,CPS0=0)(Default)
//      <0x02=> System clock/2 (CPS2=0,CPS1=0,CPS0=1)
//      <0x04=> Timer0 overflow (CPS2=0,CPS1=1,CPS0=0)
//      <0x06=> ECI pin (CPS2=0,CPS1=1,CPS0=1)
//      <0x08=> CKMIX16 output (CPS2=1,CPS1=0,CPS0=0)
//      <0x0A=> System clock/1 (CPS2=1,CPS1=0,CPS0=1)
//      <0x0C=> S0BRG overflow (CPS2=1,CPS1=1,CPS0=0)
//      <0x0E=> MCK divider output (CPS2=1,CPS1=1,CPS0=1)
        #define TIM_CKSRC   0x00
//  <o0> PCA Timer Period (0~65536)<0-65536>
        #define TIM_PERIOD  65536

//  <e0> Channel 0
        #define PWM0_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM0_VAL 0
//  </e>

//  <e0> Channel 1
        #define PWM1_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM1_VAL 0
//</e>

//  <e0> Channel 2
        #define PWM2_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM2_VAL 0
//  </e>

//  <e0> Channel 3
        #define PWM3_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM3_VAL 0
//  </e>

//  <e0> Channel 4
        #define PWM4_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM4_VAL 0
//  </e>

//  <e0> Channel 5
        #define PWM5_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM5_VAL 0
//  </e>

//  <e0> Channel 6
        #define PWM6_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM6_VAL 0
//  </e>

//  <e0> Channel 7
        #define PWM7_TIM_EN 0
//      <o0> Timer Value(0~65535)<0-65535>
            #define TIM7_VAL 0
//  </e>
//</e>
//===================================================================

//</e> PCA End


void DRV_PCA_Wizard_Init();
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0>Initialize Serial Port 0 (UART0)
//          <i> Check this term, then DRV_UART0_Wizard_Init() will initialize UART0.
//          <i> Note: TI0 bit will be set in Serial Port 0 (UART0) Initializtion.
//          <i> Date: 2024/03/07     Version: 1.03
#define MG82F6D64_UART0_WIZARD      0
//-----------------------------------------------------------------------------
//      <o>UART0
//          <0=>Easy Mode(Default)
//          <1=>Advanced Mode
//          <i> UART0 option select .
#define URT0_Option 0
//      <e>Easy Mode
#define URT0_Easy_Mode 0
//      <e>UART0 Enable
#define URT0_Easy 0
//      <o>Easy Select
//          <0=>Select0(Default)
//          <1=>Select1
//          <2=>Select2
//          <3=>Select3
//          <4=>Select4
//          <5=>Select5
//          <6=>Select6
//          <7=>Select7
//          <8=>Select8
//          <9=>Select9
//          <10=>Select10
//          <11=>Select11
//          <12=>Select12
//          <13=>Select13
//          <14=>Select14
//          <15=>Select15
//          <16=>Select16
//          <17=>Select17
//          <18=>Select18
//          <19=>Select19
//          <20=>Select20
//          <21=>Select21
//          <22=>Select22
//          <23=>Select23
//          <24=>Select24
//          <25=>Select25
//          <26=>Select26
//          <27=>Select27
//          <28=>Select28
//          <29=>Select29
//          <30=>Select30
//          <31=>Select31
//          <32=>Select32
//          <33=>Select33
//          <34=>Select34
//          <35=>Select35
//          <36=>Select36
//          <37=>Select37
//          <38=>Select38
//          <39=>Select39
//          <40=>Select40
//          <41=>Select41
//          <42=>Select42
//          <43=>Select43
//          <44=>Select44
//          <45=>Select45
//          <46=>Select46
//          <47=>Select47
//          <48=>Select48
//          <49=>Select49
//          <50=>Select50
//          <51=>Select51
//          <52=>Select52
//          <53=>Select53
//          <54=>Select54
//          <55=>Select55
//          <56=>Select56
//          <57=>Select57
//          <58=>Select58
//          <59=>Select59
//          <60=>Select60
//          <61=>Select61
//          <62=>Select62
//          <63=>Select63
//          <64=>Select64
//          <65=>Select65
//          <66=>Select66
//          <67=>Select67
//          <68=>Select68
//          <69=>Select69
//          <70=>Select70
//          <71=>Select71
//          <72=>Select72
//          <73=>Select73
//          <74=>Select74
//          <75=>Select75
//          <76=>Select76
//          <77=>Select77
//          <78=>Select78
//          <79=>Select79
//          <80=>Select80
//          <81=>Select81
//          <82=>Select82
//          <83=>Select83
//          <84=>Select84
//          <85=>Select85
//          <86=>Select86
//          <87=>Select87
//          <88=>Select88
//          <89=>Select89
//          <90=>Select90
//          <91=>Select91
//          <92=>Select92
//          <93=>Select93
//          <94=>Select94
//          <95=>Select95
//          <96=>Select96
//          <97=>Select97
//          <98=>Select98
//          <99=>Select99
//          <100=>Select100
//          <101=>Select101
//          <102=>Select102
//          <103=>Select103
//          <104=>Select104
//          <105=>Select105
//          <106=>Select106
//          <107=>Select107
//          <108=>Select108
//          <109=>Select109
//          <110=>Select110
//          <111=>Select111
//          <112=>Select112
//          <113=>Select113
//          <114=>Select114
//          <115=>Select115
//          <116=>Select116
//          <117=>Select117
//          <118=>Select118
//          <119=>Select119
//          <120=>Select120
//          <121=>Select121
//          <122=>Select122
//          <123=>Select123
//          <124=>Select124
//          <125=>Select125
//          <126=>Select126
//          <127=>Select127
//          <128=>Select128
//          <129=>Select129
//          <130=>Select130
//          <131=>Select131
//          <132=>Select132
//          <133=>Select133
//          <134=>Select134
//          <135=>Select135
//          <136=>Select136
//          <137=>Select137
//          <138=>Select138
//          <139=>Select139
//          <140=>Select140
//          <141=>Select141
//          <142=>Select142
//          <143=>Select143
//          <144=>Select144
//          <145=>Select145
//          <146=>Select146
//          <147=>Select147
//          <148=>Select148
//          <149=>Select149
//          <150=>Select150
//          <151=>Select151
//          <152=>Select152
//          <153=>Select153
//          <154=>Select154
//          <155=>Select155
//          <156=>Select156
//          <157=>Select157
//          <158=>Select158
//          <159=>Select159
//          <160=>Select160
//          <161=>Select161
//          <162=>Select162
//          <163=>Select163
//          <164=>Select164
//          <165=>Select165
//          <166=>Select166
//          <167=>Select167
//          <168=>Select168
//          <169=>Select169
//          <170=>Select170
//          <171=>Select171
//          <172=>Select172
//          <173=>Select173
//          <174=>Select174
//          <175=>Select175
//          <176=>Select176
//          <177=>Select177
//          <178=>Select178
//          <179=>Select179
//          <180=>Select180
//          <181=>Select181
//          <182=>Select182
//          <183=>Select183
//          <184=>Select184
//          <185=>Select185
//          <186=>Select186
//          <187=>Select187
//          <188=>Select188
//          <189=>Select189
//          <190=>Select190
//          <191=>Select191
//          <192=>Select192
//          <193=>Select193
//          <194=>Select194
//          <195=>Select195
//          <196=>Select196
//          <197=>Select197
//          <198=>Select198
//          <199=>Select199
//          <200=>Select200
//          <201=>Select201
//          <202=>Select202
//          <203=>Select203
//          <204=>Select204
//          <205=>Select205
//          <206=>Select206
//          <207=>Select207
//          <208=>Select208
//          <209=>Select209
//          <210=>Select210
//          <211=>Select211
//          <212=>Select212
//          <213=>Select213
//          <214=>Select214
//          <215=>Select215
//          <216=>Select216
//          <217=>Select217
//          <218=>Select218
//          <219=>Select219
//          <220=>Select220
//          <221=>Select221
//          <222=>Select222
//          <223=>Select223
//          <224=>Select224
//          <225=>Select225
//          <226=>Select226
//          <227=>Select227

#define URT0_Easy_Select 0
//          <i> Note:Please confirm clock source before you select parameter .

//          <i> Select0:    9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select1:    9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select2:    9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select3:    9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select4:    9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   RX Only         SYSCLK=12Mhz
//          <i> Select5:    9600    8BIt    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz

//          <i> Select6:    19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select7:    19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select8:    19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select9:    19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select10:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select11:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz

//          <i> Select12:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select13:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select14:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select15:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select16:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select17:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=12Mhz

//          <i> Select18:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select19:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select20:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select21:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=12Mhz
//          <i> Select22:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=12Mhz
//          <i> Select23:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=12Mhz

//          <i> Select24:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select25:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select26:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select27:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select28:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select29:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz

//          <i> Select30:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select31:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select32:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select33:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select34:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select35:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz

//          <i> Select36:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select37:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select38:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select39:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select40:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select41:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz

//          <i> Select42:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select43:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select44:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select45:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=11.0592Mhz
//          <i> Select46:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=11.0592Mhz
//          <i> Select47:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=11.0592Mhz

//          <i> Select48:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select49:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select50:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select51:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select52:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   RX Only         SYSCLK=24Mhz
//          <i> Select53:   9600    8BIt    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz

//          <i> Select54:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select55:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select56:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select57:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select58:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select59:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz

//          <i> Select60:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select61:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select62:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select63:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select64:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select65:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=24Mhz

//          <i> Select66:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select67:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select68:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select69:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=24Mhz
//          <i> Select70:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=24Mhz
//          <i> Select71:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=24Mhz

//          <i> Select72:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select73:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select74:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select75:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select76:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select77:   115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz

//          <i> Select78:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select79:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select80:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select81:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select82:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select83:   57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz

//          <i> Select84:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select85:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select86:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select87:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select88:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select89:   19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz

//          <i> Select90:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select91:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select92:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select93:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=22.1184Mhz
//          <i> Select94:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=22.1184Mhz
//          <i> Select95:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=22.1184Mhz

//          <i> Select96:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select97:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select98:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select99:   9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select100:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   RX Only         SYSCLK=29.4912Mhz
//          <i> Select101:  9600    8BIt    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz

//          <i> Select102:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select103:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select104:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select105:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select106:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select107:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz

//          <i> Select108:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select109:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select110:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select111:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select112:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select113:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=29.4912Mhz

//          <i> Select114:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select115:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select116:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select117:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=29.4912Mhz
//          <i> Select118:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=29.4912Mhz
//          <i> Select119:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=29.4912Mhz

//          <i> Select120:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select121:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select122:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select123:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select124:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select125:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz

//          <i> Select126:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select127:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select128:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select129:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select130:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select131:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz

//          <i> Select132:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select133:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select134:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select135:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select136:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select137:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz

//          <i> Select138:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select139:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select140:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select141:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=33.1776Mhz
//          <i> Select142:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=33.1776Mhz
//          <i> Select143:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=33.1776Mhz

//          <i> Select144:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select145:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select146:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select147:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select148:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   RX Only         SYSCLK=32Mhz
//          <i> Select149:  9600    8BIt    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz

//          <i> Select150:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select151:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select152:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select153:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select154:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select155:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz

//          <i> Select156:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select157:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select158:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select159:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select160:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select161:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=32Mhz

//          <i> Select162:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select163:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select164:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select165:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=32Mhz
//          <i> Select166:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=32Mhz
//          <i> Select167:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=32Mhz

//          <i> Select168:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select169:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select170:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select171:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select172:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select173:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz

//          <i> Select174:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select175:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select176:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select177:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select178:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select179:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz

//          <i> Select180:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select181:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select182:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select183:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select184:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select185:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz

//          <i> Select186:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select187:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select188:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select189:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=36Mhz
//          <i> Select190:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=36Mhz
//          <i> Select191:  9600    8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=36Mhz

//          <i> Select192:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select193:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select194:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select195:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select196:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select197:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=44.2368Mhz

//          <i> Select198:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select199:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select200:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select201:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select202:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select203:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P30 Tx=P31   Tx Rx Both      SYSCLK=44.2368Mhz

//          <i> Select204:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select205:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select206:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select207:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=44.2368Mhz
//          <i> Select208:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=44.2368Mhz
//          <i> Select209:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=44.2368Mhz

//          <i> Select210:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select211:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select212:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select213:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select214:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select215:  115200  8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz

//          <i> Select216:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select217:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select218:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select219:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select220:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select221:  57600   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz

//          <i> Select222:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select223:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select224:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select225:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Only         SYSCLK=48Mhz
//          <i> Select226:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Rx Only         SYSCLK=48Mhz
//          <i> Select227:  19200   8Bit    S0BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  RX=P30 TX=P31   Tx Rx Both      SYSCLK=48Mhz

//      </e>UART0 Enable
//      </e>Easy Mode

//      <e>Advanced Mode
#define URT0_Advance_Mode 0
//      <e>UART0 Enable
//          <i> Mode0 shift .
//          <i> Mode1 8bit .
//          <i> Mode2 9bit .
//          <i> Mode3 9bit .
//          <i> Mode4 Spi master .
//          <i> Mode5 Lin bus .
//          <i> Note: gpio wizard select P30 RXD0 (MOSI) P31 TXD0 (SPICLK) .
//          <i> Note: gpio wizard select P44 RXD0 (MOSI) P45 TXD0 (SPICLK) .
//          <i> Note: gpio wizard select P31 RXD0 (MOSI) P30 TXD0 (SPICLK) .
//          <i> Note: gpio wizard select P70 RXD0 (MOSI) P71 TXD0 (SPICLK) .
#define URT0_Advance 0
//      <o>Mode
//          <0x00=>Mode 0 Shift(SM30=0,SM00=0,SM10=0)(Default)
//          <0x01=>Mode 1 8Bit(SM30=0,SM00=0,SM10=1)
//          <0x02=>Mode 2 9Bit(SM30=0,SM00=1,SM10=0)
//          <0x03=>Mode 3 9Bit(SM30=0,SM00=1,SM10=1)
//          <0x04=>Mode 4 Spi Master(SM30=1,SM00=0,SM10=0)
//          <0x05=>Mode 5 Lin Bus(SM30=1,SM00=0,SM10=1)
//          <i> Mode0~mode5 select .
#define URT0_Mode 0x00
//===========================================================
//      <e>Mode 0 Shift Enable
//===========================================================
#define URT0_Mode0_Shift 0
//      <o>Clock Source
//          <0=>System Clock(S0TCK=0,S0RCK=0)(Default)
//          <2=>S0BRG(S0TCK=1,S0RCK=0)
#define URT0_Mode0_Clock_Source 0
//      <e>System Clock
//          <i> Mode 0 shift clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; URM0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; URM0X3=1 .
#define URT0_Mode0_Shift_SYSCLK_Clock_Source 0
//      <e>System Clock for S0
#define URT0_Mode0_Shift_SYSCLK_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode0_Shift_SYSCLK_Data_Order 0x08
//      <o0.6>Source <0=>SYSCLK/12(URM0X3=0)(Default) <1=>SYSCLK/4(URM0X3=1)
//          <i> SYSCLK/12 (URM0X3=0) .
//          <i> SYSCLK/4 (URM0X3=1) .
#define URT0_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Shift In/Out <0=>Out(REN0=0)(Default) <1=>In(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 and RI0=0 .
//          <i> Transmission is initiated by any instruction that uses S0BUF as a destination register .
//          <i> After REN0 on/off , clear RI0 .
#define URT0_Mode0_Shift_SYSCLK_Input_Output 0
//      </e>System clock for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode0_Shift_SYSCLK_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode0_Shift_SYSCLK_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode0_Shift_SYSCLK_S0BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      <e>S0BRG
//          <i> Mode 0 shift clock source from S0BRG enable .
//          <i> S0TOF S0BRG overflow .
//          <i> Baud Rate = ((2^(SMOD2+2))/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode0_Shift_S0BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode0_Shift_S0BRG_Data_Order 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(SMOD2=0)(Default) <1=>Double Baud Rate(SMOD2=1)
//          <i> Defaule baud date (SMOD2=0) .
//          <i> Double baud rate (SMOD2=1) .
#define URT0_Mode0_Shift_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode0_Shift_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode0_Shift_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode0_Shift_S0BRG_S0BRG_Operation 0
//      <o>Shift In/Out <0=>Out(REN0=0)(Default) <1=>In(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 and RI0=0 .
//          <i> Transmission is initiated by any instruction that uses S0BUF as a destination register .
//          <i> After REN0 on/off , clear RI0 .
#define URT0_Mode0_Shift_S0BRG_Input_Output 0
//      </e>S0BRG
//      </e>Mode 0 Shift Enable
//===========================================================
//      <e>Mode 1 8Bit Enable
//===========================================================
#define URT0_Mode1_8Bit 0
//      <o>Clock Source
//          <0=>Timer1(S0TCK=0,S0RCK=0,TCLK=0,RCLK=0,URTS=0)(Default)
//          <1=>Timer2(S0TCK=0,S0RCK=0,TCLK=1,RCLK=1,URTS=0)
//          <2=>S0BRG(S0TCK=1,S0RCK=1,TCLK=0,RCLK=0,URTS=0)
//          <3=>S1BRG(S0TCK=0,S0RCK=0,TCLK=0,RCLK=0,URTS=1)
#define URT0_Mode1_Clock_Source 0
//      <e>Timer1
//          <i> Mode 1 8Bit clock source from timer1 enable .
#define URT0_Mode1_8Bit_Timer1_Clock_Source 0
//          <i> T1OF timer1 overflow .
//          <i> Baud Rate = ((2^SMOD1*2^SMOD2)/32) x T1OF .
//      <e>Timer1 for S0
#define URT0_Mode1_8Bit_Timer1_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode1_8Bit_Timer1_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0)(Default) .
//          <i> Double baud rate x1 (SMOD2=0 SMOD1=1) .
//          <i> Double baud rate x2 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x4 (SMOD2=1 SMOD1=1) .
#define URT0_Mode1_8Bit_Timer1_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode1_8Bit_Timer1_Reception 0
//      </e>Timer1 for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode1_8Bit_Timer1_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode1_8Bit_Timer1_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode1_8Bit_Timer1_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode1_8Bit_Timer1_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode1_8Bit_Timer1_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>Timer1
//      <e>Timer2
//          <i> Mode 1 8Bit clock source from timer2 enable .
#define URT0_Mode1_8Bit_Timer2_Clock_Source 0
//          <i> T2OF timer2 overflow .
//          <i> Timer2 in baud rate generator mode .
//          <i> Baud Rate = ((2^SMOD2*(SMOD1+1))/16) x T2OF .
//      <e>Timer2 for S0
#define URT0_Mode1_8Bit_Timer2_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0)<1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode1_8Bit_Timer2_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Default Baud Rate(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x1(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x2(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0)(Default) .
//          <i> Defaule baud date (SMOD2=0 SMOD1=1) .
//          <i> Double baud rate x1 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x2 (SMOD2=1 SMOD1=1) .
#define URT0_Mode1_8Bit_Timer2_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode1_8Bit_Timer2_Reception 0
//      </e>Timer2 for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode1_8Bit_Timer2_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode1_8Bit_Timer2_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode1_8Bit_Timer2_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode1_8Bit_Timer2_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode1_8Bit_Timer2_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>Timer2
//      <e>S0BRG
//          <i> Mode 1 8Bit clock source from S0BRG enable .
#define URT0_Mode1_8Bit_S0BRG_Clock_Source 0
//          <i> Baud Rate = ((2^SMOD2)/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode1_8Bit_S0BRG_Data_Order 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(SMOD2=0)(Default) <1=>Double Baud Rate(SMOD2=1)
//          <i> Defaule baud date (SMOD2=0) .
//          <i> Double baud rate (SMOD2=1) .
#define URT0_Mode1_8Bit_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode1_8Bit_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode1_8Bit_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode1_8Bit_S0BRG_S0BRG_Operation 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode1_8Bit_S0BRG_Reception 0
//      </e>S0BRG
//      <e>S1BRG
//          <i> Mode 1 8Bit clock source from S1BRG enable .
//          <i> If URTS bit (S0CFG.7) is set , then Timer 1 overflow signal will be replaced by the overflow signal of the UART1 Baud Rate Generator (S1BRG) .
//          <i> In other words , the user can adopt S1BRG as the Baud Rate Generator for Mode 1 or Mode 3 of the UART0 as long as RCLK=0 , TCLK=0 and URTS=1 .
//          <i> In this condition, Timer 1 is free for other application .
//          <i> Of course , if UART1 (Mode 1 or Mode 3) is also operated at this time , these two UARTs will have the same baud rates .
#define URT0_Mode1_8Bit_S1BRG_Clock_Source 0
//          <i> S1TOF S1BRG overflow .
//          <i> Baud Rate = S1TOF x ((2^SMOD1*2^(SMOD2*2))/32).
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
//      <e>S1BRG for S0
#define URT0_Mode1_8Bit_S1BRG_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode1_8Bit_S1BRG_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0) .
//          <i> Double baud rate x1 (SMOD2=0 SMOD1=1) .
//          <i> Double baud date x2 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x4 (SMOD2=1 SMOD1=1) .
#define URT0_Mode1_8Bit_S1BRG_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode1_8Bit_S1BRG_Reception 0
//      </e>S1BRG for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode1_8Bit_S1BRG_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode1_8Bit_S1BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode1_8Bit_S1BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode1_8Bit_S1BRG_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode1_8Bit_S1BRG_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>S1BRG
//      </e>Mode 1 8Bit Enable
//===========================================================
//      <e>Mode 2 9Bit Enable
//===========================================================
#define URT0_Mode2_9Bit 0
//      <o>Clock Source
//          <0=>System Clock : System Clock(S0TCK=0,S0RCK=0,TCLK=0,RCLK=0,URTS=0)(Default)
//          <1=>S0BRG : System Clock(S0TCK=1,S0RCK=0,TCLK=0,RCLK=0,URTS=0)
//          <2=>System Clock : S0BRG(S0TCK=0,S0RCK=1,TCLK=0,RCLK=0,URTS=0)
//          <3=>Pure Timer(S0TCK=1,S0RCK=1,TCLK=0,RCLK=0,URTS=1)
#define URT0_Mode2_Clock_Source 0
//      <e>System Clock : System Clock
//          <i> Mode 2 9Bit TX/RX clock source from system clock enable .
//          <i> Baud rate = ((2^SMOD1*2^(SMOD2*2))/64) x Fsysclk .
//          <i> BaudRate        EnhanceBaudRate             SYSCLK/n
//          <i> 172800          Default Baud Rate           SYSCLK/64       SYSCLK=11.0592MHZ
//          <i> 345600          Double Baud Rate X1         SYSCLK/32       SYSCLK=11.0592MHZ
//          <i> 691200          Double Baud Rate X2         SYSCLK/16       SYSCLK=11.0592MHZ
//          <i> 1382400         Double Baud Rate X4         SYSCLK/8        SYSCLK=11.0592MHZ
//          <i> 187500          Default Baud Rate           SYSCLK/64       SYSCLK=12MHZ
//          <i> 375000          Double Baud Rate X1         SYSCLK/32       SYSCLK=12MHZ
//          <i> 750000          Double Baud Rate X2         SYSCLK/16       SYSCLK=12MHZ
//          <i> 1500000         Double Baud Rate X4         SYSCLK/8        SYSCLK=12MHZ
#define URT0_Mode2_9Bit_SYSCLK_Clock_Source 0
//      <e>System Clock for S0
#define URT0_Mode2_9Bit_SYSCLK_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode2_9Bit_SYSCLK_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x4(SMOD2=1 SMOD1=1)
#define URT0_Mode2_9Bit_SYSCLK_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode2_9Bit_SYSCLK_Reception 0
//      </e>System Clock for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode2_9Bit_SYSCLK_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>System Clock : System Clock
//      <e>S0BRG : System Clock
//          <i> Mode 2 9Bit TX clock source from S0BRG and RX clock source from system clock enable .
//          <i> TX clock source select S0BRG .
//          <i> Baud Rate = ((2^SMOD2)/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
//          <i> RX clock source select system clock .
//          <i> Baud Rate = ((2^SMOD1*2^(SMOD2*2))/64) x Fsysclk .
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate : Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Default Baud Rate : Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x1 : Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x1 : Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Default Baud Rate (S0BRG) : Default Baud Rate (System Clock)(SMOD2=0 SMOD1=0) .
//          <i> Default Baud Rate (S0BRG) : Double Baud Rate x1 (System Clock)(SMOD2=0 SMOD1=1) .
//          <i> Double Baud Rate x1 (S0BRG) : Double Baud Rate x2 (System Clock)(SMOD2=1 SMOD1=0) .
//          <i> Double Baud Rate x1 (S0BRG) : Double Baud Rate x4 (System Clock)(SMOD2=1 SMOD1=1) .
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_S0BRG_Operation 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode2_9Bit_S0BRG_SYSCLK_Reception 0
//      </e>S0BRG : System Clock
//      <e>System Clock : S0BRG
//          <i> Mode 2 9Bit RX clock source from S0BRG and TX clock source from system clock enable .
//          <i> TX clock source select system clock .
//          <i> Baud Rate = ((2^SMOD1*2^(SMOD2*2))/64) x Fsysclk .
//          <i> RX clock source select S0BRG .
//          <i> Baud Rate = ((2^SMOD2)/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate : Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Default Baud Rate : Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x1 : Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x1 : Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Default Baud Rate (S0BRG) : Default Baud Rate (System Clock)(SMOD2=0 SMOD1=0) .
//          <i> Default Baud Rate (S0BRG) : Double Baud Rate x1 (System Clock)(SMOD2=0 SMOD1=1) .
//          <i> Double Baud Rate x1 (S0BRG) : Double Baud Rate x2 (System Clock)(SMOD2=1 SMOD1=0) .
//          <i> Double Baud Rate x1 (S0BRG) : Double Baud Rate x4 (System Clock)(SMOD2=1 SMOD1=1) .
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_S0BRG_Operation 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode2_9Bit_SYSCLK_S0BRG_Reception 0
//      </e>System Clock : S0BRG
//      <e>Pure Timer
//          <i> Mode 2 9Bit Pure timer enable .
#define URT0_Mode2_9Bit_Pure_Timer 0
//      <o>Timer <0=>16Bit(S0DOR=0) <1=>8Bit(S0DOR=1)(Default)
//          <i> Pure timer select 16Bit (S0DOR=0) or 8Bit (S0DOR=1) .
#define URT0_Mode2_9Bit_Timer_Pure_Timer 1
//      <e>8Bit
//          <i> 8bit pure timer(auto reload) .
//          <i> S0TOF S0BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 SM20=0.
//          <i> S0CKI = T1OF       ; S0TX12=0 SM20=1.
//          <i> S0CKI = Fsysclk/1  ; S0TX12=1 SM20=0.
//          <i> S0CKI = T0OF       ; S0TX12=1 SM20=1.
#define URT0_Mode2_9Bit_8Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S0TX12=0 SM20=0)(Default)
//          <1=>T1OF(S0TX12=0 SM20=1)
//          <2=>SYSCLK/1(S0TX12=1 SM20=0)
//          <3=>T0OF(S0TX12=1 SM20=1)
//          <i> SYSCLK/12(S0TX12=0 SM20=0) .
//          <i> T1OF(S0TX12=0 SM20=1) .
//          <i> SYSCLK/1(S0TX12=1 SM20=0) .
//          <i> T0OF(S0TX12=1 SM20=1) .
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S0 Interrupt <0=>Off(TB80=0)(Default) <1=>On(TB80=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_Baudrate_Generator_Overflow_S0_Interrupt 0
//      <o>External Pin Trigger S0 Interrupt <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Trigger_S0_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(SMOD1=0)(Default) <1=>On(SMOD1=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Baudrate_Generator_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB80=0)(Default) <1=>L level(RB80=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_Clock_Output_Control 0
//      <o>Block TI0 <0=>Off(BTI=0)(Default) <1=>On(BTI=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_Block_TI0 0
//      <o>TI0 in System Flag Interrupt <0=>Off(UTIE=0)(Default) <1=>On(UTIE=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_TI0_in_System_Flag_Interrupt 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_Operation 0
//      </e>8Bit
//      <e>16Bit
//          <i> 16Bit pure timer(auto reload 0) .
//          <i> S0TOF S0BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(65536-(S0BRT , S0BRC)) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 SM20=0.
//          <i> S0CKI = T1OF       ; S0TX12=0 SM20=1.
//          <i> S0CKI = Fsysclk/1  ; S0TX12=1 SM20=0.
//          <i> S0CKI = T0OF       ; S0TX12=1 SM20=1.
#define URT0_Mode2_9Bit_16Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S0TX12=0 SM20=0)(Default)
//          <1=>T1OF(S0TX12=0 SM20=1)
//          <2=>SYSCLK/1(S0TX12=1 SM20=0)
//          <3=>T0OF(S0TX12=1 SM20=1)
//          <i> SYSCLK/12(S0TX12=0 SM20=0) .
//          <i> T1OF(S0TX12=0 SM20=1) .
//          <i> SYSCLK/1(S0TX12=1 SM20=0) .
//          <i> T0OF(S0TX12=1 SM20=1) .
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S0 Interrupt <0=>Off(TB80=0)(Default) <1=>On(TB80=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_Baudrate_Generator_Overflow_S0_Interrupt 0
//      <o>External Pin Trigger S0 Interrupt <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Trigger_S0_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(SMOD1=0)(Default) <1=>On(SMOD1=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Baudrate_Generator_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB80=0)(Default) <1=>L level(RB80=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~65535) <0-65535>
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_Clock_Output_Control 0
//      <o>Block TI0 <0=>Off(BTI=0)(Default) <1=>On(BTI=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_Block_TI0 0
//      <o> TI0 in System Flag Interrupt <0=>Off(UTIE=0)(Default) <1=>On(UTIE=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_TI0_in_System_Flag_Interrupt 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_Operation 0
//      </e>16Bit
//      </e>Pure Timer
//      </e>Mode 2 9Bit Enable

//===========================================================
//      <e>Mode 3 9Bit Enable
//===========================================================
#define URT0_Mode3_9Bit 0
//      <o>Clock Source
//          <0x00=>Timer1(S0TCK=0,S0RCK=0,TCLK=0,RCLK=0,URTS=0)(Default)
//          <0x01=>Timer2(S0TCK=0,S0RCK=0,TCLK=1,RCLK=1,URTS=0)
//          <0x02=>S0BRG(S0TCK=1,S0RCK=1,TCLK=0,RCLK=0,URTS=0)
//          <0x03=>S1BRG(S0TCK=0,S0RCK=0,TCLK=0,RCLK=0,URTS=1)
#define URT0_Mode3_Clock_Source 0x00
//      <e>Timer1
//          <i> Mode 3 9Bit clock source from timer1 enable .
#define URT0_Mode3_9Bit_Timer1_Clock_Source 0
//          <i> T1OF timer1 overflow .
//          <i> Baud Rate = ((2^SMOD1*2^SMOD2)/32) x T1OF .
//      <e>Timer1 for S0
#define URT0_Mode3_9Bit_Timer1_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode3_9Bit_Timer1_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0)(Default) .
//          <i> Double baud rate x1 (SMOD2=0 SMOD1=1) .
//          <i> Double baud rate x2 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x4 (SMOD2=1 SMOD1=1) .
#define URT0_Mode3_9Bit_Timer1_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode3_9Bit_Timer1_Reception 0
//      </e>Timer1 for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode3_9Bit_Timer1_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode3_9Bit_Timer1_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode3_9Bit_Timer1_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode3_9Bit_Timer1_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode3_9Bit_Timer1_Operation 0
//      </e>Baud Rate Generator for Others .
//      </e>Timer1
//      <e>Timer2
//          <i> Mode 3 9Bit clock source from timer2 enable .
#define URT0_Mode3_9Bit_Timer2_Clock_Source 0
//          <i> T2OF timer2 overflow .
//          <i> Timer2 in baud rate generator mode .
//          <i> Baud Rate = ((2^SMOD2*(SMOD1+1))/16) x T2OF .
//      <e>Timer2 for S0
#define URT0_Mode3_9Bit_Timer2_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode3_9Bit_Timer2_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Default Baud Rate(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x1(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x2(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0)(Default) .
//          <i> Defaule baud date (SMOD2=0 SMOD1=1) .
//          <i> Double baud rate x1 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x2 (SMOD2=1 SMOD1=1) .
#define URT0_Mode3_9Bit_Timer2_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode3_9Bit_Timer2_Reception 0
//      </e>Timer2 for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode3_9Bit_Timer2_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode3_9Bit_Timer2_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode3_9Bit_Timer2_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode3_9Bit_Timer2_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode3_9Bit_Timer2_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>Timer2
//      <e>S0BRG
//          <i> Mode 3 9Bit clock source from S0BRG enable .
#define URT0_Mode3_9Bit_S0BRG_Clock_Source 0
//          <i> Baud Rate = ((2^SMOD2)/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode3_9Bit_S0BRG_Data_Order 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(SMOD2=0)(Default) <1=>Double Baud Rate(SMOD2=1)
//          <i> Defaule baud date (SMOD2=0) .
//          <i> Double baud rate (SMOD2=1) .
#define URT0_Mode3_9Bit_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode3_9Bit_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode3_9Bit_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode3_9Bit_S0BRG_S0BRG_Operation 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode3_9Bit_S0BRG_Reception 0
//      </e>S0BRG
//      <e>S1BRG
//          <i> Mode 3 9Bit clock source from S1BRG enable .
#define URT0_Mode3_9Bit_S1BRG_Clock_Source 0
//          <i> S1TOF S1BRG overflow .
//          <i> Baud Rate = S1TOF x ((2^SMOD1*2^(SMOD2*2))/32).
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
//      <e>S1BRG for S0
#define URT0_Mode3_9Bit_S1BRG_Clock_Source_for_S0 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode3_9Bit_S1BRG_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(SMOD2=0 SMOD1=0)(Default)
//          <1=>Double Baud Rate x1(SMOD2=0 SMOD1=1)
//          <2=>Double Baud Rate x2(SMOD2=1 SMOD1=0)
//          <3=>Double Baud Rate x4(SMOD2=1 SMOD1=1)
//          <i> Defaule baud date (SMOD2=0 SMOD1=0) .
//          <i> Double baud rate x1 (SMOD2=0 SMOD1=1) .
//          <i> Double baud date x2 (SMOD2=1 SMOD1=0) .
//          <i> Double baud rate x4 (SMOD2=1 SMOD1=1) .
#define URT0_Mode3_9Bit_S1BRG_Baud_Rate 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i>Reception is initiated by the condition REN0=1 .
#define URT0_Mode3_9Bit_S1BRG_Reception 0
//      </e>S1BRG for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode3_9Bit_S1BRG_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode3_9Bit_S1BRG_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode3_9Bit_S1BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode3_9Bit_S1BRG_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode3_9Bit_S1BRG_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>S1BRG
//      </e>Mode 3 9Bit Enable
//===========================================================
//      <e>Mode 4 SPI Master Enable
//===========================================================
//          <i> No support CPOL now .
//          <i> Note: gpio wizard select P30 (RXD0) MOSI P31 (TXD0) SPICLK .
//          <i> Note: gpio wizard select P44 (RXD0) MOSI P45 (TXD0) SPICLK .
//          <i> Note: gpio wizard select P31 (RXD0) MOSI P30 (TXD0) SPICLK .
//          <i> Note: gpio wizard select P70 (RXD0) MOSI P71 (TXD0) SPICLK .
//          <i> Note: gpio wizard select P62 or P57 S0MI .
#define URT0_Mode4_Spi_Master 0
//      <o>Clock Source
//          <0=>Sysclk(S0TCK=0,S0RCK=0)(Default)
//          <1=>S0BRG(S0TCK=1,S0RCK=0)
#define URT0_Mode4_Clock_Source 0
//      <e>System Clock
//          <i> Mode 0 shift clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; URM0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; URM0X3=1 .
#define URT0_Mode4_Spi_Master_SYSCLK_Clock_Source 0
//      <e>System Clock for S0
#define URT0_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S0 0
//      <o.0> Source
//          <0=>SYSCLK/12(URM0X3=0)(Default)
//          <1=>SYSCLK/4(URM0X3=1)
//          <i> Note : baud rate from SYSCLK/4 or SYSCLK/12 (S0TCK=0) .
#define URT0_Mode4_Spi_Master_SYSCLK_Clock_Source_SYSCLK 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode4_Spi_Master_SYSCLK_Data_Order 0x08
//      </e>System Clock for S0
//      <e>Baud Rate Generator for Others
//          <i> S0TOF S0BRG overflow .
//          <i> Baud rate = S0TOF .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
#define URT0_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1 (S0TX12=1) .
#define URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Clock Output Control <0=>Off(S0CKOE=0)(Default) <1=>On(S0CKOE=1)
//          <i> Note: S0BRG clock output (S0CKO) port pin select P44 or P47 .
#define URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Clock_Output_Control 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Operation 0
//      </e>Baud Rate Generator for Others
//      </e>System clock
//      <e>S0BRG
//          <i> Mode 4 spi master clock source from S0BRG enable .
#define URT0_Mode4_Spi_Master_S0BRG_Clock_Source 0
//          <i> Note : baud rate from S0BRG(S0TCK=1) .
//          <i> S0TOF S0BRG overflow .
//          <i> Baud Rate = ((2^(SMOD2+2))/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode4_Spi_Master_S0BRG_Data_Order 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(SMOD2=0)(Default) <1=>Double Baud Rate(SMOD2=1)
//          <i> Note : baud rate from S0BRG(S0TCK=1) .
//          <i> Defaule baud date (SMOD2=0) .
//          <i> Double baud rate (SMOD2=1) .
#define URT0_Mode4_Spi_Master_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> Note : baud rate from S0BRG (S0TCK=1) .
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode4_Spi_Master_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode4_Spi_Master_S0BRG_Baud_Rate_Reload_Count 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode4_Spi_Master_S0BRG_S0BRG_Operation 0
//      </e>S0BRG
//      </e>Mode4 Spi Master
//===========================================================
//      <e>Mode 5 Lin Bus Enable
//===========================================================
#define URT0_Mode5_Lin_Bus 0
//      <o0.3>Data Order <0=>MSB(S0DOR=0) <1=>LSB(S0DOR=1)(Default)
//          <i> Data order select MSB (S0DOR=0) or LSB (S0DOR=1) .
#define URT0_Mode5_Lin_Bus_S0BRG_Data_Order 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(SMOD2=0)(Default) <1=>Double Baud Rate(SMOD2=1)
//          <i> Defaule baud date (SMOD2=0) .
//          <i> Double baud rate (SMOD2=1) .
#define URT0_Mode5_Lin_Bus_S0BRG_Baud_Rate 0
//      <o0.6>Source <0=>SYSCLK/12(S0TX12=0)(Default) <1=>SYSCLK/1(S0TX12=1)
//          <i> SYSCLK/12 (S0TX12=0) .
//          <i> SYSCLK/1  (S0TX12=1) .
#define URT0_Mode5_Lin_Bus_S0BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT0_Mode5_Lin_Bus_S0BRG_Baud_Rate_Reload_Count 0
//          <i> Baud Rate = ((2^SMOD2)/16) x S0TOF / 2 .
//          <i> S0TOF = S0CKI/(256-S0BRT) .
//          <i> S0CKI = Fsysclk/12 ; S0TX12=0 .
//          <i> S0CKI = Fsysclk/1 ; S0TX12=1 .
//      <o>Lin Bus Break Length <0=>13BIT(S0SB16=0)(Default) <1=>16BIT(S0SB16=1)
//          <i> Select 13-bit sync-break (S0SB16=0) .
//          <i> Select 16-bit sync-break (S0SB16=1) .
#define URT0_Mode5_Lin_Bus_S0BRG_Break_Length 0
//      <o>TX:RX Selection <0=>RX function(TXRX0=0)(Default) <1=>TX function(TXRX0=1)
//          <i> TX selection on S0 LIN bus (TXRX0=1) .
//          <i> RX selection on S0 LIN bus (TXRX0=0) .
#define URT0_Mode5_Lin_Bus_S0BRG_TX_RX_Selection 0
//      <o>Reception <0=>Off(REN0=0)(Default) <1=>On(REN0=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT0_Mode5_Lin_Bus_S0BRG_Reception 0
//      <o>S0BRG Operation <0=>Off(S0TR=0)(Default) <1=>On(S0TR=1)
#define URT0_Mode5_Lin_Bus_S0BRG_Operation 0

//      </e>Mode 5 Lin Bus Enable
//      </e>UART0 Enable
//      </e>Advanced Mode
//      </e>Serial Port 0 (UART0)
/**
*******************************************************************************
* @brief        UART0 Easy Wizard
* @details      Initial UART0 Mode Baud Rate PinMux SerialReception
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT0_Easy_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_URT0_Easy_Wizard_Init()\
    MWT(\
        __DRV_URT0_EasyDisableSerialReception(URT0_Easy_Select);\
        __DRV_URT0_Mode_Easy_Select(URT0_Easy_Select);\
        __DRV_URT0_BaudRate_Easy_Select(URT0_Easy_Select);\
        __DRV_URT0_PinMux_Easy_Select(URT0_Easy_Select);\
        __DRV_URT0_EasyEnableSerialReception(URT0_Easy_Select);\
    ;)
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0>Initialize Serial Port 1 (UART1)
//      <i> Check this term, then DRV_UART1_Wizard_Init() will initialize UART1.
//      <i> Date: 2024/03/07     Version: 1.01
#define MG82F6D64_UART1_WIZARD      0
//-----------------------------------------------------------------------------
//      <o>UART1
//          <0=>Easy Mode(Default)
//          <1=>Advanced Mode
//          <i> UART1 option select .
#define URT1_Option 0
//      <e>Easy Mode
#define URT1_Easy_Mode 1
//      <e>UART1 Enable
#define URT1_Easy 0
//      <o>Easy Select
//          <0=>Select0(Default)
//          <1=>Select1
//          <2=>Select2
//          <3=>Select3
//          <4=>Select4
//          <5=>Select5
//          <6=>Select6
//          <7=>Select7
//          <8=>Select8
//          <9=>Select9
//          <10=>Select10
//          <11=>Select11
//          <12=>Select12
//          <13=>Select13
//          <14=>Select14
//          <15=>Select15
//          <16=>Select16
//          <17=>Select17
//          <18=>Select18
//          <19=>Select19
//          <20=>Select20
//          <21=>Select21
//          <22=>Select22
//          <23=>Select23
//          <24=>Select24
//          <25=>Select25
//          <26=>Select26
//          <27=>Select27
//          <28=>Select28
//          <29=>Select29
//          <30=>Select30
//          <31=>Select31
//          <32=>Select32
//          <33=>Select33
//          <34=>Select34
//          <35=>Select35
//          <36=>Select36
//          <37=>Select37
//          <38=>Select38
//          <39=>Select39
//          <40=>Select40
//          <41=>Select41
//          <42=>Select42
//          <43=>Select43
//          <44=>Select44
//          <45=>Select45
//          <46=>Select46
//          <47=>Select47
//          <48=>Select48
//          <49=>Select49
//          <50=>Select50
//          <51=>Select51
//          <52=>Select52
//          <53=>Select53
//          <54=>Select54
//          <55=>Select55
//          <56=>Select56
//          <57=>Select57
//          <58=>Select58
//          <59=>Select59
//          <60=>Select60
//          <61=>Select61
//          <62=>Select62
//          <63=>Select63
//          <64=>Select64
//          <65=>Select65
//          <66=>Select66
//          <67=>Select67
//          <68=>Select68
//          <69=>Select69
//          <70=>Select70
//          <71=>Select71
//          <72=>Select72
//          <73=>Select73

#define URT1_Easy_Select 0
//          <i> Note:Please confirm clock source before you select parameter .
//          <i> Select0:    9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select1:    9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select2:    19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select3:    19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select4:    57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select5:    57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select6:    115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select7:    115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select8:    57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select9:    57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select10:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select11:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select12:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select13:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select14:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select15:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select16:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select17:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select18:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select19:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select20:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select21:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select22:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select23:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select24:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select25:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select26:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select27:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select28:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select29:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select30:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select31:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select32:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select33:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select34:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select35:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select36:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select37:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select38:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select39:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select40:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select41:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select42:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select43:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select44:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select45:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select46:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select47:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select48:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select49:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select50:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select51:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select52:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select53:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select54:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select55:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select56:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select57:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select58:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select59:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select60:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select61:   9600    8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select62:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select63:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select64:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select65:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select66:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select67:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select68:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select69:   115200  8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select70:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select71:   57600   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select72:   19200   8Bit    S1BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select73:   19200   8BIt    S1BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P34 Tx=P35   Tx Rx Both      SYSCLK=48Mhz
//      </e>UART1 Enable
//      </e>Easy Mode
//      <e>Advanced Mode
#define URT1_Advance_Mode 0
//      <e>UART1 Enable
//          <i> Mode0 Shift .
//          <i> Mode1 8bit .
//          <i> Mode2 9bit .
//          <i> Mode3 9bit .
//          <i> Mode4 Spi Master .
//          <i> Note: gpio wizard select P12 RXD1 (MOSI) P13 TXD1 (SPICLK) .
//          <i> Note: gpio wizard select P71 RXD1 (MOSI) P70 TXD1 (SPICLK) .
//          <i> Note: gpio wizard select P20 RXD1 (MOSI) P21 TXD1 (SPICLK) .
//          <i> Note: gpio wizard select P34 RXD1 (MOSI) P35 TXD1 (SPICLK) .
#define URT1_Advance 0
//      <o>Mode
//          <0=>Uart Mode(S1TME=0)(Default)
//          <1=>Timer Mode(S1TME=1)
//          <i> Uart/timer mode select .
#define URT1_Uart_Timer_Mode 0
//      <e>Uart Mode
#define URT1_Uart_Mode 0
//      <o>Mode
//          <0x00=>Mode 0 Shift(SM31=0,SM01=0,SM11=0)(Default)
//          <0x01=>Mode 1 8Bit(SM31=0,SM01=0,SM11=1)
//          <0x02=>Mode 2 9Bit(SM31=0,SM01=1,SM11=0)
//          <0x03=>Mode 3 9Bit(SM31=0,SM01=1,SM11=1)
//          <0x04=>Mode 4 Spi Master(SM31=1,SM01=0,SM11=0)
//          <i> Mode0~mode4 select .
#define URT1_Mode  0x00
//===========================================================
//      <e>Mode 0 Shift Enable
//===========================================================
#define URT1_Mode0_Shift 0
//      <e>System Clock
//          <i> Mode 0 shift clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S1M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S1M0X3=1 .
#define URT1_Mode0_Shift_SYSCLK_Clock_Source 0
//      <e>System Clock for S1
#define URT1_Mode0_Shift_SYSCLK_Clock_Source_for_S1 0
//      <o0.3>Data Order <0=>MSB(S1DOR=0) <1=>LSB(S1DOR=1)(Default)
//          <i> Data order select MSB (S1DOR=0) or LSB (S1DOR=1) .
#define URT1_Mode0_Shift_SYSCLK_Data_Order 0x08
//      <o0.6>Source <0=>SYSCLK/12(S1M0X3=0)(Default) <1=>SYSCLK/4(S1M0X3=1)
//          <i> SYSCLK/12 (S1M0X3=0) .
//          <i> SYSCLK/4 (S1M0X3=1) .
#define URT1_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Shift In/Out <0=>Out(REN1=0)(Default) <1=>In(REN1=1)
//          <i> Reception is initiated by the condition REN1=1 and RI1=0 .
//          <i> Transmission is initiated by any instruction that uses S1BUF as a destination register .
//          <i> After REN1 on/off , clear RI1 .
#define URT1_Mode0_Shift_SYSCLK_Input_Output 0
//      </e>System clock for S1
//      <e>Baud Rate Generator for Others
//          <i> S1TOF S1BRG overflow .
//          <i> Baud rate = S1TOF .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1 (S1TX12=1) .
#define URT1_Mode0_Shift_SYSCLK_S1BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT1_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S1BRG Clock Output Control <0=>Off(S1CKOE=0)(Default) <1=>On(S1CKOE=1)
//          <i> Note: S1BRG clock output (S1CKO) port pin select P45 or P46 .
#define URT1_Mode0_Shift_SYSCLK_Clock_Output_Control 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode0_Shift_SYSCLK_S1BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 0 Shift Enable
//===========================================================
//      <e>Mode 1 8Bit Enable
//===========================================================
#define URT1_Mode1_8Bit 0
//      <e>S1BRG
//          <i> Mode 1 8Bit clock source from S1BRG enable .
#define URT1_Mode1_8Bit_S1BRG_Clock_Source 0
//      <o>Baud Rate Generator
//          <0=>Baud Rate Generator for S1(Default)
//          <2=>Baud Rate Generator for S0
//          <i> Mode1 8bit Baud Rate Generator to S0/S1 select .
#define URT1_Mode1_8Bit_Baud_Rate_Generator 0
//      <e>Baud Rate Generator for S1
//          <i> Baud Rate = ((2^S1MOD1)/16) x S1TOF / 2 .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode1_8Bit_Baud_Rate_Generator_for_S1 0
//      <o0.3>Data Order <0=>MSB(S1DOR=0) <1=>LSB(S1DOR=1)(Default)
//          <i> Data order select MSB (S1DOR=0) or LSB (S1DOR=1) .
#define URT1_Mode1_8Bit_Data_Order_for_S1 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S1MOD1=0)(Default) <1=>Double Baud Rate(S1MOD1=1)
//          <i> Default baud rate (S1MOD1=0) .
//          <i> Double  baud rate (S1MOD1=1) .
#define URT1_Mode1_8Bit_Baud_Rate_for_S1 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1  (S1TX12=1) .
#define URT1_Mode1_8Bit_Clock_Source_for_S1 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT1_Mode1_8Bit_Baud_Rate_Reload_Count_for_S1 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode1_8Bit_S1BRG_S1BRG_Operation_for_S1 0
//      <o>Reception <0=>Off(REN1=0)(Default) <1=>On(REN1=1)
//          <i> Reception is initiated by the condition REN1=1 .
#define URT1_Mode1_8Bit_S1BRG_Reception 0
//      </e>Baud Rate Generator for S1
//      <e>Baud Rate Generator for S0
//          <i> Baud Rate Generator for S0 enable .
//          <i> In the Mode 1 and Mode 3 operation of the UART0, the software can select Timer 1 as the Baud Rate Generator by clearing bits TCLK and RCLK in T2CON register.
//          <i> At this time, if URTS bit (S0CFG.7) is set, then Timer 1 overflow signal will be replaced by the overflow signal of the UART1 Baud Rate Generator (S1BRG).
//          <i> In other words, the user can adopt S1BRG as the Baud Rate Generator for Mode 1 or Mode 3 of the UART0 as long as RCLK=0, TCLK=0 and URTS=1. In this condition, Timer 1 is free for other application.
//          <i> Of course, if UART1 (Mode 1 or Mode 3) is also operated at this time, these two UARTs will have the same baud rates.
//          <i> S1TOF S1BRG overflow .
//          <i> Baud Rate = S1TOF x ((2^SMOD1*2^(SMOD2*2))/32).
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode1_8Bit_Baud_Rate_Generator_for_S0 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1  (S1TX12=1) .
#define URT1_Mode1_8Bit_Clock_Source_for_S0 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT1_Mode1_8Bit_Baud_Rate_Reload_Count_for_S0 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode1_8Bit_S1BRG_S1BRG_Operation_for_S0 0
//      </e>Baud Rate Generator for S0
//      </e>S1BRG
//      </e>Mode 1 8Bit Enable
//===========================================================
//      <e> Mode 2 9Bit Enable
//===========================================================
#define URT1_Mode2_9Bit 0
//      <e>System Clock
//          <i> Mode 2 9bit clock source from system clock enable .
//          <i> Baud rate = ((2^S1MOD1)/64) x Fsysclk ;S1M0X3=0 .
//          <i> Baud rate = ((2^S1MOD1)/192) x Fsysclk ;S1M0X3=1 .
//          <i> BaudRate        EnhanceBaudRate             SYSCLK/n
//          <i> 172800          Default Baud Rate           SYSCLK/64       SYSCLK=11.0592MHZ
//          <i> 345600          Double Baud Rate            SYSCLK/32       SYSCLK=11.0592MHZ
//          <i> 57600           Default Baud Rate           SYSCLK/192      SYSCLK=11.0592MHZ
//          <i> 115200          Double Baud Rate            SYSCLK/96       SYSCLK=11.0592MHZ
//          <i> 187500          Default Baud Rate           SYSCLK/64       SYSCLK=12MHZ
//          <i> 375000          Double Baud Rate            SYSCLK/32       SYSCLK=12MHZ
//          <i> 62500           Default Baud Rate           SYSCLK/192      SYSCLK=12MHZ
//          <i> 125000          Double Baud Rate            SYSCLK/96       SYSCLK=12MHZ
#define URT1_Mode2_9Bit_SYSCLK_Clock_Source 0
//      <e>System Clock for S1
#define URT1_Mode2_9Bit_SYSCLK_Clock_Source_for_S1 0
//      <o0.3>Data Order <0=>MSB(S1DOR=0) <1=>LSB(S1DOR=1)(Default)
//          <i> Data order select MSB (S1DOR=0) or LSB (S1DOR=1).
#define URT1_Mode2_9Bit_SYSCLK_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(S1MOD1=0)(Default)
//          <1=>Double Baud Rate(S1MOD1=1)
//          <i> Default baud rate  (S1MOD1=0) .
//          <i> Double Baud Rate   (S1MOD1=1) .
#define URT1_Mode2_9Bit_SYSCLK_Baud_Rate 0
//          <o0.6>Source <0=>SYSCLK/1(S1M0X3=0)(Default) <1=>SYSCLK/3(S1M0X3=1)
//          <i> SYSCLK/1 (S1M0X3=0,S1MOD1=0 SYSCLK/64).
//          <i> SYSCLK/1 (S1M0X3=0,S1MOD1=1 SYSCLK/32).
//          <i> SYSCLK/3 (S1M0X3=1,S1MOD1=0,SYSCLK/192).
//          <i> SYSCLK/3 (S1M0X3=1,S1MOD1=1,SYSCLK/96).
#define URT1_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Reception <0=>Off(REN1=0)(Default) <1=>On(REN1=1)
//          <i> Reception is initiated by the condition REN0=1 .
#define URT1_Mode2_9Bit_SYSCLK_Reception 0
//      </e>System Clock for S1
//      <e>Baud Rate Generator for Others
//          <i> S1TOF S1BRG overflow .
//          <i> Baud rate = S1TOF .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1 (S1TX12=1) .
#define URT1_Mode2_9Bit_SYSCLK_S1BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT1_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S1BRG Clock Output Control <0=>Off(S1CKOE=0)(Default) <1=>On(S1CKOE=1)
//          <i> Note: S1BRG clock output (S1CKO) port pin select P45 or P46 .
#define URT1_Mode2_9Bit_SYSCLK_Clock_Output_Control 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode2_9Bit_SYSCLK_S1BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 2 9Bit Enable
//===========================================================
//      <e>Mode 3 9Bit Enable
//===========================================================
#define URT1_Mode3_9Bit 0
//      <e>S1BRG
//          <i> Mode 3 9Bit clock source from S1BRG enable .
#define URT1_Mode3_9Bit_S1BRG_Clock_Source 0
//      <o>Baud Rate Generator
//          <0=>Baud Rate Generator for S1(Default)
//          <2=>Baud Rate Generator for S0
//          <i> Mode3 9bit Baud Rate Generator to S0/S1 select .
#define URT1_Mode3_9Bit_Baud_Rate_Generator 0
//      <e>Baud Rate Generator for S1
//          <i> Baud Rate = ((2^S1MOD1)/16) x S1TOF / 2 .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode3_9Bit_Baud_Rate_Generator_for_S1 0
//      <o0.3>Data Order <0=>MSB(S1DOR=0) <1=>LSB(S1DOR=1)(Default)
//          <i> Data order select MSB (S1DOR=0) or LSB (S1DOR=1) .
#define URT1_Mode3_9Bit_Data_Order_for_S1 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S1MOD1=0)(Default) <1=>Double Baud Rate(S1MOD1=1)
//          <i> Default baud rate (S1MOD1=0) .
//          <i> Double  baud rate (S1MOD1=1) .
#define URT1_Mode3_9Bit_Baud_Rate_for_S1 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1  (S1TX12=1) .
#define URT1_Mode3_9Bit_Clock_Source_for_S1 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT1_Mode3_9Bit_Baud_Rate_Reload_Count_for_S1 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode3_9Bit_S1BRG_S1BRG_Operation_for_S1 0
//      <o>Reception <0=>Off(REN1=0)(Default) <1=>On(REN1=1)
//          <i> Reception is initiated by the condition REN1=1 .
#define URT1_Mode3_9Bit_S1BRG_Reception 0
//      </e>Baud Rate Generator for S1
//      <e>Baud Rate Generator for S0
//          <i> In the Mode 1 and Mode 3 operation of the UART0, the software can select Timer 1 as the Baud Rate Generator by clearing bits TCLK and RCLK in T2CON register.
//          <i> At this time, if URTS bit (S0CFG.7) is set, then Timer 1 overflow signal will be replaced by the overflow signal of the UART1 Baud Rate Generator (S1BRG).
//          <i> In other words, the user can adopt S1BRG as the Baud Rate Generator for Mode 1 or Mode 3 of the UART0 as long as RCLK=0, TCLK=0 and URTS=1. In this condition, Timer 1 is free for other application.
//          <i> Of course, if UART1 (Mode 1 or Mode 3) is also operated at this time, these two UARTs will have the same baud rates.
//          <i> S1TOF S1BRG overflow .
//          <i> Baud Rate = S1TOF x ((2^SMOD1*2^(SMOD2*2))/32).
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode3_9Bit_Baud_Rate_Generator_for_S0 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1  (S1TX12=1) .
#define URT1_Mode3_9Bit_Clock_Source_for_S0 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT1_Mode3_9Bit_Baud_Rate_Reload_Count_for_S0 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode3_9Bit_S1BRG_S1BRG_Operation_for_S0 0
//      </e>Baud Rate Generator for S0
//      </e>S1BRG
//      </e>Mode 3 9Bit Enable
//===========================================================
//      <e> Mode 4 SPI Master Enable
//===========================================================
//          <i> No support CPOL now.
//          <i> Note: gpio wizard select P12 (RXD1) MOSI P13 (TXD1) SPICLK .
//          <i> Note: gpio wizard select P71 (RXD1) MOSI P70 (TXD1) SPICLK .
//          <i> Note: gpio wizard select P20 (RXD1) MOSI P21 (TXD1) SPICLK .
//          <i> Note: gpio wizard select P34 (RXD1) MOSI P35 (TXD1) SPICLK .
//          <i> Note: gpio wizard select P63 or P67 S1MI .
#define URT1_Mode4_Spi_Master 0
//      <e>System Clock
//          <i> Mode 4 spi master clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S1M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S1M0X3=1 .
#define URT1_Mode4_Spi_Master_SYSCLK_Clock_Source 0
//      <e>System Clock for S1
#define URT1_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S1 0
//      <o0.3>Data Order <0=>MSB(S1DOR=0) <1=>LSB(S1DOR=1)(Default)
//          <i> Data order select MSB (S1DOR=0) or LSB (S1DOR=1).
#define URT1_Mode4_Spi_Master_Data_Order 0x08
//          <o0.6>Source <0=>SYSCLK/12(S1M0X3=0)(Default) <1=>SYSCLK/4(S1M0X3=1)
//          <i> SYSCLK/12 (S1M0X3=0).
//          <i> SYSCLK/4 (S1M0X3=1).
#define URT1_Mode4_Spi_Master_Clock_Source 0
//      </e>System Clock for S1
//      <e>Baud Rate Generator for Others
//          <i> S1TOF S1BRG overflow .
//          <i> Baud rate = S1TOF .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 .
//          <i> S1CKI = Fsysclk/1 ; S1TX12=1 .
#define URT1_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S1TX12=0)(Default) <1=>SYSCLK/1(S1TX12=1)
//          <i> SYSCLK/12 (S1TX12=0) .
//          <i> SYSCLK/1 (S1TX12=1) .
#define URT1_Mode4_Spi_Master_SYSCLK_S1BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT1_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S1BRG Clock Output Control <0=>Off(S1CKOE=0)(Default) <1=>On(S1CKOE=1)
//          <i> Note: S1BRG clock output (S1CKO) port pin select P45 or P46 .
#define URT1_Mode4_Spi_Master_Clock_Output_Control 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Mode4_Spi_Master_S1BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 4 SPI Master Enable
//      </e>Uart Mode
//      <e>Timer Mode
#define URT1_Timer_Mode 0
//      <o>S1BRG
//          <1=>8Bit Pure Timer(S1DOR=1)(Default)
//          <0=>16Bit Pure Timer(S1DOR=0)
//          <i> Baud rate generator function .
#define URT1_Timer_Mode_Pure_Timer 1
//      <e>8Bit Pure Timer
//          <i> 8bit pure timer(auto reload) .
//          <i> S1TOF S1BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S1TOF .
//          <i> S1TOF = S1CKI/(256-S1BRT) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 SM21=0.
//          <i> S1CKI = T1OF       ; S1TX12=0 SM21=1.
//          <i> S1CKI = Fsysclk/1  ; S1TX12=1 SM21=0.
//          <i> S1CKI = T0OF       ; S1TX12=1 SM21=1.
#define URT1_Timer_Mode_8Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S1TX12=0 SM21=0)(Default)
//          <1=>T1OF(S1TX12=0 SM21=1)
//          <2=>SYSCLK/1(S1TX12=1 SM21=0)
//          <3=>T0OF(S1TX12=1 SM21=1)
//          <i> SYSCLK/12(S1TX12=0 SM21=0) .
//          <i> T1OF(S1TX12=0 SM21=1) .
//          <i> SYSCLK/1(S1TX12=1 SM21=0) .
//          <i> T0OF(S1TX12=1 SM21=1) .
#define URT1_Timer_Mode_8Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S1 Interrupt <0=>Off(TB81=0)(Default) <1=>On(TB81=1)
#define URT1_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S1_Interrupt 0
//      <o>External Pin Trigger S1 Interrupt <0=>Off(REN1=0)(Default) <1=>On(REN1=1)
#define URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S1_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S1MOD1=0)(Default) <1=>On(S1MOD1=1)
#define URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB81=0)(Default) <1=>L level(RB81=1)
#define URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT1_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S1BRG Clock Output Control <0=>Off(S1CKOE=0)(Default) <1=>On(S1CKOE=1)
//          <i> Note: S1BRG clock output (S1CKO) port pin select P45 or P46 .
#define URT1_Timer_Mode_8Bit_Pure_Timer_S1BRG_Clock_Output_Control 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Timer_Mode_8Bit_Pure_Timer_S1BRG_Operation 0
//      </e>8Bit Pure Timer
//      <e>16Bit Pure Timer
//          <i> 16Bit pure timer(auto reload 0) .
//          <i> S1TOF S1BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S1TOF .
//          <i> S1TOF = S1CKI/(65536-(S1BRT,S1BRC)) .
//          <i> S1CKI = Fsysclk/12 ; S1TX12=0 SM21=0.
//          <i> S1CKI = T1OF       ; S1TX12=0 SM21=1.
//          <i> S1CKI = Fsysclk/1  ; S1TX12=1 SM21=0.
//          <i> S1CKI = T0OF       ; S1TX12=1 SM21=1.
#define URT1_Timer_Mode_16Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S1TX12=0 SM21=0)(Default)
//          <1=>T1OF(S1TX12=0 SM21=1)
//          <2=>SYSCLK/1(S1TX12=1 SM21=0)
//          <3=>T0OF(S1TX12=1 SM21=1)
//          <i> SYSCLK/12(S1TX12=0 SM21=0) .
//          <i> T1OF(S1TX12=0 SM21=1) .
//          <i> SYSCLK/1(S1TX12=1 SM21=0) .
//          <i> T0OF(S1TX12=1 SM21=1) .
#define URT1_Timer_Mode_16Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S1 Interrupt <0=>Off(TB81=0)(Default) <1=>On(TB81=1)
#define URT1_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S1_Interrupt 0
//      <o>External Pin Trigger S1 Interrupt <0=>Off(REN1=0)(Default) <1=>On(REN1=1)
#define URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S1_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S1MOD1=0)(Default) <1=>On(S1MOD1=1)
#define URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB81=0)(Default) <1=>L level(RB81=1)
#define URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~65535) <0-65535>
#define URT1_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S1BRG Clock Output Control <0=>Off(S1CKOE=0)(Default) <1=>On(S1CKOE=1)
//          <i> Note: S1BRG clock output (S1CKO) port pin select P45 or P46 .
#define URT1_Timer_Mode_16Bit_Pure_Timer_S1BRG_Clock_Output_Control 0
//      <o>S1BRG Operation <0=>Off(S1TR=0)(Default) <1=>On(S1TR=1)
#define URT1_Timer_Mode_16Bit_Pure_Timer_S1BRG_Operation 0
//      </e>16Bit Pure Timer
//      </e>Timer Mode
//      </e>UART1 Enable
//      </e>Advanced Mode
//      </e>Serial Port 1 (UART1)
/**
*******************************************************************************
* @brief       UART1 Easy Wizard
* @details     Config UART1 (Mode) (Baud Rate) (PinMux) (SerialReception)
* @return      None
* @note        None
* @par         Example
* @code
                __DRV_URT1_Easy_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_Easy_Wizard_Init()\
    MWT(\
        __DRV_URT1_EasyDisableSerialReception(URT1_Easy_Select);\
        __DRV_URT1_Mode_Easy_Select(URT1_Easy_Select);\
        __DRV_URT1_BaudRate_Easy_Select(URT1_Easy_Select);\
        __DRV_URT1_PinMux_Easy_Select(URT1_Easy_Select);\
        __DRV_URT1_EasyEnableSerialReception(URT1_Easy_Select);\
    ;)


/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0>Initialize Serial Port 2 (UART2)
//      <i> Check this term, then DRV_UART2_Wizard_Init() will initialize UART2.
//      <i> Date: 2024/03/07     Version: 1.01
#define MG82F6D64_UART2_WIZARD      0
//-----------------------------------------------------------------------------
//      <o>UART2
//          <0=>Easy Mode(Default)
//          <1=>Advanced Mode
//          <i> UART2 option select .
#define URT2_Option 0
//      <e>Easy Mode
#define URT2_Easy_Mode 0
//      <e>UART2 Enable
#define URT2_Easy 0
//      <o>Easy Select
//          <0=>Select0(Default)
//          <1=>Select1
//          <2=>Select2
//          <3=>Select3
//          <4=>Select4
//          <5=>Select5
//          <6=>Select6
//          <7=>Select7
//          <8=>Select8
//          <9=>Select9
//          <10=>Select10
//          <11=>Select11
//          <12=>Select12
//          <13=>Select13
//          <14=>Select14
//          <15=>Select15
//          <16=>Select16
//          <17=>Select17
//          <18=>Select18
//          <19=>Select19
//          <20=>Select20
//          <21=>Select21
//          <22=>Select22
//          <23=>Select23
//          <24=>Select24
//          <25=>Select25
//          <26=>Select26
//          <27=>Select27
//          <28=>Select28
//          <29=>Select29
//          <30=>Select30
//          <31=>Select31
//          <32=>Select32
//          <33=>Select33
//          <34=>Select34
//          <35=>Select35
//          <36=>Select36
//          <37=>Select37
//          <38=>Select38
//          <39=>Select39
//          <40=>Select40
//          <41=>Select41
//          <42=>Select42
//          <43=>Select43
//          <44=>Select44
//          <45=>Select45
//          <46=>Select46
//          <47=>Select47
//          <48=>Select48
//          <49=>Select49
//          <50=>Select50
//          <51=>Select51
//          <52=>Select52
//          <53=>Select53
//          <54=>Select54
//          <55=>Select55
//          <56=>Select56
//          <57=>Select57
//          <58=>Select58
//          <59=>Select59
//          <60=>Select60
//          <61=>Select61
//          <62=>Select62
//          <63=>Select63
//          <64=>Select64
//          <65=>Select65
//          <66=>Select66
//          <67=>Select67
//          <68=>Select68
//          <69=>Select69
//          <70=>Select70
//          <71=>Select71
//          <72=>Select72
//          <73=>Select73

#define URT2_Easy_Select 0
//          <i> Note:Please confirm clock source before you select parameter .
//          <i> Select0:    9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select1:    9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select2:    19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select3:    19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select4:    57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select5:    57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select6:    115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select7:    115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select8:    57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select9:    57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select10:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select11:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select12:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select13:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select14:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select15:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select16:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select17:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select18:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select19:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select20:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select21:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select22:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select23:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select24:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select25:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select26:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select27:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select28:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select29:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select30:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select31:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select32:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select33:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select34:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select35:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select36:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select37:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select38:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select39:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select40:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select41:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select42:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select43:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select44:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select45:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select46:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select47:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select48:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select49:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select50:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select51:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select52:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select53:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select54:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select55:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select56:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select57:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select58:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select59:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select60:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select61:   9600    8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select62:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select63:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select64:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select65:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select66:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select67:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select68:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select69:   115200  8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select70:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select71:   57600   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select72:   19200   8Bit    S2BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select73:   19200   8BIt    S2BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P32 Tx=P33   Tx Rx Both      SYSCLK=48Mhz

//      </e>UART2 Enable
//      </e>Easy Mode
//      <e>Advanced Mode
#define URT2_Advance_Mode 0
//      <e>UART2 Enable
//          <i> Mode0 Shift .
//          <i> Mode1 8bit .
//          <i> Mode2 9bit .
//          <i> Mode3 9bit .
//          <i> Mode4 Spi Master .
//          <i> Note: gpio wizard select P32 RXD2 (MOSI) P33 TXD2 (SPICLK) .
//          <i> Note: gpio wizard select P67 RXD2 (MOSI) P57 TXD2 (SPICLK) .
#define URT2_Advance 0
//      <o>Mode
//          <0=>Uart Mode(S2TME=0)(Default)
//          <1=>Timer Mode(S2TME=1)
//          <i> Uart/timer mode select .
#define URT2_Uart_Timer_Mode 0
//      <e>Uart Mode
#define URT2_Uart_Mode 0
//      <o>Mode
//          <0x00=>Mode 0 Shift(SM32=0,SM02=0,SM12=0)(Default)
//          <0x01=>Mode 1 8Bit(SM32=0,SM02=0,SM12=1)
//          <0x02=>Mode 2 9Bit(SM32=0,SM02=1,SM12=0)
//          <0x03=>Mode 3 9Bit(SM32=0,SM02=1,SM12=1)
//          <0x04=>Mode 4 Spi Master(SM32=1,SM02=0,SM12=0)
//          <i> Mode0~mode4 select .
#define URT2_Mode  0x00
//===========================================================
//      <e>Mode 0 Shift Enable
//===========================================================
#define URT2_Mode0_Shift 0
//      <e>System Clock
//          <i> Mode 0 shift clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S2M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S2M0X3=1 .
#define URT2_Mode0_Shift_SYSCLK_Clock_Source 0
//      <e>System Clock for S2
#define URT2_Mode0_Shift_SYSCLK_Clock_Source_for_S2 0
//      <o0.3>Data Order <0=>MSB(S2DOR=0) <1=>LSB(S2DOR=1)(Default)
//          <i> Data order select MSB (S2DOR=0) or LSB (S2DOR=1) .
#define URT2_Mode0_Shift_SYSCLK_Data_Order 0x08
//      <o0.6>Source <0=>SYSCLK/12(S2M0X3=0)(Default) <1=>SYSCLK/4(S2M0X3=1)
//          <i> SYSCLK/12 (S2M0X3=0) .
//          <i> SYSCLK/4 (S2M0X3=1) .
#define URT2_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK 0

//      <o>Shift In/Out <0=>Out(REN2=0)(Default) <1=>In(REN2=1)
//          <i> Reception is initiated by the condition REN2=1 and RI2=0 .
//          <i> Transmission is initiated by any instruction that uses S2BUF as a destination register .
//          <i> After REN2 on/off , clear RI2 .
#define URT2_Mode0_Shift_SYSCLK_Input_Output 0
//      </e>System clock for S2
//      <e>Baud Rate Generator for Others
//          <i> S2TOF S2BRG overflow .
//          <i> Baud rate = S2TOF .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 .
//          <i> S2CKI = Fsysclk/1 ; S2TX12=1 .
#define URT2_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S2TX12=0)(Default) <1=>SYSCLK/1(S2TX12=1)
//          <i> SYSCLK/12 (S2TX12=0) .
//          <i> SYSCLK/1 (S2TX12=1) .
#define URT2_Mode0_Shift_SYSCLK_S2BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT2_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S2BRG Clock Output Control <0=>Off(S2CKOE=0)(Default) <1=>On(S2CKOE=1)
//          <i> Note: S2BRG clock output (S2CKO) port pin select P64 .
#define URT2_Mode0_Shift_SYSCLK_Clock_Output_Control 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Mode0_Shift_SYSCLK_S2BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 0 Shift Enable
//===========================================================
//      <e>Mode 1 8Bit Enable
//===========================================================
#define URT2_Mode1_8Bit 0
//      <e>S2BRG
//          <i> Mode 1 8Bit clock source from S2BRG enable .
//          <i> Baud Rate = ((2^S2MOD1)/16) x S2TOF / 2 .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 .
//          <i> S2CKI = Fsysclk/1 ; S2TX12=1 .
#define URT2_Mode1_8Bit_S2BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S2DOR=0) <1=>LSB(S2DOR=1)(Default)
//          <i> Data order select MSB (S2DOR=0) or LSB (S2DOR=1) .
#define URT2_Mode1_8Bit_Data_Order_for_S2 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S2MOD1=0)(Default) <1=>Double Baud Rate(S2MOD1=1)
//          <i> Default baud rate (S2MOD1=0) .
//          <i> Double  baud rate (S2MOD1=1) .
#define URT2_Mode1_8Bit_Baud_Rate_for_S2 0
//      <o0.6>Source <0=>SYSCLK/12(S2TX12=0)(Default) <1=>SYSCLK/1(S2TX12=1)
//          <i> SYSCLK/12 (S2TX12=0) .
//          <i> SYSCLK/1  (S2TX12=1) .
#define URT2_Mode1_8Bit_Clock_Source_for_S2 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT2_Mode1_8Bit_Baud_Rate_Reload_Count_for_S2 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Mode1_8Bit_S2BRG_S2BRG_Operation_for_S2 0
//      <o>Reception <0=>Off(REN2=0)(Default) <1=>On(REN2=1)
//          <i> Reception is initiated by the condition REN2=1 .
#define URT2_Mode1_8Bit_S2BRG_Reception 0
//      </e>S2BRG
//      </e>Mode 1 8Bit Enable
//===========================================================
//      <e> Mode 2 9Bit Enable
//===========================================================
#define URT2_Mode2_9Bit 0
//      <e>System Clock
//          <i> Mode 2 9bit clock source from system clock enable .
//          <i> Baud rate = ((2^S2MOD1)/64) x Fsysclk ;S2M0X3=0 .
//          <i> Baud rate = ((2^S2MOD1)/192) x Fsysclk ;S2M0X3=1 .
//          <i> BaudRate        EnhanceBaudRate             SYSCLK/n
//          <i> 172800          Default Baud Rate           SYSCLK/64       SYSCLK=11.0592MHZ
//          <i> 345600          Double Baud Rate            SYSCLK/32       SYSCLK=11.0592MHZ
//          <i> 57600           Default Baud Rate           SYSCLK/192      SYSCLK=11.0592MHZ
//          <i> 115200          Double Baud Rate            SYSCLK/96       SYSCLK=11.0592MHZ
//          <i> 187500          Default Baud Rate           SYSCLK/64       SYSCLK=12MHZ
//          <i> 375000          Double Baud Rate            SYSCLK/32       SYSCLK=12MHZ
//          <i> 62500           Default Baud Rate           SYSCLK/192      SYSCLK=12MHZ
//          <i> 125000          Double Baud Rate            SYSCLK/96       SYSCLK=12MHZ
#define URT2_Mode2_9Bit_SYSCLK_Clock_Source 0
//      <e>System Clock for S2
#define URT2_Mode2_9Bit_SYSCLK_Clock_Source_for_S2 0
//      <o0.3>Data Order <0=>MSB(S2DOR=0) <1=>LSB(S2DOR=1)(Default)
//          <i> Data order select MSB (S2DOR=0) or LSB (S2DOR=1).
#define URT2_Mode2_9Bit_SYSCLK_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(S2MOD1=0)(Default)
//          <1=>Double Baud Rate(S2MOD1=1)
//          <i> Default baud rate(S2MOD1=0) .
//          <i> Double Baud Rate(S2MOD1=1) .
#define URT2_Mode2_9Bit_SYSCLK_Baud_Rate 0
//          <o0.6>Source <0=>SYSCLK/1(S2M0X3=0)(Default) <1=>SYSCLK/3(S2M0X3=1)
//          <i> SYSCLK/1 (S2M0X3=0,S2MOD1=0 SYSCLK/64).
//          <i> SYSCLK/1 (S2M0X3=0,S2MOD1=1 SYSCLK/32).
//          <i> SYSCLK/3 (S2M0X3=1,S2MOD1=0,SYSCLK/192).
//          <i> SYSCLK/3 (S2M0X3=1,S2MOD1=1,SYSCLK/96).
#define URT2_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Reception <0=>Off(REN2=0)(Default) <1=>On(REN2=1)
//          <i> Reception is initiated by the condition REN2=1 .
#define URT2_Mode2_9Bit_SYSCLK_Reception 0
//      </e>System Clock for S2
//      <e>Baud Rate Generator for Others
//          <i> S2TOF S2BRG overflow .
//          <i> Baud rate = S2TOF .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 .
//          <i> S2CKI = Fsysclk/1 ; S2TX12=1 .
#define URT2_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S2TX12=0)(Default) <1=>SYSCLK/1(S2TX12=1)
//          <i> SYSCLK/12 (S2TX12=0) .
//          <i> SYSCLK/1 (S2TX12=1) .
#define URT2_Mode2_9Bit_SYSCLK_S2BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT2_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S2BRG Clock Output Control <0=>Off(S2CKOE=0)(Default) <1=>On(S2CKOE=1)
//          <i> Note: S2BRG clock output (S2CKO) port pin select P64 .
#define URT2_Mode2_9Bit_SYSCLK_Clock_Output_Control 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Mode2_9Bit_SYSCLK_S2BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 2 9Bit Enable
//===========================================================
//      <e>Mode 3 9Bit Enable
//===========================================================
#define URT2_Mode3_9Bit 0
//      <e>S2BRG
//          <i> Mode 3 9Bit clock source from S2BRG enable .
//          <i> Baud Rate = ((2^S2MOD1)/16) x S2TOF / 2 .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 .
//          <i> S2CKI = Fsysclk/1 ; S2TX12=1 .
#define URT2_Mode3_9Bit_S2BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S2DOR=0) <1=>LSB(S2DOR=1)(Default)
//          <i> Data order select MSB (S2DOR=0) or LSB (S2DOR=1) .
#define URT2_Mode3_9Bit_Data_Order_for_S2 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S2MOD1=0)(Default) <1=>Double Baud Rate(S2MOD1=1)
//          <i> Default baud rate (S2MOD1=0) .
//          <i> Double  baud rate (S2MOD1=1) .
#define URT2_Mode3_9Bit_Baud_Rate_for_S2 0
//      <o0.6>Source <0=>SYSCLK/12(S2TX12=0)(Default) <1=>SYSCLK/1(S2TX12=1)
//          <i> SYSCLK/12 (S2TX12=0) .
//          <i> SYSCLK/1  (S2TX12=1) .
#define URT2_Mode3_9Bit_Clock_Source_for_S2 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT2_Mode3_9Bit_Baud_Rate_Reload_Count_for_S2 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Mode3_9Bit_S2BRG_S2BRG_Operation_for_S2 0
//      <o>Reception <0=>Off(REN2=0)(Default) <1=>On(REN2=1)
//          <i> Reception is initiated by the condition REN2=1 .
#define URT2_Mode3_9Bit_S2BRG_Reception 0
//      </e>S2BRG
//      </e>Mode 3 9Bit Enable
//===========================================================
//      <e> Mode 4 SPI Master Enable
//===========================================================
//          <i> No support CPOL now.
//          <i> Note: gpio wizard select P32 (RXD2) MOSI P33 (TXD2) SPICLK .
//          <i> Note: gpio wizard select P67 (RXD2) MOSI P57 (TXD2) SPICLK .
//          <i> Note: gpio wizard select P70 or P66 S2MI .
#define URT2_Mode4_Spi_Master 0
//      <e>System Clock
//          <i> Mode 4 spi master clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S2M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S2M0X3=1 .
#define URT2_Mode4_Spi_Master_SYSCLK_Clock_Source 0
//      <e>System Clock for S2
#define URT2_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S2 0

//      <o0.3>Data Order <0=>MSB(S2DOR=0) <1=>LSB(S2DOR=1)(Default)
//          <i> Data order select MSB (S2DOR=0) or LSB (S2DOR=1).
#define URT2_Mode4_Spi_Master_Data_Order 0x08
//          <o0.6>Source <0=>SYSCLK/12(S2M0X3=0)(Default) <1=>SYSCLK/4(S2M0X3=1)
//          <i> SYSCLK/12 (S2M0X3=0).
//          <i> SYSCLK/4 (S2M0X3=1).
#define URT2_Mode4_Spi_Master_Clock_Source 0
//      </e>System Clock for S2
//      <e>Baud Rate Generator for Others
//          <i> S2TOF S2BRG overflow .
//          <i> Baud rate = S2TOF .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 .
//          <i> S2CKI = Fsysclk/1 ; S2TX12=1 .
#define URT2_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=> SYSCLK/12(S2TX12=0)(Default) <1=> SYSCLK/1(S2TX12=1)
//          <i> SYSCLK/12 (S2TX12=0) .
//          <i> SYSCLK/1 (S2TX12=1) .
#define URT2_Mode4_Spi_Master_SYSCLK_S2BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT2_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S2BRG Clock Output Control <0=>Off(S2CKOE=0)(Default) <1=>On(S2CKOE=1)
//          <i> Note: S2BRG clock output (S2CKO) port pin select P64 .
#define URT2_Mode4_Spi_Master_Clock_Output_Control 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Mode4_Spi_Master_S2BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 4 SPI Master Enable
//      </e>Uart Mode
//      <e>Timer Mode
#define URT2_Timer_Mode 0
//      <o>S2BRG
//          <1=>8Bit Pure Timer(S2DOR=1)(Default)
//          <0=>16Bit Pure Timer(S2DOR=0)
//          <i> Baud rate generator function .
#define URT2_Timer_Mode_Pure_Timer 1
//      <e>8Bit Pure Timer
//          <i> 8bit pure timer(auto reload) .
//          <i> S2TOF S2BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S2TOF .
//          <i> S2TOF = S2CKI/(256-S2BRT) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 SM22=0.
//          <i> S2CKI = T1OF       ; S2TX12=0 SM22=1.
//          <i> S2CKI = Fsysclk/1  ; S2TX12=1 SM22=0.
//          <i> S2CKI = T0OF       ; S2TX12=1 SM22=1.
#define URT2_Timer_Mode_8Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S2TX12=0 SM22=0)(Default)
//          <1=>T1OF(S2TX12=0 SM22=1)
//          <2=>SYSCLK/1(S2TX12=1 SM22=0)
//          <3=>T0OF(S2TX12=1 SM22=1)
//          <i> SYSCLK/12(S2TX12=0 SM22=0) .
//          <i> T1OF(S2TX12=0 SM22=1) .
//          <i> SYSCLK/1(S2TX12=1 SM22=0) .
//          <i> T0OF(S2TX12=1 SM22=1) .
#define URT2_Timer_Mode_8Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S2 Interrupt <0=>Off(TB82=0)(Default) <1=>On(TB82=1)
#define URT2_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S2_Interrupt 0
//      <o>External Pin Trigger S2 Interrupt <0=>Off(REN2=0)(Default) <1=>On(REN2=1)
#define URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S2_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S2MOD1=0)(Default) <1=>On(S2MOD1=1)
#define URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB82=0)(Default) <1=>L level(RB82=1)
#define URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT2_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S2BRG Clock Output Control <0=>Off(S2CKOE=0)(Default) <1=>On(S2CKOE=1)
//          <i> Note: S2BRG clock output (S2CKO) port pin select P64 .
#define URT2_Timer_Mode_8Bit_Pure_Timer_S2BRG_Clock_Output_Control 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Timer_Mode_8Bit_Pure_Timer_S2BRG_Operation 0
//      </e>8Bit Pure Timer
//      <e>16Bit Pure Timer
//          <i> 16Bit pure timer(auto reload 0) .
//          <i> S2TOF S2BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S2TOF .
//          <i> S2TOF = S2CKI/(65536-(S2BRT,S2BRC)) .
//          <i> S2CKI = Fsysclk/12 ; S2TX12=0 SM22=0.
//          <i> S2CKI = T1OF       ; S2TX12=0 SM22=1.
//          <i> S2CKI = Fsysclk/1  ; S2TX12=1 SM22=0.
//          <i> S2CKI = T0OF       ; S2TX12=1 SM22=1.
#define URT2_Timer_Mode_16Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S2TX12=0 SM22=0)(Default)
//          <1=>T1OF(S2TX12=0 SM22=1)
//          <2=>SYSCLK/1(S2TX12=1 SM22=0)
//          <3=>T0OF(S2TX12=1 SM22=1)
//          <i> SYSCLK/12(S2TX12=0 SM22=0) .
//          <i> T1OF(S2TX12=0 SM22=1) .
//          <i> SYSCLK/1(S2TX12=1 SM22=0) .
//          <i> T0OF(S2TX12=1 SM22=1) .
#define URT2_Timer_Mode_16Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S2 Interrupt <0=>Off(TB82=0)(Default) <1=>On(TB82=1)
#define URT2_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S2_Interrupt 0
//      <o>External Pin Trigger S2 Interrupt <0=>Off(REN2=0)(Default) <1=>On(REN2=1)
#define URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S2_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S2MOD1=0)(Default) <1=>On(S2MOD1=1)
#define URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB82=0)(Default) <1=>L level(RB82=1)
#define URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~65535) <0-65535>
#define URT2_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S2BRG Clock Output Control <0=>Off(S2CKOE=0)(Default) <1=>On(S2CKOE=1)
//          <i> Note: S2BRG clock output (S2CKO) port pin select P64 .
#define URT2_Timer_Mode_16Bit_Pure_Timer_S2BRG_Clock_Output_Control 0
//      <o>S2BRG Operation <0=>Off(S2TR=0)(Default) <1=>On(S2TR=1)
#define URT2_Timer_Mode_16Bit_Pure_Timer_S2BRG_Operation 0
//      </e>16Bit Pure Timer
//      </e>Timer Mode
//      </e>UART2 Enable
//      </e>Advanced Mode
//      </e>Serial Port 2 (UART2)
//Macro for wizard constant option
#define UART2_SELECT0 UART2_8BIT_CONFIG0
#define UART2_SELECT1 UART2_8BIT_CONFIG1
#define UART2_SELECT2 UART2_8BIT_CONFIG2
#define UART2_SELECT3 UART2_8BIT_CONFIG3
#define UART2_SELECT4 UART2_8BIT_CONFIG4
#define UART2_SELECT5 UART2_8BIT_CONFIG5
#define UART2_SELECT6 UART2_8BIT_CONFIG6
#define UART2_SELECT7 UART2_8BIT_CONFIG7
#define UART2_SELECT8 UART2_8BIT_CONFIG8
#define UART2_SELECT9 UART2_8BIT_CONFIG9
#define UART2_SELECT10 UART2_8BIT_CONFIG10
#define UART2_SELECT11 UART2_8BIT_CONFIG11
#define UART2_SELECT12 UART2_8BIT_CONFIG12
#define UART2_SELECT13 UART2_8BIT_CONFIG13
#define UART2_SELECT14 UART2_8BIT_CONFIG14
#define UART2_SELECT15 UART2_8BIT_CONFIG15
#define UART2_SELECT16 UART2_8BIT_CONFIG16
#define UART2_SELECT17 UART2_8BIT_CONFIG17
#define UART2_SELECT18 UART2_8BIT_CONFIG18
#define UART2_SELECT19 UART2_8BIT_CONFIG19
#define UART2_SELECT20 UART2_8BIT_CONFIG20
#define UART2_SELECT21 UART2_8BIT_CONFIG21
#define UART2_SELECT22 UART2_8BIT_CONFIG22
#define UART2_SELECT23 UART2_8BIT_CONFIG23
/**
*******************************************************************************
* @brief       UART2 Easy Wizard
* @details     Config UART2 (Mode) (Baud Rate) (PinMux) (SerialReception)
* @return      None
* @note        None
* @par         Example
* @code
                __DRV_URT2_Easy_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_Easy_Wizard_Init()\
    MWT(\
        __DRV_URT2_EasyDisableSerialReception(URT2_Easy_Select);\
        __DRV_URT2_Mode_Easy_Select(URT2_Easy_Select);\
        __DRV_URT2_BaudRate_Easy_Select(URT2_Easy_Select);\
        __DRV_URT2_PinMux_Easy_Select(URT2_Easy_Select);\
        __DRV_URT2_EasyEnableSerialReception(URT2_Easy_Select);\
    ;)


/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0>Initialize Serial Port 3 (UART3)
//      <i> Check this term, then DRV_UART3_Wizard_Init() will initialize UART3.
//      <i> Date: 2024/03/07     Version: 1.01
#define MG82F6D64_UART3_WIZARD      0
//-----------------------------------------------------------------------------
//      <o>UART3
//          <0=>Easy Mode(Default)
//          <1=>Advanced Mode
//          <i> UART3 option select .
#define URT3_Option 0
//      <e>Easy Mode
#define URT3_Easy_Mode 0
//      <e>UART3 Enable
#define URT3_Easy 0
//      <o>Easy Select
//          <0=>Select0(Default)
//          <1=>Select1
//          <2=>Select2
//          <3=>Select3
//          <4=>Select4
//          <5=>Select5
//          <6=>Select6
//          <7=>Select7
//          <8=>Select8
//          <9=>Select9
//          <10=>Select10
//          <11=>Select11
//          <12=>Select12
//          <13=>Select13
//          <14=>Select14
//          <15=>Select15
//          <16=>Select16
//          <17=>Select17
//          <18=>Select18
//          <19=>Select19
//          <20=>Select20
//          <21=>Select21
//          <22=>Select22
//          <23=>Select23
//          <24=>Select24
//          <25=>Select25
//          <26=>Select26
//          <27=>Select27
//          <28=>Select28
//          <29=>Select29
//          <30=>Select30
//          <31=>Select31
//          <32=>Select32
//          <33=>Select33
//          <34=>Select34
//          <35=>Select35
//          <36=>Select36
//          <37=>Select37
//          <38=>Select38
//          <39=>Select39
//          <40=>Select40
//          <41=>Select41
//          <42=>Select42
//          <43=>Select43
//          <44=>Select44
//          <45=>Select45
//          <46=>Select46
//          <47=>Select47
//          <48=>Select48
//          <49=>Select49
//          <50=>Select50
//          <51=>Select51
//          <52=>Select52
//          <53=>Select53
//          <54=>Select54
//          <55=>Select55
//          <56=>Select56
//          <57=>Select57
//          <58=>Select58
//          <59=>Select59
//          <60=>Select60
//          <61=>Select61
//          <62=>Select62
//          <63=>Select63
//          <64=>Select64
//          <65=>Select65
//          <66=>Select66
//          <67=>Select67
//          <68=>Select68
//          <69=>Select69
//          <70=>Select70
//          <71=>Select71
//          <72=>Select72
//          <73=>Select73

#define URT3_Easy_Select 0
//          <i> Note:Please confirm clock source before you select parameter .
//          <i> Select0:    9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select1:    9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select2:    19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select3:    19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select4:    57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select5:    57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=12Mhz
//          <i> Select6:    115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select7:    115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select8:    57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select9:    57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select10:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select11:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select12:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select13:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=11.0592Mhz
//          <i> Select14:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select15:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select16:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select17:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select18:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select19:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select20:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select21:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=24Mhz
//          <i> Select22:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select23:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select24:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select25:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select26:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select27:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select28:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select29:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=22.1184Mhz
//          <i> Select30:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select31:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select32:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select33:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select34:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select35:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select36:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select37:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=29.4912Mhz
//          <i> Select38:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select39:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select40:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select41:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select42:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select43:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select44:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select45:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=33.1776Mhz
//          <i> Select46:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select47:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select48:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select49:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select50:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select51:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select52:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select53:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=32Mhz
//          <i> Select54:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select55:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select56:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select57:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select58:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select59:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select60:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select61:   9600    8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=36Mhz
//          <i> Select62:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select63:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select64:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select65:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select66:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select67:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=44.2368Mhz
//          <i> Select68:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select69:   115200  8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select70:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select71:   57600   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select72:   19200   8Bit    S3BRG   SYSCLK/1    Double Baud Rate    LSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz
//          <i> Select73:   19200   8BIt    S3BRG   SYSCLK/1    Double Baud Rate    MSB Pin Select  Rx=P36 Tx=P37   Tx Rx Both      SYSCLK=48Mhz

//      </e>UART3 Enable
//      </e>Easy Mode
//      <e>Advanced Mode
#define URT3_Advance_Mode 0
//      <e>UART3 Enable
//          <i> Mode0 Shift .
//          <i> Mode1 8bit .
//          <i> Mode2 9bit .
//          <i> Mode3 9bit .
//          <i> Mode4 Spi Master .
//          <i> Note: gpio wizard select P36 RXD3 (MOSI) P37 TXD3 (SPICLK) .
//          <i> Note: gpio wizard select P65 RXD3 (MOSI) P66 TXD3 (SPICLK) .
#define URT3_Advance 0
//      <o>Mode
//          <0=>Uart Mode(S3TME=0)(Default)
//          <1=>Timer Mode(S3TME=1)
//          <i> Uart/timer mode select .
#define URT3_Uart_Timer_Mode 0
//      <e>Uart Mode
#define URT3_Uart_Mode 0
//      <o>Mode
//          <0x00=>Mode 0 Shift(SM33=0,SM03=0,SM13=0)(Default)
//          <0x01=>Mode 1 8Bit(SM33=0,SM03=0,SM13=1)
//          <0x02=>Mode 2 9Bit(SM33=0,SM03=1,SM13=0)
//          <0x03=>Mode 3 9Bit(SM33=0,SM03=1,SM13=1)
//          <0x04=>Mode 4 Spi Master(SM33=1,SM03=0,SM13=0)
//          <i> Mode0~mode4 select .
#define URT3_Mode  0x00
//===========================================================
//      <e>Mode 0 Shift Enable
//===========================================================
#define URT3_Mode0_Shift 0
//      <e>System Clock
//          <i> Mode 0 shift clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S3M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S3M0X3=1 .
#define URT3_Mode0_Shift_SYSCLK_Clock_Source 0
//      <e>System Clock for S3
#define URT3_Mode0_Shift_SYSCLK_Clock_Source_for_S3 0
//      <o0.3>Data Order <0=>MSB(S3DOR=0) <1=>LSB(S3DOR=1)(Default)
//          <i> Data order select MSB (S3DOR=0) or LSB (S3DOR=1) .
#define URT3_Mode0_Shift_SYSCLK_Data_Order 0x08
//      <o0.6>Source <0=>SYSCLK/12(S3M0X3=0)(Default) <1=>SYSCLK/4(S3M0X3=1)
//          <i> SYSCLK/12 (S3M0X3=0) .
//          <i> SYSCLK/4 (S3M0X3=1) .
#define URT3_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Shift In/Out <0=>Out(REN2=0)(Default) <1=>In(REN2=1)
//          <i> Reception is initiated by the condition REN2=1 and RI2=0 .
//          <i> Transmission is initiated by any instruction that uses S3BUF as a destination register .
//          <i> After REN2 on/off , clear RI2 .
#define URT3_Mode0_Shift_SYSCLK_Input_Output 0
//      </e>System clock for S3
//      <e>Baud Rate Generator for Others
//          <i> S3TOF S3BRG overflow .
//          <i> Baud rate = S3TOF .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 .
//          <i> S3CKI = Fsysclk/1 ; S3TX12=1 .
#define URT3_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S3TX12=0)(Default) <1=>SYSCLK/1(S3TX12=1)
//          <i> SYSCLK/12 (S3TX12=0) .
//          <i> SYSCLK/1 (S3TX12=1) .
#define URT3_Mode0_Shift_SYSCLK_S3BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT3_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S3BRG Clock Output Control <0=>Off(S3CKOE=0)(Default) <1=>On(S3CKOE=1)
//          <i> Note: S3BRG clock output (S3CKO) port pin select P72 .
#define URT3_Mode0_Shift_SYSCLK_Clock_Output_Control 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Mode0_Shift_SYSCLK_S3BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 0 Shift Enable
//===========================================================
//      <e>Mode 1 8Bit Enable
//===========================================================
#define URT3_Mode1_8Bit 0
//      <e>S3BRG
//          <i> Mode 1 8Bit clock source from S3BRG enable .
//          <i> Baud Rate = ((2^S3MOD1)/16) x S3TOF / 2 .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 .
//          <i> S3CKI = Fsysclk/1 ; S3TX12=1 .
#define URT3_Mode1_8Bit_S3BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S3DOR=0) <1=>LSB(S3DOR=1)(Default)
//          <i> Data order select MSB (S3DOR=0) or LSB (S3DOR=1) .
#define URT3_Mode1_8Bit_Data_Order_for_S3 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S3MOD1=0)(Default) <1=>Double Baud Rate(S3MOD1=1)
//          <i> Default baud rate (S3MOD1=0) .
//          <i> Double  baud rate (S3MOD1=1) .
#define URT3_Mode1_8Bit_Baud_Rate_for_S3 0
//      <o0.6>Source <0=>SYSCLK/12(S3TX12=0)(Default) <1=>SYSCLK/1(S3TX12=1)
//          <i> SYSCLK/12 (S3TX12=0) .
//          <i> SYSCLK/1  (S3TX12=1) .
#define URT3_Mode1_8Bit_Clock_Source_for_S3 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT3_Mode1_8Bit_Baud_Rate_Reload_Count_for_S3 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Mode1_8Bit_S3BRG_S3BRG_Operation_for_S3 0
//      <o>Reception <0=>Off(REN3=0)(Default) <1=>On(REN3=1)
//          <i> Reception is initiated by the condition REN3=1 .
#define URT3_Mode1_8Bit_S3BRG_Reception 0
//      </e>S3BRG
//      </e>Mode 1 8Bit Enable
//===========================================================
//      <e> Mode 2 9Bit Enable
//===========================================================
#define URT3_Mode2_9Bit 0
//      <e>System Clock
//          <i> Mode 2 9bit clock source from system clock enable .
//          <i> Baud rate = ((2^S3MOD1)/64) x Fsysclk ;S3M0X3=0 .
//          <i> Baud rate = ((2^S3MOD1)/192) x Fsysclk ;S3M0X3=1 .
//          <i> BaudRate        EnhanceBaudRate             SYSCLK/n
//          <i> 172800          Default Baud Rate           SYSCLK/64       SYSCLK=11.0592MHZ
//          <i> 345600          Double Baud Rate            SYSCLK/32       SYSCLK=11.0592MHZ
//          <i> 57600           Default Baud Rate           SYSCLK/192      SYSCLK=11.0592MHZ
//          <i> 115200          Double Baud Rate            SYSCLK/96       SYSCLK=11.0592MHZ
//          <i> 187500          Default Baud Rate           SYSCLK/64       SYSCLK=12MHZ
//          <i> 375000          Double Baud Rate            SYSCLK/32       SYSCLK=12MHZ
//          <i> 62500           Default Baud Rate           SYSCLK/192      SYSCLK=12MHZ
//          <i> 125000          Double Baud Rate            SYSCLK/96       SYSCLK=12MHZ
#define URT3_Mode2_9Bit_SYSCLK_Clock_Source 0
//      <e>System Clock for S3
#define URT3_Mode2_9Bit_SYSCLK_Clock_Source_for_S3 0
//      <o0.3>Data Order <0=>MSB(S3DOR=0) <1=>LSB(S3DOR=1)(Default)
//          <i> Data order select MSB (S3DOR=0) or LSB (S3DOR=1).
#define URT3_Mode2_9Bit_SYSCLK_Data_Order 0x08
//      <o0.4..5>Enhance Baud Rate
//          <0=>Default Baud Rate(S3MOD1=0)(Default)
//          <1=>Double Baud Rate(S3MOD1=1)
//          <i> Default baud rate  (S3MOD1=0) .
//          <i> Double Baud Rate   (S3MOD1=1) .
#define URT3_Mode2_9Bit_SYSCLK_Baud_Rate 0
//          <o0.6>Source <0=>SYSCLK/1(S3M0X3=0)(Default) <1=>SYSCLK/3(S3M0X3=1)
//          <i> SYSCLK/1 (S3M0X3=0,S3MOD1=0 SYSCLK/64).
//          <i> SYSCLK/1 (S3M0X3=0,S3MOD1=1 SYSCLK/32).
//          <i> SYSCLK/3 (S3M0X3=1,S3MOD1=0,SYSCLK/192).
//          <i> SYSCLK/3 (S3M0X3=1,S3MOD1=1,SYSCLK/96).
#define URT3_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK 0
//      <o>Reception <0=>Off(REN3=0)(Default) <1=>On(REN3=1)
//          <i> Reception is initiated by the condition REN3=1 .
#define URT3_Mode2_9Bit_SYSCLK_Reception 0
//      </e>System Clock for S3
//      <e>Baud Rate Generator for Others
//          <i> S3TOF S3BRG overflow .
//          <i> Baud rate = S3TOF .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 .
//          <i> S3CKI = Fsysclk/1 ; S3TX12=1 .
#define URT3_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S3TX12=0)(Default) <1=>SYSCLK/1(S3TX12=1)
//          <i> SYSCLK/12 (S3TX12=0) .
//          <i> SYSCLK/1 (S3TX12=1) .
#define URT3_Mode2_9Bit_SYSCLK_S3BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT3_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S3BRG Clock Output Control <0=>Off(S3CKOE=0)(Default) <1=>On(S3CKOE=1)
//          <i> Note: S3BRG clock output (S3CKO) port pin select P72 .
#define URT3_Mode2_9Bit_SYSCLK_Clock_Output_Control 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Mode2_9Bit_SYSCLK_S3BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 2 9Bit Enable
//===========================================================
//      <e>Mode 3 9Bit Enable
//===========================================================
#define URT3_Mode3_9Bit 0
//      <e>S3BRG
//          <i> Mode 3 9Bit clock source from S3BRG enable .
//          <i> Baud Rate = ((2^S3MOD1)/16) x S3TOF / 2 .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 .
//          <i> S3CKI = Fsysclk/1 ; S3TX12=1 .
#define URT3_Mode3_9Bit_S3BRG_Clock_Source 0
//      <o0.3>Data Order <0=>MSB(S3DOR=0) <1=>LSB(S3DOR=1)(Default)
//          <i> Data order select MSB (S3DOR=0) or LSB (S3DOR=1) .
#define URT3_Mode3_9Bit_Data_Order_for_S3 0x08
//      <o0.4>Enhance Baud Rate	<0=>Default Baud Rate(S3MOD1=0)(Default) <1=>Double Baud Rate(S3MOD1=1)
//          <i> Default baud rate (S3MOD1=0) .
//          <i> Double  baud rate (S3MOD1=1) .
#define URT3_Mode3_9Bit_Baud_Rate_for_S3 0
//      <o0.6>Source <0=>SYSCLK/12(S3TX12=0)(Default) <1=>SYSCLK/1(S3TX12=1)
//          <i> SYSCLK/12 (S3TX12=0) .
//          <i> SYSCLK/1  (S3TX12=1) .
#define URT3_Mode3_9Bit_Clock_Source_for_S3 0
//      <o>Baud rate reload (0~255) <0-255>
#define URT3_Mode3_9Bit_Baud_Rate_Reload_Count_for_S3 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Mode3_9Bit_S3BRG_S3BRG_Operation_for_S3 0
//      <o>Reception <0=>Off(REN3=0)(Default) <1=>On(REN3=1)
//          <i> Reception is initiated by the condition REN3=1 .
#define URT3_Mode3_9Bit_S3BRG_Reception 0
//      </e>S3BRG
//      </e>Mode 3 9Bit Enable
//===========================================================
//      <e>Mode 4 SPI Master Enable
//===========================================================
//          <i> No support CPOL now.
//          <i> Note: gpio wizard select P36 (RXD3) MOSI P37 (TXD3) SPICLK .
//          <i> Note: gpio wizard select P65 (RXD3) MOSI P66 (TXD3) SPICLK .
//          <i> Note: gpio wizard select P71 or P65 S3MI .
#define URT3_Mode4_Spi_Master 0
//      <e>System Clock
//          <i> Mode 4 spi master clock source from system clock enable .
//          <i> Baud rate = Fsysclk/12 ; S3M0X3=0 .
//          <i> Baud rate = Fsysclk/4 ; S3M0X3=1 .
#define URT3_Mode4_Spi_Master_SYSCLK_Clock_Source 0
//      <e>System Clock for S3
#define URT3_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S3 0
//      <o0.3>Data Order <0=>MSB(S3DOR=0) <1=>LSB(S3DOR=1)(Default)
//          <i> Data order select MSB (S3DOR=0) or LSB (S3DOR=1).
#define URT3_Mode4_Spi_Master_Data_Order 0x08
//          <o0.6>Source <0=>SYSCLK/12(S3M0X3=0)(Default) <1=>SYSCLK/4(S3M0X3=1)
//          <i> SYSCLK/12 (S3M0X3=0).
//          <i> SYSCLK/4 (S3M0X3=1).
#define URT3_Mode4_Spi_Master_Clock_Source 0
//      </e>System Clock for S3
//      <e>Baud Rate Generator for Others
//          <i> S3TOF S3BRG overflow .
//          <i> Baud rate = S3TOF .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 .
//          <i> S3CKI = Fsysclk/1 ; S3TX12=1 .
#define URT3_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others 0
//      <o0.6>Source <0=>SYSCLK/12(S3TX12=0)(Default) <1=>SYSCLK/1(S3TX12=1)
//          <i> SYSCLK/12 (S3TX12=0) .
//          <i> SYSCLK/1 (S3TX12=1) .
#define URT3_Mode4_Spi_Master_SYSCLK_S3BRG_Clock_Source_SYSCLK 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT3_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count 0
//      <o>S3BRG Clock Output Control <0=>Off(S3CKOE=0)(Default) <1=>On(S3CKOE=1)
//          <i> Note: S3BRG clock output (S3CKO) port pin select P72 .
#define URT3_Mode4_Spi_Master_Clock_Output_Control 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Mode4_Spi_Master_S3BRG_Operation 0
//      </e>Baud Rate Generator For Others
//      </e>System Clock
//      </e>Mode 4 SPI Master Enable
//      </e>Uart Mode
//      <e>Timer Mode
#define URT3_Timer_Mode 0
//      <o>S3BRG
//          <1=>8Bit Pure Timer(S3DOR=1)(Default)
//          <0=>16Bit Pure Timer(S3DOR=0)
//          <i> Baud rate generator function .
#define URT3_Timer_Mode_Pure_Timer 1
//      <e>8Bit Pure Timer
//          <i> 8bit pure timer(auto reload) .
//          <i> S3TOF S3BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S3TOF .
//          <i> S3TOF = S3CKI/(256-S3BRT) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 SM23=0.
//          <i> S3CKI = T1OF       ; S3TX12=0 SM23=1.
//          <i> S3CKI = Fsysclk/1  ; S3TX12=1 SM23=0.
//          <i> S3CKI = T0OF       ; S3TX12=1 SM23=1.
#define URT3_Timer_Mode_8Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S3TX12=0 SM23=0)(Default)
//          <1=>T1OF(S3TX12=0 SM23=1)
//          <2=>SYSCLK/1(S3TX12=1 SM23=0)
//          <3=>T0OF(S3TX12=1 SM23=1)
//          <i> sysclk/12(S3TX12=0 SM23=0) .
//          <i> T1OF(S3TX12=0 SM23=1) .
//          <i> sysclk/1(S3TX12=1 SM23=0) .
//          <i> T0OF(S3TX12=1 SM23=1) .
#define URT3_Timer_Mode_8Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S3 Interrupt <0=>Off(TB83=0)(Default) <1=>On(TB83=1)
#define URT3_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S3_Interrupt 0
//      <o>External Pin Trigger S3 Interrupt <0=>Off(REN3=0)(Default) <1=>On(REN3=1)
#define URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S3_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S3MOD1=0)(Default) <1=>On(S3MOD1=1)
#define URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB83=0)(Default) <1=>L level(RB83=1)
#define URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~255) <0-255>
#define URT3_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S3BRG Clock Output Control <0=>Off(S3CKOE=0)(Default) <1=>On(S3CKOE=1)
//          <i> Note: S3BRG clock output (S3CKO) port pin select P72 .
#define URT3_Timer_Mode_8Bit_Pure_Timer_S3BRG_Clock_Output_Control 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Timer_Mode_8Bit_Pure_Timer_S3BRG_Operation 0
//      </e>8Bit Pure Timer
//      <e>16Bit Pure Timer
//          <i> 16Bit pure timer(auto reload 0) .
//          <i> S3TOF S3BRG overflow .
//          <i> T0OF timer0 overflow .
//          <i> T1OF timer1 overflow .
//          <i> Baud rate = S3TOF .
//          <i> S3TOF = S3CKI/(65536-(S3BRT,S3BRC)) .
//          <i> S3CKI = Fsysclk/12 ; S3TX12=0 SM23=0.
//          <i> S3CKI = T1OF       ; S3TX12=0 SM23=1.
//          <i> S3CKI = Fsysclk/1  ; S3TX12=1 SM23=0.
//          <i> S3CKI = T0OF       ; S3TX12=1 SM23=1.
#define URT3_Timer_Mode_16Bit_Pure_Timer 0
//      <o>Clock Source
//          <0=>SYSCLK/12(S3TX12=0 SM23=0)(Default)
//          <1=>T1OF(S3TX12=0 SM23=1)
//          <2=>SYSCLK/1(S3TX12=1 SM23=0)
//          <3=>T0OF(S3TX12=1 SM23=1)
//          <i> SYSCLK/12(S3TX12=0 SM23=0) .
//          <i> T1OF(S3TX12=0 SM23=1) .
//          <i> SYSCLK/1(S3TX12=1 SM23=0) .
//          <i> T0OF(S3TX12=1 SM23=1) .
#define URT3_Timer_Mode_16Bit_Pure_Timer_Clock_Source 0
//      <o>Baudrate Generator Overflow S3 Interrupt <0=>Off(TB83=0)(Default) <1=>On(TB83=1)
#define URT3_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S3_Interrupt 0
//      <o>External Pin Trigger S3 Interrupt <0=>Off(REN3=0)(Default) <1=>On(REN3=1)
#define URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S3_Interrupt 0
//      <o>External Pin Control Baudrate Generator <0=>Off(S3MOD1=0)(Default) <1=>On(S3MOD1=1)
#define URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count 0
//      <o>External Pin Trigger Level <0=>H level(RB83=0)(Default) <1=>L level(RB83=1)
#define URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level 0
//      <o>Baud Rate Reload (0~65535) <0-65535>
#define URT3_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count 0
//      <o>S3BRG Clock Output Control <0=>Off(S3CKOE=0)(Default) <1=>On(S3CKOE=1)
//          <i> Note: S3BRG clock output (S3CKO) port pin select P72 .
#define URT3_Timer_Mode_16Bit_Pure_Timer_S3BRG_Clock_Output_Control 0
//      <o>S3BRG Operation <0=>Off(S3TR=0)(Default) <1=>On(S3TR=1)
#define URT3_Timer_Mode_16Bit_Pure_Timer_S3BRG_Operation 0
//      </e>16Bit Pure Timer
//      </e>Timer Mode
//      </e>UART3 Enable
//      </e>Advanced Mode
//      </e>Serial Port 3 (UART3)

/**
*******************************************************************************
* @brief       UART3 Easy Wizard
* @details     Config UART3 (Mode) (Baud Rate) (PinMux) (SerialReception)
* @return      None
* @note        None
* @par         Example
* @code
                __DRV_URT3_Easy_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_Easy_Wizard_Init()\
    MWT(\
        __DRV_URT3_EasyDisableSerialReception(URT3_Easy_Select);\
        __DRV_URT3_Mode_Easy_Select(URT3_Easy_Select);\
        __DRV_URT3_BaudRate_Easy_Select(URT3_Easy_Select);\
        __DRV_URT3_PinMux_Easy_Select(URT3_Easy_Select);\
        __DRV_URT3_EasyEnableSerialReception(URT3_Easy_Select);\
    ;)


/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0>Initialize SPI
//      <i> Check this term, then DRV_SPI_Wizard_Init() will initialize SPI.
//      <i> Date: 2024/03/26     Version: 1.01
#define MG82F6D64_SPI_WIZARD      0
//-----------------------------------------------------------------------------
//      <o>SPI
//          <0=>Easy Mode(Default)
//          <1=> Advanced Mode
//          <i> SPI option select.
#define SPI_Option 0
//      <e>Easy Mode
#define SPI_Easy_Mode 1
//      <e>SPI Enable
#define SPI_Easy 0
//      <o>Easy Select
//          <0=>Select0(Default)
//          <1=>Select1
//          <2=>Select2
//          <3=>Select3
//          <4=>Select4
//          <5=>Select5
//          <6=>Select6
//          <7=>Select7
//          <8=>Select8
//          <9=>Select9
//          <10=>Select10
//          <11=>Select11
//          <12=>Select12
//          <13=>Select13
//          <14=>Select14
//          <15=>Select15
//          <16=>Select16
//          <17=>Select17
//          <18=>Select18
//          <19=>Select19
//          <20=>Select20
//          <21=>Select21
//          <22=>Select22
//          <23=>Select23
//          <24=>Select24
//          <25=>Select25
//          <26=>Select26
//          <27=>Select27
//          <28=>Select28
//          <29=>Select29
//          <30=>Select30
//          <31=>Select31
//          <32=>Select32
//          <33=>Select33
//          <34=>Select34
//          <35=>Select35
//          <36=>Select36
//          <37=>Select37
//          <38=>Select38
//          <39=>Select39
//          <40=>Select40
//          <41=>Select41
//          <42=>Select42
//          <43=>Select43
//          <44=>Select44
//          <45=>Select45
//          <46=>Select46
//          <47=>Select47
//          <48=>Select48
//          <49=>Select49
//          <50=>Select50
//          <51=>Select51
//          <52=>Select52
//          <53=>Select53
//          <54=>Select54
//          <55=>Select55

#define SPI_Easy_Select 0
//          <i> Note:Please confirm clock source before you select parameter.

//          <i> Select0 : Slave Select By nSS , Model Control : Typical , Data Order : LSB ,Clock Rate : Edge , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select1 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/4 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select2 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/8 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select3 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/16 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select4 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/32 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select5 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/64 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select6 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/2 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select7 : Slave Select By nSS , Model Control : Typical , Data Order : LSB ,Clock Rate : Edge , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select8 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/4 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select9 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/8 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select10 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/16 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select11 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/32 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select12 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/64 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select13 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/2 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select14 : Slave Select By nSS , Model Control : Typical , Data Order : LSB ,Clock Rate : Edge , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select15 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/4 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select16 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/8 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select17 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/16 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select18 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/32 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select19 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/64 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select20 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/2 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select21 : Slave Select By nSS , Model Control : Typical , Data Order : LSB ,Clock Rate : Edge , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select22 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/4 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select23 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/8 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select24 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/16 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select25 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/32 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select26 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/64 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select27 : Master Select By MSTR , Model Control : Typical , Data Order:LSB , Clock Rate : SYSCLK/2 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .

//          <i> Select28 : Slave Select By nSS , Model Control : Typical , Data Order : MSB ,Clock Rate : Edge , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select29 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/4 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select30 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/8 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select31 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/16 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select32 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/32 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select33 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/64 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select34 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/2 , Data Mode 0 : CPOL=0 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select35 : Slave Select By nSS , Model Control : Typical , Data Order : MSB ,Clock Rate : Edge , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select36 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/4 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select37 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/8 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select38 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/16 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select39 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/32 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select40 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/64 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select41 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/2 , Data Mode 1 : CPOL=0 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select42 : Slave Select By nSS , Model Control : Typical , Data Order : MSB ,Clock Rate : Edge , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select43 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/4 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select44 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/8 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select45 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/16 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select46 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/32 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select47 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/64 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select48 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/2 , Data Mode 2 : CPOL=1 CPHA=0 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select49 : Slave Select By nSS , Model Control : Typical , Data Order : MSB ,Clock Rate : Edge , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select50 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/4 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select51 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/8 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select52 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/16 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select53 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/32 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select54 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/64 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .
//          <i> Select55 : Master Select By MSTR , Model Control : Typical , Data Order:MSB , Clock Rate : SYSCLK/2 , Data Mode 3 : CPOL=1 CPHA=1 , Pin: nSS(P14) MOSI(SPID0)(P15) MISO(SPID1)(P16) SPICLK(P17) SPID2(P53) SPID3(P54) .

//      </e>SPI Enable
//      </e>Easy Mode
//      <e>Advanced Mode
#define SPI_Advance_Mode 0
//      <e>SPI Enable
#define SPI_Advance 0
//      <o>Connection
//          <0=>Typical SPI(SPI0M0=0,QPIEN=0)(Default)
//          <2=>Daisy Chain(SPI0M0=1,QPIEN=0)
//          <1=>QPI Mode(SPI0M0=0,QPIEN=1)
#define SPI_Connection 0
//      <e>Typical SPI
#define SPI_Connection_Typical_SPI 0
//      <o>Mode
//          <0=>Slave(Default)
//          <1=>Master
//          <i> Slave/master mode select
#define SPI_Mode_Typical_SPI 0
//===========================================================
//      <e>Slave Mode Enable
//===========================================================
//          <i> Note: gpio wizard select P14 nSS P15 MOSI (SPID0) P16 MISO (SPID1) P17 SPICLK P53 SPID2 P54 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P42 MOSI (SPID0) P41 MISO (SPID1) P40 SPICLK P36 SPID2 P37 SPID3 .
//          <i> Note: gpio wizard select P40 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P43 SPICLK P65 SPID2 P57 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P40 SPICLK P65 SPID2 P57 SPID3 .
#define SPI_Slave_Mode_Typical_SPI 0
//      <o>Slave Mode
//          <0x00=>SPI Disable(SPEN=0,SSIG=0,MSTR=0)(Default)
//          <0x01=>Slave Select by nSS(SPEN=1,SSIG=0,MSTR=0)
//          <0x02=>Slave Select by MSTR(SPEN=1,SSIG=1,MSTR=0)
#define SPI_Slave_Mode_Initial_Typical_SPI 0x00
//      <o>Data Mode
//          <0x00=>Mode0(CPOL=0,CPHA=0)
//          <0x01=>Mode1(CPOL=0,CPHA=1)(Default)
//          <0x02=>Mode2(CPOL=1,CPHA=0)
//          <0x03=>Mode3(CPOL=1,CPHA=1)
//          <i> Clock Phase Bit (CPHA) allows the user to set the edges for sampling and changing data.
//          <i> The Clock Polarity bit, CPOL, allows the user to set the clock polarity. The following figures show the different settings of Clock Phase Bit, CPHA.
#define SPI_Slave_Data_Mode_CPOL_CPHA_Typical_SPI 0x01
//      <o>Data Order <0=>MSB(DORD=0)(Default) <1=>LSB(DORD=1)
//          <i> Data order select MSB (DORD=0) or LSB (DORD=1).
#define SPI_Slave_Data_Order_Typical_SPI 0
//      <o>Transfer Completion Flag Auto-Cleared<0=>Software(SPFACE=0)(Default) <1=>Hardware(SPFACE=1)
//          <i>SPFACE=0 SPIF is only cleared by CPU software.
//          <i>SPFACE=1 SPIF is also cleared by CPU read/write SPDAT operation.
#define SPI_Slave_SPIF_Auto_Cleared_Typical_SPI 0
//      </e>Slave Mode Enable
//===========================================================
//      <e>Master Mode Enable
//===========================================================
//          <i> Note: gpio wizard select P14 nSS P15 MOSI (SPID0) P16 MISO (SPID1) P17 SPICLK P53 SPID2 P54 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P42 MOSI (SPID0) P41 MISO (SPID1) P40 SPICLK P36 SPID2 P37 SPID3 .
//          <i> Note: gpio wizard select P40 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P43 SPICLK P65 SPID2 P57 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P40 SPICLK P65 SPID2 P57 SPID3 .
#define SPI_Master_Mode_Typical_SPI 0
//      <o>Master Mode
//          <0x00=>SPI Disable(SPEN=0,SSIG=0,MSTR=0)(Default)
//          <0x03=>Master Dual Role Select by nSS(SPEN=1,SSIG=0,MSTR=1)
//          <0x04=>Master Select by MSTR(SPEN=1,SSIG=1,MSTR=1)
#define SPI_Master_Mode_Initial_Typical_SPI 0x00
//      <o>Clock Rate
//          <0x00=>SYSCLK/4(SPR2=0,SPR1=0,SPR0=0)(Default)
//          <0x01=>SYSCLK/8(SPR2=0,SPR1=0,SPR0=1)
//          <0x02=>SYSCLK/16(SPR2=0,SPR1=1,SPR0=0)
//          <0x03=>SYSCLK/32(SPR2=0,SPR1=1,SPR0=1)
//          <0x04=>SYSCLK/64(SPR2=1,SPR1=0,SPR0=0)
//          <0x05=>SYSCLK/2(SPR2=1,SPR1=0,SPR0=1)
//          <0x06=>S0TOF/6(SPR2=1,SPR1=1,SPR0=0)
//          <0x07=>T0OF/6(SPR2=1,SPR1=1,SPR0=1)
//          <i> Note:SYSCLK is the system clock.
//          <i> ClockRate		SYSCLK/n	SPR2	SPR1	SPR0
//          <i> 3Mhz   			SYSCLK/4 	 0   	 0   	 0	IHRCO 12MHZ
//          <i> 1.5Mhz 			SYSCLK/8 	 0   	 0   	 1	IHRCO 12MHZ
//          <i> 750Khz 			SYSCLK/16	 0   	 1   	 0	IHRCO 12MHZ
//          <i> 375Khz 			SYSCLK/32	 0   	 1   	 1	IHRCO 12MHZ
//          <i> 187.5hz			SYSCLK/64	 1   	 0   	 0	IHRCO 12MHZ
//          <i> 6Mhz   			SYSCLK/2 	 1   	 0   	 1	IHRCO 12MHZ
//          <i> 12Mhz  			SYSCLK/4 	 0   	 0   	 0	IHRCO 48MHZ
//          <i> 6Mhz   			SYSCLK/8 	 0   	 0   	 1	IHRCO 48MHZ
//          <i> 3Mhz   			SYSCLK/16	 0   	 1   	 0	IHRCO 48MHZ
//          <i> 1.5Mhz 			SYSCLK/32	 0   	 1   	 1	IHRCO 48MHZ
//          <i> 750Khz 			SYSCLK/64	 1   	 0   	 0	IHRCO 48MHZ
//          <i> 24Mhz  			SYSCLK/2 	 1   	 0   	 1	IHRCO 48MHZ(Vdd 5V)

//          <i> S0TOF S0BRG overflow .
//          <i> S0TOF = Fsysclk/((12^(1-S0TX12)) x (256-S0BRT)) .
//          <i> T0OF timer0 overflow .

#define SPI_Master_Clock_Rate_Config_Typical_SPI 0x00
//      <o>Data Mode
//          <0x00=>Mode0(CPOL=0,CPHA=0)
//          <0x01=>Mode1(CPOL=0,CPHA=1)(Default)
//          <0x02=>Mode2(CPOL=1,CPHA=0)
//          <0x03=>Mode3(CPOL=1,CPHA=1)
//          <i> Clock Phase Bit (CPHA) allows the user to set the edges for sampling and changing data.
//          <i> The Clock Polarity bit, CPOL, allows the user to set the clock polarity. The following figures show the different settings of Clock Phase Bit, CPHA.
#define SPI_Master_Data_Mode_CPOL_CPHA_Typical_SPI 0x01
//      <o>Data Order <0=>MSB(DORD=0)(Default) <1=>LSB(DORD=1)
//          <i> Data order select MSB (DORD=0) or LSB (DORD=1).
#define SPI_Master_Data_Order_Typical_SPI 0
//      <o>Transfer Completion Flag Auto-Cleared<0=>Software(SPFACE=0)(Default) <1=>Hardware(SPFACE=1)
//          <i>SPFACE=0 SPIF is only cleared by CPU software.
//          <i>SPFACE=1 SPIF is also cleared by CPU read/write SPDAT operation.
#define SPI_Master_SPIF_Auto_Cleared_Typical_SPI 0
//      </e>Master Mode Enable
//      </e>Typical SPI
//      <e>Daisy Chain
#define SPI_Connection_Daisy_Chain 0
//      <o>Mode
//          <0=>Slave(Default)
//          <i> Slave mode select
#define SPI_Mode_Daisy_Chain 0
//===========================================================
//      <e>Slave Mode Enable
//===========================================================
//          <i> Note: gpio wizard select P14 nSS P15 MOSI (SPID0) P16 MISO (SPID1) P17 SPICLK P53 SPID2 P54 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P42 MOSI (SPID0) P41 MISO (SPID1) P40 SPICLK P36 SPID2 P37 SPID3 .
//          <i> Note: gpio wizard select P40 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P43 SPICLK P65 SPID2 P57 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P40 SPICLK P65 SPID2 P57 SPID3 .
#define SPI_Slave_Mode_Daisy_Chain 0
//      <o>Slave Mode
//          <0x00=>SPI Disable(SPEN=0,SSIG=0,MSTR=0)(Default)
//          <0x01=>Slave Select by nSS(SPEN=1,SSIG=0,MSTR=0)
//          <0x02=>Slave Select by MSTR(SPEN=1,SSIG=1,MSTR=0)
#define SPI_Slave_Mode_Initial_Daisy_Chain 0x00
//      <o>Data Mode
//          <0x00=>Mode0(CPOL=0,CPHA=0)
//          <0x01=>Mode1(CPOL=0,CPHA=1)(Default)
//          <0x02=>Mode2(CPOL=1,CPHA=0)
//          <0x03=>Mode3(CPOL=1,CPHA=1)
//          <i> Clock Phase Bit (CPHA) allows the user to set the edges for sampling and changing data.
//          <i> The Clock Polarity bit, CPOL, allows the user to set the clock polarity. The following figures show the different settings of Clock Phase Bit, CPHA.
#define SPI_Slave_Data_Mode_CPOL_CPHA_Daisy_Chain 0x01
//      <o>Data Order <0=>MSB(DORD=0)(Default) <1=>LSB(DORD=1)
//          <i> Data order select MSB (DORD=0) or LSB (DORD=1).
#define SPI_Slave_Data_Order_Daisy_Chain 0
//      <o>Transfer Completion Flag Auto-Cleared<0=>Software(SPFACE=0)(Default) <1=>Hardware(SPFACE=1)
//          <i>SPFACE=0 SPIF is only cleared by CPU software.
//          <i>SPFACE=1 SPIF is also cleared by CPU read/write SPDAT operation.
#define SPI_Slave_SPIF_Auto_Cleared_Daisy_Chain 0
//      </e>Slave Mode Enable
//      </e>Daisy Chain
//      <e>QPI Mode
#define SPI_Connection_QPI_Mode 0
//      <o>QPI Data Bus Control
//          <0=>Input(QDOE=0)(Default)
//          <1=>Ouput(QDOE=1)
//          <i> QPI Data Bus Control
#define SPI_Mode_QPI_Data_Bus_Control 0
//      <o>Mode
//          <0=>Slave(Default)
//          <1=>Master
//          <i> Slave/master mode select
#define SPI_Mode_QPI_Mode 0
//===========================================================
//      <e>Slave Mode Enable
//===========================================================
//          <i> Note: gpio wizard select P14 nSS P15 MOSI (SPID0) P16 MISO (SPID1) P17 SPICLK P53 SPID2 P54 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P42 MOSI (SPID0) P41 MISO (SPID1) P40 SPICLK P36 SPID2 P37 SPID3 .
//          <i> Note: gpio wizard select P40 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P43 SPICLK P65 SPID2 P57 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P40 SPICLK P65 SPID2 P57 SPID3 .
#define SPI_Slave_Mode_QPI_Mode 0
//      <o>Slave Mode
//          <0x00=>SPI Disable(SPEN=0,SSIG=0,MSTR=0)(Default)
//          <0x01=>Slave Select by nSS(SPEN=1,SSIG=0,MSTR=0)
//          <0x02=>Slave Select by MSTR(SPEN=1,SSIG=1,MSTR=0)
#define SPI_Slave_Mode_Initial_QPI_Mode 0x00
//      <o>Data Mode
//          <0x00=>Mode0(CPOL=0,CPHA=0)
//          <0x01=>Mode1(CPOL=0,CPHA=1)(Default)
//          <0x02=>Mode2(CPOL=1,CPHA=0)
//          <0x03=>Mode3(CPOL=1,CPHA=1)
//          <i> Clock Phase Bit (CPHA) allows the user to set the edges for sampling and changing data.
//          <i> The Clock Polarity bit, CPOL, allows the user to set the clock polarity. The following figures show the different settings of Clock Phase Bit, CPHA.
#define SPI_Slave_Data_Mode_CPOL_CPHA_QPI_Mode 0x01
//      <o>Data Order <0=>MSB(DORD=0)(Default) <1=>LSB(DORD=1)
//          <i> Data order select MSB (DORD=0) or LSB (DORD=1).
#define SPI_Slave_Data_Order_QPI_Mode 0
//      <o>Transfer Completion Flag Auto-Cleared<0=>Software(SPFACE=0)(Default) <1=>Hardware(SPFACE=1)
//          <i>SPFACE=0 SPIF is only cleared by CPU software.
//          <i>SPFACE=1 SPIF is also cleared by CPU read/write SPDAT operation.
#define SPI_Slave_SPIF_Auto_Cleared_QPI_Mode 0
//      </e>Slave Mode Enable
//===========================================================
//      <e>Master Mode Enable
//===========================================================
//          <i> Note: gpio wizard select P14 nSS P15 MOSI (SPID0) P16 MISO (SPID1) P17 SPICLK P53 SPID2 P54 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P42 MOSI (SPID0) P41 MISO (SPID1) P40 SPICLK P36 SPID2 P37 SPID3 .
//          <i> Note: gpio wizard select P40 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P43 SPICLK P65 SPID2 P57 SPID3 .
//          <i> Note: gpio wizard select P43 nSS P41 MOSI (SPID0) P42 MISO (SPID1) P40 SPICLK P65 SPID2 P57 SPID3 .
#define SPI_Master_Mode_QPI_Mode 0
//      <o>Master Mode
//          <0x00=>SPI Disable(SPEN=0,SSIG=0,MSTR=0)(Default)
//          <0x03=>Master Dual Role Select by nSS(SPEN=1,SSIG=0,MSTR=1)
//          <0x04=>Master Select by MSTR(SPEN=1,SSIG=1,MSTR=1)
#define SPI_Master_Mode_Initial_QPI_Mode 0x00
//      <o>Clock Rate
//          <0x00=>SYSCLK/4(SPR2=0,SPR1=0,SPR0=0)(Default)
//          <0x01=>SYSCLK/8(SPR2=0,SPR1=0,SPR0=1)
//          <0x02=>SYSCLK/16(SPR2=0,SPR1=1,SPR0=0)
//          <0x03=>SYSCLK/32(SPR2=0,SPR1=1,SPR0=1)
//          <0x04=>SYSCLK/64(SPR2=1,SPR1=0,SPR0=0)
//          <0x05=>SYSCLK/2(SPR2=1,SPR1=0,SPR0=1)
//          <0x06=>S0TOF/6(SPR2=1,SPR1=1,SPR0=0)
//          <0x07=>T0OF/6(SPR2=1,SPR1=1,SPR0=1)
//          <i> Note:SYSCLK is the system clock.
//          <i> ClockRate		SYSCLK/n	SPR2	SPR1	SPR0
//          <i> 3Mhz   			SYSCLK/4 	 0   	 0   	 0	IHRCO 12MHZ
//          <i> 1.5Mhz 			SYSCLK/8 	 0   	 0   	 1	IHRCO 12MHZ
//          <i> 750Khz 			SYSCLK/16	 0   	 1   	 0	IHRCO 12MHZ
//          <i> 375Khz 			SYSCLK/32	 0   	 1   	 1	IHRCO 12MHZ
//          <i> 187.5hz			SYSCLK/64	 1   	 0   	 0	IHRCO 12MHZ
//          <i> 6Mhz   			SYSCLK/2 	 1   	 0   	 1	IHRCO 12MHZ
//          <i> 12Mhz  			SYSCLK/4 	 0   	 0   	 0	IHRCO 48MHZ
//          <i> 6Mhz   			SYSCLK/8 	 0   	 0   	 1	IHRCO 48MHZ
//          <i> 3Mhz   			SYSCLK/16	 0   	 1   	 0	IHRCO 48MHZ
//          <i> 1.5Mhz 			SYSCLK/32	 0   	 1   	 1	IHRCO 48MHZ
//          <i> 750Khz 			SYSCLK/64	 1   	 0   	 0	IHRCO 48MHZ
//          <i> 24Mhz  			SYSCLK/2 	 1   	 0   	 1	IHRCO 48MHZ(Vdd 5V)

//          <i> S0TOF S0BRG overflow .
//          <i> S0TOF = Fsysclk/((12^(1-S0TX12)) x (256-S0BRT)) .
//          <i> T0OF timer0 overflow .

#define SPI_Master_Clock_Rate_Config_QPI_Mode 0x00
//      <o>Data Mode
//          <0x00=>Mode0(CPOL=0,CPHA=0)
//          <0x01=>Mode1(CPOL=0,CPHA=1)(Default)
//          <0x02=>Mode2(CPOL=1,CPHA=0)
//          <0x03=>Mode3(CPOL=1,CPHA=1)
//          <i> Clock Phase Bit (CPHA) allows the user to set the edges for sampling and changing data.
//          <i> The Clock Polarity bit, CPOL, allows the user to set the clock polarity. The following figures show the different settings of Clock Phase Bit, CPHA.
#define SPI_Master_Data_Mode_CPOL_CPHA_QPI_Mode 0x01
//      <o>Data Order <0=>MSB(DORD=0)(Default) <1=>LSB(DORD=1)
//          <i> Data order select MSB (DORD=0) or LSB (DORD=1).
#define SPI_Master_Data_Order_QPI_Mode 0
//      <o>Transfer Completion Flag Auto-Cleared<0=>Software(SPFACE=0)(Default) <1=>Hardware(SPFACE=1)
//          <i>SPFACE=0 SPIF is only cleared by CPU software.
//          <i>SPFACE=1 SPIF is also cleared by CPU read/write SPDAT operation.
#define SPI_Master_SPIF_Auto_Cleared_QPI_Mode 0
//      </e>Master Mode Enable
//      </e>QPI Mode
//      </e>SPI Enable
//      </e>Advanced Mode
//      </e>Initialize Serial Peripheral Interface

/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Initial SPI , Mode , Clock Rate , PinMux , Daisy-Chain , Data Order.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_Easy_Wizard_Init()
* @endcode
*******************************************************************************
*/
#define __DRV_SPI_Easy_Wizard_Init()\
    MWT(\
        __DRV_SPI_Mode_Easy_Select(SPI_Easy_Select);\
        __DRV_SPI_Clock_Rate_Easy_Select(SPI_Easy_Select);\
        __DRV_SPI_Data_Mode_Easy_Select(SPI_Easy_Select);\
        __DRV_SPI_Data_Order_Easy_Select(SPI_Easy_Select);\
        __DRV_SPI_PinMux_Easy_Select(SPI_Easy_Select);\
        __DRV_SPI_Connection_Easy_Select(SPI_Easy_Select);\
    ;)
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize I2C0
//<i> Check this term, then will initialize I2C0 interface.
//  <i> Note: gpio wizard alternate function must to select P4.0 as TWI0_SCL, P4.1 as TWI0_SDA.
//  <i> Note: gpio wizard alternate function must to select P6.0 as TWI0_SCL, P6.1 as TWI0_SDA.
//  <i> Note: gpio wizard alternate function must to select P3.1 as TWI0_SCL, P3.0 as TWI0_SDA.
//  <i> Note: gpio wizard alternate function must to select P2.5 as TWI0_SCL, P2.3 as TWI0_SDA.
//<i> Date: 2020/11/13     Version: 1.00
#define MG82F6D64_I2C0_WIZARD 0

//  <o0> Select Config Mode
//  <i> This only changes the parameters of "__DRV_I2C0_Wizard_Init();"
//      <1=> Easy Mode
//      <2=> Advanced Mode
    #define DRV_I2C0_Wizard_Mode 1

//  <e0> Easy Mode
//  <i> There are two Transceiver function can be used as following
//  <i> "Sample_I2C0_Master_Byte_Write(I2C0_Address, I2C0_Data)"
//  <i> "Sample_I2C0_Master_Byte_Read(I2C0_Address)"
    #define DRV_I2C0_Wizard_Easy_Check 1

//      <O0>  Master Transceiver Clock Rate
//      <i> Easy select clock by "__DRV_I2C0_Easy_ClockRate_Select(__SELECT__);"
//      <i> Users please note that the system clock must be set to 12MHz or 24MHz
//          <0x80=> 100K (SYSCLK = 12M)
//          <0x81=> 100K (SYSCLK = 24M)
//          <0x02=> 400K (SYSCLK = 12M)
//          <0x03=> 400K (SYSCLK = 24M)
            #define DRV_I2C0_Easy_ClockRate_Config 0x80
//  </e> Easy Mode

//  <e0> Advanced Mode
//  <i> The setting only change the parameter of "__DRV_I2C0_Wizard_Init ();"
    #define DRV_I2C0_Wizard_Advanced_Check 0


//      <e0> Master Mode
        #define DRV_I2C0_Master_Mode_En 0
//          <O0> Basic Clock Rate Select
//          <i> Select OSCin by "__DRV_I2C0_ClockRate_Select(__SELECT__);"
//              <0x00=> SYSCLK/8 (CR2=0, CR1=0, CR0=0)(Default)
//              <0x01=> SYSCLK/16 (CR2=0, CR1=0, CR0=1)
//              <0x02=> SYSCLK/32 (CR2=0, CR1=1, CR0=0)
//              <0x03=> SYSCLK/64 (CR2=0, CR1=1, CR0=1)
//              <0x80=> SYSCLK/128 (CR2=1, CR1=0, CR0=0)
//              <0x81=> SYSCLK/256 (CR2=1, CR1=0, CR0=1)
//              <0x82=> S0TOF/6 (CR2=1, CR1=1, CR0=0)
//              <0x83=> T0OF/6 (CR2=1, CR1=1, CR0=1)
            #define DRV_I2C0_Basic_ClockRate_Config 0x00
//      </e> IHRCO Enable/Disable


//      <e0> Slave Mode
        #define DRV_I2C0_Slave_Mode_En 0
//          <q0> General Call Function Select (GC)
//          <i> Select Slave Address General Call Function Enable or Disable by "__DRV_I2C0_GC_Select(__SELECT__);"
            #define DRV_I2C0_General_Call 0
//          <O0> Slave Address Assignation (SIADR) <0x00-0x7f>
//          <i> Users only need to set slave address, from 0x00~0x7F
            #define DRV_I2C0_Slave_Address 0x00
//          <e0> Multiple Slave Address
                #define DRV_I2C0_Multiple_Slave_Address_En 0
//              <O0> Second Slave Address Assignation (SIA2) <0x00-0x7f>
//              <i> Users only need to the second slave address, from 0x00~0x7F
                #define DRV_I2C0_Second_Slave_Address 0x00
//              <O0> Second Slave Address Bit Mask (SIA2M) <0x00-0x7f>
//              <i> Users only need to set the bit mask of second slave address, from 0x00~0x7F
                #define DRV_I2C0_Second_Slave_Address_Mask 0x00
//          </e>
//      </e>
//  </e>    Advanced Mode End

//</e> Initialize I2C0 End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize I2C1
//<i> Check this term, then will initialize I2C1 interface.
//  <i> Note: gpio wizard alternate function must to select P4.2 as TWI1_SCL, P4.3 as TWI1_SDA.
//  <i> Note: gpio wizard alternate function must to select P6.0 as TWI1_SCL, P6.1 as TWI1_SDA.
//  <i> Note: gpio wizard alternate function must to select P6.5 as TWI1_SCL, P6.6 as TWI1_SDA.
//  <i> Note: gpio wizard alternate function must to select P6.3 as TWI1_SCL, P6.2 as TWI1_SDA.
//<i> Date: 2020/11/13     Version: 1.00
#define MG82F6D64_I2C1_WIZARD 0

//  <o0> Select Config Mode
//  <i> This only changes the parameters of "__DRV_I2C1_Wizard_Init();"
//      <1=> Easy Mode
//      <2=> Advanced Mode
    #define DRV_I2C1_Wizard_Mode 1

//  <e0> Easy Mode
//  <i> There are two Transceiver function can be used as following
//  <i> "Sample_I2C1_Master_Byte_Write(I2C1_Address, I2C1_Data)"
//  <i> "Sample_I2C1_Master_Byte_Read(I2C1_Address)"
    #define DRV_I2C1_Wizard_Easy_Check 1

//      <O0>  Master Transceiver Clock Rate
//      <i> Easy select clock by "__DRV_I2C1_Easy_ClockRate_Select(__SELECT__);"
//      <i> Users please note that the system clock must be set to 12MHz or 24MHz
//          <0x80=> 100K (SYSCLK = 12M)
//          <0x81=> 100K (SYSCLK = 24M)
//          <0x02=> 400K (SYSCLK = 12M)
//          <0x03=> 400K (SYSCLK = 24M)
            #define DRV_I2C1_Easy_ClockRate_Config 0x80
//  </e> Easy Mode

//  <e0> Advanced Mode
//  <i> The setting only change the parameter of "__DRV_I2C1_Wizard_Init ();"
    #define DRV_I2C1_Wizard_Advanced_Check 0


//      <e0> Master Mode
        #define DRV_I2C1_Master_Mode_En 0
//          <O0> Basic Clock Rate Select
//          <i> Select OSCin by "__DRV_I2C1_ClockRate_Select(__SELECT__);"
//              <0x00=> SYSCLK/8 (CR21=0, CR11=0, CR01=0)(Default)
//              <0x01=> SYSCLK/16 (CR21=0, CR11=0, CR01=1)
//              <0x02=> SYSCLK/32 (CR21=0, CR11=1, CR01=0)
//              <0x03=> SYSCLK/64 (CR21=0, CR11=1, CR01=1)
//              <0x80=> SYSCLK/128 (CR21=1, CR11=0, CR01=0)
//              <0x81=> SYSCLK/256 (CR21=1, CR11=0, CR01=1)
//              <0x82=> S0TOF/6 (CR21=1, CR11=1, CR01=0)
//              <0x83=> T0OF/6 (CR21=1, CR11=1, CR01=1)
            #define DRV_I2C1_Basic_ClockRate_Config 0x00
//      </e> IHRCO Enable/Disable


//      <e0> Slave Mode
        #define DRV_I2C1_Slave_Mode_En 0
//          <q0> General Call Function Select (GC1)
//          <i> Select Slave Address General Call Function Enable or Disable by "__DRV_I2C1_GC_Select(__SELECT__);"
            #define DRV_I2C1_General_Call 0
//          <O0> Slave Address Assignation (SI1ADR) <0x00-0x7f>
//          <i> Users only need to set slave address, from 0x00~0x7F
            #define DRV_I2C1_Slave_Address 0x00
//          <e0> Multiple Slave Address
                #define DRV_I2C1_Multiple_Slave_Address_En 0
//              <O0> Second Slave Address Assignation (SI1A2) <0x00-0x7f>
//              <i> Users only need to set the second slave address, from 0x00~0x7F
                #define DRV_I2C1_Second_Slave_Address 0x00
//              <O0> Second Slave Address Bit Mask (SI1A2M) <0x00-0x7f>
//              <i> Users only need to set the bit mask of second slave address, from 0x00~0x7F
                #define DRV_I2C1_Second_Slave_Address_Mask 0x00
//          </e>
//      </e>
//  </e>    Advanced Mode End

//</e> Initialize I2C1 End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize SI2C
//<i> Check this term, then will initialize SI2C0 interface.
//<i> Date: 2020/12/04     Version: 1.00
#define MG82F6D64_SI2C_WIZARD 0

//  <o0> SID/STWI Port pin Selection
//  <i> Setup nINT1, S0MI, TWI0, TWI1, T2EX, T3EX pin by GPIO menu.
//      <0x00=> STWI_SCL=nINT1, STWI_SDA=S0MI (SIDPS1=0, SIDPS0=0)(Default)
//      <0x40=> STWI_SCL=TWI0_SCL, STWI_SDA=TWI0_SDA (SIDPS1=0, SIDPS0=1)
//      <0x80=> STWI_SCL=TWI1_SCL, STWI_SDA=TWI1_SDA (SIDPS1=1, SIDPS0=0)
//      <0xC0=> STWI_SCL=T2EXI, STWI_SDA=T3EXI (SIDPS1=1, SIDPS0=1)
    #define WizDef_SI2C_AF 0x00

//</e> Initialize SI2C0 End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize Beeper
//<i> Check this term to initialize beeper.
//<i> Warning: Enable beeper will disable OCD ICE function.
//<i> Date: 2020/10/17     Version: 1.00
#define MG82F6D64_BEEPER_WIZARD    0

//  <o0> Beeper Output Selection
//  <i>  Select beeper output.
//      <0=> P44 (BPOC1 = 0, BPOC0 = 0)(Default)
//      <1=> ILRCO/32 (BPOC1 = 0, BPOC0 = 1)
//      <2=> ILRCO/16 (BPOC1 = 1, BPOC0 = 0)
//      <3=> ILRCO/8 (BPOC1 = 1, BPOC0 = 1)
        #define AUXR3_BPOCx      0
//</e> Beeper END

/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize KBI
//<i> Check this term, then will initialize KBI interface.
//<i> Date: 2021/11/02     Version: 1.00
#define MG82F6D64_KBI_WIZARD 0

//  <o0> KBI Interrupt Matching Polarity Select
//  <i> The setting only change the parameter of "__DRV_KBI_PatternMatchingType_Select(__SELECT__);".
//      <0x00=> Not equal (PATN_SEL=0)(Default)
//      <0x02=> Equal (PATN_SEL=1)
    #define KBI_IT_PATTERN_MATCHING_SELECTION  0x00

//  <o0> KBI Interrupt Trigger Type Select
//  <i> The setting only change the parameter of "__DRV_KBI_TriggerType_Select(__SELECT__);".
//      <0x00=> Level (KBES=0)(Default)
//      <0x20=> Edge (KBES=1)
    #define KBI_IT_TRIGGER_TYPE                0x00

//  <o0> KBI Interrupt Filter Mode Select
//  <i> The setting only change the parameter of "__DRV_KBI_FilterMode_Select(KBI_FILTER_MODE_TYPE);".
//      <0x00=> Disabled (KBCS1~0=00)(Default)
//      <0x40=> SYSCLK x 3 (KBCS1~0=01)
//      <0x80=> SYSCLK/6 x 3 (KBCS1~0=10)
//      <0xC0=> S0TOF x 3 (KBCS1~0=11)
    #define KBI_IT_FILTER_MODE_TYPE            0x00

//  <e0.0> KBI Pin0 Enable
//  <i> KBI Pin0 enable or disable by user option.
//  <i> Note: the KBI Pin0~Pin3 (low nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.0 alternate function as KBI0 by user application.
//  <i> Note: gpio wizard must to select P0.0 alternate function as KBI0 by user application.
//  <i> Note: gpio wizard must to select P2.0 alternate function as KBI0 by user application.
//  <i> Note: gpio wizard must to select P4.0 alternate function as KBI0 by user application.

//      <o1.0> KBI_Pin0 Pattern
//      <i> KBI pin0 pattern type select.
//          <0x00=> 0 (KBPATN.0=0)
//          <0x01=> 1 (KBPATN.0=1)(Default)
//  </e>

//  <e0.1> KBI Pin1 Enable
//  <i> KBI Pin1 enable or disable by user option.
//  <i> Note: the KBI Pin0~Pin3 (low nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.1 alternate function as KBI1 by user application.
//  <i> Note: gpio wizard must to select P0.1 alternate function as KBI1 by user application.
//  <i> Note: gpio wizard must to select P2.1 alternate function as KBI1 by user application.
//  <i> Note: gpio wizard must to select P4.1 alternate function as KBI1 by user application.

//      <o1.1> KBI_Pin1 Pattern
//      <i> KBI pin1 pattern type select.
//          <0x00=> 0 (KBPATN.1=0)
//          <0x01=> 1 (KBPATN.1=1)(Default)
//  </e>

//  <e0.2> KBI Pin2 Enable
//  <i> KBI Pin2 enable or disable by user option.
//  <i> Note: the KBI Pin0~Pin3 (low nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.2 alternate function as KBI2 by user application.
//  <i> Note: gpio wizard must to select P0.2 alternate function as KBI2 by user application.
//  <i> Note: gpio wizard must to select P2.2 alternate function as KBI2 by user application.
//  <i> Note: gpio wizard must to select P4.2 alternate function as KBI2 by user application.

//      <o1.2> KBI_Pin2 Pattern
//      <i> KBI pin2 pattern type select.
//          <0x00=> 0 (KBPATN.2=0)
//          <0x01=> 1 (KBPATN.2=1)(Default)
//  </e>

//  <e0.3> KBI Pin3 Enable
//  <i> KBI Pin3 enable or disable by user option.
//  <i> Note: the KBI Pin0~Pin3 (low nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.3 alternate function as KBI3 by user application.
//  <i> Note: gpio wizard must to select P0.3 alternate function as KBI3 by user application.
//  <i> Note: gpio wizard must to select P2.3 alternate function as KBI3 by user application.
//  <i> Note: gpio wizard must to select P4.3 alternate function as KBI3 by user application.

//      <o1.3> KBI_Pin3 Pattern
//      <i> KBI pin3 pattern type select.
//          <0x00=> 0 (KBPATN.3=0)
//          <0x01=> 1 (KBPATN.3=1)(Default)
//  </e>

//  <e0.4> KBI Pin4 Enable
//  <i> KBI Pin4 enable or disable by user option.
//  <i> Note: the KBI Pin4~Pin7 (high nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.4 alternate function as KBI4 by user application.
//  <i> Note: gpio wizard must to select P0.4 alternate function as KBI4 by user application.
//  <i> Note: gpio wizard must to select P2.4 alternate function as KBI4 by user application.
//  <i> Note: gpio wizard must to select P6.0 alternate function as KBI4 by user application.

//      <o1.4> KBI_Pin4 Pattern
//      <i> KBI pin4 pattern type select.
//          <0x00=> 0 (KBPATN.4=0)
//          <0x01=> 1 (KBPATN.4=1)(Default)
//  </e>

//  <e0.5> KBI Pin5 Enable
//  <i> KBI Pin5 enable or disable by user option.
//  <i> Note: the KBI Pin4~Pin7 (high nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.5 alternate function as KBI5 by user application.
//  <i> Note: gpio wizard must to select P0.5 alternate function as KBI5 by user application.
//  <i> Note: gpio wizard must to select P2.5 alternate function as KBI5 by user application.
//  <i> Note: gpio wizard must to select P6.1 alternate function as KBI5 by user application.

//      <o1.5> KBI_Pin5 Pattern
//      <i> KBI pin5 pattern type select.
//          <0x00=> 0 (KBPATN.5=0)
//          <0x01=> 1 (KBPATN.5=1)(Default)
//  </e>

//  <e0.6> KBI Pin6 Enable
//  <i> KBI Pin6 enable or disable by user option.
//  <i> Note: the KBI Pin4~Pin7 (high nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.6 alternate function as KBI6 by user application.
//  <i> Note: gpio wizard must to select P0.6 alternate function as KBI6 by user application.
//  <i> Note: gpio wizard must to select P2.6 alternate function as KBI6 by user application.
//  <i> Note: gpio wizard must to select P6.2 alternate function as KBI6 by user application.

//      <o1.6> KBI_Pin6 Pattern
//      <i> KBI pin6 pattern type select.
//          <0x00=> 0 (KBPATN.6=0)
//          <0x01=> 1 (KBPATN.6=1)(Default)
//  </e>

//  <e0.7> KBI Pin7 Enable
//  <i> KBI Pin7 enable or disable by user option.
//  <i> Note: the KBI Pin4~Pin7 (high nibble) need to assign to the same port.
//  <i> Note: gpio wizard must to select P1.7 alternate function as KBI7 by user application.
//  <i> Note: gpio wizard must to select P0.7 alternate function as KBI7 by user application.
//  <i> Note: gpio wizard must to select P2.7 alternate function as KBI7 by user application.
//  <i> Note: gpio wizard must to select P6.3 alternate function as KBI7 by user application.

//      <o1.7> KBI_Pin7 Pattern
//      <i> KBI pin7 pattern type select.
//          <0x00=> 0 (KBPATN.7=0)
//          <0x01=> 1 (KBPATN.7=1)(Default)
//  </e>

    #define KBI_KBMASK_SELECT             0x00
    #define KBI_KBPATN_TYPE_SELECT        0xFF

//</e> Initialize KBI End
/// @endcond __DRV_Wizard_Without_Doxygen


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//  <e0> Initialize ADC
//  <i> Check this term to initialize ADC.
//  <i> Date: 2020/10/29     Version: 1.00
#define MG82F6D64_ADC_WIZARD        0

//  <o0> ADC Trigger Source
//  <i> ADC trigger mode selection.
//      <0x00=> Software (ADTM3=0,ADTM2=0,ADTM1=0,ADTM0=0)(Default)
//      <0x01=> Timer 0 overflow (ADTM3=0,ADTM2=0,ADTM1=0,ADTM0=1)
//      <0x02=> Free running mode (ADTM3=0,ADTM2=0,ADTM1=1,ADTM0=0)
//      <0x03=> S0BRG overflow (ADTM3=0,ADTM2=0,ADTM1=1,ADTM0=1)
//      <0x10=> KBIET (ADTM3=0,ADTM2=1,ADTM1=0,ADTM0=0)
//      <0x11=> INT1ET (ADTM3=0,ADTM2=1,ADTM1=0,ADTM0=1)
//      <0x12=> INT2ET (ADTM3=0,ADTM2=1,ADTM1=1,ADTM0=0)
//      <0x13=> INT3ET (ADTM3=0,ADTM2=1,ADTM1=1,ADTM0=1)
//      <0x20=> T2EXES (ADTM3=1,ADTM2=0,ADTM1=0,ADTM0=0)
//      <0x21=> AC0ES (ADTM3=1,ADTM2=0,ADTM1=0,ADTM0=1)
//      <0x22=> T3EXES (ADTM3=1,ADTM2=0,ADTM1=1,ADTM0=0)
//      <0x23=> AC1ES (ADTM3=1,ADTM2=0,ADTM1=1,ADTM0=1)
//      <0x30=> PCA0 overflow (ADTM3=1,ADTM2=1,ADTM1=0,ADTM0=0)
//      <0x31=> C0CMP6 (ADTM3=1,ADTM2=1,ADTM1=0,ADTM0=1)
//      <0x32=> C0CMP6 or C0CMP7 (ADTM3=1,ADTM2=1,ADTM1=1,ADTM0=0)
//      <0x33=> BM0FES (ADTM3=1,ADTM2=1,ADTM1=1,ADTM0=1)
    #define __ADC_TRG__     0x0000

//  <o0> ADC Input Channel
//  <i> Input channel selection for ADC analog multiplexer.
//      <0x00=> AIN0 (ACHS=0,CHS3=0,CHS2=0,CHS1=0,CHS0=0)(Default)
//      <0x01=> AIN1 (ACHS=0,CHS3=0,CHS2=0,CHS1=0,CHS0=1)
//      <0x02=> AIN2 (ACHS=0,CHS3=0,CHS2=0,CHS1=1,CHS0=0)
//      <0x03=> AIN3 (ACHS=0,CHS3=0,CHS2=0,CHS1=1,CHS0=1)
//      <0x04=> AIN4 (ACHS=0,CHS3=0,CHS2=1,CHS1=0,CHS0=0)
//      <0x05=> AIN5 (ACHS=0,CHS3=0,CHS2=1,CHS1=0,CHS0=1)
//      <0x06=> AIN6 (ACHS=0,CHS3=0,CHS2=1,CHS1=1,CHS0=0)
//      <0x07=> AIN7 (ACHS=0,CHS3=0,CHS2=1,CHS1=1,CHS0=1)
//      <0x20=> AIN8 (ACHS=0,CHS3=1,CHS2=0,CHS1=0,CHS0=0)
//      <0x21=> AIN9 (ACHS=0,CHS3=1,CHS2=0,CHS1=0,CHS0=1)
//      <0x22=> AIN10 (ACHS=0,CHS3=1,CHS2=0,CHS1=1,CHS0=0)
//      <0x23=> AIN11 (ACHS=0,CHS3=1,CHS2=0,CHS1=1,CHS0=1)
//      <0x24=> AIN12 (ACHS=0,CHS3=1,CHS2=1,CHS1=0,CHS0=0)
//      <0x25=> AIN13 (ACHS=0,CHS3=1,CHS2=1,CHS1=0,CHS0=1)
//      <0x26=> AIN14 (ACHS=0,CHS3=1,CHS2=1,CHS1=1,CHS0=0)
//      <0x27=> AIN15 (ACHS=0,CHS3=1,CHS2=1,CHS1=1,CHS0=1)
//      <0x08=> Internal Vref 1.4V (ACHS=1,CHS3=0,CHS2=0,CHS1=0,CHS0=0)
//      <0x09=> VSS (ACHS=1,CHS3=0,CHS2=0,CHS1=0,CHS0=1)
    #define __ADC_CHL__     0x00

//  <o0> ADC Clock Source
//  <i> ADC conversion clock select.
//  <i> ADC Sample rate = ADC Clock Source/30.
//      <0x00=> SYSCLK/1 (ADCKS2=0,ADCKS1=0,ADCKS0=0)(Default)
//      <0x20=> SYSCLK/2 (ADCKS2=0,ADCKS1=0,ADCKS0=1)
//      <0x40=> SYSCLK/4 (ADCKS2=0,ADCKS1=1,ADCKS0=0)
//      <0x60=> SYSCLK/8 (ADCKS2=0,ADCKS1=1,ADCKS0=1)
//      <0x80=> SYSCLK/16 (ADCKS2=1,ADCKS1=0,ADCKS0=0)
//      <0xA0=> SYSCLK/32 (ADCKS2=1,ADCKS1=0,ADCKS0=1)
//      <0xC0=> S0BRG overflow/2 (ADCKS2=1,ADCKS1=1,ADCKS0=0)
//      <0xE0=> Timer 2 overflow/2 (ADCKS2=1,ADCKS1=1,ADCKS0=1)
    #define __ADC_CLKS__    0x00

//  <o0> ADC Data Alignment
//  <i> Left justified : The most significant 8 bits of conversion result are saved in ADCDH[7:0], while the least significant 4 bits in ADCDL[7:4].
//  <i> Right justified : The most significant 4 bits of conversion result are saved in ADCDH[3:0], while the least significant 8 bits in ADCDL[7:0].
//      <0x00=> Left justified (ADRJ=0)(Default)
//      <0x10=> Right justified (ADRJ=1)
    #define __ADC_DATAALIGNMENT__   0x00

//  <e0> ADC Window Detect
//  <i>Configuration ADC window detect.
    #define __WINDOW_DETECT_EN__    0

//      <o0> Window Detect Mode
//      <i> ADC value
//      <i>____4095
//      <i>|   | Outside
//      <i>|   |<----- High Boundary
//      <i>|   | Inside
//      <i>|   |<----- Low Boundary
//      <i>|   | Outside
//      <i>|__| 0
//          <0x00=> Inside (ADWM0=0)(Default)
//          <0x40=> Outside (ADWM0=1)
        #define __ADC_WD_MODE__     0x00

//      <o0> High Boundary Value is (1~4095)<1-4095>
//      <i>ADC Window detect high boundary value
//      <i>High boundary value cannot be lower than low boundary value.
        #define __ADC_WD_HB__       4095

//      <o0> Low Boundary Value is (0~4094)<0-4094>
//      <i>ADC Window detect low boundary value
//      <i>Low boundary value cannot be higher than high boundary value.
        #define __ADC_WD_LB__       0
//  </e> ADC Window Detect End

//  <e0> ADC Scan Loop
//  <i> Configuration ADC scan loop pin.
    #define __SCAN_LOOP_EN__    0

//      <q0.0> AIN0 Enable
//      <q0.1> AIN1 Enable
//      <q0.2> AIN2 Enable
//      <q0.3> AIN3 Enable
//      <q0.4> AIN4 Enable
//      <q0.5> AIN5 Enable
//      <q0.6> AIN6 Enable
//      <q0.7> AIN7 Enable
//      <q0.8> AIN8 Enable
//      <q0.9> AIN9 Enable
//      <q0.10> AIN10 Enable
//      <q0.11> AIN11 Enable
//      <q0.12> AIN12 Enable
//      <q0.13> AIN13 Enable
//      <q0.14> AIN14 Enable
//      <q0.15> AIN15 Enable
        #define SCAN_LOOP_PIN   0x0000
//  </e>

//</e> ADC End

/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize ACx
//  <i> Check this term to initialize Analog Comparator.
//  <i> Date: 2020/10/29     Version: 1.00
#define MG82F6D64_ACx_WIZARD        0
//  <e0> AC0
//  <i> Analog Comparator 0
//  <i> The setting only change the parameter of "__DRV_AC_Wizard_Init ();"
        #define __AC0_CTL__ 0
//      <o0> AC0 Positive input
//      <i> Positive input on I/O channel selector of analog comparator 0.
//          <0x00=> P02 (AC0PIS1=0,AC0PIS0=0)(Default)
//          <0x01=> P03 (AC0PIS1=0,AC0PIS0=1)
//          <0x02=> P04 (AC0PIS1=1,AC0PIS0=0)
//          <0x03=> P05 (AC0PIS1=1,AC0PIS0=1)
            #define __AC0_PIS__     0x00

//      <o0> AC0 Negative input
//      <i> Negative input on Voltage Reference selector of analog comparator 0.
//          <0x00=> P0.1 (NVRS3=0,NVRS2=0,NVRS1=0,NVRS0=0,NVRL=0)(Default)
//          <0x10=> 9/32 VDD (NVRS3=0,NVRS2=0,NVRS1=0,NVRS0=1,NVRL=0)
//          <0x20=> 10/32 VDD (NVRS3=0,NVRS2=0,NVRS1=1,NVRS0=0,NVRL=0)
//          <0x30=> 11/32 VDD (NVRS3=0,NVRS2=0,NVRS1=1,NVRS0=1,NVRL=0)
//          <0x40=> 12/32 VDD (NVRS3=0,NVRS2=1,NVRS1=0,NVRS0=0,NVRL=0)
//          <0x50=> 13/32 VDD (NVRS3=0,NVRS2=1,NVRS1=0,NVRS0=1,NVRL=0)
//          <0x60=> 14/32 VDD (NVRS3=0,NVRS2=1,NVRS1=1,NVRS0=0,NVRL=0)
//          <0x70=> 15/32 VDD (NVRS3=0,NVRS2=1,NVRS1=1,NVRS0=1,NVRL=0)
//          <0x80=> 16/32 VDD (NVRS3=1,NVRS2=0,NVRS1=0,NVRS0=0,NVRL=0)
//          <0x90=> 17/32 VDD (NVRS3=1,NVRS2=0,NVRS1=0,NVRS0=1,NVRL=0)
//          <0xA0=> 18/32 VDD (NVRS3=1,NVRS2=0,NVRS1=1,NVRS0=0,NVRL=0)
//          <0xB0=> 19/32 VDD (NVRS3=1,NVRS2=0,NVRS1=1,NVRS0=1,NVRL=0)
//          <0xC0=> 20/32 VDD (NVRS3=1,NVRS2=1,NVRS1=0,NVRS0=0,NVRL=0)
//          <0xD0=> 21/32 VDD (NVRS3=1,NVRS2=1,NVRS1=0,NVRS0=1,NVRL=0)
//          <0xE0=> 22/32 VDD (NVRS3=1,NVRS2=1,NVRS1=1,NVRS0=0,NVRL=0)
//          <0xF0=> 23/32 VDD (NVRS3=1,NVRS2=1,NVRS1=1,NVRS0=1,NVRL=0)
//          <0x08=> Internal Vref 1.4V (NVRS3=0,NVRS2=0,NVRS1=0,NVRS0=0,NVRL=1)
//          <0x18=> 1/24 VDD (NVRS3=0,NVRS2=0,NVRS1=0,NVRS0=1,NVRL=1)
//          <0x28=> 2/24 VDD (NVRS3=0,NVRS2=0,NVRS1=1,NVRS0=0,NVRL=1)
//          <0x38=> 3/24 VDD (NVRS3=0,NVRS2=0,NVRS1=1,NVRS0=1,NVRL=1)
//          <0x48=> 4/24 VDD (NVRS3=0,NVRS2=1,NVRS1=0,NVRS0=0,NVRL=1)
//          <0x58=> 5/24 VDD (NVRS3=0,NVRS2=1,NVRS1=0,NVRS0=1,NVRL=1)
//          <0x68=> 6/24 VDD (NVRS3=0,NVRS2=1,NVRS1=1,NVRS0=0,NVRL=1)
//          <0x78=> 7/24 VDD (NVRS3=0,NVRS2=1,NVRS1=1,NVRS0=1,NVRL=1)
//          <0x88=> 8/24 VDD (NVRS3=1,NVRS2=0,NVRS1=0,NVRS0=0,NVRL=1)
//          <0x98=> 9/24 VDD (NVRS3=1,NVRS2=0,NVRS1=0,NVRS0=1,NVRL=1)
//          <0xA8=> 10/24 VDD (NVRS3=1,NVRS2=0,NVRS1=1,NVRS0=0,NVRL=1)
//          <0xB8=> 11/24 VDD (NVRS3=1,NVRS2=0,NVRS1=1,NVRS0=1,NVRL=1)
//          <0xC8=> 12/24 VDD (NVRS3=1,NVRS2=1,NVRS1=0,NVRS0=0,NVRL=1)
//          <0xD8=> 13/24 VDD (NVRS3=1,NVRS2=1,NVRS1=0,NVRS0=1,NVRL=1)
//          <0xE8=> 14/24 VDD (NVRS3=1,NVRS2=1,NVRS1=1,NVRS0=0,NVRL=1)
//          <0xF8=> 15/24 VDD (NVRS3=1,NVRS2=1,NVRS1=1,NVRS0=1,NVRL=1)
            #define __AC0_NIS__     0x00

//      <e0> AC0 output Filter
//      <i>  Analog Comparator 0 output Filter control.
            #define __AC0_FLT_EN__     0

//          <o0> Filter mode
//              <0x0000=> Disabled (AC0FLT1=0,AC0FLT=0)(Default)
//              <0x0004=> SYSCLK x 3 (AC0FLT1=0,AC0FLT=1)
//              <0x0500=> SYSCLK/6 x 3 (AC0FLT1=1,AC0FLT=0)
//              <0x0504=> T3OF x 3 (AC0FLT1=1,AC0FLT=1)
                #define __AC0_FLT__   0x0000
//      </e> AC0 output Filter End

//      <o0> AC0 Power mode
//      <i>  Analog Comparator 0 Low Power Enable.
//      <i>  Normal Power : Fast response time.
//      <i>  Low Power : Slow response time.
//           <0=> Normal Power (AC0LP=0)(Default)
//           <1=> Low Power (AC0LP=1)
            #define __AC0_LP__     0

//      <o0> AC0 in PD mode
//      <i>  Analog Comparator 0 control in PD mode.
//      <i>  Disable : Analog Comparator 0 to be gated off during PD mode.
//      <i>  Enable : Analog Comparator 0 to continue its function during PD mode.
//           <0=> Disable (AC0PDX=0)(Default)
//           <1=> Enable (AC0PDX=1)
            #define __AC0_PD__     0

//      <o0> AC0 output inversion
//      <i>  Analog Comparator 0 output inversion.
//           <0=> Not inverted (AC0INV=0)(Default)
//           <1=> Inverted (AC0INV=1)
            #define __AC0_INV__     0

//      <o0> AC0 Interrupt Mode
//      <i>  Analog Comparator 0 Interrupt Mode.
//           <0=> Reserved (AC0M1=0,AC0M0=0)(Default)
//           <1=> Falling edge (AC0M1=0,AC0M0=1)
//           <2=> Rising edge (AC0M1=1,AC0M0=0)
//           <3=> Toggle (AC0M1=1,AC0M0=1)
            #define __AC0_INTM__     0

//      <o0> AC0 Hysteresis
//      <i>  Analog Comparator 0 Hysteresis Control.
//           <0=> Disable (AC0HC0=0)
//           <1=> Enable (AC0HC0=1)(Default)
            #define __AC0_HYS__     1

//      <o0> AC0 Output
//      <i>  Analog Comparator 0 output on P00.
//           <0=> Disable (AC0OE=0)(Default)
//           <1=> Enable (AC0OE=1)
            #define __AC0_OUT__     0
//  </e> AC0 End

//===============================================================================
//  <e0> AC1
//  <i> Analog Comparator 1
//  <i> The setting only change the parameter of "__DRV_AC_Wizard_Init ();"
        #define __AC1_CTL__ 0

//      <o0> AC1 Negative input
//      <i> Negative input on Voltage Reference selector of analog comparator 1.
//      <i> The positive input is fixed at P07.
//          <0x00=> P0.6 (AC1NIS=0,NVRL1=0)(Default)
//          <0x08=> Internal Vref 1.4V (AC1NIS=0,NVRL1=1)
//          <0x10=> AC0 negative input(AC1NIS=1,NVRL1=0)
            #define __AC1_NIS__     0x00

//      <e0> AC1 output Filter
//      <i>  Analog Comparator 1 output Filter control.
            #define __AC1_FLT_EN__     0

//          <o0> Filter mode
//              <0x0000=> Disabled (AC1FLT1=0,AC1FLT=0)(Default)
//              <0x0004=> SYSCLK x 3 (AC1FLT1=0,AC1FLT=1)
//              <0x0500=> SYSCLK/6 x 3 (AC1FLT1=1,AC1FLT=0)
//              <0x0504=> T3OF x 3 (AC1FLT1=1,AC1FLT=1)
                #define __AC1_FLT__   0x0000
//      </e> AC1 output Filter End

//      <o0> AC1 Power mode
//      <i>  Analog Comparator 1 Low Power Enable.
//      <i>  Normal Power : Fast response time.
//      <i>  Low Power : Slow response time.
//           <0=> Normal Power (AC1LP=0)(Default)
//           <1=> Low Power (AC1LP=1)
            #define __AC1_LP__     0

//      <o0> AC1 in PD mode
//      <i>  Analog Comparator 1 control in PD mode.
//      <i>  Disable : Analog Comparator 1 to be gated off during PD mode.
//      <i>  Enable : Analog Comparator 1 to continue its function during PD mode.
//           <0=> Disable (AC1PDX=0)(Default)
//           <1=> Enable (AC1PDX=1)
            #define __AC1_PD__     0

//      <o0> AC1 output inversion
//      <i>  Analog Comparator 1 output inversion.
//           <0=> Not inverted (AC1INV=0)(Default)
//           <1=> Inverted (AC1INV=1)
            #define __AC1_INV__     0

//      <o0> AC1 Interrupt Mode
//      <i>  Analog Comparator 1 Interrupt Mode.
//           <0=> Reserved (AC1M1=0,AC1M0=0)(Default)
//           <1=> Falling edge (AC1M1=0,AC1M0=1)
//           <2=> Rising edge (AC1M1=1,AC1M0=0)
//           <3=> Toggle (AC1M1=1,AC1M0=1)
            #define __AC1_INTM__     0

//      <o0> AC1 Hysteresis
//      <i>  Analog Comparator 1 Hysteresis Control.
//           <0=> Disable (AC1HC0=0)
//           <1=> Enable (AC1HC0=1)(Default)
            #define __AC1_HYS__     1

//      <o0> AC1 Output
//      <i>  Analog Comparator 1 output on P72.
//           <0=> Disable (AC1OE=0)(Default)
//           <1=> Enable (AC1OE=1)
            #define __AC1_OUT__     0
//  </e> AC1 End

//===============================================================================
//  <e0> AC2
//  <i> Analog Comparator 2
//  <i> The setting only change the parameter of "__DRV_AC_Wizard_Init ();"
        #define __AC2_CTL__ 0

//      <o0> AC2 Negative input
//      <i> Negative input on Voltage Reference selector of analog comparator 2.
//      <i> The positive input is fixed at P63.
//          <0x00=> P6.2 (AC2NIS=0,NVRL2=0)(Default)
//          <0x08=> Internal Vref 1.4V (AC2NIS=0,NVRL2=1)
//          <0x10=> AC0 negative input(AC2NIS=1,NVRL2=0)
            #define __AC2_NIS__     0x00

//      <e0> AC2 output Filter
//      <i>  Analog Comparator 2 output Filter control.
            #define __AC2_FLT_EN__     0

//          <o0> Filter mode
//              <0x0000=> Disabled (AC2FLT1=0,AC2FLT=0)(Default)
//              <0x0004=> SYSCLK x 3 (AC2FLT1=0,AC2FLT=1)
//              <0x0500=> SYSCLK/6 x 3 (AC2FLT1=1,AC2FLT=0)
//              <0x0504=> T3OF x 3 (AC2FLT1=1,AC2FLT=1)
                #define __AC2_FLT__   0x0000
//      </e> AC2 output Filter End

//      <o0> AC2 Power mode
//      <i>  Analog Comparator 2 Low Power Enable.
//      <i>  Normal Power : Fast response time.
//      <i>  Low Power : Slow response time.
//           <0=> Normal Power (AC2LP=0)(Default)
//           <1=> Low Power (AC2LP=1)
            #define __AC2_LP__     0

//      <o0> AC2 in PD mode
//      <i>  Analog Comparator 2 control in PD mode.
//      <i>  Disable : Analog Comparator 2 to be gated off during PD mode.
//      <i>  Enable : Analog Comparator 2 to continue its function during PD mode.
//           <0=> Disable (AC2PDX=0)(Default)
//           <1=> Enable (AC2PDX=1)
            #define __AC2_PD__     0

//      <o0> AC2 output inversion
//      <i>  Analog Comparator 2 output inversion.
//           <0=> Not inverted (AC2INV=0)(Default)
//           <1=> Inverted (AC2INV=1)
            #define __AC2_INV__     0

//      <o0> AC2 Interrupt Mode
//      <i>  Analog Comparator 2 Interrupt Mode.
//           <0=> Reserved (AC2M1=0,AC2M0=0)(Default)
//           <1=> Falling edge (AC2M1=0,AC2M0=1)
//           <2=> Rising edge (AC2M1=1,AC2M0=0)
//           <3=> Toggle (AC2M1=1,AC2M0=1)
            #define __AC2_INTM__     0

//      <o0> AC2 Hysteresis
//      <i>  Analog Comparator 2 Hysteresis Control.
//           <0=> Disable (AC2HC0=0)
//           <1=> Enable (AC2HC0=1)(Default)
            #define __AC2_HYS__     1

//      <o0> AC2 Output
//      <i>  Analog Comparator 2 output on P64.
//           <0=> Disable (AC2OE=0)(Default)
//           <1=> Enable (AC2OE=1)
            #define __AC2_OUT__     0
//  </e> AC2 End

//</e> AC End


/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize IAP
//<i> Check this term, then you can customize the IAP boundary on your demands.
//<i> Date: 2020/09/04     Version: 1.00
#define MG82F6D64_IAP_WIZARD        0

//  <o> IAP Boundary    <0x00-0xff:0x02>
//  <i> Set up IAP boundary which must be an even unsigned character(uint8_t).
//  <i> Further, a legal IAP boundary msut not be higher than ISP start address.
    #define IAP_BOUNDARY            0xF6
//</e> In-Application-Programming(IAP) END

#if MG82F6D64_IAP_WIZARD
void DRV_IAP_Boundary_Wizard_Init(void);
#endif
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
//*****************************************************************************
//<e0> Initialize Global Interrupts
//<i> Check this term to initialize(enable) interrupts.
//<i> Then, please go to MG82F6D64_INT_VECTOR.c to codding the interrupts you need.
//<i> Date: 2021/10/20     Version: 1.02
#define MG82F6D64_INT_ALL_WIZARD    0
//-----------------------------------------------------------------------------
//  <o> Global Interrupt
//  <i> Global Interrupt control.
//       <0=> Disable (EA=0)(Default)
//       <1=> Enable (EA=1)
         #define MG82F6D64_INT_GLOBAL_EN 0

//  <e0> External Interrupt 0
//  <i> External interrupt 0 enable.
//  <i> We also provide further setting details for External Interrupt 0, please go to MG82F6D64_INV_DRV.h.
//  <i> Note: gpio wizard must to select P3.2 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P3.0 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P3.4 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P4.0 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P1.0 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P1.4 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P3.6 alternate function as nINT0 by user application.
//  <i> Note: gpio wizard must to select P0.5 alternate function as nINT0 by user application.
    #define MG82F6D64_INT0_EN               0

//      <o> nINT0 Interrupt Configuration
//      <i> nINT0 interrupt and vector configuration
//          <0=> nINT0 Interrupt Disable (EX0=0)(Default)
//          <1=> nINT0 Interrupt Vector Only (EX0=0)
//          <2=> nINT0 Interrupt Enable with Vector (EX0=1)
        #define MG82F6D64_INT0_VECTOR_CONFIG      0

//      <o0> nINT0 Interrupt Priority
//          <0x0000=> 0 (PX0H=0, PX0L=0)(Lowest)(Default)
//          <0x0001=> 1 (PX0H=0, PX0L=1)
//          <0x0100=> 2 (PX0H=1, PX0L=0)
//          <0x0101=> 3 (PX0H=1, PX0L=1)(Highest)
        #define MG82F6D64_INT0_PRIORITY     0x0000

//      <o0.0..15> nINT0 Interrupt Trigger Type Select
//      <i> The setting only change the parameter of "__DRV_INT0_TriggerType_Select(__SELECT__);"
//          <0x0000=> Low Level (IT0=0, INT0H=0)(Default)
//          <0x0001=> High Level (IT0=0, INT0H=1)
//          <0x0100=> Falling Edge (IT0=1, INT0H=0)
//          <0x0101=> Rising Edge (IT0=1, INT0H=1)
        #define nINT0_TRIGGER_TYPE          0x0000

//      <o0.0..15> nINT0 Interrupt Filter Mode Type Select
//      <i> The setting only change the parameter of "__DRV_INT0_FilterMode_Select(__SELECT__);"
//          <0x0000=> Disable (X0FLT1=0, X0FLT=0)(Default)
//          <0x0001=> SYSCLK X 3 (X0FLT1=0, X0FLT=1)
//          <0x0100=> SYSCLK/6 X 3 (X0FLT1=1, X0FLT=0)
//          <0x0101=> S0TOF X 3 (X0FLT1=1, X0FLT=1)
        #define nINT0_FILTER_MODE_TYPE      0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> External Interrupt 1
//  <i> External interrupt 1 enable.
//  <i> We also provide further setting details for External Interrupt 1, please go to MG82F6D64_INV_DRV.h.
//  <i> Note: gpio wizard must to select P3.3 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P3.1 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P3.5 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P4.1 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P4.5 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P1.5 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P3.7 alternate function as nINT1 by user application.
//  <i> Note: gpio wizard must to select P0.7 alternate function as nINT1 by user application.
    #define MG82F6D64_INT1_EN               0

//      <o> nINT1 Interrupt Configuration
//      <i> nINT1 interrupt and vector configuration
//          <0=> nINT1 Interrupt Disable (EX1=0)(Default)
//          <1=> nINT1 Interrupt Vector Only (EX1=0)
//          <2=> nINT1 Interrupt Enable with Vector (EX1=1)
        #define MG82F6D64_INT1_VECTOR_CONFIG      0

//      <o0> nINT1 Interrupt Priority
//          <0x0000=> 0 (PX1H=0, PX1L=0)(Lowest)(Default)
//          <0x0004=> 1 (PX1H=0, PX1L=1)
//          <0x0400=> 2 (PX1H=1, PX1L=0)
//          <0x0404=> 3 (PX1H=1, PX1L=1)(Highest)
        #define MG82F6D64_INT1_PRIORITY     0x0000

//      <o0.0..15> nINT1 Interrupt Trigger Type Select
//      <i> The setting only change the parameter of "__DRV_INT1_TriggerType_Select(__SELECT__);"
//          <0x0000=> Low Level (IT1=0, INT1H=0)(Default)
//          <0x0002=> High Level (IT1=0, INT1H=1)
//          <0x0400=> Falling Edge (IT1=1, INT1H=0)
//          <0x0402=> Rising Edge (IT1=1, INT1H=1)
        #define nINT1_TRIGGER_TYPE          0x0000

//      <o0.0..15> nINT1 Interrupt Filter Mode Type Select
//      <i> The setting only change the parameter of "__DRV_INT1_FilterMode_Select(__SELECT__);"
//          <0x0000=> Disable (X1FLT1=0, X1FLT=0)(Default)
//          <0x0002=> SYSCLK X 3 (X1FLT1=0, X1FLT=1)
//          <0x0200=> SYSCLK/6 X 3 (X1FLT1=1, X1FLT=0)
//          <0x0202=> S0TOF X 3 (X1FLT1=1, X1FLT=1)
        #define nINT1_FILTER_MODE_TYPE      0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> External Interrupt 2
//  <i> External interrupt 2 enable.
//  <i> We also provide further setting details for External Interrupt 2, please go to MG82F6D64_INV_DRV.h.
//  <i> Note: gpio wizard must to select P4.3 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P2.0 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P1.1 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P2.5 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P4.4 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P6.0 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P0.1 alternate function as nINT2 by user application.
//  <i> Note: gpio wizard must to select P6.2 alternate function as nINT2 by user application.
    #define MG82F6D64_INT2_EN               0

//      <o> nINT2 Interrupt Configuration
//      <i> nINT2 interrupt and vector configuration
//          <0=> nINT2 Interrupt Disable (EX2=0)(Default)
//          <1=> nINT2 Interrupt Vector Only (EX2=0)
//          <2=> nINT2 Interrupt Enable with Vector (EX2=1)
        #define MG82F6D64_INT2_VECTOR_CONFIG      0

//      <o0> nINT2 Interrupt Priority
//          <0x0000=> 0 (PX2H=0, PX2L=0)(Lowest)(Default)
//          <0x0040=> 1 (PX2H=0, PX2L=1)
//          <0x4000=> 2 (PX2H=1, PX2L=0)
//          <0x4040=> 3 (PX2H=1, PX2L=1)(Highest)
        #define MG82F6D64_INT2_PRIORITY     0x0000

//      <o0> nINT2 Interrupt Trigger Type Select
//      <i> The setting only change the parameter of "__DRV_INT2_TriggerType_Select(__SELECT__);"
//          <0x00=> Low Level (IT2=0, INT2H=0)(Default)
//          <0x08=> High Level (IT2=0, INT2H=1)
//          <0x01=> Falling Edge (IT2=1, INT2H=0)
//          <0x09=> Rising Edge (IT2=1, INT2H=1)
        #define nINT2_TRIGGER_TYPE          0x00

//      <o2.0..15> nINT2 Interrupt Filter Mode Type Select
//      <i> The setting only change the parameter of "__DRV_INT2_FilterMode_Select(__SELECT__);"
//          <0x0000=> Disable (X2FLT1=0, X2FLT=0)(Default)
//          <0x0004=> SYSCLK X 3 (X2FLT1=0, X2FLT=1)
//          <0x0400=> SYSCLK/6 X 3 (X2FLT1=1, X2FLT=0)
//          <0x0404=> S0TOF X 3 (X2FLT1=1, X2FLT=1)
        #define nINT2_FILTER_MODE_TYPE      0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> External Interrupt 3
//  <i> External interrupt 3 enable.
//  <i> We also provide further setting details for External Interrupt 3, please go to MG82F6D64_INV_DRV.h.
//  <i> Note: gpio wizard must to select P4.2 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P2.1 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P0.0 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P1.6 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P0.2 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P6.1 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P0.6 alternate function as nINT3 by user application.
//  <i> Note: gpio wizard must to select P6.3 alternate function as nINT3 by user application.
    #define MG82F6D64_INT3_EN               0

//      <o> nINT3 Interrupt Configuration
//      <i> nINT3 interrupt and vector configuration
//          <0=> nINT3 Interrupt Disable (EX3=0)(Default)
//          <1=> nINT3 Interrupt Vector Only (EX3=0)
//          <2=> nINT3 Interrupt Enable with Vector (EX3=1)
        #define MG82F6D64_INT3_VECTOR_CONFIG      0

//      <o0> nINT3 Interrupt Priority
//          <0x0000=> 0 (PX3H=0, PX3L=0)(Lowest)(Default)
//          <0x0080=> 1 (PX3H=0, PX3L=1)
//          <0x8000=> 2 (PX3H=1, PX3L=0)
//          <0x8080=> 3 (PX3H=1, PX3L=1)(Highest)
        #define MG82F6D64_INT3_PRIORITY     0x0000

//      <o0> nINT3 Interrupt Trigger Type Select
//      <i> The setting only change the parameter of "__DRV_INT3_TriggerType_Select(__SELECT__);"
//          <0x00=> Low Level (IT3=0, INT3H=0)(Default)
//          <0x80=> High Level (IT3=0, INT3H=1)
//          <0x10=> Falling Edge (IT3=1, INT3H=0)
//          <0x90=> Rising Edge (IT3=1, INT3H=1)
        #define nINT3_TRIGGER_TYPE          0x00

//      <o2.0..15> nINT3 Interrupt Filter Mode Type Select
//      <i> The setting only change the parameter of "__DRV_INT3_FilterMode_Select(__SELECT__);"
//          <0x0000=> Disable (X3FLT1=0, X3FLT=0)(Default)
//          <0x0008=> SYSCLK X 3 (X3FLT1=0, X3FLT=1)
//          <0x0800=> SYSCLK/6 X 3 (X3FLT1=1, X3FLT=0)
//          <0x0808=> S0TOF X 3 (X3FLT1=1, X3FLT=1)
        #define nINT3_FILTER_MODE_TYPE      0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Timer 0 Interrupt
//  <i> Timer0 interrupt enable.
    #define MG82F6D64_TIMER0_IT_EN          0

//     <o> Timer0 Interrupt Configuration
//     <i> Timer0 interrupt and vector configuration
//          <0=> Timer0 Interrupt Disable (ET0=0)(Default)
//          <1=> Timer0 Interrupt Vector Only (ET0=0)
//          <2=> Timer0 Interrupt Enable with Vector (ET0=1)
       #define MG82F6D64_TIMER0_IT_VECTOR_CONFIG      0

//      <o0> Timer0 Interrupt Priority
//          <0x0000=> 0 (PT0H=0, PT0L=0)(Lowest)(Default)
//          <0x0002=> 1 (PT0H=0, PT0L=1)
//          <0x0200=> 2 (PT0H=1, PT0L=0)
//          <0x0202=> 3 (PT0H=1, PT0L=1)(Highest)
        #define MG82F6D64_TIMER0_IT_PRIORITY   0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Timer 1 Interrupt
//  <i> Timer1 interrupt enable.
    #define MG82F6D64_TIMER1_IT_EN      0

//     <o> Timer1 Interrupt Configuration
//     <i> Timer1 interrupt and vector configuration
//          <0=> Timer1 Interrupt Disable (ET1=0)(Default)
//          <1=> Timer1 Interrupt Vector Only (ET1=0)
//          <2=> Timer1 Interrupt Enable with Vector (ET1=1)
       #define MG82F6D64_TIMER1_IT_VECTOR_CONFIG      0

//      <o0> Timer1 Interrupt Priority
//          <0x0000=> 0 (PT1H=0, PT1L=0)(Lowest)(Default)
//          <0x0008=> 1 (PT1H=0, PT1L=1)
//          <0x0800=> 2 (PT1H=1, PT1L=0)
//          <0x0808=> 3 (PT1H=1, PT1L=1)(Highest)
        #define MG82F6D64_TIMER1_IT_PRIORITY   0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Timer 2 Interrupt
//  <i> Timer2 interrupt enable.
    #define MG82F6D64_TIMER2_IT_EN          0

//     <o> Timer2 Interrupt Configuration
//     <i> Timer2 interrupt and vector configuration
//          <0=> Timer2 Interrupt Disable (ET2=0)(Default)
//          <1=> Timer2 Interrupt Vector Only (ET2=0)
//          <2=> Timer2 Interrupt Enable with Vector (ET2=1)
       #define MG82F6D64_TIMER2_IT_VECTOR_CONFIG      0

//      <o0> Timer2 Interrupt Priority
//          <0x0000=> 0 (PT2H=0, PT2L=0)(Lowest)(Default)
//          <0x0020=> 1 (PT2H=0, PT2L=1)
//          <0x2000=> 2 (PT2H=1, PT2L=0)
//          <0x2020=> 3 (PT2H=1, PT2L=1)(Highest)
        #define MG82F6D64_TIMER2_IT_PRIORITY   0x0000

//      <o> Timer2 TL2 Overflow In Split Mode
//      <i> Timer2 split mode TL2 overflow interrupt enable.
//          <0=> Disable (TF2L=0)(Default)
//          <1=> Enable (TF2L=1)
        #define MG82F6D64_TIMER2_IT_TF2L_EN       1
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Timer 3 Interrupt
//  <i> Timer3 interrupt enable.
    #define MG82F6D64_TIMER3_IT_EN              0

//     <o> Timer3 Interrupt Configuration
//     <i> Timer3 interrupt and vector configuration
//          <0=> Timer3 Interrupt Disable (ET3=0)(Default)
//          <1=> Timer3 Interrupt Vector Only (ET3=0)
//          <2=> Timer3 Interrupt Enable with Vector (ET3=1)
       #define MG82F6D64_TIMER3_IT_VECTOR_CONFIG      0

//      <o0> Timer3 Interrupt Priority
//          <0x0000=> 0 (PT3H=0, PT3L=0)(Lowest)(Default)
//          <0x0001=> 1 (PT3H=0, PT3L=1)
//          <0x0100=> 2 (PT3H=1, PT3L=0)
//          <0x0101=> 3 (PT3H=1, PT3L=1)(Highest)
        #define MG82F6D64_TIMER3_IT_PRIORITY      0x0000

//      <o> Timer3 TL3 Overflow In Split Mode
//      <i> Timer3 split mode TL3 overflow interrupt enable.
//          <0=> Disable (TF3L=0)(Default)
//          <1=> Enable (TF3L=1)
        #define MG82F6D64_TIMER3_IT_TF3L_EN       1
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Timer 4 Interrupt
//  <i> Timer4 interrupt enable.
    #define MG82F6D64_TIMER4_IT_EN              0

//     <o> Timer4 Interrupt Configuration
//     <i> Timer4 interrupt and vector configuration
//          <0=> Timer4 Interrupt Disable (ET4=0)(Default)
//          <1=> Timer4 Interrupt Vector Only (ET4=0)
//          <2=> Timer4 Interrupt Enable with Vector (ET4=1)
       #define MG82F6D64_TIMER4_IT_VECTOR_CONFIG      0

//      <o0> Timer4 Interrupt Priority
//          <0x0000=> 0 (PT4H=0, PT4L=0)(Lowest)(Default)
//          <0x0008=> 1 (PT4H=0, PT4L=1)
//          <0x0800=> 2 (PT4H=1, PT4L=0)
//          <0x0808=> 3 (PT4H=1, PT4L=1)(Highest)
        #define MG82F6D64_TIMER4_IT_PRIORITY      0x0000

//      <o> Timer4 TL4 Overflow In Split Mode
//      <i> Timer4 split mode TL4 overflow interrupt enable.
//          <0=> Disable (TF4L=0)(Default)
//          <1=> Enable (TF4L=1)
        #define MG82F6D64_TIMER4_IT_TF4L_EN       0
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Serial Port 0 Interrupt
//  <i> Serial Port 0 enable.
    #define MG82F6D64_S0_IT_EN              0

//     <o> Serial Port 0 Interrupt Configuration
//     <i> Serial port 0 interrupt and vector configuration
//          <0=> Serial Port 0 Interrupt Disable (ES0=0)(Default)
//          <1=> Serial Port 0 Interrupt Vector Only (ES0=0)
//          <2=> Serial Port 0 Interrupt Enable with Vector (ES0=1)
       #define MG82F6D64_S0_IT_VECTOR_CONFIG      0

//      <o0> Serial Port 0 Interrupt Priority
//          <0x0000=> 0 (PS0H=0, PS0L=0)(Lowest)(Default)
//          <0x0010=> 1 (PS0H=0, PS0L=1)
//          <0x1000=> 2 (PS0H=1, PS0L=0)
//          <0x1010=> 3 (PS0H=1, PS0L=1)(Highest)
        #define MG82F6D64_S0_IT_PRIORITY       0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Serial Port 1 Interrupt
//  <i> Serial Port 1 enable.
    #define MG82F6D64_S1_IT_EN                  0

//     <o> Serial Port 1 Interrupt Configuration
//     <i> Serial port 1 interrupt and vector configuration
//          <0=> Serial Port 1 Interrupt Disable (ES1=0)(Default)
//          <1=> Serial Port 1 Interrupt Vector Only (ES1=0)
//          <2=> Serial Port 1 Interrupt Enable with Vector (ES1=1)
       #define MG82F6D64_S1_IT_VECTOR_CONFIG      0

//      <o0> Serial Port 1 Interrupt Priority
//          <0x0000=> 0 (PS1H=0, PS1L=0)(Lowest)(Default)
//          <0x0010=> 1 (PS1H=0, PS1L=1)
//          <0x1000=> 2 (PS1H=1, PS1L=0)
//          <0x1010=> 3 (PS1H=1, PS1L=1)(Highest)
        #define MG82F6D64_S1_IT_PRIORITY           0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Serial Port 2 Interrupt
//  <i> Serial Port 2 enable.
    #define MG82F6D64_S2_IT_EN              0

//     <o> Serial Port 2 Interrupt Configuration
//     <i> Serial port 2 interrupt and vector configuration
//          <0=> Serial Port 2 Interrupt Disable (ES2=0)(Default)
//          <1=> Serial Port 2 Interrupt Vector Only (ES2=0)
//          <2=> Serial Port 2 Interrupt Enable with Vector (ES2=1)
       #define MG82F6D64_S2_IT_VECTOR_CONFIG      0

//      <o0> Serial Port 2 Interrupt Priority
//          <0x0000=> 0 (PS2H=0, PS2L=0)(Lowest)(Default)
//          <0x0004=> 1 (PS2H=0, PS2L=1)
//          <0x0400=> 2 (PS2H=1, PS2L=0)
//          <0x0404=> 3 (PS2H=1, PS2L=1)(Highest)
        #define MG82F6D64_S2_IT_PRIORITY       0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Serial Port 3 Interrupt
//  <i> Serial Port 3 enable.
    #define MG82F6D64_S3_IT_EN              0

//     <o> Serial Port 3 Interrupt Configuration
//     <i> Serial port 3 interrupt and vector configuration
//          <0=> Serial Port 3 Interrupt Disable (ES3=0)(Default)
//          <1=> Serial Port 3 Interrupt Vector Only (ES3=0)
//          <2=> Serial Port 3 Interrupt Enable with Vector (ES3=1)
       #define MG82F6D64_S3_IT_VECTOR_CONFIG      0

//      <o0> Serial Port 3 Interrupt Priority
//          <0x0000=> 0 (PS3H=0, PS3L=0)(Lowest)(Default)
//          <0x0010=> 1 (PS3H=0, PS3L=1)
//          <0x1000=> 2 (PS3H=1, PS3L=0)
//          <0x1010=> 3 (PS3H=1, PS3L=1)(Highest)
        #define MG82F6D64_S3_IT_PRIORITY       0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> ADC Interrupt
//  <i> ADC interrupt enable.
    #define MG82F6D64_ADC_IT_EN             0

//      <o> ADC Interrupt Configuration
//      <i> ADC interrupt and vector configuration
//          <0=> ADC Interrupt Disable (EADC=0)(Default)
//          <1=> ADC Interrupt Vector Only (EADC=0)
//          <2=> ADC Interrupt Enable with Vector (EADC=1)
        #define MG82F6D64_ADC_IT_VECTOR_CONFIG      0

//      <o0> ADC Interrupt Priority
//          <0x0000=> 0 (PADCH=0, PADCL=0)(Lowest)(Default)
//          <0x0002=> 1 (PADCH=0, PADCL=1)
//          <0x0200=> 2 (PADCH=1, PADCL=0)
//          <0x0202=> 3 (PADCH=1, PADCL=1)(Highest)
        #define MG82F6D64_ADC_IT_PRIORITY      0x0000

//      <o> ADC Conversion Complete Interrupt (ADCI)
//      <i> ADC conversion complete interrupt enable.
//       <0=> Disable (ADCI=0)(Default)
//       <1=> Enable (ADCI=1)
        #define MG82F6D64_ADC_IT_ADCI_EN       0

//      <o> ADC Channel Sample Complete Interrupt (SMPF)
//      <i> ADC channel sample complete and hold interrupt enable.
//       <0=> Disable (SMPF=0)(Default)
//       <1=> Enable (SMPF=1)
        #define MG82F6D64_ADC_IT_SMPF_EN       0

//      <o> ADC Result match Window Detect Interrupt (ADCWI)
//      <i> ADC result with Window compare match interrupt enable.
//       <0=> Disable (ADCWI=0)(Default)
//       <1=> Enable (ADCWI=1)
        #define MG82F6D64_ADC_IT_ADCWI_EN      0
//  </e>
//-----------------------------------------------------------------------------
//  <e0> AC 0 Interrupt
//  <i> AC0 interrupt enable.
    #define MG82F6D64_AC0_IT_EN                0

//      <o> AC0 Interrupt Configuration
//      <i> AC0 interrupt and vector configuration
//          <0=> AC0 Interrupt Disable (EAC0=0)(Default)
//          <1=> AC0 Interrupt Vector Only (EAC0=0)
//          <2=> AC0 Interrupt Enable with Vector (EAC0=1)
        #define MG82F6D64_AC0_IT_VECTOR_CONFIG      0

//      <o0> AC0 Interrupt Priority
//          <0x0000=> 0 (PAC0H=0, PAC0L=0)(Lowest)(Default)
//          <0x0080=> 1 (PAC0H=0, PAC0L=1)
//          <0x8000=> 2 (PAC0H=1, PAC0L=0)
//          <0x8080=> 3 (PAC0H=1, PAC0L=1)(Highest)
        #define MG82F6D64_AC0_IT_PRIORITY         0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> AC 1 Interrupt
//  <i> AC1 interrupt enable.
    #define MG82F6D64_AC1_IT_EN                0

//      <o> AC1 Interrupt Configuration
//      <i> AC1 interrupt and vector configuration
//          <0=> AC1 Interrupt Disable (EAC1=0)(Default)
//          <1=> AC1 Interrupt Vector Only (EAC1=0)
//          <2=> AC1 Interrupt Enable with Vector (EAC1=1)
        #define MG82F6D64_AC1_IT_VECTOR_CONFIG      0

//      <o0> AC1 Interrupt Priority
//          <0x0000=> 0 (PAC1H=0, PAC1L=0)(Lowest)(Default)
//          <0x0002=> 1 (PAC1H=0, PAC1L=1)
//          <0x0200=> 2 (PAC1H=1, PAC1L=0)
//          <0x0202=> 3 (PAC1H=1, PAC1L=1)(Highest)
        #define MG82F6D64_AC1_IT_PRIORITY         0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> AC 2 Interrupt
//  <i> AC2 interrupt enable.
    #define MG82F6D64_AC2_IT_EN                0

//     <o> AC2 Interrupt Configuration
//     <i> AC2 interrupt and vector configuration
//          <0=> AC2 Interrupt Disable (EAC2=0)(Default)
//          <1=> AC2 Interrupt Vector Only (EAC2=0)
//          <2=> AC2 Interrupt Enable with Vector (EAC2=1)
       #define MG82F6D64_AC2_IT_VECTOR_CONFIG      0

//      <o0> AC2 Interrupt Priority
//          <0x0000=> 0 (PAC2H=0, PAC2L=0)(Lowest)(Default)
//          <0x0080=> 1 (PAC2H=0, PAC2L=1)
//          <0x8000=> 2 (PAC2H=1, PAC2L=0)
//          <0x8080=> 3 (PAC2H=1, PAC2L=1)(Highest)
        #define MG82F6D64_AC2_IT_PRIORITY         0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> PCA Interrupt
//  <i> PCA interrupt configuration.
    #define MG82F6D64_PCA_IT_EN            0

//     <o> PCA Interrupt Configuration
//     <i> PCA interrupt and vector configuration
//          <0=> PCA Interrupt Disable (EPCA=0)(Default)
//          <1=> PCA Interrupt Vector Only (EPCA=0)
//          <2=> PCA Interrupt Enable with Vector (EPCA=1)
       #define MG82F6D64_PCA_IT_VECTOR_CONFIG      0

//      <o0> PCA Interrupt Priority
//          <0x0000=> 0 (PPCAH=0, PPCAL=0)(Lowest)(Default)
//          <0x0004=> 1 (PPCAH=0, PPCAL=1)
//          <0x0400=> 2 (PPCAH=1, PPCAL=0)
//          <0x0404=> 3 (PPCAH=1, PPCAL=1)(Highest)
        #define MG82F6D64_PCA_IT_PRIORITY     0x0000

//      <o> Timer/Counter Overflow Interrupt
//      <i> PCA Timer/Counter interrupt enable.
//          <0=> Disable (ECF=0)(Default)
//          <1=> Enable (ECF=1)
        #define MG82F6D64_PCA_IT_COUNTER_EN       0

//      <o> Module 0 Interrupt
//      <i> PCA Module 0 interrupt enable.
//          <0=> Disable (ECCF0=0)(Default)
//          <1=> Enable (ECCF0=1)
       #define MG82F6D64_PCA_IT_MODULE0_EN      0

//      <o> Module 1 Interrupt
//      <i> PCA Module 1 interrupt enable.
//          <0=> Disable (ECCF1=0)(Default)
//          <1=> Enable (ECCF1=1)
       #define MG82F6D64_PCA_IT_MODULE1_EN      0

//      <o> Module 2 Interrupt
//      <i> PCA Module 2 interrupt enable.
//          <0=> Disable (ECCF2=0)(Default)
//          <1=> Enable (ECCF2=1)
       #define MG82F6D64_PCA_IT_MODULE2_EN      0

//      <o> Module 3 Interrupt
//      <i> PCA Module 3 interrupt enable.
//          <0=> Disable (ECCF3=0)(Default)
//          <1=> Enable (ECCF3=1)
       #define MG82F6D64_PCA_IT_MODULE3_EN      0

//      <o> Module 4 Interrupt
//      <i> PCA Module 4 interrupt enable.
//          <0=> Disable (ECCF4=0)(Default)
//          <1=> Enable (ECCF4=1)
       #define MG82F6D64_PCA_IT_MODULE4_EN      0

//      <o> Module 5 Interrupt
//      <i> PCA Module 5 interrupt enable.
//          <0=> Disable (ECCF5=0)(Default)
//          <1=> Enable (ECCF5=1)
       #define MG82F6D64_PCA_IT_MODULE5_EN      0

//      <o> Module 6 Interrupt
//      <i> PCA Module 6 interrupt enable.
//          <0=> Disable (ECCF6=0)(Default)
//          <1=> Enable (ECCF6=1)
       #define MG82F6D64_PCA_IT_MODULE6_EN      0

//      <o> Module 7 Interrupt
//      <i> PCA Module 7 interrupt enable.
//          <0=> Disable (ECCF7=0)(Default)
//          <1=> Enable (ECCF7=1)
       #define MG82F6D64_PCA_IT_MODULE7_EN      0
//  </e>
//-----------------------------------------------------------------------------
//  <e0> System Flag Interrupt
//  <i> System Flag interrupt enable.
    #define MG82F6D64_SYSFLAG_EN            0

//      <o> System Flag Interrupt Configuration
//      <i> System Flag interrupt and vector configuration.
//          <0=> System Flag Interrupt Disable (ESF=0)(Default)
//          <1=> System Flag Interrupt Vector Only (ESF=0)
//          <2=> System Flag Interrupt Enable with Vector (ESF=1)
        #define MG82F6D64_SYSFLAG_IT_VECTOR_CONFIG      0

//      <o0> System Flag Interrupt Priority
//          <0x0000=> 0 (PSFH=0, PSFL=0)(Lowest)(Default)
//          <0x0008=> 1 (PSFH=0, PSFL=1)
//          <0x0800=> 2 (PSFH=1, PSFL=0)
//          <0x0808=> 3 (PSFH=1, PSFL=1)(Highest)
        #define MG82F6D64_SYSFLAG_IT_PRIORITY      0x0000

//      <o> WDT Interrupt
//      <i> WDT interrupt enable.
//       <0=> Disable (WDTFIE=0)(Default)
//       <1=> Enable (WDTFIE=1)
        #define MG82F6D64_WDT_IT_EN         0

//      <o> RTC Interrupt
//      <i> RTC interrupt enable.'
//       <0=> Disable (RTCFIE=0)(Default)
//       <1=> Enable (RTCFIE=1)
        #define MG82F6D64_RTC_IT_EN         0

//      <o> BOD0 Interrupt
//      <i> BOD0 interrupt enable.
//       <0=> Disable (BOF0IE=0)(Default)
//       <1=> Enable (BOF0IE=1)
        #define MG82F6D64_BOD0_IT_EN        0

//      <o> BOD1 Interrupt
//      <i> BOD1 interrupt enable.
//       <0=> Disable (BOF1IE=0)(Default)
//       <1=> Enable (BOF1IE=1)
        #define MG82F6D64_BOD1_IT_EN        0

//      <o> SI2C Interrupt
//      <i> SI2C interrupt enable.
//       <0=> Disable (SIDFIE=0)(Default)
//       <1=> Enable (SIDFIE=1)
        #define MG82F6D64_SI2C_IT_EN        0
//  </e>
//-----------------------------------------------------------------------------
//  <e0> Keypad Interrupt (KBI)
//  <i> Keypad interrupt enable.
    #define MG82F6D64_KBI_IT_EN                0

//      <o> KBI Interrupt Configuration
//      <i> KBI interrupt and vector configuration.
//          <0=> KBI Interrupt Disable (EKB=0)(Default)
//          <1=> KBI Interrupt Vector Only (EKB=0)
//          <2=> KBI Interrupt Enable with Vector (EKB=1)
        #define MG82F6D64_KBI_IT_VECTOR_CONFIG      0

//      <o0> KBI Interrupt Priority
//          <0x0000=> 0 (PKBH=0, PKBL=0)(Lowest)(Default)
//          <0x0020=> 1 (PKBH=0, PKBL=1)
//          <0x2000=> 2 (PKBH=1, PKBL=0)
//          <0x2020=> 3 (PKBH=1, PKBL=1)(Highest)
        #define MG82F6D64_KBI_IT_PRIORITY          0x0000

//  </e> Keypad Interrupt END
//-----------------------------------------------------------------------------
//  <e0> SPI Interrupt
//  <i> SPI interrupt enable.
    #define MG82F6D64_SPI_IT_EN             0

//      <o> SPI Interrupt Configuration
//      <i> SPI interrupt configuration.
//          <0=> SPI Interrupt Disable (ESPI=0)(Default)
//          <1=> SPI Interrupt Vector Only (ESPI=0)
//          <2=> SPI Interrupt Enable with Vector (ESPI=1)
       #define MG82F6D64_SPI_IT_VECTOR_CONFIG      0

//      <o0> SPI Interrupt Priority
//          <0x0000=> 0 (PSPIH=0, PSPIL=0)(Lowest)(Default)
//          <0x0001=> 1 (PSPIH=0, PSPIL=1)
//          <0x0100=> 2 (PSPIH=1, PSPIL=0)
//          <0x0101=> 3 (PSPIH=1, PSPIL=1)(Highest)
        #define MG82F6D64_SPI_IT_PRIORITY      0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> I2C0 Interrupt
//  <i> "Important" User need to add file "MG82F6D64_I2C0_FLOW_CONTROL.c " to Source Group 1 when I2C0 interrupt enable.
//  <i> The void function "Sample_I2C0_ISR_Handle()" will be used.
    #define MG82F6D64_I2C0_IT_EN                0

//      <o> I2C0 Interrupt Configuration
//      <i> I2C0 interrupt configuration.
//          <0=> I2C0 Interrupt Disable (ETWI0=0)(Default)
//          <1=> I2C0 Interrupt Vector Only (ETWI0=0)
//          <2=> I2C0 Interrupt Enable with Vector (ETWI0=1)
        #define MG82F6D64_I2C0_IT_VECTOR_CONFIG      0

//      <o0> I2C0 Interrupt Priority
//          <0x0000=> 0 (PTWI0H=0, PTWI0L=0)(Lowest)(Default)
//          <0x0040=> 1 (PTWI0H=0, PTWI0L=1)
//          <0x4000=> 2 (PTWI0H=1, PTWI0L=0)
//          <0x4040=> 3 (PTWI0H=1, PTWI0L=1)(Highest)
        #define MG82F6D64_I2C0_IT_PRIORITY         0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> I2C1 Interrupt
//  <i> "Important" User need to add file "MG82F6D64_I2C1_FLOW_CONTROL.c " to Source Group 1 when I2C1 interrupt enable.
//  <i> The void function "Sample_I2C1_ISR_Handle()" will be used.
    #define MG82F6D64_I2C1_IT_EN                0

//      <o> I2C1 Interrupt Configuration
//      <i> I2C1 interrupt configuration.
//          <0=> I2C1 Interrupt Disable (ETWI1=0)(Default)
//          <1=> I2C1 Interrupt Vector Only (ETWI1=0)
//          <2=> I2C1 Interrupt Enable with Vector (ETWI1=1)
        #define MG82F6D64_I2C1_IT_VECTOR_CONFIG      0

//      <o0> I2C1 Interrupt Priority
//          <0x0000=> 0 (PTWI1H=0, PTWI1L=0)(Lowest)(Default)
//          <0x0040=> 1 (PTWI1H=0, PTWI1L=1)
//          <0x4000=> 2 (PTWI1H=1, PTWI1L=0)
//          <0x4040=> 3 (PTWI1H=1, PTWI1L=1)(Highest)
        #define MG82F6D64_I2C1_IT_PRIORITY         0x0000
//  </e>
//-----------------------------------------------------------------------------
//  <e0> DMA Interrupt
//  <i> DMA interrupt enable.
    #define MG82F6D64_DMA_IT_EN                 0

//      <o> DMA Interrupt Configuration
//      <i> DMA interrupt configuration.
//          <0=> DMA Interrupt Disable (EDMA=0)(Default)
//          <1=> DMA Interrupt Vector Only (EDMA=0)
//          <2=> DMA Interrupt Enable with Vector (EDMA=1)
        #define MG82F6D64_DMA_IT_VECTOR_CONFIG       0

//      <o0> DMA Interrupt Priority
//          <0x00=> 0 (PDMAH=0, PDMAL=0)(Lowest)(Default)
//          <0x40=> 1 (PDMAH=0, PDMAL=1)
//          <0x80=> 2 (PDMAH=1, PDMAL=0)
//          <0xC0=> 3 (PDMAH=1, PDMAL=1)(Highest)
        #define MG82F6D64_DMA_IT_PRIORITY          0x00

//      <o> DCF0 Interrupt
//      <i> DMA DCF0 interrupt enable.
//       <0=> Disable (DIE0=0)(Default)
//       <1=> Enable (DIE0=1)
        #define MG82F6D64_DMA_DCF0_IT_EN       0
//      <o> Timer5 Interrupt
//      <i> Timer5 interrupt enable.
//       <0=> Disable (T5IE=0)(Default)
//       <1=> Enable (T5IE=1)
        #define MG82F6D64_DMA_TIMER5_IT_EN      0
//      <o> Timer6 Interrupt
//      <i> Timer6 interrupt enable.
//       <0=> Disable (T6IE=0)(Default)
//       <1=> Enable (T6IE=1)
        #define MG82F6D64_DMA_TIMER6_IT_EN      0
//  </e>
//</e> Global Interrupts END

/// @endcond


//*****************************************************************************
//<<< end of configuration section >>>


//@cond __DRV_Wizard_Without_Doxygen
void System_Wizard_Init(void);
//@endcond

