#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer4 overflow Interrupt(TH4) => TF4_Flag
Timer4 external Interrupt      => EXF4_Flag
Timer4 overflow Interrupt(TL4) => TF4L_Flag
****************************************************************/
uint8_t TF4_Flag, EXF4_Flag, TF4L_Flag;

void main()
{
    /****************************************************************
    Variables
    TF4_count(TH4)        => For time delay
    TF4L_count(TL4)       => For time delay
    ****************************************************************/
    uint16_t TF4_count = 0, TF4L_count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer4 interrupt (ET4) = Enable;
     *  2. Setting TL4IS and then open the TF4L interrupt (TL4IE) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER4_IT_Cmd(MW_ENABLE);
    __DRV_TIMER4_Function_Access_Control_Cmd(MW_ENABLE);
    __DRV_TIMER4_TF4L_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P56 used for LED_D5
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P56_PushPull | P55_PushPull);

    /****************************************************************
     *  Timer4 Initialized
     *  TF4 Interrupt time => (1 / (SYSCLK/12)) * 256 * 3906 = 1 S
     *  TF4L Interrupt time => (1 / (SYSCLK/12)) * 100 * 5000 = 0.5 S
     ****************************************************************/
    __DRV_TIMER4_Mode_Select(TIMER4_SPLIT_MODE2_TWO_8BIT_CAPTURE);
    __DRV_TIMER4_Clock_Source_Select(TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER4_SetLowByte(156);
    __DRV_TIMER4_SetRCAP4L(156);
    __DRV_TIMER_Globel_Enable_Cmd(TR4E | TR4LE);

    while (1)
    {
        if (TF4_Flag)
        {
            TF4_count += 1;
            if (TF4_count == 3906)
            {
                __DRV_GPIO_InversePinP5(P55);
                TF4_count = 0;
            }
            TF4_Flag = 0;
        }

        if (TF4L_Flag)
        {
            TF4L_count += 1;
            if (TF4L_count == 5000)
            {
                __DRV_GPIO_InversePinP5(P56);
                TF4L_count = 0;
            }
            TF4L_Flag = 0;
        }
    }
}

/****************************************************************
Timer4 interrupt
The Timer4 has TF4, EXF4, TF4L flags to trigger the Timer4 interrupt.
****************************************************************/
void TIMER4_TF4_EXF4_TF4L_ISR(void) interrupt TIMER4_ISR_VECTOR
{
    if (DRV_TIMER4_GetTF4() == 1)
    {
        TF4_Flag = 1;
        DRV_TIMER4_ClearTF4();
    }

    if (DRV_TIMER4_GetTF4L() == 1)
    {
        TF4L_Flag = 1;
        DRV_TIMER4_ClearTF4L();
    }

    if (DRV_TIMER4_GetEXF4() == 1)
    {
        EXF4_Flag = 1;
        DRV_TIMER4_ClearEXF4();
    }
}
