
/*


*/


//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <math.h>

bit Timer2_flag = 0;

extern WTYPE NextUDuty;
extern WTYPE NextVDuty;
extern WTYPE NextWDuty;

//-----------------------------------------------------------------------------
// Timer2 initial
//-----------------------------------------------------------------------------
void Timer2_init (void)
{
    TH2 = RCAP2H = 0xFF;
    TL2 = RCAP2L = 0xFF;
    
    T2CON = 0x00;
    T2MOD |= T2X12;
    ET2 = 1;
    
    IP0H |= PT2H;
    PT2L = 1;
}

//-----------------------------------------------------------------------------
// Timer2 ISR (replace the next duty cycle)
//-----------------------------------------------------------------------------
void Timer2_ISR (void) interrupt 5
{ 
    if (NextUDuty.W == 1024) {
//         PCAPWM0 = (P0RS0 | ECAP1L);
        PCAPWM1 = (P0RS0 | ECAP1L);
    } else {
        PCAPWM1 = P0RS0;
        CCAP1H = NextUDuty.B[0];
        CCAP1L = NextUDuty.B[1];
    }
    if (NextVDuty.W == 1024) {
//         PCAPWM2 = (P0RS0 | ECAP1L);
        PCAPWM3 = (P0RS0 | ECAP1L);
    } else {
        PCAPWM3 = P0RS0;
        CCAP3H = NextVDuty.B[0];
        CCAP3L = NextVDuty.B[1];
    }
    if (NextWDuty.W == 1024) {
//         PCAPWM4 = (P0RS0 | ECAP1L);
        PCAPWM5 = (P0RS0 | ECAP1L);
    } else {
        PCAPWM5 = P0RS0;
        CCAP5H = NextWDuty.B[0];
        CCAP5L = NextWDuty.B[1];
    }
    
    Timer2_flag = 1;
    TF2 = 0;
    return;
}

