

//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "sinewaveTable.h"
#include "motor_parameter.h"
#include <math.h>


extern U16 Duty;                 // Duty cycle
extern U16 CurrRPM;                        // the current speed (RPM)
extern U16 TargetRPM;
extern U8 commCNT;

xdata U16 SineWavePWM_T1 [192];
xdata U16 SineWavePWM_T2 [192];

bit TableNO=1;              // declare the current table NO

//-----------------------------------------------------------------------------
// initial SineWave duty for PWM
//-----------------------------------------------------------------------------
void initial_SineWavePWM (U16 level)
{
    U8 i;
    U32 tC;
    
    for (i=0;i<192;i++)
    {
        tC = (U32) sinewave [i];
        tC = tC * level;
        tC = tC / 1000;
        if (tC > 1024) tC = 1024;
        SineWavePWM_T1 [i] = (U16) (1024 - tC);
        SineWavePWM_T2 [i] = (U16) (1024 - tC);
    }

    TableNO = 0;
   
}

//-----------------------------------------------------------------------------
// just generate one 
//-----------------------------------------------------------------------------
void PrepareSineWaveDuty (void)
{
    static U8 SineWaveIndex = 0;       // the index for calculate  sinewave table 
    static U8 GenSinState = GSS_idle;
    static bit tempbit;
    static U32 tC;
    
   
    switch (GenSinState) {
        case GSS_idle:
            if (TargetRPM > CurrRPM)
                Duty ++;
            else 
                Duty --;                    
            
            GenSinState = GSS_loadbase;
            break;
        case GSS_loadbase:
            tC = (U32) sinewave [SineWaveIndex];
            GenSinState = GSS_Mduty;
            break;
        case GSS_Mduty:
            tC = tC * Duty;
            GenSinState = GSS_Div1000;
            break;
        case GSS_Div1000:
            tC = tC / 1000;
            GenSinState = GSS_WriteTable;
            break;
        case GSS_WriteTable:
            tempbit = !TableNO;
            if (tC > 1024) tC = 1024;
            if (!tempbit) {
                SineWavePWM_T1 [SineWaveIndex] = (U16) (1024 - tC);
            } else {
                SineWavePWM_T2 [SineWaveIndex] = (U16) (1024 - tC);
            }
            SineWaveIndex ++;
            if (SineWaveIndex == 192) {
                SineWaveIndex = 0;
                GenSinState = GSS_idle;
                commCNT = 0;
                TableNO = !TableNO;
                return;
            }
            GenSinState = GSS_loadbase;
            break;
        default:
            GenSinState = GSS_idle;
            break;
    
    }
}
