
//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include <intrins.h>
#include "motor_parameter.h"

extern U8 MtrIndex, KBIIndex;       // the Hall IC - output pattern - index        
extern bit CommutateSearch;         // the time flag of Hall index 0 to 5
extern bit SynchronizationFlag;     // commutate signal for synchronization
extern U8 StuckCNT;                 // avoid motor stuck
extern code BYTE KBIPattern[];
extern U8 State;
extern bit Timer2_flag;             // timer 2 ISR flag
extern LTYPE CaledPLLT;     // for calculate timer2 RCAP2H:L
extern U16 Duty;                 // Duty cycle



//-----------------------------------------------------------------------------
// stop PCA output
//-----------------------------------------------------------------------------
void disable_PCA (void)
{    
	CR = CLR;
	CCAPM0 = CCAPM2 = CCAPM4 = NoOperation;  // PCA Module (0~5) = No operation
	CCAPM1 = CCAPM3 = CCAPM5 = NoOperation;  // PCA Module (0~5) = No operation

// 	PCAPWM1 = 0x00;                    // (Bottom) PCA module (inverter)
// 	PCAPWM3 = 0x00;                    // (Bottom) PCA module (inverter)
// 	PCAPWM5 = 0x00;                    // (Bottom) PCA module (inverter)
    
}

//-----------------------------------------------------------------------------
// initial Port pin
//-----------------------------------------------------------------------------
void Port_Init () 
{
    /*
    //5B32
    //P1.0~P1.2 (KBI input)
 	P1M0 = 0x00;	// P1.0~P1.2 (open drain without pull-up)
    PUCON0 |= P1PU0;
    P1AIO |= 0x10;

    // Gate driver - default state (OFF) 
    P2 = 0x00;      // P2.2~P2.7 = UH,UL,VH,VL,WH,WL     
    P2M0 = 0xFC;
    */ 
    
    //6D17
    //P1.0(AIN0/Analog Input) 
    //P1.1 P1.5 P1.6(KBI1 KBI5 KBI6/Open-drain with Pull-up resistor) 
    //P1.7(CEX4/Push-pull Output)
    SFRPI = 0;
    P1M0 = 0xE2;
    P1M1 = 0x7F;
    P17 = 0;
    
    //P2.2 P2.4(CEX0 CEX2/Push-pull Output)
    P2M0 = 0x14;
    SFRPI = 1;
    P2M1 = 0xEB;
    P22 = 0;
    P24 = 0;
    
    //P3.3 P3.4 P3.5(CEX1 CEX3 CEX5/Push-pull Output)
    SFRPI = 0;
    P3M1 = 0x38;
    P33 = 0;
    P34 = 0;
    P35 = 0;
    
}

//-----------------------------------------------------------------------------
// configured PWM  
//-----------------------------------------------------------------------------
void PCA_Init ()
{
	CMOD = CPS2 | CPS1 | CPS0 | BME4 | BME2 | BME0;	//MCDKO be clock source
	CCON = 0x00;	                                //clear flag & disable PCA counter
    CH = CHRL = 0xFC; CL = CLRL = 0x00;             //Setting CH:CL & reload value
    //
    CCAPM0 = CCAPM2 = CCAPM4 = DTE0 | ECOM0 | PWM0; // enable PWM with dead time function
    CCAPM1 = CCAPM3 = CCAPM5 = DTE0 | ECOM0 | PWM0;
	PCAPWM0 = PCAPWM2 = PCAPWM4 = P0RS0 | ECAP1L;    // 10BIT resolution         
	PCAPWM1 = PCAPWM3 = PCAPWM5 = P0RS0 | ECAP1L;    
    
	CCAP0H = CCAP0L = 0xFF;             // UH = VH = WH (minimum)
	CCAP1H = CCAP1L = 0xFF;            
	CCAP2H = CCAP2L = 0xFF;             
	CCAP3H = CCAP3L = 0xFF;             
	CCAP4H = CCAP4L = 0xFF;             
	CCAP5H = CCAP5L = 0xFF;             
    //    
//5B32    PDTCR = 0x4C;                       // setting dead time zone ~3us (PLL to 24MHz)
	  SFRPI = 1;
    PDTCRA = 0x4C;  //6D17                      // setting dead time zone ~3us (PLL to 24MHz)
	  SFRPI = 0;	
    PWMCR = PCAE;// | EXDT;

}

//-----------------------------------------------------------------------------
// PLL - from 12M to 32MHz
//-----------------------------------------------------------------------------
void PLL24MHz (void)
{
    U8 dat;
    
    // PLL (from 12MHz)
    CKCON0 |= (ENCKM | CKMIS0);
    CKCON0 |= SCKS0;            // 48M / 2 = 24MHz
    //
    for (dat=0; dat<100; dat++);
    //
    ISPCR |= 0x80;
    IFADRH = 0x00;
    IFADRL = 0x40;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;
    //
    IFD &= ~0x0C;
    IFD |= 0x0C;
    IFMT = 0x04;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = 0x00;
}


//-----------------------------------------------------------------------------
// PLL - from 12M to 32MHz
//-----------------------------------------------------------------------------
void MotorRotate (void)
{
    U8 commutate_cnt;
    code U16 tb100usA [] = {340, 140, 30, 14, 14, 14, 14,  14, 14, 14, 14};
    code U16 tb100usB [] = {900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900};
    U8 tbIDX;
    U16 tbCNT;

    
    State = STARTUP;
        
    TH2 = RCAP2H = (65536 - C_Peroid) >> 8;
    TL2 = RCAP2L = (65536 - C_Peroid);
   
    // ------------------------------------------------------------------------
    // output in halt state
    SetupKeypadPattern ();
    SineWaveStartup ();
    
    MtrIndex ++;
    if (MtrIndex == 6) MtrIndex = 0;
    PWMOutput ();
    CR = 1;
    TR2 = 1;
        
    //
    SynchronizationFlag = 0;
    commutate_cnt = 0;
    tbIDX = tbCNT = 0;
    StuckCNT = 0;
    while (1) {
        if (Timer2_flag) {
            tbCNT ++;
            Timer2_flag = 0;
            if (tbCNT == tb100usA [tbIDX]) { 
                PWMOutput ();
                tbCNT = 0;
                tbIDX ++;
                if (tbIDX > 10) {
                    tbIDX = 1;
                    
                    if (++MtrIndex > 5) MtrIndex = 0;
                    SineWaveStartup ();
                    PWMOutput ();
                    tbCNT = 0;
                }
            }
        } 
        if (SynchronizationFlag) {
            break;
        }
        //---------------------------------------------------------------------
        if (StuckCNT > 240) {
           State = STARTFAIL;
           return;
        }
    }

    SetupKeypadPattern ();
    commutate_cnt = 0;
    tbIDX = 0;
    tbCNT = 0;
    while (commutate_cnt < C_Count)
    {
        //---------------------------------------------------------------------
        // Synchronization depend on Hall sensor pattern 
        if (SynchronizationFlag) {        
            SynchronizationFlag = 0;
            commutate_cnt ++;
            SineWaveStartup ();
            Timer2_flag = 1;
            StuckCNT = 0;
        }
        
        //---------------------------------------------------------------------
        // prepare duty data after it triggers T2ISR to replace 
        if (Timer2_flag) {
            tbCNT ++;
            Timer2_flag = 0;
            Startup_PWMOutput ();
            if (tbCNT == tb100usB [tbIDX]) { 
                tbCNT = 0;
                tbIDX ++;
                if (tbIDX > 13) tbIDX = 12;
            }
        } 
        
        //---------------------------------------------------------------------
        if (StuckCNT > 250) {
           State = STARTFAIL;
           return;
        }
    }    
    return;    
}

