

//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <intrins.h>



U8 StuckCNT = 0;
 
#define TrgXms      1   // 1ms 
 
//-----------------------------------------------------------------------------
// T1_Init - called from main
//-----------------------------------------------------------------------------
void Timer1_Init (void)
{
    TMOD = 0x11;
    TH1 = (65536 - (TrgXms * SYSCLK / TX_DIV / 1000)) >> 8;
    TL1 = (65536 - (TrgXms * SYSCLK / TX_DIV / 1000));
	TF1 = 0;
    ET1 = 1;
    TR1 = 1;
    
    IP0H |= PT1H;
    PT1L = 1;
}

//-----------------------------------------------------------------------------
// T1_ISR
//-----------------------------------------------------------------------------
void T1_ISR (void) interrupt 3
{
    TF1 = 0;
    
    StuckCNT ++;
    
    TH1 = (65536 - (TrgXms * SYSCLK / TX_DIV / 1000)) >> 8;
    TL1 = (65536 - (TrgXms * SYSCLK / TX_DIV / 1000));
    return;
}

