//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <math.h>


extern xdata U16 SineWavePWM_T1 [192];
extern xdata U16 SineWavePWM_T2 [192];

extern bit TableNO;             // the sine wave table NO, buffer switch flag
extern U8 MtrIndex;             // the current of Hall pattern
extern U8 State;

WTYPE NextUDuty;                // U duty cycle
WTYPE NextVDuty;                // V duty cycle
WTYPE NextWDuty;                // W duty cycle

bit TableU, TableV, TableW;     // the U,V,W table NO
U8 PUi,PVi, PWi;                // the index for sine wave table

//-----------------------------------------------------------------------------
// Startup's PWM ouput ()
//-----------------------------------------------------------------------------
void Startup_PWMOutput ()
{
    WTYPE DutyU, DutyV, DutyW;
    
    
    DutyU.W = SineWavePWM_T1 [PUi];
    DutyV.W = SineWavePWM_T1 [PVi];
    DutyW.W = SineWavePWM_T1 [PWi];
    
    if (DutyU.W != 1024)
        PUi ++;        
    if (DutyV.W != 1024)
        PVi ++;        
    if (DutyW.W != 1024)
        PWi ++;   

    if (PUi > 191) { PUi = 0;}
    if (PVi > 191) { PVi = 0;}
    if (PWi > 191) { PWi = 0;}
    
    ET2 = 0;
    NextUDuty.W = DutyU.W;
    NextVDuty.W = DutyV.W;
    NextWDuty.W = DutyW.W;
    ET2 = 1;
    
    return;
}

//-----------------------------------------------------------------------------
// PWM ouput ()
//-----------------------------------------------------------------------------
void PWMOutput ()
{
    WTYPE DutyU, DutyV, DutyW;
    
    
    // ------------------------------------------------------------------------
    if (!TableNO) {
        DutyU.W = SineWavePWM_T1 [PUi];
        DutyV.W = SineWavePWM_T1 [PVi];
        DutyW.W = SineWavePWM_T1 [PWi];
    } else {
        DutyU.W = SineWavePWM_T2 [PUi];
        DutyV.W = SineWavePWM_T2 [PVi];
        DutyW.W = SineWavePWM_T2 [PWi];
    }
    
    PUi ++;        
    PVi ++;        
    PWi ++;   

    if (PUi > 191) { PUi = 0;}
    if (PVi > 191) { PVi = 0;}
    if (PWi > 191) { PWi = 0;}
        
    ET2 = 0;
    NextUDuty.W = DutyU.W;
    NextVDuty.W = DutyV.W;
    NextWDuty.W = DutyW.W;
    ET2 = 1;
    
    return;
        
}

//-----------------------------------------------------------------------------
// sine-wave start up 
//-----------------------------------------------------------------------------
void SineWaveStartup (void)
{

    // forward direction 
    switch (MtrIndex) {             
    case 0:     // 0x50  
        PUi = 64 + IDXOffset;
        PVi = 128 + IDXOffset;
        PWi = 0 + IDXOffset;
        break;
    case 1:     // 0x10  
        PUi = 96 + IDXOffset;
        PVi = 160 + IDXOffset;
        PWi = 32 + IDXOffset;
        break;
    case 2:     // 0x30  
        PUi = 128 + IDXOffset;
        PVi = 0  + IDXOffset;
        PWi = 64  + IDXOffset;
        break;
    case 3:     // 0x20  
        PUi = 160  + IDXOffset;
        PVi = 32  + IDXOffset;
        PWi = 96  + IDXOffset;
        break;
    case 4:     // 0x60  
        PUi = 0  + IDXOffset;
        PVi = 64 + IDXOffset;
        PWi = 128  + IDXOffset;
        break;
    case 5:     // 0x40  
        PUi = 32  + IDXOffset;
        PVi = 96  + IDXOffset;
        PWi = 160  + IDXOffset;
        break;
    }
    NextUDuty.W = SineWavePWM_T1 [PUi];
    NextVDuty.W = SineWavePWM_T1 [PVi];
    NextWDuty.W = SineWavePWM_T1 [PWi];
    
    
}

//---------------------------------------------------------------------
// synchronization (SynchronizationFlag from KBISR.c) - 103.5.16
// U,V,W synchronization & switch table
//---------------------------------------------------------------------
void SynchronizationUVW () 
{
    switch (MtrIndex) {
    case 1:
        PVi = 160 + IDXOffset;
        break;
    case 3:
        PUi = 160 + IDXOffset;
        break;
    case 5:
        PWi = 160 + IDXOffset;
        break;
    default:
        break;
    }
}
