/**
 * @file    comp_multichannel_interrupt.c
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _COMP_MULTICHANNEL_INTERRUPT_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "comp_multichannel_interrupt.h"

/**
  * @addtogroup MG32F04P032_LibSamples
  * @{
  */

/**
  * @addtogroup COMP
  * @{
  */

/**
  * @addtogroup COMP_MultiChannel_Interrupt
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_Configure(void)
{
    COMP_InitTypeDef COMP_InitStruct;
    EXTI_InitTypeDef EXTI_InitStruct;
    GPIO_InitTypeDef GPIO_InitStruct;
    NVIC_InitTypeDef NVIC_InitStruct;

    COMP_POLL_InitTypeDef COMP_POLL_InitStruct;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_COMP, ENABLE);

    COMP_StructInit(&COMP_InitStruct);
    COMP_InitStruct.COMP_Invert     = COMP_InvertingInput_0;    /* INM_SEL */
    COMP_InitStruct.COMP_NonInvert  = COMP_NonInvertingInput_0; /* INP_SEL */
    COMP_InitStruct.COMP_Output     = COMP_Output_None;
    COMP_InitStruct.COMP_OutputPol  = COMP_Pol_NonInvertedOut;
    COMP_InitStruct.COMP_Hysteresis = COMP_Hysteresis_No;
    COMP_InitStruct.COMP_Mode       = COMP_Mode_LowPower;
    COMP_InitStruct.COMP_OFLT       = COMP_Filter_4_Period;
    COMP_Init(COMP1, &COMP_InitStruct);

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    /* COMP1 INM0 -> PA4 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_4;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* COMP1 INP1 -> PA5 & INP2 -> PA6 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_5 | GPIO_Pin_6;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    COMP_Cmd(COMP1, ENABLE);

    COMP_PollStructInit(&COMP_POLL_InitStruct);
    COMP_POLL_InitStruct.COMP_Poll_Ch     = COMP_POLL_1_2;
    COMP_POLL_InitStruct.COMP_Poll_Fixn   = COMP_POLL_INPUT_FIX;    /* INM_SEL = SET & INP_SEL = 1/2 */
    COMP_POLL_InitStruct.COMP_Poll_Period = COMP_POLL_WAIT_128;
    COMP_PollInit(COMP1, &COMP_POLL_InitStruct);

    COMP_PollCmd(COMP1, ENABLE);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_EXTI, ENABLE);

    EXTI_StructInit(&EXTI_InitStruct);
    EXTI_InitStruct.EXTI_Line    = EXTI_Line19;
    EXTI_InitStruct.EXTI_Mode    = EXTI_Mode_Interrupt;
    EXTI_InitStruct.EXTI_Trigger = EXTI_Trigger_Rising_Falling;
    EXTI_InitStruct.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStruct);

    NVIC_InitStruct.NVIC_IRQChannel = COMP1_2_IRQn;
    NVIC_InitStruct.NVIC_IRQChannelPriority = 0x01;
    NVIC_InitStruct.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStruct);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_MultiChannel_Interrupt_Sample(void)
{
    uint32_t Status = 0;

    printf("\r\nTest %s", __FUNCTION__);

    COMP_InterruptFlag = 0;

    COMP_Configure();

    printf("\r\nRemove R8");

    printf("\r\nAdjust the comparator channel(PA4(RV3) PA5 and PA6) voltage.");

    while (1)
    {
        if (0 != COMP_InterruptFlag)
        {
            COMP_InterruptFlag = 0;

            Status = READ_BIT(COMP1->COMPx_POLL, COMP_POLL_POUT_Msk);

            printf("\r\nCOMP1 POUT[0]: %d, POUT[1] : %d", (Status & (1 << 8)) ? 1 : 0, (Status & (1 << 9)) ? 1 : 0);
        }

        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

