/*********************************************************************
    Ŀ:TI2C
        :LZD
    Ŀ:
    
    		ʹTWSI (SCL/P22, SDA/P24)Ϊӻ
    		
    MCU ͺ:MA82G5Dxx
        :11.0592MHz
    ָ:1T

    ʱ:
    ޸־:



*********************************************************************/
#define _TI2C_C

#include <Intrins.h>
#include <Absacc.h>
#include "REG_MA82G5Dxx.H"
#include "Type.h"
#include "WDT.h"

#include "MAIN.h"

#define SLAVE_ADDRESS	0xA0

#define TWI0_SEL_P40P41	0x00
#define TWI0_SEL_P60P61	0x02
#define TWI0_SEL_P30P31	0x04
#define TWI0_SEL_P22P24	0x06

#define	TWI_OV_TIME_MAX			200

#define TIMER_1MS_TH	0xFC			// 1ms @11.0592MHz 12T
#define TIMER_1MS_TL	0x66

xdata BYTE TestBuf[16]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

BYTE BufAddr;

bit bAddrorData;	// 0: ADDR, 1:Data	
bit bES0;

u16	TWI0Ovtime;
u16 delayNmS;


// ʱ0ж,1ms
void INT_T0(void) interrupt 1
{
	TL0=TIMER_1MS_TL;
	TH0=TIMER_1MS_TH;
	
	if(delayNmS!=0) delayNmS--;
	if(TWI0Ovtime !=0) TWI0Ovtime--;

}


void SendByte(BYTE tByte)
{
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}



void SendStr(BYTE* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

void SendHex(BYTE ToSend)
{
	BYTE x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

void INT_TWSI() interrupt 12
{
	_push_(SFRPI);	// SFRPI ѹջ
	SFRPI=0;
	switch(SISTA)
	{
		case 0x60:	// յӻַ+W,  ACK
		case 0x68:	//
            SICON &= (~(STA | STO));
            SICON |= AA;
			break;
		
		case 0x80:	// յֽ,ACK
			BufAddr=SIDAT;
            SICON &= (~(STA | STO));
            SICON |= AA;
			break;
		
		case 0xA0:  // յSTOP ظSTART
            SICON &= (~(STA | STO));
            SICON |= AA;
			break;
		case 0xA8:  // յӻַ+R,  ACK
		case 0xB0:  // 
            //SICON &= (~(STA | STO | AA));
            SICON &= (~(STA | STO));
            SICON |= AA;
			SIDAT = BufAddr+1;
			break; 
		
		case 0xC8:	// ϸѾͣACK
		case 0xB8:  // SIDATѾ, ACK
            SICON &= (~(STA | STO));
            SICON |= AA;
			TWI0Ovtime = TWI_OV_TIME_MAX;		// IICʱʱ
			break; 
		case 0xC0:  // ϸѾͣNO ACK
            SICON &= (~(STA | STO));
            SICON |= AA;
			break;
		default:
            SICON &= (~(STA | STO));
            SICON |= AA;
			break;
	}
	P22=0;
	SICON = SICON &(~SI);		// жϱ־

	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();
	nop();

	P22=1;
	
	_pop_(SFRPI);				// ջ
}


/***********************************************************************************
:   void ReStartTWI0(void)
:   TWI0 
:   
ز:     
*************************************************************************************/
void ReStartTWI0(void)
{
	EIE1 = EIE1 & (~ETWI0);	// ֹI2Cж
	SICON = AA;		// SYSCLK = 24M, SYSCLK / 256 = 93.75k
	SIADR = SLAVE_ADDRESS;
	nop();
	nop();
	nop();
	SICON |= ENSI;			// TWIģ
	EIE1 = EIE1 | ETWI0;	// ʹI2Cж
}


//ϵͳʼ
void InitSystem()
{
	CKCON0=B10010000;		// ѡ11.0592MHz

	//T0:1: 16λʱ T1: 2: 8λԶضʱ
	TMOD = 0x21;
	//T0ʱ 1000us
	TH0=TIMER_1MS_TH;
	TL0=TIMER_1MS_TL;
	TR0=1; 		 //ʹܶʱ0

	//ڳʼ
	//SMOD = 0
	PCON0=PCON0&0x7F;
	//ģʽΪ1: 10λɱ䲨,ʹܽ
	S0CON=0x50;
	//ʱԴΪʱ1
	T2MOD1=T2MOD1&(~TL2IS);		 // ѡTCLK/RCLK
	TCLK_TL2IE=0;
	RCLK_TF2L=0;
	//ڲΪ115200
	AUXR2=AUXR2|BIT3;		 // T1Ϊ1T ģʽ
	TH1=0xFD;			 
	//ʹܶʱ1
	TR1=1;

	// ѡP22/P24TWI0
	AUXR3=(AUXR3&(~0x06))|TWI0_SEL_P22P24;
	//P2 ΪĿ©
	P2M0=0xFF;
	P2M1=0xFF;
	
	// ʹTWSI ,ʱ187.5KHz @12MHz
	SICON = SICON|(ENSI|AA); 
	SIADR = SLAVE_ADDRESS;

	EIE1 = EIE1 | ETWI0;	// ʹI2Cж
	ET0=1;

	EA = 1; 				// ʹȫж
	
}

void main()
{
    InitSystem();
	P35=0;
	DelayMs(1000);
	P35=1;

    while(1)
    {
		if(delayNmS==0)
		{
			delayNmS=100;
			P35=!P35;
		}
		
		//IICǷʱ
		if(TWI0Ovtime==0)
		{
			// ʱTWI0
			TWI0Ovtime = TWI_OV_TIME_MAX;
			ReStartTWI0();
		}
    }
}

//ʱ
void DelayMs(unsigned int DelayTime)
{
	delayNmS=DelayTime;
	while(delayNmS !=0)
	{
	
	}
}

