

#include "REG_MA82G5Dxx.H"
#include "delay.h"


#define		AFS						0x80
#define		SMOD1					0x80
#define		T1X12					0x08

#define		ADCEN					0x80
#define		ADCI					0x10
#define		ADCS					0x08
#define		CHS2					0x04
#define		CHS1					0x02
#define		CHS0					0x01

unsigned char Value_ADCH;

void Initial_ADC(void)
{
	ADCON0 = ADCEN;
	delay_50us();

}



void ADC_Start(void)
{
	ADCON0 |= 0x08;						//start AD conversion
	while(!(ADCON0 & 0x10));			//wait AD conversion finish
	ADCON0 &= 0xEF;						//Clear ADC interrupt flag
	
	Value_ADCH = ADCDH;
}

void Initlal_PCA5(void)
{

	CCAPM5 = 0x42;								//set 8bit PWM
	CCAP5H = 0x80;								//duty cycle = 50%
	PCAPWM5=0x00;
	CMOD = 0x02;								//CPS2 ~ CPS0 = 0, 0, 1. (sysclk) / 2
	CCON = 0x40;								//PCA run, 12MHz / 2 / 256 = 23.4KHz.
	P3M0 = P3M0&(~P3M05);						//CEX5(P35) push pull 
	P3M1 = P3M1|(P3M15);;
}


void main(void)
{


	Initlal_PCA5();
	Initial_ADC();


	while(1){
		ADC_Start();
		CCAP5H = ~Value_ADCH;
		delay_ms(1);
		
	}
}
